/*
 *  (c) Kevin Thacker, 2002
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */
#include "pulse.h"
#include <stdio.h>
#include <stdlib.h>

extern SampleDescription desc;

//char *raw;			// Address of the loaded .VOC file (converted to RAW)
//int rawlen;			// Length of the .VOC file in the memory
static int cur=0;					// Current position in the sample
//int last;					// Position of last Pulse in the sample

#define PULSE_BUFFER_SIZE 4096


/* samples converted to pulses */
/* pulses entered into a buffer */
/* allows look ahead at pulses */

unsigned long PulseBuffer_GetCurrentPosition(PULSE_BUFFER *pBuffer)
{
	return pBuffer->PulseBuffer[pBuffer->ReadPosition-1].SampleOffset;
}

void	PulseBuffer_ReturnPulse(PULSE_BUFFER *pBuffer)
{
	pBuffer->ReadPosition--;
}


unsigned char GetSample(void)
{
	unsigned char datab;
	
	datab = desc.handler.pReadSample(&desc);
	cur++;

	return datab;

#if 0
	unsigned char datab;

	if (sample_eof)
		return 0x080;

	datab = raw[cur];
	cur++;

	if (cur==rawlen)
		sample_eof = 1;

	return datab;
#endif

}

int		SampleEOF(void)
{
	return desc.handler.pIsEOF(&desc);
}


static int GetPulse(void)
{
// Finds next Pulse and returns its length
#define PT 127		// Treshold value ...

unsigned long count = 0;
unsigned char sampleData;

sampleData = GetSample();

//#ifdef UNIX
/* redefined this way, because "limited scope of data meant condition was
always true */
if (sampleData&0x080)	
{
	while ((sampleData&0x080) && (!SampleEOF())) 
	{
		sampleData = GetSample();

		count++;
	}
}
else		
{
	while (((sampleData&0x080)==0) && (!SampleEOF()))
	{
		sampleData = GetSample();

		count++;
	}
}

return count;
}

static unsigned long PushedPosition;

int PulseBuffer_EOF(PULSE_BUFFER *pBuffer)
{
	return pBuffer->EndOfBuffer;
}


unsigned long 	PulseBuffer_GetPulse(PULSE_BUFFER *pBuffer)
{
	unsigned long Pulse;

	if (pBuffer->ReadPosition==pBuffer->Head)
	{
		/* end of sample file? */
		if (SampleEOF())
		{
			/* set eof for pulse buffer */
			pBuffer->EndOfBuffer = 1;

			/* return 0 length pulse */
			return 0;
		}
	
		/* fetch a new pulse */
		PulseBuffer_AddPulse(pBuffer, GetPulse(),cur);
		Pulse = pBuffer->PulseBuffer[pBuffer->ReadPosition].PulseLength;
		pBuffer->ReadPosition++;
		pBuffer->ReadPosition = pBuffer->ReadPosition % pBuffer->PulseBufferLength;
		return Pulse;
	}

	/* return existing pulse */
	Pulse = pBuffer->PulseBuffer[pBuffer->ReadPosition].PulseLength;
	pBuffer->ReadPosition++;
	pBuffer->ReadPosition = pBuffer->ReadPosition % pBuffer->PulseBufferLength;

	return Pulse;
}

void	PulseBuffer_Init(PULSE_BUFFER *pBuffer, unsigned long PulseBufferLength)
{
	pBuffer->PulseBuffer = malloc(sizeof(PULSE_DATA)*PulseBufferLength);
	pBuffer->PulseBufferLength = PulseBufferLength;
	pBuffer->ReadPosition = 0;
	pBuffer->Head = 0;
	pBuffer->Tail = 0;
	pBuffer->EndOfBuffer = 0;
}

void	PulseBuffer_Free(PULSE_BUFFER *pBuffer)
{
	if (pBuffer->PulseBuffer)
	{
		free(pBuffer->PulseBuffer);
		pBuffer->PulseBuffer = 0;
	}
}

/* pulse history is a circular buffer */
void	PulseBuffer_AddPulse(PULSE_BUFFER *pBuffer, unsigned long PulseDuration, unsigned long SampleOffset)
{
	pBuffer->PulseBuffer[pBuffer->Head].PulseLength = PulseDuration;
	pBuffer->PulseBuffer[pBuffer->Head].SampleOffset = SampleOffset;
	pBuffer->Head++;
	pBuffer->Head = pBuffer->Head % pBuffer->PulseBufferLength;
	if (pBuffer->Head==pBuffer->Tail)
	{
		pBuffer->Tail++;
		pBuffer->Tail = pBuffer->Tail % pBuffer->PulseBufferLength;
	}

}

void	PulseBuffer_PushPosition(PULSE_BUFFER *pBuffer)
{
	PushedPosition = pBuffer->ReadPosition;
}

void	PulseBuffer_PopPosition(PULSE_BUFFER *pBuffer)
{
	pBuffer->ReadPosition = PushedPosition;
}

