/*
 *  (c) Kevin Thacker, 2002
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */
#ifndef __PULSE_BUFFER_HEADER_INCLUDED__
#define __PULSE_BUFFER_HEADER_INCLUDED__

#include "sample.h"

//extern char *raw;			// Address of the loaded .VOC file (converted to RAW)
//extern int rawlen;			// Length of the .VOC file in the memory

typedef struct PULSE_DATA
{
	unsigned long SampleOffset;
	unsigned long PulseLength;
} PULSE_DATA;

typedef struct PULSE_BUFFER
{
	int EndOfBuffer;
	unsigned long PulseBufferLength;
	PULSE_DATA *PulseBuffer;
	unsigned long ReadPosition;
	unsigned long Head;
	unsigned long Tail;
} PULSE_BUFFER;

int PulseBuffer_EOF(PULSE_BUFFER *pBuffer);
unsigned long PulseBuffer_GetCurrentPosition(PULSE_BUFFER *);
void PulseBuffer_ReturnPulse(PULSE_BUFFER *pBuffer);
/* initialise the buffer */
void	PulseBuffer_Init(PULSE_BUFFER *pBuffer, unsigned long);
/* free the buffer */
void	PulseBuffer_Free(PULSE_BUFFER *);
/* read a pulse from the current read position */
unsigned long 	PulseBuffer_GetPulse(PULSE_BUFFER *pBuffer);
/* add a pulse to the head of the list */
void	PulseBuffer_AddPulse(PULSE_BUFFER *pBuffer, unsigned long PulseDuration, unsigned long SampleOffset);


void	PulseBuffer_PushPosition(PULSE_BUFFER *pBuffer);

void	PulseBuffer_PopPosition(PULSE_BUFFER *pBuffer);

int SampleEOF(void);
//int GetPulse(void);
unsigned char GetSample(void);

#endif