/*
 *  (c) Kevin Thacker, 2002
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */
#ifndef __SAMPLE_INFO_HEADER_INCLUDED__
#define __SAMPLE_INFO_HEADER_INCLUDED__

#include <stdio.h>
#include <stdlib.h>

enum
{
	SAMPLE_FORMAT_8MU = 0,	/* 8 bit mono unsigned */
	SAMPLE_FORMAT_8MS,	/* 8 bit mono signed */
	SAMPLE_FORMAT_8SU,	/* 8 bit stereo unsigned */
	SAMPLE_FORMAT_8SS,	/* 8 bit stereo signed */
	SAMPLE_FORMAT_16MU_LE,	/* 16-bit mono unsigned, little endian */
	SAMPLE_FORMAT_16SU_LE,	/* 16-bit stereo unsigned, little endian */
	SAMPLE_FORMAT_16MS_LE,	/* 16-bit mono signed, little endian */
	SAMPLE_FORMAT_16SS_LE,	/* 16-bit stereo signed, little endian */
	SAMPLE_FORMAT_16MU_BE,	/* 16-bit mono unsigned, big endian */
	SAMPLE_FORMAT_16SU_BE,	/* 16-bit stereo unsigned, big endian*/
	SAMPLE_FORMAT_16MS_BE,	/* 16-bit mono signed, big endian */
	SAMPLE_FORMAT_16SS_BE,	/* 16-bit stereo signed, big endian */
};


enum
{
	/* sample file accepted by this handler */
	SAMPLE_FILE_OK = 0,
	/* out of memory! */
	SAMPLE_FILE_OUT_OF_MEMORY,
	/* error */
	SAMPLE_FILE_ERROR,
	/* the sample file is not of this format */
	SAMPLE_FILE_NOT_RECOGNISED,
	/* this version of the sample file is not supported */
	SAMPLE_FILE_VERSION_UNSUPPORTED,
	/* the sample format is not supported */
	SAMPLE_FILE_DATA_FORMAT_UNSUPPORTED,
	/* sample file is empty */
	SAMPLE_FILE_NO_DATA,
};

#define SAMPLE_VOL_MAX 0x07f
#define SAMPLE_VOL_MIN 0x080

/* duration */
typedef struct 
{
	unsigned long Hours;
	unsigned long Minutes;
	unsigned long Seconds;
	unsigned long FractionalSeconds;
} Duration;

struct SampleDescription;

typedef struct
{
	/* description of format */
	const char *Description;
	/* attempt to open the file */
	int (*pOpen)(const char *pFilename, struct SampleDescription *);
	/* close the file */
	void (*pClose)(struct SampleDescription *);
	/* read the sample */
	unsigned char (*pReadSample)(struct SampleDescription *);
	/* is end of file? */
	unsigned long (*pIsEOF)(struct SampleDescription *);
} SampleHandler;

typedef struct 
{
	unsigned long Format;

	/* rate in HZ */
	unsigned long Rate;
	/* length in samples */
	unsigned long LengthInSamples;
	/* length in minutes */
	Duration	duration;

	SampleHandler handler;
} SampleDescription;

void	SampleDescription_InitDuration(SampleDescription *);
//void ConvertData(FILE *fh, unsigned char *pBufferPtr, unsigned long NumSamples, unsigned long Format);
unsigned char ConvertData(unsigned char *pBufferPtr, unsigned long FormatType);
int GetBytesPerSample(SampleDescription *);

int SampleFile_Open(const char *, SampleDescription *);
void SampleFile_Close(SampleDescription *);

#endif