/*
 *  (c) Kevin Thacker, 2002
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */
#ifndef __VOC_HEADER_INCLUDED__
#define __VOC_HEADER_INCLUDED__

#include "sample.h"


extern SampleHandler VOC_SampleHandler;

/* Voc file format:

Header					0x01a bytes	"Creative Voice File\0x01a"
Offset to first block	2 bytes		

  Block Header:

  1 byte		Block ID
  3 byte		Block Size (not including size of this block header)

  Blocks:

  type 2:

  data

  type 9:

  4 bytes		sample frequency
  1 byte		bits per sample
  1 byte		no of channels
  short			Format
  4 bytes		Reserved
  
format: 1,2,0x0200,0x003, adpcm
0004: signed
0006: alaw
0007: mulaw

  type 3:

  silence

  type 4: 

  marker

  type 5:

  ascii length of string, null terminated string


 
      TYPE   Description     Size (3-byte int)   Info
      ----   -----------     -----------------   -----------------------
      00     Terminator      (NONE)              (NONE)
      01     Sound data      2+length of data    *
      02     Sound continue  length of data      Voice Data
      03     Silence         3                   **
      04     Marker          2                   Marker# (2 bytes)
      05     ASCII           length of string    null terminated string
      06     Repeat          2                   Count# (2 bytes)
      07     End repeat      0                   (NONE)
      08     Extended        4                   ***

      *Sound Info Format:       **Silence Info Format:
       ---------------------      ----------------------------
       00   Sample Rate           00-01  Length of silence - 1
       01   Compression Type      02     Sample Rate
       02+  Voice Data

    ***Extended Info Format:
       ---------------------
       00-01  Time Constant: Mono: 65536 - (256000000/sample_rate)
                             Stereo: 65536 - (25600000/(2*sample_rate))
       02     Pack
       03     Mode: 0 = mono
                    1 = stereo



*/

#define VOC_MAIN_HEADER_IDENT "Creative Voice File\x1a"

typedef struct VOC_MAIN_HEADER
{
	/* identification text */
	unsigned char	IdentText[0x014];
	/* offset to first block */
	unsigned char	FirstBlockOffsetLow;
	unsigned char	FirstBlockOffsetHigh;
	/* unencoded version */
	unsigned char	UnencodedVersionMinor;
	unsigned char	UnencodedVersionMajor;
	/* encodeded version */
	unsigned char	EncodedVersionMinor;
	unsigned char	EncodedVersionMajor;
} VOC_MAIN_HEADER;

typedef struct VOC_BLOCK_HEADER
{
	/* id of block */
	unsigned char	ID;
	/* length of block */
	unsigned char	LengthLow;
	unsigned char	LengthMid;
	unsigned char	LengthHigh;
} VOC_BLOCK_HEADER;

typedef struct VOC_BLOCK9
{
	/* sample frequency in Hz */
	unsigned char	SampleFrequency[4];
	/* bits per sample */
	unsigned char	BitsPerSample;
	/* no of channels */
	unsigned char	NoOfChannels;
	unsigned char	Format[2];
	/* ?? */
	unsigned char	pad1[4];
} VOC_BLOCK9;

typedef struct VOC_BLOCK8
{
	unsigned char	TimeConstant[2];
	unsigned char	Pack;
	unsigned char	Mode;
} VOC_BLOCK8;

typedef struct VOC_BLOCK1
{
	unsigned char	SampleRate;
	unsigned char	CompressionType;
} VOC_BLOCK1;

typedef struct VOC_BLOCK3
{
	unsigned char SilenceLength[2];
	unsigned char SampleRate;
} VOC_BLOCK3;

typedef struct VOC_BLOCK4
{
	unsigned char Marker[2];
} VOC_BLOCK4;

typedef struct VOC_BLOCK6
{
	unsigned char RepeatCount[2];
} VOC_BLOCK6;


int	VOC_Open(const char *pFilename, SampleDescription *desc);
void VOC_Close(SampleDescription *);
unsigned char VOC_ReadSample(SampleDescription *);
unsigned long VOC_IsEOF(SampleDescription *desc);

#endif