/*
 *  (c) Kevin Thacker, 2002
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */
#ifndef __WAV_HEADER_INCLUDED__
#define __WAV_HEADER_INCLUDED__

#include "chunk.h"
#include "sample.h"


extern SampleHandler WAV_SampleHandler;


#ifdef _WINDOWS
#pragma pack(1)
#endif

#define CHUNK_ID_RIFF	CHUNK_ID('R','I','F','F')
#define CHUNK_ID_RIFX	CHUNK_ID('R','I','F','X')
#define CHUNK_ID_fmt	CHUNK_ID('f','m','t',' ')
#define CHUNK_ID_data	CHUNK_ID('d','a','t','a')

typedef struct WAV_WAVEFORMAT
{  
    unsigned short  FormatTag; 
    unsigned short NoOfChannels;
    unsigned long SamplesPerSecond;
	unsigned long AverageBytesPerSecond;
	unsigned short BlockAlign;
	unsigned short BitsPerSample;
} WAV_WAVEFORMAT; 

typedef struct WAV_WAVEFORMATEX
{
  unsigned short  FormatTag; 
    unsigned short NoOfChannels;
    unsigned long SamplesPerSecond;
	unsigned long AverageBytesPerSecond;
	unsigned short BlockAlign;
	unsigned short BitsPerSample;
	unsigned short SizeOfExtraFormatInfo;
} WAV_WAVEFORMATEX;

#ifdef _WINDOWS
#pragma pack()
#endif

#define WAV_WAVE_FORMAT_PCM	1

int WAV_Open(const char *pFilename, SampleDescription *desc);
void WAV_Close(SampleDescription *);
unsigned char WAV_ReadSample(SampleDescription *);
unsigned long WAV_IsEOF(SampleDescription *desc);

#endif