///////////////////////////////////////////////////////////////////////////////
// VOC/CSW/WAV/IFF/AIFF to CDT converter
//                                                                   18082002
// (c) 1997 Tomaz Kac and Martijn van der Heide
// (c) 2002 by Kevin Thacker
//
// Watcom C 10.0+ specific code...
//
// Change fiele commands for other compilers
// Also endian depandable (Intel compatible), possible fix:
// Search for ENDIAN word to find out where it should be changed (probably
// forgot some of the places though :( ) Most of the time the WORD (2 byte)
// values are being written to disk ... so you should first swap them and
// then write them ...

/* standard CPC loader:
- 0 bit can be 1/1.25 times 1 bit max or 1/2.3 times 1 bit min
- first sync pulse can be large (1 bit/1.3), 2nd can be very small

*/



#include <stdio.h>

#include "../common/sample.h"

//#define USE_MEM
#define VOC2TZX6	0
//#define TEST_BLEEPV3

#include "../common/pulse.h"

SampleDescription desc;

//static int sf_detect = 1;
//static int sf_type = SAMPLE_FILE_UNKNOWN;

enum
{
	/* normal operation; user defines action */
	ACTION_DEFAULT = 0,
	/* attempt auto-detection of some speedlock types */
	ACTION_SLDETECT
};

enum
{
	/* unknown */
	LDR_UNKNOWN = 0,
	/* appleby */
	LDR_APPLEBY,
	/* unknown e.g. shadow dancer */
	LDR_USGOLD,
	/* speedlock data */
	LDR_SLOCKDATA,
	LDR_SLOCKDATA2,
	LDR_SLOCKDATA3,
	LDR_SPEEDLOCKV0,
	/* speedlock v1 */
	LDR_SPEEDLOCKV1,
	/* speedlock v2 */
	LDR_SPEEDLOCKV2,
	/* speedlock v3 */
	LDR_SPEEDLOCKV3,
	/* speedlock v4 */
	LDR_SPEEDLOCKV4,
	/* spectrum rom type */
	LDR_SPECROM,
	/* bleep */
	LDR_BLEEPV1,
	/* bleep */
	LDR_BLEEPV2,
#ifdef TEST_BLEEPV3
	/* bleep */
	LDR_BLEEPV3,
#endif
	/* codemasters used by grell and falla etc */
	LDR_CODEMASTERS,
	/* ricochet red and yellow border */
	LDR_RICOCHET,
	/* musical */
	LDR_FIREMUS,
	/* standard */
	LDR_STANDARD,
	/* cassys */
	LDR_CASSYS,
	/* micro-key */
	LDR_MICROKEY,
	LDR_SPECVAR2,
	LDR_SPECVAR3,
	LDR_SPECVAR4,
};



#ifdef WIN32
#include <stdlib.h>
#include <io.h>
#include <string.h>
#endif

#ifdef UNIX
#include <string.h>
#include <stdlib.h>
#include <unistd.h>
#endif

#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>



//char *raw;			// Address of the loaded sample file (converted to RAW)
//int rawlen;			// Length of the sample file in the memory
PULSE_BUFFER pulseBuffer;

int sample_frequency;			// Sample Rate
char temp[65536*2];	// converted data
char tstr[14];
char tzxbuf[10]={ 'Z','X','T','a','p','e','!', 0x1A, 1, 12 };
int ofh;			// Output File Handle

int write_initial_pause = 1;
int display_initial_pause = 1;

enum
{
	WRITE_BLOCK_NONE,
	WRITE_BLOCK_PURE_DATA,
	WRITE_BLOCK_TURBO_LOADING,
	WRITE_BLOCK_TONE,
	WRITE_BLOCK_PULSES
};

int write_block_type = WRITE_BLOCK_NONE;
int write_group_end = 0;
int previous_write_block_type = WRITE_BLOCK_NONE;

// skip n blocks before forcing decoding using defined loader?
int ldrskip = -1;
// loader type to force after skipping blocks
int ldrtype = -1;
// current loader type
int ldrcur = LDR_UNKNOWN;
// number of blocks to process; and then switch to another loader type
int ldrend = -1;

int slblock = -1;

int actioncur = ACTION_DEFAULT;

// decoding slock blocks active?
//int slockactive = 0;
//int slockend = -1;
int slockmain = -1;

#if 0
// hewson
bit 0: 979
bit 1: 1958
pilot: 2340
len: 4096
	 sync 0: 1260
	 sync 1: 1260
#endif
/*-------------------------------------------------------------*/
/* loader used by dan dare 2 (ricochet) release */
int RICOCHET_SYNC1 = 693;
int RICOCHET_SYNC2 = 924;
/* approx 8000 */
int RICOCHET_HP_PILOT=2295;
int RICOCHET_BIT0 = 924;
int RICOCHET_BIT1 = 1848;
/*-------------------------------------------------------------*/
/* loader used by pubtrivia */
int CODEMASTERS_SYNC1 = 1103;
int CODEMASTERS_SYNC2 = 630;
/* approx 3000 */
int CODEMASTERS_HP_PILOT = 2276;
int CODEMASTERS_BIT0 = 575;
int CODEMASTERS_BIT1 = 1150;

/*-------------------------------------------------------------*/
int FIREMUS_SYNC1 = 945;
int FIREMUS_SYNC2 = 630;
int FIREMUS_BIT0 = 860;
int FIREMUS_BIT1 = 1720;	
// approx 1700, with approx 1076 pulses
int FIREMUS_HP_PILOT = 1720;
/*-------------------------------------------------------------*/
#ifdef TEST_BLEEPV3
int BLEEPV3_BIT0 = 800;	//1134;
int BLEEPV3_BIT1 = 1600;	//2268;
#endif
/*-------------------------------------------------------------*/
// about 780 pilot pulses
int BLEEPV1_HP_PILOT = 1600;
int BLEEPV1_SYNC1 = 945;
int BLEEPV1_SYNC2 = 630;
int BLEEPV1_BIT0 = 800;
int BLEEPV1_BIT1 = 1600;
/*-------------------------------------------------------------*/

/* speedlock data timings */
int SLOCKDATA_SYNC1 = 945;
int SLOCKDATA_SYNC2 = 630;
int SLOCKDATA_BIT0 = 580;
int SLOCKDATA_BIT1 = 1161;
/* 2200-2300 */
/* check */
/* approx 3000 of them */
int	SLOCKDATA_HP_PILOT = 2200;

/*-------------------------------------------------------------*/
int SLOCKDATA2_HP_PILOT = 2300;
int SLOCKDATA2_SYNC1 = 788;
int SLOCKDATA2_SYNC2 = 788;
int SLOCKDATA2_BIT0 = 760;
int SLOCKDATA2_BIT1 = 1520;
/*-------------------------------------------------------------*/
int SLOCKDATA3_HP_PILOT = 2300;
int SLOCKDATA3_SYNC1 = 788;
int SLOCKDATA3_SYNC2 = 788;
int SLOCKDATA3_BIT0 = 760;
int SLOCKDATA3_BIT1 = 1520;

/*-------------------------------------------------------------*/
/* appleby timings */
int APPLEBY_SYNC1 = 945;		// 1111, 794
int APPLEBY_SYNC2 = 630;		// 635, 794
int APPLEBY_BIT0 = 620;	//599;	//585;	//595;	//600;	//585;			// 599, 620
int APPLEBY_BIT1 = 1240;	//1257;	//1170;	//1190;	//1200;	//1170;		// 1257, 1200
int APPLEBY_HP_PILOT = 2257; // 2266-2287
int APPLEBY_MIN_PILOT = 100; // 2939 sometimes


/*-------------------------------------------------------------*/
//565, 1128
// Standard Timings for USGOLD (e.g. SHADOW DANCER)
int USG_HP_PILOT=	2304;	// Half-Period of Pilot pulse (2900 pulses)
int USG_SYNC1=	1001;	//                First Sync
int USG_SYNC2=	539;	//                Second Sync
int USG_BIT0=	639;	//                Bit 0
int USG_BIT1=	1278;	//       
/*-------------------------------------------------------------*/
// Standard Timings for Spectrum ROM loading routines
int SPECROM_HP_PILOT=	2168;	// Half-Period of Pilot pulse
int SPECROM_SYNC1=	667;	//                First Sync
int SPECROM_SYNC2=	735;	//                Second Sync
int SPECROM_BIT0=	855;	//                Bit 0
int SPECROM_BIT1=	1710;	//                Bit 1
int SPECROM_PILOT_HEAD= 8064;	// Length of Pilot when Header Block (ID==00, Len:19)
int SPECROM_PILOT_DATA= 3220;	// Length of Pilot when Data Block   (ID!=00)

/*-------------------------------------------------------------*/

int SPECVAR2_HP_PILOT = 2220;
int SPECVAR2_SYNC1=667;
int SPECVAR2_SYNC2=735;
int SPECVAR2_BIT0 = 848;
int SPECVAR2_BIT1 = 1695;


int	SPECVAR3_HP_PILOT = 2272;	// 2222
int SPECVAR3_SYNC1 = 667;	//1587;		// 1270
int SPECVAR3_SYNC2 = 735;	//;		// 476
int SPECVAR3_BIT0 = 580;		// 572
int SPECVAR3_BIT1 = 1160;		// 1146 

int SPECVAR4_HP_PILOT = 2026;
int SPECVAR4_SYNC1 = 667;	//1111;		// 1429,635
int SPECVAR4_SYNC2 = 735;	//476;
int SPECVAR4_BIT0 = 783;	// 797
int SPECVAR4_BIT1 = 1565;	//1592,//1588,1565

// gryzor levels
// 2192 pilot
//1429,635 sync
//1986,992 bitr 1,0


/*-------------------------------------------------------------*/
// 8000 pilot pulses
int DUX_HP_PILOT = 2075;	// 2061-2085
int DUX_SYNC1 = 945;
int DUX_SYNC2 = 630;	// 473
int DUX_BIT0 = 800;		// 810-825
int DUX_Bit1 = 1600;	// 1618-1639
/*-------------------------------------------------------------*/

// spectrum
int STD_TRES=	10;		// Treshold in % for a value to be recognised as
						// Standard

/*-------------------------------------------------------------*/

int TRES_FULL=	35;		// [35] Max Treshold in % between two HPs
int TRES_01=	40;		// [30] Min Treshold in % between 0 and 1 bit HP
int TRES_END=  	60;		// [60] Min Treshold in % between two HPs to end the Load
int MIN_PILOT=	50;		// [50] Min Number of PILOT HPs

//int tape=0;				// Are we making .TAP file ?
//int rom=0;				// Should we use the ROM values for 0 and 1 timing ?
int ignore=0;			// Ignore Last Byte if it contains less than 8 bits ?
int aprox=1;			// Are we approximating Bit 1 HP == 2* Bit 0 HP ?
//int force=0;			// Force Custom Loader Length to forcep ?
int forcep;
//int ffsync=0;			// Force SYNC of Custom blocks to Standard SYNC ?
int alter=0;			// Alternative way to recognise 0 and 1 bit (with averaging them)
int difend=0;			// Use alternative way to find END-OF-BLOCK ... with TRES_END as Treshold
						// Value
int middle=0;			// Use Middle value to determine 0 and 1 bit
//int slock=0;			// Use Speedlock conversion Algorythm (0=NO, 1,2,3,4 - YES)
//int diload=0;			// Use Digital Integration Algorythm

int plen=0;					// Current Pulse length
int lplen;					// Length of Last Pulse
int pilot,num0,num1;		// Number of Pilot, 0 and 1 bit HP's
double total,total0,total1;	// Total length of Pilot, 0 and 1 tones
//double cycle;				// How much Z80 cycles is one Sample (byte)
double t_states_per_sample;	// Number of T-States per sample
double samples_per_t_state;	// number of samples per t-state
int block=0;				// Number of the block to recognise
int start;					// Start of the block in the sample
int endb;					// End of the last block in the sample
int sync1,sync2;			// Length of both SYNC in T States
int hp0,hp1,hpt;			// Length of 0 and 1 bit HP's (first occurances)
int hp01;					// Middle value of bit 0 and 1
//int datastart;				// Start of DATA in the sample
int apilot,ahp0,ahp1;		// Average Length of Pilot, 0 and 1 bit HP's in T
int posbyte,posbit;			// Position in : Byte in block, Bit in Byte
int currbit;				// Value of the Current Bit of Data read
float pausev;				// Value of the pause (in seconds)
char buf2[256];				// Buffer for file writes
int custom=' ';				// Are we saving a Custom Loading block ?
int lst_pilot;				// Previous Pilot length
int dif;
int PilotOK;				// Was the Pilot tone recognised OK ?
int NoData;					// Was there any data in the data block ?
//int naslnorm=0;				// For bleepload algorythm...

char *finp; // Input File  
char *fout; // Output File 
char errstr[256]; // Error String
int n=0;

unsigned short slock12sync[14]=	{
								3150,3150,
								1130,1130,1130,1130,1130,1130,565,565,1130,1130,565,565
								};	// 2 SYNC pulses + 6 bits of data (111010) of Speedlock 2
									// for Speedlock 1 these 6 bits of data MUST be read from the tape
unsigned short slock34sync[28]=	{
								667,735,
								714,714,1428,1428,2144,2144,2144,2144,2144,2144,1428,1428,714,714,
								0,0,0,0,0,0,0,0,0,0,0,0
								};	// 2 Standard SYNC, 14 Composed SYNC pulses and 6 bits of Data for Type 2,3
unsigned short slockmidsync[21*2];	// SYNC between two Sub-blocks in second turbo block of 2,3

int subblocknum=1;	// Number of Sub-Blocks in Speedlock 2 and 3 second turbo block
int totallen;		// Total length of Speedlock 2 and 3 second turbo block
char totalcheck;	// Checksum of all sub-blocks ... THIS ONE ISN'T RIGHT !
//int slockvar=0;		// Speedlock Variation for Speedlock 3 : 1 - Red/Black  Decryption Stripes
//					//										 2 - Multicolor Decryption Stripes
//int slockskip=0xFFFF; 	// How many blocks to skip before encounter first Turbo block
int ClickLen;		// Length of Click in Pulses
int ClickPulses[10];	// Pulses of the Click
int PilotPulse;		// Pulse of the Pilot signal
int NumPilotParts;	// Number of Pilot Parts in Speedlock 1,2 pilot
int PilotParts[50];	// Table of Pilot Parts Length
//int slock1flag=0;	// Are we reading 6 bits of the Speedlock 1 flag byte ?

#if 0
int dipilot;		// Digital Integration PRE-PILOT length in pulses
double ditotal;		// Total length of DI Pre-Pilot
int adipilot;		// Average pilot length of di pre-pilot
#endif

int bleepv3pilot;
int bleepv3sync1;
int bleepv3bits;

unsigned char GetSyncByte(int ldr);

char *GetChecksum(int ldr,int len);
char *DoIdentify(int ldr, int len);

/* convert samples to T-States */
int		ToTStates(int Samples)
{
	return (int)(Samples/samples_per_t_state + 0.5);
}

int PauseToMilliseconds(double pause)
{
	return (int) ((pause+0.0005)*1000.0);
}


// write little-endian short out to file
// use in writing tzx file
static void write_short(int fh, short data)
{
	unsigned char local_byte[2];

	local_byte[0] = data & 0x0ff;
	local_byte[1] = (data>>8) & 0x0ff;
	write(fh, local_byte,2);
}

// write little-endian long out to file
// use in writing tzx file
static void write_long(int fh, long data)
{
	unsigned char local_byte[4];

	local_byte[0] = data & 0x0ff;
	local_byte[1] = (data>>8) & 0x0ff;
	local_byte[2] = (data>>16) & 0x0ff;
	local_byte[3] = (data>>24) & 0x0ff;
	write(fh, local_byte,4);
}


// read little-endian long from file
static unsigned long read_long(int fh, unsigned long *pData)
{
	unsigned char data[4];
	unsigned long count;
	unsigned long local_long;

	count = read(fh, data, 4);

	if (count<4)
		return count;

	local_long =  (
			(data[0] & 0x0ff) |
			((data[1] & 0x0ff)<<8) |
			((data[2] & 0x0ff)<<16) |
			((data[3] & 0x0ff)<<24)
			);

	*pData = local_long;

	return 4;
}

void Error(char *errstr)
{
// exits with an error message *errstr

printf("\n-- Error: %s\n",errstr);
}

/****************************************************************************/

/* get length of extension in chars */
int GetExtensionLength(char *str)
{
	int n;
	int stringLength;

	if (str==NULL)
		return 0;

	stringLength = strlen(str);
	n = stringLength-1;

	/* look for '.' character which signifies start of extension */
	while ((n!=0) && (str[n]!='.'))
		n--;

	/* '.' found? */
	if (n==0)
	{
		/* no */
		return 0;
	}

	/* yes */
	
	/* report length of extension */
	return stringLength-n-1;
}

/****************************************************************************/
/* replace the extension of a filename */
void ChangeFileExtension(char *str,char *ext)
{
	int extensionLength;

	if (str==NULL)
		return;

	if (ext==NULL)
		return;

	/* get length of extension */
	extensionLength = GetExtensionLength(str);
	
	/* has an extension of at least one character in length? */
	if (extensionLength==0)
		return;

	/* terminate string at extension marker */
	str[strlen(str)-extensionLength] = '\0';

	/* append new extension */
	strcat(str,ext);
}

/****************************************************************************/

#define diff_abs(x) (x<0 ? -x : x)

int Diff(int a,int b)
{
int max;
int diff;

if (a==b)
	return 0;

// get max
max = a;

if (b>max)
	max = b;

if (max==0)
	return 0;

// calc absolute difference
diff = b-a;
diff = diff_abs(diff);

return (diff*100)/max;
#if 0
// Returns the Difference (in %) between a and b (a+(a*(d/100))=b) d=diff
/*int d;*/
float aa,bb;

if (!a && !b) return(0);
if (a>b) { aa=(float) a; bb=(float) b;}
else     { aa=(float) b; bb=(float) a;}
return(abs((int) (0.5+(100.0*((bb-aa)/aa)))));
#endif
}


int Diff2(float a,float b)
{
float max;
float diff;

if (a==b)
	return 0;

// get max
max = a;

if (b>max)
	max = b;

if (max==0)
	return 0;

// calc absolute difference
diff = b-a;
diff = diff_abs(diff);

return (diff*100)/max;
#if 0
// Returns the Difference (in %) between a and b (a+(a*(d/100))=b) d=diff
/*int d;*/
float aa,bb;

if (!a && !b) return(0);
if (a>b) { aa=(float) a; bb=(float) b;}
else     { aa=(float) b; bb=(float) a;}
return(abs((int) (0.5+(100.0*((bb-aa)/aa)))));
#endif
}


char *CassysCheckSum(int len)
{




	return ("? ");
}

/********************************************************************/

char *SpanishChecksum(int len)
{
	unsigned char c=0;	
	int n = 0;

	if ((posbit!=8) && (!ignore))
	{
		len--;
	}

	while (n<len) 
	{ 
		c^=temp[n]; 
		n++; 
	}

	if (c!=0)
	{
		return ("X ");
	}
		
	return ("O ");
}


char *SpeedlockV1CheckSum(int len)
{
	unsigned char c=0;	
	int n = 0;

	if ((posbit!=8) && (!ignore))
	{
		len--;
	}

	while (n<len) 
	{ 
		c^=temp[n]; 
		n++; 
	}

	if (c!=0)
	{
		return ("X ");
	}
		
	return ("O ");
}
/********************************************************************/

/*
char *SpeedlockCheckSum(int len)
{
// Calculates CheckSum for the data in temp[], length len
unsigned char c=0;	

int n=0;

while (n<len) { c^=temp[n]; n++; }

if (c!=0)
{
	return ("X ");
}
	
return ("O ");
}
*/

/********************************************************************/

int	GetBits(int bitoffset, int count)
{
	int databyte = 0;
	int i;
	int byteoffs = (bitoffset>>3);
	int bitinbyte = (bitoffset & 0x07);

	// bitinbyte: 0 for bit 7, 1 for bit 6 etc

	for (i=0; i<count; i++)
	{
		int data;

		data = temp[byteoffs]&0x0ff;
		data = (data>>(7-bitinbyte))&0x01;
		databyte=databyte<<1;
		databyte=databyte|data;

		bitinbyte++;
		if (bitinbyte==8)
		{
			bitinbyte = 0;
			byteoffs++;
		}
	}

	return databyte;
}


void	ShiftBits(unsigned char *pPtr, unsigned long len, int nbits)
{
	unsigned char *pSrc;
	unsigned char mask1,mask2;
	unsigned char data1,data2,data;
	int i;

	pSrc = pPtr + len-1;

	mask1 = (0x0ff>>nbits);
	mask2 = mask1^0x0ff;

	for (i=0; i<len; i++)
	{
		/* get current byte */
		data1 = pSrc[0];
		pSrc--;
		/* get byte before */
		data2 = pSrc[0];
		pSrc++;
		
		/* shift bits in current byte to new position */
		data = data1>>nbits;
		/* mask off valid bits; ensuring invalid bits are 0 */
		data = data&mask1;
		/* get previous byte, mask off bits we are interested in, shift into 
		position and combine with current data */
		data |= (data2<<(8-nbits))&mask2;
		/* write back */
		pSrc[0] = data;
		pSrc--;
	}
}

/********************************************************************/

char *BleepV1Checksum(int len)
{
	unsigned char c=0;	
	int n=0;

	/* ignore first byte which is sync */
	while (n<(len-2)) 
	{ 
		unsigned char datab;

		datab = temp[n+1];

		c^=datab;
		
		n++; 
	}

	if (c!=(temp[len-1]&0x0ff))
	{
		return ("X ");
	}
	
	return ("O ");
}

int BleepV3Check(int len)
{
	unsigned char c=0;	
	int n=0;

	/* ignore first byte which is sync */
	while (n<(len-pilot-3)) 
	{ 
		unsigned char datab;

		datab = temp[n+pilot+3];

		c^=datab;
		
		n++; 
	}

	return (c==(temp[len-1]&0x0ff));
}

char *BleepV3Checksum(int len)
{
	if (BleepV3Check(len))
	{
		return ("O ");
	}
	
	if (bleepv3bits!=0)
	{
		ShiftBits(temp, len, (8-bleepv3bits));

		if (BleepV3Check(len))
		{
			return ("O ");
		}
	}

	return ("X ");
}


char *FirebirdMusicChecksum(int len)
{
	unsigned char c=0;	
	int n=0;
	int bitoffset;
	int lengthInBytes;
	int musicdata = 0;
//	int Byte0, Byte1;
	int databytecount = 0;
	unsigned char datab;
	int blockcount = 0;

	musicdata = 0;
//	Byte0 = GetBits(3+8+3,8);
//	Byte1 = GetBits(3+8+3+8+3, 8);
//
//	if (Byte0!=Byte1)
//	{
//		return ("X ");
//	}

	/* skip sync byte */
	bitoffset = 3+8;

	/* get high byte of load address; included in checksum */
	bitoffset+=3;
	datab = GetBits(bitoffset,8);
	bitoffset+=8;
	c^=datab;

	/* get checksum so far */
	bitoffset+=3;
	datab = GetBits(bitoffset,8);
	bitoffset+=8;

	if (c!=datab)
	{
		return ("X ");
	}


	/* calc length of data */
//	lengthInBytes = ((posbyte<<3)+posbit)/12;

	/* ignore first byte which is sync */
	while (bitoffset<((posbyte<<3)+posbit))
	{ 
		unsigned char code;

		code = GetBits(bitoffset,3);
		bitoffset+=3;
		datab = GetBits(bitoffset,8);
		bitoffset+=8;

		if (musicdata)
		{
			if (datab==0x0ff)
			{
				/* stop processing music data */
				musicdata = 0;
			}

			/* processing music data */
		}
		else
		{
			/* code!=0 -> music data; not included in checksum */
			/* code==0 -> databyte; included in checksum */
			if ((code&0x03)==0)
			{
				c^=datab;

				databytecount++;

				if (databytecount==256)
				{
					blockcount++;
					databytecount = 0;

					/* execution address */
					bitoffset+=3;
					datab = GetBits(bitoffset,8);
					bitoffset+=8;
					c^=datab;

					bitoffset+=3;
					datab = GetBits(bitoffset,8);
					bitoffset+=8;
					c^=datab;

					bitoffset+=3;
					datab = GetBits(bitoffset,8);
					bitoffset+=8;

					if (c!=datab)
					{
						return ("X ");
					}
				}

			}
			else
			{
				/* begin processing music data */
				musicdata=1;

				if (datab==0x0ff)
				{
					/* stop processing music data */
					musicdata = 0;
				}
			}
		
		}
		n++; 
	}

//	if (((c^GetBits(bitoffset,8))&0x0ff)!=0)
//	{
//		return ("X ");
//	}

	if ((blockcount!=0) && (databytecount==0))
		return ("O ");

	return ("X ");
}


/********************************************************************/

char *BleepV2Checksum(int len)
{
	unsigned char c=0;	
	int n=0;
	int bitoffset;
	int lengthInBytes;

	bitoffset = 9+1;

	lengthInBytes = ((posbyte<<3)+posbit)/9;

	/* ignore first byte which is sync */
	while (n<(lengthInBytes-2)) 
	{ 
		unsigned char datab;

		datab = GetBits(bitoffset, 8);

		c^=datab;
		
		bitoffset+=9;

		n++; 
	}

	if (((c^GetBits(bitoffset,8))&0x0ff)!=0)
	{
		return ("X ");
	}
	
	return ("O ");
}

/********************************************************************/

char *USG_CheckSum(int len, int init, int add1, int add2)
{
	char c;
	char check;
	char check_adj;
	int i;
	int n=0;

	if ((posbit!=8) && (!ignore))
	{
		len--;
	}

	c = 0;
	while (n<len) 
	{ 
		c+=temp[n]; 
		n++; 
	}


	// sync1 = encoded_sync1 ^ 2 ^ key
	// sync2 = encoded_sync2 ^ 1 ^ (key+add)
	// sync1 = sync2
	// enc_sync1 = encoded_sync1^2
	// enc_sync2 = encoded_sync2^1

	// sync1 = enc_sync1 ^ key
	// sync1 = enc_sync2 ^ (key+add)

	// enc_sync1 = sync1^key
	// enc_sync2 = sync1^(key+add)
	
	// enc_sync1 = enc_sync2 ^ (key+add) ^ key
	// key ^ (key+add) = enc_sync1 ^ enc_sync2

	// key = enc_sync1^enc_sync2^(key+add)

	// calculate adjustment for checksum
	check_adj = init;
	// for each sync
	check_adj += add1;
	check_adj += add1;
	// data
	for (i=0; i<len-3; i++)
	{
		char d,e;
		unsigned short len2;

		len2 = (len-3)-i;
		d = (len2>>8) & 0x0ff;
		e = len2 & 0x0ff;
		if ((e & (1<<4))!=0)
		{
			// 97
			check_adj+=add2;
			check_adj+=e;
			check_adj-=d;
		}

		// d1
		check_adj+=add1;
	}

	check = temp[len-1];
	check^=1;
	check^=check_adj;
	check &=0x0ff;

	if (((temp[len-1] + check) & 0x0ff)==(c & 0x0ff))
	{
		return("O ");
	}

	return("X ");
}

char *SpectrumCheckSum(int len)
{
	char c=0;
	int n=0;

	if ((posbit!=8) && (!ignore))
	{
		len--;
	}

	while (n<len-1) 
	{ 
		c^=temp[n]; 
		n++; 
	}
	if (c==temp[len-1]) 
		return("O "); 
	else 
		return ("X ");
}

char *CheckSum2(int len)
{
// Calculates CheckSum for the data in temp[], length len
char c=0;
int n=0;

while (n<len-1) { c+=temp[n+1]; n++; }
if (c==temp[0]) return("O "); else return("X ");
}

/* checksum for rastan levels */
char *SpeedlockDataCheckSum(int len)
{
	char c=0;
	int n=0;

	while (n<(len-1)) 
	{ 
		c+=(temp[n] & 0x0ff); 
		n++; 
	}
	if (c==(temp[len-1] & 0x0ff)) 
	{
		return("O "); 
	}

	return("X ");
}

/* checksum for rastan levels */
char *SpeedlockDataCheckSum2(int len)
{
	char c=0;
	int n=0;

	while (n<(len-1)) 
	{ 
		c+=(temp[n+1] & 0x0ff); 
		n++; 
	}
	if (c==(temp[0] & 0x0ff)) 
	{
		return("O "); 
	}

	return("X ");
}



char *Identify(int len)		
{
	int n;

	/* header sync byte for Amstrad standard loader */
	if (temp[0]==0x02c)
	{
		memset(tstr, ' ', 12);
		tstr[12] = 0;
		/* show first 12 characters.. */
		for (n=0; n<12; n++)
		{
			if (temp[n+1])	
			{
				tstr[n]=temp[n+1];
			}
			else			
				break;
		}
	}
	else strcpy(tstr,"------------");
	return(tstr);
}

/********************************************************************/



void SavePureData(char *data, int len)
{
	int PauseInMilliseconds = PauseToMilliseconds(pausev);

	// This will save the Pure data of Speedlock (or other) tapes... also with the Speedlock SYNC
	buf2[0]=0x14;
	buf2[1]=(char) (ahp0&0xff); buf2[2]=(char) (ahp0>>8);
	buf2[3]=(char) (ahp1&0xff); buf2[4]=(char) (ahp1>>8);
	buf2[5]=(char) posbit;
	buf2[6]=(char) (PauseInMilliseconds&0xff);
	buf2[7]=(char) ((PauseInMilliseconds>>8)&0x0ff);
	buf2[8]=(char) (len&0xff); buf2[9]=(char) ((len>>8)&0xff);
	buf2[10]=(char) ((len>>8)>>8);
	write(ofh,buf2,11);
	write(ofh,data,len);
}

/********************************************************************/
void	SaveSpeedlockMidSync(void)
{
	buf2[0]=0x13;
	buf2[1]=21*2;		// 21 'waves' or 42 pulses

	for (n=0; n<21; n++)
	{	// the mid-block SYNC is   000001111111111100000
		if (n<5 || n>15)	slockmidsync[(n*2)]=slockmidsync[1+(n*2)]=875;
		else				slockmidsync[(n*2)]=slockmidsync[1+(n*2)]=1750;
	}
	write(ofh,buf2,2);	// Write the mid-block SYNC
	for (n=0; n<21*2; n++)
	{
		write_short(ofh,slockmidsync[n]);
	}
}

/********************************************************************/

void SaveGroupEnd(void)
{
	buf2[0]=0x22;
	write(ofh,buf2,1);
}

/********************************************************************/
void SaveGroupStart(const char *pGroupText)
{
	int group_desc_length = strlen(pGroupText);

	// Save the GROUP Name
	buf2[0]=0x21;
	buf2[1]=group_desc_length;
	write(ofh,buf2, 2);
	if (group_desc_length!=0)
		write(ofh,pGroupText,group_desc_length);
}
/********************************************************************/
void SaveTurboLoadingDataBlock(void)
{
	int PauseInMilliseconds = PauseToMilliseconds(pausev);

	buf2[0]=0x11;
	buf2[1]=(char) (apilot&0xff); buf2[2]=(char) (apilot>>8);
//	if (ffsync) { sync1=HP_SYNC1; sync2=HP_SYNC2; }	// Force SYNC values
	buf2[3]=(char) (sync1&0xff); buf2[4]=(char) (sync1>>8);
	buf2[5]=(char) (sync2&0xff); buf2[6]=(char) (sync2>>8);
	buf2[7]=(char) (ahp0&0xff); buf2[8]=(char) (ahp0>>8);
	buf2[9]=(char) (ahp1&0xff); buf2[10]=(char) (ahp1>>8);
//	if (force) lst_pilot=forcep;					// Force PILOT Length
	buf2[11]=(char) (lst_pilot&0xff); buf2[12]=(char) (lst_pilot>>8);
	buf2[13]=(char) posbit;
	buf2[14]=(char) (PauseInMilliseconds&0x0ff);
	buf2[15]=(char) ((PauseInMilliseconds>>8)&0x0ff);
	buf2[16]=(char) (posbyte&0xff); buf2[17]=(char) ((posbyte>>8)&0xff);
	buf2[18]=(char) ((posbyte>>8)>>8);
	write(ofh,buf2,19); 
	if (posbyte!=0)
	{
		write(ofh,temp,posbyte);
	}
}
/********************************************************************/
void SaveStandardSpeedDataBlock(void)
{
	int PauseInMilliseconds = PauseToMilliseconds(pausev);

	buf2[0]=0x10;
	buf2[1]=(char) (PauseInMilliseconds&0x0ff);
	buf2[2]=(char) ((PauseInMilliseconds>>8)&0x0ff);
	buf2[3]=(char) (posbyte&0xff); buf2[4]=(char) (posbyte>>8);
	write(ofh,buf2,5); 
	if (posbyte!=0)
	{
		write(ofh,temp,posbyte);
	}
}
/********************************************************************/
void SavePureTone(int PulseLen, int NumPulses)
{
	buf2[0]=0x12;
	buf2[1]=(char)(PulseLen&0x0ff);
	buf2[2]=(char)((PulseLen>>8) & 0x0ff);
	buf2[3]=(char)(NumPulses&0x0ff);
	buf2[4]=(char)((NumPulses>>8) & 0x0ff);
	write(ofh,buf2,5);

}

/********************************************************************/
void SaveDataAsPulses(char *data, int lenbytes, int lenbits)
{
	int NumPulses;
	int PulseCount;
	int BitOffset = 0;


	buf2[0]=0x13;
	buf2[1]=1;
	buf2[2]=0;
	buf2[3]=4;
	write(ofh,buf2,4);

	PulseCount = (lenbytes*8)+lenbits;

	do
	{
		int i;

		buf2[0]=0x13;
			
		if (PulseCount>255)
			NumPulses=255;
		else
			NumPulses = PulseCount;

		PulseCount-=NumPulses;

		buf2[1]=(char)(NumPulses&0x0ff);
		write(ofh,buf2,2);

		for (i=0; i<NumPulses; i++)
		{
			int PulseLen;
			char datab;

			datab = data[(BitOffset>>3)]&(1<<(7-(BitOffset&0x07)));

			if (datab!=0)
			{
				PulseLen = ahp1;
			}
			else
			{
				PulseLen = ahp0;
			}

			buf2[0] = (char)(PulseLen&0x0ff);
			buf2[1] = (char)((PulseLen>>8)&0x0ff);

			write(ofh,buf2,2);
	
			BitOffset++;
		}
	}
	while (PulseCount!=0);
}

/********************************************************************/
void SavePulses(int NumPulses, short *PulseBuffer)
{
	buf2[0]=0x13;
	buf2[1]=NumPulses;
	write(ofh,buf2,2); 
	for (n=0; n<NumPulses; n++)
	{
		write_short(ofh, PulseBuffer[n]);
	}
}
/********************************************************************/

int DetectStandardLoading(int hp0, int hp1, int hppilot, int numpilot)
{
	// First check if this is a Standard Loading block
	if ((Diff(hp0,SPECROM_BIT0)<=STD_TRES) && (Diff(hp1,SPECROM_BIT1)<=STD_TRES) &&
		(Diff(hppilot,SPECROM_HP_PILOT)<=STD_TRES) && (posbyte<65536) &&
		((temp[0] && (Diff(numpilot,SPECROM_PILOT_DATA)<=STD_TRES)) ||
		(!temp[0] && (Diff(numpilot,SPECROM_PILOT_HEAD)<=STD_TRES))))
	{
		return 1;
	}

	return 0;
}

/********************************************************************/

void	WritePause(double pause)
{
	int PauseInMilliseconds = PauseToMilliseconds(pause);

	/* output pause */
	buf2[0]=0x20;
	buf2[1]=(char) (PauseInMilliseconds&0x0ff);
	buf2[2]=(char) ((PauseInMilliseconds>>8)&0x0ff);
	write(ofh,buf2,3);
}
/********************************************************************/

void	WriteInitialPause()
{
	/* write the pause? */
	if (write_initial_pause)
	{
		double pause;

		write_initial_pause = 0;

		pause=(float) start/(float) sample_frequency;
		if (pause<0.0) pause=0.0;

//		printf("writing pause %1.3f\r\n",pause);

		WritePause(pause);
	}
}

void	WritePossiblePause()
{
	/* a block which doesn't have a pause parameter as part of it's definition? */
	if ((previous_write_block_type==WRITE_BLOCK_TONE) || (previous_write_block_type==WRITE_BLOCK_PULSES))
	{
		double pause;

		pause=((float) start-(float) endb)/(float) sample_frequency;
		if (pause<0.0) pause=0.0;

//		printf("writing pause %1.3f\r\n",pause);

		WritePause(pause);
	}
}


/********************************************************************/
void DisplayInitialPause(void)
{
	if (display_initial_pause)
	{
		double initialPause;

		display_initial_pause = 0;


		/* calculate and display initial pause */
		initialPause=(float) start/(float) sample_frequency;
		if (initialPause<0.0) initialPause=0.0;

		printf("initial P-%1.3f\n",initialPause);
	}
}
/********************************************************************/


void SaveTZXBlock(void)
{
	switch (write_block_type)
	{
		case WRITE_BLOCK_NONE:
			break;
		case WRITE_BLOCK_PURE_DATA:
		{
			SavePureData(temp, posbyte);
		}
		break;
		case WRITE_BLOCK_PULSES:
		{
			SaveDataAsPulses(temp, posbyte,posbit);
		}
		break;

		case WRITE_BLOCK_TONE:
		{
			SavePureTone(apilot, lst_pilot);
		}
		break;


		case WRITE_BLOCK_TURBO_LOADING:
		{
			if (ldrcur==LDR_SPECROM)
			{
				if (DetectStandardLoading(ahp0, ahp1, apilot, 
					lst_pilot))
				{
					SaveStandardSpeedDataBlock();
				}
				else
				{
					SaveTurboLoadingDataBlock();
				}
			}
			else
			{
				SaveTurboLoadingDataBlock();
			}
		}
		break;
	}

	if (write_group_end)
	{
		SaveGroupEnd();
	}

	write_group_end = 0;
	previous_write_block_type = write_block_type;
	write_block_type = WRITE_BLOCK_NONE;
}

//343 686, 1029 343

/*-----------------------------------------------------------------------*/
void GetStandardPilot2(void)
{
	float fraction;

	// Find PILOT signal (first find two pulses that are almost identical)
	do	
	{
		
		lplen=plen; 
//		plen=GetPulse();
		plen=PulseBuffer_GetPulse(&pulseBuffer);


	} while ((Diff(plen,lplen)>TRES_FULL) && (!PulseBuffer_EOF(&pulseBuffer)));

	start=PulseBuffer_GetCurrentPosition(&pulseBuffer)-(plen+lplen);	// Start of the block - so the Pause can be calculated

	{
//		float seconds_per_sample = 1.0f/(float)sample_frequency;
//		printf("start %3.3f\r\n",start*seconds_per_sample);
	}

	
	pilot=0;
	total=0.0; 

	plen=(int) (((float)plen+(float)lplen+0.5)/2.0);

	if (plen==0)
	{
		PilotOK = 0;
		return;
	}
	
	// OK, found the possible PILOT ... try and load it ...
	do	
	{	
//		lplen=GetPulse();
		lplen=PulseBuffer_GetPulse(&pulseBuffer);

		if (lplen!=0)
		{
			pilot++; 
			total+=(double) lplen;

			fraction = (float)ToTStates(plen)/(float)ToTStates(lplen);

			if ((lplen<plen) && (fraction>=1.25) && (fraction<=2.3))
				break;

			if ((lplen>plen) && (fraction<0.5))
				break;

			if ((lplen<plen) && (fraction>1.5))
				break;
		}
	} 
	while (/*(Diff(plen,lplen)<=TRES_FULL) &&*/ (!PulseBuffer_EOF(&pulseBuffer)));
	
	pilot--; 
	total-=(double) plen;
	//if (lplen>plen) pilot=0;
	if (pilot>=MIN_PILOT)	
	{
//		float seconds_per_sample = 1.0f/(float)sample_frequency;
//		printf("pilot end %3.3f\r\n",(cur-lplen)*seconds_per_sample);


		// YES, found PILOT ... lets try the SYNC & DATA
		PilotOK=1;	
	}
	else					
	{
		PilotOK=0;
	}
}

/*-----------------------------------------------------------------------*/
/* get a pilot which has a fixed pulse length */
void GetFixedPilot(int PilotPulseLenT, int PilotMinLen)
{
	int PilotPulseLen = (int) ((double) PilotPulseLenT*samples_per_t_state);	

	start=PulseBuffer_GetCurrentPosition(&pulseBuffer);	// Start of the block - so the Pause can be calculated
	pilot=0;
	total=0.0; 

	do	
	{	
//		lplen=GetPulse();
		lplen=PulseBuffer_GetPulse(&pulseBuffer);
		pilot++; 
		total+=(double) lplen;
	} 
	while((Diff(PilotPulseLen,lplen)<=TRES_FULL) && (!PulseBuffer_EOF(&pulseBuffer)));

	pilot--; 
	total-=(double) lplen;

	if (pilot>=PilotMinLen)	
	{
		PilotOK=1;	
	}
	else					
	{
		PilotOK=0;
	}
}

/*-----------------------------------------------------------------------*/
/* calculate pilot */

void GetStandardPilot(void)
{
	// Find PILOT signal (first find two pulses that are almost identical)
	do	
	{
		
		lplen=plen; 
//		plen=GetPulse();
		plen=PulseBuffer_GetPulse(&pulseBuffer);
	} while ((Diff(plen,lplen)>TRES_FULL) && (!PulseBuffer_EOF(&pulseBuffer)));

	
	start=PulseBuffer_GetCurrentPosition(&pulseBuffer)-(plen+lplen);	// Start of the block - so the Pause can be calculated

	{
//		float seconds_per_sample = 1.0f/(float)sample_frequency;
//		printf("start %3.3f\r\n",start*seconds_per_sample);
	}

	
	pilot=0;
	total=0.0; 

	plen=(int) (((float)plen+(float)lplen+0.5)/2.0);

	// OK, found the possible PILOT ... try and load it ...
	do	
	{	
//		lplen=GetPulse();
		lplen=PulseBuffer_GetPulse(&pulseBuffer);
		pilot++; 
		total+=(double) lplen;
	} 
	while((Diff(plen,lplen)<=TRES_FULL) && (!PulseBuffer_EOF(&pulseBuffer)));
	
	pilot--; 
	total-=(double) plen;
	//if (lplen>plen) pilot=0;
	if (pilot>=MIN_PILOT)	
	{
//		float seconds_per_sample = 1.0f/(float)sample_frequency;
//		printf("pilot end %3.3f\r\n",(cur-lplen)*seconds_per_sample);


		// YES, found PILOT ... lets try the SYNC & DATA
		PilotOK=1;	
	}
	else					
	{
		PilotOK=0;
	}
}


#ifdef TEST_BLEEPV3

/* attempt to get a byte */
unsigned char BleepV3GetByte(unsigned char *pPtr)
{
//	int hp0,hp1;
	int i;
	int databyte = 0;

	hp0=10;
	hp1=20;
//	hp01 = ((hp1-hp0)/2)+hp0;
	hp01 = 15;	//((hp1-hp0)/2)+hp0;

//	hp0=(int) ((double) BLEEPV3_BIT0*samples_per_t_state);	
//	hp1=(int) ((double) BLEEPV3_BIT1*samples_per_t_state);

	for (i=0; i<8; i++)
	{
		int db;

		/* end of file? */
		if (PulseBuffer_EOF(&pulseBuffer))
			break;

		/* bleepv3 uses a single pulse to identify a 0 or 1 data bit
		for pilot and data */

		/* get pulse */
		plen=PulseBuffer_GetPulse(&pulseBuffer);

		/* large pulse; e.g. silence */
		if (plen>(1.5*hp1))
		{
			break;
		}

//		if (plen<(hp0*0.5))
//			break;

		/* decide if 0 or 1 bit */
		if (plen<=hp01)
		{
			db = 0;
		}
		else
		{
			db = 1;
		}

		/* combine into byte */
		databyte=databyte<<1;
		databyte=databyte|db;
	}

	*pPtr = databyte;

	/* number of bits successfully transfered */
	return i;
}

#define BLEEPV3_PILOT_BYTE 0x0f

void	GetBleepV3Sync(void)
{
	unsigned char bleepv3sync2;
	int nbits;
	int i;
	
	memset(temp,0,16384);

	posbyte=posbit=num0=num1=temp[0]=0; total0=total1=0.0;

	for (i=0; i<pilot; i++)
	{
		temp[posbyte] = bleepv3pilot;
		posbyte++;
	}

	temp[posbyte] = bleepv3sync1;
	posbyte++;

	nbits = BleepV3GetByte(&bleepv3sync2);
	temp[posbyte] = bleepv3sync2;
	posbyte++;
}

void	GetBleepV3Data(void)
{
	char *checksum;
	unsigned char datab;
	int nbits;
	unsigned char SyncString[6];
	int NoData=1;


	bleepv3bits = 0;

	do
	{
		unsigned char datab;

		nbits = BleepV3GetByte(&datab);

		if (nbits==8)
		{
			temp[posbyte] = datab;
			posbyte++;
			NoData = 0;
		}
		else
		{
			/* bleepv3bits will hold the number of bits that are assumed to be valid in the last byte */
			/* if the checksum fails, shift the data and recheck */
			bleepv3bits = nbits;
		}

	}
	while (nbits==8);

	if (NoData)
		return;

	NoData = 0;

	ahp0=(int) ((double)hp0/samples_per_t_state);
	ahp1=(int) ((double)hp1/samples_per_t_state);

	endb=PulseBuffer_GetCurrentPosition(&pulseBuffer);

	sprintf(SyncString,"F-%02x",GetSyncByte(ldrcur) & 0x0ff);

	checksum = GetChecksum(ldrcur, posbyte);


	printf(
	"*%s 0-%04d 1-%04d %s B%d L-%5d C%s",
	DoIdentify(ldrcur,posbyte), ahp0,ahp1,SyncString,posbit,posbyte, checksum);

	write_block_type = WRITE_BLOCK_PULSES;
	block++;

}

void	GetBleepV3Pilot(void)
{
	int nbits;
	unsigned char pilotbytea,pilotbyteb;

	pilot = 0;
	PilotOK = 0;

//	plen=PulseBuffer_GetPulse(&pulseBuffer);

	//	get first byte:

	do
	{

		nbits = BleepV3GetByte(&pilotbytea);
	}
	while ((!PulseBuffer_EOF(&pulseBuffer)) && (nbits!=8));

//	if (pilotbytea!=0x0f)
//		return;

	start=PulseBuffer_GetCurrentPosition(&pulseBuffer);	// Start of the block - so the Pause can be calculated
	bleepv3pilot = pilotbytea;

	do
	{
		// get byte
		nbits = BleepV3GetByte(&pilotbyteb);
	
		if (nbits==8)
		{
			if (pilotbytea==pilotbyteb)
			{
				pilot++;
			}
		}
	}
	while ((!PulseBuffer_EOF(&pulseBuffer)) && (pilotbytea==pilotbyteb) && (nbits==8));

	pilot--;

	if (nbits==8)
	{
		if (pilot>4)
		{
			bleepv3sync1 = pilotbyteb;
			PilotOK = 1;
		}
	}
}

#if 0
void	GetBleepV3Pilot(void)
{
	unsigned char pilotb;
	int nbits;

	do
	{
		unsigned char pilota,pilotb;

		pilot = 0;
		PilotOK = 0;

//		wait for change:
//		plen=PulseBuffer_GetPulse(&pulseBuffer);	
//
//		get first byte:
//		pilota = BleepV3GetByte();
//		get second byte:
//		pilotb = BleepV3GetByte();
//
//		if (pilota==pilotb)
//		{
//
//
//
//		}

		do
		{
			start=PulseBuffer_GetCurrentPosition(&pulseBuffer);	// Start of the block - so the Pause can be calculated

			nbits = BleepV3GetByte(&pilotb);
			
			if (nbits==8) 
			{
				if (pilotb==BLEEPV3_PILOT_BYTE)
					break;

				plen=PulseBuffer_GetPulse(&pulseBuffer);
			}			
		}
		while ((!PulseBuffer_EOF(&pulseBuffer)));

		do
		{
			nbits = BleepV3GetByte(&pilotb);

			// same as pilot byte?
			if (pilotb==BLEEPV3_PILOT_BYTE)
			{
				// increment pilot count
				pilot++;
			}
			else
			{
				// inverse of pilot byte (first sync byte)
				if (pilotb==(BLEEPV3_PILOT_BYTE^0x0ff))
				{
					if (pilot>4)
					{

						PilotOK = 1;


					}
				}
				else
				{
					break;
				}

			}
		}
		while (!PilotOK);

	}
	while (!PilotOK);
}
#endif
#endif

#if 0
void GetDIPilot(void)
{
// Find PILOT signal (first find two pulses that are almost identical)
do	{
	lplen=plen; 
//		plen=GetPulse();
		plen=PulseBuffer_GetPulse(&pulseBuffer);
	} while (Diff(plen,lplen)>TRES_FULL && cur<rawlen);
start=cur-(plen+lplen);	// Start of the block - so the Pause can be calculated
dipilot=2;
ditotal=(double) (plen+lplen);
plen=(int) (((float)plen+(float)lplen+0.5)/2.0);
do	{	// OK, found the possible PRE-PILOT signal... try and load it ...
//		lplen=GetPulse();
		lplen=PulseBuffer_GetPulse(&pulseBuffer);
	dipilot++; ditotal+=(double) lplen;
	} while(Diff(plen,lplen)<=TRES_FULL && cur<rawlen);
dipilot--; ditotal-=(double) lplen;
pilot=1;
/*total=(double) lplen; */
//		plen=GetPulse();
		plen=PulseBuffer_GetPulse(&pulseBuffer);
plen=(int) (((float)plen+(float)lplen+0.5)/2.0);
do	{	// After the PRE-PILOT the normal PILOT begins ...
//		lplen=GetPulse();
		lplen=PulseBuffer_GetPulse(&pulseBuffer);
	pilot++; /*total+=(double) lplen;*/
	} while(Diff(plen,lplen)<=TRES_FULL && cur<rawlen);
//pilot--; total-=(double) lplen;
if (pilot>=MIN_PILOT)	PilotOK=1;	// YES, found PILOT ... lets try the SYNC & DATA
else					PilotOK=0;
}
#endif

//version 1 (eidolon, bmx freestyle): 1e, 22, 24, 26
//version 1b (tarzan): 18, 1e, 1c, 20
//version 5 (hudson hawk): 1e, 2a, 28, 22
//3dstunt: 12, 1a, 16, 18

void GetClickingPilot(void)
{
double totalpulses;
int numpulses;
int avgpilot;
double totalclickpulses[10];
int currclick;

ClickLen=2;	// it seems it is always 2 anyway :)

// Find PILOT signal (first find two pulses that are almost identical)
do	{
	lplen=plen; 
//		plen=GetPulse();
		plen=PulseBuffer_GetPulse(&pulseBuffer);
	} while (Diff(plen,lplen)>TRES_FULL && (!PulseBuffer_EOF(&pulseBuffer)));
pilot=numpulses=2;	// We found atleast two pulses already
totalpulses=(double) (plen+lplen);
start=PulseBuffer_GetCurrentPosition(&pulseBuffer)-(plen+lplen);	// Start of the block - so the Pause can be calculated
NumPilotParts=0;
for (n=0; n<10; n++) totalclickpulses[n]=0.0;
currclick=0;

	readnextpilot:

avgpilot=(int) (0.5+(totalpulses/(double) numpulses));
do	{	// OK, found the possible PILOT ... try and load it ...
	plen=lplen;
//		lplen=GetPulse();
		lplen=PulseBuffer_GetPulse(&pulseBuffer);
	if (lplen>avgpilot*1.3) goto endofpilot; // 1.3 , Sometimes 1.2 or 1.4 better
	if (lplen<avgpilot*0.8) goto endofpart;	 // 0.8 , Sometimes 0.6 or 0.7 better
	totalpulses+=(double) lplen; numpulses++;
	avgpilot=(int) (0.5+(totalpulses/(double) numpulses));
	pilot++;
	} while(!PulseBuffer_EOF(&pulseBuffer));
PilotOK=0; return;
endofpart:						// Found a CLICK ...
if (pilot<180 || pilot>250) { PilotOK=0; return; }
PilotParts[NumPilotParts]=pilot;
NumPilotParts++;
totalclickpulses[currclick]+=(double) lplen;
currclick++;
do	{
//		lplen=GetPulse();
		lplen=PulseBuffer_GetPulse(&pulseBuffer);
	if (currclick==ClickLen) goto endofclick;	// Read enough clicks ?
	totalclickpulses[currclick]+=(double) lplen;
	currclick++;
	} while(!PulseBuffer_EOF(&pulseBuffer));
PilotOK=0; return;

	endofclick:

currclick=0;
pilot=1;
totalpulses+=(double) lplen; numpulses++;
goto readnextpilot;

	endofpilot:				    	// Found the SYNC

if (PilotParts[NumPilotParts-4]<pilot)	// Go back a pulse if we read one too
	{ pilot--; 
#if 0
	cur-=lplen; 
#endif
}			// many (strange thing, since FIRST pulse is)
PilotParts[NumPilotParts]=pilot;		// Always very short compared to the 2nd one
NumPilotParts++;
PilotPulse=(int) (0.5+((double) avgpilot/samples_per_t_state));	// Length of Pilot pulse
if (NumPilotParts<20) { PilotOK=0; return; }
ClickPulses[0]=ClickPulses[1]=715;
PilotOK=1; return;
}

void SaveClickingPilot(void)
{
	char buf[256];
	int m;

	for (n=0; n<NumPilotParts; n++)
	{
		buf[0]=0x12;
		buf[1]=(char) (PilotPulse&0xFF); buf[2]=(char) (PilotPulse>>8);
		buf[3]=(char) (PilotParts[n]&0xFF); buf[4]=(char) (PilotParts[n]>>8);
		write(ofh,buf,5);
		if (n!=NumPilotParts-1)
		{
			buf[0]=0x13;
			buf[1]=(char) ClickLen;
			for (m=0; m<ClickLen; m++)
			{
				buf[2+(m*2)]=(char) (ClickPulses[m]&0xFF);
				buf[3+(m*2)]=(char) (ClickPulses[m]>>8);
			}
			write(ofh,buf,2+(ClickLen*2));
		}
	}
}

/***********************************************************/

void GetStandardSync(int type)
{
	switch (type)
	{

		case LDR_BLEEPV1:
		{
//		plen=GetPulse();
		plen=PulseBuffer_GetPulse(&pulseBuffer);
			sync1 = BLEEPV1_SYNC1;
			sync2 = BLEEPV1_SYNC2;
		}
		break;
		
		case LDR_SPECVAR2:
		{
	//		plen=GetPulse();
			plen=PulseBuffer_GetPulse(&pulseBuffer);
			sync1 = SPECVAR2_SYNC1;
			sync2 = SPECVAR2_SYNC2;
		}
		break;

		case LDR_SPECVAR3:
		{
	//		plen=GetPulse();
			plen=PulseBuffer_GetPulse(&pulseBuffer);
			sync1 = SPECVAR3_SYNC1;
			sync2 = SPECVAR3_SYNC2;
		}
		break;

		case LDR_SPECVAR4:
		{
	//		plen=GetPulse();
			plen=PulseBuffer_GetPulse(&pulseBuffer);
			sync1 = SPECVAR4_SYNC1;
			sync2 = SPECVAR4_SYNC2;
		}
		break;

		case LDR_SPECROM:
		{
//		plen=GetPulse();
		plen=PulseBuffer_GetPulse(&pulseBuffer);
			sync1 = SPECROM_SYNC1;
			sync2 = SPECROM_SYNC2;
		}
		break;

		case LDR_APPLEBY:
		{
//		plen=GetPulse();
		plen=PulseBuffer_GetPulse(&pulseBuffer);

			sync1 = APPLEBY_SYNC1;
			sync2 = APPLEBY_SYNC2;
		}
		break;

		default:
		case LDR_BLEEPV2:
		case LDR_CASSYS:
		case LDR_UNKNOWN:
		case LDR_STANDARD:
		case LDR_MICROKEY:
		{
//		plen=GetPulse();
		plen=PulseBuffer_GetPulse(&pulseBuffer);
			sync1=(int) ((double) lplen/samples_per_t_state + 0.5);
			sync2=(int) ((double) plen/samples_per_t_state + 0.5);
		}
		break;

		case LDR_SLOCKDATA:
		{
//		plen=GetPulse();
		plen=PulseBuffer_GetPulse(&pulseBuffer);
			sync1 = SLOCKDATA_SYNC1;
			sync2 = SLOCKDATA_SYNC2;
		}
		break;

		case LDR_CODEMASTERS:
		{
//		plen=GetPulse();
		plen=PulseBuffer_GetPulse(&pulseBuffer);
			sync1 = CODEMASTERS_SYNC1;
			sync2 = CODEMASTERS_SYNC2;
		}
		break;

		case LDR_RICOCHET:
		{
//		plen=GetPulse();
		plen=PulseBuffer_GetPulse(&pulseBuffer);
			sync1 = RICOCHET_SYNC1;
			sync2 = RICOCHET_SYNC2;
		}
		break;


		case LDR_SLOCKDATA2:
		{
//		plen=GetPulse();
		plen=PulseBuffer_GetPulse(&pulseBuffer);
			sync1 = SLOCKDATA2_SYNC1;
			sync2 = SLOCKDATA2_SYNC2;
		}
		break;


		case LDR_SLOCKDATA3:
		{
//		plen=GetPulse();
		plen=PulseBuffer_GetPulse(&pulseBuffer);
			sync1 = SLOCKDATA3_SYNC1;
			sync2 = SLOCKDATA3_SYNC2;
		}
		break;

		case LDR_USGOLD:
		{
//		plen=GetPulse();
		plen=PulseBuffer_GetPulse(&pulseBuffer);
			sync1 = USG_SYNC1;
			sync2 = USG_SYNC2;
		}
		break;

		case LDR_FIREMUS:
		{
//		plen=GetPulse();
		plen=PulseBuffer_GetPulse(&pulseBuffer);
			sync1 = FIREMUS_SYNC1;
			sync2 = FIREMUS_SYNC2;
		}
		break;


	}
}


/***********************************************************/

#if 0
void GetDISync(void)
{
// lplen holds the value of the ONE DI Sync pulse ...
sync1=(int) ((double) lplen/samples_per_t_state + 0.5);
}
#endif

void GetSpeedlock2Sync(void)
{
// Just skip 2 SYNC pulses, since they are ALWAYS the same
// Skip next 6 Bits of DATA too ...
// (first pulse of SYNC has already been read - lplen)
int n;

for (n=0; n<1+(6*2); n++) 
{
//		plen=GetPulse();
		plen=PulseBuffer_GetPulse(&pulseBuffer);
}
}

void GetSpeedlock1Sync(void)
{
// Just skip 2 SYNC pulses, since they are ALWAYS the same
// (first pulse of SYNC has already been read - lplen)
/*int n; */

//	GetPulse();
	PulseBuffer_GetPulse(&pulseBuffer);
}


void GetSpeedlock34Sync(void)
{
// Just skip ALL SYNC pulses, since they are ALWAYS the same
// Actually there are 2 Standard SYNC pulses + 14 Composed SYNC pulses and 6 Bits of DATA
// (first pulse of Standard SYNC has already been read - lplen
int n;

for (n=0; n<1+(7*2)+(6*2); n++) 
{
//		plen=GetPulse();
		plen=PulseBuffer_GetPulse(&pulseBuffer);
}
}

void GetSpeedlock234MiddleSync(void)
{
// Just skip ALL SYNC pulses, since they are ALWAYS the same
int n;

for (n=0; n<21*2; n++)
{
//		plen=GetPulse();
		plen=PulseBuffer_GetPulse(&pulseBuffer);
}
}

/***********************************************************/

void Get01Timings(int type)
{

	switch (type)
	{
		case LDR_STANDARD:
		{
			hp1=total/pilot;
			hp0=(int)((double)hp1/(double)1.9);	//+(hp1>>2);
		}
		break;

		case LDR_BLEEPV1:
		{
			hp0=(int) ((double) BLEEPV1_BIT0*samples_per_t_state);	
			hp1=(int) ((double) BLEEPV1_BIT1*samples_per_t_state);
		}
		break;


		case LDR_RICOCHET:
		{
			hp0=(int) ((double) RICOCHET_BIT0*samples_per_t_state);
			hp1=(int) ((double) RICOCHET_BIT1*samples_per_t_state);
		}
		break;


		case LDR_CODEMASTERS:
		{
			hp0=(int) ((double) CODEMASTERS_BIT0*samples_per_t_state);
			hp1=(int) ((double) CODEMASTERS_BIT1*samples_per_t_state);
		}
		break;

		case LDR_FIREMUS:
		{
			hp0=(int) ((double) FIREMUS_BIT0*samples_per_t_state);	
			hp1=(int) ((double) FIREMUS_BIT1*samples_per_t_state);
		}
		break;
#ifdef TEST_BLEEPV3
		case LDR_BLEEPV3:
		{
			plen=PulseBuffer_GetPulse(&pulseBuffer);
			hp0=(int) plen;
			do	
			{
				plen=PulseBuffer_GetPulse(&pulseBuffer);
				hpt=(int)plen;
			} while(Diff(hpt, hp0)<=TRES_01 && (!PulseBuffer_EOF(&pulseBuffer)));
			if (hpt<hp0) { hp1=hp0; hp0=hpt; } else hp1=hpt;
		}
		break;
#endif


		default:
		case LDR_BLEEPV2:
		case LDR_CASSYS:
		case LDR_UNKNOWN:
		case LDR_MICROKEY:
		{
//		plen=GetPulse();
		plen=PulseBuffer_GetPulse(&pulseBuffer);
//		lplen=GetPulse();
		lplen=PulseBuffer_GetPulse(&pulseBuffer);
			hp0=(int) (((double)plen+(double)lplen+0.5)/2.0);
			do	{
//		plen=GetPulse();
		plen=PulseBuffer_GetPulse(&pulseBuffer);
//		lplen=GetPulse();
		lplen=PulseBuffer_GetPulse(&pulseBuffer);
				hpt=(int) (((double)plen+(double)lplen+0.5)/2.0);
				} while(Diff(hpt, hp0)<=TRES_01 && (!PulseBuffer_EOF(&pulseBuffer)));
			if (hpt<hp0) { hp1=hp0; hp0=hpt; } else hp1=hpt;
		}
		break;

		case LDR_USGOLD:
		{
			hp0=(int) ((double) USG_BIT0*samples_per_t_state);	
			hp1=(int) ((double) USG_BIT1*samples_per_t_state);
		}
		break;

		case LDR_SLOCKDATA:
		{
			hp0=(int) ((double)SLOCKDATA_BIT0*samples_per_t_state);
			hp1=(int) ((double)SLOCKDATA_BIT1*samples_per_t_state);
		}
		break;

		case LDR_SLOCKDATA2:
		{
			hp0=(int) ((double)SLOCKDATA2_BIT0*samples_per_t_state);
			hp1=(int) ((double)SLOCKDATA2_BIT1*samples_per_t_state);
		}
		break;

		case LDR_SLOCKDATA3:
		{
			hp0=(int) ((double)SLOCKDATA3_BIT0*samples_per_t_state);
			hp1=(int) ((double)SLOCKDATA3_BIT1*samples_per_t_state);
		}
		break;


		case LDR_SPECVAR2:
		{
			hp0=(int) ((double) SPECVAR2_BIT0*samples_per_t_state);				
			hp1=(int) ((double) SPECVAR2_BIT1*samples_per_t_state);
		}
		break;


		case LDR_SPECVAR3:
		{
			hp0=(int) ((double) SPECVAR3_BIT0*samples_per_t_state);				
			hp1=(int) ((double) SPECVAR3_BIT1*samples_per_t_state);
		}
		break;


		case LDR_SPECVAR4:
		{
			hp0=(int) ((double) SPECVAR4_BIT0*samples_per_t_state);				
			hp1=(int) ((double) SPECVAR4_BIT1*samples_per_t_state);
		}
		break;


		case LDR_SPECROM:
		{
			hp0=(int) ((double) SPECROM_BIT0*samples_per_t_state);				
			hp1=(int) ((double) SPECROM_BIT1*samples_per_t_state);
		}
		break;

		case LDR_APPLEBY:
		{
			hp0=(int) ((double)APPLEBY_BIT0*samples_per_t_state);
			hp1=(int) ((double)APPLEBY_BIT1*samples_per_t_state);
		}
		break;
	}

	hp01=hp1-((int) (0.5+ (double) (hp1-hp0)/2.0));	// Treshold value for /middle
}

/***********************************************************/

#if VOC2TZX6
int sync_averages[42];
int syncs_counted;
#endif

int GetActualSpeedlock234Data(void)
{
int syncs[42];
//int tempcur;
int endofsubblock=0;
posbyte=posbit=num0=num1=temp[0]=0; total0=total1=0.0;
do	{
	if (!posbit && posbyte)			// Recognise end-of-subblock (if it fits the description ;) )
	{
		PulseBuffer_PushPosition(&pulseBuffer);

//		tempcur=cur;
		for (n=0; n<42; n++) syncs[n]=(int) (0.5+((double) PulseBuffer_GetPulse(&pulseBuffer)/*GetPulse()*//samples_per_t_state));	// Read in 42 pulses
//		cur=tempcur;
		PulseBuffer_PopPosition(&pulseBuffer);

		////////////////////////////////////////////////////////////////////////////
		// original
		endofsubblock = 1;
		// sometimes >30 and sometimes >40 works better
		for (n=0; n<10; n++) 
		{
			if (Diff(syncs[n],875)>30) endofsubblock=0;
		}
		for (n=0; n<10; n++) 
		{
			if (Diff(syncs[32+n],875)>30) endofsubblock=0;
		}
		for (n=0; n<22; n++) 
		{
			if (Diff(syncs[10+n],1750)>30) endofsubblock=0;
		}
		////////////////////////////////////////////////////////////////////////////





#if 0
		endofsubblock=1;
		// check middle 7 bits are set
		for (n=0; n<14; n++) 
		{
			if (Diff(syncs[14+n],1750)>30) endofsubblock=0;
		}

		for (n=0; n<4; n++) 
		{
			if (Diff(syncs[0+n],875)>30) endofsubblock=0;
		}
#endif

#if 0
		endofsubblock=1;
		// check middle 7 bits are set
		for (n=0; n<14; n++) 
		{
			if (Diff(syncs[14+n],1900)>30) endofsubblock=0;
		}

		for (n=0; n<8; n++) 
		{
			if (Diff(syncs[n],950)>30) endofsubblock=0;
		}
		
		for (n=0; n<8; n++) 
		{
			if (Diff(syncs[32+n],950)>30) endofsubblock=0;
		}
	//	for (n=0; n<8; n++) 
	//	{
	//		if (Diff(syncs[(16*2)+n],875)>30) endofsubblock=0;
	//	}
#endif


#if VOC2TZX6
		if (posbyte==80)
		{
			int lastbit;

			endofsubblock=1;

			lastbit = temp[posbyte-1] & 0x01;

			// update average
			for (n=0; n<42; n++)
			{
				sync_averages[n]+=syncs[n];
			}

			// add counted
			syncs_counted++;
		}
		else
		{
			endofsubblock=0;
		}
#endif

		//		if (posbyte==15966) endofsubblock=1; 	// Ping Pong for-last block
		if (endofsubblock) goto out2;
		}
//		lplen=GetPulse();
		lplen=PulseBuffer_GetPulse(&pulseBuffer);
//		plen=GetPulse();
		plen=PulseBuffer_GetPulse(&pulseBuffer);
	if (difend && (Diff(plen,lplen)>=TRES_END)) goto out2;
	// Here it is 2* just in case...
	if (!difend && ((plen>(int) (2*hp1)) || (lplen>(int) (2*hp1)))) goto out2;
	// Check if the two pulses together were smaller than ONE pulse of Bit 0
	// If so then there MUST be something wrong and consider this as a
	// mistake - therefore read in what should be the proper pulse !
	if (plen+lplen<hp0)
		{ plen+=lplen; 
//		lplen=GetPulse();
		lplen=PulseBuffer_GetPulse(&pulseBuffer);
 plen+=lplen; 
//		lplen=GetPulse();
		lplen=PulseBuffer_GetPulse(&pulseBuffer);
	}
	if (!middle)	hpt=(int) (((double) (plen+lplen)+0.5)/2.0);
	else 			hpt=(int) (0.5 +((double) (plen+lplen))/2.0);
	if ((!middle && (abs(hpt-hp0)>abs(hpt-hp1))) || (middle && hpt>hp01))
		{ 
		currbit=1; total1+=(double) (plen+lplen); num1+=2;
		// If alternative way is used then do the recognition with averages !!!
		if (alter && num1>2)
			{
			hp1=(int) (0.5+(total1/ (double) num1));
			if (middle) hp01=hp1-((int) (0.5+ (double) (hp1-hp0)/2.0));	// Treshold value
			}
		}
	else 
		{
		currbit=0; total0+=(double) (plen+lplen); num0+=2;
		if (alter && num0>2)
			{
			hp0=(int) (0.5+(total0/ (double) num0));
			if (middle) hp01=hp1-((int) (0.5+ (double) (hp1-hp0)/2.0));	// Treshold value
			}
		}
	temp[posbyte]<<=1; temp[posbyte]+=currbit; posbit++;
	if (posbit==8) { posbyte++; temp[posbyte]=0; posbit=0; }
	} while(!PulseBuffer_EOF(&pulseBuffer));
out2:
if (posbit) posbyte++; else posbit=8;
if (posbit<8) temp[posbyte-1]<<=(8-posbit);		// Shift the last byte properly
if (posbit<8 && ignore) { posbyte--; posbit=8; }
printf("   Sub-Block %2d                                             L-%5d\n",subblocknum,posbyte);
NoData=0;				
if (endofsubblock) return(1); else return(0);	// return 1 if there are some more sub-blocks !!!
}

void GetActualStandardData(int numbits)
{
posbyte=posbit=num0=num1=temp[0]=0; total0=total1=0.0;


do	{
	// num bits defined?
	//
	// check if the number of bits have been transfered
	if ((numbits!=0) && (((posbyte<<3)+posbit)==numbits))
		goto out;

//	if (slock1flag && posbit==6) goto out;
//		lplen=GetPulse();
		lplen=PulseBuffer_GetPulse(&pulseBuffer);
//		plen=GetPulse();
		plen=PulseBuffer_GetPulse(&pulseBuffer);
	// Check if the two pulses together were smaller than ONE pulse of Bit 0
	// If so then there MUST be something wrong and consider this as a
	// mistake - therefore read in what should be the proper pulse !
	if ((plen+lplen)<hp0)
		{ plen+=lplen; 
//		lplen=GetPulse();
		lplen=PulseBuffer_GetPulse(&pulseBuffer);
	plen+=lplen; 
//		lplen=GetPulse();
		lplen=PulseBuffer_GetPulse(&pulseBuffer);
	}
	// If /end parameter is specified then look if difference between
	// the two read half-periods is greater or equal to specified one
	if (difend && (Diff(plen,lplen)>=TRES_END)) 
		goto out;
	// if no /end parameter is specified look if either one of the
	// read half-periods is greater than 1.4*half-period of bit 1
//	if (posbyte>18 && block==0 && !strcmp(CheckSum(posbyte)," ")) goto out;

	if (!difend && ((plen>(int) (1.9*hp1)) || (lplen>(int) (1.9*hp1))) && (numbits==0) /*!slock1flag*/) 
		goto out;

//	if (!difend && ((plen>(int) (2.3*hp1)) || (lplen>(int) (2.3*hp1))) && (numbits==0) /*!slock1flag*/) 
//		goto out;


	//	if (!difend && ((plen>(int) (1.4*hp1)) || (lplen>(int) (1.4*hp1))) && (numbits==0) /*!slock1flag*/) 
//		goto out;
	if (!middle)	hpt=(int) (((double) (plen+lplen)+0.5)/2.0);
	else 			hpt=(int) (0.5 +((double) (plen+lplen))/2.0);
	if ((!middle && (abs(hpt-hp0)>abs(hpt-hp1))) || (middle && hpt>hp01))
		{ 
		currbit=1; total1+=(double) (plen+lplen); num1+=2;
		// If alternative way is used then do the recognition with averages !!!
		if (alter && num1>2)
			{
			hp1=(int) (0.5+(total1/ (double) num1));
			if (middle) hp01=hp1-((int) (0.5+ (double) (hp1-hp0)/2.0));	// Treshold value
			}
		}
	else 
		{
		currbit=0; total0+=(double) (plen+lplen); num0+=2;
		if (alter && num0>2)
			{
			hp0=(int) (0.5+(total0/ (double) num0));
			if (middle) hp01=hp1-((int) (0.5+ (double) (hp1-hp0)/2.0));	// Treshold value
			}
		}
	temp[posbyte]<<=1; temp[posbyte]+=currbit; posbit++;
	if (posbit==8) { posbyte++; temp[posbyte]=0; posbit=0; }
	} while(!PulseBuffer_EOF(&pulseBuffer));
out:
if (!posbit && !posbyte) { NoData=1; return; }	// NO DATA read whatsoever
if (posbit) posbyte++; else posbit=8;
if (posbit<8) temp[posbyte-1]<<=(8-posbit);		// Shift the last byte properly
if (posbit<8 && ignore) { posbyte--; posbit=8; }
NoData=0;				
}

void GetSpeedlock1Data(void)
{
	char flag[10];

	switch (ldrcur)
	{
		/* 3d stunt rider */
		case LDR_SPEEDLOCKV0:
		{
			ahp0=1125;
			ahp1=2250;
		}
		break;

		default:
		case LDR_SPEEDLOCKV1:
		{
			ahp0=565; ahp1=1130;	// Speedlock 1 bit 0/1 timings
		}
		break;
	}
	hp0=(int) ((double) ahp0*samples_per_t_state);	
	hp1=(int) ((double) ahp1*samples_per_t_state);
	hp01=hp1-((int) (0.5+ (double) (hp1-hp0)/2.0));	// Treshold value for /middle

	DisplayInitialPause();

	/* if first block, write initial pilot */
	WriteInitialPause();
	
	{
		char GroupText[32];

		sprintf(GroupText,"Speedlock Block %d",slblock);

		SaveGroupStart(GroupText);
	}

	SaveClickingPilot();
	// Save the long 2-pulse SYNCs and 6 Bits of Data as Sequence of Pulses
	// First read the 6 bits of data in ... this is a MUST for Speedlock1 ...
//	slock1flag=1;
	GetActualStandardData(5);
//	slock1flag=0;
	for (n=0; n<5; n++)
		{
		if (temp[0]&0x80) { slock12sync[2+(n*2)]=slock12sync[3+(n*2)]=ahp1; flag[n]='1'; }
		else			  { slock12sync[2+(n*2)]=slock12sync[3+(n*2)]=ahp0; flag[n]='0'; }
		temp[0]<<=1;
		}
	flag[n]=0;
	SavePulses((2*5)+2,slock12sync);

	//
	GetActualStandardData(0);
	// the Data will be saved later with the SaveTZXBlock ... (so the pause will be right)
	printf(" Speedlock block %d   Flag:%s                       B%d L-%5d C%s",slblock,flag,posbit,posbyte,SpeedlockV1CheckSum(posbyte));
	block++;

	
	// End of the block - for Pause ...
	PulseBuffer_ReturnPulse(&pulseBuffer);
	PulseBuffer_ReturnPulse(&pulseBuffer);
	endb=PulseBuffer_GetCurrentPosition(&pulseBuffer);

	write_block_type = WRITE_BLOCK_PURE_DATA;
	write_group_end = 1;
}

void GetSpeedlock234Data(void)
{
#ifdef WIN32
int noiselen = 0;
int noisepulse = 0;
#else
int noiselen;
int noisepulse;
#endif

switch (ldrcur)
	{

	case LDR_SPEEDLOCKV2: ahp0=565; ahp1=1130; break; 	// Speedlock 2 bit 0/1 timings 
	case LDR_SPEEDLOCKV3: ahp0=551; ahp1=1102; break;		// Speedlock 3 bit 0/1 timings
	case LDR_SPEEDLOCKV4: ahp0=753; ahp1=1508; break;		// Speedlock 4 bit 0/1 timings
}

hp0=(int) ((double) ahp0*samples_per_t_state);	
hp1=(int) ((double) ahp1*samples_per_t_state);
hp01=hp1-((int) (0.5+ (double) (hp1-hp0)/2.0));	// Treshold value for /middle

DisplayInitialPause();
WriteInitialPause();


{
	char GroupText[32];
	
	sprintf(GroupText,"Speedlock Block %d",slblock);
	SaveGroupStart(GroupText);
}

	{
	// Save TYPE 2 Clicking Pilot and SYNC
	SaveClickingPilot();

	// Save the long 2-pulse SYNCs and 6 Bits of Data as Sequence of Pulses
	// First read the 5 bits of data in ... this is a MUST for Speedlock1 ...
//	slock1flag=1;
	GetActualStandardData(5);
//	slock1flag=0;
	for (n=0; n<5; n++)
		{
		if (temp[0]&0x80) { slock12sync[2+(n*2)]=slock12sync[3+(n*2)]=ahp1; }
		else			  { slock12sync[2+(n*2)]=slock12sync[3+(n*2)]=ahp0; }
		temp[0]<<=1;
		}
	SavePulses((2*5)+2,slock12sync);
	}
if (slblock==1)
/*
	((slockmain!=0xffffffff) && (block!=(ldrskip+slockmain))) ||
	((slockmain==0xffffffff) && (block!=(ldrskip+1)))
	)
	*/
	{
	GetActualStandardData(0);			// Get the encrypted data of the first turbo block
	// the Data will be saved later with the SaveTZXBlock ... (so the pause will be right)
	printf(" Speedlock block %d (type 1)                              B%d L-%5d C%s",slblock,posbit,posbyte,SpeedlockV1CheckSum(posbyte));
	}
else													// SECOND Speedlock turbo block
	{
#if VOC2TZX6
	syncs_counted = 0;
	for (n=0; n<42; n++)
	{
		sync_averages[n] = 0;
	}
#endif


	printf(" Speedlock block %d (type 2):\n",slblock);
	totallen=0;
	totalcheck=0;
	subblocknum=1;
	while(GetActualSpeedlock234Data())	// Get the data until there are no more sub-blocks
		{
		for (n=0; n<posbyte; n++) totalcheck^=temp[n];	// Calc checksum
		GetSpeedlock234MiddleSync();
		subblocknum++;
		pausev=0;
		SavePureData(temp,posbyte);	// Save the data with the  mid-SYNC  pulse
		SaveSpeedlockMidSync();
		totallen+=posbyte;
		}

	{
		int len;

		if ((posbit!=8) && (!ignore))
		{
			len = posbyte-1;
		}
		else
		{
			len = posbyte;
		}

		for (n=0; n<len; n++) 
			totalcheck^=temp[n];	// Calc checksum
	}
	
	// Last block will be saved later in SaveTZX with the correct Pause value and no mid-SYNC ...
	totallen+=posbyte;
	if (totalcheck==0) totalcheck='O'; else totalcheck='X';
	printf(" Speedlock block %d Total                               B%d L-%5d C%c ",slblock,posbit,totallen,totalcheck);
	}
block++;


	PulseBuffer_ReturnPulse(&pulseBuffer);
	PulseBuffer_ReturnPulse(&pulseBuffer);
	endb=PulseBuffer_GetCurrentPosition(&pulseBuffer);
write_block_type = WRITE_BLOCK_PURE_DATA;
write_group_end = 1;
}

#if 0
void GetDIData(void)
{
datastart=cur;
Get01Timings(LDR_UNKNOWN);
cur=datastart;
GetActualStandardData();		// OK, (hopefully) load in the data ...
if (NoData) return;
/*apilot=(int) ((total/(double) pilot)/samples_per_t_state + 0.5);*/
ahp0=(int) ((total0/(double) num0)/samples_per_t_state + 0.5);
ahp1=(int) ((total1/(double) num1)/samples_per_t_state + 0.5);
// Do we need to make an approximation that HP of Bit 1 == 2*HP of Bit 0
if (aprox) { dif=ahp1-(ahp0*2); ahp0+=dif/4; ahp1-=dif/2; }

printf(
" Digital Integration Block %d          0-%4d,1-%4d      B%d L-%5d    ",
block-1, ahp0, ahp1, posbit, posbyte);
block++;
	PulseBuffer_ReturnPulse(&pulseBuffer);
	PulseBuffer_ReturnPulse(&pulseBuffer);
	endb=PulseBuffer_GetCurrentPosition(&pulseBuffer);
}
#endif

/***********************************************************/

void	ForceTimings(int ldr)
{
	switch (ldr)
	{
		// force 0 and 1 timings here
		default:
			break;
	}

}

/********************************************/
/* return string describing checksum status */
/* C? -> checksum not implemented */
/* C- -> no checksum */
/* CO -> checksum computed and is ok */
/* CX -> checksum computed and failed */

char *GetChecksum(int ldr,int len)
{
	switch (ldr)
	{
		case LDR_FIREMUS:
		{
			return FirebirdMusicChecksum(len);
		}
		break;

		case LDR_USGOLD:
			return USG_CheckSum(len, 0x057, 0x0ef, 0x07b);
			

		case LDR_BLEEPV2:
		{
			if (len==0)
			{
				return("- ");
			}

			return BleepV2Checksum(len);	
		}
		break;

		case LDR_SPECVAR2:
		case LDR_SPECVAR3:
		case LDR_SPECVAR4:
			return SpanishChecksum(len);

		/* no checksum for codemasters! */
		case LDR_CODEMASTERS:
			return("- ");

		/* no checksum for codemasters! */
		case LDR_RICOCHET:
			return("- ");

#ifdef TEST_BLEEPV3
		case LDR_BLEEPV3:
		{
			return BleepV3Checksum(len);
		}
		break;
#endif

		case LDR_BLEEPV1:
		{
			return BleepV1Checksum(len);
		}
		break;

		case LDR_SPECROM:
		{
			return SpectrumCheckSum(len);
		}
		break;

		case LDR_CASSYS:
		{
			return CassysCheckSum(len);
		}
		break;

		case LDR_SLOCKDATA3:
			return ("- ");

		case LDR_SLOCKDATA:
		{
			return SpeedlockDataCheckSum(len);
		}
		break;

		case LDR_SLOCKDATA2:
		{
			return SpeedlockV1CheckSum(len);	//SpeedlockDataCheckSum(len);
		}
		break;


		default:
			break;


	}

	return "? ";
}

char *DoIdentify(int ldr, int len)
{
	switch (ldr)
	{
		case LDR_BLEEPV2:
		{
			/* for every byte, bleep v2 actually has a wave AND a byte */
			int bitoffset = (((256+1)*9)+1);

			/* is length read less than the position of the id byte? */
			if (((posbyte*8)+posbit)<bitoffset)
			{
				sprintf(tstr,"??----------");
			}
			else
			{
				sprintf(tstr,"%02x----------",GetBits(bitoffset,8) & 0x0ff);
			}
			return(tstr);
		}
		break;

#ifdef TEST_BLEEPV3
		case LDR_BLEEPV3:
		{
			/* is length read less than the position of the id byte? */
			if (posbyte<(256+3+pilot))
			{
				sprintf(tstr,"??----------");
			}
			else
			{
				sprintf(tstr,"%02x----------",temp[256+3+pilot] & 0x0ff);
			}
			return(tstr);
		}
		break;
#endif

		case LDR_BLEEPV1:
		{
			if (posbyte<(256+1))
			{
				sprintf(tstr,"??----------");
			}
			else
			{
				sprintf(tstr,"%02x----------",temp[256+1] & 0x0ff);
			}
			return(tstr);
				
		}
		break;


		case LDR_SPECROM:
		{
if (temp[0]==0 && (len==19 || len==20) && temp[1]<4)
	{
	switch (temp[1])
		{
#ifdef WIN32
	case 0x00: strcpy(tstr,"P\\:"); break;
	case 0x01: strcpy(tstr,"N\\:"); break;
	case 0x02: strcpy(tstr,"C\\:"); break;
	case 0x03: strcpy(tstr,"B\\:"); break;
#endif

#ifdef UNIX
	case 0x00: strcpy(tstr,"P\\:"); break;
	case 0x01: strcpy(tstr,"N\\:"); break;
	case 0x02: strcpy(tstr,"C\\:"); break;
	case 0x03: strcpy(tstr,"B\\:"); break;
#endif

#ifdef DOS
	case 0x00: strcpy(tstr,"P\:"); break;
	case 0x01: strcpy(tstr,"N\:"); break;
	case 0x02: strcpy(tstr,"C\:"); break;
	case 0x03: strcpy(tstr,"B\:"); break;
#endif
	}
	 for (n=0; n<10; n++)
	 	{
	 	if (temp[n+2]>31 && temp[n+2]<127) tstr[n+2]=temp[n+2];
		else                               tstr[n+2]=32;
		}
	tstr[13]=0;
	}
else strcpy(tstr,"------------");
return(tstr);


		}
		break;


#if 0
		case LDR_CASSYS:
		{
			

		}
		break;
#endif

		default:
		{
			return Identify(len);
		}
		break;
	}
}

/***********************************************************/
/* returns TRUE if loader has a sync byte, FALSE otherwise */

int HasSyncByte(int ldr)
{
	switch (ldr)
	{
		case LDR_RICOCHET:
		case LDR_CODEMASTERS:
		case LDR_SLOCKDATA:
			return 0;
	}

	return 1;
}

/***********************************************************/
/* returns the sync byte */

unsigned char GetSyncByte(int ldr)
{
	switch(ldr)
	{
		case LDR_BLEEPV2:
			return GetBits(1,8);

		case LDR_FIREMUS:
			return GetBits(3,8);

		case LDR_SPECROM:
			return temp[0];
#ifdef TEST_BLEEPV3
		case LDR_BLEEPV3:
			return bleepv3pilot^0x0ff;
#endif
	}
	return temp[0];
}



/***********************************************************/

void GetStandardData(void)
{
	// If Bleep v2 is used then permit the blocks with PILOT ONLY !!!
	if ((ldrcur==LDR_BLEEPV2) && (sync1>=(3*SPECROM_SYNC1) || sync2>=(3*SPECROM_SYNC2)))
	{ 
		NoData=0;
		posbit=0;
		posbyte=0;
		total0=0;
		total1=0;
	}
	else
	{
		PulseBuffer_PushPosition(&pulseBuffer);
//	datastart=cur;
	Get01Timings(ldrcur);
	//cur=datastart;
		PulseBuffer_PopPosition(&pulseBuffer);
	GetActualStandardData(0);		// OK, (hopefully) load in the data ...
	}
if (NoData) return;
apilot=(int) ((total/(double) pilot)/samples_per_t_state + 0.5);
ahp0=(int) ((total0/(double) num0)/samples_per_t_state + 0.5);
ahp1=(int) ((total1/(double) num1)/samples_per_t_state + 0.5);

ForceTimings(ldrcur);

// Do we need to make an approximation that HP of Bit 1 == 2*HP of Bit 0
if (aprox) { dif=ahp1-(ahp0*2); ahp0+=dif/4; ahp1-=dif/2; }

#if 0
if (DetectStandardLoading(ahp0, ahp1, apilot, pilot))
{
		custom=32;
}
else
{
		custom='*';
}
#endif
custom='*';

DisplayInitialPause();
WriteInitialPause();

if ((posbyte!=0) || (posbit!=0))
{
	unsigned char SyncString[6];

	write_block_type = WRITE_BLOCK_TURBO_LOADING;

	if (HasSyncByte(ldrcur))
	{
		sprintf(SyncString,"F-%02x",GetSyncByte(ldrcur) & 0x0ff);
	}
	else
	{
		sprintf(SyncString,"----");
	}

	printf(
	"%c%s P-%4d,%4d S-%4d/%4d 0-%4d,1-%4d %s B%d L-%5d C%s",
	custom,	DoIdentify(ldrcur,posbyte), apilot, pilot, sync1, sync2,	ahp0, ahp1,
	SyncString, posbit, posbyte, GetChecksum(ldrcur, posbyte));
}
else
{
	write_block_type = WRITE_BLOCK_TONE;

	printf(" -pilot only- P-%4d,%4d ----------- ------ ------ ---- -- ------- -- ",
	apilot, pilot);
}

block++;
// End of the block - for Pause ...
	PulseBuffer_ReturnPulse(&pulseBuffer);
	PulseBuffer_ReturnPulse(&pulseBuffer);
	endb=PulseBuffer_GetCurrentPosition(&pulseBuffer);
}

void GetMicrokeyData(void)
{
	// calculate timings for bit 0 and bit 1
	PulseBuffer_PushPosition(&pulseBuffer);
	Get01Timings(ldrcur);
	PulseBuffer_PopPosition(&pulseBuffer);

	// get sync byte
	GetActualStandardData(8);		

	DisplayInitialPause();
	WriteInitialPause();

	// setup for saving
	lst_pilot=pilot;	
	apilot=(int) ((total/(double) pilot)/samples_per_t_state + 0.5);
	ahp0=(int) ((total0/(double) num0)/samples_per_t_state + 0.5);
	ahp1=(int) ((total1/(double) num1)/samples_per_t_state + 0.5);
	pausev = 0.0;

	// save pilot and sync byte
	SaveTurboLoadingDataBlock();
	posbyte = 0;

	pilot = 0;

	PulseBuffer_PushPosition(&pulseBuffer);
	Get01Timings(ldrcur);
	PulseBuffer_PopPosition(&pulseBuffer);

	// fetch actual data
	GetActualStandardData(0);

	ahp0=(int) ((total0/(double) num0)/samples_per_t_state + 0.5);
	ahp1=(int) ((total1/(double) num1)/samples_per_t_state + 0.5);

	write_block_type = WRITE_BLOCK_PURE_DATA;

	block++;
	// End of the block - for Pause ...
	PulseBuffer_ReturnPulse(&pulseBuffer);
	PulseBuffer_ReturnPulse(&pulseBuffer);
	endb=PulseBuffer_GetCurrentPosition(&pulseBuffer);
}


static void InitDefaultSkip(int ldr)
{
	switch (ldr)
	{
		case LDR_SLOCKDATA3:
		case LDR_SLOCKDATA:
		case LDR_SLOCKDATA2:
		case LDR_STANDARD:
			ldrskip = 0;
			break;

		/* two single block standard loaders */
		case LDR_MICROKEY:
		{
			ldrskip = 4;
			break;
		}


#ifdef TEST_BLEEPV3
		case LDR_BLEEPV3:
#endif
		case LDR_BLEEPV2:
		case LDR_BLEEPV1:
		{
			/* normally 2 single block files */
			ldrskip = 4;
		}
		break;

		case LDR_SPECROM:
		case LDR_SPECVAR2:
		case LDR_SPECVAR3:
		case LDR_SPECVAR4:
			ldrskip = 2;
			break;

		case LDR_CASSYS:
		{
			/* normally 1 single block file */
			ldrskip = 2;
		}
		break;

		case LDR_APPLEBY:
		{
			/* a single 2 block file */
			ldrskip = 4;
		}
		break;

		case LDR_SPEEDLOCKV0:
		case LDR_SPEEDLOCKV1:
		{
			/* normally 2 single block files */
			ldrskip = 4;
		}
		break;

		case LDR_USGOLD:
		{
			/* a single 1 block file */
			ldrskip = 2;
		}
		break;

		case LDR_RICOCHET:
		{
			ldrskip = 2;
		}
		break;

		case LDR_CODEMASTERS:
		{
			ldrskip = 4;
		}
		break;


		case LDR_SPEEDLOCKV3:
		case LDR_SPEEDLOCKV4:
		case LDR_SPEEDLOCKV2:
		{
			ldrskip = 4;

		}
		break;
	}


}

static void Convert(void)
{

#ifdef WIN32
ofh=open(fout, O_WRONLY | O_BINARY | O_CREAT | O_TRUNC);
#endif

#ifdef UNIX
ofh=open(fout, O_WRONLY | O_CREAT | O_TRUNC,
	           S_IRUSR | S_IWUSR | S_IRGRP | S_IWGRP);
#endif

#ifdef DOS
ofh=open(fout, O_WRONLY | O_BINARY | O_CREAT | O_TRUNC,
	           S_IRUSR | S_IWUSR | S_IRGRP | S_IWGRP);
#endif
//if (!tape)
	{
	write(ofh,tzxbuf,10);
	}
/* 
NOTES:

- 3500000 is the Spectrum CPU frequency

- it is assumed there is one T state per clock, therefore
  there are 3500000 t-states per second 

- the sample frequency is the number of samples per second

calculations:

  t_states_per_sample = t_states_per_second/samples_per_second

  samples_per_t_state = samples_per_second/t_states_per_second

Differing sample rates, result in different errors */

t_states_per_sample = (double)3500000.0/(double)sample_frequency;
samples_per_t_state = (double)sample_frequency/(double)3500000.0;

//if (tape) printf("Creating .TAP file ...\n\n");
//else
	{
	printf("Creating 1.12 version ");
	printf("Amstrad CPC .CDT file ... \n\n");
	}
NoData=1;

/* a loader defined and no skip defined? */
if ((ldrskip==-1) && (ldrtype!=-1))
{
	/* set defaults */
	InitDefaultSkip(ldrtype);
}

while (!PulseBuffer_EOF(&pulseBuffer))
{
	switch (actioncur)
	{
		case ACTION_DEFAULT:
		{


			if (ldrskip!=-1)
			{
				/* skip defined to start loader type */

				/* loader type defined? */
				if (ldrtype!=-1)
				{
					/* reached block to change to decode defined loader? */
					if (block==ldrskip)
					{
						/* yes, set this as the current loader type */
						ldrcur = ldrtype;
					}

					/* end defined? */
					if (ldrend!=-1)
					{
						/* reached end block? */
						if (block==(ldrskip+ldrend))
						{
		//					break;
							/* switch back to unknown */
							ldrcur = LDR_UNKNOWN;
							difend = 1;
							TRES_END = 95;
						}
					}
				}
			}

			/*******************************************************************/
			switch (ldrcur)
			{
				default:
				case LDR_BLEEPV2:
				case LDR_CASSYS:
				case LDR_UNKNOWN:
				{
					GetStandardPilot();
				}
				break;

				case LDR_MICROKEY:
				{
					GetStandardPilot();
				}
				break;


				case LDR_STANDARD:
				{
					GetStandardPilot2();
				}
				break;

				case LDR_APPLEBY:
				{
					// min pilot for appleby
					GetFixedPilot(APPLEBY_HP_PILOT, APPLEBY_MIN_PILOT);
				}
				break;

				case LDR_USGOLD:
				{
					// min pilot for usgold?
					GetFixedPilot(USG_HP_PILOT, 100);
				}
				break;

				case LDR_SLOCKDATA:
				{
					GetFixedPilot(SLOCKDATA_HP_PILOT, 100);
				}
				break;

				case LDR_SLOCKDATA2:
				{
					GetFixedPilot(SLOCKDATA2_HP_PILOT, 100);
				}
				break;

				case LDR_SLOCKDATA3:
				{
					GetFixedPilot(SLOCKDATA3_HP_PILOT, 100);
				}
				break;


				case LDR_SPECVAR2:
				{
					GetFixedPilot(SPECVAR2_HP_PILOT, 128);
				}
				break;


				case LDR_SPECVAR3:
				{
					GetFixedPilot(SPECVAR3_HP_PILOT, 128);
				}
				break;


				case LDR_SPECVAR4:
				{
					GetFixedPilot(SPECVAR4_HP_PILOT, 128);
				}
				break;


				case LDR_SPECROM:
				{
					GetFixedPilot(SPECROM_HP_PILOT, 100);
				}
				break;

				case LDR_BLEEPV1:
				{
					/* approx 700 pulses */
					GetFixedPilot(BLEEPV1_HP_PILOT, 600);
				}
				break;

				case LDR_RICOCHET:
				{
					GetFixedPilot(RICOCHET_HP_PILOT, 600);
				}
				break;

				case LDR_CODEMASTERS:
				{
					GetFixedPilot(CODEMASTERS_HP_PILOT, 600);
				}
				break;

				case LDR_FIREMUS:
				{
					GetFixedPilot(FIREMUS_HP_PILOT, 100);
				}
				break;

#ifdef TEST_BLEEPV3
				case LDR_BLEEPV3:
				{
					GetBleepV3Pilot();
				}
				break;
#endif
				case LDR_SPEEDLOCKV0:
				case LDR_SPEEDLOCKV1:
				case LDR_SPEEDLOCKV2:
				case LDR_SPEEDLOCKV3:
				case LDR_SPEEDLOCKV4:
				{
					GetClickingPilot();
				}
				break;
			}
		}
		break;

		case ACTION_SLDETECT:
		{
#if 0
			int tempcur;

			tempcur=cur;
			GetClickingPilot();
			
			if (PilotOK)
			{
				if (ldrtype==-1)
				{
					ldrcur = LDR_SPEEDLOCKV1;
				}
				else
				{
					ldrcur = ldrtype;
				}
			}
			else
			{
				cur = tempcur;
				GetStandardPilot();

				if (PilotOK)
				{
					ldrcur = LDR_STANDARD;
				}
			}
#endif
		}
		break;
	}

	if (PilotOK)
	{
		if (!NoData)
		{
			/* setup pause AFTER previous block = pause between this block and previous */
			pausev=((float) start-(float) endb)/(float) sample_frequency;
			if (pausev<0.0) pausev=0.0;

			printf("P-%1.3f\n",pausev);


			if (block) SaveTZXBlock();
			WritePossiblePause();

		}
	//	else
	//	{
	//		// no data
//
//		}

		/*******************************************************************/
		switch(ldrcur)
		{
			default:
			case LDR_BLEEPV2:
			case LDR_CASSYS:
			case LDR_UNKNOWN:
			case LDR_SLOCKDATA:
			case LDR_SLOCKDATA2:
			case LDR_SLOCKDATA3:
			case LDR_CODEMASTERS:
			case LDR_RICOCHET:
			case LDR_STANDARD:
			case LDR_MICROKEY:
			case LDR_FIREMUS:
			{
				GetStandardSync(ldrcur); 
			}
			break;

#ifdef TEST_BLEEPV3
			case LDR_BLEEPV3:
			{
				GetBleepV3Sync();
			}
			break;
#endif

			case LDR_SPEEDLOCKV0:
			case LDR_SPEEDLOCKV1:
			case LDR_SPEEDLOCKV2:
			case LDR_SPEEDLOCKV3:
			case LDR_SPEEDLOCKV4:
			{
				GetSpeedlock1Sync();
			}
			break;
		}

		/*******************************************************************/
		
		/* when the first speedlock block is encountered,
		slblock will be reset to 1. For each subsequent speedlock block,
		this will be incremented by 1.
		Whenever a non speedlock block is encountered, the slblock is reset,
		so that when the next speedlock block is encountered, it will start at 1 
		again */
		switch (ldrcur)
		{
			case LDR_SPEEDLOCKV0:
			case LDR_SPEEDLOCKV1:
			case LDR_SPEEDLOCKV2:
			case LDR_SPEEDLOCKV3:
			case LDR_SPEEDLOCKV4:
			{
				if (slblock==-1)
					slblock=1;
				else 
					slblock++;
			}
			break;

			default:
				slblock = -1;
				break;
		}
		
		switch(ldrcur)
		{
			default:
			case LDR_BLEEPV2:
			case LDR_CASSYS:
			case LDR_BLEEPV1:
			case LDR_APPLEBY:
			case LDR_SLOCKDATA:
			case LDR_SLOCKDATA2:
			case LDR_SLOCKDATA3:
			case LDR_CODEMASTERS:
			case LDR_RICOCHET:
			case LDR_UNKNOWN:
			case LDR_STANDARD:
			{
				GetStandardData();
			}
			break;

#ifdef TEST_BLEEPV3
			case LDR_BLEEPV3:
			{
				GetBleepV3Data();
			}
			break;
#endif

			case LDR_FIREMUS:
			{
				GetStandardData();
			}
			break;


			case LDR_MICROKEY:
			{
				GetMicrokeyData();
			}
			break;

			case LDR_SPEEDLOCKV0:
			case LDR_SPEEDLOCKV1:
			{
				GetSpeedlock1Data();
			}
			break;

			case LDR_SPEEDLOCKV2:
			case LDR_SPEEDLOCKV3:
			case LDR_SPEEDLOCKV4:
			{
				GetSpeedlock234Data();
			}
			break;
		}

		if (!NoData)			// Got some Actual Data from conversion
		{

			lst_pilot=pilot;	// Remember the previous pilot length for saving
		}
	}
	}

// Lets Save the Last block to disk ....
if (/*!tape &&*/ block && !NoData) 
{ 
	/*pausev=0.0;*/ 
	WriteInitialPause();
	SaveTZXBlock(); 
}
if (block)	printf("\n");
else		printf("-- Error: No blocks found... please consult the documentation!\n");
close(ofh);
}

void invalidoption(char *s)
{
// Prints the Invalid Option error


sprintf(errstr,"Invalid Option %s !",s);
Error(errstr);
}

int getnumber(char *s)
{
// Returns the INT number contained in string *s
int i;

sscanf(s,"%d",&i); return(i);
}

typedef struct
{
	/* option name */
	const char *optionname;
	/* description */
	const char *optiondesc;
	/* function to execute */
	int (*optionfunction)(char **argv, int argc, int n);
} optionhandler;

int alter_option(char **argv, int argc, int n)
{
	alter=1; 

	return n;
}

int ignore_option(char **argv, int argc, int n)
{
	ignore = 1;
	
	return n;
}

int noaprox_option(char **argv, int argc, int n)
{
	aprox=0;
	return n;
}

int ldrskip_option(char **argv, int argc, int n)
{
	ldrskip=getnumber(argv[n+1]); 
	n++;

	return n;
}
#if 0
int force_option(char **argv, int argc, int n)
{
	forcep=getnumber(argv[n+1]); 
	force=1; 
	n++;

	return n;
}
#endif
#if 0
int sync_option(char **argv, int argc, int n)
{
	ffsync=1;

	return n;
}
#endif
int pilot_option(char **argv, int argc, int n)
{
	MIN_PILOT=getnumber(argv[n+1]); 
	n++; 
	return n;
}

int maxp_option(char **argv, int argc, int n)
{
	TRES_FULL=getnumber(argv[n+1]); 
	n++; 
	return n;
}

int middle_option(char **argv, int argc, int n)
{
	middle=1;

	return n;
}

int appleby_option(char **argv, int argc, int n)
{
	ldrtype = LDR_APPLEBY;

	return n;
}

int diff_option(char **argv, int argc, int n)
{
	TRES_01=getnumber(argv[n+1]); 
	n++;

	return n;
}

int end_option(char **argv, int argc, int n)
{
	TRES_END=getnumber(argv[n+1]); 
	difend=1; 
	n++; 
	return n;
}

int slmain_option(char **argv, int argc, int n)
{
	slockmain=getnumber(argv[n+1]); 
	n++;
	return n;
}

int sldata_option(char **argv, int argc, int n)
{
	ldrtype = LDR_SLOCKDATA;

	return n;
}


int specvar2_option(char **argv, int argc, int n)
{
	ldrtype = LDR_SPECVAR2;

	return n;
}

int specvar3_option(char **argv, int argc, int n)
{
	ldrtype = LDR_SPECVAR3;

	return n;
}
int specvar4_option(char **argv, int argc, int n)
{
	ldrtype = LDR_SPECVAR4;

	return n;
}

int sldata2_option(char **argv, int argc, int n)
{
	ldrtype = LDR_SLOCKDATA2;

	return n;
}


int sldata3_option(char **argv, int argc, int n)
{
	ldrtype = LDR_SLOCKDATA3;

	return n;
}


int ldrend_option(char **argv, int argc, int n)
{
	ldrend=getnumber(argv[n+1]); n++;

	return n;
}

int usgold_option(char **argv, int argc, int n)
{
	ldrtype = LDR_USGOLD;

	return n;
}

int spec_option(char **argv, int argc, int n)
{
	ldrtype = LDR_SPECROM;

	return n;
}


int slock0_option(char **argv, int argc, int n)
{
	ldrtype = LDR_SPEEDLOCKV0;
//	slockvar = 2;

	return n;
}


int slock1_option(char **argv, int argc, int n)
{
	ldrtype = LDR_SPEEDLOCKV1;
//	slockvar = 2;

	return n;
}


int slock2_option(char **argv, int argc, int n)
{
	ldrtype = LDR_SPEEDLOCKV2;

	return n;
}

int slock3_option(char **argv, int argc, int n)
{
	ldrtype = LDR_SPEEDLOCKV3;

	return n;
}


int slock4_option(char **argv, int argc, int n)
{
	ldrtype = LDR_SPEEDLOCKV4;

	return n;
}

int codem_option(char **argv, int argc, int n)
{
	ldrtype = LDR_CODEMASTERS;

	return n;
}


int ricochet_option(char **argv, int argc, int n)
{
	ldrtype = LDR_RICOCHET;

	return n;
}

int bleepv1_option(char **argv, int argc, int n)
{
	ldrtype = LDR_BLEEPV1;

	return n;
}

int bleepv2_option(char **argv, int argc, int n)
{
	ldrtype = LDR_BLEEPV2;

	return n;
}

int cassys_option(char **argv, int argc, int n)
{
	ldrtype = LDR_CASSYS;

	return n;
}

int standard_option(char **argv, int argc, int n)
{
	ldrtype = LDR_STANDARD;

	return n;
}


int microkey_option(char **argv, int argc, int n)
{
	ldrtype = LDR_MICROKEY;

	return n;
}

int slauto_option(char **argv, int argc, int n)
{
	actioncur = ACTION_SLDETECT;

	return n;
}


#ifdef TEST_BLEEPV3
int bleepv3_option(char **argv, int argc, int n)
{
	ldrtype = LDR_BLEEPV3;

	return n;
}
#endif

/* table of options */
optionhandler options[]=
{
	{
		"alter",
		"Use Alternative way to recognise 0 or 1 bit!",
		alter_option
	},
	{	
		"appleby",
		"Use 'Appleby' loader algorithm",
		appleby_option
	},
	{	
		"cassys",
		"Use 'Cassys' loader algorithm",
		cassys_option
	},
	{	
		"standard",
		"Use 'Standard' loader algorithm",
		standard_option
	},
	{	
		"microkey",
		"Use 'Micro-Key' loader algorithm",
		microkey_option
	},
//	{	
//		"specvar2",
//		"Use 'Spectrum variant 2' loader algorithm",
//		specvar2_option,
//	},
	{	
		"specvar3",
		"Use 'Spectrum variant 3' loader algorithm",
		specvar3_option,
	},
//	{	
//		"specvar4",
//		"Use 'Spectrum variant 4' loader algorithm",
//		specvar4_option,
//	},

	{	
		"sldata",
		"Use 'Speedlock Data' loader algorithm",
		sldata_option,
	},
	{	
		"sldata2",
		"Use 'Speedlock Data 2' loader algorithm",
		sldata2_option,
	},
	{	
		"sldata3",
		"Use 'Speedlock Data 3' loader algorithm",
		sldata3_option,
	},
	{	
		"bleepv1",
		"Use 'Bleepload V1' loader algorithm",
		bleepv1_option,
	},
	{	
		"codem",
		"Use 'Codemasters' loader algorithm",
		codem_option,
	},
	{	
		"ricochet",
		"Use 'Ricochet' loader algorithm",
		ricochet_option,
	},
	{	
		"bleepv2",
		"Use 'Bleepload V2' loader algorithm",
		bleepv2_option,
	},
#ifdef TEST_BLEEPV3
	{	
		"bleepv3",
		"Use 'Bleepload V3' loader algorithm; experimental!!!",
		bleepv3_option,
	},
#endif
	{	
		"spec",
		"Use 'Spectrum ROM' loader algorithm",
		spec_option,
	},
	{	
		"usgold",
		"Use 'US Gold' loader algorithm",
		usgold_option,
	},
	{
		"ignore",
		"Ignore Last Byte if it has less than 8 bits",
		ignore_option,
	},
	{
		"noaprox",
		"DON'T make Bit1 h-p == 2*Bit0 h-p",
		noaprox_option,
	},
	{
		"ldrskip",
		"Skip n blocks before forcing decoder",
		ldrskip_option,
	},
#if 0
	{
		"force",
		"n; In HPs - Force Length of Custom Pilot Tone to n",
		force_option,
	},
#endif
//	{
//		"sync",
//		"Force SYNC pulses to Standard values!",
//		sync_option,
//	},
	{
		"pilot",
		"n;  In HPs - Min. Number of Pilot HPs for a block",
		pilot_option,
	},
	{
		"maxp",
		"n;  In %% - Max. Treshold between Two HPs of Pilot",
		maxp_option,
	},
	{
		"middle",
		"Use Middle Value of bit 0 and 1 !",
		middle_option,
	},
	{
		"diff",
		"n;  In %% - Min. Treshold between 0 and 1 bit HPs",
		diff_option
	},
	{
		"end",
		"n;	In %% - Min. Treshold between Two HPs to END block",
		end_option
	},
	{
		"slmain",
		"n; block number that Speedlock V2 style block starts",
		slmain_option
	},
	{
		"ldrend",
		"n; block number to stop processing defined loader",
		ldrend_option
	},
	{
		"slauto",
		"Auto detect Speedlock V1 blocks",
		slauto_option,	
	},
	{
		"slock0",
		"Use 'Speedlock V0' loader algorithm",
		slock0_option,	
	},
	{
		"slock1",
		"Use 'Speedlock V1' loader algorithm",
		slock1_option,	
	},
	{
		"slock2",
		"Use 'Speedlock V2' loader algorithm",
		slock2_option,
	},
	{
		"slock3",
		"Use 'Speedlock V3' loader algorithm",
		slock3_option,	
	},
	{
		"slock4",
		"Use 'Speedlock V4' loader algorithm",
		slock4_option,
	},
};

void	HandleError(int Status)
{
	if (Status==SAMPLE_FILE_OUT_OF_MEMORY)
	{
		Error("Not enough memory to load input file!");
	}
	else if (Status==SAMPLE_FILE_VERSION_UNSUPPORTED)
	{
		Error("This version of the sample file is not supported!");
	}
	else if (Status==SAMPLE_FILE_DATA_FORMAT_UNSUPPORTED)
	{
		Error("The sample data is in a unsupported format!");
	}
	else if (Status==SAMPLE_FILE_NO_DATA)
	{
		Error("The sample file is empty!");
	}
}

void	DisplaySampleDescription(SampleDescription *desc)
{
	printf("\nType: %s\n",desc->handler.Description);
	printf("Duration: %02d hrs %02d mins %02d.%02d secs\n",desc->duration.Hours, desc->duration.Minutes, desc->duration.Seconds,desc->duration.FractionalSeconds);
	printf("Rate: %d Hz\n",desc->Rate);

}

int main(int argc, char *argv[])
{
	printf("\nZXTape Utilities - VOC/CSW/WAV/IFF/AIFF to TZX/CDT Converter (CPC Version)\n(Build %s)\n",__DATE__);
	
	if (argc==1)
	{
		int i;
		printf("\nUsage: SAMP2CDT [switches] [Input Sample] [Output CDT/TZX]\n");
		printf("\nSwitches:\n\n");

		for (i=0; i<sizeof(options)/sizeof(options[0]); i++)
		{
			printf("/%s  %s\n", options[i].optionname,options[i].optiondesc);
		}
	}
	else
	{
		int *fileIndexs = NULL;
		int files;	
	
		files = 0;
		fileIndexs = (int *)malloc(sizeof(int)*argc);

		if (fileIndexs!=NULL)
		{
			//sf_detect = 1;
			ldrend = -1;
			slockmain = -1;
			ldrskip = -1;
			ldrtype = -1;
			write_initial_pause = 1;
			display_initial_pause = 1;
			actioncur = ACTION_DEFAULT;
			slblock = -1;

			/* process unknown initially */
			ldrcur = LDR_UNKNOWN;	

			for (n=1; n<argc; n++)
			{
				/* switch? */
				if (argv[n][0]=='/')
				{
					int bOptionFound = 0;
					int i;

					/* scan table to find if it is handled */
					for (i=0; i<sizeof(options)/sizeof(options[0]); i++)
					{
						/* text matches? */
						if (strcmp(&argv[n][1], options[i].optionname)==0)
						{
							/* handle switch */
							n = options[i].optionfunction(argv, argc, n);

							/* option found */
							bOptionFound = 1;

							/* stop searching */
							break;
						}
					}

					if (!bOptionFound)
					{
						invalidoption(argv[1]);
						break;
					}
				}
				else
				{
					/* treat it as a file; add index of string into list */
					fileIndexs[files] = n;
					files++;
				}
			}

			finp = NULL;
			fout = NULL;

			switch (files)
			{
				case 0:
				{	
					Error("No Files specified !");
				}
				break;

				case 1:
				{
					char *filename;
					int filenameLength;

					/* get first filename */
					filename = argv[fileIndexs[0]];

					filenameLength = strlen(filename);

					if (filenameLength!=0)
					{
						finp = (char *)malloc(filenameLength+1);

						if (finp!=NULL)
						{
							memcpy(finp, filename, filenameLength+1);
						}
					}

					if (finp!=NULL)
					{
						char *newExtension = "cdt";
						int existingExtensionLength;
						int newExtensionLength;
						int additionalCharactersRequired;
						
						existingExtensionLength = GetExtensionLength(finp);

						newExtensionLength = strlen(newExtension);

						if (existingExtensionLength==0)
						{
							additionalCharactersRequired = newExtensionLength+1;
						}
						else
						{
							additionalCharactersRequired = 0;
							if (existingExtensionLength<newExtensionLength)
							{
								additionalCharactersRequired = newExtensionLength-existingExtensionLength;
							}
						}

						fout = (char *)malloc(filenameLength+1+additionalCharactersRequired);

						if (fout!=NULL)
						{
							memcpy(fout, filename, filenameLength+1);

							if (existingExtensionLength==0)
							{
								strcat(fout,".");
								strcat(fout,newExtension);
							}
							else
							{
								ChangeFileExtension(fout,"cdt");
							}
						}
					}
				}
				break;

				case 2:
				{
					char *filename;
					int filenameLength;

					/* get first filename */
					filename = argv[fileIndexs[0]];

					filenameLength = strlen(filename);

					finp = (char *)malloc(filenameLength+1);

					if (finp!=NULL)
					{
						memcpy(finp, filename, filenameLength+1);
					}

					/* get second filename */
					filename = argv[fileIndexs[1]];

					filenameLength = strlen(filename);

					fout = (char *)malloc(filenameLength+1);

					if (fout!=NULL)
					{
						memcpy(fout, filename, filenameLength+1);
					}
				}
				break;


				default:
				{
					Error("Too Many files on command line!");
				}
				break;
			}

			if ((finp!=NULL) && (fout!=NULL))
			{

				// test file exists
				{
					FILE *fh;

					fh = fopen(finp, "rb");

					if (fh==NULL)
					{
						Error("File not found!");
					}
					else
					{
						int Status;
		
						fclose(fh);

						Status = SampleFile_Open(finp, &desc);

						if (Status==SAMPLE_FILE_OK)
						{
							DisplaySampleDescription(&desc);
							sample_frequency = desc.Rate;
							PulseBuffer_Init(&pulseBuffer,4096);
							Convert();
							PulseBuffer_Free(&pulseBuffer);
							SampleFile_Close(&desc);
					//		free(raw);
						}
						else
						{
							HandleError(Status);
						}
					}
				}
			}
		}

		if (fileIndexs!=NULL)
		{
			free(fileIndexs);
			fileIndexs = NULL;
		}
	
		/* free input filename */
		if (finp!=NULL)
		{
			free(finp);
			finp = NULL;
		}

		/* free output filename */
		if (fout!=NULL)
		{
			free(fout);
			fout = NULL;
		}

	}

#if VOC2TZX6	
	{
		int n;

		for (n=0; n<42; n++)
		{
			sync_averages[n]/=syncs_counted;
		}
	}
#endif

	exit(0);
}
