;; A NEC765 emulation tester (c) Kevin Thacker 2002
;;
;; written for the Amstrad CPC
;;
;; uses Maxam assembler syntax, assembleable on Winape32 emulator
;; winape.emuunlim.com
;;
;; not tested:
;;
;; - terminal count input to NEC765 (not connected on Amstrad CPC)
;; - effect of resetting NEC765 during commands (not connected on Amstrad CPC)
;; - some effects of changing density (CPC has a fixed 4Mhz clock input
;;   to the fdc)
;; - DMA operation (not connect on Amstrad CPC)

org &1000
nolist
write"test.bin"

;; disc format:
;;
;; track 0 side 0:
;; 0,0,&41,2
;; 0,0,&42,2
;; 0,0,&43,2
;; 0,0,&44,2
;; 0,0,&45,2
;; 0,0,&46,2
;; 0,0,&47,2
;; 0,0,&48,2
;; 0,0,&49,2

;; track 0 side 1:
;; 0,1,&41,2
;; 0,1,&42,2
;; 0,1,&43,2
;; 0,1,&44,2
;; 0,1,&45,2
;; 0,1,&46,2
;; 0,1,&47,2
;; 0,1,&48,2
;; 0,1,&49,2


;; disc format:
;;
;; track 1 side 0:
;; 1,0,&41,2
;; 1,0,&42,2
;; 1,0,&43,2
;; 1,0,&44,2
;; 1,0,&45,2
;; 1,0,&46,2
;; 1,0,&47,2
;; 1,0,&48,2
;; 1,0,&49,2

;; track 1 side 1:
;; 1,1,&1,2
;; 1,1,&2,2
;; 1,1,&3,2
;; 1,1,&4,2
;; 1,1,&5,2
;; 1,1,&6,2
;; 1,1,&7,2
;; 1,1,&8,2
;; 1,1,&9,2


;; disc format:
;;
;; track 2 side 0:
;; 2,0,&1,2
;; 2,0,&2,2
;; 2,0,&3,2
;; 2,0,&4,2
;; 2,0,&5,2
;; 2,0,&6,2
;; 2,0,&7,2
;; 2,0,&8,2
;; 2,0,&9,2

;; track 2 side 1:
;; 2,1,&1,2
;; 2,1,&2,2
;; 2,1,&3,2
;; 2,1,&4,2
;; 2,1,&5,2
;; 2,1,&6,2
;; 2,1,&7,2
;; 2,1,&8,2
;; 2,1,&9,2


;; disc format:
;;
;; track 3 side 0:
;; 3,0,&1,2
;; 3,0,&2,2
;; 3,0,&3,2
;; 3,0,&4,2
;; 3,0,&5,2
;; 3,0,&6,2
;; 3,0,&7,2
;; 3,0,&8,2
;; 3,0,&9,2

;; track 3 side 1:
;; 4,1,&1,2
;; 4,1,&2,2
;; 4,1,&3,2
;; 4,1,&4,2
;; 4,1,&5,2
;; 4,1,&6,2
;; 4,1,&7,2
;; 4,1,&8,2
;; 4,1,&9,2


;; track 4:
;; 0,0,1,3			- DATA ERROR! (but formatted with size 2)

;; disc format:
;;
;; track 5 side 0:
;; 5,1,&1,2
;; 5,1,&2,2
;; 5,1,&3,2
;; 5,1,&4,2
;; 5,1,&5,2
;; 5,1,&6,2
;; 5,1,&7,2
;; 5,1,&8,2
;; 5,1,&9,2

;; track 5 side 1:
;; 5,0,&1,2
;; 5,0,&2,2
;; 5,0,&3,2
;; 5,0,&4,2
;; 5,0,&5,2
;; 5,0,&6,2
;; 5,0,&7,2
;; 5,0,&8,2
;; 5,0,&9,2


;; track 7:
;; 
;; 07,00,c1,06			- DATA ERROR

;; track 8:
;;
;; unformatted
;;
;; track 15:
;; 15,0,1,0		- 128 bytes per sector
;; 15,0,2,0		- 128 bytes per sector
;; 15,0,3,0		- 128 bytes per sector
;; 15,0,4,0		- 128 bytes per sector
;; 15,0,5,0		- 128 bytes per sector
;; 15,0,6,0		- 128 bytes per sector
;; 15,0,7,0		- 128 bytes per sector
;; 15,0,8,0		- 128 bytes per sector
;; 15,0,9,0		- 128 bytes per sector
;; 15,0,10,0		- 128 bytes per sector
;; 15,0,11,0		- 128 bytes per sector
;; 15,0,12,0		- 128 bytes per sector
;; 15,0,13,0		- 128 bytes per sector
;; 15,0,14,0		- 128 bytes per sector
;; 15,0,15,0		- 128 bytes per sector
;; 15,0,16,0		- 128 bytes per sector

;; track 10:
;; 
;; sector ids:
;;
;; 10,0,1,2		- 512 bytes - data mark
;; 10,0,2,2		- 512 bytes - deleted data mark
;; 10,0,3,2		- 512 bytes - data mark
;; 10,0,4,2		- 512 bytes - deleted data mark
;; 10,0,5,2		- 512 bytes - data mark
;; 10,0,6,2		- 512 bytes - deleted data mark
;; 10,0,7,2		- 512 bytes - data mark
;; 10,0,8,2		- 512 bytes - deleted data mark
;; 10,0,9,2		- 512 bytes - data mark
;;
;; track 11:
;;
;; sector ids:
;;
;; 11,0,C1,2		- 512 bytes - data mark
;; 11,0,C2,2		- 512 bytes - data mark
;; 11,0,C3,2		- 512 bytes - data mark
;; 11,0,C4,2		- 512 bytes - data mark
;; 11,0,C5,2		- 512 bytes - data mark
;; 11,0,C6,2		- 512 bytes - data mark
;; 11,0,C7,2		- 512 bytes - data mark
;; 11,0,C8,2		- 512 bytes - data mark
;; 11,0,C9,2		- 512 bytes - data mark
;;
;;
;; track 12:
;;
;; sector ids:
;; 
;; ff,0,c1,2		- 512 bytes - data mark (bad cylinder comparison)
;; 20,20,20,2		- 512 bytes - data mark

;; track 13:
;; 13,0,1,1		- 256 bytes per sector
;; 13,0,2,1		- 256 bytes per sector
;; 13,0,3,1		- 256 bytes per sector
;; 13,0,4,1		- 256 bytes per sector
;; 13,0,5,1		- 256 bytes per sector
;; 13,0,6,1		- 256 bytes per sector
;; 13,0,7,1		- 256 bytes per sector
;; 13,0,8,1		- 256 bytes per sector
;; 13,0,9,1		- 256 bytes per sector
;; 13,0,10,1		- 256 bytes per sector
;; 13,0,11,1		- 256 bytes per sector
;; 13,0,12,1		- 256 bytes per sector
;; 13,0,13,1		- 256 bytes per sector
;; 13,0,14,1		- 256 bytes per sector
;; 13,0,15,1		- 256 bytes per sector
;; 13,0,16,1		- 256 bytes per sector


;; track 20:
;; - used by format test -

;;---------------------------------------------------------------------------


.main_loop
call do_menu
jp main_loop


.do_menu
;; display options
ld hl,option1
call display_string
call display_newline
ld hl,option2
call display_string
call display_newline
;; wait for key
call wait_char
cp "1"
jp z,init_test_disk
cp "2"
jp z,do_test
ret


.do_test
ld hl,drive_txt
call display_string
call display_newline
call wait_char
sub '0'
ld (drive),a

ld ix,tests			;; list of test functions
xor a
.do_tests
ld l,(ix+0)			;; get address of test function
ld h,(ix+1)
inc ix
inc ix
push af
ld a,h
or l
jp z,complete				;; end of list?
pop af
push af
;; show test code
call display_hex
ld a,':'
call display_char

push ix
;; clear error code
call clear_error

di
call exec_test		;; execute test
ei
pop ix

ld a,(error_flag)
or a
;; display pass/fail message
ld hl,test_pass
jr z,display_result
ld hl,test_fail
.display_result
call display_string

;; display the error code
ld a,(error_flag)
or a
jr z,dr2
push af
ld a,' '
call display_char
pop af
call display_hex
.dr2

call display_newline
call wait_char
pop af
inc a
jp do_tests

.complete
pop af
ld hl,complete_txt
call display_string
call display_newline
call wait_char
ret


.error_flag defb 0

.complete_txt
defb "COMPLETE!",0

.option1
defb "1. FORMAT TEST DISC",0
.option2
defb "2. DO TEST",0

.drive_txt
defb "DRIVE (0 or 1)?",0

.test_pass
defb "PASS",0

.test_fail
defb "FAIL",0


.drive
defb 0


;; set error if not already set
;; so this will be the first reported error
.set_error
push de
ld e,a
ld a,(error_flag)
or a
jr nz,se2
ld a,e
ld (error_flag),a
.se2
pop de
ret

.clear_error
xor a
ld (error_flag),a
ret

.exec_test
jp (hl)

.tests
;; all tests on connected drive

defw recal_test			;; look for equipment check after 77 tracks
defw recal_nr			;; attempt a recalibrate when not ready
defw recal_test2		;; attempt recalibrate using side 1

defw seek_test1			;; look for fdd busy flag
defw seek_test2			;; look for fdc busy set/clear
defw seek_test3			;; fdd goes busy if already on track?
defw seek_test4			;; do a seek, wait a long time for it to complete, then
						;; attempt a read command - should be allowed
defw seek_test5			;; do a long seek, attempt a read command immediatly -
						;; should not be allowed
defw seek_test6			;; check if fdd busy is cleared after seek without
						;; doing a sense interrupt status
defw seek_test7			;; do a long seek, then attempt a shorter seek on same
						;; drive
defw seek_nr			;; attempt a seek when not ready
defw seek_rc			;; attempt a seek but change ready
defw seek_test8			;; attempt seek using side 1

defw sense_intr1		;; do a seek and wait for it to end with a sense interrupt
						;; status. Then do one more sense interrupt status which
						;; should return an error
defw sense_intr2		;; enable motor, wait for ready, then turn off, and do a sense
						;; interrupt status
																								
defw read_data			;; read data
defw read_data_c
;;defw read_data_rc
defw read_data2			;; different H value
defw read_data3			;; different N value
defw read_dtl_data
defw read_de_data		;; data error
defw read_nr_data		;; not ready
defw read_data_sis		;; do a read data followed by a sense interrupt status

defw read_data_eot		;; read data with eot
defw read_data_unform	;; read data on unformatted track
defw read_data_noskip	;; read data, no skip

defw read_del_data_skip	;; read deleted data sectors with skip
						;; starts and ends on a deleted data sector

defw read2_del_data_skip ;; read deleted data; only 1 sector and that has data in it!!!
defw read3_del_data_skip ;; read deleted data, first is deleted, second is data!
defw read4_del_data_skip ;; read deleted data, first is data, second is deleted, third is data!
defw read_data_skip		;; read data, and skip deleted data sectors!
defw read_data_skip2		;; read data; only 1 sector and that has deleted data in it!!!!
defw read_deleted_data_using_data ;; read deleted data sector using data command
defw read_data_using_deleted_data ;; read data sector using deleted data command
defw read_track1		;; read first sector from track, comparison must succeed
defw read_track2		;; read first sector from track, comparison must fail
defw read_track3		;; read first sector from track, comparison must fail
defw read_track4		;; read more than the number of sectors on the track
defw read_track0		;; EOT is 0
 
defw read_track6		;; see how C,H,R,N in result is generated
defw read_track5		;; N is 0, and DTL is !=0, and 1 sector is read
defw read_track10
defw read_track_unform
defw read_track7 		;; read track with skip
defw read_track8		;; read track on deleted data track
defw read_track9		;; read track with multi-track (starting side 0)
defw read_track11		;; read track with multi-track (starting side 1)
defw read_track12		;; read track on track with data error
defw read_track13		;; read track on track with data error (read 2 sectors)
defw read_track14		;; read track (formatted size 2), N in read track as 3
defw read_track_nr		;; read track but not ready

defw read_data_mt		;; multi-track operation - same id's on side 0 and side 1 (41-49)
defw read_data_mt2		;; multi-track operation - different id's on side 0 and side 1 (41-49,1-9)

defw read_data_mt3		;; multi-track operation - same id's on side 0 and side 1 (1-9)

defw read_data_mt4		;; multi-track operation - start from side 2
defw read_data_mt5		;; multi-track operation - eot doesn't exist
defw read_data_mt6		;; multi-track operation - small eot (3)
defw read_data_mt7		;; multi-track operation - bad cylinder on second side
defw read_data_mt8		;; multi-track operation - h is 1 on side 0
defw read_data_mt9		;; multi-track operation - h is 0 on side 1
defw read_data_mt10		;; multi-track operation - h value is &fe on one side &ff on other
defw read_data_ov		;; read data overrun

defw test_write			;; write data test
defw test_write_c			;; write data test
defw test_write_rc
defw test_write2		;; write deleted data mark
defw test_write_nr		;; write test when not ready
defw test_write_mt		;; write test with multi-track
defw test_write_sk		;; write test with skip
defw test_write_ov		;; write test overrun

;; these depend on last valid c,h,r,n values??
defw read_id_unform		;; test read id on a unformatted track
defw read_id2_unform	;; test read id " "
defw read_id_low		;; read id of formatted track using low density
defw read_id_de			;; read id on track with data error
defw read_id_nr			;; read id when not ready
defw read_id_rc			;; read id but ready will change state

defw read_data_low		;; read data from formatted track using low density
defw bad_cylinder
defw bad2_cylinder
defw bad3_cylinder
defw bad4_cylinder
defw bad5_cylinder		;; write on wrong cylinder
defw bad6_cylinder		;; write on bad cylinder


defw specify

defw nodata1
defw invalid
defw drive_status1		;; ready/not ready
defw drive_status2		;; track 0/not track 0
defw sync_start_of_track
defw format1			;; format test
defw format_nr			;; format, not ready

defw check_dtl_00
defw check_dtl1
defw check_dtl2
defw check_dtl3

defw scan_equal			;; comparison must be equal
defw format2			;; format different sector sizes, read back to get sector sizes

;;defw scan_equal2		;; comparison must be not equal
;;defw scan_equal3		;; complete buffer of mask bytes; scan must equal
defw 0


;;-------------------------------------------------------
;; this mask is used on the fdc main status register
;; to isolate the fdc busy state
;;
;; A = busy mask

.get_drive_busy_mask

;; get drive number
ld a,(drive)
or a					;; drive 0?
ld a,1					;; return mask for drive 0
ret z

;; calculate mask
push bc
ld b,a
ld a,1					;; initial mask (drive 0)
.gdbm add a,a			;; shift the bit up
djnz gdbm				;; decrement for drive
pop bc
ret



;;-------------------------------------------------------
;; 
;; move to track 0
;;
;; then start a long seek e.g. 0->39
;; check if corresponding fdd busy has been set



.seek_test1
;; start motor
call start_drive_motor

;; move read/write head to track 0
call move2track0

;; get fdd busy mask
call get_drive_busy_mask
ld e,a

;; if busy, quit with error
call fdc_read_main_status_register
;; %10000000

and e

ld a,1							
call nz,set_error

;; do seek to track 39

ld a,%1111						;; seek
call send_command_byte
ld a,(drive)					;; drive
call send_command_byte
ld a,39							;; destination track
call send_command_byte

;; if not busy, quit with error
call fdc_read_main_status_register

;; %10010010 (drive 1)

and e
ld a,2
call z,set_error

call wait_for_seek_end

;; get fdd busy mask
call get_drive_busy_mask
ld e,a

;; if still busy, quit with error
call fdc_read_main_status_register
;; %10000000

and e
ld a,3
call nz,set_error

call stop_drive_motor
ret


.seek_test8
;; start motor
call start_drive_motor

;; move read/write head to track 0
call move2track0

;; do seek to track 39

ld a,%1111						;; seek
call send_command_byte
ld a,(drive)					;; drive
or 4
call send_command_byte
ld a,39							;; destination track
call send_command_byte

call wait_for_seek_end
ld ix,result_data
ld a,(ix+0)
and %11111000
cp &20
ld a,1
call nz,set_error
ld a,(ix+1)
cp 39
ld a,2
call nz,set_error

;;call dump_results

call stop_drive_motor
ret

.seek_nr
call stop_drive_motor

;; do seek to track 39

ld a,%1111						;; seek
call send_command_byte
ld a,(drive)					;; drive
call send_command_byte
ld a,39							;; destination track
call send_command_byte

ld a,%1000						;; sense interrupt status
call send_command_byte
call fdc_result_phase
;;call dump_results
ld ix,result_data
ld a,(ix+0)
and %11111000
cp &68
ld a,1
call nz,set_error
ld a,(ix+1)
or a
ld a,2
call nz,set_error

ret


.seek_rc
call start_drive_motor
call move2track0

;; do seek to track 39

ld a,%1111						;; seek
call send_command_byte
ld a,(drive)					;; drive
call send_command_byte
ld a,39							;; destination track
call send_command_byte

call stop_drive_motor

ld a,%1000						;; sense interrupt status
call send_command_byte
call fdc_result_phase
;; 80
call dump_results
ret

;;------------------------------------------------------------------------------
;; 
;; test if fdc busy flag is set after first command byte, and then cleared
;; when execution phase of seek has begun

.seek_test2
;; start motor
call start_drive_motor

;; move read/write head to track 0
call move2track0

;; start seek command
ld a,%1111						;; seek
call send_command_byte

;; check if fdc busy is set
call fdc_read_main_status_register

;; %10010000

bit 4,a
ld a,1
call z,set_error

ld a,(drive)					;; drive
call send_command_byte
ld a,39							;; destination track
call send_command_byte

ld b,3
.st2a
ld hl,0
.st2b
dec hl
ld a,h
or l
jr nz,st2b
djnz st2a

;; check if fdc busy is now cleared
call fdc_read_main_status_register

;; %10010000

bit 4,a
ld a,2
call nz,set_error

call wait_for_seek_end

call get_drive_busy_mask
ld e,a

call fdc_read_main_status_register
;; %10000000
and e
ld a,3
call nz,set_error

call stop_drive_motor
ret

;;----------------------------------------------------------
.seek_test3
call start_drive_motor

call move2track0

;; get fdd busy mask
call get_drive_busy_mask
ld e,a

;; %10000000

;; error if fdd is busy
call fdc_read_main_status_register

and e
ld a,1
call nz,set_error

;; start seek
ld a,%1111
call send_command_byte
ld a,(drive)
call send_command_byte
ld a,0
call send_command_byte

call get_drive_busy_mask
ld e,a

;; error if fdd is not busy
call fdc_read_main_status_register

and e
ld a,2
call z,set_error

call wait_for_seek_end

call get_drive_busy_mask
ld e,a

;; error if fdd is busy!!
;; should be clear again
call fdc_read_main_status_register
;; %10000000
and e
ld a,3
call nz,set_error

call stop_drive_motor
ret

;;---------------------------------------------------------------------------
;; do a short seek and wait for it to complete
;;
;; do a read id (should succeed!)

;; 12, 02, 01,00,00,02,00,03,02
;; 11, 01, 00,00,00,00,00,aa,03

.seek_test4
call start_drive_motor

call move2track0

ld a,%1111
call send_command_byte
ld a,(drive)
call send_command_byte
ld a,2
call send_command_byte

;; a big delay to wait for seek to complete
ld b,6
.st4
ld hl,0
.st3
dec hl
ld a,h
or l
jr nz,st3
djnz st4

;; %10000010

ld a,%01001010			;; read id
call send_command_byte

;; read main status register
call fdc_read_main_status_register
call display_hex

;; %00010010

;;and %11110000
;;cp %00010000

;;ld a,1					;; error!
;;call z,set_error
;;jp z,st42				;; get result

;; send second byte of id command
ld a,(drive)			;; drive
call send_command_byte

call get_drive_busy_mask
ld e,a

;; read main status register
call fdc_read_main_status_register
and e
call display_hex

.st42
call fdc_result_phase	;; read result
call dump_results

;; if error, then result byte will be invalid, otherwise it will be
;; acceptable

call stop_drive_motor
ret

;;---------------------------------------------------------------------------------
;; do a long seek, then attempt a read id immediatly
;;
;; fdc should return a invalid command

;; 81, 11, 00, 00,00,00,00,aa,03

;; 81, 11
.seek_test5
call start_drive_motor

call move2track0

ld a,%1111
call send_command_byte
ld a,(drive)
call send_command_byte
ld a,39
call send_command_byte

ld hl,&800
.stzz
dec hl
ld a,h
or l
jr nz,stzz


;; get fdd busy mask
call get_drive_busy_mask
ld e,a

;; drive busy must be set

;; read main status register
call fdc_read_main_status_register
call display_hex
;; 02


ld a,%01001010			;; read id
call send_command_byte

;; must still be busy
;; read main status register
call fdc_read_main_status_register
call display_hex
;; 02

;; send second byte of id command
ld a,(drive)			;; drive
call send_command_byte

;;.st52
call fdc_result_phase	;; read result
call dump_results
;; 01,00,00,01,00,42,02
;; 00 00 00 00 00 aa,03

call start_drive_motor

call move2track0

call stop_drive_motor
ret

;;---------------------------------------------------------------------------
;; do a short seek and wait for it to complete
;;
;; test state of fdd busy state

.seek_test6
call start_drive_motor

call move2track0

ld a,%1111					;; seek
call send_command_byte
ld a,(drive)				;; drive
call send_command_byte
ld a,2						;; track
call send_command_byte

;; a big delay to wait for seek to complete
ld b,6
.st6
ld hl,0
.st6b
dec hl
ld a,h
or l
jr nz,st6b
djnz st6

;; get busy mask
call get_drive_busy_mask
ld e,a
;; get busy state of fdd
call fdc_read_main_status_register
and e
ld a,1
call z,set_error

call fdc_read_main_status_register
and %11110000
cp %10000000
ld a,2
call nz,set_error

call stop_drive_motor
ret

;;-------------------------------------------------------
.seek_test7
call start_drive_motor

call move2track0


ld a,%1111					;; seek
call send_command_byte
ld a,(drive)				;; drive
call send_command_byte
ld a,39						;; track
call send_command_byte

;; short delay
ld hl,0
.st7 dec hl
ld a,h
or l
jr nz,st7

ld a,%1111
call send_command_byte

call get_drive_busy_mask
ld e,a
;; invalid?
call fdc_read_main_status_register
and e
ld a,1
call z,set_error
call fdc_read_main_status_register
and %11110000
cp &90
ld a,2
call nz,set_error

ld a,(drive)				;; drive
call send_command_byte
ld a,0						;; track
call send_command_byte

call wait_for_seek_end		;; wait for seek to complete

call stop_drive_motor

ret

.st7b
call fdc_result_phase
call wait_for_seek_end
call stop_drive_motor
ret

;;-------------------------------------------------------
;; do a seek; which is guaranteed to allow a sense interrupt status
;; to return the current track position
;;
;; furthur sense interrupt status commands should return invalid
;; command

.sense_intr1
call start_drive_motor
call move2track0

ld a,%1111					;; seek
call send_command_byte
ld a,(drive)
call send_command_byte
ld a,39
call send_command_byte	

call wait_for_seek_end		;; wait for seek to complete

ld a,%1000					;; sense interrupt status
call send_command_byte
call fdc_result_phase

;; must be *1* result byte only!!!!
ld a,b
cp 1
ld a,1
call nz,set_error

;;call dump_results

;; ST0 reports invalid??
ld ix,result_data
ld a,(ix+0)
cp &80
ld a,2
call nz,set_error

call stop_drive_motor
ret


.sense_intr2
call start_drive_motor

call stop_drive_motor

ld a,%1000					;; sense interrupt status
call send_command_byte
call fdc_result_phase
;;call dump_results
ld ix,result_data
ld a,(ix+0)
and %11111000
cp &c0
ld a,1
call nz,set_error


ret



;;-------------------------------------------------------
;; 
;; this test is used to check for a nec765a
;; 
;; - seek to track 79
;; - start a recalibrate which should fail after 77 tracks

.recal_test
ld a,(drive)
or a
ld a,99
call z,set_error
ret z

call start_drive_motor

;; seek to 80th track
ld a,79
call move2track

;; do a recalibrate
ld a,%111
call send_command_byte
ld a,(drive)
call send_command_byte

;; do sense interrupt status
.rt1
ld a,%1000
call send_command_byte
call fdc_result_phase

;; wait for seek end flag to be set
ld ix,result_data
bit 5,(ix+0)
jr z,rt1

ld a,b
cp 2
ld a,1
call nz,set_error

;; at this point the seek should have completed.
ld a,(ix+0)
and %11111000
cp %01110000				;; check for: 
						;; - abnormal termination of command, 
						;; - seek end
						;; - equipment check
ld a,2
call nz,set_error

;; bottom 2 bits must be drive index
ld a,(drive)
ld c,a
ld a,(ix+0)
and &3
cp c
ld a,3
call nz,set_error

;; must return 0 as track number
ld a,(ix+1)
or a
ld a,4
call nz,set_error

call stop_drive_motor
ret


.recal_test2
call start_drive_motor

call move2track0
ld a,39
call move2track

;; do a recalibrate
ld a,%111
call send_command_byte
ld a,(drive)
or 4
call send_command_byte

call wait_for_seek_end
;; 20 00
;;call dump_results
ld ix,result_data
ld a,(ix+0)
and %11111000
cp &20
ld a,1
call nz,set_error
;;ld a,(ix+1)
;;or a
;;ld a,2
;;call nz,set_error

call stop_drive_motor
ret

.recal_nr
call start_drive_motor

call move2track0
ld a,39
call move2track

call stop_drive_motor

;; do a recalibrate
ld a,%111
call send_command_byte
ld a,(drive)
call send_command_byte

call fdc_read_main_status_register
and %11110000
cp &90
ld a,3
call nz,set_error
;; 0x090

;; do sense interrupt status
ld a,%1000
call send_command_byte
call fdc_result_phase
;;call dump_results
;; 68 00 

ld ix,result_data
ld a,(ix+0)
and %11111000
cp &68
ld a,1
call nz,set_error
ld a,(ix+1)
or a
ld a,2
call nz,set_error

call stop_drive_motor
ret

;;---------------------------------------------------------------------------------
;; use "read deleted data" and skip sectors with data in them
;; first and last sector contains deleted data!!!

.read_del_data_skip
call start_drive_motor

ld a,10
call move2track

ld a,%01101100				;; read deleted data, mfm, skip
call send_command_byte
ld a,(drive)
call send_command_byte
ld a,10						;; C
call send_command_byte
ld a,0						;; H
call send_command_byte
ld a,2						;; R
call send_command_byte
ld a,2						;; N
call send_command_byte
ld a,8						;; EOT
call send_command_byte
ld a,&2a					;; GPL
call send_command_byte
ld a,&ff					;; dtl
call send_command_byte

;; read data but not into memory
ld de,0
call fdc_read_data2
;; should have read 4 sectors of data
ex de,hl
ld bc,4*512
or a
sbc hl,bc
ld a,h
or l
ex de,hl
ld a,1
call nz,set_error

call fdc_result_phase
ld a,b
cp 7
ld a,9
call nz,set_error

;; 41 80 40 0a 00 08 02
ld ix,result_data
ld a,(ix+3)
cp &a
ld a,2
call nz,set_error
ld a,(ix+4)
or a
ld a,3
call nz,set_error
ld a,(ix+5)
cp 8
ld a,4
call nz,set_error
ld a,(ix+6)
cp 2
ld a,5
call nz,set_error
ld a,(ix+2)
cp &40
ld a,6
call nz,set_error
ld a,(ix+1)
cp &80
ld a,7
call nz,set_error
ld a,(ix+0)
and %11111000
cp &40
ld a,8
call nz,set_error

call stop_drive_motor
ret


;;---------------------------------------------------------------------------------
;; use "read deleted data" and skip sectors with data in them
;; first and only sector contains data!!!

.read2_del_data_skip
call start_drive_motor

ld a,10
call move2track

ld a,%01101100				;; read deleted data, mfm, skip
call send_command_byte
ld a,(drive)
call send_command_byte
ld a,10						;; C
call send_command_byte
ld a,0						;; H
call send_command_byte
ld a,1						;; R
call send_command_byte
ld a,2						;; N
call send_command_byte
ld a,1						;; EOT
call send_command_byte
ld a,&2a					;; GPL
call send_command_byte
ld a,&ff					;; dtl
call send_command_byte

;; read data but not into memory
ld de,0
call fdc_read_data2
ld a,d
or e
ld a,1
call nz,set_error

call fdc_result_phase
ld a,b
cp 7
ld a,9
call nz,set_error

ld ix,result_data
ld a,(ix+3)
cp &0a
ld a,2
call nz,set_error
ld a,(ix+4)
or a
ld a,3
call nz,set_error
ld a,(ix+5)
cp 1
ld a,4
call nz,set_error
ld a,(ix+6)
cp 2
ld a,5
call nz,set_error
ld a,(ix+2)
cp &40
ld a,6
call nz,set_error
ld a,(ix+1)
cp &80
ld a,7
call nz,set_error
ld a,(ix+0)
and %11111000
cp &40
ld a,8
call nz,set_error

call stop_drive_motor
ret

;;---------------------------------------------------------------------------------
;; use "read deleted data" and skip sectors with data in them
;; first is deleted data, second is data

.read3_del_data_skip
call start_drive_motor

ld a,10
call move2track

ld a,%01101100				;; read deleted data, mfm, skip
call send_command_byte
ld a,(drive)
call send_command_byte
ld a,10						;; C
call send_command_byte
ld a,0						;; H
call send_command_byte
ld a,2						;; R
call send_command_byte
ld a,2						;; N
call send_command_byte
ld a,3						;; EOT
call send_command_byte
ld a,&2a					;; GPL
call send_command_byte
ld a,&ff					;; dtl
call send_command_byte

;; read data but not into memory
ld de,0
call fdc_read_data2
;; should have read 1 sectors of data
ex de,hl
ld bc,512
or a
sbc hl,bc
ld a,h
or l
ex de,hl
ld a,1
call nz,set_error

call fdc_result_phase
ld a,b
cp 7
ld a,9
call nz,set_error

ld ix,result_data
;; 41, 80, 40, 0a, 00,03,02
ld a,(ix+3)
cp &0a
ld a,2
call nz,set_error
ld a,(ix+4)
cp &00
ld a,3
call nz,set_error
ld a,(ix+5)
cp &03
ld a,4
call nz,set_error
ld a,(ix+6)
cp &2
ld a,5
call nz,set_error
ld a,(ix+2)
cp &40
ld a,6
call nz,set_error
ld a,(ix+1)
cp &80
ld a,7
call nz,set_error
ld a,(ix+0)
and %11111000
cp &40
ld a,8
call nz,set_error
call stop_drive_motor
ret


;;---------------------------------------------------------------------------------
;; use "read deleted data" and skip sectors with data in them
;; first is data, second is deleted data, last is data

.read4_del_data_skip
call start_drive_motor

ld a,10
call move2track

ld a,%01101100				;; read deleted data, mfm, skip
call send_command_byte
ld a,(drive)
call send_command_byte
ld a,10						;; C
call send_command_byte
ld a,0						;; H
call send_command_byte
ld a,3						;; R
call send_command_byte
ld a,2						;; N
call send_command_byte
ld a,5						;; EOT
call send_command_byte
ld a,&2a					;; GPL
call send_command_byte
ld a,&ff					;; dtl
call send_command_byte

;; read data but not into memory
ld de,0
call fdc_read_data2
;; should have read 1 sectors of data
ex de,hl
ld bc,512
or a
sbc hl,bc
ld a,h
or l
ex de,hl
ld a,1
call nz,set_error

call fdc_result_phase
ld a,b
cp 7
ld a,9
call nz,set_error

;; 41,80,40,0a,00,05,02

ld ix,result_data
ld a,(ix+3)
cp &0a
ld a,2
call nz,set_error
ld a,(ix+4)
or a
ld a,3
call nz,set_error
ld a,(ix+5)
cp 5
ld a,4
call nz,set_error
ld a,(ix+6)
cp 2
ld a,5
call nz,set_error
ld a,(ix+2)
cp &40
ld a,6
call nz,set_error
ld a,(ix+1)
cp &80
ld a,7
call nz,set_error
ld a,(ix+0)
and %11111000
cp &40
ld a,8
call nz,set_error

call stop_drive_motor
ret


;;---------------------------------------------------------------------------------
.read_data_noskip
call start_drive_motor

ld a,10
call move2track

ld a,%01000110				;; read data, mfm
call send_command_byte
ld a,(drive)
call send_command_byte
ld a,10						;; C
call send_command_byte
ld a,0						;; H
call send_command_byte
ld a,1						;; R
call send_command_byte
ld a,2						;; N
call send_command_byte
ld a,9						;; EOT
call send_command_byte
ld a,&2a					;; GPL
call send_command_byte
ld a,&ff					;; dtl
call send_command_byte

;; read data but not into memory
ld de,0
call fdc_read_data2
;; should have read 2 sectors of data
ex de,hl
ld bc,2*512
or a
sbc hl,bc
ld a,h
or l
ex de,hl
ld a,1
call nz,set_error
call fdc_result_phase
ld a,b
cp 7
ld a,9
call nz,set_error
;; 01,00,40,0a,00,02,02

ld ix,result_data
ld a,(ix+3)
cp &0a
ld a,2
call nz,set_error
ld a,(ix+4)
or a
ld a,3
call nz,set_error
ld a,(ix+5)
cp &02
ld a,4
call nz,set_error
ld a,(ix+6)
cp &2
ld a,5
call nz,set_error
ld a,(ix+2)
cp &40
ld a,6
call nz,set_error
ld a,(ix+1)
or a
ld a,7
call nz,set_error
ld a,(ix+0)
and %11111000
or a
ld a,8
call nz,set_error

call stop_drive_motor
ret
;;---------------------------------------------------------------------------------

.read_data_skip
call start_drive_motor

ld a,10
call move2track

ld a,%01100110				;; read data, mfm, skip
call send_command_byte
ld a,(drive)
call send_command_byte
ld a,10						;; C
call send_command_byte
ld a,0						;; H
call send_command_byte
ld a,1						;; R
call send_command_byte
ld a,2						;; N
call send_command_byte
ld a,9						;; EOT
call send_command_byte
ld a,&2a					;; GPL
call send_command_byte
ld a,&ff					;; dtl
call send_command_byte

;; read data but not into memory
ld de,0
call fdc_read_data2
;; should have read 5 sectors of data
ex de,hl
ld bc,5*512
or a
sbc hl,bc
ld a,h
or l
ex de,hl
ld a,1
call nz,set_error

call fdc_result_phase
ld a,b
cp 7
ld a,9
call nz,set_error
;; 41,80,40,0a,00,09,02
;;call dump_results

ld ix,result_data
ld a,(ix+3)
cp &0a
ld a,2
call nz,set_error
ld a,(ix+4)
or a
ld a,3
call nz,set_error
ld a,(ix+5)
cp &09
ld a,4
call nz,set_error
ld a,(ix+6)
cp &2
ld a,5
call nz,set_error
ld a,(ix+2)
cp &40
ld a,6
call nz,set_error
ld a,(ix+1)
cp &80
ld a,7
call nz,set_error
ld a,(ix+0)
and %11111000
cp &40
ld a,8
call nz,set_error

call stop_drive_motor
ret


.read_data_skip2
call start_drive_motor

ld a,10
call move2track

ld a,%01100110				;; read data, mfm, skip
call send_command_byte
ld a,(drive)
call send_command_byte
ld a,10						;; C
call send_command_byte
ld a,0						;; H
call send_command_byte
ld a,2						;; R
call send_command_byte
ld a,2						;; N
call send_command_byte
ld a,2						;; EOT
call send_command_byte
ld a,&2a					;; GPL
call send_command_byte
ld a,&ff					;; dtl
call send_command_byte

;; read data but not into memory
ld de,0
call fdc_read_data2
ld a,d
or e
ld a,1
call nz,set_error

call fdc_result_phase
ld a,b
cp 7
ld a,9
call nz,set_error
;; 41,80,40,0a,00,02,02

ld ix,result_data
ld a,(ix+3)
cp &0a
ld a,2
call nz,set_error
ld a,(ix+4)
or a
ld a,3
call nz,set_error
ld a,(ix+5)
cp 2
ld a,4
call nz,set_error
ld a,(ix+6)
cp &2
ld a,5
call nz,set_error
ld a,(ix+2)
cp &40
ld a,6
call nz,set_error
ld a,(ix+1)
cp &80
ld a,7
call nz,set_error
ld a,(ix+0)
and %11111000
cp &40
ld a,8
call nz,set_error

call stop_drive_motor
ret
;;---------------------------------------------------------------------------------
;; multi-track
.read_data_mt
call start_drive_motor

call move2track0

;; side 1 is &41-&49, side two is &41-&49

;; start side 0
ld a,%11000110				;; read data, mfm, multi-track
call send_command_byte
ld a,(drive)
call send_command_byte
ld a,0						;; C
call send_command_byte
ld a,0						;; H
call send_command_byte
ld a,&41					;; R
call send_command_byte
ld a,2						;; N
call send_command_byte
ld a,&49					;; EOT
call send_command_byte
ld a,&2a					;; GPL
call send_command_byte
ld a,&ff					;; dtl
call send_command_byte

;; read data but not into memory
ld de,0
call fdc_read_data2
;; 0x01200
ex de,hl
ld bc,9*512
or a
sbc hl,bc
ld a,h
or l
ld a,1
call nz,set_error
ex de,hl

call fdc_result_phase
ld a,b
cp 7
ld a,9
call nz,set_error

;; 45,4,0,0,1,1,2
ld ix,result_data
ld a,(ix+3)
or a
ld a,2
call nz,set_error
ld a,(ix+4)
cp 1
ld a,3
call nz,set_error
ld a,(ix+5)
cp 1
ld a,4
call nz,set_error
ld a,(ix+6)
cp 2
ld a,5
call nz,set_error
ld a,(ix+2)
or a
ld a,6
call nz,set_error
ld a,(ix+1)
cp 4
ld a,7
call nz,set_error
ld a,(ix+0)
and %11111100
cp &44
ld a,8
call nz,set_error
ld a,(drive)
ld c,a
ld a,(ix+0)
and %11
cp c
ld a,9
call nz,set_error

call stop_drive_motor
ret

.read_data_mt2
call start_drive_motor

ld a,1
call move2track

;; side 1 is &41-&49, side two is &01-&09

;; start side 0
ld a,%11000110				;; read data, mfm, multi-track
call send_command_byte
ld a,(drive)
call send_command_byte
ld a,1					;; C
call send_command_byte
ld a,0						;; H
call send_command_byte
ld a,&41					;; R
call send_command_byte
ld a,2						;; N
call send_command_byte
ld a,&49					;; EOT
call send_command_byte
ld a,&2a					;; GPL
call send_command_byte
ld a,&ff					;; dtl
call send_command_byte

;; read data but not into memory
ld de,0
call fdc_read_data2
;; 0x02400
ex de,hl
ld bc,18*512
or a
sbc hl,bc
ld a,h
or l
ld a,1
call nz,set_error
ex de,hl

call fdc_result_phase
ld a,b
cp 7
ld a,9
call nz,set_error

;; 45,4,0,1,1,A,2
ld ix,result_data
ld a,(ix+3)
cp 1
ld a,2
call nz,set_error
ld a,(ix+4)
cp 1
ld a,3
call nz,set_error
ld a,(ix+5)
cp &a
ld a,4
call nz,set_error
ld a,(ix+6)
cp 2
ld a,5
call nz,set_error
ld a,(ix+2)
or a
ld a,6
call nz,set_error
ld a,(ix+1)
cp 4
ld a,7
call nz,set_error
ld a,(ix+0)
and %11111100
cp &44
ld a,8
call nz,set_error
ld a,(drive)
ld c,a
ld a,(ix+0)
and %11
cp c
ld a,9
call nz,set_error

call stop_drive_motor
ret


.read_data_mt3
call start_drive_motor

ld a,2
call move2track

;; side 1 is &1-&9, side two is &1-&9

;; start side 0
ld a,%11000110				;; read data, mfm, multi-track
call send_command_byte
ld a,(drive)
call send_command_byte
ld a,2					;; C
call send_command_byte
ld a,0						;; H
call send_command_byte
ld a,&1					;; R
call send_command_byte
ld a,2						;; N
call send_command_byte
ld a,&9					;; EOT
call send_command_byte
ld a,&2a					;; GPL
call send_command_byte
ld a,&ff					;; dtl
call send_command_byte

;; read data but not into memory
ld de,0
call fdc_read_data2
;; 0x02400
ex de,hl
ld bc,18*512
or a
sbc hl,bc
ld a,h
or l
ld a,1
call nz,set_error
ex de,hl

call fdc_result_phase
ld a,b
cp 7
ld a,9
call nz,set_error
;;call dump_results

;; 45,80,00,02,01,09,02
ld ix,result_data
ld a,(ix+3)
cp 2
ld a,2
call nz,set_error
ld a,(ix+4)
cp 1
ld a,3
call nz,set_error
ld a,(ix+5)
cp 9
ld a,4
call nz,set_error
ld a,(ix+6)
cp 2
ld a,5
call nz,set_error
ld a,(ix+2)
or a
ld a,6
call nz,set_error
ld a,(ix+1)
cp &80
ld a,7
call nz,set_error
ld a,(ix+0)
and %11111100
cp &44
ld a,8
call nz,set_error
ld a,(drive)
ld c,a
ld a,(ix+0)
and %11
cp c
ld a,9
call nz,set_error

call stop_drive_motor
ret


.read_data_mt10
call start_drive_motor

ld a,25
call move2track

;; side 1 is &1-&9, side two is &1-&9

;; start side 0
ld a,%11000110				;; read data, mfm, multi-track
call send_command_byte
ld a,(drive)
call send_command_byte
ld a,25					;; C
call send_command_byte
ld a,&fe				;; H
call send_command_byte
ld a,&1					;; R
call send_command_byte
ld a,2						;; N
call send_command_byte
ld a,&9					;; EOT
call send_command_byte
ld a,&2a					;; GPL
call send_command_byte
ld a,&ff					;; dtl
call send_command_byte

;; read data but not into memory
ld de,0
call fdc_read_data2
ex de,hl
ld bc,&2400
or a
sbc hl,bc
ld a,h
or l
ex de,hl
ld a,1
call nz,set_error

;; 0x02400
;; 45,80,00,19,ff,09,02

call fdc_result_phase
ld ix,result_data
ld a,(ix+3)
cp &19
ld a,2
call nz,set_error
ld a,(ix+4)
cp &ff
ld a,3
call nz,set_error
ld a,(ix+5)
cp &09
ld a,4
call nz,set_error
ld a,(ix+6)
cp 2
ld a,5
call nz,set_error
ld a,(ix+2)
or a
ld a,6
call nz,set_error
ld a,(ix+1)
cp &80
ld a,7
call nz,set_error
ld a,(ix+0)
and %11111100
cp &44
ld a,8
call nz,set_error
ld a,(drive)
ld c,a
ld a,(ix+0)
and %11
cp c
ld a,9
call nz,set_error

call stop_drive_motor
ret


.read_data_mt4
call start_drive_motor

ld a,2
call move2track

;; side 1 is &1-&9, side two is &1-&9

;; start side 1
ld a,%11000110				;; read data, mfm, multi-track
call send_command_byte
ld a,(drive)
or 4
call send_command_byte
ld a,2					;; C
call send_command_byte
ld a,1						;; H
call send_command_byte
ld a,&1					;; R
call send_command_byte
ld a,2						;; N
call send_command_byte
ld a,&9					;; EOT
call send_command_byte
ld a,&2a					;; GPL
call send_command_byte
ld a,&ff					;; dtl
call send_command_byte

;; read data but not into memory
ld de,0
call fdc_read_data2
ex de,hl
ld bc,9*512
or a
sbc hl,bc
ld a,h
or l
ld a,1
call nz,set_error
ex de,hl

call fdc_result_phase
ld a,b
cp 7
ld a,9
call nz,set_error

;; 45,80,00,02,01,09,02
ld ix,result_data
ld a,(ix+3)
cp 2
ld a,2
call nz,set_error
ld a,(ix+4)
cp 1
ld a,3
call nz,set_error
ld a,(ix+5)
cp &9
ld a,4
call nz,set_error
ld a,(ix+6)
cp 2
ld a,5
call nz,set_error
ld a,(ix+2)
or a
ld a,6
call nz,set_error
ld a,(ix+1)
cp &80
ld a,7
call nz,set_error
ld a,(ix+0)
and %11111100
cp &44
ld a,8
call nz,set_error
ld a,(drive)
ld c,a
ld a,(ix+0)
and %11
cp c
ld a,9
call nz,set_error

call stop_drive_motor
ret


.read_data_mt5
call start_drive_motor

ld a,2
call move2track

;; side 1 is &1-&9, side two is &1-&9

;; start side 0
ld a,%11000110				;; read data, mfm, multi-track
call send_command_byte
ld a,(drive)
call send_command_byte
ld a,2					;; C
call send_command_byte
ld a,0						;; H
call send_command_byte
ld a,&1					;; R
call send_command_byte
ld a,2						;; N
call send_command_byte
ld a,10					;; EOT (not existant)
call send_command_byte
ld a,&2a					;; GPL
call send_command_byte
ld a,&ff					;; dtl
call send_command_byte

;; read data but not into memory
ld de,0
call fdc_read_data2
ex de,hl
ld bc,9*512
or a
sbc hl,bc
ld a,h
or l
ld a,1
call nz,set_error
ex de,hl

call fdc_result_phase
ld a,b
cp 7
ld a,9
call nz,set_error

;;call dump_results

;; 41,04,00,02,00,0a,02
ld ix,result_data
ld a,(ix+3)
cp 2
ld a,2
call nz,set_error
ld a,(ix+4)
cp 0
ld a,3
call nz,set_error
ld a,(ix+5)
cp &a
ld a,4
call nz,set_error
ld a,(ix+6)
cp 2
ld a,5
call nz,set_error
ld a,(ix+2)
or a
ld a,6
call nz,set_error
ld a,(ix+1)
cp 4
ld a,7
call nz,set_error
ld a,(ix+0)
and %11111100
cp &40
ld a,8
call nz,set_error
ld a,(drive)
ld c,a
ld a,(ix+0)
and %11
cp c
ld a,9
call nz,set_error

call stop_drive_motor
ret


.read_data_mt6
call start_drive_motor

ld a,2
call move2track

;; side 1 is &1-&9, side two is &1-&9

;; start side 0
ld a,%11000110				;; read data, mfm, multi-track
call send_command_byte
ld a,(drive)
call send_command_byte
ld a,2					;; C
call send_command_byte
ld a,0						;; H
call send_command_byte
ld a,&1					;; R
call send_command_byte
ld a,2						;; N
call send_command_byte
ld a,&3					;; EOT 
call send_command_byte
ld a,&2a					;; GPL
call send_command_byte
ld a,&ff					;; dtl
call send_command_byte

;; read data but not into memory
ld de,0
call fdc_read_data2
ex de,hl
ld bc,6*512
or a
sbc hl,bc
ld a,h
or l
ld a,1
call nz,set_error
ex de,hl

call fdc_result_phase
ld a,b
cp 7
ld a,9
call nz,set_error

;; 45,80,00,02,1,3,02
ld ix,result_data
ld a,(ix+3)
cp 2
ld a,2
call nz,set_error
ld a,(ix+4)
cp 1
ld a,3
call nz,set_error
ld a,(ix+5)
cp 3
ld a,4
call nz,set_error
ld a,(ix+6)
cp 2
ld a,5
call nz,set_error
ld a,(ix+2)
or a
ld a,6
call nz,set_error
ld a,(ix+1)
cp &80
ld a,7
call nz,set_error
ld a,(ix+0)
and %11111100
cp &44
ld a,8
call nz,set_error
ld a,(drive)
ld c,a
ld a,(ix+0)
and %11
cp c
ld a,9
call nz,set_error

call stop_drive_motor
ret



.read_data_mt7
call start_drive_motor

ld a,3
call move2track

;; side 1 is &1-&9, side two is &1-&9

;; start side 1
ld a,%11000110				;; read data, mfm, multi-track
call send_command_byte
ld a,(drive)
call send_command_byte
ld a,3					;; C
call send_command_byte
ld a,0						;; H
call send_command_byte
ld a,&1					;; R
call send_command_byte
ld a,2						;; N
call send_command_byte
ld a,&9					;; EOT
call send_command_byte
ld a,&2a					;; GPL
call send_command_byte
ld a,&ff					;; dtl
call send_command_byte

;; read data but not into memory
ld de,0
call fdc_read_data2
ex de,hl
ld bc,9*512
or a
sbc hl,bc
ld a,h
or l
ld a,1
call nz,set_error
ex de,hl

call fdc_result_phase
ld a,b
cp 7
ld a,9
call nz,set_error

;; 45,04,10,03,01,01,02
ld ix,result_data
ld a,(ix+3)
cp 3
ld a,2
call nz,set_error
ld a,(ix+4)
cp 1
ld a,3
call nz,set_error
ld a,(ix+5)
cp 1
ld a,4
call nz,set_error
ld a,(ix+6)
cp 2
ld a,5
call nz,set_error
ld a,(ix+2)
cp &10
ld a,6
call nz,set_error
ld a,(ix+1)
cp &4
ld a,7
call nz,set_error
ld a,(ix+0)
and %11111100
cp &44
ld a,8
call nz,set_error
ld a,(drive)
ld c,a
ld a,(ix+0)
and %11
cp c
ld a,9
call nz,set_error

call stop_drive_motor
ret


.read_data_mt8
call start_drive_motor

ld a,5
call move2track

;; start side 0
ld a,%11000110				;; read data, mfm, multi-track
call send_command_byte
ld a,(drive)
or 4
call send_command_byte
ld a,5					;; C
call send_command_byte
ld a,0						;; H
call send_command_byte
ld a,&1					;; R
call send_command_byte
ld a,2						;; N
call send_command_byte
ld a,&3					;; EOT 
call send_command_byte
ld a,&2a					;; GPL
call send_command_byte
ld a,&ff					;; dtl
call send_command_byte

;; read data but not into memory
ld de,0
call fdc_read_data2
;; 0x0c00
ex de,hl
ld bc,6*512
or a
sbc hl,bc
ld a,h
or l
ex de,hl
ld a,1
call nz,set_error

call fdc_result_phase
;;call dump_results
;;41,80,00,05,01,03,02

ld ix,result_data
ld a,(ix+3)
cp 5
ld a,2
call nz,set_error
ld a,(ix+4)
cp 1
ld a,3
call nz,set_error
ld a,(ix+5)
cp 3
ld a,4
call nz,set_error
ld a,(ix+6)
cp 2
ld a,5
call nz,set_error
ld a,(ix+2)
or a
ld a,6
call nz,set_error
ld a,(ix+1)
cp &80
ld a,7
call nz,set_error
ld a,(ix+0)
and %11111100
cp &40
ld a,8
call nz,set_error
ld a,(drive)
ld c,a
ld a,(ix+0)
and %11
cp c
ld a,9
call nz,set_error


call stop_drive_motor
ret

.read_data_mt9
call start_drive_motor

ld a,5
call move2track

;; start side 0
ld a,%11000110				;; read data, mfm, multi-track
call send_command_byte
ld a,(drive)
call send_command_byte
ld a,5					;; C
call send_command_byte
ld a,1						;; H
call send_command_byte
ld a,&1					;; R
call send_command_byte
ld a,2						;; N
call send_command_byte
ld a,&3					;; EOT 
call send_command_byte
ld a,&2a					;; GPL
call send_command_byte
ld a,&ff					;; dtl
call send_command_byte

;; read data but not into memory
ld de,0
call fdc_read_data2
ex de,hl
ld bc,3*512
or a
sbc hl,bc
ld a,h
or l
ex de,hl
ld a,1
call nz,set_error

call fdc_result_phase
;; 41,80,00,05,01,03,02
ld ix,result_data
ld a,(ix+3)
cp 5
ld a,2
call nz,set_error
ld a,(ix+4)
cp 1
ld a,3
call nz,set_error
ld a,(ix+5)
cp 3
ld a,4
call nz,set_error
ld a,(ix+6)
cp 2
ld a,5
call nz,set_error
ld a,(ix+2)
or a
ld a,6
call nz,set_error
ld a,(ix+1)
cp &80
ld a,7
call nz,set_error
ld a,(ix+0)
and %11111100
cp &40
ld a,8
call nz,set_error
ld a,(drive)
ld c,a
ld a,(ix+0)
and %11
cp c
ld a,9
call nz,set_error

call stop_drive_motor
ret

;;---------------------------------------------------------------------------
;; read a sector with "deleted data" mark using "read data" command
;;
;; result:
;; - control mark flag should be set

.read_deleted_data_using_data

call start_drive_motor

ld a,10
call move2track

;; send command bytes
ld a,%01000110					;; read data
call send_command_byte
ld a,(drive)					;; drive
call send_command_byte
ld a,10							;; C
call send_command_byte
ld a,0							;; H
call send_command_byte			
ld a,2							;; R
call send_command_byte
ld a,2							;; N
call send_command_byte
ld a,2							;; EOT
call send_command_byte
ld a,&2a						;; GPL
call send_command_byte
ld a,&ff						;; DTL
call send_command_byte			

;; read data in execution phase
ld de,0
call fdc_read_data2
;; 512 bytes 01 00 40 0a 00 02 02
ex de,hl
ld bc,512
or a
sbc hl,bc
ld a,h
or l
ex de,hl
ld a,1
call nz,set_error

;; read result phase bytes
call fdc_result_phase
ld a,b
cp 7
ld a,9
call nz,set_error

ld ix,result_data
ld a,(ix+3)
cp &a
ld a,2
call nz,set_error
ld a,(ix+4)
or a
ld a,3
call nz,set_error
ld a,(ix+5)
cp 2
ld a,4
call nz,set_error
ld a,(ix+6)
cp 2
ld a,5
call nz,set_error
ld a,(ix+2)
cp &40
ld a,6
call nz,set_error
ld a,(ix+1)
cp &00
ld a,7
call nz,set_error
ld a,(ix+0)
and %11111000
or a
ld a,8
call nz,set_error

call stop_drive_motor
ret


;;---------------------------------------------------------------------------
;; read a sector with "data" mark using "read deleted data" command
;;
;; result:
;; - control mark flag should be set

.read_data_using_deleted_data
call start_drive_motor

ld a,10
call move2track

;; send command bytes
ld a,%01001100					;; read deleted data
call send_command_byte
ld a,(drive)					;; drive
call send_command_byte
ld a,10							;; C
call send_command_byte
ld a,0							;; H
call send_command_byte			
ld a,1							;; R
call send_command_byte
ld a,2							;; N
call send_command_byte
ld a,1							;; EOT
call send_command_byte
ld a,&2a						;; GPL
call send_command_byte
ld a,&ff						;; DTL
call send_command_byte			

;; read data in execution phase
ld de,0
call fdc_read_data2
ex de,hl
ld bc,512
or a
sbc hl,bc
ld a,h
or l
ld a,1
call nz,set_error
ex de,hl

;; read result phase bytes
call fdc_result_phase
ld a,b
cp 7
ld a,9
call nz,set_error
ld ix,result_data
ld a,(ix+3)
cp &0a
ld a,2
call nz,set_error
ld a,(ix+4)
or a
ld a,3
call nz,set_error
ld a,(ix+5)
cp 1
ld a,4
call nz,set_error
ld a,(ix+6)
cp 2
ld a,5
call nz,set_error
ld a,(ix+2)
cp &40
ld a,6
call nz,set_error
ld a,(ix+1)
or a
ld a,7
call nz,set_error
ld a,(ix+0)
and %11111000
or a
ld a,8
call nz,set_error

call stop_drive_motor
ret

;;---------------------------------------------------------------------------------


.read_track6
call start_drive_motor

ld a,11
call move2track

ld a,%01000010		;; read a track/read diagnostic
call send_command_byte
ld a,(drive)
call send_command_byte

ld a,&ee					;; C (for comparison against ids)
call send_command_byte
ld a,&dd					;; H (for comparison against ids)
call send_command_byte
ld a,&cc				;; R (for comparison against ids)
call send_command_byte
ld a,&bb					;; N (for comparison against ids)
call send_command_byte
ld a,1					;; EOT (number of sectors to read)
call send_command_byte
ld a,&2a
call send_command_byte
ld a,&ff
call send_command_byte

ld de,0
call fdc_read_data2
ex de,hl
ld bc,&8000
or a
sbc hl,bc
ld a,h
or l
ld a,1
call nz,set_error
ex de,hl

call fdc_result_phase
ld a,b
cp 7
ld a,9
call nz,set_error

;;call dump_results

;; 41,A4,20,&ee,&dd,&01,&bb
ld ix,result_data
ld a,(ix+3)
cp &ee
ld a,2
call nz,set_error
ld a,(ix+4)
cp &dd
ld a,3
call nz,set_error
ld a,(ix+5)
cp 1
ld a,4
call nz,set_error
ld a,(ix+6)
cp &bb
ld a,5
call nz,set_error
ld a,(ix+2)
cp &20
ld a,6
call nz,set_error
ld a,(ix+1)
cp &a4
ld a,7
call nz,set_error
ld a,(ix+0)
and %11111000
cp &40
ld a,8
call nz,set_error


call stop_drive_motor
ret


.read_track10
call start_drive_motor

ld a,11
call move2track

ld a,%01000010		;; read a track/read diagnostic
call send_command_byte
ld a,(drive)
call send_command_byte

ld a,&11				;; C (for comparison against ids)
call send_command_byte
ld a,&22					;; H (for comparison against ids)
call send_command_byte
ld a,&33				;; R (for comparison against ids)
call send_command_byte
ld a,&44					;; N (for comparison against ids)
call send_command_byte
ld a,1					;; EOT (number of sectors to read)
call send_command_byte
ld a,&2a
call send_command_byte
ld a,&ff
call send_command_byte

ld de,0
call fdc_read_data2
ex de,hl
ld bc,&8000
or a
sbc hl,bc
ld a,h
or l
ld a,1
call nz,set_error
ex de,hl

call fdc_result_phase
ld a,b
cp 7
ld a,9
call nz,set_error

;;call dump_results

;; 41,A4,20,&11,&22,&01,&44
ld ix,result_data
ld a,(ix+3)
cp &11
ld a,2
call nz,set_error
ld a,(ix+4)
cp &22
ld a,3
call nz,set_error
ld a,(ix+5)
cp 1
ld a,4
call nz,set_error
ld a,(ix+6)
cp &44
ld a,5
call nz,set_error
ld a,(ix+2)
cp &20
ld a,6
call nz,set_error
ld a,(ix+1)
cp &a4
ld a,7
call nz,set_error
ld a,(ix+0)
and %11111000
cp &40
ld a,8
call nz,set_error


call stop_drive_motor
ret


.read_track0
call start_drive_motor

ld a,11
call move2track

ld a,%01000010		;; read a track/read diagnostic
call send_command_byte
ld a,(drive)
call send_command_byte

ld a,11					;; C (for comparison against ids)
call send_command_byte
ld a,0					;; H (for comparison against ids)
call send_command_byte
ld a,&c1				;; R (for comparison against ids)
call send_command_byte
ld a,2					;; N (for comparison against ids)
call send_command_byte
ld a,0					;; EOT (number of sectors to read)
call send_command_byte
ld a,&2a
call send_command_byte
ld a,&ff
call send_command_byte

ld de,0
call fdc_read_data3
ex de,hl
ld bc,16384
or a
sbc hl,bc
ld a,h
or l
ld a,1
call nz,set_error
ex de,hl

call fdc_result_phase
ld a,b
cp 7
ld a,9
call nz,set_error
ld ix,result_data

call dump_results
;; 41,84,00,0b,00,00,02
ld ix,result_data

ld a,(ix+3)
cp &b
ld a,2
call nz,set_error
ld a,(ix+4)
or a
ld a,3
call nz,set_error
ld a,(ix+5)
or a
ld a,4
call nz,set_error
ld a,(ix+6)
cp 2
ld a,5
call nz,set_error
ld a,(ix+2)
or a
ld a,6
call nz,set_error
ld a,(ix+1)
cp &84
ld a,7
call nz,set_error
ld a,(ix+0)
and %11111000
cp &40
ld a,8
call nz,set_error


call stop_drive_motor
ret

;;------------------------------------------------------------------------------------
.format1

call start_drive_motor

ld a,20
call move2track

ld ix,sector_buffer
ld b,9
ld a,&1
.itd10
ld (ix+0),a
ld (ix+1),a
ld (ix+2),a
ld (ix+3),a
inc a
inc ix
inc ix
inc ix
inc ix
djnz itd10

;;call start_drive_motor

;;ld a,2
;;call move2track

ld a,%01001101
call send_command_byte
ld a,(drive)
call send_command_byte
ld a,2						;; sector size
call send_command_byte
ld a,9						;; number of sectors
call send_command_byte
ld a,&4a					;; gap
call send_command_byte
ld a,&e5					;; filler
call send_command_byte

ld de,sector_buffer
call fdc_data_write
;; 0x024
ex de,hl
ld bc,sector_buffer
or a
sbc hl,bc
ld bc,&24
or a
sbc hl,bc
ld a,h
or l
ld a,1
call nz,set_error
ex de,hl

call fdc_result_phase
;;call dump_results
;; 01,00,00,0a,04,09,02
ld ix,result_data
ld a,(ix+3)
cp &a
ld a,2
call nz,set_error
ld a,(ix+4)
cp &4
ld a,3
call nz,set_error
ld a,(ix+5)
cp &9
ld a,4
call nz,set_error
ld a,(ix+6)
cp &2
ld a,5
call nz,set_error
ld a,(ix+2)
or a
ld a,6
call nz,set_error
ld a,(ix+1)
or a
ld a,7
call nz,set_error
ld a,(ix+0)
and %11111000
or a
ld a,8
call nz,set_error

call stop_drive_motor
ret

.specify
ld a,%00011					;; specify
call send_command_byte
ld a,&a1
call send_command_byte
ld a,3						;; no dma
call send_command_byte

;; do sense interrupt status after specify
ld a,%1000
call send_command_byte
call fdc_result_phase
;; 0x080
;;call dump_results
ret


.format2
call start_drive_motor

ld a,38
call move2track

ld b,32
xor a

.fmt2a
push af
push bc

push af
push af
ld ix,sector_buffer
ld (ix+0),38
ld (ix+1),0
ld (ix+2),&44
ld (ix+3),a

di
call start_drive_motor

ld a,%01001101
call send_command_byte
ld a,(drive)
call send_command_byte
ld a,2						;; sector size
call send_command_byte
ld a,1						;; number of sectors
call send_command_byte
ld a,&4a					;; gap
call send_command_byte
ld a,&e5					;; filler
call send_command_byte

ld de,sector_buffer
call fdc_data_write
call fdc_result_phase


ld a,%01000110				;; read data
call send_command_byte
ld a,(drive)
call send_command_byte
ld a,38					;; C
call send_command_byte
ld a,0						;; H
call send_command_byte
ld a,&44					;; R
call send_command_byte
pop af
call send_command_byte
ld a,&44					;; EOT
call send_command_byte
ld a,&2a					;; GPL
call send_command_byte
ld a,&ff					;; DTL
call send_command_byte

ld de,0
call fdc_read_data2
push de
call fdc_result_phase
;;call dump_results
;;call display_newline
pop de
pop af
cp 0
ld bc,&50
jr z,fmt_tst
cp 1
ld bc,&100
jr z,fmt_tst
cp 2
ld bc,&200
jr z,fmt_tst
cp 3
ld bc,&400
jr z,fmt_tst
cp 4
ld bc,&800
jr z,fmt_tst
cp 5
ld bc,&1000
jr z,fmt_tst
cp 6
ld bc,&2000
jr z,fmt_tst
cp 7
ld bc,&4000
jr z,fmt_tst
ld bc,&8000

.fmt_tst
ex de,hl
or a
sbc hl,bc
ld a,d
or e
ld a,1
call nz,set_error
ex de,hl

pop bc
pop af
inc a
dec b
jp nz,fmt2a
;;0050 41 20 20 26 00 44 00
;;0100 41 20 20 26 00 44 01
;;0200 41 80 00 26 00 44 02
;;0400 41 20 20 26 00 44 03
;;0800 41 20 20 26 00 44 04
;;1000
;;2000
;;4000
;;8000
;;8000

ret


.format_nr
call start_drive_motor

ld a,38
call move2track

call stop_drive_motor

ld ix,sector_buffer
ld (ix+0),38
ld (ix+1),0
ld (ix+2),&44
ld (ix+3),6

ld a,%01001101
call send_command_byte
ld a,(drive)
call send_command_byte
ld a,2						;; sector size
call send_command_byte
ld a,1						;; number of sectors
call send_command_byte
ld a,&4a					;; gap
call send_command_byte
ld a,&e5					;; filler
call send_command_byte

ld de,sector_buffer
call fdc_data_write
ex de,hl
or a
ld bc,sector_buffer
sbc hl,bc
ld a,h
or l
ld a,1
call nz,set_error
ex de,hl

call fdc_result_phase
call dump_results
;; 48,00,00,26,04,00,02
ret

;;------------------------------------------------------------------------------------

.read_track1
call start_drive_motor

ld a,11
call move2track

ld a,%01000010		;; read a track/read diagnostic
call send_command_byte
ld a,(drive)
call send_command_byte

ld a,11					;; C (for comparison against ids)
call send_command_byte
ld a,0					;; H (for comparison against ids)
call send_command_byte
ld a,1					;; R (for comparison against ids)
call send_command_byte
ld a,2					;; N (for comparison against ids)
call send_command_byte
ld a,1					;; EOT (number of sectors to read)
call send_command_byte
ld a,&2a
call send_command_byte
ld a,&ff
call send_command_byte

ld de,0
call fdc_read_data2
ex de,hl
ld bc,512
or a
sbc hl,bc
ld a,h
or l
ld a,1
call nz,set_error
ex de,hl

call fdc_result_phase
ld a,b
cp 7
ld a,9
call nz,set_error

;; 41,84,00,0b,00,01,02
ld ix,result_data
ld a,(ix+3)
cp &b
ld a,2
call nz,set_error
ld a,(ix+4)
or a
ld a,3
call nz,set_error
ld a,(ix+5)
cp 1
ld a,4
call nz,set_error
ld a,(ix+6)
cp 2
ld a,5
call nz,set_error
ld a,(ix+2)
or a
ld a,6
call nz,set_error
ld a,(ix+1)
cp &84
ld a,7
call nz,set_error
ld a,(ix+0)
and %11111000
cp &40
ld a,8
call nz,set_error

call stop_drive_motor
ret


.read_track14
call start_drive_motor

ld a,11
call move2track

ld a,%01000010		;; read a track/read diagnostic
call send_command_byte
ld a,(drive)
call send_command_byte

ld a,11					;; C (for comparison against ids)
call send_command_byte
ld a,0					;; H (for comparison against ids)
call send_command_byte
ld a,1					;; R (for comparison against ids)
call send_command_byte
ld a,3					;; N (for comparison against ids)
call send_command_byte
ld a,2					;; EOT (number of sectors to read)
call send_command_byte
ld a,&2a
call send_command_byte
ld a,&ff
call send_command_byte

ld de,0
call fdc_read_data2
;; 0x0800
ex de,hl
ld bc,&800
or a
sbc hl,bc
ld a,h
or l
ld a,1
call nz,set_error
ex de,hl
call fdc_result_phase
;;call dump_results
;; 41,a4,20,0b,00,02,03
ld ix,result_data
ld a,(ix+3)
cp &b
ld a,2
call nz,set_error
ld a,(ix+4)
or a
ld a,3
call nz,set_error
ld a,(ix+5)
cp 2
ld a,4
call nz,set_error
ld a,(ix+6)
cp 3
ld a,5
call nz,set_error
ld a,(ix+2)
cp &20
ld a,6
call nz,set_error
ld a,(ix+1)
cp &a4
ld a,7
call nz,set_error
ld a,(ix+0)
and %11111000
cp &40
ld a,8
call nz,set_error

call stop_drive_motor
ret

.read_track_unform
call start_drive_motor

ld a,8
call move2track

ld a,%01000010		;; read a track/read diagnostic
call send_command_byte
ld a,(drive)
call send_command_byte

ld a,11					;; C (for comparison against ids)
call send_command_byte
ld a,0					;; H (for comparison against ids)
call send_command_byte
ld a,1					;; R (for comparison against ids)
call send_command_byte
ld a,2					;; N (for comparison against ids)
call send_command_byte
ld a,1					;; EOT (number of sectors to read)
call send_command_byte
ld a,&2a
call send_command_byte
ld a,&ff
call send_command_byte

ld de,0
call fdc_read_data2
;; 0000
ld a,d
or e
ld a,1
call nz,set_error

call fdc_result_phase

;;call dump_results
;; 41,01,00,0b,00,01,02
ld ix,result_data
ld a,(ix+3)
cp &b
ld a,2
call nz,set_error
ld a,(ix+4)
or a
ld a,3
call nz,set_error
ld a,(ix+5)
cp 1
ld a,4
call nz,set_error
ld a,(ix+6)
cp 2
ld a,5
call nz,set_error
ld a,(ix+2)
or a
ld a,6
call nz,set_error
ld a,(ix+1)
cp 1
ld a,7
call nz,set_error
ld a,(ix+0)
and %11111000
cp &40
ld a,8
call nz,set_error

call stop_drive_motor
ret



.read_track7
call start_drive_motor

ld a,10
call move2track

ld a,%01100010		;; read a track/read diagnostic
call send_command_byte
ld a,(drive)
call send_command_byte

ld a,10					;; C (for comparison against ids)
call send_command_byte
ld a,0					;; H (for comparison against ids)
call send_command_byte
ld a,1					;; R (for comparison against ids)
call send_command_byte
ld a,2					;; N (for comparison against ids)
call send_command_byte
ld a,2					;; EOT (number of sectors to read)
call send_command_byte
ld a,&2a
call send_command_byte
ld a,&ff
call send_command_byte

ld de,0
call fdc_read_data2
;; transfer 512 bytes
ex de,hl
ld bc,512
or a
sbc hl,bc
ld a,h
or l
ex de,hl
ld a,1
call nz,set_error

call fdc_result_phase
;; 41,80,40,0a,00,02,02
;;call dump_results

ld ix,result_data
ld a,(ix+3)
cp &a
ld a,2
call nz,set_error
ld a,(ix+4)
cp 0
ld a,3
call nz,set_error
ld a,(ix+5)
cp 2
ld a,4
call nz,set_error
ld a,(ix+6)
cp 2
ld a,5
call nz,set_error
ld a,(ix+2)
cp &40
ld a,6
call nz,set_error
ld a,(ix+1)
cp &80
ld a,7
call nz,set_error
ld a,(ix+0)
and %11111100
cp &40
ld a,8
call nz,set_error
ld a,(drive)
ld c,a
ld a,(ix+0)
and %11
cp c
ld a,9
call nz,set_error

call stop_drive_motor
ret

.read_track8
call start_drive_motor

ld a,10
call move2track

ld a,%01000010		;; read a track/read diagnostic
call send_command_byte
ld a,(drive)
call send_command_byte

ld a,10					;; C (for comparison against ids)
call send_command_byte
ld a,0					;; H (for comparison against ids)
call send_command_byte
ld a,1					;; R (for comparison against ids)
call send_command_byte
ld a,2					;; N (for comparison against ids)
call send_command_byte
ld a,2					;; EOT (number of sectors to read)
call send_command_byte
ld a,&2a
call send_command_byte
ld a,&ff
call send_command_byte

ld de,0
call fdc_read_data2
ex de,hl
ld bc,512*2
or a
sbc hl,bc
ld a,h
or l
ex de,hl
ld a,1
call nz,set_error

call fdc_result_phase
;; 41,80,40,0a,00,02,02
;;call dump_results
ld ix,result_data
ld a,(ix+3)
cp &a
ld a,2
call nz,set_error
ld a,(ix+4)
cp 0
ld a,3
call nz,set_error
ld a,(ix+5)
cp 2
ld a,4
call nz,set_error
ld a,(ix+6)
cp 2
ld a,5
call nz,set_error
ld a,(ix+2)
cp &40
ld a,6
call nz,set_error
ld a,(ix+1)
cp &80
ld a,7
call nz,set_error
ld a,(ix+0)
and %11111100
cp &40
ld a,8
call nz,set_error
ld a,(drive)
ld c,a
ld a,(ix+0)
and %11
cp c
ld a,9
call nz,set_error

call stop_drive_motor
ret


.read_track9
call start_drive_motor

ld a,0
call move2track

ld a,%11000010		;; read a track/read diagnostic
call send_command_byte
ld a,(drive)
call send_command_byte

ld a,10					;; C (for comparison against ids)
call send_command_byte
ld a,0					;; H (for comparison against ids)
call send_command_byte
ld a,1					;; R (for comparison against ids)
call send_command_byte
ld a,2					;; N (for comparison against ids)
call send_command_byte
ld a,1					;; EOT (number of sectors to read)
call send_command_byte
ld a,&2a
call send_command_byte
ld a,&ff
call send_command_byte

;; 2*512 bytes
ld de,0
call fdc_read_data2
ex de,hl
ld bc,512*2
or a
sbc hl,bc
ld a,h
or l
ex de,hl
ld a,1
call nz,set_error
call fdc_result_phase
;; 45,84,00,&a,01,01,02
;;call dump_results

ld ix,result_data
ld a,(ix+3)
cp &a
ld a,2
call nz,set_error
ld a,(ix+4)
cp 1
ld a,3
call nz,set_error
ld a,(ix+5)
cp 1
ld a,4
call nz,set_error
ld a,(ix+6)
cp 2
ld a,5
call nz,set_error
ld a,(ix+2)
or a
ld a,6
call nz,set_error
ld a,(ix+1)
cp &84
ld a,7
call nz,set_error
ld a,(ix+0)
and %11111100
cp &44
ld a,8
call nz,set_error
ld a,(drive)
ld c,a
ld a,(ix+0)
and %11
cp c
ld a,9
call nz,set_error

call stop_drive_motor
ret


.read_track11
call start_drive_motor

ld a,0
call move2track

ld a,%11000010		;; read a track/read diagnostic
call send_command_byte
ld a,(drive)
or 4
call send_command_byte

ld a,10					;; C (for comparison against ids)
call send_command_byte
ld a,0					;; H (for comparison against ids)
call send_command_byte
ld a,1					;; R (for comparison against ids)
call send_command_byte
ld a,2					;; N (for comparison against ids)
call send_command_byte
ld a,1					;; EOT (number of sectors to read)
call send_command_byte
ld a,&2a
call send_command_byte
ld a,&ff
call send_command_byte

;; 2*512 bytes
ld de,0
call fdc_read_data2
ex de,hl
ld bc,2*512
or a
sbc hl,bc
ld a,h
or l
ex de,hl
ld a,1
call nz,set_error
;; 0x0400

call fdc_result_phase
;;call dump_results
;; 41,84,00,0a,01,01,02

ld ix,result_data
ld a,(ix+3)
cp &a
ld a,2
call nz,set_error
ld a,(ix+4)
cp 1
ld a,3
call nz,set_error
ld a,(ix+5)
cp 1
ld a,4
call nz,set_error
ld a,(ix+6)
cp 2
ld a,5
call nz,set_error
ld a,(ix+2)
or a
ld a,6
call nz,set_error
ld a,(ix+1)
cp &84
ld a,7
call nz,set_error
ld a,(ix+0)
and %11111100
cp &40
ld a,8
call nz,set_error
ld a,(drive)
ld c,a
ld a,(ix+0)
and %11
cp c
ld a,9
call nz,set_error

call stop_drive_motor
ret

.read_track12
call start_drive_motor

ld a,4
call move2track

ld a,%01000010		;; read a track/read diagnostic
call send_command_byte
ld a,(drive)
call send_command_byte

ld a,0					;; C (for comparison against ids)
call send_command_byte
ld a,0					;; H (for comparison against ids)
call send_command_byte
ld a,&aa					;; R (for comparison against ids)
call send_command_byte
ld a,3					;; N (for comparison against ids)
call send_command_byte
ld a,1					;; EOT (number of sectors to read)
call send_command_byte
ld a,&2a
call send_command_byte
ld a,&ff
call send_command_byte

ld de,0
call fdc_read_data2
;; 0400
ex de,hl
ld bc,&400
or a
sbc hl,bc
ld a,h
or l
ld a,1
call nz,set_error
ex de,hl

call fdc_result_phase
;;call dump_results

;; 40, a4,20,00,00,01,03
ld ix,result_data
ld a,(ix+3)
or a
ld a,2
call nz,set_error
ld a,(ix+4)
or a
ld a,3
call nz,set_error
ld a,(ix+5)
cp 1
ld a,4
call nz,set_error
ld a,(ix+6)
cp 3
ld a,5
call nz,set_error
ld a,(ix+2)
cp &20
ld a,6
call nz,set_error
ld a,(ix+1)
cp &a4
ld a,7
call nz,set_error
ld a,(ix+0)
and %11111100
cp &40
ld a,8
call nz,set_error
ld a,(drive)
ld c,a
ld a,(ix+0)
and %11
cp c
ld a,9
call nz,set_error

call stop_drive_motor
ret


.read_track13
call start_drive_motor

ld a,4
call move2track

ld a,%01000010		;; read a track/read diagnostic
call send_command_byte
ld a,(drive)
call send_command_byte

ld a,0					;; C (for comparison against ids)
call send_command_byte
ld a,0					;; H (for comparison against ids)
call send_command_byte
ld a,&aa					;; R (for comparison against ids)
call send_command_byte
ld a,3					;; N (for comparison against ids)
call send_command_byte
ld a,2					;; EOT (number of sectors to read)
call send_command_byte
ld a,&2a
call send_command_byte
ld a,&ff
call send_command_byte

ld de,0
call fdc_read_data2
;; 0x0800
ex de,hl
ld bc,&800
or a
sbc hl,bc
ld a,h
or l
ld a,1
call nz,set_error
ex de,hl

call fdc_result_phase
;;call dump_results
;; 41,a4,20,00,00,02,03
ld ix,result_data
ld a,(ix+3)
or a
ld a,2
call nz,set_error
ld a,(ix+4)
or a
ld a,3
call nz,set_error
ld a,(ix+5)
cp 2
ld a,4
call nz,set_error
ld a,(ix+6)
cp 3
ld a,5
call nz,set_error
ld a,(ix+2)
cp &20
ld a,6
call nz,set_error
ld a,(ix+1)
cp &a4
ld a,7
call nz,set_error
ld a,(ix+0)
and %11111100
cp &40
ld a,8
call nz,set_error
ld a,(drive)
ld c,a
ld a,(ix+0)
and %11
cp c
ld a,9
call nz,set_error

call stop_drive_motor
ret

.read_track_nr
call start_drive_motor

ld a,0
call move2track

call stop_drive_motor

ld a,%01000010		;; read a track/read diagnostic
call send_command_byte
ld a,(drive)
call send_command_byte

ld a,0					;; C (for comparison against ids)
call send_command_byte
ld a,0					;; H (for comparison against ids)
call send_command_byte
ld a,&41					;; R (for comparison against ids)
call send_command_byte
ld a,2					;; N (for comparison against ids)
call send_command_byte
ld a,1					;; EOT (number of sectors to read)
call send_command_byte
ld a,&2a
call send_command_byte
ld a,&ff
call send_command_byte

ld de,0
call fdc_read_data2
ld a,d
or e
ld a,1
call nz,set_error

call fdc_result_phase
;; 48,00,00,00,00,41,02

;;call dump_results
ld ix,result_data
ld a,(ix+3)
or a
ld a,2
call nz,set_error
ld a,(ix+4)
or a
ld a,3
call nz,set_error
ld a,(ix+5)
cp &41
ld a,4
call nz,set_error
ld a,(ix+6)
cp 2
ld a,5
call nz,set_error
ld a,(ix+2)
or a
ld a,6
call nz,set_error
ld a,(ix+1)
or a
ld a,7
call nz,set_error
ld a,(ix+0)
and %11111100
cp &48
ld a,8
call nz,set_error
ld a,(drive)
ld c,a
ld a,(ix+0)
and %11
cp c
ld a,9
call nz,set_error

call stop_drive_motor
ret



.read_track2
call start_drive_motor

ld a,11
call move2track

ld a,%01000010		;; read a track/read diagnostic
call send_command_byte
ld a,(drive)
call send_command_byte

ld a,11					;; C (for comparison against ids)
call send_command_byte
ld a,0					;; H (for comparison against ids)
call send_command_byte
ld a,&c2			;; R (for comparison against ids)
call send_command_byte
ld a,2					;; N (for comparison against ids)
call send_command_byte
ld a,1					;; EOT (number of sectors to read)
call send_command_byte
ld a,&2a
call send_command_byte
ld a,&ff
call send_command_byte

ld de,0
call fdc_read_data2
ex de,hl
ld bc,512
or a
sbc hl,bc
ld a,h
or l
ld a,1
call nz,set_error
ex de,hl

call fdc_result_phase
ld a,b
cp 7
ld a,9
call nz,set_error

;; 41,84,00,0b,00,01,02

ld ix,result_data
ld a,(ix+3)
cp &b
ld a,2
call nz,set_error
ld a,(ix+4)
or a
ld a,3
call nz,set_error
ld a,(ix+5)
cp 1
ld a,4
call nz,set_error
ld a,(ix+6)
cp 2
ld a,5
call nz,set_error
ld a,(ix+2)
or a
ld a,6
call nz,set_error
ld a,(ix+1)
cp &84
ld a,7
call nz,set_error
ld a,(ix+0)
and %11111000
cp &40
ld a,8
call nz,set_error

call stop_drive_motor
ret


.read_track3
call start_drive_motor

ld a,11
call move2track

ld a,%01000010		;; read a track/read diagnostic
call send_command_byte
ld a,(drive)
call send_command_byte

ld a,11					;; C (for comparison against ids)
call send_command_byte
ld a,0					;; H (for comparison against ids)
call send_command_byte
ld a,2					;; R (for comparison against ids)
call send_command_byte
ld a,2					;; N (for comparison against ids)
call send_command_byte
ld a,1					;; EOT (number of sectors to read)
call send_command_byte
ld a,&2a
call send_command_byte
ld a,&ff
call send_command_byte

ld de,0
call fdc_read_data2
ex de,hl
ld bc,512
or a
sbc hl,bc
ld a,h
or l
ld a,1
call nz,set_error
ex de,hl

call fdc_result_phase
ld a,b
cp 7
ld a,9
call nz,set_error

;; 41,84,00,0b,00,01,02

ld ix,result_data
ld a,(ix+3)
cp &b
ld a,2
call nz,set_error
ld a,(ix+4)
or a
ld a,3
call nz,set_error
ld a,(ix+5)
cp 1
ld a,4
call nz,set_error
ld a,(ix+6)
cp 2
ld a,5
call nz,set_error
ld a,(ix+2)
or a
ld a,6
call nz,set_error
ld a,(ix+1)
cp &84
ld a,7
call nz,set_error
ld a,(ix+0)
and %11111000
cp &40
ld a,8
call nz,set_error

call stop_drive_motor
ret


.read_track4
call start_drive_motor

ld a,11
call move2track

ld a,%01000010		;; read a track/read diagnostic
call send_command_byte
ld a,(drive)
call send_command_byte

ld a,11					;; C (for comparison against ids)
call send_command_byte
ld a,0					;; H (for comparison against ids)
call send_command_byte
ld a,9					;; R (for comparison against ids)
call send_command_byte
ld a,2					;; N (for comparison against ids)
call send_command_byte
ld a,20					;; EOT (number of sectors to read)
call send_command_byte
ld a,&2a
call send_command_byte
ld a,&ff
call send_command_byte

ld de,0
call fdc_read_data2
ex de,hl
ld bc,20*512
or a
sbc hl,bc
ld a,h
or l
ld a,1
call nz,set_error
ex de,hl

call fdc_result_phase
ld a,b
cp 7
ld a,9
call nz,set_error
ld ix,result_data

;; 41,84,00,0b,00,14,02

ld a,(ix+3)
cp &b
ld a,2
call nz,set_error
ld a,(ix+4)
or a
ld a,3
call nz,set_error
ld a,(ix+5)
cp 20
ld a,4
call nz,set_error
ld a,(ix+6)
cp 2
ld a,5
call nz,set_error
ld a,(ix+2)
or a
ld a,6
call nz,set_error
ld a,(ix+1)
cp &84
ld a,7
call nz,set_error
ld a,(ix+0)
and %11111000
cp &40
ld a,8
call nz,set_error


call stop_drive_motor
ret

.read_track5
call start_drive_motor

ld a,11
call move2track

ld a,%01000010		;; read a track/read diagnostic
call send_command_byte
ld a,(drive)
call send_command_byte

ld a,11					;; C (for comparison against ids)
call send_command_byte
ld a,0					;; H (for comparison against ids)
call send_command_byte
ld a,&1				;; R (for comparison against ids)
call send_command_byte
ld a,0					;; N (for comparison against ids)
call send_command_byte
ld a,1					;; EOT (number of sectors to read)
call send_command_byte
ld a,&2a
call send_command_byte
ld a,&80
call send_command_byte

ld de,0
call fdc_read_data2
ex de,hl
ld bc,&50
sbc hl,bc
ld a,h
or l
ld a,1
call nz,set_error
ex de,hl

call fdc_result_phase
;; call dump_results

;; 0050
;; 40,a4,20,0b,00,01,00
ld ix,result_data

ld a,(ix+3)
cp &b
ld a,2
call nz,set_error
ld a,(ix+4)
or a
ld a,3
call nz,set_error
ld a,(ix+5)
cp 1
ld a,4
call nz,set_error
ld a,(ix+6)
cp 0
ld a,5
call nz,set_error
ld a,(ix+2)
cp &20
ld a,6
call nz,set_error
ld a,(ix+1)
cp &a4
ld a,7
call nz,set_error
ld a,(ix+0)
and %11111000
cp &40
ld a,8
call nz,set_error

call stop_drive_motor
ret

;;---------------------------------------------------------------------------
.scan_equal
call start_drive_motor

ld a,11
call move2track

;; read sector into memory
ld a,%01000110				;; read data
call send_command_byte
ld a,(drive)				;; drive
call send_command_byte
ld a,11						;; C
call send_command_byte
ld a,0						;; H
call send_command_byte
ld a,&c1					;; R
call send_command_byte
ld a,2						;; N
call send_command_byte
ld a,&c1					;; EOT
call send_command_byte
ld a,&2a					;; GPL
call send_command_byte
ld a,&ff					;; DTL
call send_command_byte
ld de,sector_buffer
call fdc_data_read
call fdc_result_phase

;; scan equal
ld a,%01010001
call send_command_byte
ld a,(drive)
call send_command_byte
ld a,11						;; C
call send_command_byte
ld a,0						;; H
call send_command_byte
ld a,&c1					;; R
call send_command_byte
ld a,2						;; N
call send_command_byte
ld a,&c1					;; EOT
call send_command_byte
ld a,&2a					;; GPL
call send_command_byte
ld a,&ff					;; DTL
call send_command_byte

ld de,sector_buffer
call fdc_data_write
call fdc_result_phase

;; 01,00,08,0b,00,c1,02
ld ix,result_data
ld a,(ix+3)
cp &b
ld a,1
call nz,set_error
ld a,(ix+4)
or a
ld a,2
call nz,set_error
ld a,(ix+5)
cp &c1
ld a,3
call nz,set_error
ld a,(ix+6)
cp 2
ld a,4
call nz,set_error
ld a,(ix+2)
cp 8
ld a,5
call nz,set_error
ld a,(ix+1)
or a
ld a,6
call nz,set_error
ld a,(ix+0)
and %11111000
or a
ld a,7
call nz,set_error

call stop_drive_motor
ret

.scan_equal2
call start_drive_motor

ld a,11
call move2track

;; read sector into memory
ld a,%01000110				;; read data
call send_command_byte
ld a,(drive)				;; drive
call send_command_byte
ld a,11						;; C
call send_command_byte
ld a,0						;; H
call send_command_byte
ld a,&c1					;; R
call send_command_byte
ld a,2						;; N
call send_command_byte
ld a,&c1					;; EOT
call send_command_byte
ld a,&2a					;; GPL
call send_command_byte
ld a,&ff					;; DTL
call send_command_byte
ld de,sector_buffer
call fdc_data_read
call fdc_result_phase

;; scan equal
ld a,%01010001
call send_command_byte
ld a,(drive)
call send_command_byte
ld a,11						;; C
call send_command_byte
ld a,0						;; H
call send_command_byte
ld a,&c2					;; R
call send_command_byte
ld a,2						;; N
call send_command_byte
ld a,&c2					;; EOT
call send_command_byte
ld a,&2a					;; GPL
call send_command_byte
ld a,&01					;; SPL contiguous sectors
call send_command_byte

ld de,sector_buffer
call fdc_data_write
call fdc_result_phase

call dump_results

ld ix,result_data
ld a,(ix+2)
and %1100
cp %1000					;; scan equal, and scan satisfied?
ld a,1
call z,set_error

call stop_drive_motor
ret


.scan_equal3
call start_drive_motor

ld a,11
call move2track

;; fill with ff's
ld hl,sector_buffer
ld e,l
ld d,h
inc de
ld (hl),&ff
ld bc,512
ldir

;; scan equal
ld a,%01010001
call send_command_byte
ld a,(drive)
call send_command_byte
ld a,11						;; C
call send_command_byte
ld a,0						;; H
call send_command_byte
ld a,&c2					;; R
call send_command_byte
ld a,2						;; N
call send_command_byte
ld a,&c2					;; EOT
call send_command_byte
ld a,&2a					;; GPL
call send_command_byte
ld a,&01					;; SPL contiguous sectors
call send_command_byte

ld de,sector_buffer
call fdc_data_write
call fdc_result_phase
ld a,b
cp 7
ld a,9
call nz,set_error

;; 01,00,08,0b,00,c1,02
ld ix,result_data
ld a,(ix+3)
cp &b
ld a,1
call nz,set_error
ld a,(ix+4)
or a
ld a,2
call nz,set_error
ld a,(ix+5)
cp &c1
ld a,3
call nz,set_error
ld a,(ix+6)
cp 2
ld a,4
call nz,set_error
ld a,(ix+2)
cp 8
ld a,5
call nz,set_error
ld a,(ix+1)
or a
ld a,6
call nz,set_error
ld a,(ix+0)
and %11111000
or a
ld a,7
call nz,set_error

call stop_drive_motor
ret

;;---------------------------------------------------------------------------------

.bad_cylinder
call start_drive_motor

ld a,12
call move2track

ld a,%01000110				;; read data
call send_command_byte
ld a,(drive)
call send_command_byte
ld a,&ff					;; C
call send_command_byte
ld a,0						;; H
call send_command_byte
ld a,&c1					;; R
call send_command_byte
ld a,2						;; N
call send_command_byte
ld a,&c1					;; EOT
call send_command_byte
ld a,&2a					;; GPL
call send_command_byte
ld a,&ff					;; DTL
call send_command_byte

ld de,0
call fdc_read_data2
ex de,hl
ld bc,512
or a
sbc hl,bc
ex de,hl
ld a,d
or e
ld a,1
call nz,set_error

call fdc_result_phase
ld a,b
cp 7
ld a,9
call nz,set_error

;; 41,80,00,ff,00,c1,02

ld ix,result_data
ld a,(ix+3)
cp &ff
ld a,2
call nz,set_error
ld a,(ix+4)
or a
ld a,3
call nz,set_error
ld a,(ix+5)
cp &c1
ld a,4
call nz,set_error
ld a,(ix+6)
cp 2
ld a,5
call nz,set_error
ld a,(ix+2)
or a
ld a,7
call nz,set_error
ld a,(ix+1)
cp &80
ld a,8
call nz,set_error
ld a,(ix+0)
and %11111000
cp &40
ld a,9
call nz,set_error

call stop_drive_motor
ret


.bad5_cylinder
call start_drive_motor

ld a,12
call move2track

ld a,%01000101				;; read data
call send_command_byte
ld a,(drive)
call send_command_byte
ld a,&0					;; C
call send_command_byte
ld a,0						;; H
call send_command_byte
ld a,&c1					;; R
call send_command_byte
ld a,2						;; N
call send_command_byte
ld a,&c1					;; EOT
call send_command_byte
ld a,&2a					;; GPL
call send_command_byte
ld a,&ff					;; DTL
call send_command_byte

ld de,sector_buffer
call fdc_data_write
ex de,hl
ld bc,sector_buffer
or a
sbc hl,bc
;; 0x0000
ld a,h
or l
call nz,set_error
ex de,hl

call fdc_result_phase
;;call dump_results
;; 41,04,12,00,00,c1,02
ld ix,result_data
ld a,(ix+3)
or a
ld a,2
call nz,set_error
ld a,(ix+4)
or a
ld a,3
call nz,set_error
ld a,(ix+5)
cp &c1
ld a,4
call nz,set_error
ld a,(ix+6)
cp 2
ld a,5
call nz,set_error
ld a,(ix+2)
cp &12
ld a,7
call nz,set_error
ld a,(ix+1)
cp &04
ld a,8
call nz,set_error
ld a,(ix+0)
and %11111000
cp &40
ld a,9
call nz,set_error

call stop_drive_motor
ret

.bad6_cylinder
call start_drive_motor

ld a,11
call move2track

ld a,%01000101				;; read data
call send_command_byte
ld a,(drive)
call send_command_byte
ld a,3					;; C
call send_command_byte
ld a,0						;; H
call send_command_byte
ld a,&c1					;; R
call send_command_byte
ld a,2						;; N
call send_command_byte
ld a,&c1					;; EOT
call send_command_byte
ld a,&2a					;; GPL
call send_command_byte
ld a,&ff					;; DTL
call send_command_byte

ld de,sector_buffer
call fdc_data_write
;; 0x0000
ex de,hl
ld bc,sector_buffer
or a
sbc hl,bc
ld a,h
or l
ld a,1
call nz,set_error
ex de,hl

call fdc_result_phase
;;call dump_results
;; 41,04,10,03,00,c1,02
ld ix,result_data
ld a,(ix+3)
cp 3
ld a,2
call nz,set_error
ld a,(ix+4)
or a
ld a,3
call nz,set_error
ld a,(ix+5)
cp &c1
ld a,4
call nz,set_error
ld a,(ix+6)
cp 2
ld a,5
call nz,set_error
ld a,(ix+2)
cp &10
ld a,7
call nz,set_error
ld a,(ix+1)
cp &04
ld a,8
call nz,set_error
ld a,(ix+0)
and %11111000
cp &40
ld a,9
call nz,set_error

call stop_drive_motor
ret


.nodata1
call start_drive_motor

ld a,11
call move2track

ld a,%01000110				;; read data
call send_command_byte
ld a,(drive)
call send_command_byte
ld a,11					;; C
call send_command_byte
ld a,0						;; H
call send_command_byte
ld a,&ca					;; R
call send_command_byte
ld a,2						;; N
call send_command_byte
ld a,&ca					;; EOT
call send_command_byte
ld a,&2a					;; GPL
call send_command_byte
ld a,&ff					;; DTL
call send_command_byte

ld de,0
call fdc_read_data2
ld a,d
or e
ld a,1
call nz,set_error

call fdc_result_phase
ld a,b
cp 7
ld a,9
call nz,set_error

;; 41,04,00,0b,00,ca,02
ld ix,result_data
ld a,(ix+3)
cp &b
ld a,2
call nz,set_error
ld a,(ix+4)
or a
ld a,3
call nz,set_error
ld a,(ix+5)
cp &ca
ld a,4
call nz,set_error
ld a,(ix+6)
cp 2
ld a,5
call nz,set_error
ld a,(ix+2)
or a
ld a,7
call nz,set_error
ld a,(ix+1)
cp 4
ld a,8
call nz,set_error
ld a,(ix+0)
and %11111000
cp &40
ld a,9
call nz,set_error

call stop_drive_motor
ret

.bad2_cylinder
call start_drive_motor

ld a,12
call move2track

ld a,%01000110				;; read data
call send_command_byte
ld a,(drive)
call send_command_byte
ld a,12					;; C
call send_command_byte
ld a,0						;; H
call send_command_byte
ld a,&c1					;; R
call send_command_byte
ld a,2						;; N
call send_command_byte
ld a,&c1					;; EOT
call send_command_byte
ld a,&2a					;; GPL
call send_command_byte
ld a,&ff					;; DTL
call send_command_byte

ld de,0
call fdc_read_data2
ld a,d
or e
ld a,1
call nz,set_error

call fdc_result_phase
ld a,b
cp 7
ld a,9
call nz,set_error

;; 41,04,12,0c,00,c1,02
ld ix,result_data
ld a,(ix+3)
cp &c
ld a,2
call nz,set_error
ld a,(ix+4)
or a
ld a,3
call nz,set_error
ld a,(ix+5)
cp &c1
ld a,4
call nz,set_error
ld a,(ix+6)
cp 2
ld a,5
call nz,set_error
ld a,(ix+2)
cp &12
ld a,6
call nz,set_error
ld a,(ix+1)
cp &04
ld a,7
call nz,set_error
ld a,(ix+0)
and %11111000
cp &40
ld a,8
call nz,set_error

call stop_drive_motor
ret


.bad3_cylinder
call start_drive_motor

ld a,11
call move2track

ld a,%01000110				;; read data
call send_command_byte
ld a,(drive)
call send_command_byte
ld a,10					;; C
call send_command_byte
ld a,0						;; H
call send_command_byte
ld a,&c1					;; R
call send_command_byte
ld a,2						;; N
call send_command_byte
ld a,&c1					;; EOT
call send_command_byte
ld a,&2a					;; GPL
call send_command_byte
ld a,&ff					;; DTL
call send_command_byte

ld de,0
call fdc_read_data2
ld a,d
or e
ld a,1
call nz,set_error

call fdc_result_phase
ld a,b
cp 7
ld a,9
call nz,set_error

;; 41,04,10,0c,00,c1,02
ld ix,result_data
ld a,(ix+3)
cp 10
ld a,2
call nz,set_error
ld a,(ix+4)
or a
ld a,3
call nz,set_error
ld a,(ix+5)
cp &c1
ld a,4
call nz,set_error
ld a,(ix+6)
cp 2
ld a,5
call nz,set_error
ld a,(ix+2)
cp &10
ld a,6
call nz,set_error
ld a,(ix+1)
cp &04
ld a,7
call nz,set_error
ld a,(ix+0)
and %11111000
cp &40
ld a,8
call nz,set_error

call stop_drive_motor
ret



.bad4_cylinder
call start_drive_motor

ld a,11
call move2track

ld a,%01000110				;; read data
call send_command_byte
ld a,(drive)
call send_command_byte
ld a,&ff					;; C
call send_command_byte
ld a,0						;; H
call send_command_byte
ld a,&c1					;; R
call send_command_byte
ld a,2						;; N
call send_command_byte
ld a,&c1					;; EOT
call send_command_byte
ld a,&2a					;; GPL
call send_command_byte
ld a,&ff					;; DTL
call send_command_byte

ld de,0
call fdc_read_data2
ld a,d
or e
ld a,1
call nz,set_error

call fdc_result_phase
ld a,b
cp 7
ld a,9
call nz,set_error
;; 41,04,10,ff,00,c1,02
;;call dump_results
ld ix,result_data
ld a,(ix+3)
cp &ff
ld a,2
call nz,set_error
ld a,(ix+4)
or a
ld a,3
call nz,set_error
ld a,(ix+5)
cp &c1
ld a,4
call nz,set_error
ld a,(ix+6)
cp 2
ld a,5
call nz,set_error
ld a,(ix+2)
cp &10
ld a,6
call nz,set_error
ld a,(ix+1)
cp &04
ld a,7
call nz,set_error
ld a,(ix+0)
and %11111000
cp &40
ld a,8
call nz,set_error

call stop_drive_motor
ret


.read_data
call start_drive_motor

ld a,11
call move2track

ld a,%01000110				;; read data
call send_command_byte
ld a,(drive)
call send_command_byte
ld a,11					;; C
call send_command_byte
ld a,0						;; H
call send_command_byte
ld a,&c1					;; R
call send_command_byte
ld a,2						;; N
call send_command_byte
ld a,&c1					;; EOT
call send_command_byte
ld a,&2a					;; GPL
call send_command_byte
ld a,&ff					;; DTL
call send_command_byte

ld de,0
call fdc_read_data2
ex de,hl
ld bc,512
or a
sbc hl,bc
ex de,hl
ld a,d
or e
ld a,1
call nz,set_error

call fdc_result_phase
ld a,b
cp 7
ld a,9
call nz,set_error
;; 41,80,00,0b,00,c1,02

;;call dump_results

ld ix,result_data
ld a,(ix+3)
cp &b
ld a,2
call nz,set_error
ld a,(ix+4)
or a
ld a,3
call nz,set_error
ld a,(ix+5)
cp &c1
ld a,4
call nz,set_error
ld a,(ix+6)
cp 2
ld a,5
call nz,set_error
ld a,(ix+2)
cp 0
ld a,6
call nz,set_error
ld a,(ix+1)
cp &80
ld a,7
call nz,set_error
ld a,(ix+0)
and %11111000
cp &40
ld a,8
call nz,set_error
call stop_drive_motor
ret


.read_data_rc
call start_drive_motor

call move2track0

ld a,11
call move2track

ld a,%01000110				;; read data
call send_command_byte
ld a,(drive)
call send_command_byte
ld a,11					;; C
call send_command_byte
ld a,0						;; H
call send_command_byte
ld a,&c1					;; R
call send_command_byte
ld a,2						;; N
call send_command_byte
ld a,&c1					;; EOT
call send_command_byte
ld a,&2a					;; GPL
call send_command_byte
ld a,&ff					;; DTL
call send_command_byte

call stop_drive_motor

;;ld de,0
;;call fdc_read_data2
;;ld a,d
;;call display_hex
;;ld a,e
;;call display_hex

call fdc_result_phase
call dump_results
;; ready change if reading data only
;; and not before?
;; 48,00,00,0b,00,c1,02
call stop_drive_motor
ret


;; read a sector, but write bytes to data register
;; see if overrun is still triggered!
.read_data_c
call start_drive_motor

call move2track0

ld a,11
call move2track

ld a,%01000110				;; read data
call send_command_byte
ld a,(drive)
call send_command_byte
ld a,11					;; C
call send_command_byte
ld a,0						;; H
call send_command_byte
ld a,&c1					;; R
call send_command_byte
ld a,2						;; N
call send_command_byte
ld a,&c1					;; EOT
call send_command_byte
ld a,&2a					;; GPL
call send_command_byte
ld a,&ff					;; DTL
call send_command_byte

ld de,sector_buffer
call fdc_data_write
;; 0x0200
ex de,hl
ld bc,sector_buffer
or a
sbc hl,bc
ex de,hl
ld a,d
call display_hex
ld a,e
call display_hex
call fdc_result_phase
call dump_results
;; 41,80,00,0b,00,c1,02
call stop_drive_motor
ret


.read_data_ov
call start_drive_motor

ld a,11
call move2track

ld a,%01000110				;; read data
call send_command_byte
ld a,(drive)
call send_command_byte
ld a,11					;; C
call send_command_byte
ld a,0						;; H
call send_command_byte
ld a,&c1					;; R
call send_command_byte
ld a,2						;; N
call send_command_byte
ld a,&c1					;; EOT
call send_command_byte
ld a,&2a					;; GPL
call send_command_byte
ld a,&ff					;; DTL
call send_command_byte

ld b,6
.rdo
ld hl,0
.rd1
dec hl
ld a,h
or l
jr nz,rd1
djnz rdo
call fdc_result_phase
;;call dump_results
;; 41,10,00,0b,00,c1,02
ld ix,result_data
ld a,(ix+3)
cp &b
ld a,2
call nz,set_error
ld a,(ix+4)
or a
ld a,3
call nz,set_error
ld a,(ix+5)
cp &c1
ld a,4
call nz,set_error
ld a,(ix+6)
cp 2
ld a,5
call nz,set_error
ld a,(ix+2)
or a
ld a,6
call nz,set_error
ld a,(ix+1)
cp &10
ld a,7
call nz,set_error
ld a,(ix+0)
and %11111000
cp &40
ld a,8
call nz,set_error

call stop_drive_motor
ret

.read_data_sis
call start_drive_motor

ld a,11
call move2track

ld a,%01000110				;; read data
call send_command_byte
ld a,(drive)
call send_command_byte
ld a,11					;; C
call send_command_byte
ld a,0						;; H
call send_command_byte
ld a,&c1					;; R
call send_command_byte
ld a,2						;; N
call send_command_byte
ld a,&c1					;; EOT
call send_command_byte
ld a,&2a					;; GPL
call send_command_byte
ld a,&ff					;; DTL
call send_command_byte

ld de,0
call fdc_read_data2

call fdc_result_phase

ld a,%1000
call send_command_byte
call fdc_result_phase
;;call dump_results
;; 80
ld a,b
cp 1
ld a,1
call nz,set_error

ld ix,result_data
ld a,(ix+0)
cp &80
ld a,2
call nz,set_error

call stop_drive_motor
ret

.read_dtl_data
call start_drive_motor

ld a,11
call move2track

ld a,%01000110				;; read data
call send_command_byte
ld a,(drive)
call send_command_byte
ld a,11					;; C
call send_command_byte
ld a,0						;; H
call send_command_byte
ld a,&c1					;; R
call send_command_byte
ld a,2						;; N
call send_command_byte
ld a,&c1					;; EOT
call send_command_byte
ld a,&2a					;; GPL
call send_command_byte
ld a,&4b					;; DTL
call send_command_byte

ld de,0
call fdc_read_data2
ex de,hl
ld bc,512
or a
sbc hl,bc
ld a,h
or l
ld a,1
call nz,set_error
ex de,hl

call fdc_result_phase
;;call dump_results
;; 41,80,00,0b,00,c1,02
ld ix,result_data
ld a,(ix+3)
cp &b
ld a,2
call nz,set_error
ld a,(ix+4)
or a
ld a,3
call nz,set_error
ld a,(ix+5)
cp &c1
ld a,4
call nz,set_error
ld a,(ix+6)
cp 2
ld a,5
call nz,set_error
ld a,(ix+2)
cp 0
ld a,6
call nz,set_error
ld a,(ix+1)
cp &80
ld a,7
call nz,set_error
ld a,(ix+0)
and %11111000
cp &40
ld a,8
call nz,set_error

call stop_drive_motor
ret

.read_data2
call start_drive_motor

ld a,11
call move2track

ld a,%01000110				;; read data
call send_command_byte
ld a,(drive)
call send_command_byte
ld a,11					;; C
call send_command_byte
ld a,&aa				;; H
call send_command_byte
ld a,&c1					;; R
call send_command_byte
ld a,2						;; N
call send_command_byte
ld a,&c1					;; EOT
call send_command_byte
ld a,&2a					;; GPL
call send_command_byte
ld a,&ff					;; DTL
call send_command_byte

ld de,0
call fdc_read_data2
ld a,d
or e
ld a,1
call nz,set_error
call fdc_result_phase
;;call dump_results
;; 41,04,00,0b,aa,c1,02

ld ix,result_data
ld a,(ix+3)
cp &b
ld a,2
call nz,set_error
ld a,(ix+4)
cp &aa
ld a,3
call nz,set_error
ld a,(ix+5)
cp &c1
ld a,4
call nz,set_error
ld a,(ix+6)
cp 2
ld a,5
call nz,set_error
ld a,(ix+2)
cp 0
ld a,6
call nz,set_error
ld a,(ix+1)
cp 4
ld a,7
call nz,set_error
ld a,(ix+0)
and %11111000
cp &40
ld a,8
call nz,set_error

call stop_drive_motor
ret

.read_data3
call start_drive_motor

ld a,11
call move2track

ld a,%01000110				;; read data
call send_command_byte
ld a,(drive)
call send_command_byte
ld a,11					;; C
call send_command_byte
ld a,0				;; H
call send_command_byte
ld a,&c1					;; R
call send_command_byte
ld a,3						;; N
call send_command_byte
ld a,&c1					;; EOT
call send_command_byte
ld a,&2a					;; GPL
call send_command_byte
ld a,&ff					;; DTL
call send_command_byte

ld de,0
call fdc_read_data2
ld a,d
or e
ld a,1
call nz,set_error

call fdc_result_phase
;;call dump_results
;; 41,04,00,0b,00,c1,03

ld ix,result_data
ld a,(ix+3)
cp &b
ld a,2
call nz,set_error
ld a,(ix+4)
cp 0
ld a,3
call nz,set_error
ld a,(ix+5)
cp &c1
ld a,4
call nz,set_error
ld a,(ix+6)
cp 3
ld a,5
call nz,set_error
ld a,(ix+2)
cp 0
ld a,6
call nz,set_error
ld a,(ix+1)
cp 4
ld a,7
call nz,set_error
ld a,(ix+0)
and %11111000
cp &40
ld a,8
call nz,set_error

call stop_drive_motor
ret


.read_de_data
call start_drive_motor

ld a,4
call move2track

ld a,%01000110				;; read data
call send_command_byte
ld a,(drive)
call send_command_byte
ld a,0					;; C
call send_command_byte
ld a,0						;; H
call send_command_byte
ld a,&aa					;; R
call send_command_byte
ld a,3						;; N
call send_command_byte
ld a,&aa					;; EOT
call send_command_byte
ld a,&2a					;; GPL
call send_command_byte
ld a,&ff					;; DTL
call send_command_byte

ld de,0
call fdc_read_data2
;; 0x0400
ex de,hl
ld bc,&400
or a
sbc hl,bc
ld a,h
or l
ex de,hl
ld a,1
call nz,set_error

call fdc_result_phase
;; 41,20,20,00,00,aa,03
ld ix,result_data
ld a,(ix+3)
or a
ld a,2
call nz,set_error
ld a,(ix+4)
or a
ld a,3
call nz,set_error
ld a,(ix+5)
cp &aa
ld a,4
call nz,set_error
ld a,(ix+6)
cp 3
ld a,5
call nz,set_error
ld a,(ix+2)
cp &20
ld a,6
call nz,set_error
ld a,(ix+1)
cp &20
ld a,7
call nz,set_error
ld a,(ix+0)
and %11111000
cp &40
ld a,8
call nz,set_error
call stop_drive_motor

ret


.read_nr_data
call start_drive_motor

ld a,4
call move2track

call stop_drive_motor

ld a,%01000110				;; read data
call send_command_byte
ld a,(drive)
call send_command_byte
ld a,0					;; C
call send_command_byte
ld a,0						;; H
call send_command_byte
ld a,&aa					;; R
call send_command_byte
ld a,3						;; N
call send_command_byte
ld a,&aa					;; EOT
call send_command_byte
ld a,&2a					;; GPL
call send_command_byte
ld a,&ff					;; DTL
call send_command_byte

ld de,0
call fdc_read_data2
ld a,d
or e
ld a,1
call nz,set_error

call fdc_result_phase
;;call dump_results
;; 48,00,00,00,00,aa,03
ld ix,result_data
ld a,(ix+3)
or a
ld a,2
call nz,set_error
ld a,(ix+4)
or a
ld a,3
call nz,set_error
ld a,(ix+5)
cp &aa
ld a,4
call nz,set_error
ld a,(ix+6)
cp 3
ld a,5
call nz,set_error
ld a,(ix+2)
or a
ld a,6
call nz,set_error
ld a,(ix+1)
or a
ld a,7
call nz,set_error
ld a,(ix+0)
and %11111000
cp &48
ld a,8
call nz,set_error
call stop_drive_motor

ret


.test_write
call start_drive_motor

ld a,0
call move2track

;; fill with pattern
ld hl,sector_buffer
ld bc,512
ld d,0
.tw1
ld (hl),d
inc hl
inc d
dec bc
ld a,b
or c
jp nz,tw1


ld a,%01000101				;; write data
call send_command_byte
ld a,(drive)
call send_command_byte
ld a,0					;; C
call send_command_byte
ld a,0						;; H
call send_command_byte
ld a,&41					;; R
call send_command_byte
ld a,2						;; N
call send_command_byte
ld a,&41					;; EOT
call send_command_byte
ld a,&2a					;; GPL
call send_command_byte
ld a,&ff					;; DTL
call send_command_byte

ld de,sector_buffer
call fdc_data_write
ex de,hl
ld bc,sector_buffer
or a 
sbc hl,bc
ld bc,512
or a
sbc hl,bc
ex de,hl
ld a,d
or e
ld a,1
call nz,set_error

call fdc_result_phase
ld a,b
cp 7
ld a,9
call nz,set_error

;; 41,80,00,00,00,41,02
;;call dump_results

di
call start_drive_motor

;; read it
ld a,%01000110				;; read data
call send_command_byte
ld a,(drive)
call send_command_byte
ld a,0					;; C
call send_command_byte
ld a,0						;; H
call send_command_byte
ld a,&41					;; R
call send_command_byte
ld a,2						;; N
call send_command_byte
ld a,&41					;; EOT
call send_command_byte
ld a,&2a					;; GPL
call send_command_byte
ld a,&ff					;; DTL
call send_command_byte

ld de,sector_buffer
call fdc_data_read
call fdc_result_phase

ld hl,sector_buffer
ld bc,512
ld d,0
.tw2 ld a,(hl)
cp d
jr z,tw4
ld a,10
call set_error
jp tw3
.tw4
inc hl
inc d
dec bc
ld a,b
or c
jp nz,tw2
.tw3

;; fill with pattern
ld hl,sector_buffer
ld e,l
ld d,h
inc de
ld (hl),&aa
ld bc,512
ldir

di
call start_drive_motor

ld a,%01000101				;; write data
call send_command_byte
ld a,(drive)
call send_command_byte
ld a,0					;; C
call send_command_byte
ld a,0						;; H
call send_command_byte
ld a,&41					;; R
call send_command_byte
ld a,2						;; N
call send_command_byte
ld a,&41					;; EOT
call send_command_byte
ld a,&2a					;; GPL
call send_command_byte
ld a,&ff					;; DTL
call send_command_byte

ld de,sector_buffer
call fdc_data_write
call fdc_result_phase

di
call start_drive_motor

;; read it
ld a,%01000110				;; read data
call send_command_byte
ld a,(drive)
call send_command_byte
ld a,0					;; C
call send_command_byte
ld a,0						;; H
call send_command_byte
ld a,&41					;; R
call send_command_byte
ld a,2						;; N
call send_command_byte
ld a,&41					;; EOT
call send_command_byte
ld a,&2a					;; GPL
call send_command_byte
ld a,&ff					;; DTL
call send_command_byte

ld de,sector_buffer
call fdc_data_read

call fdc_result_phase

ld hl,sector_buffer
ld bc,512
.tw5 ld a,(hl)
cp &aa
jr z,tw6
ld a,11
call set_error
jp tw7
.tw6
dec bc
ld a,b
or c
jp nz,tw5

.tw7

call stop_drive_motor
ret

.test_write_rc
call start_drive_motor

ld a,0
call move2track

ld a,%01000101				;; write data
call send_command_byte
ld a,(drive)
call send_command_byte
ld a,0					;; C
call send_command_byte
ld a,0						;; H
call send_command_byte
ld a,&41					;; R
call send_command_byte
ld a,2						;; N
call send_command_byte
ld a,&41					;; EOT
call send_command_byte
ld a,&2a					;; GPL
call send_command_byte
ld a,&ff					;; DTL
call send_command_byte

call stop_drive_motor

;;ld de,0
;;call fdc_read_data2
;;ld a,d
;;call display_hex
;;ld a,e
;;call display_hex
call fdc_result_phase

call dump_results

call stop_drive_motor
ret

.test_write_c
call start_drive_motor

ld a,0
call move2track

ld a,%01000101				;; write data
call send_command_byte
ld a,(drive)
call send_command_byte
ld a,0					;; C
call send_command_byte
ld a,0						;; H
call send_command_byte
ld a,&41					;; R
call send_command_byte
ld a,2						;; N
call send_command_byte
ld a,&41					;; EOT
call send_command_byte
ld a,&2a					;; GPL
call send_command_byte
ld a,&ff					;; DTL
call send_command_byte

ld de,0
call fdc_read_data2
;; 0x0200
ld a,d
call display_hex
ld a,e
call display_hex
call fdc_result_phase
;; 41,10,00,00,00,41,02

call dump_results

call stop_drive_motor
ret


.test_write_ov
call start_drive_motor

ld a,0
call move2track

ld a,%01000101				;; write data
call send_command_byte
ld a,(drive)
call send_command_byte
ld a,0					;; C
call send_command_byte
ld a,0						;; H
call send_command_byte
ld a,&41					;; R
call send_command_byte
ld a,2						;; N
call send_command_byte
ld a,&41					;; EOT
call send_command_byte
ld a,&2a					;; GPL
call send_command_byte
ld a,&ff					;; DTL
call send_command_byte

ld b,6
.two
ld hl,0
.two2
dec hl
ld a,h
or l
jr nz,two2
djnz two

call fdc_result_phase
;;call dump_results
;; 41,10,00,00,00,41,02
ld ix,result_data
ld a,(ix+3)
or a
ld a,2
call nz,set_error
ld a,(ix+4)
or a
ld a,3
call nz,set_error
ld a,(ix+5)
cp &41
ld a,4
call nz,set_error
ld a,(ix+6)
cp 2
ld a,5
call nz,set_error
ld a,(ix+2)
or a
ld a,6
call nz,set_error
ld a,(ix+1)
cp &10
ld a,7
call nz,set_error
ld a,(ix+0)
and %11111000
cp &40
ld a,8
call nz,set_error

call stop_drive_motor
ret

.test_write_nr
call start_drive_motor

ld a,0
call move2track

call stop_drive_motor

ld a,%01000101				;; write data
call send_command_byte
ld a,(drive)
call send_command_byte
ld a,0					;; C
call send_command_byte
ld a,0						;; H
call send_command_byte
ld a,&41					;; R
call send_command_byte
ld a,2						;; N
call send_command_byte
ld a,&41					;; EOT
call send_command_byte
ld a,&2a					;; GPL
call send_command_byte
ld a,&ff					;; DTL
call send_command_byte

ld de,sector_buffer
call fdc_data_write
ex de,hl
ld bc,sector_buffer
or a 
sbc hl,bc
ld a,h
or l
ld a,1
call nz,set_error
ex de,hl

call fdc_result_phase
;; 48,00,00,00,00,41,02
ld ix,result_data
ld a,(ix+3)
or a
ld a,2
call nz,set_error
ld a,(ix+4)
or a
ld a,3
call nz,set_error
ld a,(ix+5)
cp &41
ld a,4
call nz,set_error
ld a,(ix+6)
cp 2
ld a,5
call nz,set_error
ld a,(ix+2)
or a
ld a,6
call nz,set_error
ld a,(ix+1)
or a
ld a,7
call nz,set_error
ld a,(ix+0)
and %11111000
cp &48
ld a,8
call nz,set_error
call stop_drive_motor

;;call dump_results
ret

.test_write2
call start_drive_motor

ld a,0
call move2track

ld a,%01000101				;; write data
call send_command_byte
ld a,(drive)
call send_command_byte
ld a,0					;; C
call send_command_byte
ld a,0						;; H
call send_command_byte
ld a,&41					;; R
call send_command_byte
ld a,2						;; N
call send_command_byte
ld a,&41					;; EOT
call send_command_byte
ld a,&2a					;; GPL
call send_command_byte
ld a,&ff					;; DTL
call send_command_byte

ld de,sector_buffer
call fdc_data_write
call fdc_result_phase

ld a,%01001001				;; write deleted data
call send_command_byte
ld a,(drive)
call send_command_byte
ld a,0					;; C
call send_command_byte
ld a,0						;; H
call send_command_byte
ld a,&41					;; R
call send_command_byte
ld a,2						;; N
call send_command_byte
ld a,&41					;; EOT
call send_command_byte
ld a,&2a					;; GPL
call send_command_byte
ld a,&ff					;; DTL
call send_command_byte

ld de,sector_buffer
call fdc_data_write
call fdc_result_phase

;;call dump_results
;; 41,80,00,00,00,41,02
ld ix,result_data
ld a,(ix+3)
or a
ld a,9
call nz,set_error
ld a,(ix+4)
or a
ld a,10
call nz,set_error
ld a,(ix+5)
cp &41
ld a,11
call nz,set_error
ld a,(ix+6)
cp 2
ld a,12
call nz,set_error
ld a,(ix+2)
or a
ld a,13
call nz,set_error
ld a,(ix+1)
cp &80
ld a,14
call nz,set_error
ld a,(ix+0)
and %11111000
cp &40
ld a,15
call nz,set_error

di
call start_drive_motor

;; read it
ld a,%01000110				;; read data
call send_command_byte
ld a,(drive)
call send_command_byte
ld a,0					;; C
call send_command_byte
ld a,0						;; H
call send_command_byte
ld a,&41					;; R
call send_command_byte
ld a,2						;; N
call send_command_byte
ld a,&41					;; EOT
call send_command_byte
ld a,&2a					;; GPL
call send_command_byte
ld a,&ff					;; DTL
call send_command_byte

ld de,sector_buffer
call fdc_data_read
call fdc_result_phase

;;call dump_results
;; 01,00,40,00,00,41,02
ld ix,result_data
ld a,(ix+3)
or a
ld a,2
call nz,set_error
ld a,(ix+4)
or a
ld a,3
call nz,set_error
ld a,(ix+5)
cp &41
ld a,4
call nz,set_error
ld a,(ix+6)
cp 2
ld a,5
call nz,set_error
ld a,(ix+2)
cp &40
ld a,6
call nz,set_error
ld a,(ix+1)
cp 0
ld a,7
call nz,set_error
ld a,(ix+0)
and %11111000
or a
ld a,8
call nz,set_error

call stop_drive_motor
ret


.test_write_mt
call start_drive_motor

ld a,2
call move2track

ld a,%11000101				;; write data
call send_command_byte
ld a,(drive)
call send_command_byte
ld a,2					;; C
call send_command_byte
ld a,0						;; H
call send_command_byte
ld a,&1					;; R
call send_command_byte
ld a,2						;; N
call send_command_byte
ld a,&1					;; EOT
call send_command_byte
ld a,&2a					;; GPL
call send_command_byte
ld a,&ff					;; DTL
call send_command_byte

ld de,sector_buffer
call fdc_data_write
;; 0x0400
ex de,hl
ld bc,sector_buffer
or a
sbc hl,bc
ld bc,&400
or a
sbc hl,bc
ld a,h
or l
ld a,1
call nz,set_error
ex de,hl

call fdc_result_phase
;;call dump_results
;; 45,80,00,02,01,01,02
ld ix,result_data
ld a,(ix+3)
cp &2
ld a,2
call nz,set_error
ld a,(ix+4)
cp 1
ld a,3
call nz,set_error
ld a,(ix+5)
cp 1
ld a,4
call nz,set_error
ld a,(ix+6)
cp 2
ld a,5
call nz,set_error
ld a,(ix+2)
or a
ld a,6
call nz,set_error
ld a,(ix+1)
cp &80
ld a,7
call nz,set_error
ld a,(ix+0)
and %11111000
cp &40
ld a,8
call nz,set_error

call stop_drive_motor
ret

.test_write_sk
call start_drive_motor

ld a,10
call move2track

ld a,%01100101				;; write data
call send_command_byte
ld a,(drive)
call send_command_byte
ld a,10					;; C
call send_command_byte
ld a,0						;; H
call send_command_byte
ld a,&1					;; R
call send_command_byte
ld a,2						;; N
call send_command_byte
ld a,&3					;; EOT
call send_command_byte
ld a,&2a					;; GPL
call send_command_byte
ld a,&ff					;; DTL
call send_command_byte

;; 0x0600
ld de,sector_buffer
call fdc_data_write
ex de,hl
ld bc,sector_buffer
or a
sbc hl,bc
ld bc,&600
or a
sbc hl,bc
ld a,h
or l
ld a,1
call nz,set_error
ex de,hl
call fdc_result_phase
;; call dump_results
;; 41,80,00,0a,00,03,02

ld ix,result_data
ld a,(ix+3)
cp &a
ld a,2
call nz,set_error
ld a,(ix+4)
or a
ld a,3
call nz,set_error
ld a,(ix+5)
cp &3
ld a,4
call nz,set_error
ld a,(ix+6)
cp 2
ld a,5
call nz,set_error
ld a,(ix+2)
cp 0
ld a,6
call nz,set_error
ld a,(ix+1)
cp &80
ld a,7
call nz,set_error
ld a,(ix+0)
and %11111000
cp &40
ld a,8
call nz,set_error


call stop_drive_motor
ret


.read_data_eot
call start_drive_motor

ld a,11
call move2track

ld a,%01000110				;; read data
call send_command_byte
ld a,(drive)
call send_command_byte
ld a,11					;; C
call send_command_byte
ld a,0						;; H
call send_command_byte
ld a,&c1					;; R
call send_command_byte
ld a,2						;; N
call send_command_byte
ld a,&c9					;; EOT
call send_command_byte
ld a,&2a					;; GPL
call send_command_byte
ld a,&ff					;; DTL
call send_command_byte

ld de,0
call fdc_read_data2
ex de,hl
ld bc,512*9
or a
sbc hl,bc
ex de,hl
ld a,d
or e
ld a,1
call nz,set_error
;; 41,80,00,0b,00,c9,02

call fdc_result_phase
ld a,b
cp 7
ld a,9
call nz,set_error
ld ix,result_data

ld a,(ix+3)
cp &b
ld a,2
call nz,set_error
ld a,(ix+4)
or a
ld a,3
call nz,set_error
ld a,(ix+5)
cp &c9
ld a,4
call nz,set_error
ld a,(ix+6)
cp 2
ld a,5
call nz,set_error
ld a,(ix+2)
cp 0
ld a,6
call nz,set_error
ld a,(ix+1)
cp &80
ld a,7
call nz,set_error
ld a,(ix+0)
and %11111000
cp &40
ld a,8
call nz,set_error
call stop_drive_motor
ret

.invalid_codes
defb %00000
defb %00001
defb %01011
defb %01110
defb %10000
defb %10010
defb %10011
defb %10100
defb %10101
defb %10110
defb %10111
defb %11000
defb %11010
defb %11011
defb %11100
defb %11110
defb %11111


.invalid
;; ensure we're done
ld a,%1000						;; sense interrupt status
call send_command_byte
call fdc_result_phase

ld ix,invalid_codes
ld b,17
ld a,2
.inv
push af
push bc
push af


ld a,(ix+0)		;; get command byte
inc ix
call send_command_byte

;; read main status register
call fdc_read_main_status_register
call display_hex
call fdc_read_main_status_register
and %11110000
cp %11010000
					 
pop de
ld a,d					;; error!
call nz,set_error

ld de,0
call fdc_read_data2		;; get execution phase data (should be none)
ld a,d
or e
ld a,1
call nz,set_error

call fdc_result_phase
ld a,b					;; check number of bytes returned
cp 1
ld a,1
call nz,set_error

ld ix,result_data
ld a,(ix+0)				;; check it is the invalid byte
cp &80
ld a,1
call nz,set_error

pop bc
pop af
inc a
djnz inv
ret

;;---------------------------------------------------------------------------------


.check_dtl1
;; using DTL as the length of data to read, check that DTL=0
;; is handled correctly

call start_drive_motor

ld a,15
call move2track

ld a,%01000110				;; read data
call send_command_byte
ld a,(drive)				;; drive
call send_command_byte
ld a,15						;; C
call send_command_byte
ld a,0						;; H
call send_command_byte
ld a,1						;; R
call send_command_byte
ld a,0						;; N
call send_command_byte
ld a,1						;; EOT
call send_command_byte
ld a,&2a					;; GPL
call send_command_byte
ld a,128						;; DTL
call send_command_byte

ld de,0
call fdc_read_data2
push de 
call fdc_result_phase
call dump_results
pop de
ld a,d
call display_hex
ld a,e
call display_hex

;; 41,80,00,0f,00,01,00 transfer 80 bytes

call stop_drive_motor
ret

.check_dtl2
;; using DTL as the length of data to read, check that DTL=0
;; is handled correctly

call start_drive_motor

ld a,15
call move2track

ld a,%01000110				;; read data
call send_command_byte
ld a,(drive)				;; drive
call send_command_byte
ld a,15						;; C
call send_command_byte
ld a,0						;; H
call send_command_byte
ld a,1						;; R
call send_command_byte
ld a,0						;; N
call send_command_byte
ld a,1						;; EOT
call send_command_byte
ld a,&2a					;; GPL
call send_command_byte
ld a,1						;; DTL
call send_command_byte

ld de,0
call fdc_read_data2
push de
call fdc_result_phase
call dump_results
pop de
ld a,d
call display_hex
ld a,e
call display_hex

;; 41,80,00,0f,00,01,00 transfer 80 bytes

call stop_drive_motor
ret

.check_dtl3
;; using DTL as the length of data to read, check that DTL=0
;; is handled correctly

di
call start_drive_motor

ld a,15
call move2track

;; initialise sector data to be &aa
ld hl,sector_buffer
ld e,l
ld d,h
inc de
ld (hl),&aa
ld bc,512
ldir

;; fill sector entirely with data-byte
ld a,%01000101					;; write data
call send_command_byte
ld a,(drive)
call send_command_byte
ld a,15
call send_command_byte
ld a,0
call send_command_byte
ld a,1
call send_command_byte
ld a,0
call send_command_byte
ld a,1
call send_command_byte
ld a,&2a
call send_command_byte
ld a,&ff
call send_command_byte
ld de,sector_buffer
call fdc_data_write
call fdc_result_phase

call dump_results


;; initialise sector data to be &55
ld hl,sector_buffer
ld e,l
ld d,h
inc de
ld (hl),&55
ld bc,512
ldir

di
call start_drive_motor
;; fill sector partially with data-byte
ld a,%01000101					;; write data
call send_command_byte
ld a,(drive)
call send_command_byte
ld a,15
call send_command_byte
ld a,0
call send_command_byte
ld a,1
call send_command_byte
ld a,0
call send_command_byte
ld a,1
call send_command_byte
ld a,&2a
call send_command_byte
ld a,128
call send_command_byte
ld de,sector_buffer
call fdc_data_write
call fdc_result_phase

call dump_results
di
call start_drive_motor

;; read data written
ld a,%01000110				;; read data
call send_command_byte
ld a,(drive)				;; drive
call send_command_byte
ld a,9						;; C
call send_command_byte
ld a,0						;; H
call send_command_byte
ld a,1						;; R
call send_command_byte
ld a,0						;; N
call send_command_byte
ld a,1						;; EOT
call send_command_byte
ld a,&2a					;; GPL
call send_command_byte
ld a,&ff					;; DTL
call send_command_byte

ld de,sector_buffer
call fdc_data_read
call fdc_result_phase

ld hl,sector_buffer
ld bc,256
ld de,0

.cd4aa
ld a,(hl)
cp &55
jr nz,cd4a
inc de
inc hl
dec bc
ld a,b
or c
jr nz,cd4aa
.cd4a
ex de,hl
ld bc,128
or a 
sbc hl,bc
ld a,h
or l
ld a,1
call nz,set_error
ex de,hl

call dump_results

call stop_drive_motor
ret


.check_dtl_00
;; using DTL as the length of data to read, check that DTL=0
;; is handled correctly

call start_drive_motor

ld a,15
call move2track

ld a,%01000110				;; read data
call send_command_byte
ld a,(drive)				;; drive
call send_command_byte
ld a,15						;; C
call send_command_byte
ld a,0						;; H
call send_command_byte
ld a,1						;; R
call send_command_byte
ld a,0						;; N
call send_command_byte
ld a,1						;; EOT
call send_command_byte
ld a,&2a					;; GPL
call send_command_byte
ld a,0						;; DTL
call send_command_byte

ld de,0
call fdc_read_data2
push de

call fdc_result_phase
ld a,b
cp 7
ld a,9
call nz,set_error

call dump_results
pop de
ld a,d
call display_hex
ld a,e
call display_hex
;; 0050
;; 41,80,00,0f,00,01,00 transfer 80 bytes

call stop_drive_motor


ret




;;---------------------------------------------------------------------------
;; attempt to read a non-existant sector, then do a read-id immediatly
;; after
;;
;; the fdc will attempt to find the sector, but fail after seeing
;; the index pulse for the second time. At this point we are at the start
;; of the track, and reading the next id will return the id of the first
;; sector on the track.
;;
;; carry flag set if successful
;; carry flag clear if unsuccessful

.sync_start_of_track
;;di

call start_drive_motor

ld a,10
call move2track

ld a,%01000110				;; read data
call send_command_byte
ld a,(drive)				;; drive
call send_command_byte
ld a,10						;; C
call send_command_byte
ld a,0						;; H
call send_command_byte
ld a,10						;; R (non-existant sector id)
call send_command_byte
ld a,2						;; N
call send_command_byte		
ld a,10						;; EOT (non-existant sector id)
call send_command_byte		
ld a,&2a					;; GPL
call send_command_byte
ld a,&ff					;; DTL
call send_command_byte

;; ignore any data
ld de,0
call fdc_read_data2

call fdc_result_phase
ld a,b
cp 7
ld a,9
call nz,set_error
ld ix,result_data
ld a,(ix+3)
cp 10
ld a,1
call nz,set_error
ld a,(ix+4)
or a
ld a,2
call nz,set_error
ld a,(ix+5)
cp 10
ld a,3
call nz,set_error
ld a,(ix+6)
cp 2
ld a,4
call nz,set_error
ld a,(ix+2)
or a
ld a,5
call nz,set_error
ld a,(ix+1)
cp 4
ld a,6
call nz,set_error
ld a,(ix+0)
and %11111000
cp &40
ld a,7
call nz,set_error


;; now send read id

ld a,%01001010				;; read id
call send_command_byte
ld a,(drive)
call send_command_byte
call fdc_result_phase
ld a,b
cp 7
ld a,9
call nz,set_error

call stop_drive_motor

;;ei

;; check id is correct
ld ix,result_data
ld a,(ix+3)
cp 10
ld a,8
call nz,set_error
ld a,(ix+4)
cp 0
ld a,9
call nz,set_error
ld a,(ix+5)
cp 1
ld a,10
call nz,set_error
ld a,(ix+6)
cp 2
ld a,11
call nz,set_error
ld a,(ix+2)
or a
ld a,12
call nz,set_error
ld a,(ix+1)
or a
ld a,13
call nz,set_error
ld a,(ix+0)
and %11111000
or a
ld a,14
call nz,set_error

ret
;;----------------------------------------------------------------------
;; ready and not-ready tests
;; 
.drive_status1
;;di
;; 00 20

;; ensure motor is *off*
call stop_drive_motor

ld b,3
.ds1a ld hl,0
.ds1b dec hl
ld a,h
or l
jr nz,ds1b
djnz ds1a

ld a,%100						;; sense drive status
call send_command_byte
ld a,(drive)					;; drive status of connected drive
call send_command_byte
call fdc_result_phase			;; status should show that drive is NOT READY!
call dump_results

;; 1. check for number of result bytes
ld a,b
cp 1
ld a,1
call nz,set_error

ld ix,result_data

;; 2. check that the drive index is the same as the drive specified
ld a,(ix+0)
and &3
ld c,a
ld a,(drive)
and &3
cp c
ld a,2
call nz,set_error

;; 3. check that the drive is not ready
ld a,(ix+0)
and %00100000
ld a,3
call nz,set_error

;; start motor
call start_drive_motor

ld a,%100					;; sense drive status
call send_command_byte
ld a,(drive)				;; drive status of connected drive
call send_command_byte
call fdc_result_phase

call dump_results

ld ix,result_data
ld a,(ix+0)
and %00100000				;; status should show that drive is READY!
ld a,4
call z,set_error

call stop_drive_motor

;;ei
ret

;;----------------------------------------------------------------------
;; track0 test
;; 
.drive_status2
;;di

call start_drive_motor
call move2track0

ld a,%100						;; sense drive status
call send_command_byte
ld a,(drive)					;; drive status of connected drive
call send_command_byte
call fdc_result_phase			
ld a,b
cp 1
ld a,1
call nz,set_error

;; 31

ld ix,result_data
ld a,(ix+0)
and %00010000					;; check that drive is at track 0!
ld a,2
call z,set_error

ld a,1
call move2track

ld a,%100					;; sense drive status
call send_command_byte
ld a,(drive)				;; drive status of connected drive
call send_command_byte
call fdc_result_phase

;; 21

ld ix,result_data
ld a,(ix+0)
and %00010000				;; status should show that drive is *not* at track 0
ld a,3
call nz,set_error

;;ei
ret


.read_id_low
call start_drive_motor

ld a,0
call move2track

ld a,%00001010				;; read id; low density!
call send_command_byte
ld a,(drive)
call send_command_byte
call fdc_result_phase
;; 41,01,00,08,00,02,08

ld ix,result_data
ld a,(ix+2)
or a
ld a,1
call nz,set_error
ld a,(ix+1)
cp 1
ld a,2
call nz,set_error
ld a,(ix+0)
and %11111000
cp &40
ld a,3
call nz,set_error

call stop_drive_motor
ret


.read_id_de
call start_drive_motor

ld a,4
call move2track

ld a,%01001010				;; read id; low density!
call send_command_byte
ld a,(drive)
call send_command_byte
call fdc_result_phase
;;call dump_results

;; 01,00,00,00,00,aa,03
ld ix,result_data
ld a,(ix+3)
or a
ld a,2
call nz,set_error
ld a,(ix+4)
or a
ld a,3
call nz,set_error
ld a,(ix+5)
cp &aa
ld a,4
call nz,set_error
ld a,(ix+6)
cp 3
ld a,5
call nz,set_error
ld a,(ix+2)
or a
ld a,6
call nz,set_error
ld a,(ix+1)
or a
ld a,7
call nz,set_error
ld a,(ix+0)
and %11111000
or a
ld a,8
call nz,set_error

call stop_drive_motor
ret


.read_id_nr
call start_drive_motor

ld a,0
call move2track

call stop_drive_motor

ld a,%01001010				
call send_command_byte
ld a,(drive)
call send_command_byte
call fdc_result_phase
;;call dump_results
ld ix,result_data
ld a,(ix+0)
and %11111000
cp &48
ld a,1
call nz,set_error
ld a,(ix+1)
or a
ld a,2
call nz,set_error
ld a,(ix+2)
or a
ld a,3
call nz,set_error
ret


.read_id_rc
call start_drive_motor

ld a,0
call move2track

ld a,%01001010				
call send_command_byte
ld a,(drive)
call send_command_byte

call stop_drive_motor

call fdc_result_phase
call dump_results
ret


.read_data_low
call start_drive_motor

ld a,0
call move2track

ld a,%00000110				;; read data
call send_command_byte
ld a,(drive)				;; drive
call send_command_byte
ld a,0						;; C
call send_command_byte
ld a,0						;; H
call send_command_byte
ld a,&41						;; R (non-existant sector id)
call send_command_byte
ld a,2						;; N
call send_command_byte		
ld a,&41						;; EOT (non-existant sector id)
call send_command_byte		
ld a,&2a					;; GPL
call send_command_byte
ld a,&ff					;; DTL
call send_command_byte

;; ignore any data
ld de,0
call fdc_read_data2
ld a,d
or e
ld a,1
call nz,display_hex

call fdc_result_phase
ld a,b
cp 7
ld a,9
call nz,set_error

;; 41,01,00,00,00,41,02
ld ix,result_data
ld a,(ix+3)
or a
ld a,2
call nz,set_error
ld a,(ix+4)
or a
ld a,3
call nz,set_error
ld a,(ix+5)
cp &41
ld a,4
call nz,set_error
ld a,(ix+6)
cp 2
ld a,5
call nz,set_error
ld a,(ix+2)
or a
ld a,6
call nz,set_error
ld a,(ix+1)
cp &1
ld a,7
call nz,set_error
ld a,(ix+0)
and %11111000
cp &40
ld a,8
call nz,set_error

call stop_drive_motor
ret


.read_id_unform
;;di
call start_drive_motor

ld a,8
call move2track

ld a,%01001010				;; read id
call send_command_byte
ld a,(drive)
call send_command_byte
call fdc_result_phase
ld a,b
cp 7
ld a,9
call nz,set_error

ld ix,result_data
ld a,(ix+2)
or a
ld a,1
call nz,set_error
ld a,(ix+1)
cp 1
ld a,2
call nz,set_error
ld a,(ix+0)
and %11111000
cp &40
ld a,3
call nz,set_error

call stop_drive_motor
;;ei
ret


.read_data_unform
call start_drive_motor

ld a,8
call move2track

ld a,%01000110				;; read data
call send_command_byte
ld a,(drive)				;; drive
call send_command_byte
ld a,8						;; C
call send_command_byte
ld a,0						;; H
call send_command_byte
ld a,&41						;; R (non-existant sector id)
call send_command_byte
ld a,2						;; N
call send_command_byte		
ld a,&41						;; EOT (non-existant sector id)
call send_command_byte		
ld a,&2a					;; GPL
call send_command_byte
ld a,&ff					;; DTL
call send_command_byte

;; ignore any data
ld de,0
call fdc_read_data2
ld a,d
or e
ld a,1
call nz,set_error

call fdc_result_phase
;; 41,01,00,08,00,41,02
ld a,b
cp 7
ld a,9
call nz,set_error
call dump_results

ld ix,result_data
ld a,(ix+3)
cp 8
ld a,2
call nz,set_error
ld a,(ix+4)
cp 0
ld a,3
call nz,set_error
ld a,(ix+5)
cp &41
ld a,4
call nz,set_error
ld a,(ix+6)
cp &2
ld a,5
call nz,set_error
ld a,(ix+2)
or a
ld a,6
call nz,set_error
ld a,(ix+1)
cp 1
ld a,7
call nz,set_error
ld a,(ix+0)
and %11111000
cp &40
ld a,8
call nz,set_error

call stop_drive_motor
ret

.read_id2_unform
;;di
call start_drive_motor

ld a,8
call move2track


ld e,0
ld bc,16
.riu2
push bc
push de

ld a,%00000110				;; read data
call send_command_byte
ld a,(drive)				;; drive
call send_command_byte
ld a,e						;; C
call send_command_byte
ld a,e						;; H
call send_command_byte
ld a,e						;; R (non-existant sector id)
call send_command_byte
ld a,e						;; N
call send_command_byte		
ld a,e						;; EOT (non-existant sector id)
call send_command_byte		
ld a,&2a					;; GPL
call send_command_byte
ld a,&ff					;; DTL
call send_command_byte

;; ignore any data
ld de,0
call fdc_read_data2

call fdc_result_phase


ld a,%01001010				;; read id
call send_command_byte
ld a,(drive)
call send_command_byte
call fdc_result_phase
ld a,b
cp 7
ld a,9
call nz,set_error
pop de
ld ix,result_data
ld a,(ix+3)
cp e
ld a,1
call nz,set_error
ld a,(ix+4)
cp e
ld a,2
call nz,set_error
ld a,(ix+5)
cp e
ld a,3
call nz,set_error
ld a,(ix+6)
cp e
ld a,4
call nz,set_error
ld a,(ix+2)
or a
ld a,5
call nz,set_error
ld a,(ix+1)
cp 1
ld a,6
call nz,set_error
ld a,(ix+0)
and %11111000
cp &40
ld a,7
call nz,set_error
pop bc
inc e
dec bc
ld a,b
or c
jp nz,riu2

call stop_drive_motor
ret


;;-------------------------------------------------------------------------
;;----------------------------------------------------------------------------
;; HELPER FUNCTIONS

.wait_for_seek_end
ld a,%1000						;; sense interrupt status
call send_command_byte	
call fdc_result_phase

ld ix,result_data
bit 5,(ix+0)					;; seek end set in ST0?
jr z,wait_for_seek_end
ret

;;----------------------------------------------------------------------------
;;
;; move read/write head to track
;;
;; A = track number

.move2track
ld e,a
push de

ld a,%1111						;; seek
call send_command_byte
ld a,(drive)					;; drive
call send_command_byte
ld a,e							;; track number
call send_command_byte

call wait_for_seek_end
pop de

;; on correct track?
;; no: force a second seek
ld ix,result_data
ld a,(ix+1)
cp e
jr nz,move2track

ret

;;----------------------------------------------------------------
;; do actual recalibrate

.move2track0

;; recalibrate read/write head
;; (move to track 0)

.m2t02
ld a,%111						;; recalibrate
call send_command_byte
ld a,(drive)					;; drive
call send_command_byte

.m2t0
;; sense interrupt status
;;
;; if seek is not complete:
;; - invalid command
;; if seek has completed:
;; - seek end will be set
;; (however, if the track 0 is not set after 77 tracks, then there could
;; be a equipment fault error)

ld a,%1000						;; sense interrupt status
call send_command_byte
call fdc_result_phase

;; recalibrate completed?
ld ix,result_data
bit 5,(ix+0)
jr z,m2t0
bit 4,(ix+0)
jr nz,m2t02
ret

;;-------------------------------------------------------------------------
;;----------------------------------------------------------------------------
.init_test_disk
ld hl,drive_txt
call display_string
call display_newline
call wait_char
sub '0'
ld (drive),a
di

ld ix,sector_buffer
ld b,15
ld a,1
.itd1
ld (ix+0),15
ld (ix+1),0
ld (ix+2),a
ld (ix+3),0
inc a
inc ix
inc ix
inc ix
inc ix
djnz itd1

call start_drive_motor

call move2track0

ld a,15
call move2track

ld a,%01001101
call send_command_byte
ld a,(drive)
call send_command_byte
ld a,0						;; sector size
call send_command_byte
ld a,9					;; number of sectors
call send_command_byte
ld a,&1					;; gap
call send_command_byte
ld a,&e5					;; filler
call send_command_byte

ld de,sector_buffer
call fdc_data_write

call fdc_result_phase

;;ei


ld ix,sector_buffer
ld b,9
ld a,1
.itd2
ld (ix+0),10
ld (ix+1),0
ld (ix+2),a
ld (ix+3),2
inc a
inc ix
inc ix
inc ix
inc ix
djnz itd2


;;di

;;call start_drive_motor

ld a,10
call move2track

ld a,%01001101
call send_command_byte
ld a,(drive)
call send_command_byte
ld a,2						;; sector size
call send_command_byte
ld a,9						;; number of sectors
call send_command_byte
ld a,&4a					;; gap
call send_command_byte
ld a,&e5					;; filler
call send_command_byte

ld de,sector_buffer
call fdc_data_write

call fdc_result_phase

;; 10,0,1,2		- 512 bytes - data mark
;; 10,0,2,2		- 512 bytes - deleted data mark
;; 10,0,3,2		- 512 bytes - data mark
;; 10,0,4,2		- 512 bytes - deleted data mark
;; 10,0,5,2		- 512 bytes - data mark
;; 10,0,6,2		- 512 bytes - deleted data mark
;; 10,0,7,2		- 512 bytes - data mark
;; 10,0,8,2		- 512 bytes - deleted data mark
;; 10,0,9,2		- 512 bytes - data mark

;; initialise sector data to be &e5
ld hl,sector_buffer
ld e,l
ld d,h
inc de
ld (hl),&e5
ld bc,512
ldir

;; set deleted data mark on sectors
ld b,4
ld a,2
.itd4
push bc
push af
ld e,a

ld a,%01001001
call send_command_byte
ld a,(drive)
call send_command_byte
ld a,10
call send_command_byte
ld a,0
call send_command_byte
ld a,e
call send_command_byte
ld a,2
call send_command_byte
ld a,e
call send_command_byte
ld a,&2a
call send_command_byte
ld a,&ff
call send_command_byte
ld de,sector_buffer
call fdc_data_write
call fdc_result_phase
pop af
pop bc
inc a
inc a
djnz itd4

;;ei


ld ix,sector_buffer
ld b,9
ld a,&c1
.itd3
ld (ix+0),11
ld (ix+1),0
ld (ix+2),a
ld (ix+3),2
inc a
inc ix
inc ix
inc ix
inc ix
djnz itd3


;;di

;;call start_drive_motor

ld a,11
call move2track

ld a,%01001101
call send_command_byte
ld a,(drive)
call send_command_byte
ld a,2						;; sector size
call send_command_byte
ld a,9						;; number of sectors
call send_command_byte
ld a,&4a					;; gap
call send_command_byte
ld a,&e5					;; filler
call send_command_byte

ld de,sector_buffer
call fdc_data_write

call fdc_result_phase

;;ei


ld ix,sector_buffer
ld (ix+0),&ff
ld (ix+1),0
ld (ix+2),&c1
ld (ix+3),&2

ld (ix+4),20
ld (ix+5),20
ld (ix+6),20
ld (ix+7),20

;;di

;;call start_drive_motor

ld a,12
call move2track

ld a,%01001101
call send_command_byte
ld a,(drive)
call send_command_byte
ld a,2						;; sector size
call send_command_byte
ld a,2						;; number of sectors
call send_command_byte
ld a,&4a					;; gap
call send_command_byte
ld a,&e5					;; filler
call send_command_byte

ld de,sector_buffer
call fdc_data_write

call fdc_result_phase


ld ix,sector_buffer
ld b,16
ld a,1
.itd5
ld (ix+0),13
ld (ix+1),0
ld (ix+2),a
ld (ix+3),1
inc a
inc ix
inc ix
inc ix
inc ix
djnz itd5

;;call start_drive_motor

ld a,13
call move2track

ld a,%01001101
call send_command_byte
ld a,(drive)
call send_command_byte
ld a,1						;; sector size
call send_command_byte
ld a,16						;; number of sectors
call send_command_byte
ld a,&4a					;; gap
call send_command_byte
ld a,&e5					;; filler
call send_command_byte

ld de,sector_buffer
call fdc_data_write

call fdc_result_phase



ld ix,sector_buffer
ld b,9
ld a,&41
.itd15
ld (ix+0),0
ld (ix+1),0
ld (ix+2),a
ld (ix+3),2
inc a
inc ix
inc ix
inc ix
inc ix
djnz itd15

;;call start_drive_motor

call move2track0

ld a,%01001101
call send_command_byte
ld a,(drive)
call send_command_byte
ld a,2						;; sector size
call send_command_byte
ld a,9						;; number of sectors
call send_command_byte
ld a,&4a					;; gap
call send_command_byte
ld a,&e5					;; filler
call send_command_byte

ld de,sector_buffer
call fdc_data_write

call fdc_result_phase

;;call stop_drive_motor


ld ix,sector_buffer
ld b,9
ld a,&41
.itd11
ld (ix+0),0
ld (ix+1),1
ld (ix+2),a
ld (ix+3),2
inc a
inc ix
inc ix
inc ix
inc ix
djnz itd11

;;call start_drive_motor

;;call move2track0

ld a,%01001101
call send_command_byte
ld a,(drive)
or 4						;; side 1
call send_command_byte
ld a,2						;; sector size
call send_command_byte
ld a,9						;; number of sectors
call send_command_byte
ld a,&4a					;; gap
call send_command_byte
ld a,&e5					;; filler
call send_command_byte

ld de,sector_buffer
call fdc_data_write

call fdc_result_phase

;;call stop_drive_motor



ld ix,sector_buffer
ld b,9
ld a,&41
.itd12
ld (ix+0),1
ld (ix+1),0
ld (ix+2),a
ld (ix+3),2
inc a
inc ix
inc ix
inc ix
inc ix
djnz itd12

;;call start_drive_motor

ld a,1
call move2track

ld a,%01001101
call send_command_byte
ld a,(drive)
call send_command_byte
ld a,2						;; sector size
call send_command_byte
ld a,9						;; number of sectors
call send_command_byte
ld a,&4a					;; gap
call send_command_byte
ld a,&e5					;; filler
call send_command_byte

ld de,sector_buffer
call fdc_data_write

call fdc_result_phase

;;call stop_drive_motor

ld ix,sector_buffer
ld b,9
ld a,&1
.itd8
ld (ix+0),1
ld (ix+1),1
ld (ix+2),a
ld (ix+3),2
inc a
inc ix
inc ix
inc ix
inc ix
djnz itd8

;;call start_drive_motor

;;ld a,1
;;call move2track

ld a,%01001101
call send_command_byte
ld a,(drive)
or 4						;; side 1
call send_command_byte
ld a,2						;; sector size
call send_command_byte
ld a,9						;; number of sectors
call send_command_byte
ld a,&4a					;; gap
call send_command_byte
ld a,&e5					;; filler
call send_command_byte

ld de,sector_buffer
call fdc_data_write

call fdc_result_phase

ld ix,sector_buffer
ld b,9
ld a,&1
.itd13
ld (ix+0),2
ld (ix+1),0
ld (ix+2),a
ld (ix+3),2
inc a
inc ix
inc ix
inc ix
inc ix
djnz itd13

;;call start_drive_motor

ld a,2
call move2track

ld a,%01001101
call send_command_byte
ld a,(drive)
call send_command_byte
ld a,2						;; sector size
call send_command_byte
ld a,9						;; number of sectors
call send_command_byte
ld a,&4a					;; gap
call send_command_byte
ld a,&e5					;; filler
call send_command_byte

ld de,sector_buffer
call fdc_data_write

call fdc_result_phase

;;call stop_drive_motor

ld ix,sector_buffer
ld b,9
ld a,&1
.itd9
ld (ix+0),2
ld (ix+1),1
ld (ix+2),a
ld (ix+3),2
inc a
inc ix
inc ix
inc ix
inc ix
djnz itd9

;;call start_drive_motor

;;ld a,2
;;call move2track

ld a,%01001101
call send_command_byte
ld a,(drive)
or 4						;; side 1
call send_command_byte
ld a,2						;; sector size
call send_command_byte
ld a,9						;; number of sectors
call send_command_byte
ld a,&4a					;; gap
call send_command_byte
ld a,&e5					;; filler
call send_command_byte

ld de,sector_buffer
call fdc_data_write

call fdc_result_phase

ld ix,sector_buffer
ld b,9
ld a,&1
.itd14
ld (ix+0),3
ld (ix+1),0
ld (ix+2),a
ld (ix+3),2
inc a
inc ix
inc ix
inc ix
inc ix
djnz itd14

;;call start_drive_motor

ld a,3
call move2track

ld a,%01001101
call send_command_byte
ld a,(drive)
call send_command_byte
ld a,2						;; sector size
call send_command_byte
ld a,9						;; number of sectors
call send_command_byte
ld a,&4a					;; gap
call send_command_byte
ld a,&e5					;; filler
call send_command_byte

ld de,sector_buffer
call fdc_data_write

call fdc_result_phase

;;call stop_drive_motor

ld ix,sector_buffer
ld b,9
ld a,&1
.itd19
ld (ix+0),4
ld (ix+1),1
ld (ix+2),a
ld (ix+3),2
inc a
inc ix
inc ix
inc ix
inc ix
djnz itd19

;;call start_drive_motor

;;ld a,2
;;call move2track

ld a,%01001101
call send_command_byte
ld a,(drive)
or 4						;; side 1
call send_command_byte
ld a,2						;; sector size
call send_command_byte
ld a,9						;; number of sectors
call send_command_byte
ld a,&4a					;; gap
call send_command_byte
ld a,&e5					;; filler
call send_command_byte

ld de,sector_buffer
call fdc_data_write

call fdc_result_phase


ld ix,sector_buffer
ld b,9
ld a,&1
.itd20
ld (ix+0),5
ld (ix+1),1
ld (ix+2),a
ld (ix+3),2
inc a
inc ix
inc ix
inc ix
inc ix
djnz itd20

;;call start_drive_motor

ld a,5
call move2track

ld a,%01001101
call send_command_byte
ld a,(drive)
call send_command_byte
ld a,2						;; sector size
call send_command_byte
ld a,9						;; number of sectors
call send_command_byte
ld a,&4a					;; gap
call send_command_byte
ld a,&e5					;; filler
call send_command_byte

ld de,sector_buffer
call fdc_data_write

call fdc_result_phase

;;call stop_drive_motor

ld ix,sector_buffer
ld b,9
ld a,&1
.itd22
ld (ix+0),5
ld (ix+1),0
ld (ix+2),a
ld (ix+3),2
inc a
inc ix
inc ix
inc ix
inc ix
djnz itd22

;;call start_drive_motor

;;ld a,2
;;call move2track

ld a,%01001101
call send_command_byte
ld a,(drive)
or 4						;; side 1
call send_command_byte
ld a,2						;; sector size
call send_command_byte
ld a,9						;; number of sectors
call send_command_byte
ld a,&4a					;; gap
call send_command_byte
ld a,&e5					;; filler
call send_command_byte

ld de,sector_buffer
call fdc_data_write

call fdc_result_phase

ld ix,sector_buffer
ld b,9
ld a,&1
.itd23
ld (ix+0),25
ld (ix+1),&fe
ld (ix+2),a
ld (ix+3),2
inc a
inc ix
inc ix
inc ix
inc ix
djnz itd23

;;call start_drive_motor

ld a,25
call move2track

ld a,%01001101
call send_command_byte
ld a,(drive)
call send_command_byte
ld a,2						;; sector size
call send_command_byte
ld a,9						;; number of sectors
call send_command_byte
ld a,&4a					;; gap
call send_command_byte
ld a,&e5					;; filler
call send_command_byte

ld de,sector_buffer
call fdc_data_write

call fdc_result_phase

;;call stop_drive_motor

ld ix,sector_buffer
ld b,9
ld a,&1
.itd21
ld (ix+0),25
ld (ix+1),&ff
ld (ix+2),a
ld (ix+3),2
inc a
inc ix
inc ix
inc ix
inc ix
djnz itd21

;;call start_drive_motor

;;ld a,2
;;call move2track

ld a,%01001101
call send_command_byte
ld a,(drive)
or 4						;; side 1
call send_command_byte
ld a,2						;; sector size
call send_command_byte
ld a,9						;; number of sectors
call send_command_byte
ld a,&4a					;; gap
call send_command_byte
ld a,&e5					;; filler
call send_command_byte

ld de,sector_buffer
call fdc_data_write

call fdc_result_phase

ld ix,sector_buffer
ld (ix+0),0
ld (ix+1),0
ld (ix+2),&aa
ld (ix+3),3

;;call start_drive_motor

ld a,4
call move2track

ld a,%01001101
call send_command_byte
ld a,(drive)
call send_command_byte
ld a,2						;; sector size
call send_command_byte
ld a,1						;; number of sectors
call send_command_byte
ld a,&4a					;; gap
call send_command_byte
ld a,&e5					;; filler
call send_command_byte

ld de,sector_buffer
call fdc_data_write

call fdc_result_phase

;;call stop_drive_motor




ei
ret

.dump_results
push af
push bc
push ix
ld ix,result_data
.dr1
ld a,(ix+0)		;; get byte
inc ix			;; next ptr
call display_hex
ld a,' '		;; display space
call display_char
djnz dr1
pop ix
pop bc
pop af
ret

.display_hex
push af
srl a
srl a
srl a
srl a
			;; get top nibble
call display_digit
pop af
			;; get low nibble
.display_digit
and &f
add a,'0'
cp '9'+1
jr c,dd2
add a,'A'-'9'-1
.dd2
			;; display
call display_char
ret




read "cpc.asm"
;;read "plus3.asm"


.sector_buffer 
defs 1024

.result_data
defs 7
