;; A NEC765 emulation tester (c) Kevin Thacker 2002
;;
;; counts number of gap length bytes after sector

org &1000
nolist
write"test2.bin"

call wait_char
.format1
call start_drive_motor

call move2track0

ld b,0
xor a
.fmt2
push af
push bc
push af
call display_hex
ld a,':'
call display_char

call start_drive_motor
di
ld ix,sector_buffer
ld (ix+0),0
ld (ix+1),0
ld (ix+2),&c1
ld (ix+3),6
inc ix
inc ix
inc ix
inc ix
ld (ix+0),0
ld (ix+1),0
ld (ix+2),&c2
ld (ix+3),2

;; format
ld a,%01001101
call send_command_byte
ld a,(drive)
call send_command_byte
ld a,2						;; sector size
call send_command_byte
ld a,9						;; number of sectors
call send_command_byte
pop af
call send_command_byte
ld a,&e5					;; filler
call send_command_byte

ld de,sector_buffer
call fdc_data_write
call fdc_result_phase

ld a,%01000110				;; read data, mfm
call send_command_byte
ld a,(drive)
call send_command_byte
ld a,0						;; C
call send_command_byte
ld a,0						;; H
call send_command_byte
ld a,&c1					;; R
call send_command_byte
ld a,6						;; N
call send_command_byte
ld a,&c1					;; EOT
call send_command_byte
ld a,1					;; GPL
call send_command_byte
ld a,&ff					;; dtl
call send_command_byte

ld de,sector_buffer
call fdc_data_read
call fdc_result_phase

ld hl,sector_buffer
ld bc,512+2				;; 512 bytes of data + 2 for crc
add hl,bc
ld de,0
.fmt3
ld a,(hl)
or a
jp z,fmt4
inc de
inc hl
jp fmt3
.fmt4
ld a,d
call display_hex
ld a,e
call display_hex
call display_newline

pop bc
pop af
inc a
dec b
jp nz,fmt2

call stop_drive_motor
ret

;;-------------------------------------------------------------------------
;;----------------------------------------------------------------------------
;; HELPER FUNCTIONS

.wait_for_seek_end
ld a,%1000						;; sense interrupt status
call send_command_byte	
call fdc_result_phase

ld ix,result_data
bit 5,(ix+0)					;; seek end set in ST0?
jr z,wait_for_seek_end
ret

;;----------------------------------------------------------------------------
;;
;; move read/write head to track
;;
;; A = track number

.move2track
ld e,a
push de

ld a,%1111						;; seek
call send_command_byte
ld a,(drive)					;; drive
call send_command_byte
ld a,e							;; track number
call send_command_byte

call wait_for_seek_end
pop de

;; on correct track?
;; no: force a second seek
ld ix,result_data
ld a,(ix+1)
cp e
jr nz,move2track

ret

;;----------------------------------------------------------------
;; do actual recalibrate

.move2track0

;; recalibrate read/write head
;; (move to track 0)

.m2t02
ld a,%111						;; recalibrate
call send_command_byte
ld a,(drive)					;; drive
call send_command_byte

.m2t0
;; sense interrupt status
;;
;; if seek is not complete:
;; - invalid command
;; if seek has completed:
;; - seek end will be set
;; (however, if the track 0 is not set after 77 tracks, then there could
;; be a equipment fault error)

ld a,%1000						;; sense interrupt status
call send_command_byte
call fdc_result_phase

;; recalibrate completed?
ld ix,result_data
bit 5,(ix+0)
jr z,m2t0
bit 4,(ix+0)
jr nz,m2t02
ret

.dump_results
push af
push bc
push ix
ld ix,result_data
.dr1
ld a,(ix+0)		;; get byte
inc ix			;; next ptr
call display_hex
ld a,' '		;; display space
call display_char
djnz dr1
pop ix
pop bc
pop af
ret

.display_hex
push af
srl a
srl a
srl a
srl a
			;; get top nibble
call display_digit
pop af
			;; get low nibble
.display_digit
and &f
add a,'0'
cp '9'+1
jr c,dd2
add a,'A'-'9'-1
.dd2
			;; display
call display_char
ret




read "cpc.asm"
;;read "plus3.asm"


.drive
defb 1

.result_data
defs 7


.sector_buffer 
defs 1024
