;; HOWARD THE DUCK
;;
;; Cassys cassette protection system
;;
;; - data is encrypted (encryption key starts at 0, and is incremented by 3 for every byte)
;; - data can be any speed (speed is calculated)

;; this bears a close resemblance to the Amstrad standard
;; loader.

;; Messages in memory:
;;
;; "CASSYS CASSETTE PROTECTION SYSTEM 1986"
;; "MASTER HACKER RULES O.K!"

;; "(c) 1986 KEVIN PARKER - THE MASTER HACKER"
;;
;; If loading fails, screen clears, a beep is sounded, and the following error message is displayed:
;;
;; "** CASSETTE LOADING ERROR - TRY AGAIN **"

;; start here...
ac00 c39bac    jp      $ac9b

;;------------------------------------------------------------------------------
;; colours (4 for display mode 1)
ac03 defb &00,&1a,&01,&0d

;;------------------------------------------------------------------------------

ac07 d5        push de
ac08 cd11ac    call    $ac11
ac0b d1        pop     de
ac0c d8        ret     c
ac0d b7        or      a
ac0e c8        ret     z
ac0f 18f6      jr      $ac07            ; (-$0a)

;;------------------------------------------------------------------------------

ac11 2e55      ld      l,$55
ac13 cd6cac    call    $ac6c
ac16 d0        ret     nc

ac17 110000    ld      de,$0000
ac1a 62        ld      h,d
ac1b cd6cac    call    $ac6c
ac1e d0        ret     nc
ac1f eb        ex      de,hl
ac20 0600      ld      b,$00
ac22 09        add     hl,bc
ac23 eb        ex      de,hl
ac24 25        dec     h
ac25 20f4      jr      nz,$ac1b         ; (-$0c)

ac27 61        ld      h,c
ac28 79        ld      a,c
ac29 92        sub     d
ac2a 4f        ld      c,a
ac2b 9f        sbc     a,a
ac2c 47        ld      b,a
ac2d eb        ex      de,hl
ac2e 09        add     hl,bc
ac2f eb        ex      de,hl
ac30 cd6cac    call    $ac6c
ac33 d0        ret     nc

ac34 7a        ld      a,d
ac35 cb3f      srl     a
ac37 cb3f      srl     a
ac39 8a        adc     a,d
ac3a 94        sub     h
ac3b 38ea      jr      c,$ac27          ; (-$16)
ac3d 91        sub     c
ac3e 38e7      jr      c,$ac27          ; (-$19)
ac40 7a        ld      a,d
ac41 1f        rra     
ac42 8a        adc     a,d
ac43 67        ld      h,a
ac44 2297ac    ld      ($ac97),hl
ac47 cd52ac    call    $ac52
ac4a d0        ret     nc

ac4b 2196ac    ld      hl,$ac96
ac4e ae        xor     (hl)
ac4f c0        ret     nz

ac50 37        scf     
ac51 c9        ret     

;;-------------------------------------------------------------------------
;; load byte
;;
;; A = byte

ac52 d5        push    de
ac53 1e08      ld      e,$08
ac55 2a97ac    ld      hl,($ac97)
ac58 cd72ac    call    $ac72		; get edge
ac5b dc7bac    call    c,$ac7b		; get edge
ac5e 300a      jr      nc,$ac6a         ; 
ac60 7c        ld      a,h
ac61 91        sub     c
ac62 9f        sbc     a,a
ac63 cb12      rl      d
ac65 1d        dec     e
ac66 20ed      jr      nz,$ac55         ; 
ac68 7a        ld      a,d
ac69 37        scf     
ac6a d1        pop     de
ac6b c9        ret     

;;-------------------------------------------------------------------------
;; get edge

ac6c 06f4      ld      b,$f4
ac6e ed78      in      a,(c)
ac70 e604      and     $04
ac72 ed5f      ld      a,r
ac74 c603      add     a,$03
ac76 0f        rrca    
ac77 0f        rrca    
ac78 e61f      and     $1f
ac7a 4f        ld      c,a
ac7b 06f5      ld      b,$f5
ac7d 79        ld      a,c
ac7e c602      add     a,$02
ac80 4f        ld      c,a
ac81 380e      jr      c,$ac91          ; (+$0e)
ac83 ed78      in      a,(c)
ac85 ad        xor     l
ac86 e680      and     $80
ac88 20f3      jr      nz,$ac7d         ; (-$0d)
ac8a af        xor     a
ac8b ed4f      ld      r,a
ac8d cb0d      rrc     l
ac8f 37        scf     
ac90 c9        ret     

ac91 af        xor     a
ac92 ed4f      ld      r,a
ac94 3c        inc     a
ac95 c9        ret     

;;-----------------------------------------------------------------------------


ac96 00        nop     
ac97 00        nop     
ac98 00        nop     
ac99 00        nop     
ac9a 00        nop     

;;-----------------------------------------------------------------------------

;; set display mode to 1
ac9b 3e01      ld      a,$01
ac9d cd0ebc    call    $bc0e		; firmware function: scr set mode

;; set border colour to black
aca0 010000    ld      bc,$0000
aca3 cd38bc    call    $bc38		; firmware function: scr set border

;; setup colours
aca6 2103ac    ld      hl,$ac03
aca9 af        xor     a
acaa 4e        ld      c,(hl)		; get firmware colour value
acab 41        ld      b,c
acac e5        push    hl
acad f5        push    af
acae cd32bc    call    $bc32		; firmware function: scr set ink
acb1 f1        pop     af
acb2 e1        pop     hl
acb3 23        inc     hl
acb4 3c        inc     a
acb5 fe04      cp      $04
acb7 20f1      jr      nz,$acaa         ; 

;; this displays the credits (not the same for all cassys loaders)
acb9 cd8813    call    $1388


;; test for visible multiface
acbc f3        di    			; disable interrupts
acbd 01e8fe    ld      bc,$fee8		; page in rom/ram of multiface
acc0 ed49      out     (c),c
acc2 3a0000    ld      a,($0000)	; test memory
acc5 fef3      cp      $f3
acc7 28f4      jr      z,$acbd          ; if multiface found, loop continuously

;; do loading

acc9 3100c0    ld      sp,$c000
accc 1101ad    ld      de,$ad01		; error routine
accf d5        push    de
acd0 d9        exx     
acd1 c5        push    bc
acd2 d9        exx     
acd3 cd73ad    call    $ad73		; load 
acd6 d9        exx     
acd7 c1        pop     bc
acd8 d9        exx     
acd9 fb        ei      			; enable interrupts
acda 0100f6    ld      bc,$f600		; stop cassette motor
acdd ed49      out     (c),c
acdf c9        ret     


;;-------------------------------------------------------------------------------------
;; load completion flag (1=loaded successfully, 0=loading failed)
ace0 00        nop     
;;-------------------------------------------------------------------------------------

ace1:
;; this is a comparison string.
;; the file on cassette should have this
defb "THE MASTER HACKER RULES O.K. !!!"
;;-------------------------------------------------------------------------------------

;; stop cassette motor
ad01 0100f6    ld      bc,$f600
ad04 ed49      out     (c),c

ad06 210cad    ld      hl,$ad0c
ad09 cd16bd    call    $bd16

;; set border to black
ad0c 010000    ld      bc,$0000
ad0f cd38bc    call    $bc38		; firmware function: scr set border

;; set pen 0 to black
ad12 af        xor     a
ad13 010000    ld      bc,$0000
ad16 cd32bc    call    $bc32		; firmware function: scr set pen

;; set display mode to 1
ad19 3e01      ld      a,$01
ad1b cd0ebc    call    $bc0e		; firmware function: scr set mode

;; set pen 1 to bright white
ad1e 3e01      ld      a,$01
ad20 011a1a    ld      bc,$1a1a
ad23 cd32bc    call    $bc32		; firmware function: scr set pen

;; display message terminated with &ff
ad26 2149ad    ld      hl,$ad49
ad29 7e        ld      a,(hl)
ad2a 23        inc     hl
ad2b feff      cp      $ff
ad2d 2805      jr      z,$ad34          ; 
ad2f cd5abb    call    $bb5a		; firmware function: txt output
ad32 18f5      jr      $ad29            ; (-$0b)

;; delay
ad34 013208    ld      bc,$0832
ad37 c5        push    bc
ad38 cd19bd    call    $bd19		; firmware function: mc wait flyback
ad3b 0d        dec     c
ad3c 20fa      jr      nz,$ad38         
ad3e c1        pop     bc
ad3f 10f6      djnz    $ad37

;; do reset
ad41 210000    ld      hl,$0000
ad44 0eff      ld      c,$ff
ad46 cd16bd    call    $bd16

;; error message

ad49 defb "** CASSETTE LOADING ERROR - TRY AGAIN **",&07, &ff

;;-------------------------------------------------------------------------------------

ad73 010ef4    ld      bc,$f40e		; write PSG I/O port A register index to PPI port A
ad76 ed49      out     (c),c
ad78 01d0f6    ld      bc,$f6d0		; PSG select I/O port A register
ad7b ed49      out     (c),c
ad7d 0e10      ld      c,$10		; cassette motor on		
ad7f ed49      out     (c),c
ad81 0192f7    ld      bc,$f792		; set PPI port A to input
ad84 ed49      out     (c),c
ad86 0158f6    ld      bc,$f658		; select keyboard line 8 (has ESC on it)
ad89 ed49      out     (c),c

ad8b af        xor     a
ad8c ed47      ld      i,a
;; ??? (unused)
ad8e 3296ac    ld      ($ac96),a

;; handle pilot tone
ad91 cd07ac    call    $ac07
ad94 d0        ret     nc

;; check for ident string
ad95 dd21e1ac  ld      ix,$ace1
ad99 1e20      ld      e,$20
ad9b cd17ae    call    $ae17		; load byte
ad9e d0        ret     nc
ad9f ddbe00    cp      (ix+$00)
ada2 c0        ret     nz
ada3 dd23      inc     ix
ada5 1d        dec     e
ada6 20f3      jr      nz,$ad9b         ; (-$0d)

ada8 d9        exx     
ada9 210100    ld      hl,$0001		; HL=1: no "screen" following
					; HL!=1: screen following
adac d9        exx     
adad cdc3ad    call    $adc3		; load screen data
adb0 d0        ret     nc

adb1 018e7f    ld      bc,$7f8e		; set screen mode
adb4 ed49      out     (c),c
adb6 115401    ld      de,$0154		; pen 1, black
adb9 ed51      out     (c),d		; select pen 1
adbb ed59      out     (c),e		; set pen 1 colour (black)
adbd cdc3ad    call    $adc3		; load program data
adc0 d0        ret     nc
adc1 182f      jr      $adf2            ; load 


;;-------------------------------------------------------------------------------------
;; load main program code

adc3 cd17ae    call    $ae17		; load byte
adc6 d0        ret     nc

adc7 fe01      cp      $01		; sync byte?
adc9 37        scf     
adca 3f        ccf     
adcb c0        ret     nz

;; load low byte of memory address
adcc cd17ae    call    $ae17		; load byte
adcf d0        ret     nc
add0 dd6f      ld      ixl,a

;; load high byte of memory address
add2 cd17ae    call    $ae17		; load byte
add5 d0        ret     nc
add6 dd67      ld      ixh,a

;; load low byte of length
add8 cd17ae    call    $ae17		; load byte
addb d0        ret     nc
addc 5f        ld      e,a

;; load high byte of length
addd cd17ae    call    $ae17		; load byte
ade0 d0        ret     nc
ade1 57        ld      d,a

;; load data...
ade2 cd27ae    call    $ae27
ade5 d0        ret     nc

ade6 dd7700    ld      (ix+$00),a
ade9 dd23      inc     ix
adeb 1b        dec     de
adec 7a        ld      a,d
aded b3        or      e
adee 20f2      jr      nz,$ade2         ; (-$0e)

adf0 37        scf     
adf1 c9        ret     


;;--------------------------------------------------------------------------------
;; load checksum?

adf2 cd17ae    call    $ae17		; load byte
adf5 d0        ret     nc
adf6 fe10      cp      $10		; marker
adf8 c0        ret     nz

;; load low byte of checksum
adf9 cd17ae    call    $ae17		; load byte
adfc d0        ret     nc
adfd 5f        ld      e,a
;; load high byte of checksum
adfe cd17ae    call    $ae17		; load byte
ae01 d0        ret     nc
ae02 57        ld      d,a

ae03 ed53febf  ld      ($bffe),de
ae07 3e01      ld      a,$01
ae09 32e0ac    ld      ($ace0),a
ae0c 0182f7    ld      bc,$f782
ae0f ed49      out     (c),c
ae11 0110f6    ld      bc,$f610
ae14 ed49      out     (c),c
ae16 c9        ret     

;;----------------------------------------------------------
;; load a byte
ae17 cd52ac    call    $ac52
ae1a d0        ret     nc

ae1b d5        push    de

;; store loaded byte
ae1c 5f        ld      e,a
;; update encryption code
ae1d ed57      ld      a,i
ae1f c603      add     a,$03
ae21 ed47      ld      i,a
;; decrypt loaded byte
ae23 ab        xor     e
ae24 d1        pop     de
ae25 37        scf     
ae26 c9        ret     
;;----------------------------------------------------------

ae27 cd17ae    call    $ae17		; load byte
ae2a f5        push    af
ae2b d9        exx     

ae2c 2b        dec     hl
ae2d 7c        ld      a,h
ae2e b5        or      l
ae2f 2034      jr      nz,$ae65         ; (+$34)

;; load screen?
ae31 217206    ld      hl,$0672
ae34 d9        exx     

ae35 cd17ae    call    $ae17		; load byte
ae38 302e      jr      nc,$ae68         ; 
ae3a fe10      cp      $10		
ae3c 202a      jr      nz,$ae68         ; 

ae3e d9        exx     
ae3f 3e00      ld      a,$00
ae41 b7        or      a
ae42 2821      jr      z,$ae65          ; (+$21)

ae44 2100c0    ld      hl,$c000
ae47 0608      ld      b,$08
ae49 1a        ld      a,(de)
ae4a 13        inc     de
ae4b 77        ld      (hl),a
ae4c 23        inc     hl
ae4d 1a        ld      a,(de)
ae4e 13        inc     de
ae4f 77        ld      (hl),a
ae50 2b        dec     hl
ae51 7c        ld      a,h
ae52 c608      add     a,$08
ae54 67        ld      h,a
ae55 d9        exx     
ae56 cd17ae    call    $ae17		; load byte
ae59 300d      jr      nc,$ae68         ; (+$0d)
ae5b fe01      cp      $01
ae5d 2009      jr      nz,$ae68         ; (+$09)
ae5f d9        exx     
ae60 10e7      djnz    $ae49            ; (-$19)
ae62 217206    ld      hl,$0672
ae65 d9        exx     
ae66 f1        pop     af
ae67 c9        ret     

ae68 d1        pop     de
ae69 37        scf     
ae6a 3f        ccf     
ae6b c9        ret     
