; *******************************************************************
; * Amstrad CPC emulator v5.1i                                      *
; * (c) 1991-96 Bernd Schmidt                                       *
; *                                                                 *
; *******************************************************************

	IDEAL

PUBLIC amsdos,basic,rom5,rom6,rom7,haver5,haver6,haver7
PUBLIC sysstat,scrbase,scroff,modetab,normramseg
PUBLIC inp,outp,memmap,scrbankpt,dowait,intcount,DoJoystick
PUBLIC intreq,ffly,refreshrate,usevesa,smallvesa,borders
PUBLIC cleanup,reset
PUBLIC RethinkCRTC,colmode,SetColors,ResetVesaPage,IncVesaPage
PUBLIC SetPCsCRTC
PUBLIC SaveSnap,LoadSnap
PUBLIC crtcvtotal,crtcscrwidth,crtchsync,doublelinmode
PUBLIC CRTCregs,pcrtcscrwidth,crtc32state
PUBLIC GenModeTab,needmodetab

PUBLIC SBinstalled,SBport,usesound,PSGcount,psgregmod,psgregs,gusint,sbdma,sbirq
PUBLIC cpctype,quietcas,germkey,DMAblocklen
EXTRN  SB_reset:PROC,DoSound:PROC,RethinkPSG:PROC,SB_shutdown:PROC
EXTRN  Sound_Cleanup:PROC,SB_Pause:PROC,SB_continue:PROC

EXTRN  inpFB:PROC,outFA:PROC,outFB:PROC
EXTRN  CloseDisk:PROC
EXTRN  DiskBuf:BYTE,fha:WORD

EXTRN  simz80:PROC,interrupt:PROC,ClearInterruptCounter:PROC
EXTRN  simstack:WORD,sAFx:WORD,sBCx:WORD,sDEx:WORD,sHLx:WORD,ix:WORD,iy:WORD
EXTRN  srF:WORD,srFhi:WORD,srI:WORD,imode:WORD,sIFF1:BYTE,sIFF2:BYTE
EXTRN  intflag:WORD,simz80l:PROC,sz80_instend:PROC
EXTRN  imode:WORD,count52:WORD
EXTRN  inpiob:PROC

PUBLIC MenuScr,MenuItems,MenuVars,FixPrefs,CPCKtb

PUBLIC OpenTextScr,PutChar,ResetScreen,RestoreScreen

; *** Code from files.asm
EXTRN  GetDirs:PROC,GetSnapDir:PROC,SelFile:PROC,SelSnap:PROC,GetSaveSnapName:PROC
EXTRN  InitTape:PROC,CloseTape:PROC

; *** Data from files.asm
EXTRN  snapdir:BYTE,snaname:BYTE,snapha:WORD

; *** Code from misc.asm
EXTRN  LoadROMs:PROC,Menu:PROC,ClearKeyMap:PROC,Video:PROC,MyKeyInt:PROC,SetLEDs:PROC

; *** Data from misc.asm
EXTRN  KeyMatrix:BYTE,EngNormTab:BYTE,FrnNormTab:BYTE,GerNormTab:BYTE
EXTRN  ColorTab:DWORD,ColorTabA:DWORD

; *** Code from comp386.asm
EXTRN  UnpackArea:PROC,PackArea:PROC

P386

GROUP   DGROUP _stack,_data

      INCLUDE "macros.inc"

SEGMENT _text PAGE PUBLIC 'CODE'
ASSUME CS:_text
ASSUME DS:DGROUP

start:
      ;  STARTUPCODE
	MOV     DX,DGROUP
	MOV     DS,DX
	MOV     DX,SEG stck
	MOV     SS,DX
	MOV     DX,OFFSET stckend
	MOV     SP,DX

	XOR     EAX,EAX
	XOR     EBX,EBX
	XOR     ECX,ECX
	XOR     EDX,EDX
	XOR     ESI,ESI
	XOR     EDI,EDI
	XOR     EBP,EBP

	MOV     [fha],0ffffh
	MOV     [snapha],0ffffh

	CALL    GetDirs

	CALL    GetOldKeyInt
	CALL    GetOld8253Int

	CALL    GetScrMode

	MOV     DX,OFFSET prefname        ; load prefs
	MOV     AX,3d00h
	INT     21h
	JC      cleanup

	MOV     BX,AX
	MOV     AH,3Fh
	MOV     DX,OFFSET CPEPrefs
	MOV     CX,42
	INT     21h

	MOV     AH,3Fh
	MOV     DX,OFFSET joystuff
	MOV     CX,8
	INT     21h
	MOV     AH,3Eh
	INT     21h

	CALL    InitRamSegs

	CALL    LoadROMs

	CALL    FixPrefs

	MOV     AX,CS
	MOV     DS,AX
	MOV     DX,OFFSET MyKeyInt
	MOV     AX,2509h
	INT     21h                     ; set interrupt
	MOV     AX,DGROUP
	MOV     DS,AX

	MOV     AX,[normramseg]
	MOV     ES,AX

	CALL    Set8253Int

	;CALL    SOUND_Init
	CALL    SB_reset

	CALL    InitHardware
	CALL    reset

	JMP     simz80

print:
	PUSHAW
	PUSH    ES
	PUSH    DS
	POP     ES
	XOR     AX,AX
	MOV     CX,0ffffh
	MOV     DI,DX
	REPNZ   SCASB
	NEG     CX
	SUB     CX,2
	MOV     AX,4000h
	MOV     BX,1
	INT     21h
	POP     ES
	POPAW
	RET

GetOldKeyInt:
	MOV     AX,3509h
	INT     21h
	MOV     [oldintseg],ES
	MOV     [oldintadd],BX
	RET

DisableInt:
	PUSHAD
	MOV     DX,[oldintadd]
	MOV     AX,[oldintseg]
	MOV     DS,AX
	MOV     AX,2509h
	INT     21h                     ; set interrupt
	MOV     AX,DGROUP
	MOV     DS,AX
	POPAD
	RET

GetOld8253Int:
	MOV     AX,3508h
	INT     21h
	MOV     [old8253seg],ES
	MOV     [old8253add],BX
	RET

Set8253Int:
	MOV     AX,CS
	MOV     DS,AX
	MOV     DX,OFFSET My8253Int
	MOV     AX,2508h
	INT     21h
	CLI
	MOV     AX,DGROUP
	MOV     DS,AX

	MOV     DX,43h
	MOV     AL,36h
	OUT     DX,AL
	MOV     DX,40h
	MOV     AX,[timerval]
	OUT     DX,AL
	MOV     AL,AH
	OUT     DX,AL
	STI
	RET

Res8253Int:
	CLI
	MOV     DX,43h
	MOV     AL,36h
	OUT     DX,AL
	MOV     DX,40h
	MOV     AL,000h
	OUT     DX,AL
	MOV     AL,000h
	OUT     DX,AL

	MOV     AX,[old8253seg]
	MOV     DX,[old8253add]
	MOV     DS,AX
	MOV     AX,2508h
	INT     21h
	MOV     AX,DGROUP
	MOV     DS,AX
	STI
	RET

My8253Int:
	PUSH    DS
	PUSH    EAX

	PUSH    DGROUP
	POP     DS

	CALL    My8253Handler

	MOV     AX,[timerval]
	ADD     [timercount],AX
	JNC     M8253_Ret
	POP     EAX
	POP     DS
	JMP     [old8253]

M8253_Ret:
	MOV     AL,20h
	OUT     20h,AL
	POP     EAX
	POP     DS
	IRET

LABEL old8253 DWORD
old8253add  dw    0
old8253seg  dw    0

My8253Handler:
	PUSH    EAX
	PUSH    DS
	PUSH    DX

	MOV     AX,DGROUP
	MOV     DS,AX

	CMP     [doingems],0
	JNE     MII_NotInt

	INC     [intcount]
	AND     [intcount],07fh
MII_NotInt:
	POP     DX
	POP     DS
	POP     EAX
	RET

DoJoystick:
	CMP     [usejoy],0
	JE      DJOY_End
	PUSHAD
	MOV     DX,201h
	IN      AL,DX
	XOR     ESI,ESI
	XOR     EDI,EDI
	CLI
	XOR     AX,AX
	OUT     DX,AL

DJOY_l: IN      AL,DX
	AND     AL,3
	JZ      DJOY_lend
	BT      AX,0
	JNC     DJOY_notx
	INC     ESI
DJOY_notx:
	BT      AX,1
	JNC     DJOY_noty
	INC     EDI
DJOY_noty:
	JMP     DJOY_l
DJOY_lend:
	IN      AL,DX
	STI
	MOV     CL,[KeyMatrix+9]
	OR      CL,03fh
	CMP     SI,[joyr]
	JNC     DJOY_notright
	XOR     CL,4
DJOY_notright:
	CMP     [joyl],SI
	JNC     DJOY_notleft
	XOR     CL,8
DJOY_notleft:
	CMP     DI,[joyu]
	JNC     DJOY_notup
	XOR     CL,1
DJOY_notup:
	CMP     [joyd],DI
	JNC     DJOY_notdn
	XOR     CL,2
DJOY_notdn:
	AND     AL,48
	AND     CL,0CFh
	OR      CL,AL
	MOV     [KeyMatrix+9],CL
	POPAD
DJOY_End:
	RET

GetScrMode:
	MOV     AH,0FH
	CALL    Video
	PUSH    AX
	MOV     AX,1130H
	MOV     BH,0
	MOV     DL,0
	CALL    Video
	POP     AX
	MOV     DH,AH
	CMP     DL,25
	SBB     AH,AH
	INC     AH
	MOV     [OldVideo],AX
	RET

SetOldMode:
	MOV     AX,[OldVideo]
	MOV     BX,40h
	MOV     ES,BX
	MOV     BL,20H
	CMP     AL,7            ; smMono
	JNE     @@1
	MOV     BL,30H

@@1:    AND     [BYTE PTR ES:10h],0CFH     ; Equipmentbyte
	OR      [ES:10h],BL
	AND     [BYTE PTR ES:87h],0FEH     ; CrtInfo
	PUSH    AX
	MOV     AH,0
	CALL    Video
	POP     AX
	OR      AH,AH
	JE      @@2
	MOV     AX,1112H
	MOV     BL,0
	CALL    Video
	MOV     AX,1130H
	MOV     BH,0
	MOV     DL,0
	CALL    Video
	CMP     DL,42
	JNE     @@2
	OR      [BYTE PTR ES:87h],1
	MOV     AH,1
	MOV     CX,600H
	CALL    Video
	MOV     AH,12H
	MOV     BL,20H
	CALL    Video
@@2:
	RET

cleanup:
	CALL    SB_shutdown
	;CALL    SOUND_Cleanup
	CALL    CloseTape
	CALL    CloseDisk
	CALL    DisableInt
	CALL    Res8253Int
	CALL    SetOldMode
	CALL    CleanupEMM
	EXITCODE

OpenTextScr:
	CMP     [usevesa],0
	JE      OTSC_Standard
	CMP     [graphmenu],0
	JE      OTSC_Standard
	MOV     AX,[vesapage]
	MOV     [savedvesapage],AX
	CALL    ClearVesaScreen
	PUSH    SEG amsdos
	POP     FS
	RET
OTSC_Standard:
	MOV     AX,3
	CALL    Video
	PUSH    0B800h
	POP     FS
	RET

PutChar:
	CMP     [usevesa],0
	JE      PTCH_Standard
	CMP     [graphmenu],0
	JE      PTCH_Standard
	PUSHAD
	PUSH    ES
	CMP     AL,10h
	JNE     PTCH_NoArrow
	MOV     AL,243
PTCH_NoArrow:
	XOR     AH,AH
	MOV     SI,AX
	ADD     SI,SI
	ADD     SI,SI
	ADD     SI,SI
	ADD     SI,03800h  ; SI now contains the character's position in ROM

	MOV     AX,DX
	MOV     CL,80
	DIV     CL
	MOV     CL,AH
	XOR     CH,CH
	ADD     CX,CX
	ADD     CX,CX
	ADD     CX,CX
	XOR     AH,AH
	MOV     DI,6400
	MUL     DI      ; one line is 6400 bytes
	ADD     AX,CX
	ADC     DX,0
	MOV     [vesapage],DX
	CALL    SetVesaPage
	MOV     DI,AX      ; DI contains the offset to VGA memory

	PUSH    0A000h
	POP     ES
	MOV     CX,8
PTCH_LineLoop:
	MOV     BL,[FS:SI]
	INC     SI
	MOV     BH,8
PTCH_BitLoop:
	MOV     AL,20
	ROL     BL,1
	JNC     PTCH_CharOK
	MOV     AL,11
PTCH_CharOK:
	STOSB
	DEC     BH
	JNZ     PTCH_BitLoop

	ADD     DI,792
	JNC     PTCH_LineOK
	CALL    IncVesaPage
PTCH_LineOK:
	LOOP    PTCH_LineLoop
	POP     ES
	POPAD
	RET
PTCH_Standard:
	MOV     [FS:EDX*2],AX
	RET

RestoreScreen:
	CMP     [usevesa],0
	JE      RSSC_Standard
	CMP     [graphmenu],0
	JE      RSSC_Standard
	CALL    ClearVesaScreen
	PUSH    AX
	MOV     AX,[savedvesapage]
	MOV     [vesapage],AX
	POP     AX
	CALL    SetVesaPage
	RET                     ; SetPCsCRTC not needed here
RSSC_Standard:
	CALL    ResetScreen
	RET

ResetScreen:
	MOV     [scrtype],0ffffh
	CALL    SetPCsCRTC
	RET

ClearVesaScreen:
	PUSHAD
	PUSH    ES
	CALL    ResetVesaPage
	PUSH    0A000h
	POP     ES
	XOR     DI,DI
	MOV     CX,60000
	MOV     EAX,014141414h
OTSC_Clear_Loop:
	STOSD
	OR      DI,DI
	JNE     OTSC_Clear_OK
	CALL    IncVesaPage
OTSC_Clear_OK:
	LOOP    OTSC_Clear_Loop
	POP     ES
	POPAD
	RET

FixPrefs:
	CMP     [havejoy],0f00bh
	JNE     FPRF_JoyCalibrated
	MOV     [havejoy],0ffffh

	push ax ;
	push dx ;May be not necesary
	push cx ;

	mov dx, 201h
	mov cx, 0FFFFh
	out dx, al
joybu:  in al, dx
	test al, 1
	jz isjoy
	loop joybu

isjoy:  or cx, cx
	pop cx ;
	pop dx ;Idem
	pop ax ;

	jz FPRF_nojoy

	CMP     [joyr],4
	JNC     FPRF_JoyCalibrated
FPRF_nojoy:
	MOV     [havejoy],0
FPRF_JoyCalibrated:
	CMP     [SBinstalled],0
	JNE     FPRF_DontClearSB
	MOV     [usesound],0
FPRF_DontClearSB:

	MOV     BP,[havejoy]
	AND     [usejoy],BP

	MOV     AX,[refreshrate]        ; force reasonable values
	MOV     [refreshrate],1
	OR      AX,AX
	JS      FPRF_RRateOK
	CMP     AX,10
	JNC     FPRF_RRateOK
	MOV     [refreshrate],AX
FPRF_RRateOK:
	MOV     AX,[usevesa]
	NOT     AX
	OR      [smallvesa],AX

	MOV     SI,OFFSET EngNormTab
	CMP     [germkey],0
	JE      SHORT FPRF_FixMap
	MOV     SI,OFFSET FrnNormTab
	CMP     [germkey],1
	JE      SHORT FPRF_FixMap
	MOV     SI,OFFSET GerNormTab
FPRF_FixMap:
	PUSH    ES                      ; Replace keyboard
	PUSH    SEG amsdos
	POP     ES
	MOV     DI,[CPCKtb]
	MOV     CX,0FAh/2
	REP     MOVSW
	POP     ES

	RET

InitHardware:
	MOV     [ffly],0
	MOV     [scrbase],0ffffh
	MOV     [colmode],0
	MOV     [scrtype],0
	MOV     [bordercol],0ffffh
	CALL    InitTape
	CALL    GenModeTabs

	RET

reset:  CALL    SB_Pause
        PUSH    40h
	POP     FS
	CLI
	MOV     AL,[FS:17h]
	OR      AL,96
	XOR     AL,64
	MOV     [FS:17h],AL
	SHR     AL,4
	AND     AL,7
	AND     [BYTE PTR FS:97h],0f8h
	OR      [FS:97h],AL
	STI
	CALL    SetLEDs
	CALL    ClearKeyMap

	MOV     [WORD PTR sysstat],9
	MOV     [memstate],9
	MOV     [romnum],0
	MOV     [doingems],0
	CALL    InitCRTC
	CALL    GenModeTab
	CALL    RethinkMemMap
	CALL    ResetRAMState
	CALL    RethinkRamState
	MOV     sPC,0
	InitPCSeg
	MOV     [sIFF1],0
	MOV     [sIFF2],0
	MOV     [intreq],0
	MOV     [imode],1
	MOV     [intflag],0
        CALL    SB_Continue
	RET

InitCRTC:
	MOV     BP,OFFSET CRTCregs
	MOV     [DWORD PTR BP],08e2e283fh
	MOV     [DWORD PTR BP+4],01e190026h
	MOV     [DWORD PTR BP+8],00000700h
	MOV     [DWORD PTR BP+12],00c00030h

	MOV     [crtc32state],0

	MOV     [crtcvtotal],312
	MOV     [crtcscrwidth],40
	MOV     [crtchsync],20
	MOV     [scroff],0
	MOV     [scrbase],0C000h
	MOV     [scrtype],0ffffh

	MOV     [videomode],1

	CALL    SetPCsCRTC
	RET

RethinkCRTC:
	PUSH    sFree
	CMP     [usevesa],0
	JNE     CRTC_nonewborder
	MOV     sFree,[newborcol]
	CMP     [bordercol],sFree
	JE      CRTC_nonewborder
	CMP     [borchanges],2
	JNC     CRTC_clearborchg
	MOV     [bordercol],sFree
	CALL    SetBorder
CRTC_clearborchg:
	MOV     [borchanges],0
CRTC_nonewborder:

	XOR     sFree,sFree  ; 8: SetPCsCRTC

	PUSH    AX
	PUSH    BP
	MOV     BP,[WORD PTR CRTCregs+12]
	ROL     BP,8
	ADD     BP,BP
	MOV     AX,BP
	ADD     BP,BP
	AND     AX,7FEh
	AND     BP,0C000h
	MOV     [scrbase],BP
	MOV     [scroff],AX

	MOV     BP,[WORD PTR CRTCregs+12]
	ROL     BP,8
	AND     BP,[crtc32mask]
	MOV     [crtc32state],BP

	PUSH    ES
	PUSH    DI
	CALL    GetScrBankPt
	POP     DI
	POP     ES

	MOV     AL,[BYTE PTR CRTCregs+1]
;       MOV     [crtcscrwidth],AL

	CALL    SetPCsCRTC

	POP     BP
	POP     AX
CRTC_Ret:
	POP     sFree
	RET

outp:   BT      AX,14
	JC      OUT_noCRTC
	BT      AX,9
	JC      OUT_End
	BT      AX,8
	JC      OUT_CRTC_wr
	CALL    outCRTCreg
	JMP     OUT_End
OUT_CRTC_wr:
	CALL    outCRTCwr
	JMP     OUT_End
OUT_noCRTC:

	BT      AX,11
	JC      OUT_noPIO
	PUSH    AX
	AND     AH,3
	CMP     AH,0
	JNE     OUT_NotPIOa
	CALL    out8255a
	JMP     OUT_PIOend
OUT_NotPIOa:
	CMP     AH,1
	JNE     OUT_NotPIOb
	CALL    out8255b
	JMP     OUT_PIOend
OUT_NotPIOb:
	CMP     AH,2
	JNE     OUT_NotPIOc
	CALL    out8255c
	JMP     OUT_PIOend
OUT_NotPIOc:
	CALL    out8255control
OUT_PIOEnd:
	POP     AX
	JMP     OUT_noGary
OUT_noPIO:

	BT      AX,15
	JC      OUT_noGary
	PUSH    AX
	CALL    outga
	POP     AX
OUT_noGary:

	BT      AX,10
	JC      OUT_noDiskStuff
	PUSH    AX
	BT      AX,8
	JC      OUT_Disk_cmd
	CALL    outFA
	JMP     OUT_Disk_End
OUT_Disk_Cmd:
	CALL    outFB
OUT_Disk_End:
	POP     AX
OUT_NoDiskStuff:

	BT      AX,13
	JC      OUT_noROMnum
	PUSH    AX
	CALL    outROMnum
	POP     AX
OUT_noROMnum:
OUT_end:
	RET

outROMnum:
	MOV     AH,0
	CMP     AX,[romnum]
	JE      outROM_old
	MOV     [romnum],AX
	CALL    RethinkMemMap
outROM_old:
	RET

outCRTCreg:
	MOV     [CRTCregnum],AL
	RET

outCRTCwr:
	MOVZX   BP,[BYTE PTR CRTCregnum]
	AND     BP,31
	MOV     [BYTE PTR BP+CRTCregs],AL
	RET

out8255a:
	BT      [WORD PTR control8255],4
	JC      o8255aend
	MOV     [port8255a],AL
	MOV     sFree,[WORD PTR port8255c]
	SHR     sFree,6
	AND     sFree,3
	JE      inactivepsg
	CMP     sFree,3
	JE      latchpsg
	CMP     sFree,2
	JE      writepsg
o8255aend:
	RET

out8255b:
	MOV     [port8255b],AL
	RET

out8255c:
	PUSH    DX
	PUSH    AX
	XOR     DL,DL
	BT      [WORD PTR control8255],0
	JC      o8255clin
	OR      DL,15
o8255clin:
	BT      [WORD PTR control8255],3
	JC      o8255chin
	OR      DL,240
o8255chin:
	OR      [port8255c],DL
	XOR     [port8255c],DL
	AND     AL,DL
	OR      [port8255c],AL
	MOV     AH,AL
	SHR     AH,4
	AND     AH,2
	MOV     BP,DX
	CLI
	MOV     DX,61h
	IN      AL,DX
	AND     AL,0fch
	OR      AL,AH
	OUT     DX,AL
	STI

	POP     AX
	POP     DX
	AND     BP,0C0h
	JZ      inactivepsg
	MOV     sFree,AX
	SHR     sFree,6
	AND     sFree,3
	JE      inactivepsg
	CMP     sFree,3
	JE      latchpsg
	CMP     sFree,2
	JE      writepsg
	RET

out8255control:
	BT      AX,7
	JNC     out8255control_SF
	MOV     [control8255],AL
	CALL    UpdatePIOA
	CALL    UpdatePIOC
	RET
out8255control_SF:
	BT      AX,0
	JC      o8255cSFset
	PUSH    AX
	SHR     AL,1
	AND     AX,7
	XOR     BP,BP
	TEST    AX,4                      ; check whether that half is
	JZ      o8255cSFcBPok             ; in output mode
	MOV     BP,3
o8255cSFcBPok:
	BT      [WORD PTR control8255],BP
	JC      o8255cSFnores
	BTR     [WORD PTR port8255c],AX
	MOV     AL,[port8255c]
	CALL    out8255c
o8255cSFnores:
	POP     AX
	RET
o8255cSFset:
	PUSH    AX
	SHR     AL,1
	AND     AX,7
	XOR     BP,BP
	TEST    AX,4                      ; check whether that half is
	JZ      o8255cSFsBPok             ; in output mode
	MOV     BP,3
o8255cSFsBPok: ; don't you love cryptic identifiers?
	BT      [WORD PTR control8255],BP
	JC      o8255cSFnoset
	BTS     [WORD PTR port8255c],AX
	MOV     AL,[port8255c]
	CALL    out8255c
o8255cSFnoset:
	POP     AX
	RET

inactivepsg:
	RET

writepsg:
	MOV     BP,[WORD PTR psgregnum]
	AND     BP,00Fh
	MOV     AL,[port8255a]
	MOV     [BP+OFFSET psgregs],AL
	MOV     [BYTE PTR BP+OFFSET psgregmod],255
	CALL    DoSound
	CALL    UpdatePIOA
	RET

latchpsg:
	MOV     AL,[port8255a]
	AND     AL,15
	MOV     [psgregnum],AL
	CALL    UpdatePIOA
	RET

outga:  MOV     BP,AX
	SHR     BP,6
	AND     BP,3
	AND     AL,3Fh
	CMP     [BYTE PTR BP+rgsgarr],AL
	JE      outga_end
	MOV     [BYTE PTR BP+rgsgarr],AL
	CMP     BP,2
	JNE     outga1
	CMP     AL,[memstate]
	JE      outga_end
	MOV     [memstate],AL
	AND     [memstate],0EFh
	AND     AL,10h
	JZ      outga_nocli
	CALL    ClearInterruptCounter
outga_nocli:
	CALL    RethinkMemMap
	InitPCSeg
	CALL    RethinkMode
	JMP     outga_end
outga1: CMP     BP,1
	JE      ga_setcol
	CMP     BP,0
	JE      outga_colreg
	CMP     BP,3
	JE      RethinkRamState
	JMP     outga_end
outga_colreg:
	MOV     [BYTE PTR rgsgarr+1],255
outga_end:
	RET

ga_setcol:
	PUSH    AX
	PUSH    EBX
	PUSH    DX
	MOV     AL,[BYTE PTR rgsgarr]
	CMP     AL,16
	JNC     ga_sc_border
	AND     EAX,1Fh         ; *?*
	MOV     BL,[BYTE PTR (rgsgarr+1)]
	AND     BX,01Fh
	CMP     [EAX+garrcols],BL
	JE      ga_sc_end
	MOV     [EAX+garrcols],BL
	MOV     [needmodetab],1
ga_sc_end:
	POP     DX
	POP     EBX
	POP     AX
	RET
ga_sc_border:
	AND     EAX,0ffh
	CMP     AL,16
	JNE     ga_sc_end
	MOV     BL,[BYTE PTR (rgsgarr+1)]
	AND     BX,01Fh
	CMP     [EAX+garrcols],BL
	JE      ga_sc_end
	MOV     [EAX+garrcols],BL
	MOV     [newborcol],BX
	INC     [borchanges]
	CMP     [smallvesa],0
	JNE     ga_sc_end
	MOV     AL,[garrcols+16]
	MOV     AH,AL
	MOV     [WORD PTR modetab+2048],AX
	MOV     [WORD PTR modetab+2050],AX
	MOV     [WORD PTR modetab+2052],AX
	MOV     [WORD PTR modetab+2054],AX
	JMP     ga_sc_end

SetColors:
	PUSH    AX
	PUSH    EBX
	PUSH    DX
	XOR     EBX,EBX
	XOR     EAX,EAX

	MOV     AX,31
SCL_Loop:
	PUSH    AX
	CMP     [colmode],0
	JE      SCL_normcols
	MOV     EBX,[EAX*4+ColorTabA]
	JMP     SCL_colsok
SCL_normcols:
	MOV     EBX,[EAX*4+ColorTab]
SCL_colsok:
	PUSH    AX
	MOV     AX,1010h
	MOV     CX,BX
	ROL     EBX,16
	MOV     DH,BL
	XOR     EBX,EBX
	POP     BX
	CALL    Video
	XOR     EBX,EBX
	POP     AX
	DEC     AX
	JNS     SCL_Loop

	POP     DX
	POP     EBX
	POP     AX
	RET

SetBorder:
	PUSH    AX
	PUSH    EBX
	PUSH    DX

	MOV     BX,[bordercol]
	MOV     BH,BL
	MOV     AX,1001h
	CALL    Video

	POP     DX
	POP     EBX
	POP     AX
	RET

GenModeTab:
	PUSHAW
	PUSH    ES
	PUSH    DS
	POP     ES
	MOV     [needmodetab],0
	MOV     SI,OFFSET mode0tab
	CMP     [videomode],0
	JE      GMT_OK
	MOV     SI,OFFSET mode1tab
	CMP     [videomode],1
	JE      GMT_OK
	MOV     SI,OFFSET mode2tab
GMT_OK: MOV     CX,1024
	MOV     DI,OFFSET modetab
	MOV     BX,OFFSET garrcols
	CMP     [usevesa],0
	JE      GMT_Loop
	CMP     [smallvesa],0
	JNE     GMT_Loop
	ADD     CX,CX
GMT_Loop:
	LODSB
	XLATB
	STOSB
	LOOP    GMT_Loop
	MOV     AL,[garrcols+16]
	MOV     AH,AL
	MOV     [DI],AX
	MOV     [DI+2],AX
	MOV     [DI+4],AX
	MOV     [DI+6],AX
	POP     ES
	POPAW
	RET

GenModeTabs:
	CMP     [usevesa],0
	JE      GMTB_NoVesa
	CMP     [smallvesa],0
	JNE     GMTB_NoVesa

GMTV2:  PUSHAW
	MOV     AX,0
	MOV     DI,OFFSET mode2tab
GMTV2_Loop:
	MOV     CX,8
	XOR     DX,DX   ; DL = 0: no shift, 1: one set left, 2: one clr left
	CMP     AX,0BCh
	JNE     GMTV2_InnerLoop
	NOP
GMTV2_InnerLoop:
	XOR     DX,DX
	ROL     AL,1
	RCL     DX,1
	MOV     [DI],DL
	INC     DI
	LOOP    GMTV2_InnerLoop
	INC     AL
	JNE     GMTV2_Loop

GMTV0:
	MOV     SI,OFFSET garrcols
	MOV     AX,0
	MOV     DI,OFFSET mode0tab
GMTV0_Loop:
	MOV     AH,AL
	XOR     BX,BX
	ROL     AL,7
	RCL     BL,1
	ROL     AL,4
	RCL     BL,1
	ROL     AL,2
	RCL     BL,1
	ROL     AL,4
	RCL     BL,1
	MOV     BH,BL
	MOV     [DI],BX
	MOV     [DI+2],BX
	ADD     DI,4

	XOR     BX,BX
	ROL     AL,7
	RCL     BL,1
	ROL     AL,4
	RCL     BL,1
	ROL     AL,2
	RCL     BL,1
	ROL     AL,4
	RCL     BL,1
	MOV     BH,BL
	MOV     [DI],BX
	MOV     [DI+2],BX
	ADD     DI,4
	MOV     AL,AH
	INC     AL
	JNE     GMTV0_Loop

GMTV1:
	MOV     SI,OFFSET garrcols
	MOV     AX,0
	MOV     DI,OFFSET mode1tab
GMTV1_Loop:
	MOV     DX,AX
GMTV1_InnerLoop:
	XOR     BX,BX
	ROL     AL,5
	RCL     BL,1
	ROL     AL,4
	RCL     BL,1
	MOV     BH,BL
	MOV     [DI],BX

	XOR     BX,BX
	ROL     AL,5
	RCL     BL,1
	ROL     AL,4
	RCL     BL,1
	MOV     BH,BL
	MOV     [DI+2],BX

	XOR     BX,BX
	ROL     AL,5
	RCL     BL,1
	ROL     AL,4
	RCL     BL,1
	MOV     BH,BL
	MOV     [DI+4],BX

	XOR     BX,BX
	ROL     AL,5
	RCL     BL,1
	ROL     AL,4
	RCL     BL,1
	MOV     BH,BL
	MOV     [DI+6],BX

	ADD     DI,8

	MOV     AX,DX
	INC     AL
	JNE     GMTV1_Loop
	POPAW
	RET

GMTB_NoVesa:
GMT2:   PUSHAW

	MOV     AX,0
	MOV     DI,OFFSET mode2tab
GMT2_Loop:
	MOV     CX,4
	XOR     DX,DX   ; DL = 0: no shift, 1: one set left, 2: one clr left
	CMP     AX,0BCh
	JNE     GMT2_InnerLoop
	NOP
GMT2_InnerLoop:
	ROL     AL,2
	MOV     SI,AX
	AND     SI,3
	CMP     SI,3
	JE      GMT2_11
	CMP     SI,0
	JE      GMT2_00
	CMP     SI,2
	JE      GMT2_10
	JMP     GMT2_01
GMT2_11:
  ;      MOV     DL,0
	JMP     GMT2_Set

GMT2_00:
  ;      MOV     DL,0
	JMP     GMT2_Clr

GMT2_01:
	CMP     DL,0            ; pattern 01
	JNE     GMT2_01_DLnot0
	CMP     DH,1
	JNE     GMT2_01_normal
	MOV     DL,2
	JMP     GMT2_Clr        ; 1101 -> 1100, 1 clr left
GMT2_01_Normal:
	MOV     DL,1            ; 0001 -> 0011 , 1 set left
	JMP     GMT2_Set
GMT2_01_DLnot0:
	CMP     DL,1
	JNE     GMT2_01_DL2
	MOV     DL,2
	JMP     GMT2_Clr        ; 0101 -> 1100 , 1 clr left
GMT2_01_DL2:
	MOV     DL,1            ; 1001 -> 0011 , 1 set left
	JMP     GMT2_Set

GMT2_10:                        ; pattern 10
	CMP     DL,0
	JNE     GMT2_10_DLnot0
	CMP     DH,2
	JNE     GMT2_10_Normal
	MOV     DL,1
	JMP     GMT2_Set        ; 0010 -> 0011, 1 set left
GMT2_10_Normal:
	MOV     DL,2            ; 1110 -> 1100, 1 clr left
	JMP     GMT2_Clr
GMT2_10_DLnot0:
	CMP     DL,1
	JNE     GMT2_10_DL2
	MOV     DL,2
	JMP     GMT2_Clr        ; 0110 -> 1100, 1 clr left
GMT2_10_DL2:
	MOV     DL,1
	JMP     GMT2_Set        ; 1010 -> 0011, 1 set left

GMT2_Clr:
	MOV     [BYTE PTR DI],0
	MOV     DH,2
	JMP     GMT2_OK
GMT2_Set:
	MOV     [BYTE PTR DI],1
	MOV     DH,1
GMT2_OK:
	INC     DI
	LOOP    GMT2_InnerLoop
	INC     AL
	JNE     GMT2_Loop

GMT0:
	MOV     SI,OFFSET garrcols
	MOV     AX,0
	MOV     DI,OFFSET mode0tab
GMT0_Loop:
	MOV     AH,AL
	XOR     BX,BX
	ROL     AL,7
	RCL     BL,1
	ROL     AL,4
	RCL     BL,1
	ROL     AL,2
	RCL     BL,1
	ROL     AL,4
	RCL     BL,1
 ;       MOV     BL,[SI+BX]
	MOV     BH,BL
	MOV     [DI],BX
	ADD     DI,2

	XOR     BX,BX
	ROL     AL,7
	RCL     BL,1
	ROL     AL,4
	RCL     BL,1
	ROL     AL,2
	RCL     BL,1
	ROL     AL,4
	RCL     BL,1
 ;       MOV     BL,[SI+BX]
	MOV     BH,BL
	MOV     [DI],BX
	ADD     DI,2
	MOV     AL,AH
	INC     AL
	JNE     GMT0_Loop

GMT1:
	MOV     SI,OFFSET garrcols
	MOV     AX,0
	MOV     DI,OFFSET mode1tab
GMT1_Loop:
	MOV     DX,AX
GMT1_InnerLoop:
	XOR     BX,BX
	ROL     AL,5
	RCL     BL,1
	ROL     AL,4
	RCL     BL,1
	MOV     [DI],BL

	XOR     BX,BX
	ROL     AL,5
	RCL     BL,1
	ROL     AL,4
	RCL     BL,1
	MOV     [DI+1],BL

	XOR     BX,BX
	ROL     AL,5
	RCL     BL,1
	ROL     AL,4
	RCL     BL,1
	MOV     [DI+2],BL

	XOR     BX,BX
	ROL     AL,5
	RCL     BL,1
	ROL     AL,4
	RCL     BL,1
	MOV     [DI+3],BL

	ADD     DI,4

	MOV     AX,DX
	INC     AL
	JNE     GMT1_Loop
	POPAW
	RET

SetPCsCRTC:
	PUSHAW

	CALL    OpenScr
	MOV     AL,[BYTE PTR CRTCregs+9]
	INC     AL
	MOV     AH,[BYTE PTR CRTCregs+6]
	MUL     AH
	CMP     [vertoverscn],0
	JE      SPCC_HeightL25
	CMP     AX,201
	JC      SPCC_HeightL25
	MOV     [doublelinmode],0
	MOV     AL,[BYTE PTR CRTCregs+1]
	CMP     AL,41
	JNC     SPCC_WidthL40
	MOV     [pcrtcscrwidth],AL
	JMP     SPCC_ScrOpen
SPCC_HeightL25:
	MOV     [doublelinmode],1
SPCC_WidthL40:
	MOV     [pcrtcscrwidth],40
	JMP     SPCC_ScrOpen
SPCC_ScrOpen:
	CMP     [usevesa],0
	JNE     SPCC_Vesa

	MOV     AL,[pcrtcscrwidth]
	CMP     AL,0
	JE      SPCC_WidthOK
	CLI
	MOV     DX,3d4h
	PUSH    AX
	MOV     AL,13h
	OUT     DX,AL
	INC     DX
	IN      AL,DX
	POP     AX
	OUT     DX,AL
	STI

	CMP     AL,50
	JNC     SPCC_WidthOK

	ADD     AL,AL
	DEC     AL
	DEC     DX
	PUSH    AX
	MOV     AL,1
	CLI
	OUT     DX,AL
	INC     DX
	IN      AL,DX
	POP     AX
	OUT     DX,AL
	STI
SPCC_WidthOK:
	MOV     AX,[doublelinmode]
	CMP     [dlmode],AX
	JE      SPCC_End
	MOV     [dlmode],AX

	CLI                             ; 400 Zeilen
	MOV     DX,03d4h
	MOV     AL,9
	OUT     DX,AL
	INC     DX
	IN      AL,DX
	AND     AL,70h
	OUT     DX,AL

	MOV     DX,3D4h
	MOV     AL,9
	OUT     DX,AL
	INC     DX
	IN      AL,DX
	AND     AL,07fh
	CMP     [doublelinmode],0
	JE      SPCC_DLOK
	OR      AL,80h
SPCC_DLOK:
	OUT     DX,AL
	JMP     SPCC_End

SPCC_Vesa:
	MOV     [pcrtcscrwidth],50

	CMP     [smallvesa],0
	JNE     SPCC_End
				; turn on double lines
	CLI
	MOV     DX,3D4h
	MOV     AL,9
	OUT     DX,AL
	INC     DX
	IN      AL,DX
	AND     AL,07fh
	OR      AL,80h
	OUT     DX,AL

SPCC_End:
	POPAW
	STI
	RET

inp:    CMP     AH,0F4h
	JE      inpioA
	CMP     AH,0F5h
	JE      inpioB
	CMP     AH,0F6h
	JE      inpioC
	CMP     AH,0FBh
	JE      inpFB
	RET

UpdatePIOA:
	BT      [WORD PTR control8255],4
	JNC     UPIA_Ret
	BT      [WORD PTR port8255c],7
	JC      UPIA_Ret
	PUSH    AX
	CALL    readpsg
	MOV     [port8255a],AL
	POP     AX
UPIA_Ret:
	RET

inpioA: CALL    UpdatePIOA
	MOV     AL,[port8255a]
	RET

readpsg:
	CMP     [psgregnum],14
	JE      readpsgext
	MOVZX   BP,[psgregnum]
	MOV     AL,[BYTE PTR BP+psgregs]
	RET

readpsgext:
	PUSH    BX                           ; *?*
	MOV     BL,[port8255c]
	AND     BX,15
	MOV     AL,[BX+KeyMatrix]
	CMP     BL,9
	JNE     rpex_nojoy0
	MOV     BH,AL
	AND     BH,12
	JNE     rpex_jhok0
	OR      AL,12
rpex_jhok0:
	MOV     BH,AL
	AND     BH,3
	JNE     rpex_jvok0
	OR      AL,3
rpex_jvok0:
rpex_nojoy0:
	CMP     BL,6
	JNE     rpex_nojoy1
	MOV     BH,AL
	AND     BH,12
	JNE     rpex_jhok1
	OR      AL,12
rpex_jhok1:
	MOV     BH,AL
	AND     BH,3
	JNE     rpex_jvok1
	OR      AL,3
rpex_jvok1:
rpex_nojoy1:
	POP     BX
	RET

UpdatePIOC:
	MOV     AL,[port8255c]
	BT      [WORD PTR control8255],0
	JC      inpioc_lowok
	AND     AL,240
	OR      AL,0
inpioc_lowok:
	BT      [WORD PTR control8255],3
	JC      inpioc_hiok
	AND     AL,15
	OR      AL,0
inpioc_hiok:
	MOV     [port8255c],AL
	RET
inpioC:
	MOV     AL,[port8255c]
	RET

RethinkMode:
	PUSH    AX
	MOV     BP,[WORD PTR sysstat]
	AND     BP,3
	MOV     AL,[MoTable+BP]
	CMP     [videomode],AL
	JE      RTM_End
	MOV     [videomode],AL
	CALL    GenModeTab
RTM_End:
	POP     AX
	RET

OpenScr:
	CMP     [scrtype],1
	JE      OS_DontReopen
	MOV     [scrtype],1
	MOV     [dlmode],1
	CALL    SetMode
	CALL    SetColors
	CALL    SetBorder
OS_DontReopen:

	RET

SetMode:
	PUSH    ES

	CMP     [usevesa],0
	JNE     SMOD_UseVesa

	MOV     AX,13h
	CALL    Video
	POP     ES
	RET
SMOD_UseVesa:

	MOV     AX,4f02h
	MOV     BX,0103h
	PUSH    BX
	CALL    Video
	POP     CX
	PUSH    SEG vesabuffer
	POP     ES
	MOV     DI,OFFSET vesabuffer
	MOV     AX,4f01h
	CALL    Video
	CMP     [DWORD PTR vesabuffer+0ch],0
	JNE     SMOD_Happy
	MOV     [WORD PTR vesabuffer+0ch],OFFSET MySetWin
	MOV     [WORD PTR vesabuffer+0eh],SEG MySetWin
SMOD_Happy:
	POP     ES
	RET

ResetVesaPage:
	CMP     [usevesa],0
	JE      VESA_End
	MOV     [vesapage],0
	JMP     SetVesaPage
IncVesaPage:
	CMP     [usevesa],0
	JE      VESA_End
	INC     [vesapage]
	JMP     SetVesaPage
SetVesaPage:
	PUSHAD
	MOV     BX,0
	MOV     DX,[vesapage]
	MOV     AX,[WORD PTR vesabuffer+4]
	OR      AX,AX
	JE      SVEP_LEnd
	ADD     AX,AX
SVEP_Loop:
	ROL     AL,1
	JC      SVEP_LEnd
	ADD     DX,DX
	JMP     SVEP_Loop
SVEP_LEnd:
	CALL    [DWORD PTR vesabuffer+0ch]
	POPAD
VESA_End:
	RET

MySetWin:
	PUSH    AX
	MOV     AX,4f05h
	CALL    Video
	POP     AX
	RETF

 ; ******************************************************** RAM banking

InitRAMSegs:
	PUSH    ES
	MOV     [haveEMM],0
	CMP     [useems],0
	JE      IRAS_noEMS
	MOV     AX,3567h
	INT     21h
	CMP     [DWORD PTR ES:10],'XMME'
	JNE     IRAS_noEMS
	CMP     [DWORD PTR ES:14],'0XXX'
	JNE     IRAS_noEMS
	MOV     AH,41h
	INT     67h
	CMP     AH,0
	JNE     IRAS_noEMS
	MOV     [normramseg],BX
	MOV     AH,46h
	INT     67h
	OR      AH,AH
	JNE     IRAS_noEMS
	CMP     AL,040h
	JC      IRAS_noEMS
	MOV     AX,05801h
	INT     67h
	OR      AH,AH
	JNE     IRAS_noEMS
	CMP     CX,5
	JC      IRAS_noEMS
	CMP     CX,500
	JNC     IRAS_noEMS      ; panic!

	MOV     AX,5800h
	MOV     DI,SEG DiskBuf
	MOV     ES,DI
	MOV     DI,OFFSET DiskBuf
	INT     67h
	OR      AH,AH
	JNE     IRAS_noEMS
	XOR     AX,AX
	MOV     [emsscrmem],AX
	MOV     BX,[normramseg]
	MOV     SI,OFFSET DiskBuf
IRAS_EMSCheckL:
	LODSW
	MOV     DI,AX
	LODSW
	CMP     DI,BX
	JNE     IRAS_EMSCL_NotPF
	CMP     AX,0                    ; just a safety check
	JNE     IRAS_noEMS
IRAS_EMSCL_NotPF:
	CMP     [emsscrmem],0
	JNE     IRAS_EMSCL_Not4
	CMP     AX,4
	JC      IRAS_EMSCL_Not4
	MOV     DX,SEG hiram
	CMP     DI,DX
	JC      IRAS_EMSCL_Not4
	ADD     DX,0C00h
	CMP     DI,DX
	JNC     IRAS_EMSCL_Not4

	MOV     [emsscrmem],DI
	MOV     [emsscrpage],AX

	INC     AX                      ; now, see if we can have two pages
	CMP     [SI+2],AX
	JNE     IRAS_FoundOne_ButHalfBad
	XOR     AX,AX
	SUB     DX,0400h
	CMP     DI,DX
	JNC     IRAS_FoundOne_ButHalfBad
	CMP     CX,1
	JE      IRAS_FoundOne_ButHalfBad

	MOV     AX,0C00h
IRAS_FoundOne_ButHalfBad:
	MOV     [crtc32mask],AX

	JMP     IRAS_OK
IRAS_EMSCL_Not4:
	LOOP    IRAS_EMSCheckL
	CMP     [emsscrmem],0
	JE      IRAS_noEMS
IRAS_OK:
	MOV     AX,4E03h
	INT     67h
	OR      AH,AH
	JNE     IRAS_noEMS
	MOV     AX,4E00h
	MOV     DI,OFFSET pgtable
	PUSH    DS
	POP     ES
	INT     67h
	OR      AH,AH
	JNE     IRAS_noEMS
	MOV     AH,43h
	MOV     BX,8
	INT     67h
	CMP     AH,0
	JNE     IRAS_noEMS
	MOV     [haveEMM],1
	MOV     [emmha],DX
	MOV     BX,0
	MOV     AX,4400h
	PUSH    DX
	INT     67h
	POP     DX
	MOV     BX,1
	MOV     AX,4401h
	PUSH    DX
	INT     67h
	POP     DX
	MOV     BX,2
	MOV     AX,4402h
	PUSH    DX
	INT     67h
	POP     DX
	MOV     BX,3
	MOV     AX,4403h
	PUSH    DX
	INT     67h
	POP     DX
	MOV     BX,3
	MOV     AX,[emsscrpage]
	MOV     AH,044h
	INT     67h
	MOV     [mappedscr],3
	JMP     IRAS_End
IRAS_noEMS:
	MOV     [crtc32mask],0
	MOV     [normramseg],SEG rambase
	MOV     DX,OFFSET emsfail
	CALL    print
IRAS_End:
	POP     ES
	RET

CleanupEMM:
	CMP     [haveEMM],0
	JE      CEMM_Ret
	MOV     AH,45h
	MOV     DX,[emmha]
	INT     67h
	PUSH    ES
	MOV     AX,4E01h
	MOV     SI,OFFSET pgtable
	PUSH    DS
	POP     ES
	INT     67h
	POP     ES
CEMM_Ret:
	RET

ResetRAMState:
	PUSH    EAX
	MOV     EAX,[DWORD PTR ramstatetab]
	MOV     [DWORD PTR ramstate],EAX
	MOV     EAX,[DWORD PTR ramstatetab+4]
	MOV     [DWORD PTR ramstate+4],EAX
	POP     EAX
	RET

RethinkRamState:
	CMP     [haveEMM],0
	JNE     RTRS_EMM
	PUSHAD
	PUSH    ES

	MOV     AL,[BYTE PTR sysstat+1]
	AND     AX,7
	MOV     [BYTE PTR sysstat+1],AL
	ADD     AX,AX
	ADD     AX,AX
	ADD     AX,AX
	MOV     SI,AX
	ADD     SI,OFFSET ramstatetab
	MOV     DI,OFFSET ramstate
	MOV     CX,8
RTRS_Loop:
	LODSB
	CMP     AL,[DI]
	JE      RTRS_Equal
	MOV     AH,[DI]
	CALL    ExBanks
RTRS_Equal:
	INC     DI
	LOOP    RTRS_Loop
	CALL    GetScrBankPt
	POP     ES
	POPAD
	RET
RTRS_EMM:
	PUSHAW
	MOV     [doingems],1
	MOV     AL,[BYTE PTR sysstat+1]
	AND     AX,7
	MOV     [BYTE PTR sysstat+1],AL
	ADD     AX,AX
	ADD     AX,AX
	ADD     AX,AX
	MOV     SI,AX
	ADD     SI,OFFSET ramstatetab
	MOV     DI,OFFSET ramstate
	PUSH    DI
	XOR     BH,BH
	MOV     BL,[SI]
	MOV     AX,4400h
	MOV     DX,[emmha]
	PUSH    SI
	INT     67h
	POP     SI

	XOR     BH,BH
	MOV     BL,[SI+1]
	MOV     AX,4401h
	MOV     DX,[emmha]
	PUSH    SI
	INT     67h
	POP     SI

	XOR     BH,BH
	MOV     BL,[SI+2]
	MOV     AX,4402h
	MOV     DX,[emmha]
	PUSH    SI
	INT     67h
	POP     SI

	XOR     BH,BH
	MOV     BL,[SI+3]
	MOV     AX,4403h
	MOV     DX,[emmha]
	PUSH    SI
	INT     67h
	POP     SI

	POP     DI
	LODSD
	MOV     [DS:DI],EAX
	LODSD
	MOV     [DS:DI+4],EAX
	XOR     EAX,EAX
	POPAW
	MOV     [doingems],0
	RET

ExBanks:                ; IN: AL = Bank1, AH = Bank2 / corrects RamState
	PUSH    SI
	PUSH    DI
	PUSH    CX
	CALL    GetBankAddr
	XCHG    AL,AH
	PUSH    ES
	POP     FS
	MOV     SI,DI
	CALL    GetBankAddr
	MOV     CX,1000h
	PUSH    EAX
	PUSH    DX
	MOV     DX,4
EXBA_ExLoop:
	MOV     EAX,[ES:DI]
	XCHG    EAX,[FS:SI]
	STOSD
	ADD     SI,DX
	LOOP    EXBA_ExLoop
	POP     DX
	POP     EAX
	MOV     CX,8
	MOV     SI,OFFSET ramstate
EXBA_Correct:
	CMP     [SI],AL
	JNE     EXBA_NotAL
	MOV     [SI],AH
	JMP     EXBA_CorrectL
EXBA_NotAL:
	CMP     [SI],AH
	JNE     EXBA_CorrectL
	MOV     [SI],AL
EXBA_CorrectL:
	INC     SI
	LOOP    EXBA_Correct
	POP     CX
	POP     DI
	POP     SI
	RET

GetScrBankPt:
	CMP     [haveEMM],0
	JE      GSBP_noEMS
	MOV     AX,[crtc32state]
	CMP     [map32state],AX
	JNE     GSBP_NeedMapping

	MOV     AX,[scrbase]
	SHR     AX,14
	CMP     AX,[mappedscr]

	JE      GSBP_MappingOK
GSBP_NeedMapping:
	PUSHAW
	MOV     BX,[scrbase]
	SHR     BX,14
	MOV     [mappedscr],BX
	MOV     AX,[emsscrpage]
	MOV     AH,044h
	MOV     DX,[emmha]
	INT     67h

	MOV     AX,[crtc32state]
	MOV     [map32state],AX
	CMP     AX,0C00h
	JNE     GSBP_No32Scr
	MOV     BX,[mappedscr]
	INC     BX
	AND     BX,3
	MOV     AX,[emsscrpage]
	INC     AL
	MOV     AH,044h
	MOV     DX,[emmha]
	INT     67h
GSBP_No32Scr:

	POPAW
GSBP_MappingOK:
	MOV     AX,[emsscrmem]
	MOV     [WORD PTR scrbankpt+2],AX
	XOR     AX,AX
	MOV     [WORD PTR scrbankpt],AX
	RET
GSBP_noEMS:
	MOV     AX,[scrbase]
	SHR     AX,14
	CALL    GetBankAddr
	MOV     [WORD PTR scrbankpt],DI
	MOV     [WORD PTR scrbankpt+2],ES
	RET

GetBankAddr:            ; IN: AL = Bank / OUT: ES:DI Bankaddr
	PUSH    DS
	POP     ES
	PUSH    CX
	MOV     DI,OFFSET ramstate
	MOV     CX,8
	REPNE   SCASB
	SUB     DI,OFFSET ramstate+1
	CMP     DI,4
	JC      GBAD_Lo
	AND     DI,3
	ROR     DI,2
	PUSH    SEG hiram
	POP     ES
	JMP     GBAD_End
GBAD_Lo:
	ROR     DI,2
	PUSH    SEG rambase
	POP     ES
GBAD_End:
	POP     CX
	RET

RethinkMemMap:
	MOV     BP,[normramseg]
	BT      [sysstat],2
	JC      RMM_LOK
	MOV     BP,SEG amsdos
RMM_LOK:
	MOV     [memmap],BP
RMM_TestUpper:
	MOV     BP,[normramseg]
	MOV     [memmap+2],BP
	MOV     [memmap+4],BP

	BT      [sysstat],3
	JC      RMM_UOK

	CMP     [haver5],0
	JE      RMM_No5
	CMP     [romnum],5
	JNE     RMM_No5
	MOV     BP,SEG rom5
	SUB     BP,0C00h
	JMP     RMM_UOK
RMM_No5:

	CMP     [haver6],0
	JE      RMM_No6
	CMP     [romnum],6
	JNE     RMM_No6
	MOV     BP,SEG rom6
	SUB     BP,0C00h
	JMP     RMM_UOK
RMM_No6:

	CMP     [haver7],0
	JE      RMM_No7
	CMP     [romnum],7
	JNE     RMM_No7
	MOV     BP,SEG rom7
	SUB     BP,0C00h
	JMP     RMM_UOK
RMM_No7:

	MOV     BP,SEG basic
	SUB     BP,0C00h
RMM_UOK:
	MOV     [memmap+6],BP

	RET

 ; **************************************************************** Snapshots

LoadSnap:
	PUSHAD
	MOV     [snapha],0ffffh
	MOV     DX,OFFSET snapdir
	MOV     AX,3d02h
	INT     21h
	JC      LOSN_End
	MOV     [snapha],AX

	MOV     BX,AX
	MOV     AH,3fh
	MOV     CX,256
	MOV     DX,OFFSET SnapBuffer
	INT     21h
	JC      LOSN_Close
	CMP     [DWORD PTR SnapBuffer+4],'ANS ' ; check file id
	JNE     LOSN_Close
	CMP     [DWORD PTR SnapBuffer],'- VM'
	JNE     LOSN_Close
	CMP     [BYTE PTR SnapBuffer+10h],1   ; snapshot version (1/2)?
	JE      LOSN_Ver1
	CMP     [BYTE PTR SnapBuffer+10h],2
	JE      LOSN_Ver2
	JMP     LOSN_Close

LOSN_Ver2:

LOSN_Ver1:
	CALL    reset

	POPAD                                 ; read Z80 registers
	MOV     AX,[SnapBuffer+11h]
	ROL     AX,8
	MOV     sBC,[SnapBuffer+13h]
	MOV     sDE,[SnapBuffer+15h]
	MOV     nsHL,[SnapBuffer+17h]
	MOV     sPC,[SnapBuffer+23h]
	PUSHAD

	MOV     AL,[BYTE PTR SnapBuffer+19h]
	MOV     [BYTE PTR srF],AL
	AND     AL,80h
	MOV     [BYTE PTR srFhi],AL
	MOV     AL,[BYTE PTR SnapBuffer+1Ah]
	MOV     [BYTE PTR srI],AL
	MOV     AL,[BYTE PTR SnapBuffer+1Bh]
	MOV     [sIFF1],AL
	MOV     AL,[BYTE PTR SnapBuffer+1Ch]
	MOV     [sIFF2],AL
	MOV     AX,[SnapBuffer+1Dh]
	MOV     [ix],AX
	MOV     AX,[SnapBuffer+1Fh]
	MOV     [iy],AX
	MOV     AX,[SnapBuffer+21h]
	MOV     [simstack],AX
	MOVZX   AX,[BYTE PTR SnapBuffer+25h]
	MOV     [imode],AX
	MOV     AX,[SnapBuffer+26h]
	ROL     AX,8
	MOV     [sAFx],AX
	MOV     AX,[SnapBuffer+28h]
	MOV     [sBCx],AX
	MOV     AX,[SnapBuffer+2Ah]
	MOV     [sDEx],AX
	MOV     AX,[SnapBuffer+2Ch]
	MOV     [sHLx],AX

	MOV     BX,0                            ; set gary
LOSN_SetCols:
	MOV     AL,[BYTE PTR EBX+SnapBuffer+2Fh]
	MOV     [BYTE PTR rgsgarr],BL
	MOV     [BYTE PTR rgsgarr+1],AL
	CALL    ga_setcol
	INC     BX
	CMP     BX,17
	JNE     LOSN_SetCols
	MOV     AL,[BYTE PTR SnapBuffer+2eh]
	MOV     [BYTE PTR rgsgarr],AL
	MOV     AL,[BYTE PTR SnapBuffer+40h]
	MOV     [BYTE PTR rgsgarr+2],AL
	MOV     AL,[BYTE PTR SnapBuffer+41h]
	MOV     [BYTE PTR rgsgarr+3],AL

	MOV     AL,[BYTE PTR SnapBuffer+42h]             ; set CRTC
	MOV     [CRTCregnum],AL
	PUSH    ES
	PUSH    DS
	POP     ES
	MOV     SI,OFFSET SnapBuffer+43h
	MOV     DI,OFFSET CRTCregs
	MOV     CX,9
	REP     MOVSW

	MOV     AL,[BYTE PTR SnapBuffer+55h]
	MOV     [BYTE PTR romnum],AL
	MOV     AL,[BYTE PTR SnapBuffer+56h]
	MOV     [port8255a],AL
	MOV     AL,[BYTE PTR SnapBuffer+57h]
	MOV     [port8255b],AL
	MOV     AL,[BYTE PTR SnapBuffer+58h]
	MOV     [port8255c],AL
	MOV     AL,[BYTE PTR SnapBuffer+59h]
	MOV     [control8255],AL
	MOV     AL,[BYTE PTR SnapBuffer+5Ah]
	MOV     [psgregnum],AL
	MOV     SI,OFFSET SnapBuffer+5Bh
	MOV     DI,OFFSET PSGregs
	MOV     CX,8
	REP     MOVSW
	POP     ES

	MOV     BX,[snapha]                     ; read the RAM
	PUSH    DS
	PUSH    [normramseg]
	POP     DS
	MOV     DX,0
	MOV     CX,32768
	MOV     AH,3fh
	INT     21h
	ADD     DX,CX
	MOV     AH,3fh
	INT     21h
	POP     DS

	MOV     BP,0                            ; now we can use all the new
LOSN_SetPSG:                                    ; values
	PUSH    BP
	CALL    DoSound
	POP     BP
	INC     BP
	CMP     BP,14
	JNE     LOSN_SetPSG

	CALL    RethinkMemMap
	CALL    RethinkRamState
	POPAD
	InitPCSeg
	PUSHAD
	CALL    RethinkCRTC
	CALL    RethinkMode
	CALL    GenModeTab
	MOV     [scrtype],0ffffh
	MOV     [intflag],0
LOSN_Close:
	MOV     BX,[snapha]
	MOV     AH,3Eh
	INT     21h
LOSN_End:
	POPAD
	RET

SaveSnap:
	PUSHAD
	CALL    GetSaveSnapName

	CMP     [snaname],0
	JE      SASN_End

	MOV     [snapha],0ffffh
	MOV     DX,OFFSET snapdir
	MOV     AX,3c00h
	XOR     CX,CX
	INT     21h
	JC      SASN_End
	MOV     [snapha],AX

	MOV     DX,OFFSET SnapBuffer
	MOV     [DWORD PTR EDX],'- VM'
	MOV     [DWORD PTR EDX+4],'ANS '
	MOV     [BYTE PTR EDX+10h],1    ; snapshot version must be 1

	POPAD
	ROL     AX,8                              ; read Z80 registers
	MOV     [SnapBuffer+11h],AX
	ROL     AX,8
	MOV     [SnapBuffer+13h],sBC
	MOV     [SnapBuffer+15h],sDE
	MOV     [SnapBuffer+17h],nsHL
	MOV     [SnapBuffer+23h],sPC
	PUSHAD

	MOV     AL,[BYTE PTR srF]
	AND     AL,7fh
	OR      AL,[BYTE PTR srFhi]
	MOV     [BYTE PTR SnapBuffer+19h],AL
	MOV     AL,[BYTE PTR srI]
	MOV     [BYTE PTR SnapBuffer+1Ah],AL

	MOV     AL,[sIFF1]
	MOV     [BYTE PTR SnapBuffer+1Bh],AL
	MOV     AL,[sIFF2]
	MOV     [BYTE PTR SnapBuffer+1Ch],AL
	MOV     AX,[ix]
	MOV     [SnapBuffer+1Dh],AX
	MOV     AX,[iy]
	MOV     [SnapBuffer+1Fh],AX
	MOV     AX,[simstack]
	MOV     [SnapBuffer+21h],AX
	MOV     AX,[imode]
	MOV     [BYTE PTR SnapBuffer+25h],AL
	MOV     AX,[sAFx]
	ROL     AX,8
	MOV     [SnapBuffer+26h],AX
	MOV     AX,[sBCx]
	MOV     [SnapBuffer+28h],AX
	MOV     AX,[sDEx]
	MOV     [SnapBuffer+2Ah],AX
	MOV     AX,[sHLx]
	MOV     [SnapBuffer+2Ch],AX

	MOV     BX,0                            ; set gary
SASN_SetCols:
	MOV     AL,[BYTE PTR EBX+garrcols]
	MOV     [BYTE PTR EBX+SnapBuffer+02Fh],AL
	INC     BX
	CMP     BX,17
	JNE     SASN_SetCols
	MOV     AL,[BYTE PTR rgsgarr]
	MOV     [BYTE PTR SnapBuffer+2eh],AL
	MOV     AL,[BYTE PTR rgsgarr+2]
	MOV     [BYTE PTR SnapBuffer+40h],AL
	MOV     AL,[BYTE PTR rgsgarr+3]
	MOV     [BYTE PTR SnapBuffer+41h],AL

	MOV     AL,[CRTCregnum]
	MOV     [BYTE PTR SnapBuffer+42h],AL             ; set CRTC
	PUSH    ES
	PUSH    DS
	POP     ES
	MOV     DI,OFFSET SnapBuffer+43h
	MOV     SI,OFFSET CRTCregs
	MOV     CX,9
	REP     MOVSW

	MOV     AL,[BYTE PTR romnum]
	MOV     [BYTE PTR SnapBuffer+55h],AL
	MOV     AL,[port8255a]
	MOV     [BYTE PTR SnapBuffer+56h],AL
	MOV     AL,[port8255b]
	MOV     [BYTE PTR SnapBuffer+57h],AL
	MOV     AL,[port8255c]
	MOV     [BYTE PTR SnapBuffer+58h],AL
	MOV     AL,[control8255]
	MOV     [BYTE PTR SnapBuffer+59h],AL
	MOV     AL,[psgregnum]
	MOV     [BYTE PTR SnapBuffer+5Ah],AL
	MOV     DI,OFFSET SnapBuffer+5Bh
	MOV     SI,OFFSET PSGregs
	MOV     CX,8
	REP     MOVSW
	POP     ES

	MOV     [SnapBuffer+06bh],64
	MOV     [SnapBuffer+06ch],0

	MOV     BX,[snapha]
	MOV     CX,256
	MOV     DX,OFFSET SnapBuffer
	MOV     AX,4000h
	INT     21h

	PUSH    DS
	PUSH    [normramseg]
	POP     DS
	MOV     DX,0
	MOV     CX,32768
	MOV     AH,40h
	INT     21h
	ADD     DX,CX
	MOV     AH,40h
	INT     21h
	POP     DS

	MOV     BX,[snapha]
	MOV     AH,3Eh
	INT     21h
SASN_End:
	POPAD
	CALL    GetSnapDir
	RET
ENDS

SEGMENT _data PAGE PUBLIC 'DATA'

emsfail  db 'EMS not available',13,10,0

haver5  dw 0
haver6  dw 0
haver7  dw 0

prefname db 'prefs.cpe',0

SnapBuffer dw 256 DUP (?)

CPCKTb   dw 0

LABEL MenuScr BYTE
	db '               CPE Preferences                                                  '
	db '                                                                                '
	db '  Borders (only relevant in full 800x600 mode)                                  '
	db '  Green monitor                                                                 '
	db '  Use sound card                                                                '
	db '  Use joystick                                                                  '
	db '  Limit speed to 100% (recommended)                                             '
	db '  Permit vertical overscan (turn off when possible)                             '
	db 80 DUP (' ')
	db 80 DUP (' ')
	db 80 DUP (' ')
	db 80 DUP (' ')
	db 80 DUP (' ')
	db 80 DUP (' ')
	db 80 DUP (' ')
	db 80 DUP (' ')
	db 80 DUP (' ')
	db 80 DUP (' ')
	db 80 DUP (' ')
	db 80 DUP (' ')
	db 80 DUP (' ')
	db 80 DUP (' ')
	db 80 DUP (' ')
	db 80 DUP (' ')
	db 80 DUP (' ')
	db 80 DUP (' ')
	db 80 DUP (' ')
	db 80 DUP (' ')
	db 80 DUP (' ')

MenuItems   dw 6

LABEL CPEPrefs WORD
bogoval     dw 52h
bogoval2    dw 1
germkey     dw 0
SBInstalled dw 0ffffh
SBport      dw 220h
lptnum      dw 1
bogoval3    dw 62h
cpctype     dw 3
refreshrate dw 1
usevesa     dw 0
smallvesa   dw 0
graphmenu   dw 0ffffh
useems      dw 0ffffh
LABEL sbirq WORD
gusint      dw 0bh
sbdma       dw 01h
DMAblocklen dw 0f0h
quietcas    dw 0ffffh

LABEL MenuVars WORD
borders     dw 0ffffh
colmode     dw 0
usesound    dw 0ffffh
usejoy      dw 0
dowait      dw 0ffffh
vertoverscn dw 0

LABEL joystuff WORD
joyr        dw 0
joyu        dw 0
joyl        dw 0
joyd        dw 0

havejoy     dw 0f00bh

MoTable db 0,1,2,0

vesabuffer  db    256 DUP (?)
vesapage    dw    0
savedvesapage dw  0

	EVEN

 ; CPC-Ports
 ; ************************************************ CRTC 6845
	    EVEN
CRTCregnum  db    ?,?           ; BCxx
CRTCregs    dw    16 DUP (?)    ; BDxx/BFxx 18 regs of video controller

scrbase     dw    0C000h        ; extract from CRTC regs 12/13
scroff      dw    0             ;  "       "    "    "     "
pcrtcscrwidth db   ?
crtcscrwidth db   ?             ; copy of CRTC reg 1
crtchsync   dw    0
crtcvtotal  dw    ?
scrtype     dw    0             ; 1,2: normal/normal 50Hz; 3: extended
doublelinmode dw  0             ; active screen uses double lines
dlmode      dw    0
videomode   db    0             ; CPC mode 0,1,2 - for fullscr modes only

crtc32mask  dw    0             ; for 32K screens
crtc32state dw    0

scrbankpt   dd    0
 ; ************************************************ 8255, PSG
	    EVEN
port8255a   db    ?   ; F4
port8255b   db    ?   ; F5
port8255c   db    ?   ; F6
control8255 db    ?   ; F7
psgregnum   db    ?,?
psgregs     dw    128 DUP (?)
psgregmod   dw    128 DUP (?)
channeloff  dw    0
PSGcount    dw    0

 ; ************************************************ GATE ARRAY
	    EVEN
romnum      dw    ?             ; this is the DFxx port
rgsgarr     dw    ?             ; 7Fxx 4  regs of gate array
sysstat     dw    ?   ; 7Fxx this and the last line MUST be kept together
memstate    db    0,0
ramstate    db    0,1,2,3,4,5,6,7

ramstatetab db    0,1,2,3,4,5,6,7
	    db    0,1,2,7,4,5,6,3
	    db    4,5,6,7,0,1,2,3
	    db    0,3,2,7,4,5,6,1
	    db    0,4,2,3,1,5,6,7
	    db    0,5,2,3,4,1,6,7
	    db    0,6,2,3,4,5,1,7
	    db    0,7,2,3,4,5,6,1

memmap      dw    SEG amsdos,SEG rambase,SEG rambase,SEG rambase

haveEMM     dw    0
normramseg  dw    0
emmha       dw    0
doingems    dw    0

emsscrmem   dw    0
emsscrpage  dw    0
mappedscr   dw    0
map32state  dw    0
emsmalloc   dw    0

needmodetab dw    0
garrcols    db    20 DUP (?)

modetab     dd    520 DUP (?)

mode0tab    dd    520 DUP (?)
mode1tab    dd    520 DUP (?)
mode2tab    dd    520 DUP (?)

bordercol   dw    0
newborcol   dw    0
borchanges  dw    0

 ; ************************************************ Interrupts
	    EVEN
intreq      dw    ?
ffly        dw    ?

 ; ************************************************ cleanup area
oldintadd   dw    0             ; 86 interrupt torture
oldintseg   dw    0
oldnoiadd   dw    0
oldnoiseg   dw    0
timercount  dw    0
timerval    dw    0f84h
pcffcount   dw    0
OldVideo    dw    3

ffly_dec_std dw   2
ffly_dec     dw   0

intcount     dw   0

pgtable     dw    256 DUP (?)           ; hopefully large enough

ENDS

SEGMENT _stack PARA STACK 'STACK'

TapeBuffer  dw    800h DUP (?)
TapeLoadBuf dw    800h DUP (?)

stck    dw 1000 dup (?)
stckend dw ?
ENDS

SEGMENT SEGRAM PRIVATE PARA USE32
rambase db      65536 DUP (?)
ENDS
SEGMENT SEGLOROM PRIVATE PARA
amsdos  db      16386 DUP (?)
ENDS
SEGMENT SEGBASIC PRIVATE PARA
basic   db      16386 DUP (?)
ENDS
SEGMENT SEGROM5 PRIVATE PARA
rom5    db      16386 DUP (?)
ENDS
SEGMENT SEGROM6 PRIVATE PARA
rom6    db      16386 DUP (?)
ENDS
SEGMENT SEGROM7 PRIVATE PARA
rom7    db      16386 DUP (?)
ENDS
SEGMENT SEGHIRAM PRIVATE PARA USE32
hiram   db      65536 DUP (?)
ENDS

	END
