; uPD765A Floppy Disk Controller emulation for CPE
; Copyright (c) 1996,97 by Ulrich Doewich
; cyrel@interlog.com

;	v0.01	Mar. 28, 1996 - 18:58
;	v0.02	Mar. 30, 1996 - 13:16
;	v0.03	Mar. 30, 1996 - 15:40
;	v0.04	Mar. 31, 1996 - 15:11
;	v0.05	Mar. 31, 1996 - 17:00
;	v0.06	Mar. 31, 1996 - 19:19
;	v0.07	Apr.  1, 1996 - 14:27
;	v0.08	Apr.  1, 1996 - 16:48
;	v0.09	Apr.  1, 1996 - 19:50
;	v0.10	Apr.  2, 1996 - 11:15
;	v0.11	Apr.  2, 1996 - 18:27
;	v0.12	Apr.  2, 1996 - 18:57
;	v0.13	Apr.  2, 1996 - 22:26
;	v0.14	Apr.  3, 1996 - 11:55
;	v0.15	Apr.  3, 1996 - 16:26
;	v0.16	Apr.  4, 1996 - 15:35
;	v0.17	Apr.  7, 1996 - 17:16
;	v0.18	Apr.  8, 1996 - 17:51
;	v0.19	Apr. 11, 1996 - 18:14
;	v0.20	Apr. 14, 1996 - 17:27	included support for normal CPD images
;	v0.21	Apr. 14, 1996 - 19:27	included support for packed CPD images
;	v0.22	Apr. 14, 1996 - 19:56	optimized seek_curr
;	v0.23	Apr. 17, 1996 - 10:54	writing to standard CPD and DSK works
;	v0.24	Apr. 17, 1996 - 14:55	code cleanup

;	v1.00	Apr. 17, 1996 - 15:09	first official release
;	v1.01	Apr. 19, 1996 - 23:42	coded FDCreadtrk
;	v1.02	Apr. 25, 1996 - 16:53	recoded read data routine
;	v1.03	Apr. 26, 1996 - 00:02	recoded read track + fixed read error
;	v1.04	Apr. 27, 1996 - 18:19	code cleanup
;	v1.05	May  26, 1996 - 13:48	code cleanup + debug output code
;	v1.06	Jul.  9, 1996 - 12:16	reduced buffer size to 8K
;	v1.07	Aug.  6, 1996 - 19:13	correct handling of invalid C H N
;	v1.08	Aug.  8, 1996 - 19:40	fixed EOT = 0 case for read track
;	v1.09	Sep.  2, 1996 - 13:51	non-sequential sector IDs w/ read track

;	v2.00	Oct. 19, 1996 - 11:44	1st working version of rewritten code
;	v2.01	Oct. 20, 1996 - 16:32	basic functionality restored
;	v2.02	Oct. 20, 1996 - 22:56	read track command
;	v2.03	Oct. 21, 1996 - 05:19	emulating random DE sectors
;	v2.04	Dec.  2, 1996 - 23:08	support for double sided disks
;	v2.05	Jan. 13, 1997 - 21:47	full support for drives A & B
;	v2.06	Jan. 24, 1997 - 18:33	changed read track behaviour
;	v2.07	Feb.  1, 1997 - 12:21	lock write protect if image is read only
;	v2.08	Feb.  6, 1997 - 19:34	fixed packed CPD reading
;	v2.09	Mar.  5, 1997 - 18:50	changed read track behaviour
;	v2.10	Mar. 17, 1997 - 19:56	fixed close_disk
;	v2.11	Mar. 22, 1997 - 14:55	using SetLEDs to flash Scroll Lock LED
;	v2.12	Mar. 29, 1997 - 20:30	converted to variable tab stops
;	v2.13	Mar. 30, 1997 - 22:42	partially implemented write data command
;	v2.14	Mar. 31, 1997 - 23:10	completed write data/ deleted data
;	v2.15	Apr.  2, 1997 - 20:20	updated FDC cmds according to new info
;	v2.16	Apr.  2, 1997 - 21:46	fixed Read Track (once again)
;	v2.17	Apr.  3, 1997 - 23:18	more updates to all commands
;	v2.18	Apr.  6, 1997 - 13:28	implemented Overrun condition
;	v2.19	Apr.  6, 1997 - 19:35	updated Overrun + fixed skip condition
;	v2.20	Apr.  8, 1997 - 23:52	modified Overrun handling

ideal
P386

Debug		equ	0

include		"globals.inc"

BUFFER_SIZE	equ	3000h

; from comp386.asm
extrn		UnpackArea:PROC

; from ipe2.asm
extrn		sRF:WORD

; from files.asm
extrn		current_drv:WORD, CPCa_pos:WORD, CPCb_pos:WORD, name_table:WORD

; from misc.asm
extrn		SetLEDs:PROC
extrn		LED_status:BYTE

public		outFA, outFB, inpFB, open_disk, close_disk
public		buffer_offs, data_bytes, stable_offs, phase, check_ORflag
public		overrun_flag, track_tableA, track_tableB, FDC_result

group		DGROUP	_stack, _data

segment		_text	page public 'CODE'
assume		cs:_text
assume		ds:DGROUP

; ________________________________________________________________________

LEDon:
		or	[LED_status], 1			; turn Scroll Lock on
		jmp	SetLEDs

; ________________________________________________________________________

LEDoff:
		and	[LED_status], 0feh		; turn Scroll Lock off
		jmp	SetLEDs

; ________________________________________________________________________

outFA:
		cmp	ah, 0fah
		jne	outFA_end
		mov	[byte ptr motor_state], al	; drive motor status
outFA_end:
		ret

; ________________________________________________________________________

outFB:
		cmp	cl, 7fh				; FDC Data register?
		je	outFB7F
		ret
outFB7F:
		cmp	[phase], CMD_PHASE
		je	outFB7F_cmd
		cmp	[phase], EXEC_PHASE
		je	outFB7F_exec
outFB7F_end:
		ret

; ........................................................................

outFB7F_cmd:

; ::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::

if Debug
		pushad
		mov	[byte ptr dbg_buffer], al	; store byte
		mov	ax, 3d02h			; open file read/ write
		mov	dx, offset dbg_name
		int	21h
		jnc	oFB7F_dbg10
		mov	ax, 3c00h			; create file
		mov	cx, 0				; normal attributes
		mov	dx, offset dbg_name
		int	21h
oFB7F_dbg10:
		mov	[dbg_handle], ax
		mov	bx, ax
		mov	ax, 4202h			; move file pointer to
		mov	cx, 0				; end of file
		mov	dx, 0
		int	21h

		cmp	[cmd_bytes_in], 0		; expecting command?
		jne	oFB7F_dbg20
		mov	al, [byte ptr dbg_buffer]
		call	convert
		mov	ax, 0a0dh			; CR/ LF
		mov	[word ptr dbg_buffer], ax
		mov	[word ptr dbg_buffer + 2], dx
		mov	[word ptr dbg_buffer + 4], ' :'
		mov	cx, 6
		jmp	oFB7F_dbg30
oFB7F_dbg20:
		mov	al, [byte ptr dbg_buffer]
		call	convert
		mov	[word ptr dbg_buffer], dx
		mov	[byte ptr dbg_buffer + 2], ' '
		mov	cx, 3
oFB7F_dbg30:
		mov	bx, [dbg_handle]
		mov	dx, offset dbg_buffer
		mov	ax, 4000h			; write to file
		int	21h
		mov	ax, 3e00h			; close file
		int	21h
		popad
endif

; ::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::

		mov	[temp_bx], bx
		movzx	bx, [cmd_bytes_in]
		or	bl, bl
		jnz	outFB7F_paras
		test	al, 20h				; skip AM or DAM?
		jz	outFB7F_noskip
		mov	[skip], 1
		and	al, 0dfh			; reset skip bit
		jmp	outFB7F_cont
outFB7F_noskip:
		mov	[skip], 0
outFB7F_cont:
		mov	bp, offset FDC_cmds
outFB7F_cmdloop:
		cmp	al, [bp]
		je	outFB7F_cmdfound
		add	bp, 6
		cmp	[byte ptr bp], 0ffh
		jne	outFB7F_cmdloop
outFB7F_cmdinvalid:
		mov	[byte ptr FDC_result], 80h
		mov	[result_bytes], 1
		mov	[phase], RESULT_PHASE
		mov	bx, [temp_bx]
		ret
outFB7F_cmdfound:
		mov	bh, [bp + 1]
		mov	[cmd_bytes], bh
		mov	bh, [bp + 2]
		mov	[result_bytes], bh
		mov	bh, [bp + 3]
		mov	[direction], bh
		mov	bp, [bp + 4]
		mov	[cmd_address], bp
		xor	bh, bh
outFB7F_paras:
		mov	[offset FDC_command + bx], al
		inc	bl
		cmp	bl, [cmd_bytes]
		je	outFB7F_CPdone
		mov	[cmd_bytes_in], bl
		mov	bx, [temp_bx]
		ret
outFB7F_CPdone:
		mov	bx, [temp_bx]
		mov	[phase], EXEC_PHASE
		mov	[cmd_bytes_in], 0

		jmp	[cmd_address]

; ........................................................................

outFB7F_exec:
		cmp	[direction], 1			; proper direction?
		jne	outFB7F_end

		mov	bp, [buffer_offs]
		mov	[bp], al
		inc	bp
		mov	[buffer_offs], bp
		dec	[data_bytes]
		jz	outFB7F_write
		ret
outFB7F_write:
		pushad
		mov	bp, [CPC_drv]
		movzx	ax, [byte ptr bp + CURRTRACK_offs]
		add	ax, ax
		mov	bx, ax
		add	ax, ax
		add	ax, bx				; track * 6
		mov	cl, [bp + SIDES_offs]
		shl	ax, cl				; * 2 if double sided
		mov	bx, ax
		cmp	[byte ptr bp + SIDE_offs], 1	; second side selected?
		jne	outFB7F_notforced
		add	bx, 6
		jmp	outFB7F_get_offset
outFB7F_notforced:
		cmp	[byte ptr bp + CURRSIDE_offs], 1
		jne	outFB7F_get_offset
		add	bx, 6
outFB7F_get_offset:
		mov	si, [bp + TTABLE_offs]
		mov	eax, [dword ptr si + bx]
		mov	dx, ax				; low word of offset
		ror	eax, 16
		mov	cx, ax				; high word of offset
		mov	bx, [bp + HANDLE_offs]

		cmp	[byte ptr bp + TYPE_offs], BSNORM
		jne	outFB7F_MV
		add	dx, 132				; skip track header
		adc	cx, 0
		jmp	outFB7F_BSnorm
outFB7F_MV:
		movzx	ax, [stable_index]
		shl	ax, 3
		add	ax, 18h				; sector info start
		push	cx
		push	dx
		add	dx, ax
		adc	cx, 0
		mov	ax, 4200h			; move file pointer
		int	21h
		mov	ax, 4000h			; write to file
		mov	dx, [stable_offs]		; current sector info
		mov	cx, 6
		int	21h
		pop	dx
		pop	cx
		add	dx, 256				; skip track header
		adc	cx, 0
outFB7F_BSnorm:
		mov	ax, 4200h			; move file pointer
		int	21h
		mov	ax, 4000h			; write to file
		mov	dx, offset data_buffer		; current track data
		mov	cx, [bp + TLENGTH_offs]
		int	21h
outFB7F_next:
		popad

		mov	[temp_ax], ax
		inc	[stable_index]
		add	[stable_offs], 8
outFB7F_checkEOT:
		mov	al, [cmd_R]
		cmp	al, [cmd_EOT]			; reached EOT?
		je	outFB7F_EPdone
		inc	[cmd_R]
		mov	eax, [dword ptr cmd_C]
		call	stable_scan
		jc	inpFB7F_error

		mov	ax, 80h				; End of Cylinder
		cmp	[FDC_command], 45h		; write data command?
		je	outFB7F_WDcmd
		mov	ah, 40h				; Control Mark
outFB7F_WDcmd:
		mov	[word ptr bp + 4], ax		; update ST1 & ST2

		mov	ax, [sector_length]
		mov	[data_bytes], ax
		mov	ax, [temp_ax]
		ret
outFB7F_EPdone:
		mov	[word ptr ST0], 8040h		; AT + End of Cylinder
		jmp	inpFB7F_EPexit

; ________________________________________________________________________

inpFB:
		cmp	cl, 7eh				; FDC status register
		je	inpFB7E
		cmp	cl, 7fh				; FDC data register
		je	inpFB7F
		cmp	cl, 0edh			; ??
		jne	inpFB_end
inpFBED:
		mov	al, [byte ptr sRF]
inpFB_end:
		ret

; ________________________________________________________________________

inpFB7E:
		mov	ax, 80h				; data register ready
		cmp	[phase], EXEC_PHASE
		jne	inpFB7E_notEP
		or	al, 30h				; executing & busy
		cmp	[direction], 0
		jne	inpFB7E_writing
		or	al, 40h				; FDC to CPU
inpFB7E_writing:
		ret
inpFB7E_notEP:
		cmp	[phase], RESULT_PHASE
		jne	inpFB7E_notRP
		or	al, 50h				; FDC to CPU & busy
		ret
inpFB7E_notRP:
		cmp	[cmd_bytes_in], 0
		je	inpFB7E_end
		or	al, 10h				; busy
inpFB7E_end:
		ret

; ________________________________________________________________________

inpFB7F:
		cmp	[phase], EXEC_PHASE
		je	inpFB7F_exec
		cmp	[phase], RESULT_PHASE
		je	inpFB7F_result
inpFB7F_end:
		ret

; ........................................................................

inpFB7F_exec:
		cmp	[direction], 0			; proper direction?
		jne	inpFB7F_end
inpFB7F_transfer:
		mov	bp, [buffer_offs]
		mov	al, [bp]
		xor	al, [repeat_count]
		inc	bp
		mov	[buffer_offs], bp
		dec	[data_bytes]
		jz	inpFB7F_cont
		mov	[overrun_flag], 0		; clear Overrun flag
		ret
inpFB7F_cont:
		mov	[check_ORflag], 0		; disable Overrun check
		mov	[temp_ax], ax
		inc	[stable_index]
		add	[stable_offs], 8
inpFB7F_checkEOT:
		cmp	[FDC_command], 42h		; read track command?
		je	inpFB7F_readtrk

		test	[word ptr ST1], 6131h		; any error bits set?
		jnz	inpFB7F_EPdone
inpFB7F_next:
		mov	al, [cmd_R]
		cmp	al, [cmd_EOT]			; reached EOT?
		je	inpFB7F_EPdone
		inc	[cmd_R]
		mov	eax, [dword ptr cmd_C]
		call	stable_scan
		jc	inpFB7F_error

		mov	ax, [word ptr bp + 4]		; get ST1 & ST2
		and	ax, 6125h			; mask unused bits
		cmp	[FDC_command], 4ch		; read deleted data cmd?
		jne	inpFB7F_notdeldata
		xor	ah, 40h				; invert Control Mark
inpFB7F_notdeldata:
		mov	[word ptr ST1], ax
		mov	ax, [sector_length]
		cmp	[skip], 0			; skip bit set?
		je	inpFB7F_noskip
		test	[ST2], 40h			; Control Mark set?
		jnz	inpFB7F_next
inpFB7F_noskip:
		mov	[data_bytes], ax
		mov	ax, [temp_ax]
		mov	[overrun_flag], 0		; clear Overrun flag
		mov	[check_ORflag], 1		; enable Overrun check
		ret
inpFB7F_readtrk:
		cmp	[sector_count], 0
		je	inpFB7F_EPdone
		dec	[sector_count]
		mov	al, [stable_index]
		cmp	al, [sectors]			; processed all sectors?
		jb	inpFB7F_nowrap
		mov	[stable_index], 0
		mov	[stable_offs], offset sector_table
inpFB7F_nowrap:
		inc	[cmd_R]
		mov	eax, [dword ptr cmd_C]
		mov	bp, [stable_offs]
		cmp	eax, [dword ptr bp]		; actual IDR
		je	inpFB7F_validIDR
		or	[ST1], 4			; No Data
inpFB7F_validIDR:
		and	[ST2], 0bfh			; reset Control Mark
		mov	ax, [word ptr bp + 4]		; get ST1 & ST2
		and	ax, 6125h			; mask unused bits
		or	[word ptr ST1], ax

		mov	ax, [word ptr bp + 6]		; sector data in buffer
		mov	[buffer_offs], ax
		mov	ax, [sector_length]
		mov	[data_bytes], ax
		mov	ax, [temp_ax]
		mov	[overrun_flag], 0		; clear Overrun flag
		mov	[check_ORflag], 1		; enable Overrun check
		ret
inpFB7F_EPdone:
		or	[word ptr ST0], 8040h		; AT + End of Cylinder
		test	[word ptr ST1], 7f7fh
		jz	inpFB7F_EPexit
inpFB7F_checkcmd:
		cmp	[FDC_command], 42h		; read track command?
		je	inpFB7F_EPexit
		and	[ST1], 7fh			; mask End of Cylinder
		test	[word ptr ST1], 2020h		; DE and/or DD?
		jz	inpFB7F_noDE
		and	[ST2], 0bfh			; mask Control Mark
		jmp	inpFB7F_EPexit
inpFB7F_noDE:
		test	[ST2], 40h			; Control Mark?
		jz	inpFB7F_EPexit
		and	[word ptr ST0], 7f3fh		; mask AT + EN
inpFB7F_EPexit:
		mov	eax, [dword ptr ST0]		; get ST0, 1 & 2
		mov	[dword ptr FDC_result], eax
		mov	eax, [dword ptr cmd_C]		; get C H R N
		mov	[dword ptr FDC_result + 3], eax

		mov	[phase], RESULT_PHASE
		call	LEDoff
		mov	ax, [temp_ax]
		ret
inpFB7F_error:
		mov	[word ptr ST0], 440h		; set AT & No Data
		mov	al, [bp]			; C of current sector
		cmp	al, [cmd_C]			; matches requested?
		je	inpFB7F_errorsameC
		mov	ah, 10h				; No Cylinder
		cmp	al, 0ffh
		jne	inpFB7F_errorcont
		mov	ah, 02h				; Bad Cylinder
inpFB7F_errorcont:
		or	[ST2], ah
inpFB7F_errorsameC:
		mov	eax, [dword ptr ST0]
		mov	[dword ptr FDC_result], eax
		mov	eax, [dword ptr bp]		; current IDR
		mov	[dword ptr FDC_result + 3], eax

		mov	[phase], RESULT_PHASE
		call	LEDoff
		ret

; ........................................................................

inpFB7F_result:
		mov	[temp_bx], bx
		movzx	bx, [res_bytes_out]
		mov	al, [offset FDC_result + bx]

; ::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::

if Debug
		pushad
		mov	[byte ptr dbg_buffer], al
		mov	ax, 3d02h			; open file read/ write
		mov	dx, offset dbg_name
		int	21h
		jnc	iFB7F_dbg10
		mov	ax, 3c00h			; create file
		mov	cx, 0				; normal attributes
		mov	dx, offset dbg_name
		int	21h
iFB7F_dbg10:
		mov	[dbg_handle], ax
		mov	bx, ax
		mov	ax, 4202h			; move file pointer
		mov	cx, 0				; to end of file
		mov	dx, 0
		int	21h

		mov	al, [byte ptr dbg_buffer]
		call	convert
		mov	[byte ptr dbg_buffer], '['
		mov	[word ptr dbg_buffer + 1], dx
		mov	[word ptr dbg_buffer + 3], ' ]'
		mov	cx, 5
		mov	bx, [dbg_handle]
		mov	dx, offset dbg_buffer
		mov	ax, 4000h			; write to file
		int	21h
		mov	ax, 3e00h			; close file
		int	21h
		popad
endif

; ::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::

		inc	bl
		cmp	bl, [result_bytes]
		je	inpFB7F_RPdone
		mov	[res_bytes_out], bl
		mov	bx, [temp_bx]
		ret
inpFB7F_RPdone:
		mov	[phase], CMD_PHASE
		mov	[res_bytes_out], 0
		mov	bx, [temp_bx]
		ret

; ________________________________________________________________________

build_ttableNORM:
		xor	ebx, ebx
		mov	bx, [di + TLENGTH_offs]		; maximum track length
		movzx	cx, [di + TRACKS_offs]
		push	di
		mov	di, [di + TTABLE_offs]
bttNORM_loop:
		mov	[dword ptr di], eax
		mov	[word ptr di + 4], bx		; track length
		add	eax, ebx
		add	di, 6
		loop	bttNORM_loop			; done all tracks?
		pop	di
		ret

; ________________________________________________________________________

build_ttablePACK:
		movzx	bx, [di + TRACKS_offs]
		mov	cl, [di + SIDES_offs]
		shl	bx, cl
		mov	cx, bx
		push	di
		mov	di, [di + TTABLE_offs]
		mov	si, offset data_buffer		; track table in image
bttPACK_loop:
		mov	eax, [dword ptr si]		; track offset in image
		mov	[dword ptr di], eax
		mov	[word ptr di + 4], 5252		; track length
		add	si, 4
		add	di, 6
		loop	bttPACK_loop			; done all tracks?
		pop	di
		ret

; ________________________________________________________________________

build_ttableEXTD:
		mov	eax, 256			; skip DSK header
		movzx	bx, [di + TRACKS_offs]
		mov	cl, [di + SIDES_offs]
		shl	bx, cl
		mov	cx, bx
		push	di
		mov	di, [di + TTABLE_offs]
		mov	si, offset data_buffer + 34h	; track table start in
							;  DSK header
bttEXTD_loop:
		xor	ebx, ebx
		mov	bh, [si]			; get track size
		mov	[word ptr di + 4], bx
		or	bh, bh				; unformatted track?
		jnz	bttEXTD_normal
		mov	[dword ptr di], 0
		jmp	bttEXTD_cont
bttEXTD_normal:
		mov	[dword ptr di], eax
		add	eax, ebx			; add size to offset
bttEXTD_cont:
		inc	si
		add	di, 6
		loop	bttEXTD_loop
		pop	di
		ret

; ________________________________________________________________________

open_disk:
		call	close_disk

		mov	[byte ptr di + SIDE_offs], 0
		mov	[byte ptr di + WPSTATUS_offs], OFF
		mov	dx, di
		add	dx, NAME_offs
		mov	ax, 3d02h			; open file read / write
		int	21h
		jnc	odsk_imageopen
		mov	ax, 3d00h			; open file read only
		int	21h
		jc	odsk_invimage
		mov	[byte ptr di + WPSTATUS_offs], LOCKED
odsk_imageopen:
		mov	[di + HANDLE_offs], ax		; store file handle
		mov	bx, ax
		mov	ax, 3f00h			; read from file
		cmp	[byte ptr di + TYPE_offs], MVNORM
		jge	odsk_MV
odsk_BS:
		mov	[byte ptr di + RNDFLAG_offs], OFF
		mov	cx, 9				; read CPD header..
		mov	dx, offset data_buffer
		int	21h
		cmp	[dword ptr data_buffer + 4], 'KSID'
		jne	odsk_invimage
		cmp	[dword ptr data_buffer], 'MRON'
		je	odsk_BSnorm
		cmp	[dword ptr data_buffer], 'XURC'
		jne	odsk_invimage
odsk_BSpack:
		mov	[byte ptr di + TYPE_offs], BSPACK
		mov	[byte ptr di + WPSTATUS_offs], LOCKED
		mov	al, [byte ptr data_buffer + 8]
		mov	[di + TRACKS_offs], al		; number of tracks
		mov	[byte ptr di + SIDES_offs], 0
		mov	ax, 3f00h			; read from file
		mov	cx, 184				; track table
		mov	dx, offset data_buffer
		int	21h
		call	build_ttablePACK
		jmp	odsk_validimage
odsk_BSnorm:
		mov	al, [byte ptr data_buffer + 8]
		mov	[di + TRACKS_offs], al		; number of tracks
		mov	[byte ptr di + SIDES_offs], 0
		mov	[word ptr di + TLENGTH_offs], 5252
		mov	eax, 9				; skip CPD header
		call	build_ttableNORM
		jmp	odsk_validimage

; ........................................................................

odsk_MV:
		mov	cx, 256				; image header
		mov	dx, offset data_buffer
		int	21h

		mov	al, [byte ptr data_buffer + 30h]
		mov	[di + TRACKS_offs], al		; number of tracks
		mov	al, [byte ptr data_buffer + 31h]
		test	al, 80h
		jz	odsk_MVnoRNDDE
		mov	[byte ptr di + RNDFLAG_offs], ON
		jmp	odsk_MVsetsides
odsk_MVnoRNDDE:
		mov	[byte ptr di + RNDFLAG_offs], OFF
odsk_MVsetsides:
		and	al, 3
		dec	al
		mov	[di + SIDES_offs], al		; number of sides
odsk_MVchecktype:
		cmp	[dword ptr data_buffer], '- VM'
		je	odsk_MVnorm
		cmp	[dword ptr data_buffer], 'ETXE'
		jne	odsk_invimage
odsk_MVextd:
		mov	[byte ptr di + TYPE_offs], MVEXTD
;		mov	[byte ptr di + WPSTATUS_offs], LOCKED
		call	build_ttableEXTD		; create track table
		jmp	odsk_validimage
odsk_MVnorm:
		mov	ax, [word ptr data_buffer + 32h]
		mov	[word ptr di + TLENGTH_offs], ax ; maximum track length
		mov	eax, 256			; skip DSK header
		call	build_ttableNORM		; create track table

; ........................................................................

odsk_validimage:
		mov	[byte ptr di + CURRTRACK_offs], 0
		call	seek_curr
		mov	[cmd_bytes_in], 0
		mov	[data_bytes], 0
		mov	[res_bytes_out], 0
		mov	[FDCint_flag], 0
		mov	[phase], CMD_PHASE
		clc
		jmp	odsk_end
odsk_invimage:
		mov	[byte ptr di + TYPE_offs], 0
		mov	[word ptr di + HANDLE_offs], 0ffffh
		stc
odsk_end:
		ret

; ________________________________________________________________________

close_disk:
		mov	di, [current_drv]
		cmp	[word ptr di + HANDLE_offs], 0ffffh
		je	cd_notopen			; no DSK file open?
		push	ax
		push	bx
		mov	bx, [di + HANDLE_offs]
		mov	ax, 3e00h			; close file
		int	21h
		pop	bx
		pop	ax
		mov	[word ptr di + HANDLE_offs], 0ffffh
cd_notopen:
		ret

; ________________________________________________________________________

update_drv:
		mov	bp, offset CPCa_pos
		test	[byte ptr cmd_unit], 1		; drive B?
		jz	ud_done
		mov	bp, offset CPCb_pos
ud_done:
		cmp	bp, [CPC_drv]			; drive changed?
		jne	ud_rereadtrack
		ret
ud_rereadtrack:
		mov	[CPC_drv], bp
		jmp	seek_curr

; ________________________________________________________________________

set_ST0:
		mov	bp, [CPC_drv]
		mov	al, [cmd_unit]
		and	al, 3				; current unit
		cmp	[byte ptr bp + CURRSIDE_offs], 0
		je	sST0_side0
		or	al, 4				; Head Address
sST0_side0:
		cmp	[word ptr bp + HANDLE_offs], 0ffffh
		jne	sST0_inserted
		or	al, 48h				; AT + Not Ready
sST0_inserted:
		test	[motor_state], 1		; is drive motor on?
		jnz	sST0_driveOK
		or	al, 48h				; AT + Not Ready
sST0_driveOK:
		mov	[ST0], al
		mov	[word ptr ST1], 0		; clear ST1 & ST2
		ret

; ________________________________________________________________________


FDCspecify:
		mov	[phase], CMD_PHASE
		ret

; ________________________________________________________________________

FDCdrvstat:
		call	update_drv
		mov	bp, [CPC_drv]
		mov	al, [cmd_unit]
		and	al, 3				; current unit
		cmp	[byte ptr bp + CURRSIDE_offs], 0
		je	FDCds_side0
		or	al, 4				; Head Address
FDCds_side0:
		cmp	[byte ptr bp + WPSTATUS_offs], 0
		je	FDCds_notWP
		or	al, 40h				; Write Protected
FDCds_notWP:
		or	al, 20h				; Ready
		cmp	[word ptr bp + HANDLE_offs], 0ffffh
		jne	FDCds_inserted
		and	al, 0dfh			; reset Ready
FDCds_inserted:
		test	[motor_state], 1		; is drive motor on?
		jnz	FDCds_driveOK
		and	al, 0dfh			; reset Ready
FDCds_driveOK:
		cmp	[byte ptr bp + CURRTRACK_offs], 0
		jne	FDCds_nottrack0
		or	al, 10h				; Track 0
FDCds_nottrack0:
		cmp	[byte ptr bp + SIDES_offs], 0
		je	FDCds_1sided
		or	al, 8				; Two Side
FDCds_1sided:
		mov	[byte ptr FDC_result], al
		mov	[phase], RESULT_PHASE
		ret

; ________________________________________________________________________

FDCrecalib:
		call	update_drv
		call	LEDon
		call	set_ST0
		xor	al, al
		jmp	FDCs_checktrack

; ________________________________________________________________________

FDCintstat:
		cmp	[FDCint_flag], 0		; no pending interrupt?
		je	FDCis_return80

		mov	[FDCint_flag], 0
		mov	bp, [CPC_drv]
		cmp	[FDbusy_flag], 0		; drive not busy?
		je	FDCis_notbusy
		mov	[FDbusy_flag], 0
		mov	al, 20h				; Seek End
		jmp	FDCis_cont
FDCis_notbusy:
		mov	al, 0c0h			; Attention Interrupt
FDCis_cont:
		cmp	[word ptr bp + HANDLE_offs], 0ffffh
		jne	FDCis_inserted
		or	al, 8				; Not Ready
FDCis_inserted:
		test	[motor_state], 1		; is drive motor on?
		jnz	FDCis_driveOK
		or	al, 8				; Not Ready
FDCis_driveOK:
		mov	ah, [bp + CURRTRACK_offs]
		mov	[word ptr FDC_result], ax
		jmp	FDCis_end
FDCis_return80:
		mov	[byte ptr FDC_result], 80h	; invalid command
		mov	[result_bytes], 1
FDCis_end:
		mov	[phase], RESULT_PHASE
		ret

; ________________________________________________________________________

FDCseek:
		call	update_drv
		call	LEDon
		call	set_ST0
		mov	al, [cmd_C]
FDCs_checktrack:
		mov	bp, [CPC_drv]
		cmp	al, [bp + CURRTRACK_offs]
		je	FDCs_end
		mov	[bp + CURRTRACK_offs], al
		call	seek_curr
FDCs_end:
		mov	[phase], CMD_PHASE
		mov	[FDCint_flag], 1
		mov	[FDbusy_flag], 1
		call	LEDoff
		ret

; ________________________________________________________________________

seek_curr:
		pushad
		test	[ST0], 8			; drive not ready?
		jnz	sc_end
		mov	bp, [CPC_drv]
		mov	al, [bp + CURRTRACK_offs]
		cmp	al, [bp + TRACKS_offs]		; track < max track?
		jb	sc_valid_track
		mov	[sectors], 0			; invalid track
		jmp	sc_end
sc_valid_track:
		xor	ah, ah
		add	ax, ax
		mov	bx, ax
		add	ax, ax
		add	ax, bx				; track * 6
		mov	cl, [bp + SIDES_offs]
		shl	ax, cl				; * 2 if double sided
		mov	bx, ax
		cmp	[byte ptr bp + SIDE_offs], 1	; second side selected?
		jne	sc_notforced
		add	bx, 6
		jmp	sc_get_offset
sc_notforced:
		cmp	[byte ptr bp + CURRSIDE_offs], 1
		jne	sc_get_offset
		add	bx, 6
sc_get_offset:
		mov	si, [bp + TTABLE_offs]
		mov	eax, [dword ptr si + bx]
		or	eax, eax			; unformatted track?
		jnz	sc_track_formatted
		mov	[sectors], 0
		jmp	sc_end
sc_track_formatted:
		mov	dx, [word ptr si + bx + 4]
		cmp	dx, BUFFER_SIZE
		jb	sc_not2large
		mov	dx, BUFFER_SIZE
sc_not2large:
		mov	[bp + TLENGTH_offs], dx
		mov	dx, ax				; low word of offset
		ror	eax, 16
		mov	cx, ax				; high word of offset
		mov	bx, [bp + HANDLE_offs]

		cmp	[byte ptr bp + TYPE_offs], BSNORM
		je	scBSnorm
		cmp	[byte ptr bp + TYPE_offs], BSPACK
		je	scBSpack
		cmp	[byte ptr bp + TYPE_offs], MVNORM
		je	scMV
		cmp	[byte ptr bp + TYPE_offs], MVEXTD
		je	scMV
sc_end:
		popad
		ret

; ........................................................................

build_BSstable:
		mov	di, offset sector_table
		mov	[max_slength], 0
		mov	bl, 0
		mov	dx, offset data_buffer
bBSst_scopy_loop:
		xor	eax, eax
		mov	al, [byte ptr si]		; sector ID
		cmp	al, 0ffh			; got all sectors?
		je	bBSst_done_scopy
		mov	ah, [byte ptr si + 66]		; sector size
		mov	cl, ah
		cmp	ah, [max_slength]		; greater sector size?
		jb	bBSst_cont
		mov	[max_slength], ah
bBSst_cont:
		rol	eax, 16
		mov	al, [bp + CURRTRACK_offs]
		mov	[dword ptr di], eax		; C H R N
		mov	[word ptr di + 4], 0		; blanks for ST0 & ST1
		mov	ax, 128
		rol	ax, cl
		mov	[word ptr di + 6], dx
		add	dx, ax
		inc	si
		add	di, 8
		inc	bl
		jmp	bBSst_scopy_loop
bBSst_done_scopy:
		mov	[sectors], bl			; sectors per track
		ret

; ........................................................................

scBSnorm:
		mov	eax, 4200h			; move file pointer
scBSn_read_tdata:
		int	21h
		mov	ax, 3f00h			; read from file
		mov	dx, offset data_buffer
		mov	cx, 132				; load track header
		int	21h

		mov	si, offset data_buffer
		call	build_BSstable			; build sector table

		mov	ax, 3f00h			; read from file
		mov	bx, [bp + HANDLE_offs]
		mov	cx, 5120
		mov	dx, offset data_buffer
		int	21h
scBSn_end:
		popad
		ret

; ........................................................................

scBSpack:
		xor	ch, ch				; mask compression flag
		push	ax
		mov	ax, 4200h			; move file pointer
		int	21h
		pop	ax

		cmp	ah, 0				; compressed track?
		je	scBSn_read_tdata
		mov	ax, 3f00h			; read from file
		mov	cx, 5252
		mov	dx, offset data_buffer + 8
		int	21h

		push	es
		mov	ax, ds
		mov	es, ax
		mov	si, offset data_buffer
		mov	[dword ptr si], 'XURC'		; prepare buffer for
		mov	[dword ptr si + 4], 'KCAP'	; unpack routine
		mov	di, offset name_table
		mov	cx, 5252
		call	far UnpackArea			; decompress track
		mov	si, offset name_table
		mov	bp, [CPC_drv]
		call	build_BSstable			; build sector table
		mov	si, offset name_table + 132
		mov	di, offset data_buffer
		mov	cx, 5120
		rep	movsb				; copy track data to
							;  data buffer
		pop	es
scBSp_end:
		popad
		ret

; ........................................................................

scMV:
		mov	eax, 4200h			; move file pointer
		int	21h
		mov	ax, 3f00h			; read from file
		mov	dx, offset data_buffer
		mov	cx, 256				; load track header
		int	21h
		mov	cl, [byte ptr data_buffer + 14h]
		mov	[max_slength], cl		; maximum sector size
		mov	ch, [byte ptr data_buffer + 15h]
		mov	[sectors], ch			; number of sectors
		or	ch, ch
		jz	scMV_end

		mov	di, offset sector_table
		mov	bx, 18h				; start of sector info
		mov	dx, offset data_buffer
scMV_scopy_loop:
		mov	eax, [dword ptr data_buffer + bx]
		mov	[dword ptr di], eax
		mov	eax, [dword ptr data_buffer + bx + 4]
		mov	[dword ptr di + 4], eax		; copy sector table
		mov	ax, [word ptr di + 6]
		cmp	[byte ptr bp + TYPE_offs], MVNORM
		jne	scMV_extd
		mov	ax, 128
		rol	ax, cl
scMV_extd:
		mov	[word ptr di + 6], dx
		add	dx, ax
		add	bx, 8
		add	di, 8
		dec	ch
		jnz	scMV_scopy_loop

		mov	ax, 3f00h			; read from file
		mov	bx, [bp + HANDLE_offs]
		mov	cx, [bp + TLENGTH_offs]
		mov	dx, offset data_buffer
		int	21h
scMV_end:
		popad
		ret

; ________________________________________________________________________

; IN	eax	requested C H R N

; OUT	bp	pointer to sector table entry
;	carry	set if sector not found

stable_scan:
		mov	[temp_bx], bx
sts_loop:
		mov	bl, [stable_index]
		cmp	bl, [sectors]
		jb	sts_nowrap
		mov	[stable_index], 0
		mov	[stable_offs], offset sector_table
		inc	[index_count]
sts_nowrap:
		mov	bp, [stable_offs]
		cmp	eax, [dword ptr bp]		; correct sector?
		je	sts_sfound
		cmp	[index_count], 1		; 2nd time 'round?
		jg	sts_notfound
		inc	[stable_index]
		add	[stable_offs], 8
		jmp	sts_loop
sts_notfound:
		stc
		jmp	sts_end
sts_sfound:
		mov	bx, [word ptr bp + 6]		; sector size in bytes
		mov	[buffer_offs], bx
		clc
sts_end:
		mov	[index_count], 0
		mov	bx, [temp_bx]
		ret

; ________________________________________________________________________

FDCreadtrk:
		call	update_drv
		call	LEDon
		call	set_ST0
		test	[ST0], 8			; drive not ready?
		jz	FDCrt_drvOK
		mov	ax, [word ptr ST0]
		mov	[word ptr FDC_result], ax
		mov	[byte ptr FDC_result + 2], 0
		jmp	FDCr_errorexit
FDCrt_drvOK:
		test	[cmd_unit], 4			; side 2?
		jz	FDCrt_side0
		mov	bp, [CPC_drv]
		mov	[byte ptr bp + CURRSIDE_offs], 1
		jmp	FDCrt_checkside
FDCrt_side0:
		mov	[byte ptr bp + CURRSIDE_offs], 0
FDCrt_checkside:
		mov	al, [bp + CURRSIDE_offs]
		cmp	al, [bp + PREVSIDE_offs]
		je	FDCrt_checksectors
		mov	[bp + PREVSIDE_offs], al
		call	seek_curr
FDCrt_checksectors:
		cmp	[sectors], 0			; track not formatted?
		je	FDCrID_error

		mov	[cmd_R], 1			; sector ID set to 1
		mov	[stable_index], 0
		mov	[stable_offs], offset sector_table
		mov	[buffer_offs], offset data_buffer

		mov	eax, [dword ptr cmd_C]
		cmp	eax, [dword ptr sector_table]	; actual IDR
		je	FDCrt_validIDR
		or	[ST1], 4			; No Data
FDCrt_validIDR:
		and	[ST2], 0bfh			; reset Control Mark
		mov	ax, [word ptr sector_table + 4]	; get ST1 & ST2
		and	ax, 6125h			; mask unused bits
		or	[word ptr ST1], ax

		mov	al, [cmd_EOT]
		mov	[sector_count], al
		cmp	[cmd_N], 0			; use DTL for length?
		jne	FDCrt_normalN
		movzx	ax, [cmd_DTL]
		cmp	ax, 80h				; greater than 128?
		jbe	FDCrt_cont
		mov	ax, 80h
		jmp	FDCrt_cont
FDCrt_normalN:
		mov	[temp_cx], cx
		mov	ax, 128
		mov	cl, [cmd_N]
		rol	ax, cl
		mov	cx, [temp_cx]
FDCrt_cont:
		mov	[sector_length], ax
		mov	[data_bytes], ax
		dec	[sector_count]
		mov	[repeat_count], 0

		mov	[overrun_flag], 0		; clear Overrun flag
		mov	[check_ORflag], 1		; enable Overrun check
		ret

; ________________________________________________________________________

FDCwrite:
		call	update_drv
		call	LEDon
		call	set_ST0
		test	[ST0], 8			; drive not ready?
		jnz	FDCw_drvnotOK
		mov	bp, [CPC_drv]
		cmp	[byte ptr bp + WPSTATUS_offs], 0
		je	FDCw_drvOK
		or	[word ptr ST0], 240h		; AT + Not Writable
FDCw_drvnotOK:
		mov	ax, [word ptr ST0]
		mov	[word ptr FDC_result], ax
		mov	[byte ptr FDC_result + 2], 0
		jmp	FDCr_errorexit
FDCw_drvOK:
		test	[cmd_unit], 4			; side 2?
		jz	FDCw_side0
		mov	[byte ptr bp + CURRSIDE_offs], 1
		jmp	FDCw_checkside
FDCw_side0:
		mov	[byte ptr bp + CURRSIDE_offs], 0
FDCw_checkside:
		mov	al, [bp + CURRSIDE_offs]
		cmp	al, [bp + PREVSIDE_offs]
		je	FDCw_checksectors
		mov	[bp + PREVSIDE_offs], al
		call	seek_curr
FDCw_checksectors:
		cmp	[sectors], 0			; track not formatted?
		je	FDCrID_error

		mov	eax, [dword ptr cmd_C]
		call	stable_scan
		jc	FDCr_error

		mov	ax, 80h				; End of Cylinder
		cmp	[FDC_command], 45h		; write data command?
		je	FDCw_WDcmd
		mov	ah, 40h				; Control Mark
FDCw_WDcmd:
		mov	[word ptr bp + 4], ax		; update ST1 & ST2

		cmp	[cmd_N], 0			; use DTL for length?
		jne	FDCw_normalN
		movzx	ax, [cmd_DTL]
		cmp	ax, 80h				; greater than 128?
		jbe	FDCw_cont
		mov	ax, 80h
		jmp	FDCw_cont
FDCw_normalN:
		mov	[temp_cx], cx
		mov	ax, 128
		mov	cl, [cmd_N]
		rol	ax, cl
		mov	cx, [temp_cx]
FDCw_cont:
		mov	[sector_length], ax
		mov	[data_bytes], ax
		ret

; ________________________________________________________________________

FDCread:
		call	update_drv
		call	LEDon
		call	set_ST0
		test	[ST0], 8			; drive not ready?
		jz	FDCr_drvOK
		mov	ax, [word ptr ST0]
		mov	[word ptr FDC_result], ax
		mov	[byte ptr FDC_result + 2], 0
		jmp	FDCr_errorexit
FDCr_drvOK:
		test	[cmd_unit], 4			; side 2?
		jz	FDCr_side0
		mov	bp, [CPC_drv]
		mov	[byte ptr bp + CURRSIDE_offs], 1
		jmp	FDCr_checkside
FDCr_side0:
		mov	[byte ptr bp + CURRSIDE_offs], 0
FDCr_checkside:
		mov	al, [bp + CURRSIDE_offs]
		cmp	al, [bp + PREVSIDE_offs]
		je	FDCr_checksectors
		mov	[bp + PREVSIDE_offs], al
		call	seek_curr
FDCr_checksectors:
		cmp	[sectors], 0			; track not formatted?
		je	FDCrID_error

		mov	eax, [dword ptr cmd_C]
		cmp	eax, [last_sector]
		jne	FDCr_norepeat
		cmp	[byte ptr bp + RNDFLAG_offs], OFF
		je	FDCr_checktrack
		inc	[repeat_count]
		jmp	FDCr_checktrack
FDCr_norepeat:
		mov	[last_sector], eax
		mov	[repeat_count], 0
FDCr_checktrack:
		call	stable_scan
		jc	FDCr_error

		mov	ax, [word ptr bp + 4]		; get ST1 & ST2
		and	ax, 6125h			; mask unused bits
		cmp	[FDC_command], 4ch		; read deleted data cmd?
		jne	FDCr_notrdd
		xor	ah, 40h				; invert Control Mark
FDCr_notrdd:
		mov	[word ptr ST1], ax
		test	ah, 40h				; Control Mark?
		jz	FDCr_noskip
		cmp	[skip], 0			; skip DAM or DDAM?
		je	FDCr_noskip
		mov	al, [cmd_R]
		cmp	al, [cmd_EOT]			; reached EOT?
		je	inpFB7F_EPdone
		inc	[cmd_R]
		mov	eax, [dword ptr cmd_C]
		jmp	FDCr_norepeat
FDCr_noskip:
		cmp	[cmd_N], 0			; use DTL for length?
		jne	FDCr_normalN
		movzx	ax, [cmd_DTL]
		cmp	ax, 80h				; greater than 128?
		jbe	FDCr_cont
		mov	ax, 80h
		jmp	FDCr_cont
FDCr_normalN:
		mov	[temp_cx], cx
		mov	ax, 128
		mov	cl, [cmd_N]
		rol	ax, cl
		mov	cx, [temp_cx]
FDCr_cont:
		mov	[sector_length], ax
		mov	[data_bytes], ax

		mov	[overrun_flag], 0		; clear Overrun flag
		mov	[check_ORflag], 1		; enable Overrun check
		ret
FDCr_error:
		mov	[word ptr ST0], 440h		; set AT & No Data
		mov	al, [bp]			; C of current sector
		cmp	al, [cmd_C]			; matches requested?
		je	FDCr_errorsameC
		mov	ah, 10h				; No Cylinder
		cmp	al, 0ffh
		jne	FDCr_errorcont
		mov	ah, 02h				; Bad Cylinder
FDCr_errorcont:
		or	[ST2], ah
FDCr_errorsameC:
		mov	eax, [dword ptr ST0]
		mov	[dword ptr FDC_result], eax
		mov	eax, [dword ptr bp]		; current IDR
		mov	[dword ptr FDC_result + 3], eax
FDCr_errorexit:
		mov	[FDCint_flag], 1
		mov	[phase], RESULT_PHASE
		call	LEDoff
		ret

; ________________________________________________________________________

FDCreadID:
		call	update_drv
		call	LEDon
		call	set_ST0
		test	[ST0], 8			; drive not ready?
		jz	FDCrID_drvOK
		mov	ax, [word ptr ST0]
		mov	[word ptr FDC_result], ax
		mov	[byte ptr FDC_result + 2], 0
		jmp	FDCrID_errorexit
FDCrID_drvOK:
		test	[cmd_unit], 4			; side 2?
		jz	FDCrID_side0
		mov	bp, [CPC_drv]
		mov	[byte ptr bp + CURRSIDE_offs], 1
		jmp	FDCrID_checkside
FDCrID_side0:
		mov	[byte ptr bp + CURRSIDE_offs], 0
FDCrID_checkside:
		mov	al, [bp + CURRSIDE_offs]
		cmp	al, [bp + PREVSIDE_offs]
		je	FDCrID_checksectors
		mov	[bp + PREVSIDE_offs], al
		call	seek_curr
FDCrID_checksectors:
		cmp	[sectors], 0			; track not formatted?
		je	FDCrID_error
		mov	al, [stable_index]
		cmp	al, [sectors]
		jb	FDCrID_nowrap
		mov	[stable_index], 0
		mov	[stable_offs], offset sector_table
FDCrID_nowrap:
		mov	bp, [stable_offs]
		mov	eax, 0				; cleared ST registers
		mov	[dword ptr FDC_result], eax
		mov	eax, [dword ptr bp]		; get C H R N
		mov	[dword ptr FDC_result + 3], eax
		mov	ax, [word ptr bp + 6]
		mov	[buffer_offs], ax

		add	[stable_offs], 8
		inc	[stable_index]

		mov	[phase], RESULT_PHASE
		mov	[FDCint_flag], 1
		call	LEDoff
		ret
FDCrID_error:
		mov	[word ptr ST0], 140h		; set AT & Missing AM
		mov	eax, [dword ptr ST0]
		mov	[dword ptr FDC_result], eax
		mov	eax, [dword ptr cmd_C]		; get C H R N
		mov	[dword ptr FDC_result + 3], eax
FDCrID_errorexit:
		mov	[phase], RESULT_PHASE
		mov	[FDCint_flag], 1
		call	LEDoff
		ret

; ________________________________________________________________________

FDCformattrk:
		call	update_drv
		call	LEDon

; ...

		ret

; ________________________________________________________________________

FDCscan:
		call	update_drv
		call	LEDon

; ...

		ret

; ________________________________________________________________________

FDCscanlo:
		call	update_drv
		call	LEDon

; ...

		ret

; ________________________________________________________________________

FDCscanhi:
		call	update_drv
		call	LEDon

; ...

		ret

; ________________________________________________________________________

; ::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::

if Debug
convert:
		mov	bl, al
		and	al, 0fh
		cmp	al, 9
		jg	convert10
		add	al, 30h
		jmp	convert20
convert10:
		add	al, 57h
convert20:
		mov	dh, al
		mov	al, bl
		ror	al, 4
		and	al, 0fh
		cmp	al, 9
		jg	convert30
		add	al, 30h
		jmp	convert40
convert30:
		add	al, 57h
convert40:
		mov	dl, al
		ret
endif

; ::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::

ends

segment		_data	page public 'DATA'

macro		fcmd	c1, c2, c3, c4, c5
		db	c1, c2, c3, c4
		dw	c5
endm

label FDC_cmds word

		fcmd	003h, 3, 0, 0, FDCspecify	; specify
		fcmd	004h, 2, 1, 0, FDCdrvstat	; sense drive status
		fcmd	007h, 2, 0, 0, FDCrecalib	; recalibrate
		fcmd	008h, 1, 2, 0, FDCintstat	; sense interrupt status
		fcmd	00fh, 3, 0, 0, FDCseek		; seek
		fcmd	042h, 9, 7, 0, FDCreadtrk	; read track
		fcmd	045h, 9, 7, 1, FDCwrite		; write data
		fcmd	046h, 9, 7, 0, FDCread		; read data
		fcmd	049h, 9, 7, 1, FDCwrite		; write deleted data
		fcmd	04ah, 2, 7, 0, FDCreadID	; read ID
		fcmd	04ch, 9, 7, 0, FDCread		; read deleted data
		fcmd	04dh, 6, 7, 1, FDCformattrk	; format track
		fcmd	051h, 9, 7, 0, FDCscan		; scan equal
		fcmd	059h, 9, 7, 0, FDCscanlo	; scan low or equal
		fcmd	05dh, 9, 7, 0, FDCscanhi	; scan high or equal
		db	0ffh

		even
last_sector	dd	0

buffer_offs	dw	offset data_buffer
cmd_address	dw	0
sector_length	dw	0
data_bytes	dw	0
temp_ax		dw	0
temp_bx		dw	0
temp_cx		dw	0
stable_offs	dw	offset sector_table
CPC_drv		dw	offset CPCa_pos

phase		dw	CMD_PHASE
check_ORflag	dw	0
overrun_flag	dw	0
FDbusy_flag	db	0
FDCint_flag	db	0
ST0		db	0
ST1		db	0
ST2		db	0
ST3		db	0
cmd_bytes	db	0
cmd_bytes_in	db	0
direction	db	0
index_count	db	0
max_slength	db	0
motor_state	db	0
res_bytes_out	db	0
result_bytes	db	0
sectors		db	0
skip		db	0
stable_index	db	0
sector_count	db	0
repeat_count	db	0

		even
FDC_command	db	0
cmd_unit	db	0
cmd_C		db	0
cmd_H		db	0
cmd_R		db	0
cmd_N		db	0
cmd_EOT		db	0
cmd_GPL		db	0
cmd_DTL		db	0

		even
FDC_result	db	10 dup (?)

sector_table	db	146 dup (?)
track_tableA	dw	480 dup (?)			; 80 tracks, 2 sides
track_tableB	dw	480 dup (?)			; 80 tracks, 2 sides

data_buffer	db	BUFFER_SIZE dup (?)

; ::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::

if Debug

dbg_handle	dw	0
dbg_buffer	db	10 dup (?)
dbg_name	db	'\out.dat', 0
dbg_divider	db	'- new DSK --------- '

endif

; ::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::

ends

; ________________________________________________________________________

segment		_stack	para stack 'STACK'
ends

end
