; CPE - The Amstrad CPC Emulator
; emulation core module
; Copyright (c) 1991-96 by Bernd Schmidt
; modifications Copyright (c) 1995-97 by Ulrich Doewich

;	Mar. ...		rewrote joystick routines + support for two
;	Mar. ...		reformatted source to use variable tabs
;	Mar. ...		new VESA graphics routines
;	Mar. ...		optimized set_colours + set_border
;	Mar. ...		shifted CPC colours upwards by 16 in VGA DAC
;	Mar. 23, 1997 - 16:57	made print_string colour aware + more efficient
;	Mar. 23, 1997 - 17:41	removed print_colbar and related material
;	Mar. 23, 1997 - 10:50	commented snapshot save & load routines
;	Mar. 24, 1997 - 00:35	hopefully fixed the snapshot handling
;	Mar. 28, 1997 - 19:25	modified joystick code to allow any combination
;	Apr. 19, 1997 - 20:14	fixed joystick 2 handling

IDEAL
P386

include		"globals.inc"

DEBUG		equ	0

SCR_WIDTH	equ	80
TEXT_COLOUR	equ	7

; from ipe2.asm
EXTRN		z80_reset:PROC, simz80:PROC, interrupt:PROC, ClearInterruptCounter:PROC
EXTRN		simstack:WORD, sAFx:WORD, sBCx:WORD, sDEx:WORD, sHLx:WORD, ix:WORD, iy:WORD
EXTRN		srF:WORD, srFhi:WORD, srI:WORD, imode:WORD, sIFF1:BYTE, sIFF2:BYTE
EXTRN		intflag:WORD, simz80l:PROC, sz80_instend:PROC
EXTRN		imode:WORD, count52:WORD
EXTRN		inpiob:PROC

; from files.asm
extrn		init_filesys:PROC, restore_snapshot:PROC, store_snapshot:PROC
extrn		cleanup_filesys:PROC
extrn		rsnap_handle:WORD, rsnap_name:BYTE, ssnap_handle:WORD, ssnap_name:BYTE
extrn		name_table:BYTE

; from fdc.asm
extrn		inpFB:PROC, outFA:PROC, outFB:PROC
extrn		buffer_offs:WORD, data_bytes:WORD, stable_offs:WORD, phase:WORD
extrn		check_ORflag:WORD, overrun_flag:WORD, FDC_result:BYTE

; from tape.asm
EXTRN		InitTape:PROC, CloseTape:PROC, GetTapeDir:PROC
EXTRN		TapeBuffer:WORD, tables_end:WORD

; from sound.asm
extrn		sound_reset:PROC, sound_shutdown:PROC, RethinkPSG:PROC, DoSound:PROC
extrn		sound_PSGreset:PROC
extrn		sound_pause:WORD, sound_continue:WORD

; from misc.asm
EXTRN		LoadROMs:PROC, Menu:PROC, ClearKeyMap:PROC, MyKeyInt:PROC
EXTRN		SetLEDs:PROC, KeyMatrix:BYTE, EngNormTab:BYTE, FrnNormTab:BYTE
EXTRN		GerNormTab:BYTE, ColorTab:DWORD, ColorTabA:DWORD
extrn		LED_status:BYTE

; ........................................................................

PUBLIC		amsdos, basic, rom5, rom6, rom7, haver5, haver6, haver7
PUBLIC		sysstat, scrbase, scroff, modetab, normramseg
PUBLIC		inp, outp, memmap, scrbankpt, dowait, intcount, DoJoystick
PUBLIC		intreq, ffly, refreshrate, usevesa, smallvesa, borders
PUBLIC		cleanup, reset
PUBLIC		RethinkCRTC, colmode, set_colours, reset_vesapage, inc_vesapage
PUBLIC		SetPCsCRTC
PUBLIC		SaveSnap, LoadSnap
PUBLIC		crtcvtotal, crtcscrwidth, crtchsync, doublelinmode
PUBLIC		CRTCregs, pcrtcscrwidth, crtc32state
PUBLIC		GenModeTab, needmodetab

PUBLIC		SCinstalled, SCport, SCwport, SCmirq, SCirq, SCdma, DMAblocklen, SCsrate
PUBLIC		stereo_flag, usesound, PSGcount, psgregmod
PUBLIC		psgregs

PUBLIC		cpctype, quietcas, germkey
;PUBLIC		TapeBuffer, TapeLoadBuf

PUBLIC		menu_layout, MenuItems, MenuVars, CPCKtb

public		init_joystick

PUBLIC		OpenTextScr, RestoreScreen
public		move_scrpos, print_string, vesa_winwrite, scr_colour


GROUP DGROUP	_stack, _data

INCLUDE		"macros.inc"

SEGMENT _text	PAGE PUBLIC 'CODE'
ASSUME		CS:_text
ASSUME		DS:DGROUP

; ________________________________________________________________________

start:
		mov	bx, seg tables_end		; end of data segment
		mov	ax, es				; PSP segment
		sub	bx, ax				; size of code+data
		mov	ax, offset tables_end
		shr	ax, 4
		add	bx, ax				; bx = paragraphs needed
		mov	ah, 4ah				; modify mem allocation
		int	21h

		mov	ax, DGROUP
		mov	ds, ax
		mov	ax, seg stck
		mov	ss, ax
		mov	ax, offset stckend
		mov	sp, ax

		XOR	EAX, EAX
		XOR	EBX, EBX
		XOR	ECX, ECX
		XOR	EDX, EDX
		XOR	ESI, ESI
		XOR	EDI, EDI
		XOR	EBP, EBP

		call	GetTapeDir
		CALL	GetOldKeyInt
		CALL	GetOld8253Int
		CALL	GetScrMode

		MOV	DX, OFFSET prefname
		MOV	AX, 3d00h			; open file
		INT	21h
		JC	cleanup
		MOV	BX, AX
		MOV	AH, 3Fh				; read from file
		MOV	DX, OFFSET CPEPrefs		; load preferences
		MOV	CX, 46
		INT	21h
		mov	ah, 3fh				; read from file
		mov	dx, offset ColorTab		; load colour table
		mov	cx, 128
		int	21h
		mov	ah, 3fh				; read from file
		mov	dx, offset name_table		; load path names
		mov	cx, 400
		int	21h
		MOV	AH, 3Eh				; close file
		INT	21h

		call	init_filesys
		CALL	InitRamSegs
		CALL	LoadROMs
		CALL	FixPrefs

		MOV	AX, CS
		MOV	DS, AX
		MOV	DX, OFFSET MyKeyInt		; install new KB handler
		MOV	AX, 2509h
		INT	21h
		MOV	AX, DGROUP
		MOV	DS, AX
		MOV	AX, [normramseg]
		MOV	ES, AX

		CALL	Set8253Int			; change hardware timer

		call	sound_reset
		CALL	InitHardware
		CALL	reset
		call	[sound_continue]		; start sound playback
		call	init_joystick

		JMP	simz80				; start emulation

; ________________________________________________________________________

print:
		pushad
		PUSH	ES
		PUSH	DS
		POP	ES
		XOR	AX, AX
		MOV	CX, 0ffffh
		MOV	DI, DX
		REPNZ	SCASB
		NEG	CX
		SUB	CX, 2
		MOV	AX, 4000h
		MOV	BX, 1
		INT	21h
		POP	ES
		popad
		RET

; ________________________________________________________________________

GetOldKeyInt:
		MOV	AX, 3509h
		INT	21h
		MOV	[oldintseg], ES
		MOV	[oldintadd], BX
		RET

; ________________________________________________________________________

DisableInt:
		PUSHAD
		MOV	DX, [oldintadd]
		MOV	AX, [oldintseg]
		MOV	DS, AX
		MOV	AX, 2509h
		INT	21h				; set interrupt
		MOV	AX, DGROUP
		MOV	DS, AX
		POPAD
		RET

; ________________________________________________________________________

GetOld8253Int:
		MOV	AX, 3508h
		INT	21h
		MOV	[old8253seg], ES
		MOV	[old8253add], BX
		RET

; ________________________________________________________________________

Set8253Int:
		MOV	AX, CS
		MOV	DS, AX
		MOV	DX, OFFSET My8253Int
		MOV	AX, 2508h
		INT	21h
		CLI
		MOV	AX, DGROUP
		MOV	DS, AX

		MOV	DX, 43h				; PIT control register
		MOV	AL, 36h				; R/W low/high; mode 3
		OUT	DX, AL
		MOV	DX, 40h				; PIT counter 0
		MOV	AX, [timerval]
		OUT	DX, AL				; low byte
		MOV	AL, AH
		OUT	DX, AL				; high byte
		STI
		RET

; ________________________________________________________________________

Res8253Int:
		CLI
		MOV	DX, 43h
		MOV	AL, 36h
		OUT	DX, AL
		MOV	DX, 40h
		MOV	AL, 000h
		OUT	DX, AL
		MOV	AL, 000h
		OUT	DX, AL

		MOV	AX, [old8253seg]
		MOV	DX, [old8253add]
		MOV	DS, AX
		MOV	AX, 2508h
		INT	21h
		MOV	AX, DGROUP
		MOV	DS, AX
		STI
		RET

; ________________________________________________________________________

My8253Int:
		PUSH	DS
		PUSH	EAX

		PUSH	DGROUP
		POP	DS

		CMP	[doingems], 0
		JNE	MII_NotInt

		INC	[intcount]
		AND	[intcount], 07fh
MII_NotInt:
		jmp	m8253_done

		cmp	[check_ORflag], 0		; check FDC Overrun?
		je	m8253_done
		cmp	[overrun_flag], 2		; got Overrun?
		jne	m8253_noOR

		mov	[check_ORflag], 0		; disable Overrun check
		mov	[phase], RESULT_PHASE		; switch to result phase
		mov	[word ptr FDC_result], 1040h	; set AT + Overrun
		push	si
		mov	si, [stable_offs]
		mov	eax, [dword ptr si]		; get current IDR
		mov	[dword ptr FDC_result + 3], eax
		pop	si

		and	[LED_status], 0feh		; turn Scroll Lock off
		mov	al, 0edh			; update keyboard LEDs
		out	60h, al
m8253_ledloop:
		in	al, 64h
		test	al, 2				; data in input buffer?
		jnz	m8253_ledloop
		mov	al, [LED_status]
		out	60h, al				; set LEDs
		jmp	m8253_done
m8253_noOR:
		inc	[overrun_flag]
m8253_done:
		MOV	AX, [timerval]
		ADD	[timercount], AX
		JNC	M8253_Ret

		POP	EAX
		POP	DS
		JMP	[old8253]
M8253_Ret:
		MOV	AL, 20h
		OUT	20h, AL

		POP	EAX
		POP	DS
		IRET

; ________________________________________________________________________

LABEL old8253 DWORD
old8253add	dw	0
old8253seg	dw	0

; ________________________________________________________________________

; init_joystick		determine joystick centre position

init_joystick:
		mov	[joy_mask], 0
		cmp	[usejoy1], 0			; joystick 1 enabled?
		je	ij_nojoy1
		or	[joy_mask], 03h			; scan joystick 1
ij_nojoy1:
		cmp	[usejoy2], 0			; joystick 2 enabled?
		je	ij_nojoy2
		or	[joy_mask], 0ch			; scan joystick 2
ij_nojoy2:
		cmp	[joy_mask], 0			; any joystick enabled?
		je	ij_nojoystick
ij_doinit:
		mov	[joy1_x_centre], 0
		mov	[joy1_y_centre], 0
		mov	[joy2_x_centre], 0
		mov	[joy2_y_centre], 0
		mov	ecx, 4				; get 4 readings..
		cli
ij_loop:
		push	ecx
		call	poll_joystick			; determine current pos
		pop	ecx
		jc	ij_nojoystick			; no joystick found?
		mov	eax, [joy1_x]
		add	[joy1_x_centre], eax		; update x total
		mov	eax, [joy1_y]
		add	[joy1_y_centre], eax		; update y total
		mov	eax, [joy2_x]
		add	[joy2_x_centre], eax		; update x total
		mov	eax, [joy2_y]
		add	[joy2_y_centre], eax		; update y total
		loopnz	ij_loop

		shr	[joy1_x_centre], 2		; determine x average
		shr	[joy1_y_centre], 2		; determine y average
		shr	[joy2_x_centre], 2		; determine x average
		shr	[joy2_y_centre], 2		; determine y average
		sti
		ret
ij_nojoystick:
		mov	[usejoy1], 0			; disable both
		mov	[usejoy2], 0			;  joysticks
		sti
		ret

; ________________________________________________________________________

; USES:
;	eax, ebx, ecx, dx

poll_joystick:
		mov	[joy1_x], 0
		mov	[joy1_y], 0
		mov	[joy2_x], 0
		mov	[joy2_y], 0
		mov	ecx, 0ffffh			; timeout counter
;		cli
		mov	dx, 201h			; joystick port
		xor	eax, eax
		out	dx, al				; start counters
poll_loop:
		in	al, dx				; get current value
		mov	ebx, eax
		shr	ebx, 1				; joystick1 X direction
		adc	[joy1_x], 0
		shr	ebx, 1				; joystick1 Y direction
		adc	[joy1_y], 0
		shr	ebx, 1				; joystick2 X direction
		adc	[joy2_x], 0
		shr	ebx, 1				; joystick2 Y direction
		adc	[joy2_y], 0
		test	al, [joy_mask]			; keep going?
		loopnz	poll_loop

;		sti
		or	ecx, ecx			; timed out?
		jz	poll_error
		ret
poll_error:
		stc					; set carry on timeout
		ret

; ________________________________________________________________________

if DEBUG

joy_debug:
		pushad
		push	ds
		mov	ax, 0a000h
		mov	ds, ax
		xor	di, di
		mov	ecx, 8
jd_loop:
		shr	edx, 1
		jc	jd_cont1
		mov	[byte ptr di], 0
		jmp	jd_cont2
jd_cont1:
		mov	[byte ptr di], 15
jd_cont2:
		inc	di
		loop	jd_loop
		mov	di, 320
		mov	[dword ptr di], 000f000fh
		mov	[dword ptr di + 4], 000f000fh
		pop	ds
		popad
		ret
endif

; ________________________________________________________________________

DoJoystick:
		cmp	[dword ptr usejoy1], 0		; joysticks disabled?
		je	dj_exit

		pushad
		cli
		call	poll_joystick

		mov	edx, eax
		cmp	[usejoy1], 0			; joystick 1 enabled?
		je	dj_joy2

		and	eax, 30h			; keep fire buttons
		movzx	ecx, [KeyMatrix + 9]
		and	ecx, 0cfh			; mask old button states
		or	ecx, eax			; add new state
		or	ecx, 0fh			; mask old directions

		mov	eax, [joy1_x]
		mov	ebx, eax
		sub	eax, [joy1_x_old]
		jns	dj_x1abs
		not	eax				; absolute difference
dj_x1abs:
		shr	ebx, 2
		cmp	eax, ebx
		jge	dj_donej1
		mov	eax, [joy1_y]
		mov	ebx, eax
		sub	eax, [joy1_y_old]
		jns	dj_y1abs
		not	eax				; absolute difference
dj_y1abs:
		shr	ebx, 2
		cmp	eax, ebx
		jge	dj_donej1

		mov	ebx, [joy1_x]
		mov	eax, [joy1_x_centre]
		shr	eax, 1
		cmp	ebx, eax
		jge	dj_notleftj1
		xor	ecx, 4				; left
dj_notleftj1:
		mov	eax, [joy1_x_centre]
		shl	eax, 1
		add	eax, [joy1_x_centre]
		shr	eax, 1
		cmp	ebx, eax
		jle	dj_notrightj1
		xor	ecx, 8				; right
dj_notrightj1:
		mov	ebx, [joy1_y]
		mov	eax, [joy1_y_centre]
		shr	eax, 1
		cmp	ebx, eax
		jge	dj_notupj1
		xor	ecx, 1				; up
dj_notupj1:
		mov	eax, [joy1_y_centre]
		shl	eax, 1
		add	eax, [joy1_y_centre]
		shr	eax, 1
		cmp	ebx, eax
		jle	dj_donej1
		xor	ecx, 2				; down
dj_donej1:
		mov	[KeyMatrix + 9], cl		; store updated value
		mov	eax, [joy1_x]
		mov	[joy1_x_old], eax
		mov	eax, [joy1_y]
		mov	[joy1_y_old], eax

; ........................................................................

		cmp	[usejoy2], 0			; joystick 2 enabled?
		je	dj_doneboth
dj_joy2:
		shr	edx, 2				; joystick2 fire buttons
		and	edx, 30h			; keep fire buttons
		or	edx, 0cfh

		mov	eax, [joy2_x]
		mov	ebx, eax
		sub	eax, [joy2_x_old]
		jns	dj_x2abs
		not	eax				; absolute difference
dj_x2abs:
		shr	ebx, 2
		cmp	eax, ebx
		jge	dj_donej2
		mov	eax, [joy2_y]
		mov	ebx, eax
		sub	eax, [joy2_y_old]
		jns	dj_y2abs
		not	eax				; absolute difference
dj_y2abs:
		shr	ebx, 2
		cmp	eax, ebx
		jge	dj_donej2

		mov	ebx, [joy2_x]
		mov	eax, [joy2_x_centre]
		shr	eax, 1
		cmp	ebx, eax
		jge	dj_notleftj2
		and	edx, 0fbh			; left
dj_notleftj2:
		mov	eax, [joy2_x_centre]
		shl	eax, 1
		add	eax, [joy2_x_centre]
		shr	eax, 1
		cmp	ebx, eax
		jle	dj_notrightj2
		and	edx, 0f7h			; right
dj_notrightj2:
		mov	ebx, [joy2_y]
		mov	eax, [joy2_y_centre]
		shr	eax, 1
		cmp	ebx, eax
		jge	dj_notupj2
		and	edx, 0feh			; up
dj_notupj2:
		mov	eax, [joy2_y_centre]
		shl	eax, 1
		add	eax, [joy2_y_centre]
		shr	eax, 1
		cmp	ebx, eax
		jle	dj_donej2
		and	edx, 0fdh			; down
dj_donej2:
if DEBUG
		call	joy_debug
endif
		mov	al, dl
		mov	ah, [joy2_prev]
		or	ah, [KeyMatrix + 6]
		and	ah, dl
		mov	[KeyMatrix + 6], ah
		not	al
		mov	[joy2_prev], al

		mov	eax, [joy2_x]
		mov	[joy2_x_old], eax
		mov	eax, [joy2_y]
		mov	[joy2_y_old], eax
dj_doneboth:
		popad
		sti
dj_exit:
		ret

; ________________________________________________________________________

GetScrMode:
		MOV	AH, 0FH				; get current video mode
		int	10h
		PUSH	AX
		MOV	AX, 1130H			; get font information
		MOV	BH, 0				; int 1fh - 8x8 gfx font
		MOV	DL, 0
		int	10h
		POP	AX
		MOV	DH, AH
		CMP	DL, 25
		SBB	AH, AH
		INC	AH
		MOV	[OldVideo], AX
		RET

; ________________________________________________________________________

SetOldMode:
		MOV	AX, [OldVideo]
		MOV	BX, 40h
		MOV	ES, BX
		MOV	BL, 20H
		CMP	AL, 7				; smMono
		JNE	@@1
		MOV	BL, 30H
@@1:
		AND	[BYTE PTR ES:10h], 0CFH		; Equipmentbyte
		OR	[ES:10h], BL
		AND	[BYTE PTR ES:87h], 0FEH		; CrtInfo
		PUSH	AX
		MOV	AH, 0
		int	10h
		POP	AX
		OR	AH, AH
		JE	@@2
		MOV	AX, 1112H
		MOV	BL, 0
		int	10h
		MOV	AX, 1130H
		MOV	BH, 0
		MOV	DL, 0
		int	10h
		CMP	DL, 42
		JNE	@@2
		OR	[BYTE PTR ES:87h], 1
		MOV	AH, 1
		MOV	CX, 600H
		int	10h
		MOV	AH, 12H
		MOV	BL, 20H
		int	10h
@@2:
		RET

; ________________________________________________________________________

cleanup:
		CALL	sound_shutdown
		CALL	CloseTape
		CALL	cleanup_filesys
		CALL	DisableInt
		CALL	Res8253Int
		CALL	SetOldMode
		CALL	CleanupEMM

		mov	dx, offset verstr_cpe
		mov	ah, 9
		int	21h

		EXITCODE

; ________________________________________________________________________

OpenTextScr:
		CMP	[usevesa], 0
		JE	OTSC_Standard
		CMP	[graphmenu], 0
		JE	OTSC_Standard

		mov	ax, [vesa_page]
		mov	[vesa_prevpage], ax
		mov	ax, [vesa_winwrite]
		mov	es, ax				; set es to write window
		jmp	clear_screenGM
OTSC_Standard:
		mov	ah, 0				; set text video mode
		mov	al, 3
		int	10h
		mov	ah, 2				; set cursor position
		mov	bh, 0
		mov	dx, 1900h			; column 0, row 25 ..
		int	10h				;  'disables' cursor
		mov	ax, 0b800h			; text screen segment
		mov	es, ax
		ret

; ________________________________________________________________________

RestoreScreen:
		CMP	[usevesa], 0
		JE	RSSC_Standard
		CMP	[graphmenu], 0
		JE	RSSC_Standard

;		call	clear_screenGM
		mov	ax, [vesa_prevpage]
		mov	[vesa_page], ax
		jmp	set_vesapage
RSSC_Standard:
		MOV	[scrtype], 0ffffh
		jmp	SetPCsCRTC

; ________________________________________________________________________

; IN:
;	ah	text x coordinate
;	al	text y coordinate

; OUT:
;	di	text mode screen address

; USES:
;	ax bx di

move_scrposTM:
		movzx	bx, ah
		xor	ah, ah
		imul	ax, SCR_WIDTH*2
		shl	bx, 1
		add	ax, bx
		mov	di, ax
		ret

; ________________________________________________________________________

; IN:
;	bl	string length
;	cl	text colour
;	es:di	text mode screen address
;	si	pointer to string

; USES:
;	ax bl di si

print_stringTM:
		mov	ah, cl				; text colour
psTM_loop:
		mov	al, [si]			; get character
		inc	si
		or	al, al				; end of string?
		jz	psTM_end
		cmp	al, 1				; colour change?
		jne	psTM_nocchange
		mov	ah, [si]			; update colour info
		inc	si
		jmp	psTM_loop
psTM_nocchange:
		mov	[es:di], ax			; write char + colour
		add	di, 2
		dec	bl
		jnz	psTM_loop
psTM_end:
		ret

; ________________________________________________________________________

; IN:
;	ah	text x coordinate
;	al	text y coordinate

; OUT:
;	di	pointer to video memory

move_scrposGM:
		push	dx
		mov	bx, ax
		movzx	edx, al				; Y position..
		mov	eax, edx
		shl	edx, 3
		add	edx, eax			; ..times 9
		movzx	eax, [vesa_bpscanline]		; bytes per scanline
		mul	edx
		movzx	ebx, bh				; X position..
		shl	ebx, 3				; ..times 8
		add	eax, ebx

		movzx	ebx, [vesa_wingranKB]
		shl	ebx, 10				; convert to bytes
		div	ebx
		mov	di, dx				; di holds offset
		mov	dx, ax				; dx holds segment

		mov	[vesa_page], dx
		mov	bx, 0				; set window A
		call	[vesa_winmove]
;		mov	dx, [vesa_page]
;		mov	bx, 1				; set window B
;		call	[vesa_winmove]
		pop	dx
		ret

; ________________________________________________________________________

; IN:
;	bl	string length
;	cl	text colour
;	es:di	graphics mode screen address
;	si	pointer to string

print_stringGM:
		pushad
		mov	bh, 0
		mov	[str_length], bx
		mov	bx, 100h			; query window A access
		call	[vesa_winmove]			;  location
		mov	[scr_bank], dx
psGM_strloop:
		mov	[str_pos], si
		mov	[scr_offs], di
		movzx	ax, [si]			; get character
		or	ax, ax				; end of string?
		jz	psGM_done
		cmp	al, 1
		jne	psGM_nocchange
		mov	cl, [si + 1]
		add	si, 2
		jmp	psGM_strloop
psGM_nocchange:
		mov	si, offset font_buffer		; start of font data
		shl	ax, 3				; times 8
		add	si, ax
		mov	bp, 8
		mov	dx, [vesa_bpscanline]
		sub	dx, 8
psGM_charloop:
		mov	al, [si]			; get row from matrix
		inc	si
		mov	ah, 80h				; test mask
psGM_testbit:
		mov	bl, cl
		shr	bl, 4
		test	al, ah				; bit set?
		jz	psGM_notset
		mov	bl, cl
		and	bl, 0fh
psGM_notset:
		mov	[byte ptr es:di], bl		; draw pixel on screen
		inc	di				; advance by 1 pixel
		jnz	psGM_nextbit
		call	inc_vesapage
psGM_nextbit:
		shr	ah, 1				; rotate test mask
		jnz	psGM_testbit			; row complete?
		add	di, dx				; advance by 1 line
		jnc	psGM_nooverflow
		call	inc_vesapage
psGM_nooverflow:
		dec	bp
		jnz	psGM_charloop			; loop for entire char
		mov	si, [str_pos]			; move pointer to next
		inc	si				;  character in string
		mov	di, [scr_offs]			; get starting screen
		add	di, 8				;  position and increase
		jnc	psGM_nochange
		call	inc_vesapage
psGM_nochange:
		mov	bx, 100h
		call	[vesa_winmove]
		cmp	dx, [scr_bank]			; did the bank change?
		je	psGM_nobankchange
		mov	dx, [scr_bank]
		mov	bx, 0
		call	[vesa_winmove]			; set window A address
psGM_nobankchange:
		dec	[str_length]
		jnz	psGM_strloop
psGM_done:
		popad
		mov	si, [str_pos]			; points to end of
		inc	si				;  string +1
		ret

; ________________________________________________________________________

clear_screenGM:
		pushad
		push	es

		mov	eax, 75300h			; 800 x 600
		xor	edx, edx
		movzx	ebx, [vesa_winsizeKB]
		shl	ebx, 10				; convert to bytes
		div	ebx
		inc	ax				; number of pages
		mov	si, ax
		mov	[vesa_page], 0			; start with 0
		xor	di, di				; start position
		mov	ax, [vesa_winwrite]
		mov	es, ax				; write window
		cld					; increasing direction
csGM_loop:
		mov	bx, 0				; set page 0
		mov	dx, [vesa_page]
		call	[vesa_winmove]
		xor	eax, eax			; fill with 0s
		mov	cx, 4000h
		rep	stosd
		mov	ax, [vesa_sizepgran]
		add	[vesa_page], ax			; next page
		dec	si
		jnz	csGM_loop

		pop	es
		popad
		ret

; ________________________________________________________________________

FixPrefs:
		cmp	[scinstalled], 0		; soundcard installed?
		jne	fp_SCinstalled
		mov	[usesound], 0			; disable sound output
fp_SCinstalled:
		MOV	AX, [refreshrate]		; force reasonable
		MOV	[refreshrate], 1		;  values..
;		OR	AX, AX
;		JS	FPRF_RRateOK
		CMP	AX, 10
		jg	FPRF_RRateOK
		MOV	[refreshrate], AX
FPRF_RRateOK:
		MOV	AX, [usevesa]
		NOT	AX
		OR	[smallvesa], AX

		MOV	SI, OFFSET EngNormTab
		CMP	[germkey], 0
		JE	SHORT FPRF_FixMap
		MOV	SI, OFFSET FrnNormTab
		CMP	[germkey], 1
		JE	SHORT FPRF_FixMap
		MOV	SI, OFFSET GerNormTab
FPRF_FixMap:
		PUSH	ES				; replace keyboard
		PUSH	SEG amsdos			;  translation table..
		POP	ES
		MOV	DI, [CPCKtb]
		MOV	CX, 0FAh/2
		REP	MOVSW
		POP	ES
		RET

; ________________________________________________________________________

InitHardware:
		MOV	[ffly], 0
		MOV	[scrbase], 0ffffh
;		MOV	[colmode], 0
		MOV	[scrtype], 0
		MOV	[bordercol], 0ffffh
		CALL	InitTape
		CALL	GenModeTabs
		RET

; ________________________________________________________________________

reset:
		PUSH	40h
		POP	FS
		CLI
		MOV	AL, [FS:17h]
		OR	AL, 96
		XOR	AL, 64
		MOV	[FS:17h], AL
		SHR	AL, 4
		AND	AL, 7
		AND	[BYTE PTR FS:97h], 0f8h
		OR	[FS:97h], AL
		STI
		CALL	SetLEDs
		CALL	ClearKeyMap

		MOV	[WORD PTR sysstat], 9
		MOV	[memstate], 9
		MOV	[romnum], 0
		MOV	[doingems], 0
		CALL	InitCRTC
		CALL	GenModeTab
		CALL	RethinkMemMap
		CALL	ResetRAMState
		CALL	RethinkRamState
		MOV	sPC, 0
		InitPCSeg
		MOV	[sIFF1], 0
		MOV	[sIFF2], 0
		MOV	[intreq], 0
		MOV	[imode], 1
		MOV	[intflag], 0

		mov	[check_ORflag], 0		; disable Overrun check
		mov	[overrun_flag], 0		; clear Overrun flag

		JMP	sound_PSGreset

; ________________________________________________________________________

InitCRTC:
		MOV	BP, OFFSET CRTCregs
		MOV	[DWORD PTR BP], 08e2e283fh
		MOV	[DWORD PTR BP+4], 01e190026h
		MOV	[DWORD PTR BP+8], 00000700h
		MOV	[DWORD PTR BP+12], 00c00030h

		MOV	[crtc32state], 0

		MOV	[crtcvtotal], 312
		MOV	[crtcscrwidth], 40
		MOV	[crtchsync], 20
		MOV	[scroff], 0
		MOV	[scrbase], 0C000h
		MOV	[scrtype], 0ffffh

		MOV	[videomode], 1

		CALL	SetPCsCRTC
		RET

; ________________________________________________________________________

RethinkCRTC:
		PUSH	sFree
		CMP	[usevesa], 0
		JNE	CRTC_nonewborder
		MOV	sFree, [newborcol]
		CMP	[bordercol], sFree
		JE	CRTC_nonewborder
		CMP	[borchanges], 2
		JNC	CRTC_clearborchg
		MOV	[bordercol], sFree
		CALL	set_border
CRTC_clearborchg:
		MOV	[borchanges], 0
CRTC_nonewborder:

		XOR	sFree, sFree			; 8: SetPCsCRTC

		PUSH	AX
		PUSH	BP
		MOV	BP, [WORD PTR CRTCregs+12]
		ROL	BP, 8
		ADD	BP, BP
		MOV	AX, BP
		ADD	BP, BP
		AND	AX, 7FEh
		AND	BP, 0C000h
		MOV	[scrbase], BP
		MOV	[scroff], AX

		MOV	BP, [WORD PTR CRTCregs+12]
		ROL	BP, 8
		AND	BP, [crtc32mask]
		MOV	[crtc32state], BP

		PUSH	ES
		PUSH	DI
		CALL	GetScrBankPt
		POP	DI
		POP	ES

		MOV	AL, [BYTE PTR CRTCregs+1]
;		MOV	[crtcscrwidth], AL

		CALL	SetPCsCRTC

		POP	BP
		POP	AX
CRTC_Ret:
		POP	sFree
		RET

; ________________________________________________________________________

outp:		BT	AX, 14
		JC	OUT_noCRTC
		BT	AX, 9
		JC	OUT_End
		BT	AX, 8
		JC	OUT_CRTC_wr
		CALL	outCRTCreg
		JMP	OUT_End
OUT_CRTC_wr:
		CALL	outCRTCwr
		JMP	OUT_End
OUT_noCRTC:

		BT	AX, 11
		JC	OUT_noPIO
		PUSH	AX
		AND	AH, 3
		CMP	AH, 0
		JNE	OUT_NotPIOa
		CALL	out8255a
		JMP	OUT_PIOend
OUT_NotPIOa:
		CMP	AH, 1
		JNE	OUT_NotPIOb
		CALL	out8255b
		JMP	OUT_PIOend
OUT_NotPIOb:
		CMP	AH, 2
		JNE	OUT_NotPIOc
		CALL	out8255c
		JMP	OUT_PIOend
OUT_NotPIOc:
		CALL	out8255control
OUT_PIOEnd:
		POP	AX
		JMP	OUT_noGary
OUT_noPIO:

		BT	AX, 15
		JC	OUT_noGary
		PUSH	AX
		CALL	outga
		POP	AX
OUT_noGary:

		BT	AX, 10
		JC	OUT_noDiskStuff
		PUSH	AX
		BT	AX, 8
		JC	OUT_Disk_cmd
		CALL	outFA
		JMP	OUT_Disk_End
OUT_Disk_Cmd:
		CALL	outFB
OUT_Disk_End:
		POP	AX
OUT_NoDiskStuff:

		BT	AX, 13
		JC	OUT_noROMnum
		PUSH	AX
		CALL	outROMnum
		POP	AX
OUT_noROMnum:
OUT_end:
		RET

outROMnum:
		MOV	AH, 0
		CMP	AX, [romnum]
		JE	outROM_old
		MOV	[romnum], AX
		CALL	RethinkMemMap
outROM_old:
		RET

outCRTCreg:
		MOV	[CRTCregnum], AL
		RET

outCRTCwr:
		MOVZX	BP, [BYTE PTR CRTCregnum]
		AND	BP, 31
		MOV	[BYTE PTR BP+CRTCregs], AL
		RET

out8255a:
		BT	[WORD PTR control8255], 4	; port A output?
		JC	o8255aend
		MOV	[port8255a], AL
		MOV	sFree, [WORD PTR port8255c]
		SHR	sFree, 6
		AND	sFree, 3
		CMP	sFree, 3
		JE	latchpsg
		CMP	sFree, 2
		JE	writepsg
o8255aend:
		RET

out8255b:
		MOV	[port8255b], AL
		RET

out8255c:
		PUSH	DX
		PUSH	AX
		XOR	DL, DL
		BT	[WORD PTR control8255], 0
		JC	o8255clin
		OR	DL, 15
o8255clin:
		BT	[WORD PTR control8255], 3
		JC	o8255chin
		OR	DL, 240
o8255chin:
		OR	[port8255c], DL
		XOR	[port8255c], DL
		AND	AL, DL
		OR	[port8255c], AL
		MOV	BP, DX

;		MOV	AH, AL
;		SHR	AH, 4
;		AND	AH, 2
;		CLI
;		MOV	DX, 61h
;		IN	AL, DX
;		OR	AL, AH
;		AND	AL, 0fch
;		OUT	DX, AL
;		STI

		POP	AX
		POP	DX

		AND	BP, 0C0h
		JZ	inactivepsg
		MOV	sFree, AX
		SHR	sFree, 6
		AND	sFree, 3
		CMP	sFree, 3
		JE	latchpsg
		CMP	sFree, 2
		JE	writepsg

inactivepsg:
		RET

out8255control:
		BT	AX, 7
		JNC	out8255control_SF
		MOV	[control8255], AL
		push	ax
		mov	[port8255a], 0
		mov	[port8255b], 0
		mov	al, [port8255c]
		and	al, 30h
		mov	[port8255c], al
		pop	ax
		RET
out8255control_SF:
		BT	AX, 0
		JC	o8255cSFset
		PUSH	AX
		SHR	AL, 1
		AND	AX, 7
		XOR	BP, BP
		TEST	AX, 4				; check whether that half is
		JZ	o8255cSFcBPok			; in output mode
		MOV	BP, 3
o8255cSFcBPok:
		BT	[WORD PTR control8255], BP
		JC	o8255cSFnores
		BTR	[WORD PTR port8255c], AX
		MOV	AL, [port8255c]
		CALL	out8255c
o8255cSFnores:
		POP	AX
		RET
o8255cSFset:
		PUSH	AX
		SHR	AL, 1
		AND	AX, 7
		XOR	BP, BP
		TEST	AX, 4				; check whether that half is
		JZ	o8255cSFsBPok			; in output mode
		MOV	BP, 3
o8255cSFsBPok:						; don't you love cryptic identifiers?
		BT	[WORD PTR control8255], BP
		JC	o8255cSFnoset
		BTS	[WORD PTR port8255c], AX
		MOV	AL, [port8255c]
		CALL	out8255c
o8255cSFnoset:
		POP	AX
		RET

writepsg:
		MOV	AL, [port8255a]
		MOV	BP, [WORD PTR psgregnum]
;		AND	BP, 00Fh
		cmp	bp, 15
		jg	wpsg_exit
		MOV	[BP+OFFSET psgregs], AL
;		MOV	[BYTE PTR BP+OFFSET psgregmod], 255
wpsg_exit:
		CALL	DoSound
		RET

latchpsg:
		MOV	AL, [port8255a]
;		AND	AL, 15
		MOV	[psgregnum], AL
		RET

outga:		MOV	BP, AX
		SHR	BP, 6
		AND	BP, 3
		AND	AL, 3Fh
		CMP	[BYTE PTR BP+rgsgarr], AL
		JE	outga_end
		MOV	[BYTE PTR BP+rgsgarr], AL
		CMP	BP, 2
		JNE	outga1
		CMP	AL, [memstate]
		JE	outga_end
		MOV	[memstate], AL
		AND	[memstate], 0EFh
		AND	AL, 10h
		JZ	outga_nocli
		CALL	ClearInterruptCounter
outga_nocli:
		CALL	RethinkMemMap
		InitPCSeg
		CALL	RethinkMode
		JMP	outga_end
outga1:		CMP	BP, 1
		JE	ga_setcol
		CMP	BP, 0
		JE	outga_colreg
		CMP	BP, 3
		JE	RethinkRamState
		JMP	outga_end
outga_colreg:
		MOV	[BYTE PTR rgsgarr+1], 255
outga_end:
		RET

ga_setcol:
		PUSH	AX
		PUSH	EBX
		PUSH	DX
		MOV	AL, [BYTE PTR rgsgarr]
		CMP	AL, 16
		JNC	ga_sc_border
		AND	EAX, 1Fh		 	; *?*
		MOV	BL, [BYTE PTR (rgsgarr+1)]
		AND	BX, 01Fh
		CMP	[EAX+garrcols], BL
		JE	ga_sc_end
		MOV	[EAX+garrcols], BL
		MOV	[needmodetab], 1
ga_sc_end:
		POP	DX
		POP	EBX
		POP	AX
		RET
ga_sc_border:
		AND	EAX, 0ffh
		CMP	AL, 16
		JNE	ga_sc_end
		MOV	BL, [BYTE PTR (rgsgarr+1)]
		AND	BX, 01Fh
		CMP	[EAX+garrcols], BL
		JE	ga_sc_end
		MOV	[EAX+garrcols], BL
		MOV	[newborcol], BX
		INC	[borchanges]
		CMP	[smallvesa], 0
		JNE	ga_sc_end
		MOV	AL, [garrcols+16]
		add	al, 16
		MOV	AH, AL
		MOV	[WORD PTR modetab+2048], AX
		MOV	[WORD PTR modetab+2050], AX
		MOV	[WORD PTR modetab+2052], AX
		MOV	[WORD PTR modetab+2054], AX
		JMP	ga_sc_end

; ________________________________________________________________________

; set_colours	programs the video DACs with the CPC colour palette

set_colours:
		pushad
		mov	bx, 16				; start w/ colour 0
		mov	si, offset ColorTab
		cmp	[colmode], 0			; green monitor?
		je	sc_loop
		mov	si, offset ColorTabA
sc_loop:
		mov	eax, [si]			; get RGB values
		add	si, 4
		mov	cx, ax				; cl = B, ch = G
		rol	eax, 16
		mov	dh, al				; dh = R
		mov	ax, 1010h			; set indiv. DAC reg
		int	10h
		inc	bx
		cmp	bx, 16 + 32			; done all 32 colours?
		jne	sc_loop
		popad
		ret

; ________________________________________________________________________

set_border:
		push	ax
		push	bx
		mov	bh, [byte ptr bordercol]
		add	bh, 16
		mov	ax, 1001h			; set border colour
		int	10h
		pop	bx
		pop	ax
		ret

; ________________________________________________________________________

GenModeTab:
		mov	ax, ds
		mov	es, ax
		MOV	[needmodetab], 0
		MOV	SI, OFFSET mode0tab
		CMP	[videomode], 0
		JE	GMT_OK
		MOV	SI, OFFSET mode1tab
		CMP	[videomode], 1
		JE	GMT_OK
		MOV	SI, OFFSET mode2tab
GMT_OK:
		MOV	CX, 1024
		MOV	DI, OFFSET modetab
		MOV	BX, OFFSET garrcols
		CMP	[usevesa], 0
		JE	GMT_Loop
		CMP	[smallvesa], 0
		JNE	GMT_Loop
		ADD	CX, CX
GMT_Loop:
		LODSB
		XLATB
		add	al, 16				; VGA register shift
		STOSB
		LOOP	GMT_Loop

		MOV	AL, [garrcols+16]
		add	al, 16				; VGA register shift
		MOV	AH, AL
		MOV	[DI], AX
		MOV	[DI+2], AX
		MOV	[DI+4], AX
		MOV	[DI+6], AX
		RET

; ________________________________________________________________________

GenModeTabs:
		CMP	[usevesa], 0
		JE	GMTB_NoVesa
		CMP	[smallvesa], 0
		JNE	GMTB_NoVesa
GMTV2:
		pushad
		MOV	AX, 0
		MOV	DI, OFFSET mode2tab
GMTV2_Loop:
		MOV	CX, 8
		XOR	DX, DX				; DL = 0: no shift, 1: one set left
		CMP	AX, 0BCh			;  2: one clr left
		JNE	GMTV2_InnerLoop
		NOP
GMTV2_InnerLoop:
		XOR	DX, DX
		ROL	AL, 1
		RCL	DX, 1
		MOV	[DI], DL
		INC	DI
		LOOP	GMTV2_InnerLoop
		INC	AL
		JNE	GMTV2_Loop
GMTV0:
		MOV	SI, OFFSET garrcols
		MOV	AX, 0
		MOV	DI, OFFSET mode0tab
GMTV0_Loop:
		MOV	AH, AL
		XOR	BX, BX
		ROL	AL, 7
		RCL	BL, 1
		ROL	AL, 4
		RCL	BL, 1
		ROL	AL, 2
		RCL	BL, 1
		ROL	AL, 4
		RCL	BL, 1
		MOV	BH, BL
		MOV	[DI], BX
		MOV	[DI+2], BX
		ADD	DI, 4

		XOR	BX, BX
		ROL	AL, 7
		RCL	BL, 1
		ROL	AL, 4
		RCL	BL, 1
		ROL	AL, 2
		RCL	BL, 1
		ROL	AL, 4
		RCL	BL, 1
		MOV	BH, BL
		MOV	[DI], BX
		MOV	[DI+2], BX
		ADD	DI, 4
		MOV	AL, AH
		INC	AL
		JNE	GMTV0_Loop
GMTV1:
		MOV	SI, OFFSET garrcols
		MOV	AX, 0
		MOV	DI, OFFSET mode1tab
GMTV1_Loop:
		MOV	DX, AX
GMTV1_InnerLoop:
		XOR	BX, BX
		ROL	AL, 5
		RCL	BL, 1
		ROL	AL, 4
		RCL	BL, 1
		MOV	BH, BL
		MOV	[DI], BX

		XOR	BX, BX
		ROL	AL, 5
		RCL	BL, 1
		ROL	AL, 4
		RCL	BL, 1
		MOV	BH, BL
		MOV	[DI+2], BX

		XOR	BX, BX
		ROL	AL, 5
		RCL	BL, 1
		ROL	AL, 4
		RCL	BL, 1
		MOV	BH, BL
		MOV	[DI+4], BX

		XOR	BX, BX
		ROL	AL, 5
		RCL	BL, 1
		ROL	AL, 4
		RCL	BL, 1
		MOV	BH, BL
		MOV	[DI+6], BX

		ADD	DI, 8

		MOV	AX, DX
		INC	AL
		JNE	GMTV1_Loop
		popad
		RET
GMTB_NoVesa:
GMT2:		pushad

		MOV	AX, 0
		MOV	DI, OFFSET mode2tab
GMT2_Loop:
		MOV	CX, 4
		XOR	DX, DX				; DL = 0: no shift, 1: one set left
		CMP	AX, 0BCh			;  2: one clr left
		JNE	GMT2_InnerLoop
		NOP
GMT2_InnerLoop:
		ROL	AL, 2
		MOV	SI, AX
		AND	SI, 3
		CMP	SI, 3
		JE	GMT2_11
		CMP	SI, 0
		JE	GMT2_00
		CMP	SI, 2
		JE	GMT2_10
		JMP	GMT2_01
GMT2_11:
;		MOV	DL, 0
		JMP	GMT2_Set

GMT2_00:
;		MOV	DL, 0
		JMP	GMT2_Clr
GMT2_01:
		CMP	DL, 0				; pattern 01
		JNE	GMT2_01_DLnot0
		CMP	DH, 1
		JNE	GMT2_01_normal
		MOV	DL, 2
		JMP	GMT2_Clr			; 1101 -> 1100, 1 clr left
GMT2_01_Normal:
		MOV	DL, 1				; 0001 -> 0011 , 1 set left
		JMP	GMT2_Set
GMT2_01_DLnot0:
		CMP	DL, 1
		JNE	GMT2_01_DL2
		MOV	DL, 2
		JMP	GMT2_Clr			; 0101 -> 1100 , 1 clr left
GMT2_01_DL2:
		MOV	DL, 1				; 1001 -> 0011 , 1 set left
		JMP	GMT2_Set
GMT2_10:						; pattern 10
		CMP	DL, 0
		JNE	GMT2_10_DLnot0
		CMP	DH, 2
		JNE	GMT2_10_Normal
		MOV	DL, 1
		JMP	GMT2_Set			; 0010 -> 0011, 1 set left
GMT2_10_Normal:
		MOV	DL, 2				; 1110 -> 1100, 1 clr left
		JMP	GMT2_Clr
GMT2_10_DLnot0:
		CMP	DL, 1
		JNE	GMT2_10_DL2
		MOV	DL, 2
		JMP	GMT2_Clr			; 0110 -> 1100, 1 clr left
GMT2_10_DL2:
		MOV	DL, 1
		JMP	GMT2_Set			; 1010 -> 0011, 1 set left
GMT2_Clr:
		MOV	[BYTE PTR DI], 0
		MOV	DH, 2
		JMP	GMT2_OK
GMT2_Set:
		MOV	[BYTE PTR DI], 1
		MOV	DH, 1
GMT2_OK:
		INC	DI
		LOOP	GMT2_InnerLoop
		INC	AL
		JNE	GMT2_Loop

GMT0:
		MOV	SI, OFFSET garrcols
		MOV	AX, 0
		MOV	DI, OFFSET mode0tab
GMT0_Loop:
		MOV	AH, AL
		XOR	BX, BX
		ROL	AL, 7
		RCL	BL, 1
		ROL	AL, 4
		RCL	BL, 1
		ROL	AL, 2
		RCL	BL, 1
		ROL	AL, 4
		RCL	BL, 1
;		MOV	BL, [SI+BX]
		MOV	BH, BL
		MOV	[DI], BX
		ADD	DI, 2

		XOR	BX, BX
		ROL	AL, 7
		RCL	BL, 1
		ROL	AL, 4
		RCL	BL, 1
		ROL	AL, 2
		RCL	BL, 1
		ROL	AL, 4
		RCL	BL, 1
;		MOV	BL, [SI+BX]
		MOV	BH, BL
		MOV	[DI], BX
		ADD	DI, 2
		MOV	AL, AH
		INC	AL
		JNE	GMT0_Loop

GMT1:
		MOV	SI, OFFSET garrcols
		MOV	AX, 0
		MOV	DI, OFFSET mode1tab
GMT1_Loop:
		MOV	DX, AX
GMT1_InnerLoop:
		XOR	BX, BX
		ROL	AL, 5
		RCL	BL, 1
		ROL	AL, 4
		RCL	BL, 1
		MOV	[DI], BL

		XOR	BX, BX
		ROL	AL, 5
		RCL	BL, 1
		ROL	AL, 4
		RCL	BL, 1
		MOV	[DI+1], BL

		XOR	BX, BX
		ROL	AL, 5
		RCL	BL, 1
		ROL	AL, 4
		RCL	BL, 1
		MOV	[DI+2], BL

		XOR	BX, BX
		ROL	AL, 5
		RCL	BL, 1
		ROL	AL, 4
		RCL	BL, 1
		MOV	[DI+3], BL

		ADD	DI, 4

		MOV	AX, DX
		INC	AL
		JNE	GMT1_Loop
		popad
		RET

; ________________________________________________________________________

SetPCsCRTC:
		pushad

		CALL	OpenScr
		MOV	AL, [BYTE PTR CRTCregs+9]
		INC	AL
		MOV	AH, [BYTE PTR CRTCregs+6]
		MUL	AH
		CMP	[vertoverscn], 0
		JE	SPCC_HeightL25
		CMP	AX, 201
		JC	SPCC_HeightL25
		MOV	[doublelinmode], 0
		MOV	AL, [BYTE PTR CRTCregs+1]
		CMP	AL, 41
		JNC	SPCC_WidthL40
		MOV	[pcrtcscrwidth], AL
		JMP	SPCC_ScrOpen
SPCC_HeightL25:
		MOV	[doublelinmode], 1
SPCC_WidthL40:
		MOV	[pcrtcscrwidth], 40
		JMP	SPCC_ScrOpen
SPCC_ScrOpen:
		CMP	[usevesa], 0
		JNE	SPCC_Vesa

		MOV	AL, [pcrtcscrwidth]
		CMP	AL, 0
		JE	SPCC_WidthOK
		CLI
		MOV	DX, 3d4h
		PUSH	AX
		MOV	AL, 13h
		OUT	DX, AL
		INC	DX
		IN	AL, DX
		POP	AX
		OUT	DX, AL
		STI

		CMP	AL, 50
		JNC	SPCC_WidthOK

		ADD	AL, AL
		DEC	AL
		DEC	DX
		PUSH	AX
		MOV	AL, 1
		CLI
		OUT	DX, AL
		INC	DX
		IN	AL, DX
		POP	AX
		OUT	DX, AL
		STI
SPCC_WidthOK:
		MOV	AX, [doublelinmode]
		CMP	[dlmode], AX
		JE	SPCC_End
		MOV	[dlmode], AX

		CLI					; 400 Zeilen
		MOV	DX, 03d4h
		MOV	AL, 9
		OUT	DX, AL
		INC	DX
		IN	AL, DX
		AND	AL, 70h
		OUT	DX, AL

		MOV	DX, 3D4h
		MOV	AL, 9
		OUT	DX, AL
		INC	DX
		IN	AL, DX
		AND	AL, 07fh
		CMP	[doublelinmode], 0
		JE	SPCC_DLOK
		OR	AL, 80h
SPCC_DLOK:
		OUT	DX, AL
		JMP	SPCC_End

SPCC_Vesa:
		MOV	[pcrtcscrwidth], 50

		CMP	[smallvesa], 0
		JNE	SPCC_End
							; turn on double lines
		CLI
		MOV	DX, 3D4h
		MOV	AL, 9
		OUT	DX, AL
		INC	DX
		IN	AL, DX
		AND	AL, 07fh
		OR	AL, 80h
		OUT	DX, AL

SPCC_End:
		popad
		STI
		RET

; ________________________________________________________________________

inp:		CMP	AH, 0F4h
		JE	inpioA
		CMP	AH, 0F5h
		JE	inpioB_ext
		CMP	AH, 0F6h
		JE	inpioC
		CMP	AH, 0FBh
		JE	inpFB
		RET

inpioA:
		BT	[WORD PTR control8255], 4
		JNC	ipioA_latched
		BT	[WORD PTR port8255c], 7
		JC	ipioA_latched
		jmp	readpsg
ipioA_latched:
		mov	al, [port8255a]
		RET

readpsg:
		CMP	[psgregnum], 14
		JE	readpsgext
		MOVZX   BP, [psgregnum]
		MOV	AL, [BYTE PTR BP+psgregs]
		RET

readpsgext:
		PUSH	BX				; *?*
		MOV	BL, [port8255c]
		AND	BX, 15
		MOV	AL, [BX+KeyMatrix]
		CMP	BL, 9
		JNE	rpex_nojoy0
		MOV	BH, AL
		AND	BH, 12
		JNE	rpex_jhok0
		OR	AL, 12
rpex_jhok0:
		MOV	BH, AL
		AND	BH, 3
		JNE	rpex_jvok0
		OR	AL, 3
rpex_jvok0:
rpex_nojoy0:
		CMP	BL, 6
		JNE	rpex_nojoy1
		MOV	BH, AL
		AND	BH, 12
		JNE	rpex_jhok1
		OR	AL, 12
rpex_jhok1:
		MOV	BH, AL
		AND	BH, 3
		JNE	rpex_jvok1
		OR	AL, 3
rpex_jvok1:
rpex_nojoy1:
		POP	BX
		RET

inpioB_ext:
		BT	[WORD PTR control8255], 1
		jc	inpioB
		mov	al, [port8255b]
		ret

inpioC:
		MOV	AL, [port8255c]
		and	al, 30h
		RET

; ________________________________________________________________________

RethinkMode:
		pushad
		push	es
		MOV	BP, [WORD PTR sysstat]
		AND	BP, 3
		MOV	AL, [MoTable+BP]
		CMP	[videomode], AL
		JE	RTM_End
		MOV	[videomode], AL
		CALL	GenModeTab
RTM_End:
		pop	es
		popad
		RET

; ________________________________________________________________________

OpenScr:
		CMP	[scrtype], 1
		JE	OS_DontReopen
		MOV	[scrtype], 1
		MOV	[dlmode], 1
		CALL	SetMode
		CALL	set_colours
		CALL	set_border
OS_DontReopen:
		RET

; ________________________________________________________________________

SetMode:
		PUSH	ES
		CMP	[usevesa], 0
		JNE	init_screenGM
SMOD_Normal:
		MOV	AX, 13h
		int	10h
		POP	ES
		RET
init_screenGM:
		mov	ax, ds
		mov	es, ax				; data segment into es
		mov	ax, 4f01h			; query VESA mode
		mov	cx, 103h			; 800x600 256 colours
		mov	di, offset vesa_buffer
		int	10h
		cmp	al, 4fh				; function supported?
		jne	isGM_error
		or	ah, ah				; successful?
		jnz	isGM_error

		test	[vesa_modeattr], 1		; is mode supported?
		jz	isGM_error
		test	[vesa_winAattr], 2		; window A readable?
		jz	igm_Anotread
		mov	ax, [vesa_winAstart]
		mov	[vesa_winread], ax		; set read to window A
igm_Anotread:
		test	[vesa_winAattr], 4		; window A writeable?
		jz	igm_Anotwrite
		mov	ax, [vesa_winAstart]
		mov	[vesa_winwrite], ax		; set write to window A
igm_Anotwrite:
		cmp	[vesa_winread], 0		; already set?
		jne	igm_Bnotread
		test	[vesa_winBattr], 2		; window B readable?
		jz	igm_Bnotread
		mov	ax, [vesa_winBstart]
		mov	[vesa_winread], ax		; set read to window B
igm_Bnotread:
		cmp	[vesa_winwrite], 0		; already set?
		jne	igm_foundRWwin
		test	[vesa_winBattr], 4		; window B writeable?
		jz	igm_foundRWwin
		mov	ax, [vesa_winBstart]
		mov	[vesa_winwrite], ax		; set write to window B
igm_foundRWwin:
		mov	ax, 4f02h			; set VESA mode
		mov	bx, 103h			; 800x600 256 colours
		int	10h
		or	ah, ah				; successful?
		jnz	isGM_error

		mov	ax, [vesa_winsizeKB]		; calculate window size
		cwd					;  per granularity..
		div	[vesa_wingranKB]
		mov	[vesa_sizepgran], ax

		cmp	[graphmenu], 0
		je	isGM_textmenus
		mov	[move_scrpos], offset move_scrposGM
		mov	[print_string], offset print_stringGM
isGM_textmenus:
		pop	es
		ret
isGM_error:
		mov	[usevesa], 0
		jmp	SMOD_Normal

; ________________________________________________________________________

inc_vesapage:
		cmp	[usevesa], 0
		je	ivp_done
;		pushad
		push	ax
		push	bx
		push	dx
		mov	bx, 100h			; query window A access
		call	[vesa_winmove]			;  location
		add	dx, [vesa_sizepgran]		; increase by one
		mov	[vesa_page], dx
		mov	bx, 0				; set window A
		call	[vesa_winmove]
;		mov	dx, [vesa_page]
;		mov	bx, 1				; set window B
;		call	[vesa_winmove]
;		popad
		pop	dx
		pop	bx
		pop	ax
ivp_done:
		ret

; ........................................................................

set_vesapage:
		cmp	[usevesa], 0
		je	svp_done
;		pushad
		push	ax
		push	bx
		push	dx
		mov	dx, [vesa_page]
		mov	bx, 0				; set window A
		call	[vesa_winmove]
;		mov	dx, [vesa_page]
;		mov	bx, 1				; set window B
;		call	[vesa_winmove]
;		popad
		pop	dx
		pop	bx
		pop	ax
svp_done:
		ret

; ........................................................................

reset_vesapage:
		cmp	[usevesa], 0
		je	rvp_done
;		pushad
		push	ax
		push	bx
		push	dx
		xor	dx, dx
		mov	[vesa_page], dx
		mov	bx, 0				; set window A
		call	[vesa_winmove]
;		xor	dx, dx
;		mov	bx, 1				; set window B
;		call	[vesa_winmove]
;		popad
		pop	dx
		pop	bx
		pop	ax
rvp_done:
		ret

 ; ******************************************************** RAM banking

InitRAMSegs:
		PUSH	ES
		MOV	[haveEMM], 0
		CMP	[useems], 0
		JE	IRAS_noEMS
		MOV	AX, 3567h
		INT	21h
		CMP	[DWORD PTR ES:10], 'XMME'
		JNE	IRAS_noEMS
		CMP	[DWORD PTR ES:14], '0XXX'
		JNE	IRAS_noEMS
		MOV	AH, 41h
		INT	67h
		CMP	AH, 0
		JNE	IRAS_noEMS
		MOV	[normramseg], BX
		MOV	AH, 46h
		INT	67h
		OR	AH, AH
		JNE	IRAS_noEMS
		CMP	AL, 040h
		JC	IRAS_noEMS
		MOV	AX, 05801h
		INT	67h
		OR	AH, AH
		JNE	IRAS_noEMS
		CMP	CX, 5
		JC	IRAS_noEMS
		CMP	CX, 500
		JNC	IRAS_noEMS	; panic!

		MOV	AX, 5800h
		MOV	DI, SEG TapeBuffer
		MOV	ES, DI
		MOV	DI, OFFSET TapeBuffer
		INT	67h
		OR	AH, AH
		JNE	IRAS_noEMS
		XOR	AX, AX
		MOV	[emsscrmem], AX
		MOV	BX, [normramseg]
		MOV	SI, OFFSET TapeBuffer
IRAS_EMSCheckL:
		LODSW
		MOV	DI, AX
		LODSW
		CMP	DI, BX
		JNE	IRAS_EMSCL_NotPF
		CMP	AX, 0				; just a safety check
		JNE	IRAS_noEMS
IRAS_EMSCL_NotPF:
		CMP	[emsscrmem], 0
		JNE	IRAS_EMSCL_Not4
		CMP	AX, 4
		JC	IRAS_EMSCL_Not4
		MOV	DX, SEG hiram
		CMP	DI, DX
		JC	IRAS_EMSCL_Not4
		ADD	DX, 0C00h
		CMP	DI, DX
		JNC	IRAS_EMSCL_Not4

		MOV	[emsscrmem], DI
		MOV	[emsscrpage], AX

		INC	AX				; now, see if we can have two pages
		CMP	[SI+2], AX
		JNE	IRAS_FoundOne_ButHalfBad
		XOR	AX, AX
		SUB	DX, 0400h
		CMP	DI, DX
		JNC	IRAS_FoundOne_ButHalfBad
		CMP	CX, 1
		JE	IRAS_FoundOne_ButHalfBad

		MOV	AX, 0C00h
IRAS_FoundOne_ButHalfBad:
		MOV	[crtc32mask], AX

		JMP	IRAS_OK
IRAS_EMSCL_Not4:
		LOOP	IRAS_EMSCheckL
		CMP	[emsscrmem], 0
		JE	IRAS_noEMS
IRAS_OK:
		MOV	AX, 4E03h
		INT	67h
		OR	AH, AH
		JNE	IRAS_noEMS
		MOV	AX, 4E00h
		MOV	DI, OFFSET pgtable
		PUSH	DS
		POP	ES
		INT	67h
		OR	AH, AH
		JNE	IRAS_noEMS
		MOV	AH, 43h
		MOV	BX, 8
		INT	67h
		CMP	AH, 0
		JNE	IRAS_noEMS
		MOV	[haveEMM], 1
		MOV	[emmha], DX
		MOV	BX, 0
		MOV	AX, 4400h
		PUSH	DX
		INT	67h
		POP	DX
		MOV	BX, 1
		MOV	AX, 4401h
		PUSH	DX
		INT	67h
		POP	DX
		MOV	BX, 2
		MOV	AX, 4402h
		PUSH	DX
		INT	67h
		POP	DX
		MOV	BX, 3
		MOV	AX, 4403h
		PUSH	DX
		INT	67h
		POP	DX
		MOV	BX, 3
		MOV	AX, [emsscrpage]
		MOV	AH, 044h
		INT	67h
		MOV	[mappedscr], 3
		JMP	IRAS_End
IRAS_noEMS:
		MOV	[crtc32mask], 0
		MOV	[normramseg], SEG rambase
		MOV	DX, OFFSET emsfail
		CALL	print
IRAS_End:
		POP	ES
		RET

; ________________________________________________________________________

CleanupEMM:
		CMP	[haveEMM], 0
		JE	CEMM_Ret
		MOV	AH, 45h
		MOV	DX, [emmha]
		INT	67h
		PUSH	ES
		MOV	AX, 4E01h
		MOV	SI, OFFSET pgtable
		PUSH	DS
		POP	ES
		INT	67h
		POP	ES
CEMM_Ret:
		RET

; ________________________________________________________________________

ResetRAMState:
		PUSH	EAX
		MOV	EAX, [DWORD PTR ramstatetab]
		MOV	[DWORD PTR ramstate], EAX
		MOV	EAX, [DWORD PTR ramstatetab+4]
		MOV	[DWORD PTR ramstate+4], EAX
		POP	EAX
		RET

; ________________________________________________________________________

RethinkRamState:
		CMP	[haveEMM], 0
		JNE	RTRS_EMM
		PUSHAD
		PUSH	ES

		MOV	AL, [BYTE PTR sysstat+1]
		AND	AX, 7
		MOV	[BYTE PTR sysstat+1], AL
		ADD	AX, AX
		ADD	AX, AX
		ADD	AX, AX
		MOV	SI, AX
		ADD	SI, OFFSET ramstatetab
		MOV	DI, OFFSET ramstate
		MOV	CX, 8
RTRS_Loop:
		LODSB
		CMP	AL, [DI]
		JE	RTRS_Equal
		MOV	AH, [DI]
		CALL	ExBanks
RTRS_Equal:
		INC	DI
		LOOP	RTRS_Loop
		CALL	GetScrBankPt
		POP	ES
		POPAD
		RET
RTRS_EMM:
		pushad
		MOV	[doingems], 1
		MOV	AL, [BYTE PTR sysstat+1]
		AND	AX, 7
		MOV	[BYTE PTR sysstat+1], AL
		ADD	AX, AX
		ADD	AX, AX
		ADD	AX, AX
		MOV	SI, AX
		ADD	SI, OFFSET ramstatetab
		MOV	DI, OFFSET ramstate
		PUSH	DI
		XOR	BH, BH
		MOV	BL, [SI]
		MOV	AX, 4400h
		MOV	DX, [emmha]
		PUSH	SI
		INT	67h
		POP	SI

		XOR	BH, BH
		MOV	BL, [SI+1]
		MOV	AX, 4401h
		MOV	DX, [emmha]
		PUSH	SI
		INT	67h
		POP	SI

		XOR	BH, BH
		MOV	BL, [SI+2]
		MOV	AX, 4402h
		MOV	DX, [emmha]
		PUSH	SI
		INT	67h
		POP	SI

		XOR	BH, BH
		MOV	BL, [SI+3]
		MOV	AX, 4403h
		MOV	DX, [emmha]
		PUSH	SI
		INT	67h
		POP	SI

		POP	DI
		LODSD
		MOV	[DS:DI], EAX
		LODSD
		MOV	[DS:DI+4], EAX
		XOR	EAX, EAX
		popad
		MOV	[doingems], 0
		RET

; ________________________________________________________________________

ExBanks:						; IN: AL = Bank1, AH = Bank2 / corrects RamState
		PUSH	SI
		PUSH	DI
		PUSH	CX
		CALL	GetBankAddr
		XCHG	AL, AH
		PUSH	ES
		POP	FS
		MOV	SI, DI
		CALL	GetBankAddr
		MOV	CX, 1000h
		PUSH	EAX
		PUSH	DX
		MOV	DX, 4
EXBA_ExLoop:
		MOV	EAX, [ES:DI]
		XCHG	EAX, [FS:SI]
		STOSD
		ADD	SI, DX
		LOOP	EXBA_ExLoop
		POP	DX
		POP	EAX
		MOV	CX, 8
		MOV	SI, OFFSET ramstate
EXBA_Correct:
		CMP	[SI], AL
		JNE	EXBA_NotAL
		MOV	[SI], AH
		JMP	EXBA_CorrectL
EXBA_NotAL:
		CMP	[SI], AH
		JNE	EXBA_CorrectL
		MOV	[SI], AL
EXBA_CorrectL:
		INC	SI
		LOOP	EXBA_Correct
		POP	CX
		POP	DI
		POP	SI
		RET

; ________________________________________________________________________

GetScrBankPt:
		CMP	[haveEMM], 0
		JE	GSBP_noEMS
		MOV	AX, [crtc32state]
		CMP	[map32state], AX
		JNE	GSBP_NeedMapping

		MOV	AX, [scrbase]
		SHR	AX, 14
		CMP	AX, [mappedscr]

		JE	GSBP_MappingOK
GSBP_NeedMapping:
		pushad
		MOV	BX, [scrbase]
		SHR	BX, 14
		MOV	[mappedscr], BX
		MOV	AX, [emsscrpage]
		MOV	AH, 044h
		MOV	DX, [emmha]
		INT	67h

		MOV	AX, [crtc32state]
		MOV	[map32state], AX
		CMP	AX, 0C00h
		JNE	GSBP_No32Scr
		MOV	BX, [mappedscr]
		INC	BX
		AND	BX, 3
		MOV	AX, [emsscrpage]
		INC	AL
		MOV	AH, 044h
		MOV	DX, [emmha]
		INT	67h
GSBP_No32Scr:

		popad
GSBP_MappingOK:
		MOV	AX, [emsscrmem]
		MOV	[WORD PTR scrbankpt+2], AX
		XOR	AX, AX
		MOV	[WORD PTR scrbankpt], AX
		RET
GSBP_noEMS:
		MOV	AX, [scrbase]
		SHR	AX, 14
		CALL	GetBankAddr
		MOV	[WORD PTR scrbankpt], DI
		MOV	[WORD PTR scrbankpt+2], ES
		RET

; ________________________________________________________________________

GetBankAddr:						; IN: AL = Bank / OUT: ES:DI Bankaddr
		PUSH	DS
		POP	ES
		PUSH	CX
		MOV	DI, OFFSET ramstate
		MOV	CX, 8
		REPNE	SCASB
		SUB	DI, OFFSET ramstate+1
		CMP	DI, 4
		JC	GBAD_Lo
		AND	DI, 3
		ROR	DI, 2
		PUSH	SEG hiram
		POP	ES
		JMP	GBAD_End
GBAD_Lo:
		ROR	DI, 2
		PUSH	SEG rambase
		POP	ES
GBAD_End:
		POP	CX
		RET

; ________________________________________________________________________

RethinkMemMap:
		MOV	BP, [normramseg]
		BT	[sysstat], 2
		JC	RMM_LOK
		MOV	BP, SEG amsdos
RMM_LOK:
		MOV	[memmap], BP
RMM_TestUpper:
		MOV	BP, [normramseg]
		MOV	[memmap+2], BP
		MOV	[memmap+4], BP

		BT	[sysstat], 3
		JC	RMM_UOK

		CMP	[haver5], 0
		JE	RMM_No5
		CMP	[romnum], 5
		JNE	RMM_No5
		MOV	BP, SEG rom5
		SUB	BP, 0C00h
		JMP	RMM_UOK
RMM_No5:

		CMP	[haver6], 0
		JE	RMM_No6
		CMP	[romnum], 6
		JNE	RMM_No6
		MOV	BP, SEG rom6
		SUB	BP, 0C00h
		JMP	RMM_UOK
RMM_No6:

		CMP	[haver7], 0
		JE	RMM_No7
		CMP	[romnum], 7
		JNE	RMM_No7
		MOV	BP, SEG rom7
		SUB	BP, 0C00h
		JMP	RMM_UOK
RMM_No7:

		MOV	BP, SEG basic
		SUB	BP, 0C00h
RMM_UOK:
		MOV	[memmap+6], BP

		RET

; ________________________________________________________________________

LoadSnap:
		PUSHAD
		call	restore_snapshot
		cmp	[byte ptr rsnap_name+2], 0	; selector was aborted?
		je	LOSN_End

		MOV	DX, OFFSET rsnap_name
		MOV	AX, 3d00h			; open file
		INT	21h
		JC	LOSN_End
		MOV	[rsnap_handle], AX

		MOV	BX, AX
		MOV	AH, 3fh				; read from file
		MOV	CX, 256
		MOV	DX, OFFSET SnapBuffer
		INT	21h
		JC	LOSN_Close
		CMP	[DWORD PTR SnapBuffer+4], 'ANS '
		JNE	LOSN_Close			; valid snapshot file?
		CMP	[DWORD PTR SnapBuffer], '- VM'
		JNE	LOSN_Close
		CMP	[BYTE PTR SnapBuffer+10h], 1	; snapshot version (1/2)?
		JE	LOSN_Ver1
		CMP	[BYTE PTR SnapBuffer+10h], 2
		JE	LOSN_Ver2
		JMP	LOSN_Close
LOSN_Ver2:

LOSN_Ver1:
;		CALL	reset
		POPAD					; restore Z80 registers
;		call	z80_reset

		MOV	AX, [SnapBuffer+11h]		; AF
		ROL	AX, 8
		MOV	sBC, [SnapBuffer+13h]		; BC
		MOV	sDE, [SnapBuffer+15h]		; DE
		MOV	nsHL, [SnapBuffer+17h]		; HL
		MOV	sPC, [SnapBuffer+23h]		; PC
		PUSHAD

		MOV	AL, [BYTE PTR SnapBuffer+19h]	; R
		MOV	[BYTE PTR srF], AL
		AND	AL, 80h
		MOV	[BYTE PTR srFhi], AL
		MOV	AL, [BYTE PTR SnapBuffer+1Ah]	; I
		MOV	[BYTE PTR srI], AL
		MOV	AL, [BYTE PTR SnapBuffer+1Bh]	; IFF0
		MOV	[sIFF1], AL
		MOV	AL, [BYTE PTR SnapBuffer+1Ch]	; IFF1
		MOV	[sIFF2], AL
		MOV	AX, [SnapBuffer+1Dh]		; IX
		MOV	[ix], AX
		MOV	AX, [SnapBuffer+1Fh]		; IY
		MOV	[iy], AX
		MOV	AX, [SnapBuffer+21h]		; SP
		MOV	[simstack], AX
		MOVZX   AX, [BYTE PTR SnapBuffer+25h]	; interrupt mode IMD
		MOV	[imode], AX
		MOV	AX, [SnapBuffer+26h]		; AF'
		ROL	AX, 8
		MOV	[sAFx], AX
		MOV	AX, [SnapBuffer+28h]		; BC'
		MOV	[sBCx], AX
		MOV	AX, [SnapBuffer+2Ah]		; DE'
		MOV	[sDEx], AX
		MOV	AX, [SnapBuffer+2Ch]		; HL'
		MOV	[sHLx], AX

		mov	ebx, 0
LOSN_SetCols:
		MOV	AL, [BYTE PTR EBX+SnapBuffer+2Fh]
		MOV	[BYTE PTR rgsgarr], BL		; ink number
		MOV	[BYTE PTR rgsgarr+1], AL	; ink value
		CALL	ga_setcol
		INC	BX
		CMP	BX, 17
		JNE	LOSN_SetCols
		MOV	AL, [BYTE PTR SnapBuffer+2eh]	; ink number register
		MOV	[BYTE PTR rgsgarr], AL
		MOV	AL, [BYTE PTR SnapBuffer+40h]	; multi-config register
		MOV	[BYTE PTR rgsgarr+2], AL
		MOV	AL, [BYTE PTR SnapBuffer+41h]	; RAM configuration
		MOV	[BYTE PTR rgsgarr+3], AL

		MOV	AL, [BYTE PTR SnapBuffer+42h]	; CRTC address register
		MOV	[CRTCregnum], AL
		PUSH	ES
		PUSH	DS
		POP	ES
		MOV	SI, OFFSET SnapBuffer+43h	; CRTC data registers
		MOV	DI, OFFSET CRTCregs
		MOV	CX, 9
		REP	MOVSW

		MOV	AL, [BYTE PTR SnapBuffer+55h]	; upper ROM number
		MOV	[BYTE PTR romnum], AL
		MOV	AL, [BYTE PTR SnapBuffer+56h]	; PIO port A
		MOV	[port8255a], AL
		MOV	AL, [BYTE PTR SnapBuffer+57h]	; PIO port B
		MOV	[port8255b], AL
		MOV	AL, [BYTE PTR SnapBuffer+58h]	; PIO port C
		MOV	[port8255c], AL
		MOV	AL, [BYTE PTR SnapBuffer+59h]	; PIO control port
		MOV	[control8255], AL
		MOV	AL, [BYTE PTR SnapBuffer+5Ah]	; PSG address register
		MOV	[psgregnum], AL
		MOV	SI, OFFSET SnapBuffer+5Bh	; PSG data registers
		MOV	DI, OFFSET PSGregs
		MOV	CX, 8
		REP	MOVSW
		POP	ES

		MOV	BX, [rsnap_handle]
		PUSH	DS
		PUSH	[normramseg]
		POP	DS
		MOV	DX, 0
		MOV	CX, 32768
		MOV	AH, 3fh				; read from file
		INT	21h
		ADD	DX, CX
		MOV	AH, 3fh				; read from file
		INT	21h
		POP	DS

		mov	bp, 13				; set up PSG..
LOSN_SetPSG:
		call	DoSound
		dec	bp
		jns	LOSN_SetPSG

		CALL	RethinkMemMap
		CALL	RethinkRamState
		POPAD
		InitPCSeg
		PUSHAD
		CALL	RethinkCRTC
		CALL	RethinkMode
;		CALL	GenModeTab
;		MOV	[scrtype], 0ffffh
		MOV	[intflag], 0
LOSN_Close:
		MOV	BX, [rsnap_handle]
		MOV	AH, 3Eh				; close file
		INT	21h
		MOV	[rsnap_handle], 0ffffh
LOSN_End:
		POPAD
		jmp	[sound_continue]

; ________________________________________________________________________

SaveSnap:
		PUSHAD
		call	store_snapshot
		cmp	[byte ptr ssnap_name+2], 0	; selector was aborted?
		je	SASN_End

		MOV	DX, OFFSET ssnap_name
		MOV	AX, 3c00h			; create file
		XOR	CX, CX
		INT	21h
		JC	SASN_End
		MOV	[ssnap_handle], AX

		xor	edx, edx
		mov	dx, offset SnapBuffer
		MOV	[DWORD PTR EDX], '- VM'		; snapshot ID..
		MOV	[DWORD PTR EDX+4], 'ANS '
		MOV	[BYTE PTR EDX+10h], 1		; snapshot version

		POPAD					; restore Z80 registers
		ROL	AX, 8
		MOV	[SnapBuffer+11h], AX		; AF
		ROL	AX, 8
		MOV	[SnapBuffer+13h], sBC		; BC
		MOV	[SnapBuffer+15h], sDE		; DE
		MOV	[SnapBuffer+17h], nsHL		; HL
		PUSHAD

		MOV	AL, [BYTE PTR srF]
		AND	AL, 7fh
		OR	AL, [BYTE PTR srFhi]
		MOV	[BYTE PTR SnapBuffer+19h], AL	; R
		MOV	AL, [BYTE PTR srI]
		MOV	[BYTE PTR SnapBuffer+1Ah], AL	; I

		MOV	AL, [sIFF1]
		MOV	[BYTE PTR SnapBuffer+1Bh], AL	; IFF0
		MOV	AL, [sIFF2]
		MOV	[BYTE PTR SnapBuffer+1Ch], AL	; IFF1
		MOV	AX, [ix]
		MOV	[SnapBuffer+1Dh], AX		; IX
		MOV	AX, [iy]
		MOV	[SnapBuffer+1Fh], AX		; IY
		MOV	AX, [simstack]
		MOV	[SnapBuffer+21h], AX		; SP
		MOV	[SnapBuffer+23h], sPC		; PC
		MOV	AX, [imode]
		MOV	[BYTE PTR SnapBuffer+25h], AL	; interrupt mode IMD
		MOV	AX, [sAFx]
		ROL	AX, 8
		MOV	[SnapBuffer+26h], AX		; AF'
		MOV	AX, [sBCx]
		MOV	[SnapBuffer+28h], AX		; BC'
		MOV	AX, [sDEx]
		MOV	[SnapBuffer+2Ah], AX		; DE'
		MOV	AX, [sHLx]
		MOV	[SnapBuffer+2Ch], AX		; HL'

		mov	ebx, 0
SASN_SetCols:
		MOV	AL, [BYTE PTR EBX+garrcols]	; ink value
		MOV	[BYTE PTR EBX+SnapBuffer+02Fh], AL
		INC	BX
		CMP	BX, 17
		JNE	SASN_SetCols
		MOV	AL, [BYTE PTR rgsgarr]
		MOV	[BYTE PTR SnapBuffer+2eh], AL	; ink number register
		MOV	AL, [BYTE PTR rgsgarr+2]
		MOV	[BYTE PTR SnapBuffer+40h], AL	; multi-config register
		MOV	AL, [BYTE PTR rgsgarr+3]
		MOV	[BYTE PTR SnapBuffer+41h], AL	; RAM configuration

		MOV	AL, [CRTCregnum]
		MOV	[BYTE PTR SnapBuffer+42h], AL	; CRTC address register
		PUSH	ES
		PUSH	DS
		POP	ES
		MOV	DI, OFFSET SnapBuffer+43h
		MOV	SI, OFFSET CRTCregs
		MOV	CX, 9
		REP	MOVSW				; CRTC data registers

		MOV	AL, [BYTE PTR romnum]
		MOV	[BYTE PTR SnapBuffer+55h], AL	; upper ROM number
		MOV	AL, [port8255a]
		MOV	[BYTE PTR SnapBuffer+56h], AL	; PIO port A
		MOV	AL, [port8255b]
		MOV	[BYTE PTR SnapBuffer+57h], AL	; PIO port B
		MOV	AL, [port8255c]
		MOV	[BYTE PTR SnapBuffer+58h], AL	; PIO port C
		MOV	AL, [control8255]
		MOV	[BYTE PTR SnapBuffer+59h], AL	; PIO control port
		MOV	AL, [psgregnum]
		MOV	[BYTE PTR SnapBuffer+5Ah], AL	; PSG address register
		MOV	DI, OFFSET SnapBuffer+5Bh
		MOV	SI, OFFSET PSGregs
		MOV	CX, 8
		REP	MOVSW				; PSG data registers
		POP	ES

		mov	[byte ptr SnapBuffer+06bh], 64	; memory dump size..
		mov	[byte ptr SnapBuffer+06ch], 0

		MOV	BX, [ssnap_handle]
		MOV	CX, 256
		MOV	DX, OFFSET SnapBuffer
		MOV	AH, 40h				; write to file
		INT	21h

		PUSH	DS
		PUSH	[normramseg]
		POP	DS
		MOV	DX, 0
		MOV	CX, 32768
		MOV	AH, 40h				; write to file
		INT	21h
		ADD	DX, CX
		MOV	AH, 40h				; write to file
		INT	21h
		POP	DS

		MOV	BX, [ssnap_handle]
		MOV	AH, 3Eh				; close file
		INT	21h
		MOV	[ssnap_handle], 0ffffh
SASN_End:
		POPAD
		jmp	[sound_continue]

; ________________________________________________________________________

ENDS

SEGMENT _data PAGE PUBLIC 'DATA'

emsfail		db	'EMS not available', 13, 10, 0

verstr_cpe	db	'CPE v', VER_CPE, ' - The Amstrad CPC Emulator', 13, 10
		db	'  Copyright (c) 1991-96 by Bernd Schmidt', 13, 10
		db	'  portions Copyright (c) 1995-97 by Ulrich Doewich', 13, 10, 13, 10
		db	'AY-3-8912 PSG emulation v', VER_SND, 13, 10
		db	'  Creative Labs SoundBlaster module v', VER_SBSND, 13, 10
		db	'  Ensoniq Soundscape module v', VER_ESSSND, 13, 10
		db	'  Gravis Ultrasound module v', VER_GUSSND, 13, 10, 13, 10
		db	'uPD765A FDC emulation v', VER_FDC, 13, 10, 13, 10
		db	'CPC ROM images', 13, 10
		db	'  Copyright (c) 1984,85 Amstrad and Locomotive Software'
		db	13, 10, 36

menu_layout	db	 0, 4, 1, 15, 'Options', 0
		db	 2, 1, 1,  7, '  Emulate borders ', 1, 8, '(in 800x600 VESA mode)', 0
		db	 3, 1, 1,  7, '  Simulate green monitor', 0
		db	 4, 1, 1,  7, '  PSG sound emulation', 0
		db	 5, 1, 1,  7, '  Utilize PC joystick 1', 0
		db	 6, 1, 1,  7, '  Utilize PC joystick 2', 0
		db	 7, 1, 1,  7, '  Limit speed to 100% ', 1, 8, '(recommended)', 0
		db	 8, 1, 1,  7, '  Permit vertical overscan ', 1, 8, '(keep disabled if not required)', 0
		db	11, 4, 1, 11, ' ', 1, 3, ' Select option', 0
		db	12, 4, 1, 11, 'SPACE', 1, 3, ' Toggle selection', 0
		db	13, 4, 1, 11, 'ESC', 1, 3, ' Return to emulation', 0
		dw	0ffffh

prefname	db	'prefs.cpe', 0

		even
haver5		dw	0
haver6		dw	0
haver7		dw	0
CPCKTb		dw	0

LABEL CPEPrefs WORD
refreshrate	dw	1
usevesa		dw	0
smallvesa	dw	0
graphmenu	dw	0ffffh
cpctype		dw	3
germkey		dw	0
SCinstalled	dw	0ffffh
SCport		dw	220h
SCwport		dw	534h
SCmirq		dw	9
SCirq		dw	5
SCdma		dw	1
DMAblocklen	dw	0f0h
SCsrate		dw	0
stereo_flag	dw	0
useems		dw	0ffffh
lptnum		dw	1
quietcas	dw	0ffffh

LABEL MenuVars WORD
borders		dw	0ffffh
colmode		dw	0
usesound	dw	0
usejoy1		dw	0
usejoy2		dw	0
dowait		dw	0ffffh
vertoverscn	dw	0

MenuItems	dw	7

joy1_x		dd	0
joy1_y		dd	0
joy1_x_old	dd	0
joy1_y_old	dd	0
joy1_x_centre	dd	0
joy1_y_centre	dd	0
joy2_x		dd	0
joy2_y		dd	0
joy2_x_old	dd	0
joy2_y_old	dd	0
joy2_x_centre	dd	0
joy2_y_centre	dd	0
joy_mask	db	0
joy2_prev	db	0

		even
move_scrpos	dw	offset move_scrposTM
print_string	dw	offset print_stringTM

str_length	dw	0
str_pos		dw	0
scr_colour	dw	0
scr_offs	dw	0
scr_bank	dw	0

vesa_winwrite	dw	0a000h
vesa_winread	dw	0
vesa_sizepgran	dw	0
vesa_page	dw	0
vesa_prevpage	dw	0

label vesa_buffer byte
vesa_modeattr	dw	0
vesa_winAattr	db	0
vesa_winBattr	db	0
vesa_wingranKB	dw	0
vesa_winsizeKB	dw	0
vesa_winAstart	dw	0
vesa_winBstart	dw	0
vesa_winmove	dd	0
vesa_bpscanline	dw	0
		db	238 dup (?)

include		"font8x8.asm"

; CPC-Ports
; ************************************************ CRTC 6845

		EVEN
CRTCregnum	db	?, ?				; BCxx
CRTCregs	dw	16 DUP (?)			; BDxx/BFxx 18 regs of video controller

scrbase		dw	0C000h				; extract from CRTC regs 12/13
scroff		dw	0				;  "	 "	"	"	"
pcrtcscrwidth	db	?
crtcscrwidth	db	?				; copy of CRTC reg 1
crtchsync	dw	0
crtcvtotal	dw	?
scrtype		dw	0				; 1, 2: normal/normal 50Hz; 3: extended
doublelinmode	dw	0				; active screen uses double lines
dlmode		dw	0
videomode	db	0				; CPC mode 0, 1, 2 - for fullscr modes only

crtc32mask	dw	0				; for 32K screens
crtc32state	dw	0

scrbankpt	dd	0

; ************************************************ 8255, PSG

		EVEN
port8255a	db	?				; F4
port8255b	db	?				; F5
port8255c	db	?				; F6
control8255	db	?				; F7
psgregnum	db	?, ?
psgregs		dw	128 DUP (?)
psgregmod	dw	128 DUP (?)
channeloff	dw	0
PSGcount	dw	0

; ************************************************ GATE ARRAY

		EVEN
romnum		dw	?				; this is the DFxx port
rgsgarr		dw	?				; 7Fxx 4  regs of gate array
sysstat		dw	?				; 7Fxx this and the last line MUST be kept together
memstate	db	0, 0
ramstate	db	0, 1, 2, 3, 4, 5, 6, 7

ramstatetab	db	0, 1, 2, 3, 4, 5, 6, 7
		db	0, 1, 2, 7, 4, 5, 6, 3
		db	4, 5, 6, 7, 0, 1, 2, 3
		db	0, 3, 2, 7, 4, 5, 6, 1
		db	0, 4, 2, 3, 1, 5, 6, 7
		db	0, 5, 2, 3, 4, 1, 6, 7
		db	0, 6, 2, 3, 4, 5, 1, 7
		db	0, 7, 2, 3, 4, 5, 6, 1

memmap		dw	SEG amsdos, SEG rambase, SEG rambase, SEG rambase

haveEMM		dw	0
normramseg	dw	0
emmha		dw	0
doingems	dw	0

emsscrmem	dw	0
emsscrpage	dw	0
mappedscr	dw	0
map32state	dw	0
emsmalloc	dw	0

needmodetab	dw	0
garrcols	db	20 DUP (?)

MoTable		db	0, 1, 2, 0

modetab		dd	520 DUP (?)

mode0tab	dd	520 DUP (?)
mode1tab	dd	520 DUP (?)
mode2tab	dd	520 DUP (?)

bordercol	dw	0
newborcol	dw	0
borchanges	dw	0

 ; ************************************************ Interrupts

		EVEN
intreq		dw	?
ffly		dw	?

 ; ************************************************ cleanup area

oldintadd	dw	0				; 86 interrupt torture
oldintseg	dw	0
oldnoiadd	dw	0
oldnoiseg	dw	0
timercount	dw	0
timerval	dw	0f84h				; 300Hz
pcffcount	dw	0
OldVideo	dw	3

ffly_dec_std	dw	2
ffly_dec	dw	0

intcount	dw	0

pgtable		dw	256 DUP (?)			; hopefully large enough
SnapBuffer	dw	128 DUP (?)

ENDS

; ________________________________________________________________________

SEGMENT _stack PARA STACK 'STACK'

;TapeBuffer	dw	800h DUP (?)
;TapeLoadBuf	dw	800h DUP (?)

stck		dw	1000 dup (?)
stckend		dw	?

ENDS

; ________________________________________________________________________

SEGMENT SEGRAM PRIVATE PARA USE32
rambase		db	65536 DUP (?)
ENDS

SEGMENT SEGLOROM PRIVATE PARA
amsdos		db	16386 DUP (?)
ENDS

SEGMENT SEGBASIC PRIVATE PARA
basic		db	16386 DUP (?)
ENDS

SEGMENT SEGROM5 PRIVATE PARA
rom5		db	16386 DUP (?)
ENDS

SEGMENT SEGROM6 PRIVATE PARA
rom6		db	16386 DUP (?)
ENDS

SEGMENT SEGROM7 PRIVATE PARA
rom7		db	16386 DUP (?)
ENDS

SEGMENT SEGHIRAM PRIVATE PARA USE32
hiram		db	65536 DUP (?)
ENDS

END start
