; CPE - The Amstrad CPC Emulator
; miscellaneous routines
; Copyright (c) 1991-96 by Bernd Schmidt
; modifications Copyright (c) 1995-97 by Ulrich Doewich

;	Mar. 22, 1997 - 14:39	recoded keyboard interrupt handler and SetLEDs
;	Mar. 23, 1997 - 00:13	implemented new options menu

ideal
p386

INCLUDE		"macros.inc"

ESC_KEY		equ	01h
TOGGLE_KEY	equ	39h
UP_KEY		equ	48h
DOWN_KEY	equ	50h

; from ipe1.asm
extrn		init_joystick:PROC
EXTRN		OpenTextScr:PROC, RestoreScreen:PROC, set_colours:PROC
extrn		move_scrpos:WORD, print_string:WORD, scr_colour:WORD
EXTRN		menu_layout:BYTE, MenuVars:WORD, MenuItems:WORD
EXTRN		cleanup:PROC, haver5:WORD, haver6:WORD, haver7:WORD
EXTRN		quietcas:WORD, cpctype:WORD, CPCKTb:WORD
EXTRN		amsdos:BYTE, basic:BYTE, rom7:BYTE, rom5:BYTE, rom6:BYTE
EXTRN		germkey:WORD, intflag:WORD
extrn		SCinstalled:WORD, usesound:WORD

; from snd.asm
extrn		sound_pause:WORD, sound_continue:WORD

; from tape.asm
EXTRN		CAScont:WORD, CASInH:WORD


PUBLIC		LoadROMs, Menu, ClearKeyMap, MyKeyInt, SetLEDs

PUBLIC		KeyMatrix, keycode, EngNormTab, FrnNormTab, GerNormTab
PUBLIC		ColorTab, ColorTabA, LED_status


GROUP DGROUP	_stack, _data

SEGMENT _text	PAGE PUBLIC 'CODE'
ASSUME		CS:_text
ASSUME		DS:DGROUP

; ________________________________________________________________________

LoadROMs:
		MOV	DX, OFFSET mvr464		; load lower ROM
		CMP	[cpctype], 1
		JE	LMVR_Ok
		MOV	DX, OFFSET mvr664
		CMP	[cpctype], 2
		JE	LMVR_Ok
		MOV	DX, OFFSET mvr6128
LMVR_Ok:
		MOV	AX, 3d00h
		INT	21h
		JC	cleanup
		MOV	BX, AX
		MOV	AH, 3Fh
		MOV	DX, SEG amsdos
		MOV	DS, DX
		MOV	DX, OFFSET amsdos
		MOV	CX, 4000h
		INT	21h
		MOV	DX, DGROUP
		MOV	DS, DX
		JC	cleanup
		MOV	AH, 3Fh
		MOV	DX, SEG basic
		MOV	DS, DX
		MOV	DX, OFFSET basic
		MOV	CX, 4000h
		INT	21h
		MOV	DX, DGROUP
		MOV	DS, DX
		JC	cleanup
		MOV	AH, 3Eh
		INT	21h

		MOV	[haver5], 0
		MOV	[haver6], 0
		MOV	[haver7], 0

		MOV	DX, OFFSET mvr7			; load floppy ROM
		MOV	AX, 3d00h
		INT	21h
		JC	nor7
		MOV	BX, AX
		MOV	AH, 3Fh
		MOV	DX, SEG rom7
		MOV	DS, DX
		MOV	DX, OFFSET rom7
		MOV	CX, 4000h
		INT	21h
		MOV	DX, DGROUP
		MOV	DS, DX
		JC	cleanup
		MOV	AH, 3Eh
		INT	21h
		MOV	[haver7], 1
nor7:
		MOV	DX, OFFSET r5name
		MOV	AX, 3d00h
		INT	21h
		JC	nor5
		MOV	BX, AX
		MOV	AH, 3Fh
		MOV	DX, SEG rom5
		MOV	DS, DX
		MOV	DX, OFFSET rom5
		MOV	CX, 4000h
		INT	21h
		MOV	DX, DGROUP
		MOV	DS, DX
		JC	nor5
		MOV	AH, 3Eh
		INT	21h
		MOV	[haver5], 1
nor5:
		MOV	DX, OFFSET r6name
		MOV	AX, 3d00h
		INT	21h
		JC	nor6
		MOV	BX, AX
		MOV	AH, 3Fh
		MOV	DX, SEG rom6
		MOV	DS, DX
		MOV	DX, OFFSET rom6
		MOV	CX, 4000h
		INT	21h
		MOV	DX, DGROUP
		MOV	DS, DX
		JC	nor6
		MOV	AH, 3Eh
		INT	21h
		MOV	[haver6], 1
nor6:
		Call	PatchLROM
		RET
PatchLROM:
		PUSH	ES
		PUSH	DX
		MOV	DX, SEG amsdos
		MOV	ES, DX
		CMP	[WORD PTR ES:682h], '1v'
		JE	PLRO_464
		CMP	[WORD PTR ES:683h], '2v'
		JE	PLRO_664
		CMP	[WORD PTR ES:69Eh], '3v'
		JE	PLRO_6128
PLRO_end:
		POP	DX
		POP	ES
		RET
PLRO_464:
		MOV	[CPCKtb], 1d69h
		MOV	[WORD PTR ES:2836h], 0feedh
;		MOV	[WORD PTR ES:283fh], 0fdedh
;		MOV	[WORD PTR ES:2851h], 0fcedh
		MOV	[WORD PTR ES:2399h], 0fbedh
		MOV	[WORD PTR ES:2a51h+17h], 01h
		MOV	[CAScont], 02a72h
		MOV	[CASInH], 0b807h
		CMP	[quietcas], 0
		JE	PLRO_end
		MOV	[BYTE PTR ES:2765h], 0C9h
		MOV	[WORD PTR ES:2560h], 0530h
		MOV	[WORD PTR ES:2562h], 0
		POP	DX
		POP	ES
		RET
PLRO_664:
		MOV	[CPCKtb], 1eefh
		MOV	[WORD PTR ES:29A6h], 0feedh
;		MOV	[WORD PTR ES:29AFh], 0fdedh
;		MOV	[WORD PTR ES:29C1h], 0fcedh
		MOV	[WORD PTR ES:2bc1h+17h], 01h
		MOV	[WORD PTR ES:24ech], 0fbedh
		MOV	[CAScont], 02be2h
		MOV	[CASInH], 0b11fh
		CMP	[quietcas], 0
		JE	PLRO_end
		MOV	[BYTE PTR ES:28D7h], 0C9h
		MOV	[WORD PTR ES:26d4h], 0328h
		POP	DX
		POP	ES
		RET
PLRO_6128:
		MOV	[CPCKtb], 1eefh
		MOV	[WORD PTR ES:29A6h], 0feedh
;		MOV	[WORD PTR ES:29AFh], 0fdedh
;		MOV	[WORD PTR ES:29C1h], 0fcedh
		MOV	[WORD PTR ES:2bc1h+17h], 01h
		MOV	[WORD PTR ES:24ech], 0fbedh
		MOV	[DWORD PTR ES:24eeh], 0E126ACCDh ; make it like 664
		MOV	[CAScont], 02be2h
		MOV	[CASInH], 0b11fh
		CMP	[quietcas], 0
		JE	PLRO_end
		MOV	[BYTE PTR ES:28D7h], 0C9h
		MOV	[WORD PTR ES:26d4h], 0328h
		POP	DX
		POP	ES
		RET

; ________________________________________________________________________

Menu:
		pushad
		push	es
		call	[sound_pause]
		call	OpenTextScr

		mov	si, offset menu_layout		; options menu layout
m_lloop:
		mov	ax, [si]			; get screen position
		or	ax, ax				; end of screen layout?
		js	m_ldone
		call	[move_scrpos]
		add	si, 2				; skip position
		mov	bl, 0				; 0 terminated string
		call	[print_string]
		jmp	m_lloop
m_ldone:
		mov	[current_pos], 0
m_selector:
		mov	cx, [MenuItems]			; # of menu items
		mov	bp, offset MenuVars
		mov	dx, 0002h			; start with 1st option
m_sloop:
		mov	si, offset notchecked
		cmp	[word ptr bp], 0		; option disabled?
		je	m_notenabled
		mov	si, offset checked
m_notenabled:		
		mov	ax, dx
		call	[move_scrpos]			; move cursor
		mov	bl, 3
		mov	bh, cl
		mov	cl, 07h
		mov	al, [byte ptr current_pos]
		add	al, 2
		cmp	al, dl
		jne	m_notselected
		mov	cl, 1fh
m_notselected:
		call	[print_string]
		mov	cl, bh
		inc	dl				; next row
		add	bp, 2				; next option
		loop	m_sloop
m_getkey:
		mov	[keycode], 0			; clear input
m_getkeyloop:
		mov	ah, [keycode]
		or	ah, ah				; was any key pressed?
		jz	m_getkeyloop

; ........................................................................

		cmp	ah, ESC_KEY
		je	m_done

; ........................................................................

		cmp	ah, UP_KEY
		jne	m_notup
		cmp	[current_pos], 0		; already at the top?
		je	m_getkey
		dec	[current_pos]
		jmp	m_selector		
m_notup:
		
; ........................................................................

		cmp	ah, DOWN_KEY
		jne	m_notdown
		mov	ax, [current_pos]
		inc	ax
		cmp	ax, [MenuItems]
		je	m_getkey
		mov	[current_pos], ax
		jmp	m_selector
m_notdown:

; ........................................................................

		cmp	ah, TOGGLE_KEY
		jne	m_getkey
		mov	ax, [current_pos]
		shl	ax, 1
		mov	di, offset MenuVars
		add	di, ax
		not	[word ptr di]
		jmp	m_selector

; ........................................................................

m_done:
		call	ClearKeyMap
		mov	[keycode], 0			; clear input buffer
		call	RestoreScreen

		cmp	[SCinstalled], 0		; soundcard installed?
		jne	m_SCinstalled
		mov	[usesound], 0			; disable sound output
m_SCinstalled:
		call	[sound_continue]
		call	init_joystick			; update joysticks
		call	set_colours			; colour / green palette
		pop	es
		popad
		ret

; ________________________________________________________________________

MyKeyInt:
		push	ax
		push	cx
		push	di
		push	ds
		mov	ax, DGROUP
		mov	ds, ax

		cli
		xor	cx, cx				; timeout counter
mki_waitloop:
		in	al, 64h				; poll status port
		test	al, 1				; data in output buffer?
		loopz	mki_waitloop
		in	al, 60h				; grab key code
		sti

		xor	di, di
		mov	ah, [LED_status]
		test	ah, 2				; Num Lock LED on?
		jnz	mki_numlockon
		mov	di, 128
mki_numlockon:
		cmp	[altcode], 1			; processing MFII key?
		je	mki_MFIIkey
		cmp	al, 45h				; Num Lock key pressed?
		jne	mki_notnumlock
		xor	ah, 2				; toggle status
		mov	[LED_status], ah
		call	SetLEDs				; update keyboard LEDs
		jmp	mki_done
mki_notnumlock:
		cmp	al, 3ah				; Caps Lock key pressed?
		jne	mki_notcapslock
		xor	ah, 4				; toggle status
		mov	[LED_status], ah
		mov	ah, al
		call	SetLEDs				; update keyboard LEDs
		mov	al, ah
mki_notcapslock:
		cmp	al, 0e0h			; MFII precode?
		jne	mki_notprecode
		mov	[altcode], 1
		jmp	mki_done
mki_MFIIkey:
		mov	[altcode], 0
		add	di, offset AltCodeTab
		jmp	mki_checkcode
mki_notprecode:
		add	di, offset KeyCodeTab
mki_checkcode:
		or	al, al
		js	mki_breakcode
		mov	[keycode], al			; store key scan code
		or	[intflag], 100h
		cmp	[spccode], 0			; ??
		jne	mki_breakcode
		mov	[spccode], al
mki_breakcode:
		mov	cl, al
		and	ax, 7fh				; mask out high-bit
		add	di, ax
		mov	al, [di]
		cmp	al, 0f0h			; invalid key?
		je	mki_done
		movzx	di, al
		shr	di, 4
		and	ax, 0fh
		or	cl, cl
		js	mki_released
		btr	[di + offset KeyMatrix], ax
		jmp	mki_done
mki_released:
		bts	[di + offset KeyMatrix], ax
mki_done:
		mov	al, 20h
		out	20h, al				; clear interrupt
		pop	ds
		pop	di
		pop	cx
		pop	ax
		iret

; ________________________________________________________________________

SetLEDs:
		mov	al, 0edh			; update keyboard LEDs
		out	60h, al
sled_loop:
		in	al, 64h
		test	al, 2				; data in input buffer?
		jnz	sled_loop
		mov	al, [LED_status]
		out	60h, al				; set LEDs
		ret

; ________________________________________________________________________

ClearKeyMap:
		MOV	[DWORD PTR KeyMatrix], 0ffffffffh
		MOV	[DWORD PTR KeyMatrix+4], 0ffffffffh
		MOV	[DWORD PTR KeyMatrix+8], 0ffffffffh
		MOV	[DWORD PTR KeyMatrix+12], 0ffffffffh
		RET

; ________________________________________________________________________

ENDS

SEGMENT _data	PAGE PUBLIC 'DATA'

mvr464		db	'ROM\CPC464.ROM', 0
mvr664		db	'ROM\CPC664.ROM', 0
mvr6128		db	'ROM\CPC6128.ROM', 0
mvr7		db	'ROM\CPCADOS.ROM', 0
r5name		db	'ROM\ROM5.ROM', 0
r6name		db	'ROM\ROM6.ROM', 0

ColorTabA	dd	00002400h, 00002400h, 00003000h, 00003C00h
		dd	00000C00h, 00001800h, 00001E00h, 00002A00h ;4
		dd	00001800h, 00003C00h, 00003A00h, 00003E00h
		dd	00001600h, 00001A00h, 00002800h, 00002C00h ; 12
		dd	00000C00h, 00003000h, 00002E00h, 00003200h
		dd	00000A00h, 00000E00h, 00001C00h, 00002000h ; 20
		dd	00001200h, 00003600h, 00003400h, 00003800h
		dd	00001000h, 00001400h, 00002200h, 00002600h

ColorTab	dd	002f2f2fh, 002f2f2fh, 00003f2fh, 003f3f2fh
		dd	0000002fh, 003f002fh, 00002f2fh, 003f2f2fh ;4
		dd	003f002fh, 003f3f2fh, 003f3f00h, 003f3f3fh
		dd	003f0000h, 003f003fh, 003f2f00h, 003f2f3fh ; 12
		dd	0000002fh, 00003f2fh, 00003f00h, 00003f3fh
		dd	00000000h, 0000003fh, 00002f00h, 00002f3fh ; 20
		dd	002f002fh, 002f3f2fh, 002f3f00h, 002f3f3fh
		dd	002f0000h, 002f003fh, 002f2f00h, 002f2f3fh

LABEL KeyMatrix BYTE
		db	0FFH, 0FFh, 0FFh, 0FFh, 0FFh, 0FFh, 0FFh, 0FFh
		db	0FFh, 0FFh, 0FFh, 0FFh, 0FFh, 0FFh, 0FFh, 0FFh

		EVEN

LABEL KeyCodeTab BYTE	; F0 = not on cpc keyboard
 ;                  ESC  1    2    3    4    5    6    7    8    9    0            DEL  TAB
        db    0f0h,082h,080h,081h,071h,070h,061h,060h,051h,050h,041h,040h,031h,030h,097h,084h
 ;             Q    W    E    R    T    Y    U    I    O    P        +    CR  CTRL  A    S
        db    083h,073h,072h,062h,063h,053h,052h,043h,042h,033h,032h,021h,022h,027h,085h,074h
 ;             D    F    G    H    J    K    L            ^  LSH   #'   Z    X    C    V
        db    075h,065h,064h,054h,055h,045h,044h,035h,034h,082h,025h,023h,087h,077h,076h,067h
 ;             B    N    M    ,    .    -   RSH  PRTS ALT  SPC  CAP   F1   F2   F3   F4   F5
        db    066h,056h,046h,047h,037h,036h,025h,0f0h,011h,057h,086h,0f0h,0f0h,0f0h,0f0h,0f0h
 ;             F6   F7   F8   F9   F10  NUM  ROL  N7   N8   N9   N-   N4   N5   N6   N+   N1
        db    0f0h,0f0h,0f0h,0f0h,0f0h,0f0h,090h,012h,013h,003h,031h,024h,014h,004h,034h,015h
 ;             N2   N3   N0   N,                 F11  F12
        db    016h,005h,017h,007h,0f0h,0f0h,026h,0F0h,0F0h,026h,026h,026h,026h,026h,026h,026h
        db    0f0h,0f0h,0f0h,0f0h,0F0h,0F0h,0F0h,0F0h,0F0h,0F0h,0F0h,0F0h,0f0h,0F0h,0F0h,0F0h
        db    0f0h,0f0h,0f0h,0f0h,0f0h,0F0h,0F0h,0F0h,0F0h,0F0h,0F0h,0F0h,0F0h,0F0h,0F0h,0F0h
 ; SECOND ALTERNATIVE: NumLock OFF
 ;                  ESC  1    2    3    4    5    6    7    8    9    0            DEL  TAB
        db    0f0h,082h,080h,081h,071h,070h,061h,060h,051h,050h,041h,040h,031h,030h,097h,084h
 ;             Q    W    E    R    T    Z    U    I    O    P        +    CR  CTRL  A    S
        db    083h,073h,072h,062h,063h,053h,052h,043h,042h,033h,032h,021h,022h,027h,085h,074h
 ;             D    F    G    H    J    K    L            ^  LSH   #'   Y    X    C    V
        db    075h,065h,064h,054h,055h,045h,044h,035h,034h,082h,025h,023h,087h,077h,076h,067h
 ;             B    N    M    ,    .    -   RSH  PRTS ALT  SPC  CAP   F1   F2   F3   F4   F5
        db    066h,056h,046h,047h,037h,036h,025h,0f0h,011h,057h,086h,0f0h,0f0h,0f0h,0f0h,0f0h
 ;             F6   F7   F8   F9   F10  NUM  ROL  N7   N8   N9   N-   N4   N5   N6   N+   N1
        db    0f0h,0f0h,0f0h,0f0h,0f0h,0f0h,060h,012h,090h,003h,031h,092h,094h,093h,034h,015h
 ;             N2   N3   N0   N,                 F11  F12
        db    091h,005h,017h,007h,0f0h,0f0h,026h,0F0h,0F0h,026h,026h,026h,026h,026h,026h,026h
        db    0f0h,0f0h,0f0h,0f0h,0F0h,0F0h,0F0h,0F0h,0F0h,0F0h,0F0h,0F0h,0f0h,0F0h,0F0h,0F0h
        db    0f0h,0f0h,0f0h,0f0h,0f0h,0F0h,0F0h,0F0h,0F0h,0F0h,0F0h,0F0h,0F0h,0F0h,0F0h,0F0h

LABEL AltCodeTab BYTE    ; F0 = not on cpc keyboard
        db    0f0h,0f0h,0f0h,0f0h,0f0h,0f0h,0f0h,0f0h,0f0h,0f0h,0f0h,0f0h,0f0h,0f0h,0f0h,0f0h
 ;                                                                       ENTER CTRL
        db    0f0h,0f0h,0f0h,0f0h,0f0h,0f0h,0f0h,0f0h,0f0h,0f0h,0f0h,0f0h,006h,027h,0f0h,0f0h
        db    0f0h,0f0h,0f0h,0f0h,0f0h,0f0h,0f0h,0f0h,0f0h,0f0h,0f0h,0f0h,0f0h,0f0h,0f0h,0f0h
        db    0f0h,0f0h,0f0h,0f0h,0f0h,0f0h,0f0h,0f0h,0f0h,0f0h,0f0h,0f0h,0f0h,0f0h,0f0h,0f0h
 ;                                               HOME CUUP PGUP      CULF      CURT      ENDE
        db    0f0h,0f0h,0f0h,0f0h,0f0h,0f0h,0f0h,094h,000h,093h,0f0h,010h,0f0h,001h,0f0h,091h
 ;            CUDN PGDN INST DELE
        db    002h,0f0h,092h,020h,0f0h,0f0h,0f0h,0f0h,0f0h,0f0h,0f0h,0f0h,0f0h,0f0h,0f0h,0f0h
        db    0f0h,0f0h,0f0h,0f0h,0f0h,0f0h,0f0h,0f0h,0f0h,0f0h,0f0h,0f0h,0f0h,0f0h,0f0h,0f0h
        db    0f0h,0f0h,0f0h,0f0h,0f0h,0f0h,0f0h,0f0h,0f0h,0f0h,0f0h,0f0h,0f0h,0f0h,0f0h,0f0h
 ; ALTERNATIVE: NumLock OFF
        db    0f0h,0f0h,0f0h,0f0h,0f0h,0f0h,0f0h,0f0h,0f0h,0f0h,0f0h,0f0h,0f0h,0f0h,0f0h,0f0h
 ;                                                                       ENTER
        db    0f0h,0f0h,0f0h,0f0h,0f0h,0f0h,0f0h,0f0h,0f0h,0f0h,0f0h,0f0h,006h,0f0h,0f0h,0f0h
        db    0f0h,0f0h,0f0h,0f0h,0f0h,0f0h,0f0h,0f0h,0f0h,0f0h,0f0h,0f0h,0f0h,0f0h,0f0h,0f0h
        db    0f0h,0f0h,0f0h,0f0h,0f0h,0f0h,0f0h,0f0h,0f0h,0f0h,0f0h,0f0h,0f0h,0f0h,0f0h,0f0h
 ;                                               HOME CUUP PGUP      CULF      CURT      ENDE
        db    0f0h,0f0h,0f0h,0f0h,0f0h,0f0h,0f0h,064h,000h,063h,0f0h,010h,0f0h,001h,0f0h,061h
 ;            CUDN PGDN INST DELE
        db    002h,0f0h,062h,020h,0f0h,0f0h,0f0h,0f0h,0f0h,0f0h,0f0h,0f0h,0f0h,0f0h,0f0h,0f0h
        db    0f0h,0f0h,0f0h,0f0h,0f0h,0f0h,0f0h,0f0h,0f0h,0f0h,0f0h,0f0h,0f0h,0f0h,0f0h,0f0h
        db    0f0h,0f0h,0f0h,0f0h,0f0h,0f0h,0f0h,0f0h,0f0h,0f0h,0f0h,0f0h,0f0h,0f0h,0f0h,0f0h


		; CPC ROM Keyboard translation key
		; equate original CPC ROM

Label EngNormTab byte

		DB	0F0h, 0F3h, 0F1h, 089h, 086h, 083h, 08Bh, 08Ah
		DB	0F2h, 0E0h, 087h, 088h, 085h, 081h, 082h, 080h
		DB	010h,  '[', 00Dh,  ']', 084h, 0FFh,  '\', 0FFh
		DB	 '^',  '-',  '@',  'p',  ';',  ':',  '/',  '.'
		DB	 '0',  '9',  'o',  'i',  'l',  'k',  'm',  ','
		DB	 '8',  '7',  'u',  'y',  'h',  'j',  'n',  ' '
		DB	 '6',  '5',  'r',  't',  'g',  'f',  'b',  'v'
		DB	 '4',  '3',  'e',  'w',  's',  'd',  'c',  'x'
		DB	 '1',  '2', 0FCh,  'q', 009h,  'a', 0FDh,  'z'
		DB	00Bh, 00Ah, 008h, 009h,  'X',  'Z', 0FFh, 07Fh

Label EngShiftTab byte

		DB	0F4h, 0F7h, 0F5h, 089h, 086h, 083h, 08Bh, 08Ah
		DB	0F6h, 0E0h, 087h, 088h, 085h, 081h, 082h, 080h
		DB	010h,  '{', 00Dh,  '}', 084h, 0FFh,  '`', 0FFh
		DB	0A3h,  '=',  '|',  'P',  '+',  '*',  '?',  '>'
		DB	 '_',  ')',  'O',  'I',  'L',  'K',  'M',  '<'
		DB	 '(',  "'",  'U',  'Y',  'H',  'J',  'N',  ' '
		DB	 '&',  '%',  'R',  'T',  'G',  'F',  'B',  'V'
		DB	 '$',  '#',  'E',  'W',  'S',  'D',  'C',  'X'
		DB	 '!',  '"', 0FCh,  'Q', 009h,  'A', 0FDh,  'Z'
		DB	00Bh, 00Ah, 008h, 009h,  'X',  'Z', 0FFh, 07Fh

Label EngCtrlTab byte

		DB	0F8h, 0FBh, 0F9h, 089h, 086h, 083h, 08Ch, 08Ah
		DB	0FAh, 0E0h, 087h, 088h, 085h, 081h, 082h, 080h
		DB	010h, 01Bh, 00Dh, 01Dh, 084h, 0FFh, 01Ch, 0FFh
		DB	01Eh, 0FFh, 000h, 010h, 0FFh, 0FFh, 0FFh, 0FFh
		DB	01Fh, 0FFh, 00Fh, 009h, 00Ch, 00Bh, 00Dh, 0FFh
		DB	0FFh, 0FFh, 015h, 019h, 008h, 00Ah, 00Eh, 0FFh
		DB	0FFh, 0FFh, 012h, 014h, 007h, 006h, 002h, 016h
		DB	0FFh, 0FFh, 005h, 017h, 013h, 004h, 003h, 018h
		DB	0FFh,  '~', 0FCh, 011h, 0E1h, 001h, 0FEh, 01Ah
		DB	0FFh, 0FFh, 0FFh, 0FFh, 0FFh, 0FFh, 0FFh, 07Fh

Label EngOtherTab byte

		DB	007h, 003h,  'K', 0FFh, 0FFh, 0FFh, 0FFh, 0FFh
		DB	0ABh, 08Fh
SzEngTab	=	$ - EngNormTab

		; CPC ROM Keyboard translation key

Label   GerNormTab byte

		DB	0F0h, 0F3h, 0F1h, 089h, 086h, 083h, 08Bh, 08Ah
		DB	0F2h, 0E0h, 087h, 088h, 085h, 081h, 082h, 080h
		DB	010h,  '[', 00Dh,  ']', 084h, 0FFh,  '\', 0FFh
		DB	 '^',  '-',  '@',  'p',  ';',  ':',  '/',  '.'
		DB	 '0',  '9',  'o',  'i',  'l',  'k',  'm',  ','
		DB	 '8',  '7',  'u',  'z',  'h',  'j',  'n',  ' '
		DB	 '6',  '5',  'r',  't',  'g',  'f',  'b',  'v'
		DB	 '4',  '3',  'e',  'w',  's',  'd',  'c',  'x'
		DB	 '1',  '2', 0FCh,  'q', 009h,  'a', 0FDh,  'y'
		DB	00Bh, 00Ah, 008h, 009h,  'X',  'Z', 0FFh, 07Fh

Label   GerShiftTab byte

		DB	0F4h, 0F7h, 0F5h, 089h, 086h, 083h, 08Bh, 08Ah
		DB	0F6h, 0E0h, 087h, 088h, 085h, 081h, 082h, 080h
		DB	010h,  '{', 00Dh,  '}', 084h, 0FFh,  '`', 0FFh
		DB	0A3h,  '=',  '|',  'P',  '+',  '*',  '?',  '>'
		DB	 '_',  ')',  'O',  'I',  'L',  'K',  'M',  '<'
		DB	 '(',  "'",  'U',  'Z',  'H',  'J',  'N',  ' '
		DB	 '&',  '%',  'R',  'T',  'G',  'F',  'B',  'V'
		DB	 '$',  '#',  'E',  'W',  'S',  'D',  'C',  'X'
		DB	 '!',  '"', 0FCh,  'Q', 009h,  'A', 0FDh,  'Y'
		DB	00Bh, 00Ah, 008h, 009h,  'X',  'Z', 0FFh, 07Fh

Label   GerCtrlTab byte

		DB	0F8h, 0FBh, 0F9h, 089h, 086h, 083h, 08Ch, 08Ah
		DB	0FAh, 0E0h, 087h, 088h, 085h, 081h, 082h, 080h
		DB	010h, 01Bh, 00Dh, 01Dh, 084h, 0FFh, 01Ch, 0FFh
		DB	01Eh, 0FFh, 000h, 010h, 0FFh, 0FFh, 0FFh, 0FFh
		DB	01Fh, 0FFh, 00Fh, 009h, 00Ch, 00Bh, 00Dh, 0FFh
		DB	0FFh, 0FFh, 015h, 019h, 008h, 00Ah, 00Eh, 0FFh
		DB	0FFh, 0FFh, 012h, 014h, 007h, 006h, 002h, 016h
		DB	0FFh, 0FFh, 005h, 017h, 013h, 004h, 003h, 018h
		DB	0FFh,  '~', 0FCh, 011h, 0E1h, 001h, 0FEh, 01Ah
		DB	0FFh, 0FFh, 0FFh, 0FFh, 0FFh, 0FFh, 0FFh, 07Fh

Label   GerOtherTab byte

		DB	007h, 003h,  'K', 0FFh, 0FFh, 0FFh, 0FFh, 0FFh
		DB	0ABh, 08Fh
SzGerTab	=	$ - GerNormTab

		; CPC ROM Keyboard translation key

Label   FrnNormTab byte

		DB	0F0h, 0F3h, 0F1h, 089h, 086h, 083h, 08Bh, 08Ah
		DB	0F2h, 0E0h, 087h, 088h, 085h, 081h, 082h, 080h
;		DB	010h,  '[', 00Dh,  '}', 084h, 0FFh,  '\', 0FFh
		DB	010h,  '$', 00Dh,  '*', 084h, 0FFh,  '<', 0FFh
;		DB	 '#',  ')',  '%',  'p',  ';',  ':',  '/',  '.'
		DB	 '=',  ')',  '[',  'p',  '{',  'm',  '!',  ':'
;		DB	 '@',  '^',  'o',  'i',  'l',  'k',  'm',  ','
		DB	 '@',  '^',  'o',  'i',  'l',  'k',  ',',  ';'
;		DB	 '_',  "&",  'u',  'y',  'h',  'j',  'n',  ' '
		DB	 '_',  '`',  'u',  'y',  'h',  'j',  'n',  ' '
		DB	 '-',  '(',  'r',  't',  'g',  'f',  'b',  'v'
		DB	 "'",  '"',  'e',  'z',  's',  'd',  'c',  'x'
;		DB	 '&',  '$', 0FCh,  'a', 009h,  'q', 0FDh,  'w'
		DB	 '&',  '\', 0FCh,  'a', 009h,  'q', 0FDh,  'w'
		DB	00Bh, 00Ah, 008h, 009h,  'X',  'Z', 0FFh, 07Fh

Label FrnShiftTab byte

		DB	0F4h, 0F7h, 0F5h, 089h, 086h, 083h, 08Bh, 08Ah
		DB	0F6h, 0E0h, 087h, 088h, 085h, 081h, 082h, 080h
;		DB	010h,  '{', 00Dh,  ']', 084h, 0FFh,  '`', 0FFh
		DB	010h, 0A3H, 00Dh,  '}', 084h, 0FFh,  '>', 0FFh
;		DB	0A3h,  '=',  '|',  'P',  '+',  '*',  '?',  '>'
		DB	 '+',  '#',  ']',  'P',  '%',  'M', 0FFH,  '/'
;		DB	 '0',  '9',  'O',  'I',  'L',  'K',  'M',  '<'
		DB	 '0',  '9',  'O',  'I',  'L',  'K',  '?',  '.'
		DB	 '8',  '7',  'U',  'Y',  'H',  'J',  'N',  ' '
		DB	 '6',  '5',  'R',  'T',  'G',  'F',  'B',  'V'
		DB	 '4',  '3',  'E',  'Z',  'S',  'D',  'C',  'X'
		DB	 '1',  '2', 0FCh,  'A', 009h,  'Q', 0FDh,  'W'
		DB	00Bh, 00Ah, 008h, 009h,  'X',  'Z', 0FFh, 07Fh

Label FrnCtrlTab byte

		DB	0F8h, 0FBh, 0F9h, 089h, 086h, 083h, 08Ch, 08Ah
		DB	0FAh, 0E0h, 087h, 088h, 085h, 081h, 082h, 080h
		DB	010h, 01Bh, 00Dh, 01Dh, 084h, 0FFh, 01Ch, 0FFh
		DB	01Eh, 0FFh, 000h, 010h, 0FFh, 0FFh, 0FFh, 0FFh
		DB	01Fh, 0FFh, 00Fh, 009h, 00Ch, 00Bh, 00Dh, 0FFh
		DB	0FFh, 0FFh, 015h, 019h, 008h, 00Ah, 00Eh, 0FFh
		DB	0FFh, 0FFh, 012h, 014h, 007h, 006h, 002h, 016h
		DB	0FFh, 0FFh, 005h, 017h, 013h, 004h, 003h, 018h
		DB	0FFh,  '~', 0FCh, 011h, 0E1h, 001h, 0FEh, 01Ah
		DB	0FFh, 0FFh, 0FFh, 0FFh, 0FFh, 0FFh, 0FFh, 07Fh

Label   FrnOtherTab byte

		DB	007h, 003h,  'K', 0FFh, 0FFh, 0FFh, 0FFh, 0FFh
		DB	0ABh, 08Fh
SzFrnTab	=	$ - FrnNormTab

 ; ************************************************ keyboard

		even
keycode		db	0, 0
altcode		dw	0
spccode		db	0, 0
LED_status	db	00000010b, 0

current_pos	dw	0
notchecked	db	020h, 0fah, 020h
checked		db	020h, 0fbh, 020h

ENDS

SEGMENT _stack	PARA STACK 'STACK'

ENDS

END
