;zblast SD - music code

chan_music_1	equ 0
chan_music_2	equ 1
snd_music_tone_mask	equ 1+2


;current addr in blocklist table
blockpos	equ musicvars	;2 bytes

;and in the blocks themselves
chan1pos	equ musicvars+2	;2 bytes
chan2pos	equ musicvars+4	;2 bytes

note_time_in_frames equ 5

;notes left in current block
notes_left	equ musicvars+6


blocklist	equ musicvars+7	;2 bytes
blocks_minus64	equ musicvars+9	;2 bytes


musicframe:
ld a,(blockpos+1)
and a
ret z

ld hl,note_timeout
ld a,(hl)
and a
jr z,mfnext

ld a,(frame_counter)
and a
ret nz

dec (hl)
dec a
jr nz,writevol

mfnext:
ld (hl),note_time_in_frames

ld hl,notes_left
dec (hl)
bit 7,(hl)
jr z,mfgetblockskip

ld (hl),63	;reset notes_left (really 64, but need 63 given how it works)

ld hl,(blockpos)
ld a,(hl)
inc a
jr nz,mfresetskip
ld hl,(blocklist)
mfresetskip:
call mfblockaddr
ld (chan1pos),de
call mfblockaddr
ld (chan2pos),de
ld (blockpos),hl

mfgetblockskip:
;get next notes
ld hl,(chan1pos)
ld d,chan_music_1*2
call mfchan1note
ld (chan1pos),hl
ld hl,(chan2pos)
ld d,chan_music_2*2
call mfchan2note
ld (chan2pos),hl
ld a,note_time_in_frames-1
;falls through

writevol:
srl a
add a,8
ld b,a
subvolop: sub 0		;modified
ld c,a
ld d,chan_music_1+8
ld hl,chan1pos
call writevol2
ld c,b
ld d,chan_music_2+8
ld hl,chan2pos
;falls through

writevol2:
ld a,c
and &1f   ;Reset bits 5-7 of the volume, otherwise the Arnold emulator will
          ;crash!
ld e,a

ld a,(hl)
inc hl
ld h,(hl)
ld l,a
ld a,h
and a
jr nz,wvol2skip
;zero out if no block playing
ld e,0
wvol2skip:
dec hl
ld a,(hl)
and a
jr nz,wvol2skip2
;also zero out if no note currently playing in the block
ld e,0
wvol2skip2:
jr aywrite_jr


mfchan1note:
ld a,(hl)

;write vol stuff
rlca
rlca
and 2
ld (subvolop+1),a

mfchan2note:
;don't write if it's zero (to avoid sound glitches)
ld a,(hl)
and a
inc hl
ret z

push hl
and 127
ld l,a
ld h,0
add hl,hl
ld bc,freqtable-2
add hl,bc
ld e,(hl)
inc hl
call aywrite
ld e,(hl)
pop hl
inc d
aywrite_jr:
jp aywrite


mfblockaddr:
ld a,(hl)
inc hl
ld e,a
ld d,0
and a
ret z	;use zero to indicate no block to play on this channel

ex de,hl
add hl,hl
add hl,hl
add hl,hl
add hl,hl
add hl,hl
add hl,hl	;*64
ld bc,(blocks_minus64)
add hl,bc
ex de,hl
ret

