;zblast SD - sound code (and interrupt handler)

chan_sfx	equ 2

snd_sfx_tone_mask	equ 4
snd_sfx_noise_mask	equ 32


;these get higher priority with higher numbers - a new
;sound which has type >= existing one will override it.
snd_plyr_shot		equ 1
snd_enemy_shot		equ 2
snd_enemy_hit		equ 3
snd_enemy_died		equ 4
snd_plyr_lostlife	equ 5
snd_plyr_died		equ 6

snd_sfx_init_timeouts: defb 15,15,7,20,12,127

snd_sfx_timeout equ snd_sfx_timeout_op+1
snd_sfx_type equ snd_sfx_type_op+1


sfx_noise_on:
ld a,(mixerdat)
and 255-snd_sfx_noise_mask
jr mixerwrite

sfx_noise_off:
ld a,(mixerdat)
or snd_sfx_noise_mask
mixerwrite:
ld (mixerdat),a

;Bits 7 and 6 of register 7 define the modes of ports A and B of the PSG. On the
;Arnold emulator and a real CPC, port A must be in input mode (i.e. bit 6 must be
;reset), otherwise the keyboard routines will not work properly. For some reason,
;this does not happen on all other CPC emulators that I have tested!

and &3f   ;Reset bits 7 and 6, so that port A is in input mode
ld e,a
ld d,7
;falls through

;write e to ay register d
;The Arnold emulator on Windows crashes if bits 7 and/or 6 are set for registers
;8, 9 and 10 (amplitudes of channels A, B and C)
aywrite:
push bc

ld b,&f4
out (c),d   ;Write the selected PSG register to port A
ld bc,&f6c0   ;Set the PPI to 'select PSG register' mode (bit 7 = 1, bit 6 = 1)
out (c),c
ld c,0   ;Set the PPI to inactive mode (bits 7 = 0, bit 6 = 0)
out (c),c

ld b,&f4
out (c),e   ;Set the new value of the register
ld bc,&f680   ;Set the PPI to 'write PSG register' mode (bit 7 = 1, bit 6 = 0)
out (c),c
ld c,0   ;Set the PPI to inactive mode (bits 7 = 0, bit 6 = 0)
out (c),c

pop bc
ret


queuesnd_sfx:
ld (asavop+1),a
snd_sfx_timeout_op: ld a,0	;modified
and a
asavop: ld a,0		;modified
jr z,qsp1

;must be >= existing type
exx
ld hl,(snd_sfx_type)
cp l
exx
ret c

qsp1:
ld (snd_sfx_type),a
exx
ld l,a
ld h,0
ld de,snd_sfx_init_timeouts-1
add hl,de
ld a,(hl)
ld (snd_sfx_timeout),a
exx
ret

sound_frames: defb 0

inthndl:
push af
push bc
push de
push hl

;On the Spectrum, interrupts run at 50Hz, but on a CPC, they run at 300Hz, so
;the interrupt routine should only be run every sixth interrupt

;frame_counter keeps a count of this. It is incremented by 1 on each interrupt,
;and when it reaches 6, it is reset to 0

frame_counter  equ frame_counterop+1
frame_counterop: ld a,0    ;modified
inc a   ;Increase the counter
ld (frame_counter),a
cp 5
jr c,inthndl2   ;If the counter is more than 5, reset it
xor a
ld (frame_counter),a

;The interrupt routine is only run when the counter is equal to 0
inthndl2:
and a
jp nz,ihs3

frames	equ framesop+1 ;=screen frames (i.e. ints) since start of game frame
framesop: ld a,0	;modified
inc a
ld (frames),a

call musicframe

;--- player stuff ---
;
ld hl,snd_sfx_timeout
ld a,(hl)
and a
jr nz,ihs1a

inc (hl)	;to counter the decr later
ld c,a
ld b,a
ld l,a
jr ihs1z

ihs1a:
snd_sfx_type_op: ld a,0	;modified
cp snd_plyr_shot
jr nz,ihs1b

call sfx_noise_off
ld a,(hl)
rlca
rlca
rlca
ld e,a
ld a,255
sub e
ld c,a
ld b,0

ld a,(hl)
srl a
inc a
ld l,a
jr ihs1z

ihs1b:
cp snd_plyr_lostlife
jr nz,ihs1c

call sfx_noise_off

ld a,(hl)
and 3
rrca
rrca
rrca
ld c,a
ld b,0

ld l,15
jr ihs1z

ihs1c:
cp snd_plyr_died
jr nz,ihs2

call sfx_noise_on

ld c,0
ld a,(hl)
rrca
ld b,a
ld a,127
sub b
ld b,a

ld l,(hl)
srl l
srl l
srl l
jr ihs1z


ihs2:
;--- enemy stuff ---
;
cp snd_enemy_shot
jr nz,ihs2b

call sfx_noise_off

ld a,(hl)
rlca
rlca
ld e,a
ld a,100
sub e
ld c,a
ld b,0
ld l,16
jr ihs1z

ihs2b:
cp snd_enemy_hit
jr nz,ihs2c

call sfx_noise_on

ld c,0
ld a,(hl)
rlca
ld b,a
ld a,255
sub b
ld b,a
ld l,15
jr ihs1z

ihs2c:
;must be snd_enemy_died

call sfx_noise_on

ld c,0
ld a,127-11
sub (hl)
ld b,a
ld a,(hl)
add a,11
rra	;nc from add
ld l,a

ihs1z:
;at this point, c=tone (low), b=tone (high), l=vol
ld e,c
ld d,chan_sfx*2
call aywrite
ld e,b
inc d
call aywrite
ld a,l
and &1f   ;Reset bits 5-7 of the volume, otherwise the Arnold emulator will
          ;crash!
ld e,a
ld d,chan_sfx+8
call aywrite

ld hl,snd_sfx_timeout
dec (hl)


ihs3:
pop hl
pop de
pop bc
pop af
ei
ret