/*Copyright 1995 by Michael Stroucken/Strouckensoft*/

/*cpc2x.c,v 2.0 1996/12/28 18:57:25 stroucki Rel*/

/*
 * cpc2x.c,v
 * Revision 2.0  1996/12/28 18:57:25  stroucki
 * Zweite berarbeitete Ausgabe
 *
 * Revision 1.2  1996/12/02  07:51:16  stroucki
 * Fehler verbessert, wo Farbdaten eingelesen wurden, als
 * die Datei schon geschlossen war.
 * Laeuft jetzt auch auf CP/M, aber braucht viel Speicher.
 *
 * Revision 1.1  1996/11/13  07:54:12  stroucki
 * Programm zum grossen Teil lesbarer gemacht.
 * Auf Unices zum Laufen gebracht
 *
 * Revision 1.0  1995/06/03  03:56:39  mxsst1
 * Initial revision
 **/

/*2.6.95 / 23.56*/

#define VERSION "2.0"
#define SEEK_SET 0
#define SEEK_CUR 1
#define SEEK_END 2
#define ERRNOT "Cannot "
#define ERRMALL "allocate memory"
#define ERROPENF "open file for "
#define ERRWRIT	"writing"
#define ERRREAD "reading"

#include <stdio.h>
#include <stdlib.h>			/*For malloc,free*/

#ifdef LOMEM
#include <unistd.h>			/*For unlink*/
#endif
FILE *infile, *outfile;
unsigned char mode,header,filetype;
unsigned char *bitmap;
unsigned int pos=0,size=0,colour[27][3];
unsigned int col,row;
unsigned char palette[16]={1,24,20,6,26,0,2,8,10,12,14,16,18,22,0,0};
/* Normale Systempalette, wobei die letzten mit blau/gelb blinkend und */
/* rosa/himmelblau belegt sind */
char hard2soft[32]={13,27,19,25,1,7,10,16,28,29,24,26,6,8,15,17,30,31,18,20,0,2,9,11,4,22,21,23,3,5,12,14};

#ifdef TIFF
#define OUTTYPE "TIFF"
#endif

#ifdef GIF
#define OUTTYPE "GIF" 
#define bpp 4
#define codesize bpp+1
#define clearcode 1<<bpp
#define endcode (clearcode)+1
#define mincode (endcode)+1
#define maxcode (clearcode)<<1

unsigned char puff[255],fontname[20];
unsigned int child[4096],sib[4096],shade[4096];
unsigned int nvc,parent,ccolour,son,bro,ppos;
unsigned int cs=codesize;
#endif

void putword(unsigned int word, FILE* towhere) {
	/*Force little-endian words for this TIFF-Format*/
	putc(word,towhere);
	putc(word>>8,towhere);
	}

void putdword(unsigned long word, FILE* towhere) {
	putword(word,towhere);
	putword(word>>16,towhere);
	}

void setpalette(char type) {
	char ctr,hc;
	if (type==1) { /*multiface*/
		printf("I believe this is a Multiface II file...\n");
		fseek(infile,0x40e8,SEEK_SET);
		for(ctr=0;ctr<16;ctr++) {
			fscanf(infile,"%c",&hc);
			palette[ctr]=hard2soft[hc];
			}
		fseek(infile,0x4108,SEEK_SET);
		if (mode==0xff) {
			fscanf(infile,"%c",&mode);
			mode=mode & 3;
			} else
			printf("Ignoring mode stored in file...\n");
		}
	}

#ifdef GIF
void dump() {				/*Flush buffer*/
	int temp;
	putc(ppos,outfile); /*block size*/
	for(temp=0;temp<ppos;temp++) putc(puff[temp],outfile);
	ppos=0;
	}

void queue(unsigned int what) {		/*Stack up bits and insert in buffer*/
	static unsigned int streampos;
	static unsigned long streamchar;	/*need >16 bits here*/
	streamchar|=((unsigned long)what<<streampos);
	streampos+=cs;
	while(streampos>7) {
		puff[ppos]=streamchar;ppos++;streampos-=8;
		streamchar>>=8;if (ppos==255) dump();
		}
	}

void init() {				/*Preparations*/
	int t;
	for(t=0;t<4096;t++) child[t]=sib[t]=0;
	queue(clearcode);
	nvc=mincode;cs=codesize;
	ccolour=parent=son=bro=0;
	}
#endif

void initcolour() { /*blau,rot,gruen*/
	char temp;
	unsigned int intens[3];
	intens[0]=0;intens[1]=32767;intens[2]=65535;
	for(temp=0;temp<27;temp++) {
		colour[temp][2]=intens[temp%3];
		colour[temp][0]=intens[(temp/3)%3];
		colour[temp][1]=intens[(temp/9)%3];
		}
	}

char getcolour() {
	static unsigned char temp=0,bitptr=0,xv=0;
	unsigned char colour;
	if (!bitptr) {
#ifdef LOMEM
		temp=(unsigned char)getc(infile);
#else
		pos=(row&7)*2048+80*(row>>3)+col;
/* Schei-Umrechnerei! */
		temp=bitmap[pos];
#endif
	}
	switch (mode) {
		case 2: /* 7,6,5,4,3,2,1,0 */
		if (!bitptr) bitptr=128;
		colour=(temp&bitptr)?1:0;
/*
		xv=!xv;
*/
		if (!xv) bitptr>>=1;
		break;

		case 1: /* 3,7,2,6,1,5,0,4 */
		if (!bitptr) bitptr=8;
		colour=((temp&bitptr)?2:0)|((temp&(bitptr<<4))?1:0);
		bitptr>>=1;
		break;

		case 0: /* 1,5,3,7,0,4,2,6 */
		if (!bitptr) bitptr=2;
		if ((bitptr==1) && (!xv)) temp<<=1;
		colour=((temp&2)?8:0)|((temp&32)?4:0);
		colour|=((temp&8)?2:0)|((temp&128)?1:0);
		xv=!xv;
		if (!xv) bitptr>>=1;
		break;
		}
	if (!bitptr) {
		col++;
		if (col==80) {
			col=0;
			row++;
			}
		}
	return colour;
	}

#ifdef TIFF
int writegraphic() {
	unsigned char temp;
	fprintf(outfile,"II");			/* intel format */
	putword('*',outfile);
	putdword(8,outfile);			/*header with ifd at 8*/

	/*8 -- ifd*/
	putword(13,outfile);			/*length*/
	putword(0x100,outfile);			/*imagewidth*/
	putword(3,outfile);			/*short*/
	putdword(1,outfile);			/*1*/
	temp=4>>mode;

	/*0x12,18 -- ifd*/
	switch (mode) {				/*for x-resolution*/
		case 0:
		case 1:
		putword(320,outfile);
		break;
		case 2:
		putword(640,outfile);
		}
	putword(0,outfile);

	/*0x16,22 -- ifd*/
	putword(0x101,outfile);			/*imagelength*/
	putword(3,outfile);			/*short*/
	putdword(1,outfile);			/*1*/
	putdword(200,outfile);			/*200 rows*/

	/*0x22,34 -- ifd*/
	putword(0x102,outfile);			/*bits per sample*/
	putword(3,outfile);			/*short*/
	putdword(1,outfile);			/*1*/
	putdword(4,outfile);			/*4 bits per sample*/

	/*0x2e,46 -- ifd*/
	putword(0x103,outfile);			/*compression*/
	putword(3,outfile);			/*short*/
	putdword(1,outfile);			/*1*/
	putdword(1,outfile);			/*no compression*/

	/*0x3a,58 -- ifd*/
	putword(0x106,outfile);			/*photometric interpret.*/
	putword(3,outfile);			/*short*/
	putdword(1,outfile);			/*1*/
	putdword(3,outfile);			/*palette colour*/

	/*0x46,70*/
	putword(0x111,outfile);			/*strip offsets*/
	putword(3,outfile);			/*short*/
	putdword(1,outfile);			/*1*/
	putdword(0x180,outfile);		/*start at 0x180*/

	/*
	Soll ich einen groߞen Streifen definieren, oder 200 kleine?
	*/

	/*0x52,82 -- ifd*/
	putword(0x116,outfile);			/*rows per strip*/
	putword(3,outfile);			/*short*/
	putdword(1,outfile);			/*1*/
	putdword(200,outfile);			/*200 rows per strip*/

	/*0x5e,94 -- ifd*/
	putword(0x117,outfile);			/*strip byte counts*/
	putword(3,outfile);			/*short*/
	putdword(1,outfile);			/*1*/
	if (mode==2) putdword(64000,outfile);	/*640/pixels per byte*/
		else putdword(32000,outfile);	/* *200 */

	/*0x6a,106 -- ifd*/
	putword(0x11a,outfile);			/*x resolution*/
	putword(5,outfile);			/*ratio*/
	putdword(1,outfile);			/*1*/
	putword(170,outfile);
	putword(0,outfile);

	/*0x76,118 -- ifd*/
	putword(0x11b,outfile);			/*y resolution*/
	putword(5,outfile);			/*ratio*/
	putdword(1,outfile);			/*1*/
	putword(178,outfile);
	putword(0,outfile);

	/*0x82,130 -- ifd*/
	putword(0x128,outfile);			/*resolution unit*/
	putword(3,outfile);			/*short*/
	putdword(1,outfile);			/*1*/
	putdword(3,outfile);			/*centimetres*/

	/*0x8e,142 -- ifd*/
	putword(0x131,outfile);			/*software*/
	putword(2,outfile);			/*ascii*/
	putdword(90,outfile);			/*90*/
	putdword(186,outfile);			/*offset for string*/

	/*0x9a,154 -- ifd*/
	putword(320,outfile);			/*colourmap*/
	putword(3,outfile);			/*short*/
	putdword(48,outfile);			/*48*/
	putdword(0x114,outfile);		/*map at 0x114*/

	/*0xa6,166 -- ifd*/
	putdword(0,outfile);			/*end of entries*/

	/*0xaa,170 -- aspect ratio*/
	/* 8/5 x 1 <-> 320 x 200 */
	putdword(8,outfile);putdword(5,outfile);

	/*0xb2,178*/
	putdword(1,outfile);putdword(1,outfile);

	/*0xba,186 -- program identifier*/
	fprintf(outfile,"CPC2TIF\n");
	/*c2,194*/
	fprintf(outfile,"This picture transferred from a CPC by\nCPC 2 TIFF\n");
	fprintf(outfile,"Written 1995 by Strouckensoft.\n%c",0);

	/*0x114,276 -- colour map*/
	for(col=0;col<3;col++) {		/*from red to blue*/
		for(row=0;row<16;row++) {	/*through all colours*/
			putword(colour[palette[row]][col],outfile);
			}
		}
	while (ftell(outfile)!=0x180) putword(0xe5e5,outfile);
	/*fill up space (makes debugging easier)*/

	/*0x180,384 -- bitmap*/
	/*image starts here*/
	row=col=0;
	while (row<200) {
		temp=getcolour()<<4;
		temp|=getcolour();
		putc(temp,outfile);
		}
	return 0;
	}
#endif

#ifdef GIF
void writegraphic() {			/*???*/
	int width;
	fprintf(outfile,"GIF87a");	/*Gif signature*/
	width=320<<((mode==2)?1:0);
	putc((char)width,outfile);	/*width low*/
	putc(width>>8,outfile);		/*width high*/
	putc((char)200,outfile);   	/*height low*/
	putc(200>>8,outfile);		/*height high*/
	putword(0xf3,outfile);		/*global colour, 4 bits/pix*/
	putc(0,outfile);		/*end descriptor*/
	for(row=0;row<16;row++) {	/*through all colours*/
		for(col=0;col<3;col++) {/*from red to blue*/
			putc(colour[palette[row]][col]>>8,outfile);
			}
		}
	putc(',',outfile);              /*image separator*/
	putdword(0,outfile);		/*Top left corner*/
	putc((char)width,outfile);	/*width low*/
	putc(width>>8,outfile);		/*width high*/
	putc((char)200,outfile);	/*height low*/
	putc(200>>8,outfile);		/*height high*/
	putc(3,outfile); /*global colour map, sequential, 4 bpp*/
	putc(bpp,outfile); /*bits per pixel*/

	init();				/*The encoding mechanism is taken*/
	row=col=0;			/*from Bob Montgomery's flowchart*/
					/*"GIF Encoder" dated 21 Jan 88*/ 
	parent=getcolour();
p1:
	if(row==200) goto end;
	ccolour=getcolour();
	son=child[parent];
	if (son) goto p2; else goto p3;

p2:
	if (shade[son]==ccolour) goto p9; else {
		bro=son;
		goto p5;
		}

p3:
	child[parent]=nvc;
	shade[nvc]=ccolour;
	queue(parent);
	parent=ccolour;
	nvc++;

p4:
	cs+=(nvc>(1<<cs))?1:0;		 /*I think this is cool!*/
	if(nvc==4096) init();
	goto p1;

p5:
	if(sib[bro]) {
		bro=sib[bro];
		goto p8;
		} else goto p7;

p7:
		sib[bro]=nvc;
		shade[nvc]=ccolour;
		queue(parent);
		parent=ccolour;
		nvc++;
		goto p4;

p8:
	if(shade[bro]==ccolour) {
		parent=bro;
		goto p4;
		} else goto p5;

p9:
	parent=son;
	goto p4;

end:
	queue(parent);
	ccolour=cs;
	cs=7;queue(0);cs=ccolour;
	puff[ppos]=endcode;ppos++;
	if (ppos) dump();
	putword(0x3b00,outfile);
	}
#endif

int openin(char *filename) {
	unsigned int header=0;
	if (!(infile = fopen(filename, "rb"))) {
		fprintf(stderr, "%s%s%s.\n",ERRNOT,ERROPENF,ERRREAD);
		return 1;
		}
	fseek(infile,0,SEEK_END);
	size=ftell(infile);
	rewind(infile);
	filetype=0;
	if (size>16384) {
		header=128;
		} else {
		printf("Seems to be a headerless file...\n");
		}
	fseek(infile,header,SEEK_SET); /* skip header */
	bitmap=malloc(16384);
	if(!bitmap) {
		fprintf(stderr,"%s%s.\n",ERRNOT,ERRMALL);
		return 1;
		}
	while (pos<16384) {
		if (!feof(infile)) {
			bitmap[pos]=getc(infile);
			pos++;
			} else {
			bitmap[pos]=0;
			}
		}
	if (!feof(infile)) {
		fseek(infile,0x4000|header,SEEK_SET);
		filetype=getc(infile);
		}
#ifdef LOMEM
	printf("Using 16384 bytes of virtual memory...\n");
	if ((outfile = fopen("virtual.mem", "wb")) == NULL) {
		fprintf(stderr, "%s%s%s.\n",ERRNOT,ERROPENF,ERRWRIT);
		return 1;
		}
	rewind(outfile);
	for(row=0;row<200;row++) for(col=0;col<80;col++)
		putc(bitmap[(row&7)*2048+80*(row>>3)+col],outfile);
	fclose(outfile);		/*Close VM file*/
	free(bitmap);			/*Free buffer memory*/
#endif
	return 0;
	}

int openout(char *after) {
	if ((outfile = fopen(after, "wb")) == NULL) {
		fprintf(stderr, "%s%s%s.\n",ERRNOT,ERROPENF,ERRWRIT);
		return 1;
		}
	rewind(outfile);
	return 0;
	}

int closeout() {
	fclose(outfile);
	return 0;
	}

int closein() {
	fclose(infile);
	return 0;
}

int main(int argc,char *argv[]) {
	printf("CPC2%s %s: Transforms a CPC screendump to a %s file.\n\
Written 1996 by Michael Stroucken/Strouckensoft\n"\
	,OUTTYPE,VERSION,OUTTYPE);
	mode=0xff;
	if (argc<3) {
		printf("Usage: %s <source> <destination> [mode]\n",argv[0]);
		return 255;
		}
	/*0x40e8*/
	if (argc==4) mode=((char)argv[3][0]-48)&3;
	printf("Opening %s...\n",argv[1]);
	if (openin(argv[1])) return 255;
	printf("Initialising colourmap...\n");
	initcolour();
	printf("Compiling palette...\n");
	if (filetype==0xf3) setpalette(1);
	if (mode==255) mode=1;		/*guess a mode*/
	mode=mode%3;			/*normalize mode*/
	printf("This is a mode %d picture...\n",mode);
	printf("Closing %s...\n",argv[1]);
	closein();
	printf("Opening %s...\n",argv[2]);
	if (openout(argv[2])) return 255;
	printf("Writing %s data into %s...\n",OUTTYPE,argv[2]);
#ifdef LOMEM
	infile=fopen("virtual.mem","rb");
#endif
	writegraphic();
#ifdef LOMEM
	fclose(infile);
	unlink("virtual.mem");
#endif
	printf("Closing %s...\n",argv[2]);
	closeout();
	printf("Done! Enjoy...\n");
	return 0;
	}
