#!/usr/local/bin/perl -- -*-perl-*-

# ------------------------------------------------------------
# indexsearch.cgi - Search RFC index for a regex
# Based on...
#
# submit_job.pl, by Kyle Hourihan
#   most Perl Code thanks to Reuven M. Lerner (reuven@the-tech.mit.edu).
#   modified by Eli Rosenblatt
#
# Last updated: 8/30/95
#
# job_input.pl allows a recruiter to post new jobs listings in 
# a WWW html form and outputs the response to a the server.
# This script requires Perl and should run on any CGI-compatible 
# HTTP server.
# 
# ------------------------------------------------------------

# ------------------------------------------------------------

# job_post.pl is free software; you can redistribute it and/or modify it
# under the terms of the GNU General Public License as published by the
# Free Software Foundation; either version 2, or (at your option) any
# later version.


# You should have received a copy of the GNU General Public License
# along with Form-mail; see the file COPYING.  If not, write to the Free
# Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
# ------------------------------------------------------------

# NOTE:  Check the variables below the splits() for server specific paths 


# Get the input
read(STDIN, $buffer, $ENV{'CONTENT_LENGTH'});

# Split the name-value pairs
@pairs = split(/&/, $buffer);

foreach $pair (@pairs)
{
    ($name, $value) = split(/=/, $pair);

    # Un-Webify plus signs and %-encoding
    $value =~ tr/+/ /;
    $value =~ s/%([a-fA-F0-9][a-fA-F0-9])/pack("C", hex($1))/eg;

    # Stop people from using subshells to execute commands
    # Not a big deal when using sendmail, but very important
    # when using UCB mail (aka mailx).
    # $value =~ s/~!/ ~!/g; 
    # Uncomment for debugging purposes
    # print "Setting $name to $value<P>";

    $FORM{$name} = $value;
}

$Target = "indextable";
$RegEx = $FORM{SEARCH_STRING};
$RegEx = " " if $RegEx eq "";

$Command = "grep";
$Command = "fgrep" if ($FORM{TYPE} eq "STRING");

@Options = ();
@Options = (@Options, "-i") if $FORM{CASE_INDEPENDANT} eq "on";
@Options = (@Options, "-w") if $FORM{WHOLE_WORD} eq "on" && $FORM{TYPE} ne "STRING";


# Print out a content-type for HTTP/1.0 compatibility
print "Content-type: text/html\n\n";

print "<HTML>\n";
print "<HEAD>\n";
print "<TITLE>RFC Index Search: $RegEx</TITLE>\n";
print "</HEAD>\n";
print "<BODY>\n";
print "<CENTER><H3>RFC Index Search: $RegEx</H3></CENTER><P>\n";
print "<TABLE>\n";

# The next command is more or less this, but for security reasons
# I don't want shell metacharaters interpreted in $RegEx
#
# system("[f]grep $Options $RegEx $Target |");

@Targets = <${Target}>;
@Command = ($Command, @Options, $RegEx, @Targets);
$| = 1;  print "\n";
system @Command;

print "</TABLE>\n";
print "</BODY>\n";
print "</HTML>\n";
