#ifndef __ATARI__
#define	__ATARI__

#include	"system.h"

#define	ATARI_WIDTH	(384)
#define	ATARI_HEIGHT	(192 + 24 + 24)
#define	ATARI_TITLE	"Atari 800 Emulator, Version 0.1.6"

enum ESCAPE
{
	ESC_SIO,
	ESC_E_OPEN,
	ESC_E_CLOSE,
	ESC_E_READ,
	ESC_E_WRITE,
	ESC_E_STATUS,
	ESC_E_SPECIAL,
	ESC_K_OPEN,
	ESC_K_CLOSE,
	ESC_K_READ,
	ESC_K_WRITE,
	ESC_K_STATUS,
	ESC_K_SPECIAL,
	ESC_H_OPEN,
	ESC_H_CLOSE,
	ESC_H_READ,
	ESC_H_WRITE,
	ESC_H_STATUS,
	ESC_H_SPECIAL
};

/*
	=======================================
	Define CIOV Input Output Control Blocks
	=======================================
*/

#define	OPEN		0x03
#define	GETREC		0x05
#define	GETCHR		0x07
#define	PUTREC		0x09
#define	PUTCHR		0x0b
#define	CLOSE		0x0c
#define	STATUS		0x0d

/*
	==================
	Hardware Registers
	==================
*/

extern UBYTE	ALLPOT;
extern UBYTE	AUDC1;
extern UBYTE	AUDC2;
extern UBYTE	AUDC3;
extern UBYTE	AUDC4;
extern UBYTE	AUDCTL;
extern UBYTE	AUDF1;
extern UBYTE	AUDF2;
extern UBYTE	AUDF3;
extern UBYTE	AUDF4;
extern UBYTE	CHACTL;
extern UBYTE	CHBASE;
extern UBYTE	COLBK;
extern UBYTE	COLPF0;
extern UBYTE	COLPF1;
extern UBYTE	COLPF2;
extern UBYTE	COLPF3;
extern UBYTE	COLPM0;
extern UBYTE	COLPM1;
extern UBYTE	COLPM2;
extern UBYTE	COLPM3;
extern UBYTE	CONSOL;
extern UBYTE	DLISTH;
extern UBYTE	DLISTL;
extern UBYTE	DMACTL;
extern UBYTE	GRACTL;
extern UBYTE	GRAFM;
extern UBYTE	GRAFP0;
extern UBYTE	GRAFP1;
extern UBYTE	GRAFP2;
extern UBYTE	GRAFP3;
extern UBYTE	HITCLR;
extern UBYTE	HPOSM0;
extern UBYTE	HPOSM1;
extern UBYTE	HPOSM2;
extern UBYTE	HPOSM3;
extern UBYTE	HPOSP0;
extern UBYTE	HPOSP1;
extern UBYTE	HPOSP2;
extern UBYTE	HPOSP3;
extern UBYTE	HSCROL;
extern UBYTE	IRQEN;
extern UBYTE	IRQST;
extern UBYTE	KBCODE;
extern UBYTE	M0PF;
extern UBYTE	M0PL;
extern UBYTE	M1PF;
extern UBYTE	M1PL;
extern UBYTE	M2PF;
extern UBYTE	M2PL;
extern UBYTE	M3PF;
extern UBYTE	M3PL;
extern UBYTE	NMIEN;
extern UBYTE	NMIRES;
extern UBYTE	NMIST;
extern UBYTE	P0PF;
extern UBYTE	P0PL;
extern UBYTE	P1PF;
extern UBYTE	P1PL;
extern UBYTE	P2PF;
extern UBYTE	P2PL;
extern UBYTE	P3PF;
extern UBYTE	P3PL;
extern UBYTE	PACTL;
extern UBYTE	PAL;
extern UBYTE	PBCTL;
extern UBYTE	PENH;
extern UBYTE	PENV;
extern UBYTE	PMBASE;
extern UBYTE	PORTA;
extern UBYTE	PORTB;
extern UBYTE	POT0;
extern UBYTE	POT1;
extern UBYTE	POT2;
extern UBYTE	POT3;
extern UBYTE	POT4;
extern UBYTE	POT5;
extern UBYTE	POT6;
extern UBYTE	POT7;
extern UBYTE	POTGO;
extern UBYTE	PRIOR;
extern UBYTE	RANDOM;
extern UBYTE	SERIN;
extern UBYTE	SEROUT;
extern UBYTE	SIZEM;
extern UBYTE	SIZEP0;
extern UBYTE	SIZEP1;
extern UBYTE	SIZEP2;
extern UBYTE	SIZEP3;
extern UBYTE	SKCTL;
extern UBYTE	SKREST;
extern UBYTE	SKSTAT;
extern UBYTE	STIMER;
extern UBYTE	TRIG0;
extern UBYTE	TRIG1;
extern UBYTE	TRIG2;
extern UBYTE	TRIG3;
extern UBYTE	VCOUNT;
extern UBYTE	VDELAY;
extern UBYTE	VSCROL;
extern UBYTE	WSYNC;

/*
	=================
	Joystick Position
	=================
*/

#define	STICK_LL	0x09;
#define	STICK_BACK	0x0d;
#define	STICK_LR	0x05;
#define	STICK_LEFT	0x0b;
#define	STICK_CENTRE	0x0f;
#define	STICK_RIGHT	0x07;
#define	STICK_UL	0x0a;
#define	STICK_FORWARD	0x0e;
#define	STICK_UR	0x06;

/*
	=================================================================
	Defines return values to be used by the various keyboard handlers
	=================================================================
*/

typedef enum
{
	AKEY_NONE = -1,
	AKEY_WARMSTART = 256,
	AKEY_COLDSTART,
	AKEY_EXIT,
	AKEY_OPTION,
	AKEY_SELECT,
	AKEY_START,
	AKEY_HELP,
	AKEY_BREAK,
	AKEY_PIL,
	AKEY_DISKCHANGE,
	AKEY_DOWN,
	AKEY_LEFT,
	AKEY_RIGHT,
	AKEY_UP,
	AKEY_BACKSPACE,
	AKEY_ESCAPE,
	AKEY_ATARI,
	AKEY_CAPSLOCK,
	AKEY_CAPSTOGGLE,
	AKEY_RETURN,

	AKEY_CTRL_A,
	AKEY_CTRL_B,
	AKEY_CTRL_C,
	AKEY_CTRL_D,
	AKEY_CTRL_E,
	AKEY_CTRL_F,
	AKEY_CTRL_G,
	AKEY_CTRL_H,
	AKEY_CTRL_I,
	AKEY_CTRL_J,
	AKEY_CTRL_K,
	AKEY_CTRL_L,
	AKEY_CTRL_M,
	AKEY_CTRL_N,
	AKEY_CTRL_O,
	AKEY_CTRL_P,
	AKEY_CTRL_Q,
	AKEY_CTRL_R,
	AKEY_CTRL_S,
	AKEY_CTRL_T,
	AKEY_CTRL_U,
	AKEY_CTRL_V,
	AKEY_CTRL_W,
	AKEY_CTRL_X,
	AKEY_CTRL_Y,
	AKEY_CTRL_Z,

	AKEY_CTRL_0,
	AKEY_CTRL_1,
	AKEY_CTRL_2,
	AKEY_CTRL_3,
	AKEY_CTRL_4,
	AKEY_CTRL_5,
	AKEY_CTRL_6,
	AKEY_CTRL_7,
	AKEY_CTRL_8,
	AKEY_CTRL_9,
} AtariKey;

/*
	==========================
	Define Function Prototypes
	==========================
*/

void	initialise_os ();
void	add_esc (UWORD address, UBYTE esc_code);
void	A800_RUN (void);
void	ESC (UBYTE esc_code);

#endif
