#include	<vga.h>
#include	<vgagl.h>

#include	"atari.h"

extern int	colortable[128];

static int	trig0;
static int	stick0;

void Atari_Initialise ()
{
	int	VGAMODE = G320x200x256;
	int	i;

	vga_init ();

	if (!vga_hasmode(VGAMODE))
	{
		printf ("Mode not available\n");
		exit (1);
	}

	vga_setmode (VGAMODE);

	gl_setcontextvga (VGAMODE);

	for (i=0;i<128;i++)
	{
		int	rgb = colortable[i];
		int	red;
		int	green;
		int	blue;

		red = (rgb & 0x00ff0000) >> 18;
		green = (rgb & 0x0000ff00) >> 10;
		blue = (rgb & 0x000000ff) >> 2;

		gl_setpalettecolor (i+i, red, green, blue);
		gl_setpalettecolor (i+i+1, red, green, blue);
	}
}

void Atari_Exit ()
{
	vga_setmode (TEXT);
}

extern UWORD	scanline[ATARI_WIDTH];
extern int	ypos;

static UBYTE	*svga_ptr;

void Atari_PreUpdate ()
{
	svga_ptr = graph_mem;
}

void Atari_PostUpdate ()
{
}

void Atari_ScanLine ()
{
	UWORD	*pixel_ptr;
	int	xpos;

	UBYTE	temp[16];

	if ((ypos < 24) || (ypos >= (ATARI_HEIGHT-24))) return;

	temp[0] = COLBK;
	temp[1] = COLPF0;
	temp[2] = COLPF1;
	temp[3] = COLBK;
	temp[4] = COLPF2;
	temp[5] = COLBK;
	temp[6] = COLBK;
	temp[7] = COLBK;
	temp[8] = COLPF3;
	temp[9] = COLBK;
	temp[10] = COLBK;
	temp[11] = COLBK;
	temp[12] = COLBK;
	temp[13] = COLBK;
	temp[14] = COLBK;
	temp[15] = COLBK;

	pixel_ptr = &scanline[32];
	for (xpos=32;xpos<ATARI_WIDTH-32;xpos++)
	{
		UWORD	pixel;
		UBYTE	playfield;
		UBYTE	colour;

		pixel = *pixel_ptr++;
		playfield = pixel & 0x000f;
		colour = temp[playfield];

		if (pixel & 0xff00)
		{
			UBYTE	player;

			player = (pixel >> 8) & 0x000f;

			if (pixel & 0xf000)
			{
				if (pixel & 0x8000)
				{
					M3PF |= playfield;
					M3PL |= player;
					colour = COLPM3;
				}

				if (pixel & 0x4000)
				{
					M2PF |= playfield;
					M2PL |= player;
					colour = COLPM2;
				}

				if (pixel & 0x2000)
				{
					M1PF |= playfield;
					M1PL |= player;
					colour = COLPM1;
				}

				if (pixel & 0x1000)
				{
					M0PF |= playfield;
					M0PL |= player;
					colour = COLPM0;
				}
/*
	==========================
	Handle fifth player enable
	==========================
*/
				if (PRIOR & 0x10)
				{
					colour = COLPF3;
				}
			}

			if (pixel & 0x0f00)
			{
				if (pixel & 0x0800)
				{
					P3PF |= playfield;
					P3PL |= player;
					colour = COLPM3;
				}

				if (pixel & 0x0400)
				{
					P2PF |= playfield;
					P2PL |= player;
					colour = COLPM2;
				}

				if (pixel & 0x0200)
				{
					P1PF |= playfield;
					P1PL |= player;
					colour = COLPM1;
				}

				if (pixel & 0x0100)
				{
					P0PF |= playfield;
					P0PL |= player;
					colour = COLPM0;
				}
			}
		}

		*svga_ptr++ = colour;
	}
}

int Atari_Keyboard (void)
{
	int	keycode;

	trig0 = 0x10;

	keycode = vga_getkey();

	switch (keycode)
	{
		case 0x01 :
			keycode = AKEY_CTRL_A;
			break;
		case 0x02 :
			keycode = AKEY_CTRL_B;
			break;
/*
		case 0x03 :
			keycode = AKEY_CTRL_C;
			break;
*/
		case 0x04 :
			keycode = AKEY_CTRL_D;
			break;
		case 0x05 :
			keycode = AKEY_CTRL_E;
			break;
		case 0x06 :
			keycode = AKEY_CTRL_F;
			break;
		case 0x07 :
			keycode = AKEY_CTRL_G;
			break;
		case 0x08 :
			keycode = AKEY_CTRL_H;
			break;
		case 0x09 :
			keycode = AKEY_CTRL_I;
			break;
/*
		case 0x0a :
			keycode = AKEY_CTRL_J;
			break;
*/
		case 0x0b :
			keycode = AKEY_CTRL_K;
			break;
		case 0x0c :
			keycode = AKEY_CTRL_L;
			break;
/*
		case 0x0d :
			keycode = AKEY_CTRL_M;
			break;
*/
		case 0x0e :
			keycode = AKEY_CTRL_N;
			break;
		case 0x0f :
			keycode = AKEY_CTRL_O;
			break;
		case 0x10 :
			keycode = AKEY_CTRL_P;
			break;
		case 0x11 :
			keycode = AKEY_CTRL_Q;
			break;
		case 0x12 :
			keycode = AKEY_CTRL_R;
			break;
		case 0x13 :
			keycode = AKEY_CTRL_S;
			break;
		case 0x14 :
			keycode = AKEY_CTRL_T;
			break;
		case 0x15 :
			keycode = AKEY_CTRL_U;
			break;
		case 0x16 :
			keycode = AKEY_CTRL_V;
			break;
		case 0x17 :
			keycode = AKEY_CTRL_W;
			break;
		case 0x18 :
			keycode = AKEY_CTRL_X;
			break;
		case 0x19 :
			keycode = AKEY_CTRL_Y;
			break;
		case 0x1a :
			keycode = AKEY_CTRL_Z;
			break;
		case '`' :
			keycode = AKEY_CAPSTOGGLE;
			break;
		case '!' :
		case '"' :
		case '#' :
		case '$' :
		case '%' :
		case '&' :
		case '\'' :
		case '@' :
		case '(' :
		case ')' :
		case '<' :
		case '>' :
		case '=' :
		case '?' :
		case '-' :
		case '+' :
		case '*' :
		case '/' :
		case ':' :
		case ';' :
		case ',' :
		case '.' :
		case '_' :
		case '{' :
		case '}' :
		case '^' :
		case '\\' :
		case '|' :
		case '0' : case '1' : case '2' : case '3' : case '4' :
		case '5' : case '6' : case '7' : case '8' : case '9' :
		case ' ' :
		case 'a' : case 'A' :
		case 'b' : case 'B' :
		case 'c' : case 'C' :
		case 'd' : case 'D' :
		case 'e' : case 'E' :
		case 'f' : case 'F' :
		case 'g' : case 'G' :
		case 'h' : case 'H' :
		case 'i' : case 'I' :
		case 'j' : case 'J' :
		case 'k' : case 'K' :
		case 'l' : case 'L' :
		case 'm' : case 'M' :
		case 'n' : case 'N' :
		case 'o' : case 'O' :
		case 'p' : case 'P' :
		case 'q' : case 'Q' :
		case 'r' : case 'R' :
		case 's' : case 'S' :
		case 't' : case 'T' :
		case 'u' : case 'U' :
		case 'v' : case 'V' :
		case 'w' : case 'W' :
		case 'x' : case 'X' :
		case 'y' : case 'Y' :
		case 'z' : case 'Z' :
			break;
		case 0x7f :	/* Backspace */
			keycode = AKEY_BACKSPACE;
			break;
		case '\n' :
			keycode = AKEY_RETURN;
			break;
		case 0x1b :
			{
				char	buff[10];
				int	nc;

				nc = 0;
				while (((keycode = vga_getkey()) != 0) && (nc < 8))
					buff[nc++] = keycode;
				buff[nc++] = '\0';

				if (strcmp(buff, "\133\133\101") == 0)		/* F1 */
				{
					keycode = AKEY_WARMSTART;
				}
				else if (strcmp(buff, "\133\133\102") == 0)	/* F2 */
				{
					keycode = AKEY_OPTION;
				}
				else if (strcmp(buff, "\133\133\103") == 0)	/* F3 */
				{
					keycode = AKEY_SELECT;
				}
				else if (strcmp(buff, "\133\133\104") == 0)	/* F4 */
				{
					keycode = AKEY_START;
				}
				else if (strcmp(buff, "\133\133\105") == 0)	/* F5 */
				{
					keycode = AKEY_COLDSTART;
				}
				else if (strcmp(buff, "\133\061\067\176") == 0)	/* F6 */
				{
					keycode = AKEY_PIL;
				}
				else if (strcmp(buff, "\133\061\070\176") == 0)	/* F7 */
				{
					keycode = AKEY_BREAK;
				}
				else if (strcmp(buff, "\133\061\071\176") == 0)	/* F8 */
				{
					keycode = AKEY_NONE;
				}
				else if (strcmp(buff, "\133\062\060\176") == 0)	/* F9 */
				{
					keycode = AKEY_EXIT;
				}
				else if (strcmp(buff, "\133\062\061\176") == 0)	/* F10 */
				{
					keycode = AKEY_NONE;
				}
				else if (strcmp(buff, "\133\062\063\176") == 0)	/* F11 */
				{
					keycode = AKEY_NONE;
				}
				else if (strcmp(buff, "\133\062\064\176") == 0)	/* F12 */
				{
					keycode = AKEY_NONE;
				}
				else if (strcmp(buff, "\133\062\176") == 0)	/* Keypad 0 */
				{
					trig0 = 0x00;
					keycode = AKEY_NONE;
				}
				else if (strcmp(buff, "\133\064\176") == 0)	/* Keypad 1 */
				{
					stick0 = STICK_LL;
					keycode = AKEY_NONE;
				}
				else if (strcmp(buff, "\133\102") == 0)		/* Keypad 2 */
				{
					stick0 = STICK_BACK;
					keycode = AKEY_NONE;
				}
				else if (strcmp(buff, "\133\066\176") == 0)	/* Keypad 3 */
				{
					stick0 = STICK_LR;
					keycode = AKEY_NONE;
				}
				else if (strcmp(buff, "\133\104") == 0)		/* Keypad 4 */
				{
					stick0 = STICK_LEFT;
					keycode = AKEY_NONE;
				}
				else if (strcmp(buff, "\133\107") == 0)		/* Keypad 5 */
				{
					stick0 = STICK_CENTRE;
					keycode = AKEY_NONE;
				}
				else if (strcmp(buff, "\133\103") == 0)		/* Keypad 6 */
				{
					stick0 = STICK_RIGHT;
					keycode = AKEY_NONE;
				}
				else if (strcmp(buff, "\133\061\176") == 0)	/* Keypad 7 */
				{
					stick0 = STICK_UL;
					keycode = AKEY_NONE;
				}
				else if (strcmp(buff, "\133\101") == 0)		/* Keypad 8 */
				{
					stick0 = STICK_FORWARD;
					keycode = AKEY_NONE;
				}
				else if (strcmp(buff, "\133\065\176") == 0)	/* Keypad 9 */
				{
					stick0 = STICK_UR;
					keycode = AKEY_NONE;
				}
				else
				{
					int	i;
#ifdef DEBUG
					printf ("Unknown key: 0x1b ");
					for (i=0;i<nc;i++) printf ("0x%02x ", buff[i]);
					printf ("\n");
#endif
					keycode = AKEY_NONE;
				}
			}
			break;
		default :
#ifdef DEBUG
			printf ("Unknown Keycode: %d\n", keycode);
#endif
		case 0 :
			keycode = AKEY_NONE;
			break;
	}

	return keycode;
}

int Atari_Joystick (int num)
{
	int	stick;

	if (num == 0)
	{
		stick = trig0 | stick0;
	}
	else
	{
		stick = 0x1f;	/* Central + Trigger not pressed */
	}

	return stick;
}

int Atari_Paddle (int num)
{
	return 0x100;
}
