#ifndef CPU_INCLUDED

#include	"system.h"

typedef struct CPU_Status
{
	UWORD	PC;
	UBYTE	A;
	UBYTE	S;
	UBYTE	X;
	UBYTE	Y;
	struct Flags
	{
		unsigned int	N : 1;
		unsigned int	V : 1;
		unsigned int	B : 1;
		unsigned int	D : 1;
		unsigned int	I : 1;
		unsigned int	Z : 1;
		unsigned int	C : 1;
	} flag;
} CPU_Status;

void	CPU_Reset (void);
void	CPU_GetStatus (CPU_Status *cpu_status);
void	CPU_PutStatus (CPU_Status *cpu_status);
int	GO (void);

#define	RAM		0
#define	ROM		1
#define	HARDWARE	2

extern UBYTE	memory[65536];
extern UBYTE	attrib[65536];

extern void  (*Escape)   (UBYTE code);

#define	NMI_MASK	0x01
#define	IRQ_MASK	0x02

extern int	INTERRUPT;
extern int	ncycles;

#endif
