#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>

static char *rcsid = "$Id: configure.c,v 1.1 1996/02/05 18:16:21 david Exp $";

void RemoveLF (char *string)
{
  int len;

  len = strlen (string);
  if (string[len-1] == '\n')
    string[len-1] = '\0';
}

void GetString (char *message, char *string)
{
  char gash[128];

  printf (message, string);
  gets (gash);
  if (strlen(gash) > 0)
    strcpy (string, gash);
}

void YesNo (char *message, char *yn)
{
  char gash[128];
  char t_yn;

  do
    {
      printf (message, *yn);
      gets (gash);

      if (strlen(gash) > 0)
	t_yn = gash[0];
      else
	t_yn = ' ';

      if (islower(t_yn))
	t_yn = toupper(t_yn);
    } while ((t_yn != ' ') && (t_yn != 'Y') && (t_yn != 'N'));

  if (t_yn != ' ')
    *yn = t_yn;
}

int main (void)
{
  FILE *fp;
  char config_filename[256];
  char *home;

  char disk_dir[256];
  char h1_dir[256];
  char h2_dir[256];
  char h3_dir[256];
  char h4_dir[256];
  char print_command[256];

  home = getenv ("~");
  if (!home)
    home = getenv ("HOME");
  if (!home)
    home = ".";

  sprintf (config_filename, "%s/.atari800", home);

  fp = fopen (config_filename, "r");
  if (fp)
    {
      printf ("\nReading: %s\n\n", config_filename);

      fgets (disk_dir, 256, fp);
      RemoveLF (disk_dir);

      fgets (h1_dir, 256, fp);
      RemoveLF (h1_dir);

      fgets (h2_dir, 256, fp);
      RemoveLF (h2_dir);

      fgets (h3_dir, 256, fp);
      RemoveLF (h3_dir);

      fgets (h4_dir, 256, fp);
      RemoveLF (h4_dir);

      fgets (print_command, 256, fp);
      RemoveLF (print_command);

      fclose (fp);
    }
  else
    {
      strcpy (disk_dir, "/usr/local/lib/atari/DISKS");
      strcpy (h1_dir, "/usr/local/lib/atari/H1");
      strcpy (h2_dir, "/usr/local/lib/atari/H2");
      strcpy (h3_dir, "/usr/local/lib/atari/H3");
      strcpy (h4_dir, "/usr/local/lib/atari/H4");
      strcpy (print_command, "lpr %s");
    }

  GetString ("Enter path for disk images [%s] ", disk_dir);
  GetString ("Enter path for H1: device [%s] ", h1_dir);
  GetString ("Enter path for H2: device [%s] ", h2_dir);
  GetString ("Enter path for H3: device [%s] ", h3_dir);
  GetString ("Enter path for H4: device [%s] ", h4_dir);
  GetString ("Enter command to print file [%s] ", print_command);

  fp = fopen ("config.h", "w");
  if (fp)
    {
      fprintf (fp, "#ifndef __CONFIG__\n");
      fprintf (fp, "#define __CONFIG__\n");

      fprintf (fp, "#define ATARI_DISK_DIR \"%s\"\n", disk_dir);
      fprintf (fp, "#define ATARI_H1_DIR \"%s\"\n", h1_dir);
      fprintf (fp, "#define ATARI_H2_DIR \"%s\"\n", h2_dir);
      fprintf (fp, "#define ATARI_H3_DIR \"%s\"\n", h3_dir);
      fprintf (fp, "#define ATARI_H4_DIR \"%s\"\n", h4_dir);
      fprintf (fp, "#define PRINT_COMMAND \"%s\"\n", print_command);

      fprintf (fp, "#endif\n");

      fclose (fp);
    }

  fp = fopen (config_filename, "w");
  if (fp)
    {
      printf ("\nWriting: %s\n\n", config_filename);

      fprintf (fp, "%s\n", disk_dir);
      fprintf (fp, "%s\n", h1_dir);
      fprintf (fp, "%s\n", h2_dir);
      fprintf (fp, "%s\n", h3_dir);
      fprintf (fp, "%s\n", h4_dir);
      fprintf (fp, "%s\n", print_command);

      fclose (fp);
    }
  else
    {
      perror (config_filename);
      exit (1);
    }

  return 0;
}
