;crc32 version 1.0 for the C-128 and C-64 by Craig Bruce 23-May-92

.mem
.bank 15
.org $1c01

.byte $2c,$1c,$0a,$00,$8b,$20,$c2,$28,$36,$35,$35,$33,$34,$29,$b2,$32
.byte $33,$20,$a7,$20,$9e,$20,$c2,$28,$34,$35,$29,$aa,$32,$35,$36,$ac
.byte $c2,$28,$34,$36,$29,$aa,$37,$31,$3a,$80,$00,$45,$1c,$14,$00,$9e
.byte $20,$c2,$28,$34,$33,$29,$aa,$32,$35,$36,$ac,$c2,$28,$34,$34,$29
.byte $aa,$37,$31,$00,$00,$00,$00

stringBase = 2  ;(2)
crcAccum = 4    ;(4)
filenameLen = 8 ;(1)
device = 9      ;(1)
ch = 10         ;(1)
itoaBin = crcAccum
itoaBcd = 11    ;(5)
itoaFlag = 2    ;(1)

crcLow  = $b7
crcMid1 = $1d
crcMid2 = $c1
crcHigh = $04

kernelSetlfs = $ffba
kernelSetnam = $ffbd
kernelOpen   = $ffc0
kernelClose  = $ffc3
kernelChkin  = $ffc6
kernelClrchn = $ffcc
kernelChrin  = $ffcf
kernelChrout = $ffd2
filename = $200+40

   lda #$60
   sta stringBase
   sei
jsrLabel = *
   jsr stringBase
   tsx
   lda $100,x
   tay
   dex
   lda $100,x
   cli
   clc
   adc #stringStart-jsrLabel-2
   bcc +
   iny
+  sta stringBase
   sty stringBase+1
   clc
   bcc entry

stringStart = *

startMsg = *
   .asc "enter name of file to take crc32 of:"
   .byte 13,0

scanningMsg = *
   .byte 13,13
   .asc "scanning file...  "
   .byte 0

crcMsg = *
   .asc "crc32 = "
   .byte 0

entry = *
   lda 186
   sta device
   ldy #startMsg-stringStart
-  lda (stringBase),y
   beq +
   jsr kernelChrout
   iny
   bne -
+  ldy #0
-  jsr kernelChrin
   sta filename,y
   cmp #13
   beq +
   iny
   bne -
+  sty filenameLen
   ldy #scanningMsg-stringStart
-  lda (stringBase),y
   beq +
   jsr kernelChrout
   iny
   bne -

;***open file

+  ldx #<filename
   ldy #>filename
   lda filenameLen
   jsr kernelSetnam
   lda #1
   ldx device
   ldy #2
   jsr kernelSetlfs
   jsr kernelOpen
   bcc +
-  rts
+  ldx #1
   jsr kernelChkin
   bcs -
   ldx #3
   lda #0
-  sta crcAccum,x
   dex
   bpl -

;***scan file

nextChar = *
   jsr kernelChrin
   sta ch
   ldx #8

nextBit = *
   asl ch
   rol crcAccum+0
   rol crcAccum+1
   rol crcAccum+2
   rol crcAccum+3
   bcc +
   lda crcAccum+0 
   eor #crcLow
   sta crcAccum+0
   lda crcAccum+1
   eor #crcMid1
   sta crcAccum+1
   lda crcAccum+2 
   eor #crcMid2
   sta crcAccum+2
   lda crcAccum+3 
   eor #crcHigh
   sta crcAccum+3
+  dex
   bne nextBit
   bit $90
   bvc nextChar

;***close file

   jsr kernelClrchn
   lda #1
   jsr kernelClose
   ldy #crcMsg-stringStart
-  lda (stringBase),y
   beq +
   jsr kernelChrout
   iny
   bne -

;*** print out result

+  ldx #4
   lda #0
-  sta itoaBcd,x
   dex
   bpl -
   sta itoaFlag
   ldy #32
   sei
   sed

   itoaNextBit = *
   asl itoaBin+0
   rol itoaBin+1
   rol itoaBin+2
   rol itoaBin+3
   ldx #4
-  lda itoaBcd,x
   adc itoaBcd,x
   sta itoaBcd,x
   dex
   bpl -
   dey
   bne itoaNextBit
   cld
   cli
   ldx #0

nextBcd = *
   lda itoaBcd,x
   ;** print first digit
   pha
   lsr
   lsr
   lsr
   lsr
   cmp itoaFlag
   beq +
   ora #$30
   sta itoaFlag
   jsr kernelChrout

   ;** print second digit
+  pla
   and #$0f
   cmp itoaFlag
   beq +
   ora #$30
   sta itoaFlag
   jsr kernelChrout

+  inx
   cpx #5
   bcc nextBcd

;*** finish up

   lda itoaFlag
   bne +
   lda #"0"
   jsr kernelChrout
+  lda #13
   jsr kernelChrout
   rts
