/*
 * ACME - a crossassembler for producing 6502/65c02/65816 code.
 * Copyright (C) 1998 Marco Baye
 * Have a look at "acme.c" for further info
 */

#ifndef platform_H
#define platform_H

/*
 * Platform specific stuff (in this case, for Linux)
 */

typedef short       Sixteen;/* At least 16 bit */
typedef signed long Value;  /* At least 24 bit */

#define PLATFORM_VERSION "Ported to Linux by Jochen Kmietsch.\nCurrent maintainer Krzysztof Dabrowski aka BruSH/ElysiuM\n"
#define PORT_SWITCHES


/* Integer-to-character conversion routine */
#define PLATFORM_INT2CHAR(x)    \
  x ^= x >> 16;                 \
  x ^= x >>  8;                 \
  x &= 255

/* Closedown sequence */
#define PLATFORM_EXIT

/* Convert UNIX-style pathname to system-style pathname */
#define PLATFORM_CONVERTPATH(a)

/* Platform specific message output */
#define PLATFORM_MESSAGE(a, b)

/* Maximum length of filenames in sources */
#define LNFMAX          255

/* Maximum length of paths */
#define LNPMAX          4096

/* Setting the created files' types */
#define PLATFORM_SETFILETYPE(a, b)

/* Platform specific command line switches */
#define PLATFORM_SWITCHCODE

/*
 * Prototypes
 */
static void Platform_FindLib(void);

#endif
