/*
 * ACME - a crossassembler for producing 6502/65c02/65816 code.
 * Copyright (C) 1998 Marco Baye
 * Have a look at "acme.c" for further info
 */

/*
 * Initialisation
 */
static void DataTables_Init() {
  int a;

  /* Clear pointertable */
  for(a = 255; a >= 0; a--) pPointerTable[a] = NULL;
  for(a = KEY2COUNT_B-1; a >= 0; a--)/* link two-char strings (bytes) */
    DataTables_Next((ListItem *) &pKeyTable2_B[a], 2);
  for(a = KEY3COUNT_B-1; a >= 0; a--)/* link three-char strings (bytes) */
    DataTables_Next((ListItem *) &pKeyTable3_B[a], 3);
  for(a = KEY4COUNT_B-1; a >= 0; a--)/* link four-char strings (bytes) */
    DataTables_Next((ListItem *) &pKeyTable4_B[a], 4);
  for(a = KEY5COUNT_B-1; a >= 0; a--)/* link five-char strings (bytes) */
    DataTables_Next((ListItem *) &pKeyTable5_B[a], 5);

  for(a = KEY2COUNT_P-1; a >= 0; a--)/* link two-char strings (pointers) */
    DataTables_Next((ListItem *) &pKeyTable2_P[a], 2);
  for(a = KEY3COUNT_P-1; a >= 0; a--)/* link three-char strings (pointers) */
    DataTables_Next((ListItem *) &pKeyTable3_P[a], 3);
  for(a = KEY4COUNT_P-1; a >= 0; a--)/* link four-char strings (pointers) */
    DataTables_Next((ListItem *) &pKeyTable4_P[a], 4);
  for(a = KEY5COUNT_P-1; a >= 0; a--)/* link five-char strings (pointers) */
    DataTables_Next((ListItem *) &pKeyTable5_P[a], 5);
  for(a = KEY6COUNT_P-1; a >= 0; a--)/* link six-char strings (pointers) */
    DataTables_Next((ListItem *) &pKeyTable6_P[a], 6);
  for(a = KEY7COUNT_P-1; a >= 0; a--)/* link seven-char strings (pointers) */
    DataTables_Next((ListItem *) &pKeyTable7_P[a], 7);
  for(a = KEY8COUNT_P-1; a >= 0; a--)/* link eight-char strings (pointers) */
    DataTables_Next((ListItem *) &pKeyTable8_P[a], 8);
  for(a = KEY9COUNT_P-1; a >= 0; a--)/* link nine-char strings (pointers) */
    DataTables_Next((ListItem *) &pKeyTable9_P[a], 9);
  FillOutBuffer(0);
}

/*
 * Utility routine
 */
static void DataTables_Next(ListItem *p, int len) {
  ListItem *t;
  u_char    Hash = Struct_Hash(p, len);/* routine will use type *and* string */

#ifdef FDEBUG
  pHashTestTable[Hash]++;
#endif
  t = (ListItem *) &pPointerTable[Hash];/* point to first pointer */
  while(t->Next) {
    if((t->Next)->Hash > p->Hash) break;
    t = t->Next;
  }
  p->Next = t->Next;
  t->Next = p;
}
