/*
 * ACME - a crossassembler for producing 6502/65c02/65816 code.
 * Copyright (C) 1998 Marco Baye
 * Have a look at "acme.c" for further info
 */

/*
 * Main definitions
 */

#ifndef global_H
#define global_H

/* Macros for skipping a single space character */
#define        SKIPSPACE        if(GotByte   == ' ') GetByte()
#define NEXTANDSKIPSPACE        if(GetByte() == ' ') GetByte()

/* Definition of Nullpointer */
#ifndef NULL
#define NULL ((void *)0)
#endif

/* Definitions of boolean values */
#define FALSE   0
#define TRUE    1

/* Number of "global zone" */
#define NZONE_GLOBAL    0
/* Number of zone before first zone definition */
#define NZONE_START     1

/* Structure for linked list of segment data */
typedef struct SegmentStruct SegmentStruct;
struct SegmentStruct {
  SegmentStruct *Next;
  Value          Start;
  Value          Length;
};

/*
 * Prototypes
 */

SegmentStruct *pSegmentList;/* points to linked list of segment structures */

static int      hCodeTable_Now;/* Current translation table and its values */
enum {
  HCODETABLE_RAW,
  HCODETABLE_PET,
  HCODETABLE_SCR,
  HCODETABLE_FILE
};

static int      ffProgram = 0;/* Program flags variable and its bitfields */
/* Copyright and usage message has been shown */
#define FPROGRAM_INFOSHOWN      (1u << 0)

static int      ffPass;/* Pass flags and its bitfields */
/* Do stuff that only has to be done once (only in first pass) */
#define FPASSDOONCE     (1u << 0)
/* Show errors when values are undefined (only in additional pass) */
#define FPASSDOERROR    (1u << 1)

static int      ffRepeat = 0;/* Repetition flags variable and its bitfields */
/* File name for output was given */
#define FREPEAT_OUTFILECHOSEN   (1u << 0)
/* Produce label dump */
#define FREPEAT_DOLABELDUMP     (1u << 1)
/* Memory buffer has been initialised */
#define FREPEAT_MEMINIT         (1u << 2)

static int      lVerbosity = 0;/* Level of additional output */
static int      fMadeItem = FALSE;/* Global flag for list item lookup */
static int      VP_Work = FALSE;/* TRUE if value parser had work on top level */
static char     GotByte      ;/* Last byte read (processed) */
static char    *pnfTop       ;/* => top level file name as given in CLI */
/* Global counters */
static int      nParenth       ;/* Parentheses still open (value parser) */
static int      nNeedvalue     ;/* "NeedValue" type errors */
static int      nNeedvalue_Last;/* "NeedValue" type errors of previous pass */
static int      nErrors        ;/* Errors yet */
static int      nContext       ;/* Number of saved contexts */
static Sixteen  nZone_Max      ;/* Highest zone number yet */
/* CPU variables */
static int      hCPU_Now   ;/* Handle of current CPU type (default 6502) */
static int      fCPU_LongA ;/* Flag for long accumulator (default off) */
static int      fCPU_LongR ;/* Flag for long index registers (default off) */
static int      fCPU_LongAb;/* Buffer for these flags while other CPU is active */
static int      fCPU_LongRb;
static int      fPCdefined ;/* Flag: PC is defined */
static Value    PC_CPU     ;/* Current program counter (pseudo value) */
static Value    PC_Mem     ;/* Current program counter (real memory address) */
static Value    PC_inc     ;/* Increase PC by this amount after statement */
static Value    PC_Lowest  ;/* Start address of program (first PC given) */
static Value    PC_Highest ;/* End address of program plus one */
static Value    SegmentStart;/* Start of current segment */
static Value    SegmentMax;/* Highest address segment may use */
/* Static buffers for string storage, hash creation, list item lookup */
static ListItem StringItem;/* ...for general strings */
static char     pConvTable[256];/* holds conversion table from file */
       int      main(int, char *[]);
static void     Pass(int);
static void     ParseBlock(void);
static void     SkipRest(void);
static void     EnsureEOL(void);
static void     PseudoOpcode(void);
static void     SetPC(void);
static void     SetLabel(Sixteen, int);
static void     SetLabelValue(ListItem *, Value, int, int);
static void     NeedValue(void);
static void     Message(char *, int);
static void     ReadParameters(int, char *[]);
static void     CleanExit(int);
static char     ConvertChar(char, int);
static void     ConvertString(char *, int, int);
static void     FillOutBuffer(u_char);
static void     Segment_Link(Value, Value);
static void     Segment_FindMax(Value);
static void     Segment_Check(Value);

#endif
