/*
 * ACME - a crossassembler for producing 6502/65c02/65816 code.
 * Copyright (C) 1998 Marco Baye
 * Have a look at "acme.c" for further info
 */

/*
 * List item definitions
 */

#ifndef item_H
#define item_H

/* Flags for newly created labels */
#define LABELFLAG_DEFAULT       0

typedef unsigned char u_char;

/* The following definition is a part of all variants of the general structure
 * "ListItem". The first element of that structure *has* to be the pointer to
 * the list's next item, because the lookup routine treats the
 * startpointer-array's elements as if they were "ListItem"s (though the array
 * just contains pointers).*/
#define STRUCTHEADER_B  \
  ListItem     *Next;   \
  int           Hash;   \
  union {               \
    struct {            \
      u_char    Code;   \
      u_char    Group;  \
    } Bytes;            \
    void       *Body;   \
    struct {            \
      Value     Value;  \
      u_char    Flags;  \
    } Label;            \
  } Data;               \
  u_char        Type;

/* Official ANSI-C does not allow to predefine any union elements but the
 * first. Because of that, here the structure is defined once again (just with
 * a different ordering of union elements). :( */
#define STRUCTHEADER_P  \
  ListItem     *Next;   \
  int           Hash;   \
  union {               \
    void       *Body;   \
    struct {            \
      u_char    Code;   \
      u_char    Group;  \
    } Bytes;            \
    struct {            \
      Value     Value;  \
      u_char    Flags;  \
    } Label;            \
  } Data;               \
  u_char        Type;

/* The following structure is the one that is used throughout the whole
 * program: Its last element is the zero-terminated name string.*/
typedef struct ListItem ListItem;
struct ListItem {
  STRUCTHEADER_B
  char String[LSMAX + 1];
};

/* As I don't want to waste memory, each list item only gets as much of it as
 * is necessary. The following structure only reserves space for *one* string
 * character - the terminator; so "sizeof()" can deliver the space needed for
 * a list item without a name string.*/
typedef struct SizeStruct SizeStruct;
struct SizeStruct {
  STRUCTHEADER_B
  char String[1];
};

/* All predefined list items have exactly matching lengths. */
typedef struct KeyStruct2_B KeyStruct2_B;
struct KeyStruct2_B {
  STRUCTHEADER_B
  char String[3];
};

typedef struct KeyStruct3_B KeyStruct3_B;
struct KeyStruct3_B {
  STRUCTHEADER_B
  char String[4];
};

typedef struct KeyStruct4_B KeyStruct4_B;
struct KeyStruct4_B {
  STRUCTHEADER_B
  char String[5];
};

typedef struct KeyStruct5_B KeyStruct5_B;
struct KeyStruct5_B {
  STRUCTHEADER_B
  char String[6];
};


typedef struct KeyStruct2_P KeyStruct2_P;
struct KeyStruct2_P {
  STRUCTHEADER_P
  char String[3];
};

typedef struct KeyStruct3_P KeyStruct3_P;
struct KeyStruct3_P {
  STRUCTHEADER_P
  char String[4];
};

typedef struct KeyStruct4_P KeyStruct4_P;
struct KeyStruct4_P {
  STRUCTHEADER_P
  char String[5];
};

typedef struct KeyStruct5_P KeyStruct5_P;
struct KeyStruct5_P {
  STRUCTHEADER_P
  char String[6];
};

typedef struct KeyStruct6_P KeyStruct6_P;
struct KeyStruct6_P {
  STRUCTHEADER_P
  char String[7];
};

typedef struct KeyStruct7_P KeyStruct7_P;
struct KeyStruct7_P {
  STRUCTHEADER_P
  char String[8];
};

typedef struct KeyStruct8_P KeyStruct8_P;
struct KeyStruct8_P {
  STRUCTHEADER_P
  char String[9];
};

typedef struct KeyStruct9_P KeyStruct9_P;
struct KeyStruct9_P {
  STRUCTHEADER_P
  char String[10];
};

/* Macros for claiming and releasing memory blocks */

#define ALLOC_TASK(Size)      MyAlloc(Size, &pToBeFreed_Task)
#define ALLOC_TRY(Size)       MyAlloc(Size, &pToBeFreed_Try)
#define ALLOC_PASS(Size)      MyAlloc(Size, &pToBeFreed_Pass)
#define FREE_TASK()           MyFree(pToBeFreed_Task)
#define FREE_TRY()            MyFree(pToBeFreed_Try)
#define FREE_PASS()           MyFree(pToBeFreed_Pass)

/*
 * Prototypes
 */
/* Array of pointers to start of item lists (because of 8-bit hash) */
static ListItem *pPointerTable[256];
static void     *pToBeFreed_Task;/* linked list, holds malloc blocks */
static void     *pToBeFreed_Try;/* linked list, holds malloc blocks */
static void     *pToBeFreed_Pass;/* linked list, holds malloc blocks */
static u_char    Struct_Hash(ListItem *, int);
static ListItem *Struct_Search(ListItem *, u_char, int, int);
static ListItem *Struct_GetZoned(Sixteen, int, int, int);
static ListItem *Struct_GetPreparedLabel(Sixteen, int, int);
static void     *MyAlloc(size_t, void **);
static void      MyFree(void *);

#endif
