/*
 * ACME - a crossassembler for producing 6502/65c02/65816 code.
 * Copyright (C) 1998 Marco Baye
 * Have a look at "acme.c" for further info
 */

/*
 * Mnemonic definitions
 */

#ifndef mnemo_H
#define mnemo_H

/*
 * These values are needed to recognize addressing modes.
 * Bits:
 * 7....... "Implicit"     (no value given)
 * .6...... "Immediate"    ("#" at start)
 * ..5..... "IndirectLong" ("[" at start and "]" after value)
 * ...4.... "Indirect"     (Value has at least one unnecessary pair of "()")
 * ....32.. "Indexed-Int"  (Index given inside of "()")
 *          00 = no index
 *          01 = ",s"      (Stack-indexed)
 *          10 = ",x"      (X-indexed)
 *          11 = ",y"      (Y-indexed)
 * ......10 "Indexed-Ext"  (Index given outside of (or without any) "()")
 *          00 = no index
 *          01 = ",s"      (Stack-indexed)
 *          10 = ",x"      (X-indexed)
 *          11 = ",y"      (Y-indexed)
 */

/*
 * Components (Values for indices)
 */

/* No index */
#define HAM__      (0u << 0)

/* Stack-indexed */
#define HAM_S      (1u << 0)

/* X-indexed */
#define HAM_X      (2u << 0)

/* Y-indexed */
#define HAM_Y      (3u << 0)

/*
 * End values           base value      internal index  external index
 */

#define HAM_IMP         (1u << 7)
#define HAM_IMM         (1u << 6)
#define HAM_ABS                 0
#define HAM_ABSS                                        (1u << 0)
#define HAM_ABSX                                        (2u << 0)
#define HAM_ABSY                                        (3u << 0)
#define HAM_IND         (1u << 4)
#define HAM_XIND       ((1u << 4)   |   (2u << 2))
#define HAM_INDY       ((1u << 4)   |                   (3u << 0))
#define HAM_SINDY      ((1u << 4)   |   (1u << 2)   |   (3u << 0))
#define HAM_INDL        (1u << 5)
#define HAM_INDLY      ((1u << 5)                   |   (3u << 0))
/* Values of internal indices equal values of external indices, shifted left
 * by two bits. The program relies on this ! */

/*
 * Constant values, used to mark the possible parameter lengths of commands.
 * Not all of the eight values are actually used, however (because of the
 * supported CPUs).
 */
#define MAYBE______     (0)
#define MAYBE_1____     (MVALUE_FORCE08)
#define MAYBE___2__     (MVALUE_FORCE16)
#define MAYBE_1_2__     (MVALUE_FORCE08 | MVALUE_FORCE16)
#define MAYBE_____3     (MVALUE_FORCE24)
#define MAYBE_1___3     (MVALUE_FORCE08 | MVALUE_FORCE24)
#define MAYBE___2_3     (MVALUE_FORCE16 | MVALUE_FORCE24)
#define MAYBE_1_2_3     (MVALUE_FORCE08 | MVALUE_FORCE16 | MVALUE_FORCE24)

/*
 * Prototypes
 */
static ListItem MnemoItem; /* buffer */
static int      hAM_Now;/* Handle of current addressing mode */
static int      Mnemo_IsInvalid(int);
static int      Mnemo65_IsInvalid(int);
static int      Mnemo65_Check(int);
static void     Mnemo65_00(u_char);
static void     Mnemo65_01(u_char);
static void     Mnemo65_02(u_char);
static void     Mnemo65_03_04(u_char, int);
static void     Mnemo65_05_06_07(u_char, u_char);
static int      Mnemo65_567(int, int);
static void     Mnemo65_08(u_char);
static void     Mnemo65_09(u_char);
static void     Mnemo65_10(u_char);
static int      Mnemo_GetForceBit(void);
static Value    Mnemo_GetArgument(void);
static int      Mnemo_GetIndex(int);
static int      Mnemo_DoChecks(int, Value, int, int);
static int      Mnemo80_IsInvalid(int);

#endif
