/*
 * ACME - a crossassembler for producing 6502/65c02/65816 code.
 * Copyright (C) 1998 Marco Baye
 * Have a look at "acme.c" for further info
 */

/*
 * String definitions
 */

#ifndef strings_H
#define strings_H

/*
 * Prototypes
 */

/* Copyright message */
static char psInfo[] = "\n"
"ACME - the ACME Crossassembler for Multiple Environments\n"
"Release 0.08 beta (12 Nov 1999), Copyright (C) 1998, 1999 Marco Baye.\n"
PLATFORM_VERSION
"ACME comes with ABSOLUTELY NO WARRANTY; for details read the help file.\n"
"This is free software, and you are welcome to redistribute it under\n"
"certain conditions; as outlined in the GNU General Public License.\n\n"
"Syntax: acme [options] [file]\n\n"
"Options:\n"
"-v<digit>       Set verbosity level.\n"
"-h              Help. Show this message.\n"
PORT_SWITCHES
"\n";

/* Message type handles and strings */
#define EWARNING        0
#define EERROR          1
#define ESERIOUS        2
static char *eType[] = {
  "Warning",
  "Error",
  "Serious error"
};
/* Warning messages during assembly */
static char pswCbmUsed[] = "'!cbm' is deprecated; use '!ct pet' instead.";
static char pswHighbyteZero [] = "Using oversized addressing mode.";
static char pswSegReached[] = "Segment reached another one, overwriting it.";
static char pswSegIllegal[] = "Segment starts inside another one, overwriting it.";
static char pswOffsetOn[] = "Offset assembly still active at end of segment. Switched it off.";

/* Error messages during assembly */
static char pseNo2ndOutfile     [] = "Output file already chosen.";
static char pseNo3rdFile        [] = "Already two input files open.";
static char pseCannotOpenOutFile[] = "Cannot open output file.";
static char pseCannotOpenSubFile[] = "Cannot open sublevel file.";
static char pseCombCA [] = "Illegal combination of command and addressing mode.";
static char pseCombCP [] = "Illegal combination of command and postfix.";
static char pseDivZero[] = "Division by zero.";
static char pseNegExp [] = "Exponent is negative.";
static char pseNoPC         [] = "Program counter is unset.";
static char pseNotYet       [] = "Sorry, feature not yet implemented.";
static char pseNoMemLeft    [] = "Out of memory.";
static char pseSyntax       [] = "Syntax error.";
static char pseLabelTwice   [] = "Label already defined.";
static char pseMacroTwice   [] = "Macro already defined.";
static char pseMemInitTwice [] = "Memory already initialised.";
static char pseNeedValue    [] = "Value not yet defined.";
static char pseOpenQuotes   [] = "Quotes still open at end of line.";
static char pseMissingString[] = "No string given.";
static char pseTooBig   [] = "Number out of range.";
static char pseTooDeep  [] = "Recursion too deep.";
static char pseTooFar   [] = "Target out of range.";
static char pseTooLate  [] = "Too late for postfix.";
static char pseTooLong  [] = "String too long.";
static char pseTooMuch  [] = "Produced too much code.";
static char pseTooManyMP[] = "Too many macro parameters.";
static char pseTooOpen  [] = "Too many '('.";
static char pseTooClosed[] = "Too many ')'.";
static char pseNegative[] = "Negative value - cannot choose addressing mode.";
static char pseUkOp    [] = "Unknown operator.";
static char pseUkPF    [] = "Illegal postfix.";
static char pseUkPO    [] = "Unknown pseudo opcode.";
static char pseUkCPU   [] = "Unknown processor.";
static char pseUkGroup [] = "Bug in ACME - illegal group index.";
static char pseUkMacro [] = "Macro not defined.";
static char pseWrongNr [] = "Wrong number of macro parameters.";
static char pseWrongCPU[] = "Chosen CPU does not support this command and/or addressing mode.";
static char pseNoVarFound[] = "'ACME' environment variable not found.";
/* Error messages for block routines */
static char pseeEndOfFile [] = "End of file expected.";
static char pseeRightBrace[] = "Missing '}'.";
static char pseeLeftBrace [] = "Missing '{'.";
/* Error messages on startup or closedown */
static char pseCannotOpenDumpFile[] = "Error: Cannot open dump file.\n";
static char pseCannotOpenTopFile [] = "Error: Cannot open toplevel file.\n";
static char pseNoTop             [] = "Error: No top level source given.\n";
static char pseUkSwitch          [] = "Error: Unknown CLI switch: '%c'.\n";
/* Other messages */
static char psvFirst  [] = "First pass.\n";
static char psvFurther[] = "Further pass.\n";
static char psvFind   [] = "Further pass needed to find error.\n";
static char psvOutput [] = "Saving output file ($%x - $%x exclusive).\n";
static char psvBinary [] = "Loaded $%x bytes from file offset $%x.\n";
static char psvSegment[] = "Segment finished ($%x - $%x exclusive).\n";
/* Other strings */
static char psMacro   [] = "Macro";
static char psZone    [] = "Zone";
static char psUntitled[] = "<untitled>";
/* Functions */
static void String_ToLower(ListItem *, int);
static void String_ShowInfo(void);
static void String_EndSegment(void);

#endif
