/*
 * ACME - a crossassembler for producing 6502/65c02/65816 code.
 * Copyright (C) 1998 Marco Baye
 * Have a look at "acme.c" for further info
 */

/*
 * Block stuff
 */

#include "block.h"

/*
 * Constants
 */

/*
 * Variables
 */

byte  BlockBuffer[BLOCK_MAXSIZE];
byte* BlockBufEnd = &(BlockBuffer[BLOCK_MAXSIZE]);/* end of buffer */
/* Content of block in case of loop:
 *
 * Handle of WHILE or UNTIL
 * Condition (ALU expression)
 * Separator
 * Assembler lines
 * Separator
 * Handle of WHILE or UNTIL
 * Condition (ALU expression)
 * Separator
 */

int EndReason;/* Block end reason */

/*
 * Parse {block} [else {block}]
 */
void Block_2Blocks(int fParseFirst) {
  treeItem* Item;
  int       Reason;

  if(fParseFirst) ParseBlock();
  else            Block_Store(NULL);

  Reason = EndReason;
  EndReason = RNONE;/* Clear global variable */
  if(Reason == RRIGHTBRACE) {
    /* check for "else" */
    NEXTANDSKIPSPACE;
    if(GotByte) {
      if(Stream_ReadKeyword(MiscString, FALSE)) {
        MiscString_ToLower();
        Item = Tree_ScanROM(MiscString, HTYPE_ELSE);
        if(Item) {
          if(Item->Body.Opcode.Code == ID_ELSE) {
            SKIPSPACE;
            if(GotByte != '{') ThrowSerious(Exception_NoLeftBrace);

            if(fParseFirst) Block_Store(NULL);
            else            ParseBlock();

            Reason = EndReason;
            EndReason = RNONE;/* Clear global variable */
            if(Reason != RRIGHTBRACE) ThrowError(Exception_NoRightBrace);
            GetByte();
          } else ThrowError(Exception_Syntax);
        } else ThrowError(Exception_Syntax);
      }
      EnsureEOL();
    }
  } else ThrowError(Exception_NoRightBrace);
}

/*
 * Read block to address (starting with next byte) and terminate. The updated
 * pointer is returned. If the end address is exceeded, an error (serious)
 * will be generated. If the given RAM pointer is NULL, the block will simply
 * be skipped.
 */
byte* Block_Store(byte* Pointer) {
  int  Depth = 1;/* to find the correct closing brace */
  byte b;

  while(Depth && (EndReason == RNONE)) {
    b = Stream_GetRawByte();
    if(Pointer) {
      /* if pointer isn't NULL, store block */
      if(Pointer == BlockBufEnd) ThrowSerious(Exception_NoMemLeft);
      *(Pointer++) = b;
    }
    if(QuoteChar == NO_QUOTE_CHAR) {
      if(b == '{') Depth++;
      if(b == '}') Depth--;
    }
  }
  if(Depth) {
    ThrowSerious(Exception_NoRightBrace);
  } else {
    EndReason = RRIGHTBRACE;
    GotByte = 0;/* Kluge */
    if(Pointer) *(Pointer - 1) = BLOCK_FIELDSEPARATOR;/* add separator */
  }
  return(Pointer);
}
