/*
 * ACME - a crossassembler for producing 6502/65c02/65816 code.
 * Copyright (C) 1998 Marco Baye
 * Have a look at "acme.c" for further info
 */

/*
 * Block stuff
 */

#ifndef block_H
#define block_H

/*
 * Macros, conditional assembly, loops and sourcefile-includes are all based on
 * parsing blocks of code. When defining macros or using loops or conditional
 * assembly, the block starts with "{" and ends with "}". In the case of
 * "!source", the given file is treated like a block - the outermost assembler
 * routine uses the same technique to parse the top level file.
 */

/* Separation character within memory block - linefeed never gets through
 * "GetByte()" and is therefore appropriate here */
#define BLOCK_FIELDSEPARATOR    10

/* Handle to use for the "else" keyword - rather stupid as there is nothing it
 * could be confused with */
#define ID_ELSE 0

/*
 * Variables
 */

extern byte  BlockBuffer[];
extern byte* BlockBufEnd;
/* Block end reason and its possible contents */
extern int EndReason;
enum {
  RNONE      ,/* Default value - means "not at end" */
  RENDOFFILE ,/* Reached end of file - either real or by "!eof" */
  RENDOFBLOCK,/* Reached separator in RAM block */
  RRIGHTBRACE /* Reached "}" */
};

/*
 * Prototypes
 */

void  Block_2Blocks(int);
byte* Block_Store(byte*);

#endif
