/*
 * ACME - a crossassembler for producing 6502/65c02/65816 code.
 * Copyright (C) 1998 Marco Baye
 * Have a look at "acme.c" for further info
 */

/*
 * Configuration
 */

#ifndef config_H
#define config_H

/* Maximum recursion depth of value parser */
#define MAXLEVEL        16

/* Maximum depth of zone/macro contexts */
#define MAXCONTEXTS     9

/* Maximum number of macro parameters */
#define MACRO_MAXPARAMETERS     8

/* Maximum length of strings */
#define LSMAX           127

/* Default value for "!fill" */
#define VFILL           0

/* Default value for output buffer */
#define MEMFILL         0

/* Default value for "!align" (234 = NOP) */
#define VALIGN          234

/* Default size of macro/loop buffer */
#define BLOCK_MAXSIZE   4096

/* Total number of errors before exiting */
#define MAXERRORS       20

#endif
