/*
 * ACME - a crossassembler for producing 6502/65c02/65816 code.
 * Copyright (C) 1998 Marco Baye
 * Have a look at "acme.c" for further info
 */

/*
 * Context stuff
 */

#include "context.h"

/*
 * Constants
 */

char psZone[] = "Zone";

/*
 * Variables
 */

zone Context_CurrentZone;/* current zone value */
zone Zone_Max;/* Highest zone number yet */
int  nContext;/* Number of saved contexts */
int  Context_CodeTable;/* Current translation table */

/*
 * Set default values for pass
 */
inline void Context_InitForPass(FILE* Filehandle) {
  nContext = 0;
  Context[0].nLines       = 0;
  Context[0].hByteSource  = BYTESOURCE_FILE;
  Context[0].u.hFile      = Filehandle;
  Context[0].pSourceFile  = pnfTop;
  Context[0].pSourceTitle = psUntitled;
  Context[0].pSourceType  = psZone;
  Context[0].OldFileByte  = 0;
  Context[0].OldRawByte   = 0;

  Context_CurrentZone = ZONE_STEP;/* current = lowest number */
  Zone_Max = ZONE_STEP;/* highest used yet = current */

  GotByte = 0;
}

/*
 * Check whether context depth is exceeded and increase counter if not.
 */
void Context_New() {
  if((nContext++) == MAXCONTEXTS) {
    nContext--;
    ThrowSerious(Exception_TooDeep);
  }
}
