/*
 * ACME - a crossassembler for producing 6502/65c02/65816 code.
 * Copyright (C) 1998 Marco Baye
 * Have a look at "acme.c" for further info
 */

/*
 * Context stuff
 */

#ifndef context_H
#define context_H

/* Number of "global zone" */
#define ZONE_GLOBAL      0

#define CONTEXT_NEWZONE Context_CurrentZone = (Zone_Max += ZONE_STEP);

/*
 * Variables
 */

/* Current context
 * These are not necessarily current data (top- or sub-filename); during macro
 * processing these vectors points to the data of the file the macro was
 * defined in. Needed for meaningful error messages! */
typedef struct context context;
struct context {
  int      hByteSource;/* current source handle    */
  int      nLines     ;/* line number inside file  */
  union {
    FILE*    hFile;/* File handle */
    byte*    pRAM ;/* Read pointer in block */
  } u;
  byte*    pSourceFile ;/* file name                */
  byte*    pSourceTitle;/* title of zone or macro   */
  byte*    pSourceType ;/* "zone" or "macro"        */
  byte     OldFileByte ;/* latest byte from file    */
  byte     OldRawByte  ;/* latest byte converted    */
};

extern zone    Context_CurrentZone;/* current zone value */
extern zone    Zone_Max;/* Highest zone number yet */
extern int     nContext;/* Number of saved contexts */
extern context Context[];
extern byte    pTitle[][];
extern int Context_CodeTable;/* Current translation table and its values */
enum {
  CODETABLE_RAW,
  CODETABLE_PET,
  CODETABLE_SCR,
  CODETABLE_FILE
};

/*
 * Prototypes
 */

void Context_InitForPass(FILE*);
void Context_New(void);

#endif
