/*
 * ACME - a crossassembler for producing 6502/65c02/65816 code.
 * Copyright (C) 1998 Marco Baye
 * Have a look at "acme.c" for further info
 */

/*
 * CPU stuff
 */

#ifndef cpu_H
#define cpu_H

/*
 * Variables
 */

extern int CPU_TypeBit;/* Handle of current CPU type (default 6502) */
extern int CPU_fLongA;/* Flag for long accumulator (default off) */
extern int CPU_fLongR;/* Flag for long index registers (default off) */
extern int CPU_BufLongA;/* Buffer for these flags while other CPU is active */
extern int CPU_BufLongR;
extern int CPU_fPCdefined;/* Flag: PC is defined */
extern value CPU_PC;/* Current program counter (pseudo value) */

/*
 * Prototypes
 */

inline void CPU_InitForPass(void);
inline void CPU_SetPC(void);
int  CPU_Choose(void);
int  CPU_SetLongA(void);
int  CPU_SetLongR(void);
int  CPU_SetShortA(void);
int  CPU_SetShortR(void);

#endif
