/*
 * ACME - a crossassembler for producing 6502/65c02/65816 code.
 * Copyright (C) 1998 Marco Baye
 * Have a look at "acme.c" for further info
 */

/*
 * Byte data table
 */

#ifndef data_H
#define data_H

/*
 * Variables
 */

extern byte pFlagTable[];/* Flag table */
/* Byte flags */
#define CPUBIT_6502     (1u << 0) /* Byte is 6502 opcode */
#define CPUBIT_6510     (1u << 1) /* Byte is illegal 6510 opcode */
#define CPUBIT_65C02    (1u << 2) /* Byte is 65c02 extension */
#define CPUBIT_65816    (1u << 3) /* Byte is 65816 extension */
#define CPUBIT_Z80      (1u << 4) /* Byte is Z80 opcode */
/* (1u << 5) is currently reserved */
#define BYTEIS_UPCASE   (1u << 6) /* Byte is uppercase */
#define BYTEIS_ILLEGAL  (1u << 7) /* Byte is illegal in a keyword */

#endif
