/*
 * ACME - a crossassembler for producing 6502/65c02/65816 code.
 * Copyright (C) 1998 Marco Baye
 * Have a look at "acme.c" for further info
 */

/*
 * Global definitions
 */

#ifndef global_H
#define global_H

/* Macros for skipping a single space character */
#define        SKIPSPACE        if(GotByte   == ' ') GetByte()
#define NEXTANDSKIPSPACE        if(GetByte() == ' ') GetByte()

#ifndef NULL
/* Nullpointer definition */
#define NULL ((void *)0)
#endif

#ifndef FALSE
/* Boolean values */
#define FALSE   0
#define TRUE    1
#endif

/* RAM tree item types */
#define BM_LABEL        0
#define BM_MACRO        1
#define BM_STRING       2
#define BM_MASK         3
/* Zone numbers and RAM tree item types are OR'd to make Type values,
 * so the following number must match. */
#define ZONE_STEP       4

/* Type definitions */
typedef unsigned char byte;/* replaces "u_char" */
typedef unsigned int  u_int;
typedef unsigned int  zone;
typedef struct label label;
typedef struct treeItem treeItem;

#endif
