/*
 * ACME - a crossassembler for producing 6502/65c02/65816 code.
 * Copyright (C) 1998 Marco Baye
 * Have a look at "acme.c" for further info
 */

/*
 * Mnemonic definitions
 */

#ifndef mnemo_H
#define mnemo_H

/*
 * Constants
 */

/*
 * These values are needed to recognize addressing modes.
 * Bits:
 * 7....... "Implicit"     (no value given)
 * .6...... "Immediate"    ("#" at start)
 * ..5..... "IndirectLong" ("[" at start and "]" after value)
 * ...4.... "Indirect"     (Value has at least one unnecessary pair of "()")
 * ....32.. "Indexed-Int"  (Index given inside of "()")
 * ......10 "Indexed-Ext"  (Index given outside of (or without any) "()")
 *
 * Index bits:
 *   00 = no index
 *   01 = ",s"  (Stack-indexed)
 *   10 = ",x"  (X-indexed)
 *   11 = ",y"  (Y-indexed)
 */

/*
 * Components (Values for indices)
 */

/* No index */
#define HAM__      (0u << 0)

/* Stack-indexed */
#define HAM_S      (1u << 0)

/* X-indexed */
#define HAM_X      (2u << 0)

/* Y-indexed */
#define HAM_Y      (3u << 0)

/*
 * End values           base value      internal index  external index
 */

#define HAM_IMP         (1u << 7)
#define HAM_IMM         (1u << 6)
#define HAM_ABS                 0
#define HAM_ABSS                                        (1u << 0)
#define HAM_ABSX                                        (2u << 0)
#define HAM_ABSY                                        (3u << 0)
#define HAM_IND         (1u << 4)
#define HAM_XIND       ((1u << 4)   |   (2u << 2))
#define HAM_INDY       ((1u << 4)   |                   (3u << 0))
#define HAM_SINDY      ((1u << 4)   |   (1u << 2)   |   (3u << 0))
#define HAM_INDL        (1u << 5)
#define HAM_INDLY      ((1u << 5)                   |   (3u << 0))
/* Values of internal indices equal values of external indices, shifted left
 * by two bits. The program relies on this ! */

/*
 * Constant values, used to mark the possible parameter lengths of commands.
 * Not all of the eight values are actually used, however (because of the
 * supported CPUs).
 */
#define MAYBE______     (0)
#define MAYBE_1____     (MVALUE_FORCE08)
#define MAYBE___2__     (MVALUE_FORCE16)
#define MAYBE_1_2__     (MVALUE_FORCE08 | MVALUE_FORCE16)
#define MAYBE_____3     (MVALUE_FORCE24)
#define MAYBE_1___3     (MVALUE_FORCE08 | MVALUE_FORCE24)
#define MAYBE___2_3     (MVALUE_FORCE16 | MVALUE_FORCE24)
#define MAYBE_1_2_3     (MVALUE_FORCE08 | MVALUE_FORCE16 | MVALUE_FORCE24)

/* Size of largest assembler menmonic */
#define MAXSIZE_MNEMO   3

/*
 * Prototypes
 */

void   Mnemo_PutCodeByte(byte);
int    Mnemo_IsInvalid(int);
int    Mnemo65_IsInvalid(int);
int    Mnemo65_Check(int);
void   Mnemo65_GroupIMP(byte);
void   Mnemo65_GroupRELS(byte);
void   Mnemo65_GroupRELL(byte);
void   Mnemo65_GroupACC(byte, int);
void   Mnemo65_GroupMISC(byte, byte);
int    Mnemo65_OutputMISC(int, int);
void   Mnemo65_GroupMOVE(byte);
void   Mnemo65_GroupPEI(byte);
void   Mnemo65_GroupJUMP(byte);
int    Mnemo_GetForceBit(void);
value  Mnemo_GetArgument(void);
int    Mnemo_GetIndex(int);
int    Mnemo_DoChecks(int, value, int, int);
int    Mnemo80_IsInvalid(int);

#endif
