; ODPLAY UPER-64  V1.5 OURCE ODE
; URRENTLY HANDLES THE FOLLOWING:

; OST MODES USE A 'DELAY' TIMER CONTROLLED BY  THAT ADJUSTS THE SPEED
; OF ALL ROUTINES TO MATCH ABOUT 42 Z, THE SPEED OF THE IGIMAX DRIVER.

; ODE  ESCRIPTION
;   1    CHIP(S) IN 4 BITS (ITHERING AVAILABLE)
;   2    CHIP(S) IN 8 BIT  MODE
;   3   SER ORT  CIRCUIT(S)

; TEREO IS AVAILABLE IN ALL MODES.  IGIMAX USED IN STEREO SER ORT MODE.

.ORG $6200

ROMBANK = $01
LONOTE = 1023
HINOTE = 16
NOTEPERL = $02
NOTEPERH = NOTEPERL+4
OLDPERIODL = NOTEPERH+4
OLDPERIODH = OLDPERIODL+4
NOTESTOPL = OLDPERIODH+4
NOTESTOPH = NOTESTOPL+4
ARPNOTE1L = NOTESTOPH+4
ARPNOTE1H = ARPNOTE1L+4
ARPNOTE2L = ARPNOTE1H+4
ARPNOTE2H = ARPNOTE2L+4
ARPCOUNTER = ARPNOTE2H+4
ARPFLAG = ARPCOUNTER+4
SETVOLFLAG = ARPFLAG+4
PORTAFLAG = SETVOLFLAG+4
VSLIDEDIR = PORTAFLAG+4
PSLIDE = VSLIDEDIR+4
VSLIDE = PSLIDE+4
PORTA = VSLIDE+4
TRACKVOL = PORTA+4
VOL1 = TRACKVOL+4
VOL2 = VOL1+2
VOL3 = VOL2+2
VOL4 = VOL3+2
SAMPLENUM = VOL4+2
ENABLEFLGS = SAMPLENUM+4
TICKS = ENABLEFLGS+1
TEMPOBPM = TICKS+1
TEMPOTPD = TEMPOBPM+1
COMMAND = TEMPOTPD+1
CMDARG = COMMAND+4
OLDCOMMAND = CMDARG+4
OLDCMDARG = OLDCOMMAND+4
LASTKEY = OLDCMDARG+4
TEMPA = LASTKEY+1
TEMPB = TEMPA+5
TEMPC = TEMPB+5
TEMPD = TEMPC+5
TEMPX = TEMPD+5
TEMPY = TEMPX+1
TEMPPNT1 = TEMPY+1
SECOND = TEMPPNT1+2
THIRD = SECOND+4
FOURTH = THIRD+4
FIFTH = FOURTH+4
SIXTH = FIFTH+4
SEVENTH = SIXTH+4
EIGHTH = SEVENTH+4
PATINDEX = EIGHTH+4
BREAKADDR = PATINDEX+2
PATNUMBER = BREAKADDR+2
ROWNUMBER = PATNUMBER+1
FRACTION = ROWNUMBER+1
STEPL = FRACTION+4
STEPH = STEPL+4
TRKPNTL = STEPH+4
TRKPNTH = TRKPNTL+4
TRKPNTB = TRKPNTH+4
STARTL = TRKPNTB+4
STARTH = STARTL+4
STARTB = STARTH+4
ENDL = STARTB+4
ENDH = ENDL+4
ENDB = ENDH+4
OFFSET = ENDB+4
TEMPPER = OFFSET+4
SAMPNUM = TEMPPER+4
SID4OUTRIGHT = SAMPNUM+4
SID8OUTLORIGHT = SID4OUTRIGHT+2
SID8OUTHIRIGHT = SID8OUTLORIGHT+2
SID8CLKLORIGHT = SID8OUTHIRIGHT+2
SID8CLKHIRIGHT = SID8CLKLORIGHT+2
NTPEROFF = SID8CLKHIRIGHT+2

TEMPPNT3 = $FA
TEMPPNT4 = $FC
RIGHTSID = $FE
ABORTFLAG = $03E1
PLAYMODE = $03E2
DELAY = $03E3
DELAY2 = $03E4          ; $03E5-$03E8 ARE RESERVED FOR FUTURE USE.
DITHER = $03E9          ; 0=ORMAL 4 BIT, 1=ENABLE DITHERING
VOLFIX = $03EA          ; 0=NORMAL 6581 , 1=FIX VOLUME FOR 8580
STEREO = $03EB          ; 0=MONO, 1=STEREO
RSIDCOPY = $03EC        ; ASE ADDRESS PAGE OF STEREO  (N. $7)
BALLEFT = $03ED         ; LOBAL OLUME EFT IDE (  )
BALRIGHT = $03EE        ; LOBAL OLUME IGHT IDE (  )
LEFT = %11001011
RIGHT = %11001111
TRK1DATA = $0340
TRK2DATA = $0348
TRK3DATA = $0350
TRK4DATA = $0358
ARPTABLEL = $0360
ARPTABLEH = $0370
VIBTABLEL = $0380
VIBTABLEH = $0390
PATTERNBUF = $5600
PATTERNTOP = $5A00      ; AW EADER ATA IS $500 TO $5.
SONGLENGTH = $5DB6
PATTERNTBL = $5DB8      ;  ONV. ABLE IS $500 TO $5.
VOLTABLE = $9000
TEMPOTBL = $E000
TEMPOTBH = $E100
PAGE0TEMP = $E200
LSBSADDR = $E300
MSBSADDR = $E320
BNKSADDR = $E340
LSBSEND = $E360
MSBSEND = $E380
BNKSEND = $E3A0
LSBLPPNT = $E3C0
MSBLPPNT = $E3E0
BNKLPPNT = $E400
LSBLPLEN = $E420
MSBLPLEN = $E440
BNKLPLEN = $E460
VOLUMES = $E480         ; IGNED-TO-NSIGNED TABLE IS $500 TO $5.
DIVIDE16 = $E500
NTPERIOD = $E600        ; NUSED AM IS $00 TO $

; / EGISTERS

SID = $D400
SID8OUTLO = SID+2
SID8CLKLO = SID+4
SID8OUTHI = SID+9
SID8CLKHI = SID+11
SID4OUT = SID+24
SIDNOISE = SID+27
KEYCOLS = $DC00
KEYROWS = $DC01
DIGITRACK = $DD00
USEROUT = $DD01
TEMPO = $DD04
DMACMD = $DF01
DMAADL = $DF02
DMAADH = $DF03
DMALO = $DF04
DMAHI = $DF05
DMABNK = $DF06
DMADAL = $DF07
DMADAH = $DF08
DMAVER = $DF0A

JMP PLAYSONG
JMP INITSOUND
JMP PLAYSAMP
JMP SILENCE

REUDATA
 .BYTE 0
BITTABLE
 .BYTE 1,2,4,8,16,32,64,128

 .BYTE 0,0,0,"VIBRATO VARS"

VIBFLAG
 .BYTE 0,0,0,0
VIBRATE
 .BYTE 0,0,0,0
VIBDEPTH
 .BYTE 0,0,0,0
VIBTOPL
 .BYTE 0,0,0,0
VIBTOPH
 .BYTE 0,0,0,0
VIBBOTL
 .BYTE 0,0,0,0
VIBBOTH
 .BYTE 0,0,0,0
VIBSTEPF
 .BYTE 0,0,0,0
VIBSTEPL
 .BYTE 0,0,0,0
VIBSTEPH
 .BYTE 0,0,0,0
STEPFRACT
 .BYTE 0,0,0,0
VIBCOUNTER
 .BYTE 0,0,0,0
VIBHALFC
 .BYTE 0,0,0,0
UPFLAG
 .BYTE 0,0,0,0
VIBWAVE
 .BYTE 0,0,0,0

 .BYTE 0,0,0,"UMP TABLES",0,0,0

JUMPTAB1L
 .BYTE <ARPEGGIO
 .BYTE <SLIDEUP
 .BYTE <SLIDEDN
 .BYTE <SLIDE2NT
 .BYTE <VIBRATO
 .BYTE <SLIDEVS
 .BYTE <VIBRATOVS
 .BYTE <UNUSED
 .BYTE <UNUSED
 .BYTE <SOFFSET
 .BYTE <VOLSLIDE
 .BYTE <POSJUMP
 .BYTE <SETVOL
 .BYTE <PATBRK
 .BYTE <UNUSED
 .BYTE <SETSPEED

JUMPTAB1H
 .BYTE >ARPEGGIO
 .BYTE >SLIDEUP
 .BYTE >SLIDEDN
 .BYTE >SLIDE2NT
 .BYTE >VIBRATO
 .BYTE >SLIDEVS
 .BYTE >VIBRATOVS
 .BYTE >UNUSED
 .BYTE >UNUSED
 .BYTE >SOFFSET
 .BYTE >VOLSLIDE
 .BYTE >POSJUMP
 .BYTE >SETVOL
 .BYTE >PATBRK
 .BYTE >UNUSED
 .BYTE >SETSPEED

JUMPTAB2L
 .BYTE <DARPEGGIO
 .BYTE <DSLIDEUP
 .BYTE <DSLIDEDN
 .BYTE <DSLIDE2NT
 .BYTE <DVIBRATO
 .BYTE <DSLIDEVS
 .BYTE <DVIBRATOVS
 .BYTE <UNUSED
 .BYTE <UNUSED
 .BYTE <UNUSED
 .BYTE <DVOLSLIDE
 .BYTE <UNUSED
 .BYTE <UNUSED
 .BYTE <UNUSED
 .BYTE <UNUSED
 .BYTE <UNUSED

JUMPTAB2H
 .BYTE >DARPEGGIO
 .BYTE >DSLIDEUP
 .BYTE >DSLIDEDN
 .BYTE >DSLIDE2NT
 .BYTE >DVIBRATO
 .BYTE >DSLIDEVS
 .BYTE >DVIBRATOVS
 .BYTE >UNUSED
 .BYTE >UNUSED
 .BYTE >UNUSED
 .BYTE >DVOLSLIDE
 .BYTE >UNUSED
 .BYTE >UNUSED
 .BYTE >UNUSED
 .BYTE >UNUSED
 .BYTE >UNUSED

PLAYSONG
 SEI
 LDA #0
 STA 53280
 LDA #32
 STA 53265
 LDA #53
 STA ROMBANK
 LDX #2
 
COPYLP1
 LDA $00,X
 STA PAGE0TEMP,X
 INX
 BNE COPYLP1

 LDA #$7F
 STA $DD0D
 LDA #$00
 STA $DD0E
 LDA #23
 STA $DD00
 LDA #255
 STA $DD01
 STA $DD03
 LDA #63
 STA $DD02
 LDA #0
 LDX #2

CLRLOOP
 STA $00,X
 INX
 BNE CLRLOOP
 LDX #61

CLRLOOP2
 DEX
 STA VIBFLAG,X
 BNE CLRLOOP2
 STA ABORTFLAG
 STA DMACMD
 LDA RSIDCOPY
 STA RIGHTSID+1
 STA SID4OUTRIGHT+1
 STA SID8OUTLORIGHT+1
 STA SID8OUTHIRIGHT+1
 STA SID8CLKLORIGHT+1
 STA SID8CLKHIRIGHT+1
 LDA #$18
 STA SID4OUTRIGHT
 LDA #2
 STA SID8OUTLORIGHT
 LDA #9
 STA SID8OUTHIRIGHT
 LDA #4
 STA SID8CLKLORIGHT
 LDA #$0B
 STA SID8CLKHIRIGHT
 LDA PLAYMODE
 CMP #2
 BNE NOTPWMSTR
 LDA STEREO
 BEQ NOTPWMSTR
 LDA #8
 STA NTPEROFF

NOTPWMSTR
 LDA #1
 STA DMADAL
 LDA #0
 STA DMADAH
 LDA #0
 STA DMAVER
 LDA #$0F
 STA ENABLEFLGS
 LDA #125
 STA TEMPOBPM
 LDA #6
 STA TEMPOTPD
 JSR CALCTEMPO
 LDA #<LONOTE
 STA NOTEPERL
 STA NOTEPERL+1
 STA NOTEPERL+2
 STA NOTEPERL+3
 LDA #>LONOTE
 STA NOTEPERH
 STA NOTEPERH+1
 STA NOTEPERH+2
 STA NOTEPERH+3
 LDA #>VOLTABLE
 STA VOL1+1
 STA VOL2+1
 STA VOL3+1
 STA VOL4+1
 LDA #1
 STA STARTB
 STA STARTB+1
 STA STARTB+2
 STA STARTB+3
 STA ENDB
 STA ENDB+1
 STA ENDB+2
 STA ENDB+3
 STA TRKPNTB
 STA TRKPNTB+1
 STA TRKPNTB+2
 STA TRKPNTB+3
 LDA #3
 STA ENDH
 STA ENDH+1
 STA ENDH+2
 STA ENDH+3

NEWPATN
 LDA #0
 STA ROWNUMBER
 STA DMALO
 LDX PATNUMBER
 LDA PATTERNTBL,X
 ASL
 ASL
 STA DMAHI
 LDA #0
 ADC #0
 STA DMABNK
 LDA #<PATTERNBUF
 STA DMAADL
 LDA #>PATTERNBUF
 STA DMAADH
 LDA #0
 STA DMAVER
 STA DMADAL
 LDA #4
 STA DMADAH
 LDA #$95
 STA DMACMD
 LDA #8
 STA DMADAL
 LDA #0
 STA DMADAH
 STA DMAVER
 STA DMAADH
 LDA #$09
 STA $DD0E
 LDA BREAKADDR+1
 BNE SETBREAK
 LDA #<PATTERNBUF
 STA PATINDEX
 LDA #>PATTERNBUF
 STA PATINDEX+1
 JMP STARTNOTE

SETBREAK
 LDA BREAKADDR
 STA PATINDEX
 LDA BREAKADDR
 STA PATINDEX+1

STARTNOTE
 LDA #$FE
 STA KEYCOLS
 LDA KEYROWS
 CMP #$BF
 BNE CHKSPC
 LDA #2 
 STA ABORTFLAG
 JMP STOPSONG

CHKSPC
 LDA #$7F
 STA KEYCOLS
 LDA KEYROWS
 CMP #$EF
 BNE NOSTOP
 LDA #1
 STA ABORTFLAG
 JMP STOPSONG

NOSTOP
 CMP #$FE
 BNE NOTOG1
 JMP TOGGLE1

NOTOG1
 CMP #$F7
 BNE NOTOG2
 JMP TOGGLE2

NOTOG2
 LDA #$FD
 STA KEYCOLS
 LDA KEYROWS
 CMP #$FE
 BNE NOTOG3
 JMP TOGGLE3

NOTOG3
 CMP #$F7
 BNE NOTOG4
 JMP TOGGLE4

NOTOG4
 LDA #$DF
 STA KEYCOLS
 LDA KEYROWS
 CMP #$FD
 BNE NOKEYS
 JMP PAUSE

NOKEYS
 LDA #0
 STA LASTKEY
 JMP ROWCMDS

TOGGLE1
 LDA #1
 CMP LASTKEY
 BNE TGL1
 JMP ROWCMDS

TGL1
 STA LASTKEY
 LDA ENABLEFLGS
 EOR #$01
 STA ENABLEFLGS
 AND #$01
 BNE TGON1
 LDA #0
 LDX #0
 JSR SV2
 JMP TG1_1

TGON1
 LDA TRACKVOL
 LDX #0
 JSR SV2

TG1_1
 LDX #0
 JMP ROWCMDS

TOGGLE2
 LDA #2
 CMP LASTKEY
 BNE TGL2
 JMP ROWCMDS

TGL2
 STA LASTKEY
 LDA ENABLEFLGS
 EOR #$02
 STA ENABLEFLGS
 AND #$02
 BNE TGON2
 LDA #0
 LDX #1
 JSR SV2
 JMP TG2_1

TGON2
 LDA TRACKVOL+1
 LDX #1
 JSR SV2

TG2_1
 LDX #1
 JMP ROWCMDS

TOGGLE3
 LDA #3
 CMP LASTKEY
 BNE TGL3
 JMP ROWCMDS

TGL3
 STA LASTKEY
 LDA ENABLEFLGS
 EOR #$04
 STA ENABLEFLGS
 AND #$04
 BNE TGON3
 LDA #0
 LDX #2
 JSR SV2
 JMP TG3_1

TGON3
 LDA TRACKVOL+2
 LDX #2
 JSR SV2

TG3_1
 LDX #2
 JMP ROWCMDS

TOGGLE4
 LDA #4
 CMP LASTKEY
 BNE TGL4
 JMP ROWCMDS

TGL4
 STA LASTKEY
 LDA ENABLEFLGS
 EOR #$08
 STA ENABLEFLGS
 AND #$08
 BNE TGON4
 LDA #0
 LDX #3
 JSR SV2
 JMP TG4_1

TGON4
 LDA TRACKVOL+3
 LDX #3
 JSR SV2

TG4_1
 LDX #3
 JMP ROWCMDS

PAUSE
 LDA #5
 CMP LASTKEY
 BEQ ROWCMDS
 STA LASTKEY
 LDA #$DF
 STA KEYCOLS
 LDA #$49
 STA SID+4
 STA SID+11
 STA SID+18
 LDY #4
 STA (RIGHTSID),Y
 LDY #11
 STA (RIGHTSID),Y
 LDY #18
 STA (RIGHTSID),Y
 LDA #$FD

PAUSEDB
 CMP KEYROWS
 BEQ PAUSEDB
 LDA #$FD

PAUSEWT
 CMP KEYROWS
 BNE PAUSEWT
 LDA #$41
 STA SID+18
 LDY #18
 STA (RIGHTSID),Y

ROWCMDS
 LDX #4
 LDA #0

CLRROWLOOP
 DEX
 STA SETVOLFLAG,X
 STA PORTAFLAG,X
 STA VSLIDE,X
 STA PSLIDE,X
 STA OFFSET,X
 STA VSLIDEDIR,X
 STA ARPFLAG,X
 STA VIBFLAG,X
 BNE CLRROWLOOP
 LDY #2
 LDA (PATINDEX),Y
 TAY
 LDX DIVIDE16,Y
 LDA JUMPTAB1L,X
 STA JSRCMD1+1
 LDA JUMPTAB1H,X
 STA JSRCMD1+2
 LDA COMMAND
 STA OLDCOMMAND
 STX COMMAND
 LDY #3
 LDX #0
 LDA CMDARG
 STA OLDCMDARG
 LDA (PATINDEX),Y
 STA CMDARG

JSRCMD1
 JSR $0000
 LDY #6
 LDA (PATINDEX),Y
 TAY
 LDX DIVIDE16,Y
 LDA JUMPTAB1L,X
 STA JSRCMD2+1
 LDA JUMPTAB1H,X
 STA JSRCMD2+2
 LDA COMMAND+1
 STA OLDCOMMAND+1
 STX COMMAND+1
 LDY #7
 LDX #1
 LDA CMDARG+1
 STA OLDCMDARG+1
 LDA (PATINDEX),Y
 STA CMDARG+1

JSRCMD2
 JSR $0000
 LDY #10
 LDA (PATINDEX),Y
 TAY
 LDX DIVIDE16,Y
 LDA JUMPTAB1L,X
 STA JSRCMD3+1
 LDA JUMPTAB1H,X
 STA JSRCMD3+2
 LDA COMMAND+2
 STA OLDCOMMAND+2
 STX COMMAND+2
 LDY #11
 LDX #2
 LDA CMDARG+2
 STA OLDCMDARG+2
 LDA (PATINDEX),Y
 STA CMDARG+2

JSRCMD3
 JSR $0000
 LDY #14
 LDA (PATINDEX),Y
 TAY
 LDX DIVIDE16,Y
 LDA JUMPTAB1L,X
 STA JSRCMD4+1
 LDA JUMPTAB1H,X
 STA JSRCMD4+2
 LDA COMMAND+3
 STA OLDCOMMAND+3
 STX COMMAND+3
 LDY #15
 LDX #3
 LDA CMDARG+3
 STA OLDCMDARG+3
 LDA (PATINDEX),Y
 STA CMDARG+3

JSRCMD4
 JSR $0000

 LDY #0
 LDA (PATINDEX),Y
 BEQ FREQCHK1
 LDY PORTAFLAG
 BNE FREQCHK1
 CMP SAMPLENUM
 STA SAMPLENUM
 BNE NS1
 LDY VSLIDE
 BEQ NS1
 LDX SAMPLENUM
 LDA VOLUMES,X
 LDX #0
 JSR SETVOL
 JMP FREQCHK1

NS1
 JSR SETSAMP1

FREQCHK1
 LDY #2
 LDA (PATINDEX),Y
 AND #$0F
 STA TEMPA
 DEY
 LDX #0
 ORA (PATINDEX),Y
 BEQ SAMPCHK2
 LDA PORTAFLAG
 BNE SAMPCHK2
 LDA TEMPA
 STA NOTEPERH
 LDA (PATINDEX),Y
 STA NOTEPERL
 JSR STEPCALC
 LDA OFFSET
 ORA VIBFLAG
 BNE NO1
 JSR START1
 LDA SETVOLFLAG
 BNE SAMPCHK2

NO1
 LDX SAMPLENUM
 LDA VOLUMES,X
 LDX #0
 JSR SETVOL

SAMPCHK2
 LDY #4
 LDA (PATINDEX),Y
 BEQ FREQCHK2
 LDY PORTAFLAG+1
 BNE FREQCHK2
 CMP SAMPLENUM+1
 STA SAMPLENUM+1
 BNE NS2
 LDY VSLIDE+1
 BEQ NS2
 LDX SAMPLENUM+1
 LDA VOLUMES,X
 LDX #1
 JSR SETVOL
 JMP FREQCHK2

NS2
 JSR SETSAMP2

FREQCHK2
 LDY #6
 LDA (PATINDEX),Y
 AND #$0F
 STA TEMPA
 DEY
 LDX #1
 ORA (PATINDEX),Y
 BEQ SAMPCHK3
 LDA PORTAFLAG+1
 BNE SAMPCHK3
 LDA TEMPA
 STA NOTEPERH+1
 LDA (PATINDEX),Y
 STA NOTEPERL+1
 JSR STEPCALC
 LDA OFFSET+1
 ORA VIBFLAG+1
 BNE NO2
 JSR START2
 LDA SETVOLFLAG+1
 BNE SAMPCHK3

NO2
 LDX SAMPLENUM+1
 LDA VOLUMES,X
 LDX #1
 JSR SETVOL

SAMPCHK3
 LDY #8
 LDA (PATINDEX),Y
 BEQ FREQCHK3
 LDY PORTAFLAG+2
 BNE FREQCHK3
 CMP SAMPLENUM+2
 STA SAMPLENUM+2
 BNE NS3
 LDY VSLIDE+2
 BEQ NS3
 LDX SAMPLENUM+2
 LDA VOLUMES,X
 LDX #2
 JSR SETVOL
 JMP FREQCHK3

NS3
 JSR SETSAMP3

FREQCHK3
 LDY #10
 LDA (PATINDEX),Y
 AND #$0F
 STA TEMPA
 DEY
 LDX #2
 ORA (PATINDEX),Y
 BEQ SAMPCHK4
 LDA PORTAFLAG+2
 BNE SAMPCHK4
 LDA TEMPA
 STA NOTEPERH+2
 LDA (PATINDEX),Y
 STA NOTEPERL+2
 JSR STEPCALC
 LDA OFFSET+2
 ORA VIBFLAG+2
 BNE NO3
 JSR START3
 LDA SETVOLFLAG+2
 BNE SAMPCHK4

NO3
 LDX SAMPLENUM+2
 LDA VOLUMES,X
 LDX #2
 JSR SETVOL

SAMPCHK4
 LDY #12
 LDA (PATINDEX),Y
 BEQ FREQCHK4
 LDY PORTAFLAG+3
 BNE FREQCHK4
 CMP SAMPLENUM+3
 STA SAMPLENUM+3
 BNE NS4
 LDY VSLIDE+3
 BEQ NS4
 LDX SAMPLENUM+3
 LDA VOLUMES,X
 LDX #3
 JSR SETVOL
 JMP FREQCHK4

NS4
 JSR SETSAMP4

FREQCHK4
 LDY #14
 LDA (PATINDEX),Y
 AND #$0F
 STA TEMPA
 DEY
 LDX #3
 ORA (PATINDEX),Y
 BEQ STARTMIXER
 LDA PORTAFLAG+3
 BNE STARTMIXER
 LDA TEMPA
 STA NOTEPERH+3
 LDA (PATINDEX),Y
 STA NOTEPERL+3
 JSR STEPCALC
 LDA OFFSET+3
 ORA VIBFLAG+3
 BNE NO4
 JSR START4
 LDA SETVOLFLAG+3
 BNE STARTMIXER

NO4
 LDX SAMPLENUM+3
 LDA VOLUMES,X
 LDX #3
 JSR SETVOL

STARTMIXER
 LDA TEMPOTPD
 SEC
 SBC #1
 STA TICKS
 LDA #>TRK1DATA
 STA DMAADH

 LDA #<TRK1DATA
 STA DMAADL
 LDA ARPFLAG
 BEQ NOARP1
 LDX #0
 JSR CALCARP

NOARP1
 LDA ARPFLAG+1
 BEQ NOARP2
 LDX #1
 JSR CALCARP

NOARP2
 LDA ARPFLAG+2
 BEQ NOARP3
 LDX #2
 JSR CALCARP

NOARP3
 LDA ARPFLAG+3
 BEQ VIBCHK1
 LDX #3
 JSR CALCARP

VIBCHK1
 LDX #0
 LDA VIBFLAG
 BNE VIB1
 STA VIBSTEPF
 STA VIBSTEPL
 STA VIBSTEPH
 JSR STEPCALC
 JMP VIBCHK2

VIB1
 JSR VIBCALC

VIBCHK2
 LDX #1
 LDA VIBFLAG+1
 BNE VIB2
 STA VIBSTEPF+1
 STA VIBSTEPL+1
 STA VIBSTEPH+1
 JSR STEPCALC
 JMP VIBCHK3

VIB2
 JSR VIBCALC

VIBCHK3
 LDX #2
 LDA VIBFLAG+2
 BNE VIB3
 STA VIBSTEPF+2
 STA VIBSTEPL+2
 STA VIBSTEPH+2
 JSR STEPCALC
 JMP VIBCHK4

VIB3
 JSR VIBCALC

VIBCHK4
 LDX #3
 LDA VIBFLAG+3
 BNE VIB4
 STA VIBSTEPF+3
 STA VIBSTEPL+3
 STA VIBSTEPH+3
 JSR STEPCALC
 JMP TIMETICK

VIB4
 JSR VIBCALC

TIMETICK
 JSR MIXER

TICKCMDS
 LDX COMMAND
 LDA JUMPTAB2L,X
 STA JSRTICKS1+1
 LDA JUMPTAB2H,X
 STA JSRTICKS1+2
 TXA
 LDX #0

JSRTICKS1
 JSR $0000

JS2
 LDX COMMAND+1
 LDA JUMPTAB2L,X
 STA JSRTICKS2+1
 LDA JUMPTAB2H,X
 STA JSRTICKS2+2
 TXA
 LDX #1

JSRTICKS2
 JSR $0000

JS3
 LDX COMMAND+2
 LDA JUMPTAB2L,X
 STA JSRTICKS3+1
 LDA JUMPTAB2H,X
 STA JSRTICKS3+2
 TXA
 LDX #2

JSRTICKS3
 JSR $0000

JS4
 LDX COMMAND+3
 LDA JUMPTAB2L,X
 STA JSRTICKS4+1
 LDA JUMPTAB2H,X
 STA JSRTICKS4+2
 TXA
 LDX #3

JSRTICKS4
 JSR $0000

NT
 LDA TICKS
 BEQ CHECKBREAK
 DEC TICKS
 BEQ CHECKBREAK
 JMP TIMETICK

CHECKBREAK
 JSR MIXER
 LDA BREAKADDR+1
 BEQ CHECKPATN
 LDA #0
 STA BREAKADDR
 STA BREAKADDR+1
 JMP NEXTPATN

CHECKPATN
 INC ROWNUMBER
 LDA BREAKADDR+1
 BNE NEXTPATN
 CLC
 LDA PATINDEX
 ADC #16
 STA PATINDEX
 BNE PATNOTDONE
 INC PATINDEX+1
 LDA PATINDEX+1
 CMP #>PATTERNTOP
 BEQ NEXTPATN

PATNOTDONE
 JMP STARTNOTE

NEXTPATN
 INC PATNUMBER
 LDA PATNUMBER
 CMP SONGLENGTH
 BEQ STOPSONG
 JMP NEWPATN

STOPSONG
 LDX #2

COPYLP2
 LDY $0000,X
 LDA PAGE0TEMP,X
 STA $00,X
 TYA
 STA PAGE0TEMP,X
 INX
 BNE COPYLP2

 LDA #55
 STA ROMBANK
 LDA #0
 JSR 65412
 JSR 65511
 JSR 65451
 JSR 65454
 LDA #27
 STA 53265
 LDA #0
 STA 53280
 LDA #23
 STA $DD00
 LDA #255
 STA $DD01
 LDA #63
 STA $DD02
 LDA #0
 STA $DD03
 LDA #$00
 STA $DD0E
 LDA #$7F
 STA $DD0D
 CLI
 LDA ABORTFLAG

UNUSED
 RTS

; OW COMMAND INTERPRETERS

ARPEGGIO
 BEQ STOPARP
 LDA #1
 STA ARPFLAG,X
 LDA CMDARG,X
 CMP OLDCMDARG,X
 BNE SAMEARP
 LDA #1
 STA ARPCOUNTER,X

SAMEARP
 RTS

STOPARP
 LDA #0
 STA ARPFLAG,X
 STA ARPNOTE1L,X
 STA ARPNOTE1H,X
 STA ARPNOTE2L,X
 STA ARPNOTE2H,X
 LDA #1
 STA ARPCOUNTER,X
 RTS

CALCARP
 LDA NOTEPERL,X
 CLC
 ADC #<NTPERIOD
 STA TEMPPNT1
 LDA NOTEPERH,X
 ADC #>NTPERIOD
 ADC NTPEROFF
 STA TEMPPNT1+1
 LDY #0
 LDA (TEMPPNT1),Y
 STA STEPL,X
 STA TEMPA
 LDA TEMPPNT1+1
 CLC
 ADC #4
 STA TEMPPNT1+1
 LDA (TEMPPNT1),Y
 STA STEPH,X
 STA TEMPA+1

; FIRST NEW NOTE

FIRSTNOTE
 LDA CMDARG,X
 LSR
 LSR
 LSR
 LSR
 TAY
 LDA ARPTABLEL,Y
 STA TEMPA
 LDA ARPTABLEH,Y
 STA TEMPA+1
 LDA STEPL,X
 STA TEMPB
 STA TEMPD
 LDA STEPH,X
 STA TEMPB+1
 LDA #0
 STA TEMPC
 STA TEMPC+1
 STA TEMPC+2
 STA TEMPA+2
 STA TEMPA+3
 CLC
 STX TEMPX
 JSR MULTBYTE
 LDA TEMPB+1
 STA TEMPD
 JSR MULTBYTE
 LDX TEMPX
 LDA TEMPC+1
 STA TEMPC
 LDA TEMPC+2
 STA TEMPC+1
 LDA TEMPC+3
 STA TEMPC+2
 LDA #0
 STA TEMPC+3
 LSR TEMPC+2
 ROR TEMPC+1
 ROR TEMPC
 LSR TEMPC+2
 ROR TEMPC+1
 ROR TEMPC
 LSR TEMPC+2
 ROR TEMPC+1
 ROR TEMPC
 LSR TEMPC+2
 ROR TEMPC+1
 ROR TEMPC
 LSR TEMPC+2
 ROR TEMPC+1
 ROR TEMPC
 LSR TEMPC+2
 ROR TEMPC+1
 ROR TEMPC
 LDA TEMPC
 STA ARPNOTE1L,X
 LDA TEMPC+1
 STA ARPNOTE1H,X

; SECOND NEW NOTE

 LDA CMDARG,X
 AND #$0F
 TAY
 LDA ARPTABLEL,Y
 STA TEMPA
 LDA ARPTABLEH,Y
 STA TEMPA+1
 LDA STEPL,X
 STA TEMPB
 STA TEMPD
 LDA STEPH,X
 STA TEMPB+1
 LDA #0
 STA TEMPC
 STA TEMPC+1
 STA TEMPC+2
 STA TEMPA+2
 STA TEMPA+3
 CLC
 STX TEMPX
 JSR MULTBYTE
 LDA TEMPB+1
 STA TEMPD
 JSR MULTBYTE
 LDX TEMPX
 LDA TEMPC+1
 STA TEMPC
 LDA TEMPC+2
 STA TEMPC+1
 LDA TEMPC+3
 STA TEMPC+2
 LDA #0
 STA TEMPC+3
 LSR TEMPC+2
 ROR TEMPC+1
 ROR TEMPC
 LSR TEMPC+2
 ROR TEMPC+1
 ROR TEMPC
 LSR TEMPC+2
 ROR TEMPC+1
 ROR TEMPC
 LSR TEMPC+2
 ROR TEMPC+1
 ROR TEMPC
 LSR TEMPC+2
 ROR TEMPC+1
 ROR TEMPC
 LSR TEMPC+2
 ROR TEMPC+1
 ROR TEMPC
 LDA TEMPC
 STA ARPNOTE2L,X
 LDA TEMPC+1
 STA ARPNOTE2H,X
 RTS

MULTBYTE
 LDX #0
 LDY #8

MLOOP1
 LDA TEMPD
 AND BITTABLE,X
 BEQ DONTADD
 LDA TEMPC
 ADC TEMPA
 STA TEMPC
 LDA TEMPC+1
 ADC TEMPA+1
 STA TEMPC+1
 LDA TEMPC+2
 ADC TEMPA+2
 STA TEMPC+2
 LDA TEMPC+3
 ADC TEMPA+3
 STA TEMPC+3 
 PHP
 ASL TEMPA
 ROL TEMPA+1
 ROL TEMPA+2
 ROL TEMPA+3
 PLP
 INX
 DEY
 BNE MLOOP1
 RTS

DONTADD
 ASL TEMPA
 ROL TEMPA+1
 ROL TEMPA+2
 ROL TEMPA+3
 INX
 DEY
 BNE MLOOP1
 RTS

SLIDEUP
 STA PSLIDE,X
 LDA #<HINOTE
 STA NOTESTOPL,X
 LDA #>HINOTE
 STA NOTESTOPH,X
 RTS

SLIDEDN
 STA PSLIDE,X
 LDA #<LONOTE
 STA NOTESTOPL,X
 LDA #>LONOTE
 STA NOTESTOPH,X
 RTS

SLIDE2NT
 BNE CKSL2NT

SNT
 LDA PORTA,X

CKSL2NT
 STA PSLIDE,X
 STA PORTA,X
 DEY
 DEY
 LDA (PATINDEX),Y
 STA TEMPPER
 INY
 LDA (PATINDEX),Y
 AND #$0F
 STA TEMPPER+1
 ORA TEMPPER
 BEQ CONTSLIDE
 LDA TEMPPER
 STA NOTESTOPL,X
 LDA TEMPPER+1
 STA NOTESTOPH,X

CONTSLIDE
 SEC
 LDA NOTEPERL,X
 SBC NOTESTOPL,X
 LDA NOTEPERH,X
 SBC NOTESTOPH,X
 LDA #2
 BCC PORDOWN
 LDA #1

PORDOWN
 STA PORTAFLAG,X
 LDA #3
 STA COMMAND,X
 LDA OLDCOMMAND,X
 BEQ HOLDPORTA
 CMP #1
 BEQ HOLDPORTA
 CMP #2
 BEQ HOLDPORTA
 CMP #3
 BEQ HOLDPORTA
 CMP #5
 BEQ HOLDPORTA
 JSR RETRIG
 LDY SAMPLENUM,X
 LDA VOLUMES,Y
 JMP SETVOL

HOLDPORTA
 RTS

VIBRATO
 LDA #1
 STA VIBFLAG,X
 RTS

VIBCALC
 LDA COMMAND,X
 CMP #5
 BNE STARTVIBC
 RTS

STARTVIBC
 STA TEMPA
 STX TEMPX
 LDA OLDCOMMAND,X
 CMP #4
 BEQ SAMEVIB1
 CMP #5
 BEQ SAMEVIB1
 JMP NEWVIBRATO

SAMEVIB1
 LDA TEMPA 
 BNE NVIB
 RTS

NEWVIBRATO
 LDA #0
 STA UPFLAG,X
 STA STEPFRACT,X

NVIB
 STX TEMPX
 CLC
 LDA NOTEPERL,X
 ADC #<NTPERIOD
 STA TEMPPNT1
 LDA NOTEPERH,X
 ADC #>NTPERIOD
 ADC NTPEROFF
 STA TEMPPNT1+1
 LDY #0
 LDA (TEMPPNT1),Y
 STA VIBBOTL,X
 CLC
 LDA TEMPPNT1+1
 ADC #4
 STA TEMPPNT1+1
 LDA (TEMPPNT1),Y
 STA VIBBOTH,X
 LDA TEMPA
 LSR
 LSR
 LSR
 LSR
 AND #$0F
 BNE NEWRATE
 LDA VIBRATE,X
 
NEWRATE
 STA VIBRATE,X
 LDA TEMPA
 AND #$0F
 BNE NEWDEPTH
 LDA VIBDEPTH,X

NEWDEPTH
 STA VIBDEPTH,X
 TAY
 LDA VIBTABLEL,Y
 STA TEMPB
 LDA VIBTABLEH,Y
 STA TEMPB+1
 LDA #0
 STA TEMPA+2
 STA TEMPA+3
 STA TEMPB+2
 STA TEMPC
 STA TEMPC+1
 STA TEMPC+2
 STA TEMPC+3
 STA TEMPC+4
 LDA VIBBOTL,X
 STA TEMPA
 LDA VIBBOTH,X
 STA TEMPA+1
 CLC
 LDA TEMPB
 STA TEMPD
 JSR MULTBYTE
 LDA TEMPB+1
 STA TEMPD
 JSR MULTBYTE

 LDX TEMPX
 LDA TEMPC+1
 STA TEMPC
 LDA TEMPC+2
 STA TEMPC+1
 LDA TEMPC+3
 STA TEMPC+2
 LDA #0
 STA TEMPC+3
 LSR TEMPC+2
 ROR TEMPC+1
 ROR TEMPC
 LSR TEMPC+2
 ROR TEMPC+1
 ROR TEMPC
 LSR TEMPC+2
 ROR TEMPC+1
 ROR TEMPC
 LSR TEMPC+2
 ROR TEMPC+1
 ROR TEMPC
 LSR TEMPC+2
 ROR TEMPC+1
 ROR TEMPC
 LSR TEMPC+2
 ROR TEMPC+1
 ROR TEMPC

 LDA TEMPC
 STA VIBTOPL,X
 LDA TEMPC+1
 STA VIBTOPH,X
 LDA #0
 STA TEMPC
 STA TEMPC+1
 STA TEMPC+2
 STA TEMPC+3
 STA TEMPC+4
 STA TEMPA+2
 STA TEMPA+3
 STA TEMPA+4

 SEC
 LDA VIBTOPL,X
 SBC VIBBOTL,X
 STA TEMPA
 LDA VIBTOPH,X
 SBC VIBBOTH,X
 STA TEMPA+1
 LDA VIBRATE,X 
 STA TEMPD
 CLC
 LDY #4
 LDX #0
 JSR MBYTE2
 LDX TEMPX
 LDA #0
 LSR TEMPC+1
 ROR TEMPC
 ROR
 LSR TEMPC+1
 ROR TEMPC
 ROR
 LSR TEMPC+1
 ROR TEMPC
 ROR
 LSR TEMPC+1
 ROR TEMPC
 ROR
 LSR TEMPC+1
 ROR TEMPC
 ROR
 LSR TEMPC+1
 ROR TEMPC
 ROR

TRIWAVE1
 STA VIBSTEPF,X
 LDA TEMPC
 STA VIBSTEPL,X
 LDA TEMPC+1
 STA VIBSTEPH,X
 LDA VIBWAVE,X
 CMP #2
 BNE NEWVIB2

 LDA OLDCOMMAND,X
 CMP #4
 BEQ SAMEVIB

NEWVIB2
 LDA TEMPOTPD
 STA VIBCOUNTER,X
 LSR
 STA VIBHALFC,X
 LDA VIBBOTL,X
 STA STEPL,X
 STA TEMPA
 LDA VIBBOTH,X
 STA STEPH,X
 STA TEMPA+1
 JMP STEPCALC2

SAMEVIB
 RTS

MBYTE2
 LDA TEMPD
 AND BITTABLE,X
 BEQ NOADD2
 LDA TEMPC
 ADC TEMPA
 STA TEMPC
 LDA TEMPC+1 
 ADC TEMPA+1
 STA TEMPC+1
 LDA TEMPC+2
 ADC TEMPA+2
 STA TEMPC+2
 PHP
 ASL TEMPA
 ROL TEMPA+1
 ROL TEMPA+2
 PLP
 INX
 DEY 
 BNE MBYTE2
 RTS

NOADD2
 PHP
 ASL TEMPA
 ROL TEMPA+1
 ROL TEMPA+2
 PLP
 INX
 DEY
 BNE MBYTE2
 RTS

SLIDEVS
 STX TEMPX
 STY TEMPY
 JSR VOLSLIDE
 LDY TEMPY
 JSR SNT
 LDX TEMPX
 LDA #5
 STA COMMAND,X
 LDA #1
 STA SETVOLFLAG,X
 RTS

VIBRATOVS
 STX TEMPX
 JSR VOLSLIDE
 LDX TEMPX
 LDA #6
 STA COMMAND,X
 LDA #1
 STA SETVOLFLAG,X
 STA VIBFLAG,X
 RTS

SOFFSET
 STA OFFSET,X
 RTS

VOLSLIDE
 STA TEMPA
 TAY
 LDA DIVIDE16,Y
 BEQ CHKY
 STA VSLIDE,X
 LDA #1
 STA VSLIDEDIR,X
 STA SETVOLFLAG,X
 LDA TEMPA
 RTS

CHKY
 LDA TEMPA
 AND #$0F
 BEQ NOVLS
 STA VSLIDE,X
 LDA #0
 STA VSLIDEDIR,X
 LDA #1
 STA SETVOLFLAG,X

NOVLS
 LDA TEMPA
 RTS

POSJUMP
 STA TEMPA
 SEC
 CMP SONGLENGTH
 BEQ SETPOS
 BCC SETPOS
 LDA #0
 STA BREAKADDR
 STA BREAKADDR+1
 RTS

SETPOS
 LDA TEMPA
 SEC
 SBC #1
 STA PATNUMBER
 LDA #<PATTERNBUF
 STA BREAKADDR
 LDA #>PATTERNBUF
 STA BREAKADDR+1
 RTS

SETVOL
 SEC
 CMP #64
 BCC SV
 LDA #63

SV
 STA TRACKVOL,X
 LDA ENABLEFLGS
 AND BITTABLE,X
 BEQ NOVOL
 LDA TRACKVOL,X
 LDY #1
 STY SETVOLFLAG,X

SV2
 TAY
 TXA
 ASL
 TAX
 TYA
 CLC
 ADC #>VOLTABLE
 STA VOL1+1,X

NOVOL
 RTS

PATBRK
 STA TEMPA
 AND #$0F
 STA TEMPB
 LDA TEMPA
 AND #$F0
 LSR
 LSR
 STA TEMPA
 LSR
 LSR
 CLC
 ADC TEMPA
 ASL
 ADC TEMPB
 LDX #0
 STX TEMPB
 ASL
 ROL TEMPB
 ASL
 ROL TEMPB
 ASL
 ROL TEMPB
 ASL
 ROL TEMPB
 CLC
 ADC #<PATTERNBUF
 STA BREAKADDR
 LDA TEMPB
 ADC #>PATTERNBUF
 STA BREAKADDR+1
 RTS

SETSPEED
 LDA CMDARG,X
 BNE DOSPD
 RTS

DOSPD
 SEC
 CMP #$20
 BCC SETTICKS
 STA TEMPOBPM
 JMP CALCTEMPO

SETTICKS
 STA TEMPOTPD

CALCTEMPO
 LDX TEMPOBPM
 LDA TEMPOTBH,X
 STA TEMPO+1
 LDA TEMPOTBL,X
 STA TEMPO
 LDA #$49
 STA $DD0E
 RTS

; 'ICK' COMMAND INTERPRETERS

DARPEGGIO
 LDA CMDARG,X
 BNE ARP1
 RTS

ARP1
 LDA ARPCOUNTER,X
 BNE NEWNOTE1
 JSR STEPCALC
 JMP INCARPCNT

NEWNOTE1
 AND #$01
 BEQ NEWNOTE2
 CLC
 LDA ARPNOTE1L,X
 STA STEPL,X
 STA TEMPA
 LDA ARPNOTE1H,X
 STA STEPH,X
 STA TEMPA+1
 JSR STEPCALC2
 JMP INCARPCNT

NEWNOTE2
 CLC
 LDA ARPNOTE2L,X
 STA STEPL,X
 STA TEMPA
 LDA ARPNOTE2H,X
 STA STEPH,X
 STA TEMPA+1
 JSR STEPCALC2

INCARPCNT
 INC ARPCOUNTER,X
 LDA ARPCOUNTER,X
 CMP #3
 BNE COUNTEROK
 LDA #0
 STA ARPCOUNTER,X

COUNTEROK
 RTS

DSLIDEUP
 LDA NOTEPERL,X
 SEC
 SBC PSLIDE,X
 STA NOTEPERL,X
 LDA NOTEPERH,X
 SBC #0
 STA NOTEPERH,X
 BCC ENDOFSUP
 LDA NOTEPERL,X
 SEC
 SBC NOTESTOPL,X
 LDA NOTEPERH,X
 SBC NOTESTOPH,X
 BCC ENDOFSUP
 JSR STEPCALC
 RTS

ENDOFSUP
 LDA NOTESTOPL,X
 STA NOTEPERL,X
 LDA NOTESTOPH,X
 STA NOTEPERH,X
 JSR STEPCALC
 LDA #0
 STA PSLIDE,X
 STA PORTAFLAG,X
 RTS

DSLIDEDN
 LDA NOTEPERL,X
 CLC
 ADC PSLIDE,X
 STA NOTEPERL,X
 LDA NOTEPERH,X
 ADC #0
 STA NOTEPERH,X
 LDA NOTEPERL,X
 SEC
 SBC NOTESTOPL,X
 LDA NOTEPERH,X
 SBC NOTESTOPH,X
 BCS ENDOFSDN
 JSR STEPCALC
 RTS

ENDOFSDN
 LDA NOTESTOPL,X
 STA NOTEPERL,X
 LDA NOTESTOPH,X
 STA NOTEPERH,X
 JSR STEPCALC
 LDA #0
 STA PSLIDE,X
 STA PORTAFLAG,X
 RTS

DSLIDE2NT
 LDA PORTAFLAG,X
 BNE S2NT
 STA PSLIDE,X
 RTS

S2NT
 CMP #1
 BEQ DSLIDEUP
 CMP #2
 BEQ DSLIDEDN
 LDA #0
 STA PSLIDE,X
 STA PORTAFLAG,X
 RTS

NOVIB
 RTS

DVIBRATO
 STX TEMPX
 LDA VIBFLAG,X
 BEQ NOVIB
 LDA VIBWAVE,X
 BEQ TRI
 JMP NOTTRI

TRI
 LDA UPFLAG,X
 BNE GOUP

GODOWN
 SEC
 LDA STEPFRACT,X
 SBC VIBSTEPF,X
 STA STEPFRACT,X
 LDA STEPL,X
 SBC VIBSTEPL,X
 STA STEPL,X
 STA TEMPA
 LDA STEPH,X
 SBC VIBSTEPH,X
 STA STEPH,X
 STA TEMPA+1
 SEC
 LDA VIBBOTL,X
 CMP TEMPA
 LDA VIBBOTH,X
 CMP TEMPA+1
 BCS TOOLOW
 LDA TEMPA+1
 JMP STEPCALC2

TOOLOW
 LDA #1
 STA UPFLAG,X
 LDA #0
 STA STEPFRACT,X
 LDA VIBBOTL,X
 STA STEPL,X
 STA TEMPA
 LDA VIBBOTH,X
 STA STEPH,X
 STA TEMPA+1
 JMP STEPCALC2

GOUP
 CLC
 LDA STEPFRACT,X
 ADC VIBSTEPF,X
 STA STEPFRACT,X
 LDA STEPL,X
 ADC VIBSTEPL,X
 STA STEPL,X
 STA TEMPA
 LDA STEPH,X
 ADC VIBSTEPH,X
 STA STEPH,X
 STA TEMPA+1
 SEC
 LDA TEMPA
 CMP VIBTOPL,X
 LDA TEMPA+1
 CMP VIBTOPH,X
 BCS TOOHIGH
 LDA TEMPA+1
 JMP STEPCALC2

TOOHIGH
 LDA #0
 STA UPFLAG,X
 STA STEPFRACT,X
 LDA VIBTOPL,X
 STA STEPL,X
 STA TEMPA
 LDA VIBTOPH,X
 STA STEPH,X
 STA TEMPA+1
 JMP STEPCALC2

NOTTRI
 CMP #2
 BEQ SQUARE

RAMP
 LDA #0
 STA UPFLAG,X
 SEC
 LDA STEPFRACT,X
 SBC VIBSTEPF,X
 STA STEPFRACT,X
 LDA STEPL,X
 SBC VIBSTEPL,X
 STA STEPL,X
 STA TEMPA
 LDA STEPH,X
 SBC VIBSTEPH,X
 STA STEPH,X
 STA TEMPA+1
 SEC
 LDA VIBBOTL,X
 CMP TEMPA
 LDA VIBBOTH,X
 CMP TEMPA+1
 BCS TOOLOW2
 LDA TEMPA+1
 JMP STEPCALC2

TOOLOW2
 LDA #0
 STA UPFLAG,X
 STA STEPFRACT,X
 LDA VIBTOPL,X
 STA STEPL,X
 STA TEMPA
 LDA VIBTOPH,X
 STA STEPH,X
 STA TEMPA+1
 JMP STEPCALC2 

SQUARE
 SEC
 LDA VIBCOUNTER,X
 CMP VIBHALFC,X
 BCS HIGH

LOW
 LDA VIBBOTL,X
 STA STEPL,X
 STA TEMPA
 LDA VIBBOTH,X
 STA STEPH,X
 STA TEMPA+1
 JMP STEPCALC2
 
HIGH
 LDA VIBTOPL,X
 STA STEPL,X
 STA TEMPA
 LDA VIBTOPH,X
 STA STEPH,X
 STA TEMPA+1
 JMP STEPCALC2

DVIBRATOVS
 STX TEMPX
 JSR DVOLSLIDE
 LDX TEMPX
 JMP DVIBRATO

DSLIDEVS
 STX TEMPX
 JSR DVOLSLIDE
 LDX TEMPX
 JMP DSLIDE2NT

DVOLSLIDE
 LDA VSLIDEDIR,X
 BEQ VOLDOWN
 CLC
 LDA TRACKVOL,X
 ADC VSLIDE,X
 JMP SETVOL

VOLDOWN
 SEC
 LDA TRACKVOL,X
 SBC VSLIDE,X
 BCS DOVOL
 LDA #0

DOVOL
 JMP SV

; ISC. OUTINES..

RETRIG
 LDA STARTL,X
 STA TRKPNTL,X
 LDA STARTH,X
 STA TRKPNTH,X
 LDA STARTB,X
 STA TRKPNTB,X
 LDA #0
 STA ARPCOUNTER,X
 RTS

SETSAMP1
 LDY #0
 LDA (PATINDEX),Y
 TAX
 LDA LSBSADDR,X
 STA STARTL
 STA TRKPNTL
 LDA MSBSADDR,X
 STA STARTH
 CLC
 ADC OFFSET
 STA TRKPNTH
 LDA BNKSADDR,X
 STA STARTB
 ADC #0
 STA TRKPNTB
 LDA LSBSEND,X
 STA ENDL
 LDA MSBSEND,X
 STA ENDH
 LDA BNKSEND,X
 STA ENDB
 LDA #0
 STA FRACTION
 LDA SETVOLFLAG
 BNE ES1
 LDX SAMPLENUM
 LDA VOLUMES,X
 LDX #0
 JSR SETVOL

ES1
 RTS

SETSAMP2
 LDY #4
 LDA (PATINDEX),Y
 TAX
 LDA LSBSADDR,X
 STA STARTL+1
 STA TRKPNTL+1
 LDA MSBSADDR,X
 STA STARTH+1
 CLC
 ADC OFFSET+1
 STA TRKPNTH+1
 LDA BNKSADDR,X
 STA STARTB+1
 ADC #0
 STA TRKPNTB+1
 LDA LSBSEND,X
 STA ENDL+1
 LDA MSBSEND,X
 STA ENDH+1
 LDA BNKSEND,X
 STA ENDB+1
 LDA #0
 STA FRACTION+1
 LDA SETVOLFLAG+1
 BNE ES2
 LDX SAMPLENUM+1
 LDA VOLUMES,X
 LDX #1
 JSR SETVOL

ES2
 RTS

SETSAMP3
 LDY #8
 LDA (PATINDEX),Y
 TAX
 LDA LSBSADDR,X
 STA STARTL+2
 STA TRKPNTL+2
 LDA MSBSADDR,X
 STA STARTH+2
 CLC
 ADC OFFSET+2
 STA TRKPNTH+2
 LDA BNKSADDR,X
 STA STARTB+2
 ADC #0
 STA TRKPNTB+2
 LDA LSBSEND,X
 STA ENDL+2
 LDA MSBSEND,X
 STA ENDH+2
 LDA BNKSEND,X
 STA ENDB+2
 LDA #0
 STA FRACTION+2
 LDA SETVOLFLAG+2
 BNE ES3
 LDX SAMPLENUM+2
 LDA VOLUMES,X
 LDX #2
 JSR SETVOL

ES3
 RTS

SETSAMP4
 LDY #12
 LDA (PATINDEX),Y
 TAX
 LDA LSBSADDR,X
 STA STARTL+3
 STA TRKPNTL+3
 LDA MSBSADDR,X
 STA STARTH+3
 CLC
 ADC OFFSET+3
 STA TRKPNTH+3
 LDA BNKSADDR,X
 STA STARTB+3
 ADC #0
 STA TRKPNTB+3
 LDA LSBSEND,X
 STA ENDL+3
 LDA MSBSEND,X
 STA ENDH+3
 LDA BNKSEND,X
 STA ENDB+3
 LDA #0
 STA FRACTION+3
 LDA SETVOLFLAG+3
 BNE ES4
 LDX SAMPLENUM+3
 LDA VOLUMES,X
 LDX #3
 JSR SETVOL

ES4
 RTS

STEPCALC
 LDA NOTEPERL,X
 CLC
 ADC #<NTPERIOD
 STA TEMPPNT1
 LDA NOTEPERH,X
 ADC #>NTPERIOD
 ADC NTPEROFF
 STA TEMPPNT1+1
 LDY #0
 LDA (TEMPPNT1),Y
 STA STEPL,X
 STA TEMPA
 LDA TEMPPNT1+1
 CLC
 ADC #4
 STA TEMPPNT1+1
 LDA (TEMPPNT1),Y
 STA STEPH,X
 STA TEMPA+1

STEPCALC2
 LSR
 STA FIFTH,X        ; 4/8
 ROR TEMPA
 LSR
 STA THIRD,X        ; 2/8
 STA TEMPB+1
 ROR TEMPA
 LSR
 STA SECOND,X       ; 1/8
 STA TEMPA+1
 ROR TEMPA
 LDA TEMPA
 ASL 
 STA TEMPB
 CLC
 LDA TEMPA
 ADC TEMPB
 STA TEMPC
 LDA TEMPA+1
 ADC TEMPB+1
 STA TEMPC+1
 STA FOURTH,X       ; 3/8
 LDA TEMPB
 ADC TEMPC
 STA TEMPD
 LDA TEMPB+1
 ADC TEMPC+1
 STA TEMPD+1
 STA SIXTH,X        ; 5/8
 LDA TEMPD
 ADC TEMPA
 STA TEMPD
 LDA TEMPD+1
 ADC TEMPA+1
 STA TEMPD+1
 STA SEVENTH,X      ; 6/8
 LDA TEMPD
 ADC TEMPA
 LDA TEMPD+1
 ADC TEMPA+1
 STA EIGHTH,X       ; 7/8
 RTS
 
START1
 LDA STARTL
 STA TRKPNTL
 LDA STARTH
 STA TRKPNTH
 LDA STARTB
 STA TRKPNTB
 LDA #0
 STA ARPCOUNTER
 RTS

START2
 LDA STARTL+1
 STA TRKPNTL+1
 LDA STARTH+1
 STA TRKPNTH+1
 LDA STARTB+1
 STA TRKPNTB+1
 LDA #0
 STA ARPCOUNTER+1
 RTS

START3
 LDA STARTL+2
 STA TRKPNTL+2
 LDA STARTH+2
 STA TRKPNTH+2
 LDA STARTB+2
 STA TRKPNTB+2
 LDA #0
 STA ARPCOUNTER+2
 RTS

START4
 LDA STARTL+3
 STA TRKPNTL+3
 LDA STARTH+3
 STA TRKPNTH+3
 LDA STARTB+3
 STA TRKPNTB+3
 LDA #0
 STA ARPCOUNTER+3
 RTS

; AMPLE LAYER OUTINES

PLAYSAMP
 SEI
 LDA $FD
 STA STEPSA+1
 LDA $FE
 STA STEPSB+1
 LDX #54
 STX ROMBANK
 LDX $FC
 LDA LSBSADDR,X
 STA STARTSA+1
 LDA MSBSADDR,X
 STA STARTSB+1
 LDA BNKSADDR,X
 STA STARTSC+1
 CLC
 LDA LSBSEND,X
 STA ENDSMPA+1
 LDA MSBSEND,X
 STA ENDSMPB+1
 LDA BNKSEND,X
 STA ENDSMPC+1
 JSR STARTSA
 LDA #<REUDATA
 STA DMAADL
 LDA #>REUDATA
 STA DMAADH
 LDA #$C0
 STA DMAVER
 LDY #0

UPDATES
 CLC
FRACTS LDA #0
STEPSA ADC #0
 STA FRACTS+1
SAMPPNTA LDA #0
STEPSB ADC #0
 STA SAMPPNTA+1
 STA DMALO
SAMPPNTB LDA #0
 ADC #0
 STA SAMPPNTB+1
 STA DMAHI
SAMPPNTC LDA #0
 ADC #0
 STA SAMPPNTC+1
 STA DMABNK
 LDA #1
 STA DMADAL
 LDA #$95
 STA DMACMD
 SEC
 LDA SAMPPNTA+1
ENDSMPA SBC #0
 LDA SAMPPNTB+1
ENDSMPB SBC #0
 LDA SAMPPNTC+1
ENDSMPC SBC #0
 BCC CYCLESMP
 LDA LSBLPPNT,X
 ORA MSBLPPNT,X
 ORA BNKLPPNT,X
 ORA LSBLPLEN,X
 ORA MSBLPLEN,X
 ORA BNKLPLEN,X
 BEQ STOPSAMP
 CLC
 LDA LSBSADDR,X
 ADC LSBLPPNT,X
 STA SAMPPNTA+1
 LDA MSBSADDR,X
 ADC MSBLPPNT,X
 STA SAMPPNTB+1
 LDA BNKSADDR,X
 ADC BNKLPPNT,X
 STA SAMPPNTC+1
 CLC
 LDA SAMPPNTA+1
 ADC LSBLPLEN,X
 STA ENDSMPA+1
 LDA SAMPPNTB+1
 ADC MSBLPLEN,X
 STA ENDSMPB+1
 LDA SAMPPNTC+1
 ADC BNKLPLEN,X
 STA ENDSMPC+1
 JMP UPDATES

CYCLESMP
 LDA REUDATA
 STA USEROUT
 LDA #$7F
 STA KEYCOLS
 LDA KEYROWS
 CMP #$EF
 BEQ STOPSAMP
 JMP UPDATES

STOPSAMP
 LDA #0
 STA DMAVER
 LDA #55
 STA ROMBANK
 CLI
 RTS

STARTSA LDA #0
 STA SAMPPNTA+1
STARTSB LDA #0
 STA SAMPPNTB+1
STARTSC LDA #0
 STA SAMPPNTC+1
 RTS

INITSOUND
 LDA PLAYMODE
 CMP #1
 BEQ SID4INIT
 CMP #2
 BEQ SID8INIT
 CMP #3
 BNE EXITINIT
 JMP DIGIINIT
EXITINIT
 RTS

SID4INIT
 JSR SILENCESID
 LDA DITHER
 BEQ NODITHER  
 LDA #$FF
 STA SID+14
 LDY #14
 STA (RIGHTSID),Y
 STA SID+15
 LDY #15
 STA (RIGHTSID),Y
 LDA #$81
 STA SID+18
 LDY #18
 STA (RIGHTSID),Y
NODITHER
 LDA VOLFIX
 BEQ NOVOLFIX
 LDA #$F0
 STA SID+6
 LDY #6
 STA (RIGHTSID),Y
 LDA #$41
 STA SID+4
 LDY #4
 STA (RIGHTSID),Y
NOVOLFIX
 RTS

SID8INIT
 JSR SILENCESID
 LDA #120
 STA SID+1
 LDY #1
 STA (RIGHTSID),Y
 STA SID+8
 LDY #8
 STA (RIGHTSID),Y
 LDA #$10
 STA SID+6
 LDY #6
 STA (RIGHTSID),Y
 LDA #$C0
 STA SID+13
 LDY #13
 STA (RIGHTSID),Y
 LDA #$70
 STA SID+20
 LDY #20
 STA (RIGHTSID),Y 
 LDA #$FF
 STA SID+16
 STA SID+17
 LDY #16
 STA (RIGHTSID),Y
 INY
 STA (RIGHTSID),Y
 LDX STEREO
 BNE DOSTEREO
 LDA #$0F
 STA SID+24
 RTS

DOSTEREO
 LDA BALLEFT
 STA SID+24
 LDA BALRIGHT
 LDY #24
 STA (RIGHTSID),Y
 RTS

DIGIINIT
 JSR SILENCE
 LDA #$FF
 STA $DD03 
 RTS

SILENCE
 LDA #55
 STA ROMBANK
 LDA #$00
 STA $DD01

SILENCESID
 LDA RSIDCOPY
 STA RIGHTSID+1
 LDA #0
 STA RIGHTSID
 LDY #$1F
SILENCELP1
 STA SID,Y
 STA (RIGHTSID),Y
 DEY
 BPL SILENCELP1
 RTS

; HIS PART DECIDES WHICH MIXER TO USE

MIXER
 LDA STEREO
 BNE PLAYSTEREO

PLAYMONO
 LDA PLAYMODE
 CMP #1
 BNE NM1
 JMP SID4UD1
NM1
 CMP #2
 BNE NM2
 JMP MIXER8MONO
NM2
 CMP #3
 BNE NM3
 JMP USERUD1
NM3
 PLA
 PLA
 JMP STOPSONG   ; ORCES THE SONG TO STOP PLAYING IF
                ; IXER # GET'S CORRUPTED.

PLAYSTEREO
 LDA PLAYMODE
 CMP #1
 BNE NSTR1
 JMP SID4SUD1
NSTR1
 CMP #2
 BNE NSTR2
 JMP MIXER8STEREO
NSTR2
 CMP #3
 BNE NM3
 JMP DIGIUD1

; IXER FOR 4 BIT ONO  (ITHERING VAILABLE)

SID4UD1
 LDA #<TRK1DATA
 STA DMAADL
 CLC
 LDA FRACTION
 ADC STEPL
 STA FRACTION
 LDA TRKPNTL
 ADC STEPH
 STA TRKPNTL
 STA DMALO
 LDA TRKPNTH
 ADC #0
 STA TRKPNTH
 STA DMAHI
 LDA TRKPNTB
 ADC #0
 STA TRKPNTB
 STA DMABNK
 LDA #8
 STA DMADAL

 CLC
 LDX EIGHTH
 LDY TRK1DATA,X
 LDA (VOL1),Y
 LDX SECOND+3
 LDY TRK4DATA,X
 ADC (VOL4),Y
 LSR
 STA TEMPA
 LDX SIXTH+1
 LDY TRK2DATA,X
 LDA (VOL2),Y
 LDX FOURTH+2
 LDY TRK3DATA,X
 ADC (VOL3),Y
 LSR
 ADC TEMPA
 LDY DITHER
 BEQ SID4OK1
 STA TEMPA
 LDA SIDNOISE
 AND #$0F
 ADC TEMPA
 BCC SID4OK1
 LDA #255
 CLC
SID4OK1
 TAY
 LDA DIVIDE16,Y
 ORA #$90
 STA SID4OUT

 LDX DELAY
DLLP9
 DEX
 BNE DLLP9
 
 LDA #$95
 STA DMACMD

 LDY TRK1DATA
 LDA (VOL1),Y
 LDX THIRD+3
 LDY TRK4DATA,X
 ADC (VOL4),Y
 LSR
 STA TEMPA
 LDX SEVENTH+1
 LDY TRK2DATA,X
 LDA (VOL2),Y
 LDX FIFTH+2
 LDY TRK3DATA,X
 ADC (VOL3),Y
 LSR
 ADC TEMPA
 LDY DITHER
 BEQ SID4OK2
 STA TEMPA
 LDA SIDNOISE
 AND #$0F
 ADC TEMPA
 BCC SID4OK2
 LDA #255
SID4OK2
 TAY
 LDA DIVIDE16,Y
 ORA #$90
 STA SID4OUT

 LDX DELAY
DLLP10
 DEX
 BNE DLLP10
 
 SEC
 LDA TRKPNTL
 SBC ENDL
 LDA TRKPNTH
 SBC ENDH
 LDA TRKPNTB
 SBC ENDB
 BCC SID4UD2
 LDX SAMPLENUM
 LDA LSBLPLEN,X
 ORA MSBLPLEN,X
 ORA BNKLPLEN,X
 BNE SID4LP1
 LDX #0
 JSR RETRIG
 LDA #0
 STA SECOND
 STA THIRD
 STA FOURTH
 STA FIFTH
 STA SIXTH
 STA SEVENTH
 STA EIGHTH
 STA STEPL
 STA STEPH
 JSR SV2
 JMP SID4UD2

SID4LP1
 CLC
 LDA LSBSADDR,X
 ADC LSBLPPNT,X
 STA STARTL
 LDA MSBSADDR,X
 ADC MSBLPPNT,X
 STA STARTH
 LDA BNKSADDR,X
 ADC BNKLPPNT,X
 STA STARTB
 LDA LSBLPLEN,X
 ADC STARTL
 STA ENDL
 LDA MSBLPLEN,X
 ADC STARTH
 STA ENDH
 LDA BNKLPLEN,X
 ADC STARTB
 STA ENDB
 LDX #0
 JSR RETRIG

SID4UD2
 LDA FRACTION+1
 ADC STEPL+1
 STA FRACTION+1
 LDA TRKPNTL+1
 ADC STEPH+1
 STA TRKPNTL+1
 STA DMALO
 LDA TRKPNTH+1
 ADC #0
 STA TRKPNTH+1
 STA DMAHI
 LDA TRKPNTB+1
 ADC #0
 STA TRKPNTB+1
 STA DMABNK
 LDA #8
 STA DMADAL

 CLC
 LDX SECOND
 LDY TRK1DATA,X
 LDA (VOL1),Y
 LDX FOURTH+3
 LDY TRK4DATA,X
 ADC (VOL4),Y
 LSR
 STA TEMPA
 LDX EIGHTH+1
 LDY TRK2DATA,X
 LDA (VOL2),Y
 LDX SIXTH+2
 LDY TRK3DATA,X
 ADC (VOL3),Y
 LSR
 ADC TEMPA
 LDY DITHER
 BEQ SID4OK3
 STA TEMPA
 LDA SIDNOISE
 AND #$0F
 ADC TEMPA
 BCC SID4OK3
 LDA #255
 CLC
SID4OK3
 TAY
 LDA DIVIDE16,Y
 ORA #$90
 STA SID4OUT

 LDX DELAY
DLLP11
 DEX
 BNE DLLP11
 
 LDA #$95
 STA DMACMD

 LDX THIRD
 LDY TRK1DATA,X
 LDA (VOL1),Y
 LDX FIFTH+3
 LDY TRK4DATA,X
 ADC (VOL4),Y
 LSR
 STA TEMPA
 LDY TRK2DATA
 LDA (VOL2),Y
 LDX SEVENTH+2
 LDY TRK3DATA,X
 ADC (VOL3),Y
 LSR
 ADC TEMPA
 LDY DITHER
 BEQ SID4OK4
 STA TEMPA
 LDA SIDNOISE
 AND #$0F
 ADC TEMPA
 BCC SID4OK4
 LDA #255
SID4OK4
 TAY
 LDA DIVIDE16,Y
 ORA #$90
 STA SID4OUT

 LDX DELAY
DLLP12
 DEX
 BNE DLLP12 

 SEC
 LDA TRKPNTL+1
 SBC ENDL+1
 LDA TRKPNTH+1
 SBC ENDH+1
 LDA TRKPNTB+1
 SBC ENDB+1
 BCC SID4UD3
 LDX SAMPLENUM+1
 LDA LSBLPLEN,X
 ORA MSBLPLEN,X
 ORA BNKLPLEN,X
 BNE SID4LP2
 LDX #1
 JSR RETRIG
 LDA #0
 STA SECOND+1
 STA THIRD+1
 STA FOURTH+1
 STA FIFTH+1
 STA SIXTH+1
 STA SEVENTH+1
 STA EIGHTH+1
 STA STEPL+1
 STA STEPH+1
 JSR SV2
 JMP SID4UD3

SID4LP2
 CLC
 LDA LSBSADDR,X
 ADC LSBLPPNT,X
 STA STARTL+1
 LDA MSBSADDR,X
 ADC MSBLPPNT,X
 STA STARTH+1
 LDA BNKSADDR,X
 ADC BNKLPPNT,X
 STA STARTB+1
 LDA LSBLPLEN,X
 ADC STARTL+1
 STA ENDL+1
 LDA MSBLPLEN,X
 ADC STARTH+1
 STA ENDH+1
 LDA BNKLPLEN,X
 ADC STARTB+1
 STA ENDB+1
 LDX #1
 JSR RETRIG

SID4UD3
 LDA FRACTION+2
 ADC STEPL+2
 STA FRACTION+2
 LDA TRKPNTL+2
 ADC STEPH+2
 STA TRKPNTL+2
 STA DMALO
 LDA TRKPNTH+2
 ADC #0
 STA TRKPNTH+2
 STA DMAHI
 LDA TRKPNTB+2
 ADC #0
 STA TRKPNTB+2
 STA DMABNK
 LDA #8
 STA DMADAL

 CLC
 LDX FOURTH
 LDY TRK1DATA,X
 LDA (VOL1),Y
 LDX SIXTH+3
 LDY TRK4DATA,X
 ADC (VOL4),Y
 LSR
 STA TEMPA
 LDX SECOND+1
 LDY TRK2DATA,X
 LDA (VOL2),Y
 LDX EIGHTH+2
 LDY TRK3DATA,X
 ADC (VOL3),Y
 LSR
 ADC TEMPA
 LDY DITHER
 BEQ SID4OK5
 STA TEMPA
 LDA SIDNOISE
 AND #$0F
 ADC TEMPA
 BCC SID4OK5
 LDA #255
 CLC
SID4OK5
 TAY
 LDA DIVIDE16,Y
 ORA #$90
 STA SID4OUT

 LDX DELAY
DLLP13
 DEX
 BNE DLLP13
 
 LDA #$95
 STA DMACMD

 LDX FIFTH
 LDY TRK1DATA,X
 LDA (VOL1),Y
 LDX SEVENTH+3
 LDY TRK4DATA,X
 ADC (VOL4),Y
 LSR
 STA TEMPA
 LDX THIRD+1
 LDY TRK2DATA,X
 LDA (VOL2),Y
 LDY TRK3DATA
 ADC (VOL3),Y
 LSR
 ADC TEMPA
 LDY DITHER
 BEQ SID4OK6
 STA TEMPA
 LDA SIDNOISE
 AND #$0F
 ADC TEMPA
 BCC SID4OK6
 LDA #255
SID4OK6
 TAY
 LDA DIVIDE16,Y
 ORA #$90
 STA SID4OUT

 LDX DELAY
DLLP14
 DEX
 BNE DLLP14
 
 SEC
 LDA TRKPNTL+2
 SBC ENDL+2
 LDA TRKPNTH+2
 SBC ENDH+2
 LDA TRKPNTB+2
 SBC ENDB+2
 BCC SID4UD4
 LDX SAMPLENUM+2
 LDA LSBLPLEN,X
 ORA MSBLPLEN,X
 ORA BNKLPLEN,X
 BNE SID4LP3
 LDX #2
 JSR RETRIG
 LDA #0
 STA SECOND+2
 STA THIRD+2
 STA FOURTH+2
 STA FIFTH+2
 STA SIXTH+2
 STA SEVENTH+2
 STA EIGHTH+2
 STA STEPL+2
 STA STEPH+2
 JSR SV2
 JMP SID4UD4

SID4LP3
 CLC
 LDA LSBSADDR,X
 ADC LSBLPPNT,X
 STA STARTL+2
 LDA MSBSADDR,X
 ADC MSBLPPNT,X
 STA STARTH+2
 LDA BNKSADDR,X
 ADC BNKLPPNT,X
 STA STARTB+2
 LDA LSBLPLEN,X
 ADC STARTL+2
 STA ENDL+2
 LDA MSBLPLEN,X
 ADC STARTH+2
 STA ENDH+2
 LDA BNKLPLEN,X
 ADC STARTB+2
 STA ENDB+2
 LDX #2
 JSR RETRIG

SID4UD4
 LDA FRACTION+3
 ADC STEPL+3
 STA FRACTION+3
 LDA TRKPNTL+3
 ADC STEPH+3
 STA TRKPNTL+3
 STA DMALO
 LDA TRKPNTH+3
 ADC #0
 STA TRKPNTH+3
 STA DMAHI
 LDA TRKPNTB+3
 ADC #0
 STA TRKPNTB+3
 STA DMABNK
 LDA #8
 STA DMADAL

 CLC
 LDX SIXTH
 LDY TRK1DATA,X
 LDA (VOL1),Y
 LDX EIGHTH+3 
 LDY TRK4DATA,X
 ADC (VOL4),Y
 LSR
 STA TEMPA
 LDX FOURTH+1
 LDY TRK2DATA,X
 LDA (VOL2),Y
 LDX SECOND+2
 LDY TRK3DATA,X
 ADC (VOL3),Y
 LSR
 ADC TEMPA
 LDY DITHER
 BEQ SID4OK7
 STA TEMPA
 LDA SIDNOISE
 AND #$0F
 ADC TEMPA
 BCC SID4OK7
 LDA #255
 CLC
SID4OK7
 TAY
 LDA DIVIDE16,Y
 ORA #$90
 STA SID4OUT

 LDX DELAY
DLLP15
 DEX
 BNE DLLP15
 
 LDA #$95
 STA DMACMD

 LDX SEVENTH
 LDY TRK1DATA,X
 LDA (VOL1),Y
 LDY TRK4DATA
 ADC (VOL4),Y
 LSR
 STA TEMPA
 LDX FIFTH+1
 LDY TRK2DATA,X
 LDA (VOL2),Y
 LDX THIRD+2
 LDY TRK3DATA,X
 ADC (VOL3),Y
 LSR
 ADC TEMPA
 LDY DITHER
 BEQ SID4OK8
 STA TEMPA
 LDA SIDNOISE
 AND #$0F
 ADC TEMPA
 BCC SID4OK8
 LDA #255
SID4OK8
 TAY
 LDA DIVIDE16,Y
 ORA #$90
 STA SID4OUT

 LDX DELAY
DLLP16
 DEX
 BNE DLLP16
 
 SEC
 LDA TRKPNTL+3
 SBC ENDL+3
 LDA TRKPNTH+3
 SBC ENDH+3
 LDA TRKPNTB+3
 SBC ENDB+3
 BCC SID4CHKT
 LDX SAMPLENUM+3
 LDA LSBLPLEN,X
 ORA MSBLPLEN,X
 ORA BNKLPLEN,X
 BNE SID4LP4
 LDX #3
 JSR RETRIG
 LDA #0
 STA SECOND+3
 STA THIRD+3
 STA FOURTH+3
 STA FIFTH+3
 STA SIXTH+3
 STA SEVENTH+3
 STA EIGHTH+3
 STA STEPL+3
 STA STEPH+3
 JSR SV2
 JMP SID4CHKT

SID4LP4
 CLC
 LDA LSBSADDR,X
 ADC LSBLPPNT,X
 STA STARTL+3
 LDA MSBSADDR,X
 ADC MSBLPPNT,X
 STA STARTH+3
 LDA BNKSADDR,X
 ADC BNKLPPNT,X
 STA STARTB+3
 LDA LSBLPLEN,X
 ADC STARTL+3
 STA ENDL+3
 LDA MSBLPLEN,X
 ADC STARTH+3
 STA ENDH+3
 LDA BNKLPLEN,X
 ADC STARTB+3
 STA ENDB+3
 LDX #3
 JSR RETRIG

SID4CHKT
 LDA $DD0D
 AND #$01
 BNE SID4EXIT
 JMP SID4UD1

SID4EXIT
 LDA #$09
 STA $DD0E
 RTS

; IXER FOR 8 BIT  IN  MODE

MIXER8MONO
 LDA #$49
 STA SID+18 

SID8UD1
 LDA #<TRK1DATA
 STA DMAADL
 CLC
 LDA FRACTION
 ADC STEPL
 STA FRACTION
 LDA TRKPNTL
 ADC STEPH
 STA TRKPNTL
 STA DMALO
 LDA TRKPNTH
 ADC #0
 STA TRKPNTH
 STA DMAHI
 LDA TRKPNTB
 ADC #0
 STA TRKPNTB
 STA DMABNK
 LDA #8
 STA DMADAL

 CLC
 LDX EIGHTH
 LDY TRK1DATA,X
 LDA (VOL1),Y
 LDX SECOND+3
 LDY TRK4DATA,X
 ADC (VOL4),Y
 LSR
 STA TEMPA
 LDX SIXTH+1
 LDY TRK2DATA,X
 LDA (VOL2),Y
 LDX FOURTH+2
 LDY TRK3DATA,X
 ADC (VOL3),Y
 LSR
 ADC TEMPA

 TAX
 AND #$F0
 STA SID8OUTHI
 TXA
 ASL
 ASL
 ASL
 ASL
 STA SID8OUTLO
 LDA #$49
 STA SID8CLKLO
 STA SID8CLKHI
 LDA #$41
 STA SID8CLKLO
 STA SID8CLKHI

 LDX DELAY
DLLP17
 DEX
 BNE DLLP17

 LDA #$95
 STA DMACMD

 CLC
 LDY TRK1DATA
 LDA (VOL1),Y
 LDX THIRD+3
 LDY TRK4DATA,X
 ADC (VOL4),Y
 LSR
 STA TEMPA
 LDX SEVENTH+1
 LDY TRK2DATA,X
 LDA (VOL2),Y
 LDX FIFTH+2
 LDY TRK3DATA,X
 ADC (VOL3),Y
 LSR
 ADC TEMPA
 TAX
 AND #$F0
 STA SID8OUTHI
 TXA
 ASL
 ASL
 ASL
 ASL
 STA SID8OUTLO
 LDA #$49
 STA SID8CLKLO
 STA SID8CLKHI
 LDA #$41
 STA SID8CLKLO
 STA SID8CLKHI

 LDX DELAY
DLLP18
 DEX
 BNE DLLP18
 
 SEC
 LDA TRKPNTL
 SBC ENDL
 LDA TRKPNTH
 SBC ENDH
 LDA TRKPNTB
 SBC ENDB
 BCC SID8UD2
 LDX SAMPLENUM
 LDA LSBLPLEN,X
 ORA MSBLPLEN,X
 ORA BNKLPLEN,X
 BNE SID8LP1
 LDX #0
 JSR RETRIG
 LDA #0
 STA SECOND
 STA THIRD
 STA FOURTH
 STA FIFTH
 STA SIXTH
 STA SEVENTH
 STA EIGHTH
 STA STEPL
 STA STEPH
 JSR SV2
 JMP SID8UD2

SID8LP1
 CLC
 LDA LSBSADDR,X
 ADC LSBLPPNT,X
 STA STARTL
 LDA MSBSADDR,X
 ADC MSBLPPNT,X
 STA STARTH
 LDA BNKSADDR,X
 ADC BNKLPPNT,X
 STA STARTB
 LDA LSBLPLEN,X
 ADC STARTL
 STA ENDL
 LDA MSBLPLEN,X
 ADC STARTH
 STA ENDH
 LDA BNKLPLEN,X
 ADC STARTB
 STA ENDB
 LDX #0
 JSR RETRIG

SID8UD2
 LDA FRACTION+1
 ADC STEPL+1
 STA FRACTION+1
 LDA TRKPNTL+1
 ADC STEPH+1
 STA TRKPNTL+1
 STA DMALO
 LDA TRKPNTH+1
 ADC #0
 STA TRKPNTH+1
 STA DMAHI
 LDA TRKPNTB+1
 ADC #0
 STA TRKPNTB+1
 STA DMABNK
 LDA #8
 STA DMADAL

 CLC
 LDX SECOND
 LDY TRK1DATA,X
 LDA (VOL1),Y
 LDX FOURTH+3
 LDY TRK4DATA,X
 ADC (VOL4),Y
 LSR
 STA TEMPA
 LDX EIGHTH+1
 LDY TRK2DATA,X
 LDA (VOL2),Y
 LDX SIXTH+2
 LDY TRK3DATA,X
 ADC (VOL3),Y
 LSR
 ADC TEMPA
 TAX
 AND #$F0
 STA SID8OUTHI
 TXA
 ASL
 ASL
 ASL
 ASL
 STA SID8OUTLO
 LDA #$49
 STA SID8CLKLO
 STA SID8CLKHI
 LDA #$41
 STA SID8CLKLO
 STA SID8CLKHI

 LDX DELAY
DLLP19
 DEX
 BNE DLLP19 

 LDA #$95
 STA DMACMD

 CLC
 LDX THIRD
 LDY TRK1DATA,X
 LDA (VOL1),Y
 LDX FIFTH+3
 LDY TRK4DATA,X
 ADC (VOL4),Y
 LSR
 STA TEMPA
 LDY TRK2DATA
 LDA (VOL2),Y
 LDX SEVENTH+2
 LDY TRK3DATA,X
 ADC (VOL3),Y
 LSR
 ADC TEMPA
 TAX
 AND #$F0
 STA SID8OUTHI
 TXA
 ASL
 ASL
 ASL
 ASL
 STA SID8OUTLO
 LDA #$49
 STA SID8CLKLO
 STA SID8CLKHI
 LDA #$41
 STA SID8CLKLO
 STA SID8CLKHI

 LDX DELAY
DLLP20
 DEX
 BNE DLLP20
 
 SEC
 LDA TRKPNTL+1
 SBC ENDL+1
 LDA TRKPNTH+1
 SBC ENDH+1
 LDA TRKPNTB+1
 SBC ENDB+1
 BCC SID8UD3
 LDX SAMPLENUM+1
 LDA LSBLPLEN,X
 ORA MSBLPLEN,X
 ORA BNKLPLEN,X
 BNE SID8LP2
 LDX #1
 JSR RETRIG
 LDA #0
 STA SECOND+1
 STA THIRD+1
 STA FOURTH+1
 STA FIFTH+1
 STA SIXTH+1
 STA SEVENTH+1
 STA EIGHTH+1
 STA STEPL+1
 STA STEPH+1
 JSR SV2
 JMP SID8UD3

SID8LP2
 CLC
 LDA LSBSADDR,X
 ADC LSBLPPNT,X
 STA STARTL+1
 LDA MSBSADDR,X
 ADC MSBLPPNT,X
 STA STARTH+1
 LDA BNKSADDR,X
 ADC BNKLPPNT,X
 STA STARTB+1
 LDA LSBLPLEN,X
 ADC STARTL+1
 STA ENDL+1
 LDA MSBLPLEN,X
 ADC STARTH+1
 STA ENDH+1
 LDA BNKLPLEN,X
 ADC STARTB+1
 STA ENDB+1
 LDX #1
 JSR RETRIG

SID8UD3
 LDA FRACTION+2
 ADC STEPL+2
 STA FRACTION+2
 LDA TRKPNTL+2
 ADC STEPH+2
 STA TRKPNTL+2
 STA DMALO
 LDA TRKPNTH+2
 ADC #0
 STA TRKPNTH+2
 STA DMAHI
 LDA TRKPNTB+2
 ADC #0
 STA TRKPNTB+2
 STA DMABNK
 LDA #8
 STA DMADAL

 CLC
 LDX FOURTH
 LDY TRK1DATA,X
 LDA (VOL1),Y
 LDX SIXTH+3
 LDY TRK4DATA,X
 ADC (VOL4),Y
 LSR
 STA TEMPA
 LDX SECOND+1
 LDY TRK2DATA,X
 LDA (VOL2),Y
 LDX EIGHTH+2
 LDY TRK3DATA,X
 ADC (VOL3),Y
 LSR
 ADC TEMPA
 TAX
 AND #$F0
 STA SID8OUTHI
 TXA
 ASL
 ASL
 ASL
 ASL
 STA SID8OUTLO
 LDA #$49
 STA SID8CLKLO
 STA SID8CLKHI
 LDA #$41
 STA SID8CLKLO
 STA SID8CLKHI

 LDX DELAY
DLLP21
 DEX
 BNE DLLP21

 LDA #$95
 STA DMACMD

 CLC
 LDX FIFTH
 LDY TRK1DATA,X
 LDA (VOL1),Y
 LDX SEVENTH+3
 LDY TRK4DATA,X
 ADC (VOL4),Y
 LSR
 STA TEMPA
 LDX THIRD+1
 LDY TRK2DATA,X
 LDA (VOL2),Y
 LDY TRK3DATA
 ADC (VOL3),Y
 LSR
 ADC TEMPA
 TAX
 AND #$F0
 STA SID8OUTHI
 TXA
 ASL
 ASL
 ASL
 ASL
 STA SID8OUTLO
 LDA #$49
 STA SID8CLKLO
 STA SID8CLKHI
 LDA #$41
 STA SID8CLKLO
 STA SID8CLKHI

 LDX DELAY
DLLP22
 DEX
 BNE DLLP22
 
 SEC
 LDA TRKPNTL+2
 SBC ENDL+2
 LDA TRKPNTH+2
 SBC ENDH+2
 LDA TRKPNTB+2
 SBC ENDB+2
 BCC SID8UD4
 LDX SAMPLENUM+2
 LDA LSBLPLEN,X
 ORA MSBLPLEN,X
 ORA BNKLPLEN,X
 BNE SID8LP3
 LDX #2
 JSR RETRIG
 LDA #0
 STA SECOND+2
 STA THIRD+2
 STA FOURTH+2
 STA FIFTH+2
 STA SIXTH+2
 STA SEVENTH+2
 STA EIGHTH+2
 STA STEPL+2
 STA STEPH+2
 JSR SV2
 JMP SID8UD4

SID8LP3
 CLC
 LDA LSBSADDR,X
 ADC LSBLPPNT,X
 STA STARTL+2
 LDA MSBSADDR,X
 ADC MSBLPPNT,X
 STA STARTH+2
 LDA BNKSADDR,X
 ADC BNKLPPNT,X
 STA STARTB+2
 LDA LSBLPLEN,X
 ADC STARTL+2
 STA ENDL+2
 LDA MSBLPLEN,X
 ADC STARTH+2
 STA ENDH+2
 LDA BNKLPLEN,X
 ADC STARTB+2
 STA ENDB+2
 LDX #2
 JSR RETRIG

SID8UD4
 LDA FRACTION+3
 ADC STEPL+3
 STA FRACTION+3
 LDA TRKPNTL+3
 ADC STEPH+3
 STA TRKPNTL+3
 STA DMALO
 LDA TRKPNTH+3
 ADC #0
 STA TRKPNTH+3
 STA DMAHI
 LDA TRKPNTB+3
 ADC #0
 STA TRKPNTB+3
 STA DMABNK
 LDA #8
 STA DMADAL

 CLC
 LDX SIXTH
 LDY TRK1DATA,X
 LDA (VOL1),Y
 LDX EIGHTH+3 
 LDY TRK4DATA,X
 ADC (VOL4),Y
 LSR
 STA TEMPA
 LDX FOURTH+1
 LDY TRK2DATA,X
 LDA (VOL2),Y
 LDX SECOND+2
 LDY TRK3DATA,X
 ADC (VOL3),Y
 LSR
 ADC TEMPA
 TAX
 AND #$F0
 STA SID8OUTHI
 TXA
 ASL
 ASL
 ASL
 ASL
 STA SID8OUTLO
 LDA #$49
 STA SID8CLKLO
 STA SID8CLKHI
 LDA #$41
 STA SID8CLKLO
 STA SID8CLKHI

 LDX DELAY
DLLP23
 DEX
 BNE DLLP23
 
 LDA #$95
 STA DMACMD

 CLC
 LDX SEVENTH
 LDY TRK1DATA,X
 LDA (VOL1),Y
 LDY TRK4DATA
 ADC (VOL4),Y
 LSR
 STA TEMPA
 LDX FIFTH+1
 LDY TRK2DATA,X
 LDA (VOL2),Y
 LDX THIRD+2
 LDY TRK3DATA,X
 ADC (VOL3),Y
 LSR
 ADC TEMPA
 TAX
 AND #$F0
 STA SID8OUTHI
 TXA
 ASL
 ASL
 ASL
 ASL
 STA SID8OUTLO
 LDA #$49
 STA SID8CLKLO
 STA SID8CLKHI
 LDA #$41
 STA SID8CLKLO
 STA SID8CLKHI

 LDX DELAY2
DLLP24
 DEX
 BNE DLLP24
 
 SEC
 LDA TRKPNTL+3
 SBC ENDL+3
 LDA TRKPNTH+3
 SBC ENDH+3
 LDA TRKPNTB+3
 SBC ENDB+3
 BCC SID8CHKT
 LDX SAMPLENUM+3
 LDA LSBLPLEN,X
 ORA MSBLPLEN,X
 ORA BNKLPLEN,X
 BNE SID8LP4
 LDX #3
 JSR RETRIG
 LDA #0
 STA SECOND+3
 STA THIRD+3
 STA FOURTH+3
 STA FIFTH+3
 STA SIXTH+3
 STA SEVENTH+3
 STA EIGHTH+3
 STA STEPL+3
 STA STEPH+3
 JSR SV2
 JMP SID8CHKT

SID8LP4
 CLC
 LDA LSBSADDR,X
 ADC LSBLPPNT,X
 STA STARTL+3
 LDA MSBSADDR,X
 ADC MSBLPPNT,X
 STA STARTH+3
 LDA BNKSADDR,X
 ADC BNKLPPNT,X
 STA STARTB+3
 LDA LSBLPLEN,X
 ADC STARTL+3
 STA ENDL+3
 LDA MSBLPLEN,X
 ADC STARTH+3
 STA ENDH+3
 LDA BNKLPLEN,X
 ADC STARTB+3
 STA ENDB+3
 LDX #3
 JSR RETRIG

SID8CHKT
 LDA $DD0D
 AND #$01
 BNE SID8EXIT
 JMP SID8UD1

SID8EXIT
 LDA #$09
 STA $DD0E
 LDA #$41
 STA SID+18
 RTS

; IXER FOR 8 BIT SER ORT 

USERUD1
 LDA #<TRK1DATA
 STA DMAADL
 CLC
 LDA FRACTION
 ADC STEPL
 STA FRACTION
 LDA TRKPNTL
 ADC STEPH
 STA TRKPNTL
 STA DMALO
 LDA TRKPNTH
 ADC #0
 STA TRKPNTH
 STA DMAHI
 LDA TRKPNTB
 ADC #0
 STA TRKPNTB
 STA DMABNK
 LDA #8
 STA DMADAL

 CLC
 LDX EIGHTH
 LDY TRK1DATA,X
 LDA (VOL1),Y
 LDX SECOND+3
 LDY TRK4DATA,X
 ADC (VOL4),Y
 LSR
 STA TEMPA
 LDX SIXTH+1
 LDY TRK2DATA,X
 LDA (VOL2),Y
 LDX FOURTH+2
 LDY TRK3DATA,X
 ADC (VOL3),Y
 LSR
 ADC TEMPA
 STA USEROUT

 LDX DELAY
DLLP25
 DEX
 BNE DLLP25
 
 LDA #$95
 STA DMACMD

 LDY TRK1DATA
 LDA (VOL1),Y
 LDX THIRD+3
 LDY TRK4DATA,X
 ADC (VOL4),Y
 LSR
 STA TEMPA
 LDX SEVENTH+1
 LDY TRK2DATA,X
 LDA (VOL2),Y
 LDX FIFTH+2
 LDY TRK3DATA,X
 ADC (VOL3),Y
 LSR
 ADC TEMPA
 STA USEROUT

 LDX DELAY
DLLP26
 DEX
 BNE DLLP26
 
 SEC
 LDA TRKPNTL
 SBC ENDL
 LDA TRKPNTH
 SBC ENDH
 LDA TRKPNTB
 SBC ENDB
 BCC USERUD2
 LDX SAMPLENUM
 LDA LSBLPLEN,X
 ORA MSBLPLEN,X
 ORA BNKLPLEN,X
 BNE USERLP1
 LDX #0
 JSR RETRIG
 LDA #0
 STA SECOND
 STA THIRD
 STA FOURTH
 STA FIFTH
 STA SIXTH
 STA SEVENTH
 STA EIGHTH
 STA STEPL
 STA STEPH
 JSR SV2
 JMP USERUD2

USERLP1
 CLC
 LDA LSBSADDR,X
 ADC LSBLPPNT,X
 STA STARTL
 LDA MSBSADDR,X
 ADC MSBLPPNT,X
 STA STARTH
 LDA BNKSADDR,X
 ADC BNKLPPNT,X
 STA STARTB
 LDA LSBLPLEN,X
 ADC STARTL
 STA ENDL
 LDA MSBLPLEN,X
 ADC STARTH
 STA ENDH
 LDA BNKLPLEN,X
 ADC STARTB
 STA ENDB
 LDX #0
 JSR RETRIG

USERUD2
 LDA FRACTION+1
 ADC STEPL+1
 STA FRACTION+1
 LDA TRKPNTL+1
 ADC STEPH+1
 STA TRKPNTL+1
 STA DMALO
 LDA TRKPNTH+1
 ADC #0
 STA TRKPNTH+1
 STA DMAHI
 LDA TRKPNTB+1
 ADC #0
 STA TRKPNTB+1
 STA DMABNK
 LDA #8
 STA DMADAL

 CLC
 LDX SECOND
 LDY TRK1DATA,X
 LDA (VOL1),Y
 LDX FOURTH+3
 LDY TRK4DATA,X
 ADC (VOL4),Y
 LSR
 STA TEMPA
 LDX EIGHTH+1
 LDY TRK2DATA,X
 LDA (VOL2),Y
 LDX SIXTH+2
 LDY TRK3DATA,X
 ADC (VOL3),Y
 LSR
 ADC TEMPA
 STA USEROUT

 LDX DELAY
DLLP27
 DEX
 BNE DLLP27
 
 LDA #$95
 STA DMACMD
 
 LDX THIRD
 LDY TRK1DATA,X
 LDA (VOL1),Y
 LDX FIFTH+3
 LDY TRK4DATA,X
 ADC (VOL4),Y
 LSR
 STA TEMPA
 LDY TRK2DATA
 LDA (VOL2),Y
 LDX SEVENTH+2
 LDY TRK3DATA,X
 ADC (VOL3),Y
 LSR
 ADC TEMPA
 STA USEROUT

 LDX DELAY
DLLP28
 DEX
 BNE DLLP28
 
 SEC
 LDA TRKPNTL+1
 SBC ENDL+1
 LDA TRKPNTH+1
 SBC ENDH+1
 LDA TRKPNTB+1
 SBC ENDB+1
 BCC USERUD3
 LDX SAMPLENUM+1
 LDA LSBLPLEN,X
 ORA MSBLPLEN,X
 ORA BNKLPLEN,X
 BNE USERLP2
 LDX #1
 JSR RETRIG
 LDA #0
 STA SECOND+1
 STA THIRD+1
 STA FOURTH+1
 STA FIFTH+1
 STA SIXTH+1
 STA SEVENTH+1
 STA EIGHTH+1
 STA STEPL+1
 STA STEPH+1
 JSR SV2
 JMP USERUD3

USERLP2
 CLC
 LDA LSBSADDR,X
 ADC LSBLPPNT,X
 STA STARTL+1
 LDA MSBSADDR,X
 ADC MSBLPPNT,X
 STA STARTH+1
 LDA BNKSADDR,X
 ADC BNKLPPNT,X
 STA STARTB+1
 LDA LSBLPLEN,X
 ADC STARTL+1
 STA ENDL+1
 LDA MSBLPLEN,X
 ADC STARTH+1
 STA ENDH+1
 LDA BNKLPLEN,X
 ADC STARTB+1
 STA ENDB+1
 LDX #1
 JSR RETRIG

USERUD3
 LDA FRACTION+2
 ADC STEPL+2
 STA FRACTION+2
 LDA TRKPNTL+2
 ADC STEPH+2
 STA TRKPNTL+2
 STA DMALO
 LDA TRKPNTH+2
 ADC #0
 STA TRKPNTH+2
 STA DMAHI
 LDA TRKPNTB+2
 ADC #0
 STA TRKPNTB+2
 STA DMABNK
 LDA #8
 STA DMADAL

 CLC
 LDX FOURTH
 LDY TRK1DATA,X
 LDA (VOL1),Y
 LDX SIXTH+3
 LDY TRK4DATA,X
 ADC (VOL4),Y
 LSR
 STA TEMPA
 LDX SECOND+1
 LDY TRK2DATA,X
 LDA (VOL2),Y
 LDX EIGHTH+2
 LDY TRK3DATA,X
 ADC (VOL3),Y
 LSR
 ADC TEMPA
 STA USEROUT

 LDX DELAY
DLLP29
 DEX
 BNE DLLP29
 
 LDA #$95
 STA DMACMD

 LDX FIFTH
 LDY TRK1DATA,X
 LDA (VOL1),Y
 LDX SEVENTH+3
 LDY TRK4DATA,X
 ADC (VOL4),Y
 LSR
 STA TEMPA
 LDX THIRD+1
 LDY TRK2DATA,X
 LDA (VOL2),Y
 LDY TRK3DATA
 ADC (VOL3),Y
 LSR
 ADC TEMPA
 STA USEROUT

 LDX DELAY
DLLP30
 DEX
 BNE DLLP30
 
 SEC
 LDA TRKPNTL+2
 SBC ENDL+2
 LDA TRKPNTH+2
 SBC ENDH+2
 LDA TRKPNTB+2
 SBC ENDB+2
 BCC USERUD4
 LDX SAMPLENUM+2
 LDA LSBLPLEN,X
 ORA MSBLPLEN,X
 ORA BNKLPLEN,X
 BNE USERLP3
 LDX #2
 JSR RETRIG
 LDA #0
 STA SECOND+2
 STA THIRD+2
 STA FOURTH+2
 STA FIFTH+2
 STA SIXTH+2
 STA SEVENTH+2
 STA EIGHTH+2
 STA STEPL+2
 STA STEPH+2
 JSR SV2
 JMP USERUD4

USERLP3
 CLC
 LDA LSBSADDR,X
 ADC LSBLPPNT,X
 STA STARTL+2
 LDA MSBSADDR,X
 ADC MSBLPPNT,X
 STA STARTH+2
 LDA BNKSADDR,X
 ADC BNKLPPNT,X
 STA STARTB+2
 LDA LSBLPLEN,X
 ADC STARTL+2
 STA ENDL+2
 LDA MSBLPLEN,X
 ADC STARTH+2
 STA ENDH+2
 LDA BNKLPLEN,X
 ADC STARTB+2
 STA ENDB+2
 LDX #2
 JSR RETRIG

USERUD4
 LDA FRACTION+3
 ADC STEPL+3
 STA FRACTION+3
 LDA TRKPNTL+3
 ADC STEPH+3
 STA TRKPNTL+3
 STA DMALO
 LDA TRKPNTH+3
 ADC #0
 STA TRKPNTH+3
 STA DMAHI
 LDA TRKPNTB+3
 ADC #0
 STA TRKPNTB+3
 STA DMABNK
 LDA #8
 STA DMADAL

 CLC
 LDX SIXTH
 LDY TRK1DATA,X
 LDA (VOL1),Y
 LDX EIGHTH+3 
 LDY TRK4DATA,X
 ADC (VOL4),Y
 LSR
 STA TEMPA
 LDX FOURTH+1
 LDY TRK2DATA,X
 LDA (VOL2),Y
 LDX SECOND+2
 LDY TRK3DATA,X
 ADC (VOL3),Y
 LSR
 ADC TEMPA
 STA USEROUT

 LDX DELAY
DLLP31
 DEX
 BNE DLLP31
 
 LDA #$95
 STA DMACMD

 LDX SEVENTH
 LDY TRK1DATA,X
 LDA (VOL1),Y
 LDY TRK4DATA
 ADC (VOL4),Y
 LSR
 STA TEMPA
 LDX FIFTH+1
 LDY TRK2DATA,X
 LDA (VOL2),Y
 LDX THIRD+2
 LDY TRK3DATA,X
 ADC (VOL3),Y
 LSR
 ADC TEMPA
 STA USEROUT

 LDX DELAY
DLLP32
 DEX
 BNE DLLP32
 
 SEC
 LDA TRKPNTL+3
 SBC ENDL+3
 LDA TRKPNTH+3
 SBC ENDH+3
 LDA TRKPNTB+3
 SBC ENDB+3
 BCC USERCHKT
 LDX SAMPLENUM+3
 LDA LSBLPLEN,X
 ORA MSBLPLEN,X
 ORA BNKLPLEN,X
 BNE USERLP4
 LDX #3
 JSR RETRIG
 LDA #0
 STA SECOND+3
 STA THIRD+3
 STA FOURTH+3
 STA FIFTH+3
 STA SIXTH+3
 STA SEVENTH+3
 STA EIGHTH+3
 STA STEPL+3
 STA STEPH+3
 JSR SV2
 JMP USERCHKT

USERLP4
 CLC
 LDA LSBSADDR,X
 ADC LSBLPPNT,X
 STA STARTL+3
 LDA MSBSADDR,X
 ADC MSBLPPNT,X
 STA STARTH+3
 LDA BNKSADDR,X
 ADC BNKLPPNT,X
 STA STARTB+3
 LDA LSBLPLEN,X
 ADC STARTL+3
 STA ENDL+3
 LDA MSBLPLEN,X
 ADC STARTH+3
 STA ENDH+3
 LDA BNKLPLEN,X
 ADC STARTB+3
 STA ENDB+3
 LDX #3
 JSR RETRIG

USERCHKT
 LDA $DD0D
 AND #$01
 BNE USEREXIT
 JMP USERUD1

USEREXIT
 LDA #$09
 STA $DD0E
 RTS

; RIVER FOR  4 BIT MODE, IN STEREO (ITHER AVAILABLE)

SID4SUD1
 LDA #<TRK1DATA
 STA DMAADL
 CLC
 LDA FRACTION
 ADC STEPL
 STA FRACTION
 LDA TRKPNTL
 ADC STEPH
 STA TRKPNTL
 STA DMALO
 LDA TRKPNTH
 ADC #0
 STA TRKPNTH
 STA DMAHI
 LDA TRKPNTB
 ADC #0
 STA TRKPNTB
 STA DMABNK
 LDA #8
 STA DMADAL

 CLC
 LDX EIGHTH
 LDY TRK1DATA,X
 LDA (VOL1),Y
 LDX SECOND+3
 LDY TRK4DATA,X
 ADC (VOL4),Y
 LDY DITHER
 BEQ SID4SOK1A
 STA TEMPA
 LDA SIDNOISE
 AND #$0F
 ADC TEMPA
 BCC SID4SOK1A
 LDA #255
 CLC
SID4SOK1A
 TAY
 LDA DIVIDE16,Y
 ORA #$90
 STA SID4OUT

 LDX SIXTH+1
 LDY TRK2DATA,X
 LDA (VOL2),Y
 LDX FOURTH+2
 LDY TRK3DATA,X
 ADC (VOL3),Y
 LDY DITHER
 BEQ SID4SOK1B
 STA TEMPA
 LDA SIDNOISE
 AND #$0F
 ADC TEMPA
 BCC SID4SOK1B
 LDA #255
 CLC
SID4SOK1B
 TAY
 LDA DIVIDE16,Y
 ORA #$90
 LDY #0
 STA (SID4OUTRIGHT),Y

 LDX DELAY
DLLP33
 DEX
 BNE DLLP33
 
 LDA #$95
 STA DMACMD

 LDY TRK1DATA
 LDA (VOL1),Y
 LDX THIRD+3
 LDY TRK4DATA,X
 ADC (VOL4),Y
 LDY DITHER
 BEQ SID4SOK2A
 STA TEMPA
 LDA SIDNOISE
 AND #$0F
 ADC TEMPA
 BCC SID4SOK2A
 LDA #255
 CLC
SID4SOK2A
 TAY
 LDA DIVIDE16,Y
 ORA #$90
 STA SID4OUT
 LDX SEVENTH+1
 LDY TRK2DATA,X
 LDA (VOL2),Y
 LDX FIFTH+2
 LDY TRK3DATA,X
 ADC (VOL3),Y
 LDY DITHER
 BEQ SID4SOK2B
 STA TEMPA
 LDA SIDNOISE
 AND #$0F
 ADC TEMPA
 BCC SID4SOK2B
 LDA #255
SID4SOK2B
 TAY
 LDA DIVIDE16,Y
 ORA #$90
 LDY #0
 STA (SID4OUTRIGHT),Y

 LDX DELAY
DLLP34
 DEX
 BNE DLLP34
 
 SEC
 LDA TRKPNTL
 SBC ENDL
 LDA TRKPNTH
 SBC ENDH
 LDA TRKPNTB
 SBC ENDB
 BCC SID4SUD2
 LDX SAMPLENUM
 LDA LSBLPLEN,X
 ORA MSBLPLEN,X
 ORA BNKLPLEN,X
 BNE SID4SLP1
 LDX #0
 JSR RETRIG
 LDA #0
 STA SECOND
 STA THIRD
 STA FOURTH
 STA FIFTH
 STA SIXTH
 STA SEVENTH
 STA EIGHTH
 STA STEPL
 STA STEPH
 JSR SV2
 JMP SID4SUD2

SID4SLP1
 CLC
 LDA LSBSADDR,X
 ADC LSBLPPNT,X
 STA STARTL
 LDA MSBSADDR,X
 ADC MSBLPPNT,X
 STA STARTH
 LDA BNKSADDR,X
 ADC BNKLPPNT,X
 STA STARTB
 LDA LSBLPLEN,X
 ADC STARTL
 STA ENDL
 LDA MSBLPLEN,X
 ADC STARTH
 STA ENDH
 LDA BNKLPLEN,X
 ADC STARTB
 STA ENDB
 LDX #0
 JSR RETRIG

SID4SUD2
 LDA FRACTION+1
 ADC STEPL+1
 STA FRACTION+1
 LDA TRKPNTL+1
 ADC STEPH+1
 STA TRKPNTL+1
 STA DMALO
 LDA TRKPNTH+1
 ADC #0
 STA TRKPNTH+1
 STA DMAHI
 LDA TRKPNTB+1
 ADC #0
 STA TRKPNTB+1
 STA DMABNK
 LDA #8
 STA DMADAL

 CLC
 LDX SECOND
 LDY TRK1DATA,X
 LDA (VOL1),Y
 LDX FOURTH+3
 LDY TRK4DATA,X
 ADC (VOL4),Y
 LDY DITHER
 BEQ SID4SOK3A
 STA TEMPA
 LDA SIDNOISE
 AND #$0F
 ADC TEMPA
 BCC SID4SOK3A
 LDA #255
 CLC
SID4SOK3A
 TAY
 LDA DIVIDE16,Y
 ORA #$90
 STA SID4OUT
 LDX EIGHTH+1
 LDY TRK2DATA,X
 LDA (VOL2),Y
 LDX SIXTH+2
 LDY TRK3DATA,X
 ADC (VOL3),Y
 LDY DITHER
 BEQ SID4SOK3B
 STA TEMPA
 LDA SIDNOISE
 AND #$0F
 ADC TEMPA
 BCC SID4SOK3B
 LDA #255
 CLC
SID4SOK3B
 TAY
 LDA DIVIDE16,Y
 ORA #$90
 LDY #0
 STA (SID4OUTRIGHT),Y

 LDX DELAY
DLLP35
 DEX
 BNE DLLP35
 
 LDA #$95
 STA DMACMD

 LDX THIRD
 LDY TRK1DATA,X
 LDA (VOL1),Y
 LDX FIFTH+3
 LDY TRK4DATA,X
 ADC (VOL4),Y
 LDY DITHER
 BEQ SID4SOK4A
 STA TEMPA
 LDA SIDNOISE
 AND #$0F
 ADC TEMPA
 BCC SID4SOK4A
 LDA #255
 CLC
SID4SOK4A
 TAY
 LDA DIVIDE16,Y
 ORA #$90
 STA SID4OUT
 LDY TRK2DATA
 LDA (VOL2),Y
 LDX SEVENTH+2
 LDY TRK3DATA,X
 ADC (VOL3),Y
 LDY DITHER
 BEQ SID4SOK4B
 STA TEMPA
 LDA SIDNOISE
 AND #$0F
 ADC TEMPA
 BCC SID4SOK4B
 LDA #255
SID4SOK4B
 TAY
 LDA DIVIDE16,Y
 ORA #$90
 LDY #0
 STA (SID4OUTRIGHT),Y

 LDX DELAY
DLLP36
 DEX
 BNE DLLP36 

 SEC
 LDA TRKPNTL+1
 SBC ENDL+1
 LDA TRKPNTH+1
 SBC ENDH+1
 LDA TRKPNTB+1
 SBC ENDB+1
 BCC SID4SUD3
 LDX SAMPLENUM+1
 LDA LSBLPLEN,X
 ORA MSBLPLEN,X
 ORA BNKLPLEN,X
 BNE SID4SLP2
 LDX #1
 JSR RETRIG
 LDA #0
 STA SECOND+1
 STA THIRD+1
 STA FOURTH+1
 STA FIFTH+1
 STA SIXTH+1
 STA SEVENTH+1
 STA EIGHTH+1
 STA STEPL+1
 STA STEPH+1
 JSR SV2
 JMP SID4SUD3

SID4SLP2
 CLC
 LDA LSBSADDR,X
 ADC LSBLPPNT,X
 STA STARTL+1
 LDA MSBSADDR,X
 ADC MSBLPPNT,X
 STA STARTH+1
 LDA BNKSADDR,X
 ADC BNKLPPNT,X
 STA STARTB+1
 LDA LSBLPLEN,X
 ADC STARTL+1
 STA ENDL+1
 LDA MSBLPLEN,X
 ADC STARTH+1
 STA ENDH+1
 LDA BNKLPLEN,X
 ADC STARTB+1
 STA ENDB+1
 LDX #1
 JSR RETRIG

SID4SUD3
 LDA FRACTION+2
 ADC STEPL+2
 STA FRACTION+2
 LDA TRKPNTL+2
 ADC STEPH+2
 STA TRKPNTL+2
 STA DMALO
 LDA TRKPNTH+2
 ADC #0
 STA TRKPNTH+2
 STA DMAHI
 LDA TRKPNTB+2
 ADC #0
 STA TRKPNTB+2
 STA DMABNK
 LDA #8
 STA DMADAL

 CLC
 LDX FOURTH
 LDY TRK1DATA,X
 LDA (VOL1),Y
 LDX SIXTH+3
 LDY TRK4DATA,X
 ADC (VOL4),Y
 LDY DITHER
 BEQ SID4SOK5A
 STA TEMPA
 LDA SIDNOISE
 AND #$0F
 ADC TEMPA
 BCC SID4SOK5A
 LDA #255
 CLC
SID4SOK5A
 TAY
 LDA DIVIDE16,Y
 ORA #$90
 STA SID4OUT
 LDX SECOND+1
 LDY TRK2DATA,X
 LDA (VOL2),Y
 LDX EIGHTH+2
 LDY TRK3DATA,X
 ADC (VOL3),Y
 LDY DITHER
 BEQ SID4SOK5B
 STA TEMPA
 LDA SIDNOISE
 AND #$0F
 ADC TEMPA
 BCC SID4SOK5B
 LDA #255
 CLC
SID4SOK5B
 TAY
 LDA DIVIDE16,Y
 ORA #$90
 LDY #0
 STA (SID4OUTRIGHT),Y

 LDX DELAY
DLLP37
 DEX
 BNE DLLP37
 
 LDA #$95
 STA DMACMD

 LDX FIFTH
 LDY TRK1DATA,X
 LDA (VOL1),Y
 LDX SEVENTH+3
 LDY TRK4DATA,X
 ADC (VOL4),Y
 LDY DITHER
 BEQ SID4SOK6A
 STA TEMPA
 LDA SIDNOISE
 AND #$0F
 ADC TEMPA
 BCC SID4SOK6A
 LDA #255
 CLC
SID4SOK6A
 TAY
 LDA DIVIDE16,Y
 ORA #$90
 STA SID4OUT

 LDX THIRD+1
 LDY TRK2DATA,X
 LDA (VOL2),Y
 LDY TRK3DATA
 ADC (VOL3),Y
 LDY DITHER
 BEQ SID4SOK6B
 STA TEMPA
 LDA SIDNOISE
 AND #$0F
 ADC TEMPA
 BCC SID4SOK6B
 LDA #255
SID4SOK6B
 TAY
 LDA DIVIDE16,Y
 ORA #$90
 LDY #0
 STA (SID4OUTRIGHT),Y

 LDX DELAY
DLLP38
 DEX
 BNE DLLP38
 
 SEC
 LDA TRKPNTL+2
 SBC ENDL+2
 LDA TRKPNTH+2
 SBC ENDH+2
 LDA TRKPNTB+2
 SBC ENDB+2
 BCC SID4SUD4
 LDX SAMPLENUM+2
 LDA LSBLPLEN,X
 ORA MSBLPLEN,X
 ORA BNKLPLEN,X
 BNE SID4SLP3
 LDX #2
 JSR RETRIG
 LDA #0
 STA SECOND+2
 STA THIRD+2
 STA FOURTH+2
 STA FIFTH+2
 STA SIXTH+2
 STA SEVENTH+2
 STA EIGHTH+2
 STA STEPL+2
 STA STEPH+2
 JSR SV2
 JMP SID4SUD4

SID4SLP3
 CLC
 LDA LSBSADDR,X
 ADC LSBLPPNT,X
 STA STARTL+2
 LDA MSBSADDR,X
 ADC MSBLPPNT,X
 STA STARTH+2
 LDA BNKSADDR,X
 ADC BNKLPPNT,X
 STA STARTB+2
 LDA LSBLPLEN,X
 ADC STARTL+2
 STA ENDL+2
 LDA MSBLPLEN,X
 ADC STARTH+2
 STA ENDH+2
 LDA BNKLPLEN,X
 ADC STARTB+2
 STA ENDB+2
 LDX #2
 JSR RETRIG

SID4SUD4
 LDA FRACTION+3
 ADC STEPL+3
 STA FRACTION+3
 LDA TRKPNTL+3
 ADC STEPH+3
 STA TRKPNTL+3
 STA DMALO
 LDA TRKPNTH+3
 ADC #0
 STA TRKPNTH+3
 STA DMAHI
 LDA TRKPNTB+3
 ADC #0
 STA TRKPNTB+3
 STA DMABNK
 LDA #8
 STA DMADAL

 CLC
 LDX SIXTH
 LDY TRK1DATA,X
 LDA (VOL1),Y
 LDX EIGHTH+3 
 LDY TRK4DATA,X
 ADC (VOL4),Y
 LDY DITHER
 BEQ SID4SOK7A
 STA TEMPA
 LDA SIDNOISE
 AND #$0F
 ADC TEMPA
 BCC SID4SOK7A
 LDA #255
 CLC
SID4SOK7A
 TAY
 LDA DIVIDE16,Y
 ORA #$90
 STA SID4OUT

 LDX FOURTH+1
 LDY TRK2DATA,X
 LDA (VOL2),Y
 LDX SECOND+2
 LDY TRK3DATA,X
 ADC (VOL3),Y
 LDY DITHER
 BEQ SID4SOK7B
 STA TEMPA
 LDA SIDNOISE
 AND #$0F
 ADC TEMPA
 BCC SID4SOK7B
 LDA #255
 CLC
SID4SOK7B
 TAY
 LDA DIVIDE16,Y
 ORA #$90
 LDY #0
 STA (SID4OUTRIGHT),Y

 LDX DELAY
DLLP39
 DEX
 BNE DLLP39
 
 LDA #$95
 STA DMACMD

 LDX SEVENTH
 LDY TRK1DATA,X
 LDA (VOL1),Y
 LDY TRK4DATA
 ADC (VOL4),Y
 LDY DITHER
 BEQ SID4SOK8A
 STA TEMPA
 LDA SIDNOISE
 AND #$0F
 ADC TEMPA
 BCC SID4SOK8A
 LDA #255
 CLC
SID4SOK8A
 TAY
 LDA DIVIDE16,Y
 ORA #$90
 STA SID4OUT

 LDX FIFTH+1
 LDY TRK2DATA,X
 LDA (VOL2),Y
 LDX THIRD+2
 LDY TRK3DATA,X
 ADC (VOL3),Y
 LDY DITHER
 BEQ SID4SOK8B
 STA TEMPA
 LDA SIDNOISE
 AND #$0F
 ADC TEMPA
 BCC SID4SOK8B
 LDA #255
 CLC
SID4SOK8B
 TAY
 LDA DIVIDE16,Y
 ORA #$90
 LDY #0
 STA (SID4OUTRIGHT),Y

 LDX DELAY
DLLP40
 DEX
 BNE DLLP40
 
 SEC
 LDA TRKPNTL+3
 SBC ENDL+3
 LDA TRKPNTH+3
 SBC ENDH+3
 LDA TRKPNTB+3
 SBC ENDB+3
 BCC SID4SCHKT
 LDX SAMPLENUM+3
 LDA LSBLPLEN,X
 ORA MSBLPLEN,X
 ORA BNKLPLEN,X
 BNE SID4SLP4
 LDX #3
 JSR RETRIG
 LDA #0
 STA SECOND+3
 STA THIRD+3
 STA FOURTH+3
 STA FIFTH+3
 STA SIXTH+3
 STA SEVENTH+3
 STA EIGHTH+3
 STA STEPL+3
 STA STEPH+3
 JSR SV2
 JMP SID4SCHKT

SID4SLP4
 CLC
 LDA LSBSADDR,X
 ADC LSBLPPNT,X
 STA STARTL+3
 LDA MSBSADDR,X
 ADC MSBLPPNT,X
 STA STARTH+3
 LDA BNKSADDR,X
 ADC BNKLPPNT,X
 STA STARTB+3
 LDA LSBLPLEN,X
 ADC STARTL+3
 STA ENDL+3
 LDA MSBLPLEN,X
 ADC STARTH+3
 STA ENDH+3
 LDA BNKLPLEN,X
 ADC STARTB+3
 STA ENDB+3
 LDX #3
 JSR RETRIG

SID4SCHKT
 LDA $DD0D
 AND #$01
 BNE SID4SEXIT
 JMP SID4SUD1

SID4SEXIT
 LDA #$09
 STA $DD0E
 RTS

; IXER FOR 8 BIT ,  MODE, IN STEREO

MIXER8STEREO
 LDA #$49
 STA SID+18
 LDY #18
 STA (RIGHTSID),Y
SID8SUD1
 LDA #<TRK1DATA
 STA DMAADL
 CLC
 LDA FRACTION
 ADC STEPL
 STA FRACTION
 LDA TRKPNTL
 ADC STEPH
 STA TRKPNTL
 STA DMALO
 LDA TRKPNTH
 ADC #0
 STA TRKPNTH
 STA DMAHI
 LDA TRKPNTB
 ADC #0
 STA TRKPNTB
 STA DMABNK
 LDA #8
 STA DMADAL

 CLC
 LDX EIGHTH
 LDY TRK1DATA,X
 LDA (VOL1),Y
 LDX SECOND+3
 LDY TRK4DATA,X
 ADC (VOL4),Y
 TAX
 AND #$F0
 STA SID8OUTHI
 TXA
 ASL
 ASL
 ASL
 ASL
 STA SID8OUTLO
 LDX SIXTH+1
 LDY TRK2DATA,X
 LDA (VOL2),Y
 LDX FOURTH+2
 LDY TRK3DATA,X
 ADC (VOL3),Y
 TAX
 AND #$F0
 LDY #0
 STA (SID8OUTHIRIGHT),Y
 TXA
 ASL
 ASL
 ASL
 ASL
 STA (SID8OUTLORIGHT),Y
 LDA #$49
 STA SID8CLKLO
 STA SID8CLKHI
 STA (SID8CLKLORIGHT),Y
 STA (SID8CLKHIRIGHT),Y
 LDA #$41
 STA SID8CLKLO
 STA SID8CLKHI
 STA (SID8CLKLORIGHT),Y
 STA (SID8CLKHIRIGHT),Y

 LDX DELAY
DLLP41
 DEX
 BNE DLLP41

 LDA #$95
 STA DMACMD

 CLC
 LDY TRK1DATA
 LDA (VOL1),Y
 LDX THIRD+3
 LDY TRK4DATA,X
 ADC (VOL4),Y
 TAX
 AND #$F0
 STA SID8OUTHI
 TXA
 ASL
 ASL
 ASL
 ASL
 STA SID8OUTLO
 LDX SEVENTH+1
 LDY TRK2DATA,X
 LDA (VOL2),Y
 LDX FIFTH+2
 LDY TRK3DATA,X
 ADC (VOL3),Y
 TAX
 AND #$F0
 LDY #0
 STA (SID8OUTHIRIGHT),Y
 TXA
 ASL
 ASL
 ASL
 ASL
 STA (SID8OUTLORIGHT),Y
 LDA #$49
 STA SID8CLKLO
 STA SID8CLKHI
 STA (SID8CLKLORIGHT),Y
 STA (SID8CLKHIRIGHT),Y
 LDA #$41
 STA SID8CLKLO
 STA SID8CLKHI
 STA (SID8CLKLORIGHT),Y
 STA (SID8CLKHIRIGHT),Y

 LDX DELAY
DLLP42
 DEX
 BNE DLLP42
 
 SEC
 LDA TRKPNTL
 SBC ENDL
 LDA TRKPNTH
 SBC ENDH
 LDA TRKPNTB
 SBC ENDB
 BCC SID8SUD2
 LDX SAMPLENUM
 LDA LSBLPLEN,X
 ORA MSBLPLEN,X
 ORA BNKLPLEN,X
 BNE SID8SLP1
 LDX #0
 JSR RETRIG
 LDA #0
 STA SECOND
 STA THIRD
 STA FOURTH
 STA FIFTH
 STA SIXTH
 STA SEVENTH
 STA EIGHTH
 STA STEPL
 STA STEPH
 JSR SV2
 JMP SID8SUD2

SID8SLP1
 CLC
 LDA LSBSADDR,X
 ADC LSBLPPNT,X
 STA STARTL
 LDA MSBSADDR,X
 ADC MSBLPPNT,X
 STA STARTH
 LDA BNKSADDR,X
 ADC BNKLPPNT,X
 STA STARTB
 LDA LSBLPLEN,X
 ADC STARTL
 STA ENDL
 LDA MSBLPLEN,X
 ADC STARTH
 STA ENDH
 LDA BNKLPLEN,X
 ADC STARTB
 STA ENDB
 LDX #0
 JSR RETRIG

SID8SUD2
 LDA FRACTION+1
 ADC STEPL+1
 STA FRACTION+1
 LDA TRKPNTL+1
 ADC STEPH+1
 STA TRKPNTL+1
 STA DMALO
 LDA TRKPNTH+1
 ADC #0
 STA TRKPNTH+1
 STA DMAHI
 LDA TRKPNTB+1
 ADC #0
 STA TRKPNTB+1
 STA DMABNK
 LDA #8
 STA DMADAL

 CLC
 LDX SECOND
 LDY TRK1DATA,X
 LDA (VOL1),Y
 LDX FOURTH+3
 LDY TRK4DATA,X
 ADC (VOL4),Y
 TAX
 AND #$F0
 STA SID8OUTHI
 TXA
 ASL
 ASL
 ASL
 ASL
 STA SID8OUTLO
 LDX EIGHTH+1
 LDY TRK2DATA,X
 LDA (VOL2),Y
 LDX SIXTH+2
 LDY TRK3DATA,X
 ADC (VOL3),Y
 TAX
 AND #$F0
 LDY #0
 STA (SID8OUTHIRIGHT),Y
 TXA
 ASL
 ASL
 ASL
 ASL
 STA (SID8OUTLORIGHT),Y
 LDA #$49
 STA SID8CLKLO
 STA SID8CLKHI
 STA (SID8CLKLORIGHT),Y
 STA (SID8CLKHIRIGHT),Y
 LDA #$41
 STA SID8CLKLO
 STA SID8CLKHI
 STA (SID8CLKLORIGHT),Y
 STA (SID8CLKHIRIGHT),Y

 LDX DELAY
DLLP43
 DEX
 BNE DLLP43

 LDA #$95
 STA DMACMD

 CLC
 LDX THIRD
 LDY TRK1DATA,X
 LDA (VOL1),Y
 LDX FIFTH+3
 LDY TRK4DATA,X
 ADC (VOL4),Y
 TAX
 AND #$F0
 STA SID8OUTHI
 TXA
 ASL
 ASL
 ASL
 ASL
 STA SID8OUTLO
 LDY TRK2DATA
 LDA (VOL2),Y
 LDX SEVENTH+2
 LDY TRK3DATA,X
 ADC (VOL3),Y
 TAX
 AND #$F0
 LDY #0
 STA (SID8OUTHIRIGHT),Y
 TXA
 ASL
 ASL
 ASL
 ASL
 STA (SID8OUTLORIGHT),Y
 LDA #$49
 STA SID8CLKLO
 STA SID8CLKHI
 STA (SID8CLKLORIGHT),Y
 STA (SID8CLKHIRIGHT),Y
 LDA #$41
 STA SID8CLKLO
 STA SID8CLKHI
 STA (SID8CLKLORIGHT),Y
 STA (SID8CLKHIRIGHT),Y

 LDX DELAY
DLLP44
 DEX
 BNE DLLP44
 
 SEC
 LDA TRKPNTL+1
 SBC ENDL+1
 LDA TRKPNTH+1
 SBC ENDH+1
 LDA TRKPNTB+1
 SBC ENDB+1
 BCC SID8SUD3
 LDX SAMPLENUM+1
 LDA LSBLPLEN,X
 ORA MSBLPLEN,X
 ORA BNKLPLEN,X
 BNE SID8SLP2
 LDX #1
 JSR RETRIG
 LDA #0
 STA SECOND+1
 STA THIRD+1
 STA FOURTH+1
 STA FIFTH+1
 STA SIXTH+1
 STA SEVENTH+1
 STA EIGHTH+1
 STA STEPL+1
 STA STEPH+1
 JSR SV2
 JMP SID8SUD3

SID8SLP2
 CLC
 LDA LSBSADDR,X
 ADC LSBLPPNT,X
 STA STARTL+1
 LDA MSBSADDR,X
 ADC MSBLPPNT,X
 STA STARTH+1
 LDA BNKSADDR,X
 ADC BNKLPPNT,X
 STA STARTB+1
 LDA LSBLPLEN,X
 ADC STARTL+1
 STA ENDL+1
 LDA MSBLPLEN,X
 ADC STARTH+1
 STA ENDH+1
 LDA BNKLPLEN,X
 ADC STARTB+1
 STA ENDB+1
 LDX #1
 JSR RETRIG

SID8SUD3
 LDA FRACTION+2
 ADC STEPL+2
 STA FRACTION+2
 LDA TRKPNTL+2
 ADC STEPH+2
 STA TRKPNTL+2
 STA DMALO
 LDA TRKPNTH+2
 ADC #0
 STA TRKPNTH+2
 STA DMAHI
 LDA TRKPNTB+2
 ADC #0
 STA TRKPNTB+2
 STA DMABNK
 LDA #8
 STA DMADAL

 CLC
 LDX FOURTH
 LDY TRK1DATA,X
 LDA (VOL1),Y
 LDX SIXTH+3
 LDY TRK4DATA,X
 ADC (VOL4),Y
 TAX
 AND #$F0
 STA SID8OUTHI
 TXA
 ASL
 ASL
 ASL
 ASL
 STA SID8OUTLO
 LDX SECOND+1
 LDY TRK2DATA,X
 LDA (VOL2),Y
 LDX EIGHTH+2
 LDY TRK3DATA,X
 ADC (VOL3),Y
 TAX
 AND #$F0
 LDY #0
 STA (SID8OUTHIRIGHT),Y
 TXA
 ASL
 ASL
 ASL
 ASL
 STA (SID8OUTLORIGHT),Y
 LDA #$49
 STA SID8CLKLO
 STA SID8CLKHI
 STA (SID8CLKLORIGHT),Y
 STA (SID8CLKHIRIGHT),Y
 LDA #$41
 STA SID8CLKLO
 STA SID8CLKHI
 STA (SID8CLKLORIGHT),Y
 STA (SID8CLKHIRIGHT),Y

 LDX DELAY
DLLP45
 DEX
 BNE DLLP45

 LDA #$95
 STA DMACMD

 CLC
 LDX FIFTH
 LDY TRK1DATA,X
 LDA (VOL1),Y
 LDX SEVENTH+3
 LDY TRK4DATA,X
 ADC (VOL4),Y
 TAX
 AND #$F0
 STA SID8OUTHI
 TXA
 ASL
 ASL
 ASL
 ASL
 STA SID8OUTLO
 LDX THIRD+1
 LDY TRK2DATA,X
 LDA (VOL2),Y
 LDY TRK3DATA
 ADC (VOL3),Y
 TAX
 AND #$F0
 LDY #0
 STA (SID8OUTHIRIGHT),Y
 TXA
 ASL
 ASL
 ASL
 ASL
 STA (SID8OUTLORIGHT),Y
 LDA #$49
 STA SID8CLKLO
 STA SID8CLKHI
 STA (SID8CLKLORIGHT),Y
 STA (SID8CLKHIRIGHT),Y
 LDA #$41
 STA SID8CLKLO
 STA SID8CLKHI
 STA (SID8CLKLORIGHT),Y
 STA (SID8CLKHIRIGHT),Y

 LDX DELAY
DLLP46
 DEX
 BNE DLLP46 

 SEC
 LDA TRKPNTL+2
 SBC ENDL+2
 LDA TRKPNTH+2
 SBC ENDH+2
 LDA TRKPNTB+2
 SBC ENDB+2
 BCC SID8SUD4
 LDX SAMPLENUM+2
 LDA LSBLPLEN,X
 ORA MSBLPLEN,X
 ORA BNKLPLEN,X
 BNE SID8SLP3
 LDX #2
 JSR RETRIG
 LDA #0
 STA SECOND+2
 STA THIRD+2
 STA FOURTH+2
 STA FIFTH+2
 STA SIXTH+2
 STA SEVENTH+2
 STA EIGHTH+2
 STA STEPL+2
 STA STEPH+2
 JSR SV2
 JMP SID8SUD4

SID8SLP3
 CLC
 LDA LSBSADDR,X
 ADC LSBLPPNT,X
 STA STARTL+2
 LDA MSBSADDR,X
 ADC MSBLPPNT,X
 STA STARTH+2
 LDA BNKSADDR,X
 ADC BNKLPPNT,X
 STA STARTB+2
 LDA LSBLPLEN,X
 ADC STARTL+2
 STA ENDL+2
 LDA MSBLPLEN,X
 ADC STARTH+2
 STA ENDH+2
 LDA BNKLPLEN,X
 ADC STARTB+2
 STA ENDB+2
 LDX #2
 JSR RETRIG

SID8SUD4
 LDA FRACTION+3
 ADC STEPL+3
 STA FRACTION+3
 LDA TRKPNTL+3
 ADC STEPH+3
 STA TRKPNTL+3
 STA DMALO
 LDA TRKPNTH+3
 ADC #0
 STA TRKPNTH+3
 STA DMAHI
 LDA TRKPNTB+3
 ADC #0
 STA TRKPNTB+3
 STA DMABNK
 LDA #8
 STA DMADAL

 CLC
 LDX SIXTH
 LDY TRK1DATA,X
 LDA (VOL1),Y
 LDX EIGHTH+3 
 LDY TRK4DATA,X
 ADC (VOL4),Y
 TAX
 AND #$F0
 STA SID8OUTHI
 TXA
 ASL
 ASL
 ASL
 ASL
 STA SID8OUTLO
 LDX FOURTH+1
 LDY TRK2DATA,X
 LDA (VOL2),Y
 LDX SECOND+2
 LDY TRK3DATA,X
 ADC (VOL3),Y
 TAX
 AND #$F0
 LDY #0
 STA (SID8OUTHIRIGHT),Y
 TXA
 ASL
 ASL
 ASL
 ASL
 STA (SID8OUTLORIGHT),Y
 LDA #$49
 STA SID8CLKLO
 STA SID8CLKHI
 STA (SID8CLKLORIGHT),Y
 STA (SID8CLKHIRIGHT),Y
 LDA #$41
 STA SID8CLKLO
 STA SID8CLKHI
 STA (SID8CLKLORIGHT),Y
 STA (SID8CLKHIRIGHT),Y

 LDX DELAY
DLLP47
 DEX
 BNE DLLP47
 
 LDA #$95
 STA DMACMD

 CLC
 LDX SEVENTH
 LDY TRK1DATA,X
 LDA (VOL1),Y
 LDY TRK4DATA
 ADC (VOL4),Y
 TAX
 AND #$F0
 STA SID8OUTHI
 TXA
 ASL
 ASL
 ASL
 ASL
 STA SID8OUTLO
 LDX FIFTH+1
 LDY TRK2DATA,X
 LDA (VOL2),Y
 LDX THIRD+2
 LDY TRK3DATA,X
 ADC (VOL3),Y
 TAX
 AND #$F0
 LDY #0
 STA (SID8OUTHIRIGHT),Y
 TXA
 ASL
 ASL
 ASL
 ASL
 STA (SID8OUTLORIGHT),Y
 LDA #$49
 STA SID8CLKLO
 STA SID8CLKHI
 STA (SID8CLKLORIGHT),Y
 STA (SID8CLKHIRIGHT),Y
 LDA #$41
 STA SID8CLKLO
 STA SID8CLKHI
 STA (SID8CLKLORIGHT),Y
 STA (SID8CLKHIRIGHT),Y

 LDX DELAY2
DLLP48
 DEX
 BNE DLLP48
 
 SEC
 LDA TRKPNTL+3
 SBC ENDL+3
 LDA TRKPNTH+3
 SBC ENDH+3
 LDA TRKPNTB+3
 SBC ENDB+3
 BCC SID8SCHKT
 LDX SAMPLENUM+3
 LDA LSBLPLEN,X
 ORA MSBLPLEN,X
 ORA BNKLPLEN,X
 BNE SID8SLP4
 LDX #3
 JSR RETRIG
 LDA #0
 STA SECOND+3
 STA THIRD+3
 STA FOURTH+3
 STA FIFTH+3
 STA SIXTH+3
 STA SEVENTH+3
 STA EIGHTH+3
 STA STEPL+3
 STA STEPH+3
 JSR SV2
 JMP SID8SCHKT

SID8SLP4
 CLC
 LDA LSBSADDR,X
 ADC LSBLPPNT,X
 STA STARTL+3
 LDA MSBSADDR,X
 ADC MSBLPPNT,X
 STA STARTH+3
 LDA BNKSADDR,X
 ADC BNKLPPNT,X
 STA STARTB+3
 LDA LSBLPLEN,X
 ADC STARTL+3
 STA ENDL+3
 LDA MSBLPLEN,X
 ADC STARTH+3
 STA ENDH+3
 LDA BNKLPLEN,X
 ADC STARTB+3
 STA ENDB+3
 LDX #3
 JSR RETRIG

SID8SCHKT
 LDA $DD0D
 AND #$01
 BNE SID8SEXIT
 JMP SID8SUD1

SID8SEXIT
 LDA #$09
 STA $DD0E
 LDA #$41
 STA SID+18
 LDY #18
 STA (RIGHTSID),Y
 RTS

; IXER FOR IGIMAX CARD, IN STEREO

DIGIUD1
 LDA #<TRK1DATA
 STA DMAADL
 CLC
 LDA FRACTION
 ADC STEPL
 STA FRACTION
 LDA TRKPNTL
 ADC STEPH
 STA TRKPNTL
 STA DMALO
 LDA TRKPNTH
 ADC #0
 STA TRKPNTH
 STA DMAHI
 LDA TRKPNTB
 ADC #0
 STA TRKPNTB
 STA DMABNK
 LDA #8
 STA DMADAL

 CLC
 LDX EIGHTH
 LDY TRK1DATA,X
 LDA (VOL1),Y
 LDX SECOND+3
 LDY TRK4DATA,X
 ADC (VOL4),Y
 LDX #LEFT
 STX DIGITRACK
 STA USEROUT

 LDX SIXTH+1
 LDY TRK2DATA,X
 LDA (VOL2),Y
 LDX FOURTH+2
 LDY TRK3DATA,X
 ADC (VOL3),Y
 LDX #RIGHT
 STX DIGITRACK
 STA USEROUT
 LDA #$95
 STA DMACMD

 LDY TRK1DATA
 LDA (VOL1),Y
 LDX THIRD+3
 LDY TRK4DATA,X
 ADC (VOL4),Y
 LDX #LEFT
 STX DIGITRACK
 STA USEROUT

 LDX SEVENTH+1
 LDY TRK2DATA,X
 LDA (VOL2),Y
 LDX FIFTH+2
 LDY TRK3DATA,X
 ADC (VOL3),Y
 LDX #RIGHT
 STX DIGITRACK
 STA USEROUT

 SEC
 LDA TRKPNTL
 SBC ENDL
 LDA TRKPNTH
 SBC ENDH
 LDA TRKPNTB
 SBC ENDB
 BCC DIGIUD2
 LDX SAMPLENUM
 LDA LSBLPLEN,X
 ORA MSBLPLEN,X
 ORA BNKLPLEN,X
 BNE DIGILP1
 LDX #0
 JSR RETRIG
 LDA #0
 STA SECOND
 STA THIRD
 STA FOURTH
 STA FIFTH
 STA SIXTH
 STA SEVENTH
 STA EIGHTH
 STA STEPL
 STA STEPH
 JSR SV2
 JMP DIGIUD2

DIGILP1
 CLC
 LDA LSBSADDR,X
 ADC LSBLPPNT,X
 STA STARTL
 LDA MSBSADDR,X
 ADC MSBLPPNT,X
 STA STARTH
 LDA BNKSADDR,X
 ADC BNKLPPNT,X
 STA STARTB
 LDA LSBLPLEN,X
 ADC STARTL
 STA ENDL
 LDA MSBLPLEN,X
 ADC STARTH
 STA ENDH
 LDA BNKLPLEN,X
 ADC STARTB
 STA ENDB
 LDX #0
 JSR RETRIG

DIGIUD2
 LDA FRACTION+1
 ADC STEPL+1
 STA FRACTION+1
 LDA TRKPNTL+1
 ADC STEPH+1
 STA TRKPNTL+1
 STA DMALO
 LDA TRKPNTH+1
 ADC #0
 STA TRKPNTH+1
 STA DMAHI
 LDA TRKPNTB+1
 ADC #0
 STA TRKPNTB+1
 STA DMABNK
 LDA #8
 STA DMADAL

 CLC
 LDX SECOND
 LDY TRK1DATA,X
 LDA (VOL1),Y
 LDX FOURTH+3
 LDY TRK4DATA,X
 ADC (VOL4),Y
 LDX #LEFT
 STX DIGITRACK
 STA USEROUT

 LDX EIGHTH+1
 LDY TRK2DATA,X
 LDA (VOL2),Y
 LDX SIXTH+2
 LDY TRK3DATA,X
 ADC (VOL3),Y
 LDX #RIGHT
 STX DIGITRACK
 STA USEROUT

 LDA #$95
 STA DMACMD

 LDX THIRD
 LDY TRK1DATA,X
 LDA (VOL1),Y
 LDX FIFTH+3
 LDY TRK4DATA,X
 ADC (VOL4),Y
 LDX #LEFT
 STX DIGITRACK
 STA USEROUT

 LDY TRK2DATA
 LDA (VOL2),Y
 LDX SEVENTH+2
 LDY TRK3DATA,X
 ADC (VOL3),Y
 LDX #RIGHT
 STX DIGITRACK
 STA USEROUT

 SEC
 LDA TRKPNTL+1
 SBC ENDL+1
 LDA TRKPNTH+1
 SBC ENDH+1
 LDA TRKPNTB+1
 SBC ENDB+1
 BCC DIGIUD3
 LDX SAMPLENUM+1
 LDA LSBLPLEN,X
 ORA MSBLPLEN,X
 ORA BNKLPLEN,X
 BNE DIGILP2
 LDX #1
 JSR RETRIG
 LDA #0
 STA SECOND+1
 STA THIRD+1
 STA FOURTH+1
 STA FIFTH+1
 STA SIXTH+1
 STA SEVENTH+1
 STA EIGHTH+1
 STA STEPL+1
 STA STEPH+1
 JSR SV2
 JMP DIGIUD3

DIGILP2
 CLC
 LDA LSBSADDR,X
 ADC LSBLPPNT,X
 STA STARTL+1
 LDA MSBSADDR,X
 ADC MSBLPPNT,X
 STA STARTH+1
 LDA BNKSADDR,X
 ADC BNKLPPNT,X
 STA STARTB+1
 LDA LSBLPLEN,X
 ADC STARTL+1
 STA ENDL+1
 LDA MSBLPLEN,X
 ADC STARTH+1
 STA ENDH+1
 LDA BNKLPLEN,X
 ADC STARTB+1
 STA ENDB+1
 LDX #1
 JSR RETRIG

DIGIUD3
 LDA FRACTION+2
 ADC STEPL+2
 STA FRACTION+2
 LDA TRKPNTL+2
 ADC STEPH+2
 STA TRKPNTL+2
 STA DMALO
 LDA TRKPNTH+2
 ADC #0
 STA TRKPNTH+2
 STA DMAHI
 LDA TRKPNTB+2
 ADC #0
 STA TRKPNTB+2
 STA DMABNK
 LDA #8
 STA DMADAL

 CLC
 LDX FOURTH
 LDY TRK1DATA,X
 LDA (VOL1),Y
 LDX SIXTH+3
 LDY TRK4DATA,X
 ADC (VOL4),Y
 LDX #LEFT
 STX DIGITRACK
 STA USEROUT

 LDX SECOND+1
 LDY TRK2DATA,X
 LDA (VOL2),Y
 LDX EIGHTH+2
 LDY TRK3DATA,X
 ADC (VOL3),Y
 LDX #RIGHT
 STX DIGITRACK
 STA USEROUT

 LDA #$95
 STA DMACMD

 LDX FIFTH
 LDY TRK1DATA,X
 LDA (VOL1),Y
 LDX SEVENTH+3
 LDY TRK4DATA,X
 ADC (VOL4),Y
 LDX #LEFT
 STX DIGITRACK
 STA USEROUT

 LDX THIRD+1
 LDY TRK2DATA,X
 LDA (VOL2),Y
 LDY TRK3DATA
 ADC (VOL3),Y
 LDX #RIGHT
 STX DIGITRACK
 STA USEROUT

 SEC
 LDA TRKPNTL+2
 SBC ENDL+2
 LDA TRKPNTH+2
 SBC ENDH+2
 LDA TRKPNTB+2
 SBC ENDB+2
 BCC DIGIUD4
 LDX SAMPLENUM+2
 LDA LSBLPLEN,X
 ORA MSBLPLEN,X
 ORA BNKLPLEN,X
 BNE DIGILP3
 LDX #2
 JSR RETRIG
 LDA #0
 STA SECOND+2
 STA THIRD+2
 STA FOURTH+2
 STA FIFTH+2
 STA SIXTH+2
 STA SEVENTH+2
 STA EIGHTH+2
 STA STEPL+2
 STA STEPH+2
 JSR SV2
 JMP DIGIUD4

DIGILP3
 CLC
 LDA LSBSADDR,X
 ADC LSBLPPNT,X
 STA STARTL+2
 LDA MSBSADDR,X
 ADC MSBLPPNT,X
 STA STARTH+2
 LDA BNKSADDR,X
 ADC BNKLPPNT,X
 STA STARTB+2
 LDA LSBLPLEN,X
 ADC STARTL+2
 STA ENDL+2
 LDA MSBLPLEN,X
 ADC STARTH+2
 STA ENDH+2
 LDA BNKLPLEN,X
 ADC STARTB+2
 STA ENDB+2
 LDX #2
 JSR RETRIG

DIGIUD4
 LDA FRACTION+3
 ADC STEPL+3
 STA FRACTION+3
 LDA TRKPNTL+3
 ADC STEPH+3
 STA TRKPNTL+3
 STA DMALO
 LDA TRKPNTH+3
 ADC #0
 STA TRKPNTH+3
 STA DMAHI
 LDA TRKPNTB+3
 ADC #0
 STA TRKPNTB+3
 STA DMABNK
 LDA #8
 STA DMADAL

 CLC
 LDX SIXTH
 LDY TRK1DATA,X
 LDA (VOL1),Y
 LDX EIGHTH+3 
 LDY TRK4DATA,X
 ADC (VOL4),Y
 LDX #LEFT
 STX DIGITRACK
 STA USEROUT

 LDX FOURTH+1
 LDY TRK2DATA,X
 LDA (VOL2),Y
 LDX SECOND+2
 LDY TRK3DATA,X
 ADC (VOL3),Y
 LDX #RIGHT
 STX DIGITRACK
 STA USEROUT

 LDA #$95
 STA DMACMD

 LDX SEVENTH
 LDY TRK1DATA,X
 LDA (VOL1),Y
 LDY TRK4DATA
 ADC (VOL4),Y
 LDX #LEFT
 STX DIGITRACK
 STA USEROUT

 LDX FIFTH+1
 LDY TRK2DATA,X
 LDA (VOL2),Y
 LDX THIRD+2
 LDY TRK3DATA,X
 ADC (VOL3),Y
 LDX #RIGHT
 STX DIGITRACK
 STA USEROUT

 SEC
 LDA TRKPNTL+3
 SBC ENDL+3
 LDA TRKPNTH+3
 SBC ENDH+3
 LDA TRKPNTB+3
 SBC ENDB+3
 BCC DIGICHKT
 LDX SAMPLENUM+3
 LDA LSBLPLEN,X
 ORA MSBLPLEN,X
 ORA BNKLPLEN,X
 BNE DIGILP4
 LDX #3
 JSR RETRIG
 LDA #0
 STA SECOND+3
 STA THIRD+3
 STA FOURTH+3
 STA FIFTH+3
 STA SIXTH+3
 STA SEVENTH+3
 STA EIGHTH+3
 STA STEPL+3
 STA STEPH+3
 JSR SV2
 JMP DIGICHKT

DIGILP4
 CLC
 LDA LSBSADDR,X
 ADC LSBLPPNT,X
 STA STARTL+3
 LDA MSBSADDR,X
 ADC MSBLPPNT,X
 STA STARTH+3
 LDA BNKSADDR,X
 ADC BNKLPPNT,X
 STA STARTB+3
 LDA LSBLPLEN,X
 ADC STARTL+3
 STA ENDL+3
 LDA MSBLPLEN,X
 ADC STARTH+3
 STA ENDH+3
 LDA BNKLPLEN,X
 ADC STARTB+3
 STA ENDB+3
 LDX #3
 JSR RETRIG

DIGICHKT
 LDA $DD0D
 AND #$01
 BNE DIGIEXIT
 JMP DIGIUD1

DIGIEXIT
 LDA #$09
 STA $DD0E
 RTS

