# choose your crossassembler (if you have one).
# mandatory only if you want to hack any of the 6502 sources.
#
XASS        = xa
#XASS	     = cl65

# destination directories
#
PREFIX      = /usr/local
BINDIR	    = $(PREFIX)/bin
LIBDIR	    = $(PREFIX)/lib
MANDIR	    = $(PREFIX)/man/man1
INFODIR	    = $(PREFIX)/info
INCDIR	    = $(PREFIX)/include
MODDIR      = `for d in /lib/modules/\`uname -r\`/{misc,kernel/drivers/char}; do test -d $$d && echo $$d; done`

# common compile flags
#
CFLAGS      = -m486 -O5 -Wall -I../include

# kernel driver compile flags
# add `-D__SMP__ if you have a SMP kernel
#
KERN_FLAGS  = $(CFLAGS) -DMODULE -D__KERNEL__ -I/usr/src/linux/include

# uncomment the next line if you want to use your old (cbm4linux <= 0.2.0)
# XE1541-like cable.
#
#KERN_FLAGS  = $(CFLAGS) -DMODULE -D__KERNEL__ -DOLD_C4L_CABLE

# d64copy compile flags
#
D64COPY     = $(CFLAGS)

# uncomment the next line to use kernel module handshakes with the
# custom transfer routines. This will reduce system load but also have
# a bad inpact on total transfer times.
# It's experimental, so don't use it ;-)
#
#D64COPY     = $(CFLAGS) -DUSE_CBM_IEC_WAIT

LINK_FLAGS  = -L../lib -lcbm4linux
CC          = gcc
LD          = ld
AR          = ar

.SUFFIXES: .a65 .o65 .inc

.o65.inc:
	test -s $< && od -w8 -txC -v -An $< | \
	sed 's/\([0-9a-f]\{2\}\) */0x\1,/g; $$s/,$$//' > $@
	
# xa defs
#
XA	    = xa

# cl65 defs, contributed by Ullrich von Bassewitz <uz@musoftware.de>
# (cc65 >= 2.6 required)
#
CL65        = cl65
LD65        = ld65
CA65_FLAGS  = --feature labels_without_colons --feature pc_assignment --feature loose_char_term


.a65.o65:
ifeq ($(XASS),xa)
	$(XA) $< -o $@
else
ifeq ($(XASS),cl65)
	$(CL65) -c $(CA65_FLAGS) -o $*.tmp $<
	$(LD65) --target none -o $@ $*.tmp && rm -f $*.tmp
endif
	@echo "*** Error: No crossassembler defined. Check config.make" 2>&1
	exit 1
endif
