/*
 *	This program is free software; you can redistribute it and/or
 *	modify it under the terms of the GNU General Public License
 *	as published by the Free Software Foundation; either version
 *	2 of the License, or (at your option) any later version.
 *
 *  Copyright 1999 Michael Klein <michael.klein@puffin.lb.shuttle.de>
*/

#ifndef _D64COPY_H
#define _D64COPY_H

#include "gcr.h"

#define STD_BLOCKS  683
#define EXT_BLOCKS  768

#define STD_TRACKS   35
#define EXT_TRACKS   40
#define MAX_SECTORS  21

#define BS_MUST_COPY  '-'
#define BS_DONT_COPY  '.'
#define BS_COPIED     '*'

typedef int(*turbo_start)(int);

struct transfer_funcs {
    int  (*open_disk)(char*,int,int,turbo_start);
    int  (*read_block)(int,int,char*);
    int  (*write_block)(int,int,char*,int);
    void (*close_disk)(void);
    int  is_cbm_drive;
    int  needs_turbo;
    int  (*send_track_map)(int,char*,int);
    int  (*read_gcr_block)(int*,unsigned char*);
};

#define DECLARE_TRANSFER_FUNCS(x,c,t) \
    struct transfer_funcs x = {open_disk, \
                               read_block, \
                               write_block, \
                               close_disk, \
                               c, \
                               t, \
                               NULL, \
                               NULL}

#define DECLARE_TRANSFER_FUNCS_EX(x,c,t) \
    struct transfer_funcs x = {open_disk, \
                               read_block, \
                               write_block, \
                               close_disk, \
                               c, \
                               t, \
                               send_track_map, \
                               read_gcr_block}
    
extern char sector_map[EXT_TRACKS+1];
extern int  fd_cbm;
extern int drive_type;

#endif
