/*
 *	This program is free software; you can redistribute it and/or
 *	modify it under the terms of the GNU General Public License
 *	as published by the Free Software Foundation; either version
 *	2 of the License, or (at your option) any later version.
 *
 *  Copyright 1999 Michael Klein <michael.klein@puffin.lb.shuttle.de>
*/

#include "cbm4linux.h"
#include "d64copy.h"

#include <stdlib.h>

#ifndef USE_CBM_IEC_WAIT
#include <unistd.h>
#endif

static unsigned char s1_drive_prog[] = {
#include "s1.inc"
};

static int s1_write_byte(int fd, unsigned char c)
{
    int b, i;
    for(i=7; i>=0; i--) {
        b=(c >> i) & 1;
        if(b) cbm_iec_set(fd, IEC_DATA); else cbm_iec_release(fd, IEC_DATA);
        cbm_iec_release(fd, IEC_CLOCK);
#ifndef USE_CBM_IEC_WAIT
        while(!cbm_iec_get(fd, IEC_CLOCK));
#else
        cbm_iec_wait(fd, IEC_CLOCK, 1);
#endif
        if(b) cbm_iec_release(fd, IEC_DATA); else cbm_iec_set(fd, IEC_DATA);
#ifndef USE_CBM_IEC_WAIT
        while(cbm_iec_get(fd, IEC_CLOCK));
#else
        cbm_iec_wait(fd, IEC_CLOCK, 0);
#endif
        cbm_iec_release(fd, IEC_DATA);
        cbm_iec_set(fd, IEC_CLOCK);
#ifndef USE_CBM_IEC_WAIT
        while(!cbm_iec_get(fd, IEC_DATA));
#else
        cbm_iec_wait(fd, IEC_DATA, 1);
#endif
    }
    return 0;
}

static int s1_read_byte(int fd, unsigned char *c)
{
    int b=0, i;
    *c = 0;
    for(i=7; i>=0; i--) {
#ifndef USE_CBM_IEC_WAIT
        while(cbm_iec_get(fd, IEC_DATA));
#else        
        cbm_iec_wait(fd, IEC_DATA, 0);
#endif
        cbm_iec_release(fd, IEC_CLOCK);
        b = cbm_iec_get(fd, IEC_CLOCK);
        *c = (*c >> 1) | (b ? 0x80 : 0);
        cbm_iec_set(fd, IEC_DATA);
#ifndef USE_CBM_IEC_WAIT
        while(b == cbm_iec_get(fd, IEC_CLOCK));
#else        
        cbm_iec_wait(fd, IEC_CLOCK, !b);
#endif
        cbm_iec_release(fd, IEC_DATA);
#ifndef USE_CBM_IEC_WAIT
        while(!cbm_iec_get(fd, IEC_DATA));
#else        
        cbm_iec_wait(fd, IEC_DATA, 1);
#endif
        cbm_iec_set(fd, IEC_CLOCK);
    }
    return 0;
}

static int read_block(int tr, int se, char *block)
{
    int  i;
    char status;

    s1_write_byte(fd_cbm, tr);
    s1_write_byte(fd_cbm, se);
#ifndef USE_CBM_IEC_WAIT    
    usleep(20000);
#endif    
    s1_read_byte(fd_cbm, &status);
    for(i=0;i<256;i++) s1_read_byte(fd_cbm, &block[i]);
    cbm_iec_release(fd_cbm, IEC_DATA);

    return status;
}

static int write_block(int tr, int se, char *block, int size)
{
    int  i;
    char status;

    s1_write_byte(fd_cbm, tr);
    s1_write_byte(fd_cbm, se);
    for(i=0;i<size;i++) s1_write_byte(fd_cbm, block[i]);
#ifndef USE_CBM_IEC_WAIT    
    if(size == BLOCKSIZE) {
        usleep(20000);
    }
#endif    
    s1_read_byte(fd_cbm, &status);
    cbm_iec_release(fd_cbm, IEC_DATA);

    return status;
}

static int open_disk(char *name, int for_writing, int ext, turbo_start start)
{
    int d = atoi(name);

    cbm_upload(fd_cbm, d, 0x700, s1_drive_prog, sizeof(s1_drive_prog));
    start(d);
    while(!cbm_iec_get(fd_cbm, IEC_DATA));
    return 0;
}

static void close_disk(void)
{
    s1_write_byte(fd_cbm, 0);
    s1_write_byte(fd_cbm, 0);
}

static int send_track_map(int tr, char *trackmap, int count)
{
    int i;
    s1_write_byte(fd_cbm, tr);
    s1_write_byte(fd_cbm, count);
    for(i = 0; i < sector_map[(int)tr]; i++) {
        s1_write_byte(fd_cbm, trackmap[i] != BS_MUST_COPY);
    }
    return 0;
}

static int read_gcr_block(int *se, unsigned char *gcrbuf)
{
    int i;
    unsigned char s;

    s1_read_byte(fd_cbm, &s);
    *se = s;
    s1_read_byte(fd_cbm,  &s);

    if(s) {
        return s;
    }

    for(i = 0; i < GCRBUFSIZE; i++) {
        s1_read_byte(fd_cbm, &gcrbuf[i]);
    }
    return 0;
}

DECLARE_TRANSFER_FUNCS_EX(s1_transfer, 1, 1);
