/* $Source: /u/mark/src/pax/RCS/func.h,v $
 *
 * $Revision: 2.0.0.5 $
 *
 * func.h - function type and argument declarations
 *
 * DESCRIPTION
 *
 *	This file contains function delcarations in both ANSI style
 *	(function prototypes) and traditional style.
 *
 * AUTHOR
 *
 *     Mark H. Colburn, Open Systems Architects, Inc. (mark@minnetech.mn.org)
 *
 * COPYRIGHT
 *
 *	Copyright (c) 1989 Mark H. Colburn.  All rights reserved.
 *
 *	Redistribution and use in source and binary forms are permitted
 *	provided that the above copyright notice and this paragraph are
 *	duplicated in all such forms and that any documentation,
 *	advertising materials, and other materials related to such
 *	distribution and use acknowledge that the software was developed
 *	by Mark H. Colburn.
 *
 *	THIS SOFTWARE IS PROVIDED ``AS IS'' AND WITHOUT ANY EXPRESS OR
 *	IMPLIED WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED
 *	WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
 */

#ifndef _PAX_FUNC_H
#define _PAX_FUNC_H

/* Function Prototypes */

#ifdef __STDC__

Link           *linkfrom(char *, Stat *);
Link           *linkto(char *, Stat *);
char           *mem_get(uint);
char           *mem_str(char *);
char           *strerror(void);
int 		ar_read(void);
int 		buf_read(char *, uint);
int 		buf_skip(OFFSET);
int 		create_archive(void);
int 		dirneed(char *);
int 		read_archive(void);
int 		inentry(char *, Stat *);
int 		lineget(FILE *, char *);
int 		name_match(char *);
int 		name_next(char *, Stat *);
int 		nameopt(char *);
int 		open_archive(int);
int 		open_tty(void);
int 		openin(char *, Stat *);
int 		openout(char *, Stat *, Link *, int);
int 		pass(char *);
int 		passitem(char *, Stat *, int, char *);
int 		read_header(char *, Stat *);
int 		wildmat(char *, char *);
void 		buf_allocate(OFFSET);
void 		close_archive(void);
void 		fatal(char *);
void 		name_gather(void);
void		name_init(int, char **);
void 		notfound(void);
void 		next(int);
int 		nextask(char *, char *, int);
void 		outdata(int, char *, OFFSET);
void 		outwrite(char *, uint);
void 		passdata(char *, int, char *, int);
void		print_entry(char *, Stat *);
void            warn();
void 		warnarch(char *, OFFSET);
void 		write_eot(void);
void 		get_archive_type(void);
struct group   *getgrgid();
struct group   *getgrnam();
struct passwd  *getpwuid();
char           *getenv(const char *);
Link           *islink(char *, Stat *);
char           *finduname(UIDTYPE);
char           *findgname(GIDTYPE);
GIDTYPE 	findgid(char *);
UIDTYPE 	finduid(char *);
void           *malloc();
char           *index(char *, char);
char           *rindex(char *, char);

/*
 * Theortically, this should not be necessary, however, some ANSI compilers
 * (notably GCC), do not yet have an ANSI conforming support library.
 */
#ifdef VOIDSIG
void                (*signal()) ();
#else /* VOIDSIG */
int                 (*signal()) ();
#endif /* VOIDSIG */

#if defined(PC) && defined(DIO)
extern  int dio_write(int drive,char *from_buf,unsigned int from_cnt);
extern  int dio_read(int drive,char *to_buf,unsigned int to_cnt);
extern  int dio_open_check(char *s);
extern  int dio_open2(char *p,int f);
extern  int dio_open3(char *p,int f,int m);
extern  int dio_close(int h);
extern  long dio_lseek(int h,long o,int r);
extern	void dio_str(char *s);
#endif /* PC */

#else /* !__STDC__ */

extern Link        *linkfrom();
extern Link        *linkto();
extern char        *mem_get();
extern char        *mem_str();
extern char        *strerror();
extern int          ar_read();
extern int          buf_read();
extern int          buf_skip();
extern int          create_archive();
extern int          dirneed();
extern int          read_archive();
extern int          inentry();
extern int          lineget();
extern int          name_match();
extern int          name_next();
extern int          nameopt();
extern int          open_archive();
extern int          open_tty();
extern int          openin();
extern int          openout();
extern int          pass();
extern int          passitem();
extern int          read_header();
extern int          wildmat();
extern void         buf_allocate();
extern void         close_archive();
extern void         fatal();
extern void         name_gather();
extern void         name_init();
extern void         notfound();
extern void         next();
extern int          nextask();
extern void         outdata();
extern void         outwrite();
extern void         passdata();
extern void         print_entry();
extern void         warn();
extern void         warnarch();
extern void         write_eot();
extern void         get_archive_type();
extern char        *index();
extern char        *rindex();
extern char        *getenv();
extern char        *malloc();
extern char        *strcat();
extern char        *strcpy();
extern char        *strncpy();
extern OFFSET       lseek();
extern struct group *getgrgid();
extern struct group *getgrnam();
extern struct passwd *getpwuid();
extern struct tm   *localtime();
extern time_t       time();
extern uint         sleep();
extern void         _exit();
extern void         exit();
extern void         free();
extern Link        *islink();
extern char        *finduname();
extern char        *findgname();
extern GIDTYPE      findgid();
extern UIDTYPE      finduid();

#ifdef VOIDSIG
extern void         (*signal()) ();
#else
extern int          (*signal()) ();
#endif

#if defined(PC) && defined(DIO)
extern  int dio_write();
extern  int dio_read();
extern  int dio_open_check();
extern  int dio_open2();
extern  int dio_open3();
extern  int dio_close();
extern  long dio_lseek();
extern	void dio_str();
#endif /* PC */

#ifndef STRTOK
extern	char *strtok();
#endif /* STRTOK */

#endif /* __STDC__ */
#endif /* _PAX_FUNC_H */
