.\" $Id: pax.man,v 2.0.0.0 89/10/30 07:32:55 mark Exp Locker: mark $
.TH PAX 1 "Minnetech Consulting, Inc." ""
.SH NAME
pax \- portable archive exchange 
.SH SYNOPSIS
.TP \w'\fBpax\fR\ 'u
.B pax
.RB [ \-cimopuvy ]
.RI "[\fB\-f\fR" " archive" ]
.RI "[\fB\-s\fR" " replstr" ]
.RI "[\fB\-t\fR" " device" ] 
.RI [ pattern... ]
.TP \w'\fBpax\ \-r\fR\ 'u
.B "pax\ \-r"
.RB [ \-cimnopuvy ]
.RI "[\fB\-f\fR" " archive" ]
.RI "[\fB\-s\fR" " replstr" ] 
.RI "[\fB\-t\fR" " device" ] 
.RI [ pattern... ]
.TP \w'\fBpax\ \-w\fR\ 'u
.B "pax\ \-w"
.RB [ \-adimuvy ] 
.RI "[\fB\-b\fR" " blocking" ]
.RI "[\fB\-f\fR" " archive" ] 
.RI "[\fB\-s\fR" " replstr" ] 
.RI "[\fB\-t\fR" " device" ] 
.RI "[\fB\-x\fR" " format" ]
.RI [ pathname... ]
.TP \w'\fBpax\ \-rw\fR\ 'u
.B "pax\ \-rw"
.RB [ \-ilmopuvy ] 
.RI "[\fB\-s\fR" " replstr" ] 
.RI [ pathname... ]
directory
.SH DESCRIPTION
.I Pax 
reads and writes archive files which conform to the 
.B "Archive/Interchange File Format" 
specified in 
.IR "IEEE Std. 1003.1-1988" .
.I Pax
can also read, but not write, a number of other file formats
in addition to those specified in the 
.B "Archive/Interchange File Format"
description.
Support for these traditional file formats, such as V7 
.I "tar" 
and System V binary 
.I "cpio" 
format archives,
is provided for backward compatibility and to maximize portability.
.PP
.I Pax 
will also support traditional 
.I cpio 
and 
System V
.I tar
interfaces if invoked with the name
"cpio" or "tar" respectively.
See the 
.I cpio(1) 
or 
.I tar(1)
manual pages for more details.
.PP
Combinations of the
.B \-r 
and 
.B \-w
command line arguments specify whether 
.I pax 
will read, write or list the contents of the specified archive,
or move the specified files to another directory.
.PP
The command line arguments are:
.TP .5i
.B \-w
writes the files and directories specified by 
.I pathname
operands to the standard output together with the pathname and status 
information prescribed by the archive format used.
A directory
.I pathname
operand refers to the files and (recursively) subdirectories of that 
directory.
If no 
.I pathname 
operands are given, then the standard input is read to get a
list of pathnames to copy, one pathname per line.
In this case, only those pathnames appearing on the standard input are
copied.
.TP .5i
.B \-r
.I Pax
reads an archive file from the standard input.
Only files with names that match any of the 
.I pattern
operands are selected for extraction.
The selected files are conditionally created and copied relative to the
current directory tree, subject to the options described below.
By default, the owner and group of selected files will be that of the
invoking process, and the permissions and modification times will be the
sames as those in the archive.
.RS .5i
.PP
The supported archive formats are automatically detected on input.
The default output format is 
.IR ustar ,
but may be overridden by the 
.B \-x
.I format
option described below.
.RE
.TP .5i
.B \-rw
.I Pax 
reads the files and directories named in the
.I pathname
operands and copies them to the destination 
.IR directory .
A directory
.I pathname 
operand refers to the files and (recursively) subdirectories of that
directory.
If no 
.I pathname
operands are given, the standard input is read to get a list of pathnames
to copy, one pathname per line.
In this case, only those pathnames appearing on the standard input are
copied.
The directory named by the 
.I directory
operand must exist and have the proper permissions before the copy can
occur.
.PP
If neither the
.BR \-r " or " \-w 
options are given, then 
.I pax
will list the contents of the specified archive.
In this mode, 
.I pax 
lists normal files one per line, hard link pathnames as
.sp
.RS 1i
.IR pathname " == " linkname
.RE
.sp
and symbolic link pathnames (if supported by the implementation) as
.sp
.RS 1i
.IR pathname " -> " linkname
.RE
.sp
where 
.I pathname
is the name of the file being extracted, and
.I linkname
is the name of a file which appeared earlier in the archive.
.PP
If the 
.B \-v
option is specified, then 
.I pax 
list normal pathnames in the same format used by the 
.I ls
utility with the
.B \-l
option.
Hard links are shown as
.sp
.RS 1i
.IR "<ls -l listing>" " == " linkname
.RE
.sp
and symbolic links (if supported) are shown as
.sp
.RS 1i
.IR "<ls -l listing>" " -> " linkname
.RE
.sp 
.PP
.I Pax 
is capable of reading and writing archives which span multiple physical 
volumes.
Upon detecting an end of medium on an archive which is not yet completed,
.I pax 
will prompt the user for the next volume of the archive and will allow the 
user to specify the location of the next volume.
.SS Options
The following options are available:
.TP 1i
.B \-a
The files specified by
.I pathname
are appended to the specified archive.
.TP 1i
.BI \-b " blocking"
Block the output at
.I blocking
bytes per write to the archive file.
A 
.B k
suffix multiplies 
.I blocking 
by 1024, a
.B b 
suffix multiplies 
.I blocking 
by 512 and a 
.B m
suffix multiplies 
.I blocking 
by 1048576 (1 megabyte).
For machines with 16-bit int's (VAXen, XENIX-286, etc.), 
the maximum buffer size is 32k-1.
If not specified,
.I blocking 
is automatically determined on input and is ignored for 
.B \-rw.
.TP 1i
.B \-c
Complement the match sense of the 
.I pattern
operands.
.TP 1i
.B \-d
Intermediate directories not explicitly listed in the archive are not 
created.
This option is ignored unless
the 
.B \-r
option is specified.
.TP 1i
.BI \-f " archive"
The
.I archive
option specifies the pathname of the input or output archive,
overriding the default of standard input for 
.B \-r
or standard output for
.BR \-w .
.TP 1i
.B \-i
Interactively rename files.
Substitutions specified by 
.B \-s
options (described below)
are performed before requesting the new file name from the user.
A file is skipped if an empty line is entered and
.I pax
exits with an exit status of 0 if 
.B EOF 
is encountered.
.TP 1i
.B \-l
Files are linked rather than copied when possible.
.TP 1i
.B \-m
File modification times are not retained.
.TP 1i
.B \-n
When 
.B \-r
is specified, but
.B \-w
is not, the 
.I pattern
arguments are treated as ordinary file names.
Only the first occurrence of each of these files in the input archive
is read.
The
.B pax
utility exits with a zero exit status after all files in the list have been
read.
If one or more files in the list is not found,
.B pax
writes a diagnostic to standard error for each of the files and exits with
a non-zero exit status.
the file names are compared before any of the 
.BR \-i ,
.BR \-s ,
or
.B \-y
options are applied.
.TP 1i
.B \-o
Restore file ownership as specified in the archive.
The invoking process must have appropriate privileges to accomplish this.
.TP 1i
.B \-p
Preserve the access time of the input files after they have been copied.
.TP 1i
.BI \-s " replstr"
File names are modified according to the substitution expression using the 
syntax of 
.I "ed(1)"
as shown:
.sp
.RS 2i
-s /\fIold\fR/\fInew\fR/\fB[\fRgp\fB]\fR
.RE
.RS 1i
.PP
Any non null character may be used as a delimiter (a / is used here as an
example).
Multiple 
.B \-s
expressions may be specified; the expressions are applied in the order
specified terminating with the first successful substitution.
The optional trailing 
.B p
causes successful mappings to be listed on standard error.
The optional trailing
.B g
causes the 
.I old 
expression to be replaced each time it occurs in the source string.
Files that substitute to an empty string are ignored both on input and
output.
.RE
.TP 1i
.BI \-t " device"
The
.I device
option argument is an implementation-defined identifier that names the input
or output archive device, overriding the default of standard input for
.B \-r
and standard output for
.BR \-w .
.TP 1i
.B \-u
Copy each file only if it is newer than a pre-existing file with the same
name.
This implies 
.BR \-a .
.TP 1i
.B \-v
List file names as they are encountered.
Produces a verbose table of contents listing on the standard output when both 
.B \-r 
and
.B \-w
are omitted,
otherwise the file names are printed to standard error as they are
encountered in the archive.
.TP 1i
.BI \-x " format"
Specifies the output archive
.IR format .
The input format, which must be one of the following, is automatically
determined when the
.B \-r 
option is used.
The supported formats are:
.RS 1i
.TP 0.75i
.I cpio
The extended 
.I CPIO
interchange format specified in
.B "Extended CPIO Format" in 
.I "IEEE Std. 1003.1-1988."
.TP 0.75i
.I ustar
The extended 
.I TAR
interchange format specified in
.B "Extended TAR Format" in 
.I "IEEE Std. 1003.1-1988."
This is the default archive format.
.RE
.TP 1i
.B \-y
Interactively prompt for the disposition of each file.
Substitutions specified by 
.B \-s
options (described above)
are performed before prompting the user for disposition.
.B EOF
or an input line starting with the character
.B q
caused
.I pax
to exit.
Otherwise, an input line starting with anything other than 
.B y
causes the file to be ignored.
This option cannot be used in conjunction with the 
.B \-i 
option.
.PP
Only the last of multiple 
.B \-f 
or
.B \-t
options take effect.
.PP
When writing to an archive, the
standard input is used as a list of pathnames if no
.I pathname
operands are specified.
The format is one pathname per line.
Otherwise, the standard input is the archive file,
which is formatted according to one of the specifications in
.B "Archive/Interchange File format"
in 
.IR "IEEE Std. 1003.1-1988" ,
or some other implementation-defined format.
.PP
The user ID and group ID of the process, together with the appropriate
privileges, affect the ability of 
.I pax
to restore ownership and permissions attributes of the archived files.
(See 
.I "format-reading utility"
in
.B "Archive/Interchange File Format"
in 
.IR "IEEE Std. 1003.1-1988" ".)"
.PP
The options
.BR \-a ,
.BR \-c ,
.BR \-d ,
.BR \-i ,
.BR \-l ,
.BR \-p ,
.BR \-t ,
.BR \-u ,
and
.BR \-y 
are provided for functional compatibility with the historical
.I cpio
and
.I tar
utilities.
The option defaults were chosen based on the most common usage of these
options, therefore, some of the options have meanings different than
those of the historical commands.
.SS Operands
The following operands are available:
.TP 1i
.I directory
The destination directory pathname for copies when both the
.B \-r
and 
.B \-w
options are specified.
The directory must exist and be writable before the copy or and error
results.
.TP 1i
.I pathname
A file whose contents are used instead of the files named on the standard
input.
When a directory is named, all of its files and (recursively) 
subdirectories
are copied as well.
.TP 1i
.IR pattern 
A
.I pattern
is given in the standard shell pattern matching notation.
The default if no 
.I pattern 
is  specified is
.BR * \,
which selects all files.
.SH EXAMPLES
The following command
.sp
.RS 1i
pax \-w \-f /dev/rmt0 \.
.RE
.sp
copies the contents of the current directory to tape drive 0.
.PP
The commands
.sp
.RS 1i
.RI mkdir " newdir"
.br
.RI cd " olddir"
.br
.RI "pax -rw . " newdir
.RE
.sp
copies the contents of 
.I olddir 
to 
.I newdir .
.PP
The command
.sp
.RS 1i
pax \-r \-s ',//*usr//*,,' -f pax.out
.RE
.sp
reads the archive 
.B pax.out
with all files rooted in "/usr" in the archive extracted
relative to the current directory.
.SH FILES
.TP 1i
/dev/tty
used to prompt the user for information when the
.BR \-i " or " \-y
options are specified. 
.SH "SEE ALSO"
cpio(1), find(1), tar(1), cpio(5), tar(5)
.SH DIAGNOSTICS
.I Pax
will terminate immediately, without processing any 
additional files on the command line or in the archive.
.SH "EXIT CODES"
.I Pax 
will exit with one of the following values:
.IP 0 .5i
All files in the archive were processed successfully.
.IP ">0" .5i
.I Pax 
aborted due to errors encountered during operation.
.SH BUGS
Special permissions may be required to copy or extract special files.
.PP
Device, user ID, and group ID numbers larger than 65535 cause additional
header records to be output.
These records are ignored by some historical version of
.I "cpio(1)"
and
.IR "tar(1)" .
.PP
The archive formats described in
.B "Archive/Interchange File Format" 
have certain restrictions that have
been carried over from historical usage.
For example, there are restrictions on the length of pathnames stored in
the archive.
.PP
When getting an "ls -l" style listing on
.I tar
format archives, link counts are listed as zero since the 
.I ustar
archive format does not keep link count information.
.PP
On 16 bit architectures, the largest buffer size is 32k-1.
This is due, in part, to using integers in the buffer allocation schemes,
however, on many of these machines, it is not possible to allocate blocks
of memory larger than 32k.
.SH COPYRIGHT
Copyright (c) 1989 Mark H. Colburn.  
.br
All rights reserved.
.PP
Redistribution and use in source and binary forms are permitted
provided that the above copyright notice is duplicated in all such 
forms and that any documentation, advertising materials, and other 
materials related to such distribution and use acknowledge that the 
software was developed by Mark H. Colburn.
.PP
THE SOFTWARE IS PROVIDED ``AS IS'' AND WITHOUT ANY EXPRESS OR
IMPLIED WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED
WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
.SH AUTHOR
Mark H. Colburn
.br
Minnetech Consulting, Inc.
.br
3232 Aquila Lane
.br
St. Louis Park, MN 55426
.sp
mark@Minnetech.MN.ORG
