.\" $Id: tar.man,v 2.0.0.0 89/10/30 07:31:53 mark Exp Locker: mark $
.TH TAR 1 "Minnetech Consulting, Inc." ""
.SH NAME
tar \- process tape archives
.SH SYNOPSIS
.B tar
.BR \-c [ bfvw ]
.I device
.I block
.I filename...
.br
.B tar
.BR \-r [ bvw ]
.I device
.I block
.RI [ filename... ]
.br
.B tar
.BR \-t [ fv ]
.I device
.br
.B tar
.BR \-u [ bvw ]
.I device
.I block
.br
.B tar
.BR \-x [ flmovw ]
.I device
.RI [ filename... ]
.SH DESCRIPTION
.I Tar
reads and writes archive files which conform to the
.B "Archive/Interchange File Format"
specified in
.IR "IEEE Std. 1003.1-1988" .
.SS Options
The following options are available:
.TP 1i
.B \-c
Creates a new archive; writing begins at the beginning of the archive,
instead of after the last file.
.TP 1i
.B \-r
Writes names files to the end of the archive.
.TP 1i
.B \-t
Lists the names of all of the files in the archive.
.TP 1i
.B \-u
Causes named files to be
added to the archive if they are not already there, or have been
modified since last written into the archive.
This implies the
.B \-r
option.
.TP 1i
.B \-x
Extracts named files
from the archive.
If a named file matches a directory whose contents had been written onto
the archive, that directory is recursively extracted.
If a named file in the archive does not exist on the system, the file is
create with the same mode as the one in the archive, except that the
set-user-id and get-group-id modes are not set unless the user has
appropriate privileges.
.PP
If the files exist, their modes are not changed except as described above.
The owner, group and modification time are restored if possible.
If no
.I filename
argument is given, the entire contents of the archive is extracted.
Note that if several files with the same name are in the archive,
the last one will overwrite all earlier ones.
.TP 1i
.B \-b
Causes
.I tar
to use the next argument on the command line as the blocking factor for
tape records.
The default is 1; the maximum is 20.
This option should only be used with raw magnetic tape archives.
Normally, the block size is determined automatically when reading tapes.
.TP 1i
.B \-f
Causes
.I tar
to use the next argument on the command line as the name of the archive
instead of the default, which is usually a tape drive.
If
.B -
is specified as a filename
.I tar
writes to the standard output or reads from the standard input, whichever
is appropriate for the options given.
Thus,
.I tar
can be used as the head or tail of a pipeline.
.TP 1i
.B \-l
Tells
.I tar
to report if it cannot resolve all of the links to the files being
archived.
If
.B \-l
is not specified, no error messages are written to the standard output.
This modifier is only valid with the
.BR \-c ,
.B \-r
and
.BR \-u
options.
.TP 1i
.B \-m
Tells
.I tar
not to restore the modification times.
The modification time of the file will be the time of extraction.
This modifier is invalid with th
.B \-t
option.
.TP 1i
.B \-o
Causes extracted files to take on the user and group identifier of the user
running the program rather than those on the archive.
This modifier is only valid with the
.B \-x
option.
.TP 1i
.B \-v
Causes
.I tar
to operate verbosely.  Usually,
.I tar
does its work silently, but
the
.B v
modifier causes it to print the name of each file it processes,
preceded by the option letter.
With the
.B \-t
option,
.B v
gives more information about the archive entries than just the name.
.TP 1i
.B \-w
Causes
.I tar
to print the action to be taken, followed by the name of the file, and then
wait for the user's confirmation.
If a word beginning with
.B y
is given, the action is performed.
Any other input means "no".
This modifier is invalid with the
.B \-t
option.
.SH FILES
.TP 1i
/dev/tty
used to prompt the user for information when the
.BR \-i " or " \-y
options are specified.
.SH "SEE ALSO"
cpio(1), dd(1), find(1), pax(1), cpio(5), tar(5)
.SH COPYRIGHT
Copyright (c) 1989 Mark H. Colburn.  
.br
All rights reserved.
.PP
Redistribution and use in source and binary forms are permitted
provided that the above copyright notice is duplicated in all such 
forms and that any documentation, advertising materials, and other 
materials related to such distribution and use acknowledge that the 
software was developed by Mark H. Colburn.
.PP
THE SOFTWARE IS PROVIDED ``AS IS'' AND WITHOUT ANY EXPRESS OR
IMPLIED WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED
WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
.SH AUTHOR
Mark H. Colburn
.br
Minnetech Consulting, Inc.
.br
3232 Aquila Lane
.br
St. Louis Park, MN 55426
.sp
mark@Minnetech.MN.ORG
