/* REXX program to install ZiPMe */

Call rxfuncadd sysloadfuncs, rexxutil, sysloadfuncs
Call sysloadfuncs

Call SysCls

say "                       Welcome to the ZiPMe installer."
say ""
say "This program will do the following:"
say ""
say "It will create a desktop folder with a program object for ZiPMe, a template"
say "for ZIP files, and an object for the Readme file. The ZiPMe Object will be"
say "associated to all *.ZIP files, so you can double-click on a ZIP file to"
say "automatically start ZiPMe and load this ZIP file. With the a template, which"
say "you can move into your Templates folder, you can create new ZIP files in a"
say "document-centric way."
say ""

say "Should I continue? (Y/N)"
PARSE PULL reply
if reply = "N" | reply = "n" then exit

curdir = Directory()

Error = 0

if SysCreateObject("WPFolder", "ZiPMe", "<WP_DESKTOP>", "OBJECTID=<ZIPME_FOLDER>") then
  say "ZiPMe Folder created ..."
else do
  say "Could not create ZiPMe folder!"
  Error = 1
end

if SysCreateObject("WPProgram", "ZiPMe", "<ZIPME_FOLDER>", "EXENAME="curdir"\ZIPME.EXE;STARTUPDIR="curdir";ASSOCFILTER=*.ZIP") then
  say "ZiPMe Program Object created ..."
else do
  say "Could not create ZiPMe Program Object!"
  Error = 1
end

if SysCreateObject("WPProgram", "Readme", "<ZIPME_FOLDER>", "EXENAME=e.exe;PARAMETERS="curdir"\Readme") then
  say "Readme Object created ..."
else do
  say "Could not create Readme Object!"
  Error = 1
end

if SysCopyObject(""curdir"\ZIP file.ZIP", "<ZIPME_FOLDER>") then
  say "ZiPMe Template created ..."
else do
  say "Could not create ZiPMe Template!"
  Error = 1
end

say ""
if Error then do
say "Some or all of the objects could not be automatically installed!"
say "If you haven't installed the EMX runtime package yet, copy the file emx.dll,"
say "which is distibuted with ZiPMe, into the directory where ZiPMe is or into a"
say "directory that is specified in the LIBPATH statement in your config.sys."
say "Then start ZiPMe and follow the manual install instructions in the online help."
end  
else do
say "All objects have been installed."
say "If you haven't installed the EMX runtime package yet, copy the file emx.dll,"
say "which is distibuted with ZiPMe, into the directory where ZiPMe is or into a"
say "directory that is specified in the LIBPATH statement in your config.sys."
say "Check to be sure that zip.exe and unzip.exe are in a directory that is"
say "specified in the PATH statement of your config.sys, or copy them in the"
say "directory where ZiPMe is."
end
