/*
 * Decompiled with CFR 0.152.
 */
package ctag.pilot;

import ctag.pilot.PilotDate;
import ctag.types.ByteBuffer;

public class CardInfo {
    protected byte cardNo = 0;
    protected short version = 0;
    protected PilotDate creationTime = new PilotDate();
    protected int romSize = 0;
    protected int ramSize = 0;
    protected int ramFree = 0;
    protected String name = new String();
    protected String manufacturer = new String();
    protected byte more = 0;

    public void fromBuffer(ByteBuffer byteBuffer) {
        this.more = 0;
        this.cardNo = byteBuffer.getByte(5);
        this.version = byteBuffer.getShort(6);
        this.creationTime.fromBuffer(byteBuffer, 8);
        this.romSize = byteBuffer.getInt(16);
        this.ramSize = byteBuffer.getInt(20);
        this.ramFree = byteBuffer.getInt(24);
        byte by = byteBuffer.getByte(28);
        this.name = new String(byteBuffer.getData(30, (int)by));
        byte by2 = byteBuffer.getByte(29);
        this.manufacturer = new String(byteBuffer.getData(30 + by, (int)by2));
    }

    public String toString() {
        return "[CardInfo;" + this.creationTime + ";" + this.name + ";" + this.manufacturer + ";" + this.cardNo + ";" + this.version + ";" + this.romSize + ";" + this.ramSize + ";" + this.ramFree + "]";
    }
}

