/*
 * Decompiled with CFR 0.152.
 */
package ctag.pilot;

import ctag.types.ByteBuffer;

public class CategoryAppInfo {
    public boolean[] renamed = new boolean[16];
    public String[] names = new String[16];
    public byte[] IDs = new byte[16];
    public byte lastUniqueID;

    public CategoryAppInfo() {
        int n = 0;
        while (n < 16) {
            this.names[n] = "";
            this.renamed[n] = false;
            this.IDs[n] = 0;
            ++n;
        }
    }

    public int fromBuffer(ByteBuffer byteBuffer) {
        int n = 2;
        short s = byteBuffer.getShort(n);
        int n2 = 0;
        while (n2 < 16) {
            this.renamed[n2] = (s & 1 << n2) == 1 << n2;
            ++n2;
        }
        n += 2;
        n2 = 0;
        while (n2 < 16) {
            this.names[n2] = byteBuffer.getString(n, 16);
            n += 16;
            ++n2;
        }
        this.IDs = byteBuffer.getData(n, 16);
        this.lastUniqueID = byteBuffer.getByte(n += 16);
        return n += 4;
    }

    public int getLength() {
        return 278;
    }

    public ByteBuffer toBuffer() {
        ByteBuffer byteBuffer = new ByteBuffer(1);
        short s = 0;
        int n = 0;
        while (n < 16) {
            if (this.renamed[n]) {
                s = (short)(s | 1 << n);
            }
            ++n;
        }
        byteBuffer.appendShort(s);
        int n2 = 0;
        while (n2 < 16) {
            byteBuffer.appendString(this.names[n2], 16);
            ++n2;
        }
        byteBuffer.appendData(this.IDs);
        byteBuffer.appendByte(this.lastUniqueID);
        byteBuffer.appendTreble(0);
        return byteBuffer;
    }

    public String toString() {
        return "[CategoryAppInfo: " + this.names[0] + " ; " + this.names[1] + " ; " + this.names[2] + " ; " + this.names[3] + " ; " + this.lastUniqueID + "]";
    }
}

