/*
 * Decompiled with CFR 0.152.
 */
package ctag.pilot;

import ctag.pilot.PilotDate;
import ctag.types.ByteBuffer;

public class DBInfo {
    public byte more = 0;
    public short flags = 0;
    public byte miscFlags = 0;
    public int type = 0;
    public int creatorID = 0;
    public short version = 0;
    public int modnum = 0;
    public PilotDate createDate = new PilotDate();
    public PilotDate modifyDate = new PilotDate();
    public PilotDate backupDate = new PilotDate();
    public short index = 0;
    public String name = new String();
    public static final int dlpDBFlagResource = 1;
    public static final int dlpDBFlagReadOnly = 2;
    public static final int dlpDBFlagAppInfoDirty = 4;
    public static final int dlpDBFlagBackup = 8;
    public static final int dlpDBFlagOpen = 32768;
    public static final int dlpDBFlagNewer = 16;
    public static final int dlpDBFlagReset = 32;
    public static final int dlpDBMiscFlagExcludeFromSync = 128;

    public void fromBuffer(ByteBuffer byteBuffer) {
        this.more = byteBuffer.getByte(2);
        this.miscFlags = byteBuffer.getByte(5);
        this.flags = byteBuffer.getShort(6);
        this.type = byteBuffer.getInt(8);
        this.creatorID = byteBuffer.getInt(12);
        this.version = byteBuffer.getShort(16);
        this.modnum = byteBuffer.getInt(18);
        this.createDate.fromBuffer(byteBuffer, 22);
        this.modifyDate.fromBuffer(byteBuffer, 30);
        this.backupDate.fromBuffer(byteBuffer, 38);
        this.index = byteBuffer.getShort(46);
        this.name = byteBuffer.getString(48);
    }

    public String getType() {
        byte[] byArray = new byte[]{(byte)(this.type >> 56 & 0xFF), (byte)(this.type >> 48 & 0xFF), (byte)(this.type >> 40 & 0xFF), (byte)(this.type >> 32 & 0xFF), (byte)(this.type >> 24 & 0xFF), (byte)(this.type >> 16 & 0xFF), (byte)(this.type >> 8 & 0xFF), (byte)(this.type & 0xFF)};
        return new String(byArray);
    }

    public boolean isAppInfoDirty() {
        return (this.flags & 4) != 0;
    }

    public boolean isBackup() {
        return (this.flags & 8) != 0;
    }

    public boolean isExcludeFromSync() {
        return (this.flags & 0x80) == 128;
    }

    public boolean isNewer() {
        return (this.flags & 0x10) != 0;
    }

    public boolean isOpen() {
        return (this.flags & 0x8000) != 0;
    }

    public boolean isReadOnly() {
        return (this.flags & 2) != 0;
    }

    public boolean isReset() {
        return (this.flags & 0x20) != 0;
    }

    public boolean isResource() {
        return (this.flags & 1) == 1;
    }

    public String toString() {
        return "[DBInfo;" + this.name + ";" + this.type + ";" + this.creatorID + ";" + this.modnum + ";" + this.index + ";" + this.createDate + ";" + this.modifyDate + ";" + this.backupDate + ";" + "]";
    }
}

