/*
 * Decompiled with CFR 0.152.
 */
package ctag.pilot;

import ctag.pilot.PilotDate;
import ctag.pilot.Record;
import ctag.types.ByteBuffer;

public class DateBookRecord
extends Record {
    public PilotDate begin = new PilotDate();
    public PilotDate end = new PilotDate();
    public PilotDate repeatEnd = new PilotDate();
    public boolean isUntimed = false;
    public String description = "";
    public String note = "";
    public int duration;
    public boolean isAlarmed = false;
    public int alarmAdvTime;
    public int repeatType;
    public boolean repeatForever = false;
    public int repeatFrequency;
    public int repeatDay;
    public boolean[] repeatDays = new boolean[7];
    public int repeatWeekstart;
    public int exceptions;
    public PilotDate[] exceptDates = new PilotDate[0];
    public static final int repeatNone = 0;
    public static final int repeatDaily = 1;
    public static final int repeatWeekly = 2;
    public static final int repeatMonthlyByDay = 3;
    public static final int repeatMonthlyByDate = 4;
    public static final int repeatYearly = 5;

    public DateBookRecord(Record record, boolean bl) {
        super(record);
        if (bl) {
            int n;
            this.begin.fromShort(this.buffer.getShort(4));
            this.end.fromShort(this.buffer.getShort(4));
            if ((this.buffer.getShort(0) & 0xFFFF) == 65535) {
                this.isUntimed = true;
            } else {
                this.isUntimed = false;
                this.begin.hour = this.buffer.getByte(0);
                this.begin.minute = this.buffer.getByte(1);
                this.end.hour = this.buffer.getByte(2);
                this.end.minute = this.buffer.getByte(3);
            }
            byte by = this.buffer.getByte(6);
            int n2 = 8;
            if ((by & 0x40) != 0) {
                this.isAlarmed = true;
                this.alarmAdvTime = this.buffer.getByte(n2);
                this.duration = this.buffer.getByte(++n2);
                ++n2;
            } else {
                this.isAlarmed = false;
                this.alarmAdvTime = 0;
                this.duration = 0;
            }
            if ((by & 0x20) != 0) {
                this.repeatType = this.buffer.getByte(n2);
                if ((this.buffer.getShort(n2 += 2) & 0xFFFF) == 65535) {
                    this.repeatForever = true;
                } else {
                    this.repeatEnd.fromShort(this.buffer.getShort(n2));
                    this.repeatForever = false;
                }
                this.repeatFrequency = this.buffer.getByte(n2 += 2);
                byte by2 = this.buffer.getByte(++n2);
                ++n2;
                this.repeatDay = 0;
                n = 0;
                while (n < 7) {
                    this.repeatDays[n] = false;
                    ++n;
                }
                if (this.repeatType == 3) {
                    this.repeatDay = by2;
                } else if (this.repeatType == 2) {
                    n = 0;
                    while (n < 7) {
                        this.repeatDays[n] = (by2 & 1 << n) != 0;
                        ++n;
                    }
                }
                this.repeatWeekstart = this.buffer.getByte(n2);
                ++n2;
                ++n2;
            } else {
                this.repeatType = 0;
                this.repeatForever = true;
                this.duration = 0;
                this.repeatDay = 0;
                n = 0;
                while (n < 7) {
                    this.repeatDays[n] = false;
                    ++n;
                }
                this.repeatWeekstart = 0;
            }
            if ((by & 8) != 0) {
                this.exceptions = this.buffer.getShort(n2);
                n2 += 2;
                this.exceptDates = new PilotDate[this.exceptions];
                n = 0;
                while (n < this.exceptions) {
                    this.exceptDates[n] = new PilotDate();
                    this.exceptDates[n].fromShort(this.buffer.getShort(n2));
                    ++n;
                    n2 += 2;
                }
            } else {
                this.exceptions = 0;
                this.exceptDates = new PilotDate[0];
            }
            if ((by & 4) != 0) {
                this.description = this.buffer.getString(n2);
                n2 += this.description.length() + 1;
            } else {
                this.description = "";
            }
            if ((by & 0x10) != 0) {
                this.note = this.buffer.getString(n2);
                n2 += this.note.length() + 1;
                return;
            }
            this.note = "";
        }
    }

    public void fromBuffer(ByteBuffer byteBuffer) {
        super.fromBuffer(byteBuffer);
    }

    public ByteBuffer toBuffer() {
        ByteBuffer byteBuffer = new ByteBuffer(1);
        return super.toBuffer(byteBuffer);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("[DateBookRecord: ");
        stringBuffer.append("]");
        return stringBuffer.toString();
    }
}

