/*
 * Decompiled with CFR 0.152.
 */
package ctag.pilot;

import ctag.pilot.PilotDate;
import ctag.pilot.Record;
import ctag.types.ByteBuffer;

public class MailRecord
extends Record {
    public PilotDate date = new PilotDate();
    public int flags;
    public String subject;
    public String from;
    public String to;
    public String cc;
    public String bcc;
    public String replyTo;
    public String sentTo;
    public String body;

    public MailRecord(Record record, boolean bl) {
        super(record);
        if (bl) {
            this.date.fromShort(this.buffer.getShort(0));
            this.date.hour = this.buffer.getByte(2);
            this.date.minute = this.buffer.getByte(3);
            this.flags = this.buffer.getByte(4);
            int n = 6;
            int n2 = this.buffer.getLength() - 6;
            if (this.buffer.getByte(n) != 0) {
                this.subject = this.buffer.getString(n);
                n += this.subject.length();
                n2 -= this.subject.length();
            }
            --n2;
            if (this.buffer.getByte(++n) != 0) {
                this.from = this.buffer.getString(n);
                n += this.from.length();
                n2 -= this.from.length();
            }
            --n2;
            if (this.buffer.getByte(++n) != 0) {
                this.to = this.buffer.getString(n);
                n += this.to.length();
                n2 -= this.to.length();
            }
            --n2;
            if (this.buffer.getByte(++n) != 0) {
                this.cc = this.buffer.getString(n);
                n += this.cc.length();
                n2 -= this.cc.length();
            }
            --n2;
            if (this.buffer.getByte(++n) != 0) {
                this.bcc = this.buffer.getString(n);
                n += this.bcc.length();
                n2 -= this.bcc.length();
            }
            --n2;
            if (this.buffer.getByte(++n) != 0) {
                this.replyTo = this.buffer.getString(n);
                n += this.replyTo.length();
                n2 -= this.replyTo.length();
            }
            --n2;
            if (this.buffer.getByte(++n) != 0) {
                this.sentTo = this.buffer.getString(n);
                n += this.sentTo.length();
                n2 -= this.sentTo.length();
            }
            --n2;
            if (this.buffer.getByte(++n) != 0) {
                this.body = this.buffer.getString(n);
                n += this.body.length();
                n2 -= this.body.length();
            }
            ++n;
            --n2;
        }
    }

    public MailRecord(ByteBuffer byteBuffer) {
        super(byteBuffer);
    }

    public int getAddressing() {
        return this.flags & 3;
    }

    public int getPriority() {
        return (this.flags & 0xC) >> 2;
    }

    public boolean isConfirmDelivery() {
        return (this.flags & 0x10) != 0;
    }

    public boolean isConfirmRead() {
        return (this.flags & 0x20) != 0;
    }

    public boolean isRead() {
        return (this.flags & 0x80) != 0;
    }

    public boolean isSignature() {
        return (this.flags & 0x40) != 0;
    }

    public void setAddressing(int n) {
        this.flags |= n & 3;
    }

    public void setConfirmDelivery(boolean bl) {
        if (bl) {
            this.flags |= 0x10;
            return;
        }
        this.flags &= 0xFFFFFFEF;
    }

    public void setConfirmRead(boolean bl) {
        if (bl) {
            this.flags |= 0x20;
            return;
        }
        this.flags &= 0xFFFFFFDF;
    }

    public void setPriority(int n) {
        this.flags |= (n & 3) << 2;
    }

    public void setRead(boolean bl) {
        if (bl) {
            this.flags |= 0x80;
            return;
        }
        this.flags &= 0xFFFFFF7F;
    }

    public void setSignature(boolean bl) {
        if (bl) {
            this.flags |= 0x40;
            return;
        }
        this.flags &= 0xFFFFFFBF;
    }

    public ByteBuffer toBuffer() {
        ByteBuffer byteBuffer = new ByteBuffer(1);
        byteBuffer.appendShort(this.date.toShort()).appendByte(this.date.hour).appendByte(this.date.minute).appendByte(this.flags).appendByte(0).appendString(this.subject).appendString(this.from).appendString(this.to).appendString(this.cc).appendString(this.bcc).appendString(this.replyTo).appendString(this.sentTo).appendString(this.body);
        return super.toBuffer(byteBuffer);
    }
}

